"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.actionsCamel = exports.actions = exports.action_params = exports.action_id = exports.action_group = exports.action_action_type_id = exports.action = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _saved_object_attributes = require("../saved_object_attributes");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/* eslint-disable @typescript-eslint/naming-convention */

/**
 * Params is an "object", since it is a type of AlertActionParams which is action templates.
 * @see x-pack/plugins/alerting/common/alert.ts
 */
const action_group = exports.action_group = t.string;
const action_id = exports.action_id = t.string;
const action_action_type_id = exports.action_action_type_id = t.string;
const action_params = exports.action_params = _saved_object_attributes.saved_object_attributes;
const action = exports.action = t.exact(t.type({
  group: action_group,
  id: action_id,
  action_type_id: action_action_type_id,
  params: action_params
}));
const actions = exports.actions = t.array(action);
const actionsCamel = exports.actionsCamel = t.array(t.exact(t.type({
  group: action_group,
  id: action_id,
  actionTypeId: action_action_type_id,
  params: action_params
})));