import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _isNativeReflectConstruct from "@babel/runtime/helpers/isNativeReflectConstruct";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import * as PropTypes from 'prop-types';
import * as React from 'react';
import * as i18n from '../core';
import { isPseudoLocale, translateUsingPseudoLocale } from '../core/pseudo_locale';

/**
 * To translate label that includes nested `FormattedMessage` instances React Intl
 * replaces them with special placeholders (@__uid__@ELEMENT-uid-counter@__uid__@)
 * and maps them back with nested translations after `formatMessage` processes
 * original string, so we shouldn't modify these special placeholders with pseudo
 * translations otherwise React Intl won't be able to properly replace placeholders.
 * It's implementation detail of the React Intl, but since pseudo localization is dev
 * only feature we should be fine here.
 * @param message
 */
function translateFormattedMessageUsingPseudoLocale(message) {
  var formattedMessageDelimiter = message.match(/@__.{10}__@/);
  if (formattedMessageDelimiter !== null) {
    return message.split(formattedMessageDelimiter[0]).map(function (part) {
      return part.startsWith('ELEMENT-') ? part : translateUsingPseudoLocale(part);
    }).join(formattedMessageDelimiter[0]);
  }
  return translateUsingPseudoLocale(message);
}

/**
 * If the locale is our pseudo locale (e.g. en-xa), we override the
 * intl.formatMessage function to display scrambled characters. We are
 * overriding the context rather than using injectI18n, because the
 * latter creates a new React component, which causes React diffs to
 * be inefficient in some cases, and can cause React hooks to lose
 * their state.
 */
export var PseudoLocaleWrapper = /*#__PURE__*/function (_React$PureComponent) {
  _inherits(PseudoLocaleWrapper, _React$PureComponent);
  function PseudoLocaleWrapper(props, context) {
    var _this;
    _classCallCheck(this, PseudoLocaleWrapper);
    _this = _callSuper(this, PseudoLocaleWrapper, [props, context]);
    if (isPseudoLocale(i18n.getLocale())) {
      var formatMessage = context.intl.formatMessage;
      context.intl.formatMessage = function () {
        return translateFormattedMessageUsingPseudoLocale(formatMessage.apply(void 0, arguments));
      };
    }
    return _this;
  }
  _createClass(PseudoLocaleWrapper, [{
    key: "render",
    value: function render() {
      return this.props.children;
    }
  }]);
  return PseudoLocaleWrapper;
}(React.PureComponent);
_defineProperty(PseudoLocaleWrapper, "propTypes", {
  children: PropTypes.element.isRequired
});
_defineProperty(PseudoLocaleWrapper, "contextTypes", {
  intl: PropTypes.object.isRequired
});