import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectSpread from "@babel/runtime/helpers/objectSpread2";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { get, omit, pick } from 'lodash';
import { getConvertedValueForField } from '../filters';

/** @internal */

function isDeprecatedMatchPhraseFilter(filter) {
  var _ref, _filter$query;
  // @ts-ignore
  var fieldName = Object.keys((_ref = filter.match || ((_filter$query = filter.query) === null || _filter$query === void 0 ? void 0 : _filter$query.match)) !== null && _ref !== void 0 ? _ref : {})[0];
  return Boolean(fieldName && (get(filter, ['query', 'match', fieldName, 'type']) === 'phrase' || get(filter, ['match', fieldName, 'type']) === 'phrase'));
}

/** @internal */
export function migrateFilter(filter, indexPattern) {
  if (isDeprecatedMatchPhraseFilter(filter)) {
    // @ts-ignore
    var match = filter.match || filter.query.match;
    var fieldName = Object.keys(match)[0];
    var params = get(match, [fieldName]);
    var query = params.query;
    if (indexPattern) {
      var _field = indexPattern.fields.find(function (f) {
        return f.name === fieldName;
      });
      if (_field) {
        query = getConvertedValueForField(_field, params.query);
      }
    }
    return {
      meta: filter.meta,
      $state: filter.$state,
      query: {
        match_phrase: _defineProperty({}, fieldName, omit(_objectSpread(_objectSpread({}, params), {}, {
          query: query
        }), 'type'))
      }
    };
  }
  if (!filter.query) {
    filter.query = {};
  } else {
    // handle the case where .query already exists and filter has other top level keys on there
    filter = pick(filter, ['meta', 'query', '$state']);
  }

  // @ts-ignore
  if (filter.exists) {
    // @ts-ignore
    filter.query.exists = filter.exists;
    // @ts-ignore
    delete filter.exists;
  }

  // @ts-ignore
  if (filter.range) {
    // @ts-ignore
    filter.query.range = filter.range;
    // @ts-ignore
    delete filter.range;
  }

  // @ts-ignore
  if (filter.match_all) {
    // @ts-ignore
    filter.query.match_all = filter.match_all;
    // @ts-ignore
    delete filter.match_all;
  }

  // move all other keys under query
  Object.keys(filter).forEach(function (key) {
    if (key === 'meta' || key === 'query' || key === '$state') {
      return;
    }
    // @ts-ignore
    filter.query[key] = filter[key];
    // @ts-ignore
    delete filter[key];
  });
  return filter;
}