"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SchemaTypeError = void 0;
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class SchemaTypeError extends _.SchemaError {
  constructor(error, path) {
    super(typeof error === 'string' ? error : error.message);

    // Set the prototype explicitly, see:
    // https://github.com/Microsoft/TypeScript/wiki/Breaking-Changes#extending-built-ins-like-error-array-and-map-may-no-longer-work
    this.path = path;
    Object.setPrototypeOf(this, SchemaTypeError.prototype);
  }
}
exports.SchemaTypeError = SchemaTypeError;