import _asyncToGenerator from "@babel/runtime/helpers/asyncToGenerator";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _regeneratorRuntime from "@babel/runtime/regenerator";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { wrapArray } from './util';
import { createUiCounterMetric, trackUsageAgent } from './metrics';
import { ReportStorageManager } from './storage';
import { ReportManager } from './report';
export var Reporter = /*#__PURE__*/function () {
  function Reporter(config) {
    var _this = this;
    _classCallCheck(this, Reporter);
    _defineProperty(this, "checkInterval", void 0);
    _defineProperty(this, "interval", void 0);
    _defineProperty(this, "http", void 0);
    _defineProperty(this, "reportManager", void 0);
    _defineProperty(this, "storageManager", void 0);
    _defineProperty(this, "debug", void 0);
    _defineProperty(this, "retryCount", 0);
    _defineProperty(this, "maxRetries", 3);
    _defineProperty(this, "start", function () {
      if (!_this.interval) {
        _this.interval = setTimeout(function () {
          _this.interval = undefined;
          _this.sendReports();
        }, _this.checkInterval);
      }
    });
    _defineProperty(this, "reportUiCounter", function (appName, type, eventNames, count) {
      var metrics = wrapArray(eventNames).map(function (eventName) {
        _this.log("".concat(type, " Metric -> (").concat(appName, ":").concat(eventName, "):"));
        var report = createUiCounterMetric({
          type: type,
          appName: appName,
          eventName: eventName,
          count: count
        });
        _this.log(report);
        return report;
      });
      _this.saveToReport(metrics);
    });
    _defineProperty(this, "reportUserAgent", function (appName) {
      _this.log("Reporting user-agent.");
      var report = trackUsageAgent(appName);
      _this.saveToReport([report]);
    });
    _defineProperty(this, "sendReports", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
      var versionMismatch;
      return _regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            if (_this.reportManager.isReportEmpty()) {
              _context.next = 13;
              break;
            }
            _context.prev = 1;
            _context.next = 4;
            return _this.http(_this.reportManager.report);
          case 4:
            _this.flushReport();
            _context.next = 13;
            break;
          case 7:
            _context.prev = 7;
            _context.t0 = _context["catch"](1);
            _this.log("Error Sending Metrics Report ".concat(_context.t0));
            _this.retryCount = _this.retryCount + 1;
            versionMismatch = _this.reportManager.report.reportVersion !== ReportManager.REPORT_VERSION;
            if (versionMismatch || _this.retryCount > _this.maxRetries) {
              _this.flushReport();
            }
          case 13:
            _this.start();
          case 14:
          case "end":
            return _context.stop();
        }
      }, _callee, null, [[1, 7]]);
    })));
    var http = config.http,
      storage = config.storage,
      debug = config.debug,
      _config$checkInterval = config.checkInterval,
      checkInterval = _config$checkInterval === void 0 ? 90000 : _config$checkInterval,
      _config$storageKey = config.storageKey,
      storageKey = _config$storageKey === void 0 ? 'analytics' : _config$storageKey;
    this.http = http;
    this.checkInterval = checkInterval;
    this.storageManager = new ReportStorageManager(storageKey, storage);
    var storedReport = this.storageManager.get();
    this.reportManager = new ReportManager(storedReport);
    this.debug = !!debug;
  }
  _createClass(Reporter, [{
    key: "saveToReport",
    value: function saveToReport(newMetrics) {
      this.reportManager.assignReports(newMetrics);
      this.storageManager.store(this.reportManager.report);
    }
  }, {
    key: "flushReport",
    value: function flushReport() {
      this.retryCount = 0;
      this.reportManager.clearReport();
      this.storageManager.store(this.reportManager.report);
    }
  }, {
    key: "log",
    value: function log(message) {
      if (this.debug) {
        // eslint-disable-next-line
        console.debug(message);
      }
    }
  }, {
    key: "reportApplicationUsage",
    value: function reportApplicationUsage(appUsageReport) {
      this.log("Reporting application usage for ".concat(appUsageReport.appId, ", ").concat(appUsageReport.viewId));
      this.saveToReport([appUsageReport]);
    }
  }]);
  return Reporter;
}();