"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkOrDefaultToolBarDisplayOptions = checkOrDefaultToolBarDisplayOptions;
exports.EuiDataGridToolbar = void 0;

var _react = _interopRequireDefault(require("react"));

var _button = require("../../button");

var _i18n = require("../../i18n");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

// Used to simplify some sizing logic which is difficult to account for in tests
var IS_JEST_ENVIRONMENT = global.hasOwnProperty('_isJest'); // When below this number the grid only shows the full screen button

var MINIMUM_WIDTH_FOR_GRID_CONTROLS = 479; // When data grid is full screen, we add a class to the body to remove the extra scrollbar

var GRID_IS_FULLSCREEN_CLASSNAME = 'euiDataGrid__restrictBody'; // Typeguards to see if toolbarVisibility has a certain boolean property assigned
// If not, just set it to true and assume it's OK to show

function objectHasKey(object, key) {
  return object.hasOwnProperty(key);
}

function checkOrDefaultToolBarDisplayOptions(arg, option) {
  if (arg === undefined) {
    return true;
  } else if (typeof arg === 'boolean') {
    return arg;
  } else if (objectHasKey(arg, option)) {
    return arg[option];
  } else {
    return true;
  }
}

var EuiDataGridToolbar = function EuiDataGridToolbar(_ref) {
  var gridWidth = _ref.gridWidth,
      _ref$minSizeForContro = _ref.minSizeForControls,
      minSizeForControls = _ref$minSizeForContro === void 0 ? MINIMUM_WIDTH_FOR_GRID_CONTROLS : _ref$minSizeForContro,
      toolbarVisibility = _ref.toolbarVisibility,
      isFullScreen = _ref.isFullScreen,
      controlBtnClasses = _ref.controlBtnClasses,
      styleSelector = _ref.styleSelector,
      columnSelector = _ref.columnSelector,
      columnSorting = _ref.columnSorting,
      setRef = _ref.setRef,
      setIsFullScreen = _ref.setIsFullScreen;

  var _useEuiI18n = (0, _i18n.useEuiI18n)(['euiDataGridToolbar.fullScreenButton', 'euiDataGridToolbar.fullScreenButtonActive'], ['Full screen', 'Exit full screen']),
      _useEuiI18n2 = _slicedToArray(_useEuiI18n, 2),
      fullScreenButton = _useEuiI18n2[0],
      fullScreenButtonActive = _useEuiI18n2[1];

  var hasRoomForGridControls = IS_JEST_ENVIRONMENT ? true : gridWidth > minSizeForControls || isFullScreen; // need to safely access those Web APIs

  if (typeof document !== 'undefined') {
    // When data grid is full screen, we add a class to the body to remove the extra scrollbar
    document.body.classList.toggle(GRID_IS_FULLSCREEN_CLASSNAME, isFullScreen);
  }

  var fullScreenSelector = /*#__PURE__*/_react.default.createElement(_button.EuiButtonEmpty, {
    size: "xs",
    iconType: "fullScreen",
    color: "text",
    className: controlBtnClasses,
    "data-test-subj": "dataGridFullScreenButton",
    onClick: function onClick() {
      return setIsFullScreen(!isFullScreen);
    }
  }, isFullScreen ? fullScreenButtonActive : fullScreenButton);

  return /*#__PURE__*/_react.default.createElement("div", {
    ref: setRef,
    className: "euiDataGrid__controls",
    "data-test-sub": "dataGridControls"
  }, hasRoomForGridControls && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, checkOrDefaultToolBarDisplayOptions(toolbarVisibility, 'additionalControls') && typeof toolbarVisibility !== 'boolean' ? toolbarVisibility.additionalControls : null, checkOrDefaultToolBarDisplayOptions(toolbarVisibility, 'showColumnSelector') ? columnSelector : null, checkOrDefaultToolBarDisplayOptions(toolbarVisibility, 'showStyleSelector') ? styleSelector : null, checkOrDefaultToolBarDisplayOptions(toolbarVisibility, 'showSortSelector') ? columnSorting : null), checkOrDefaultToolBarDisplayOptions(toolbarVisibility, 'showFullScreenSelector') ? fullScreenSelector : null);
};

exports.EuiDataGridToolbar = EuiDataGridToolbar;