function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

import { ORIGIN } from './origin';
import { toAbsoluteUrl } from './utils';
export var AbstractEmsService = /*#__PURE__*/function () {
  function AbstractEmsService(config, emsClient, proxyPath) {
    var _this = this;
    _classCallCheck(this, AbstractEmsService);
    _defineProperty(this, "_emsClient", void 0);
    _defineProperty(this, "_config", void 0);
    _defineProperty(this, "_proxyPath", void 0);
    /**
     * Checks if url is absolute. If not, prepend the basePath.
     */
    _defineProperty(this, "_getAbsoluteUrl", function (url) {
      if (/^https?:\/\//.test(url)) {
        return url;
      } else {
        return toAbsoluteUrl(_this.getApiUrl(), url);
      }
    });
    this._config = config;
    this._emsClient = emsClient;
    this._proxyPath = proxyPath;
  }
  _createClass(AbstractEmsService, [{
    key: "getAttributions",
    value: function getAttributions() {
      var _this2 = this;
      return this._config.attribution.map(function (attribution) {
        var url = _this2._emsClient.getValueInLanguage(attribution.url);
        var label = _this2._emsClient.getValueInLanguage(attribution.label);
        return {
          url: url,
          label: label
        };
      });
    }
  }, {
    key: "getMarkdownAttribution",
    value: function getMarkdownAttribution() {
      var _this3 = this;
      var attributions = this._config.attribution.map(function (attribution) {
        var url = _this3._emsClient.getValueInLanguage(attribution.url);
        var label = _this3._emsClient.getValueInLanguage(attribution.label);
        return "[".concat(label, "](").concat(url, ")");
      });
      return attributions.join('|');
    }
  }, {
    key: "getOrigin",
    value: function getOrigin() {
      return ORIGIN.EMS;
    }
  }]);
  return AbstractEmsService;
}();