"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AbstractEmsService = void 0;
var _origin = require("./origin");
var _utils = require("./utils");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
                                                                                                                                                                                                                                                                                                                                                                                           * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                           * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                           * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                           * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                           */
class AbstractEmsService {
  constructor(config, emsClient, proxyPath) {
    _defineProperty(this, "_emsClient", void 0);
    _defineProperty(this, "_config", void 0);
    _defineProperty(this, "_proxyPath", void 0);
    /**
     * Checks if url is absolute. If not, prepend the basePath.
     */
    _defineProperty(this, "_getAbsoluteUrl", url => {
      if (/^https?:\/\//.test(url)) {
        return url;
      } else {
        return (0, _utils.toAbsoluteUrl)(this.getApiUrl(), url);
      }
    });
    this._config = config;
    this._emsClient = emsClient;
    this._proxyPath = proxyPath;
  }
  getAttributions() {
    return this._config.attribution.map(attribution => {
      const url = this._emsClient.getValueInLanguage(attribution.url);
      const label = this._emsClient.getValueInLanguage(attribution.label);
      return {
        url: url,
        label: label
      };
    });
  }
  getMarkdownAttribution() {
    const attributions = this._config.attribution.map(attribution => {
      const url = this._emsClient.getValueInLanguage(attribution.url);
      const label = this._emsClient.getValueInLanguage(attribution.label);
      return `[${label}](${url})`;
    });
    return attributions.join('|');
  }
  getOrigin() {
    return _origin.ORIGIN.EMS;
  }
}
exports.AbstractEmsService = AbstractEmsService;