"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.withTextMeasure = void 0;
var withTextMeasure = function (fun) {
    var canvas = document.createElement('canvas');
    canvas.style.display = 'none';
    var ctx = canvas.getContext('2d');
    var root = document.documentElement;
    root.appendChild(canvas);
    var textMeasure = ctx
        ? function (text, padding, fontSize, fontFamily, lineHeight, fontWeight) {
            if (lineHeight === void 0) { lineHeight = 1; }
            if (fontWeight === void 0) { fontWeight = 400; }
            ctx.font = fontWeight + " " + fontSize + "px " + fontFamily;
            var measure = ctx.measureText(text);
            return { width: measure.width + Math.max(padding, 1), height: fontSize * lineHeight };
        }
        : function () { return ({ width: 0, height: 0 }); };
    var result = fun(textMeasure);
    root.removeChild(canvas);
    return result;
};
exports.withTextMeasure = withTextMeasure;
//# sourceMappingURL=canvas_text_bbox_calculator.js.map