"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.computeChartDimensionsSelector = void 0;
var d3_array_1 = require("d3-array");
var text_utils_1 = require("../../../../common/text_utils");
var create_selector_1 = require("../../../../state/create_selector");
var get_legend_size_1 = require("../../../../state/selectors/get_legend_size");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var common_1 = require("../../../../utils/common");
var get_grid_full_height_1 = require("./get_grid_full_height");
var get_heatmap_config_1 = require("./get_heatmap_config");
var get_heatmap_table_1 = require("./get_heatmap_table");
var get_x_axis_right_overflow_1 = require("./get_x_axis_right_overflow");
var getParentDimension = function (state) { return state.parentDimensions; };
exports.computeChartDimensionsSelector = (0, create_selector_1.createCustomCachedSelector)([
    getParentDimension,
    get_legend_size_1.getLegendSizeSelector,
    get_heatmap_table_1.getHeatmapTableSelector,
    get_heatmap_config_1.getHeatmapConfigSelector,
    get_x_axis_right_overflow_1.getXAxisRightOverflow,
    get_grid_full_height_1.getGridHeightParamsSelector,
    get_settings_specs_1.getSettingsSpecSelector,
], function (chartContainerDimensions, legendSize, heatmapTable, config, rightOverflow, _a, _b) {
    var _c, _d, _e;
    var height = _a.height;
    var showLegend = _b.showLegend, legendPosition = _b.legendPosition;
    var width = chartContainerDimensions.width, left = chartContainerDimensions.left;
    var top = chartContainerDimensions.top;
    var padding = config.yAxisLabel.padding;
    var textMeasurer = document.createElement('canvas');
    var textMeasurerCtx = textMeasurer.getContext('2d');
    var textMeasure = (0, text_utils_1.measureText)(textMeasurerCtx);
    var totalHorizontalPadding = typeof padding === 'number' ? padding * 2 : ((_c = padding.left) !== null && _c !== void 0 ? _c : 0) + ((_d = padding.right) !== null && _d !== void 0 ? _d : 0);
    if (config.yAxisLabel.visible) {
        var boxedYValues = heatmapTable.yValues.map(function (value) {
            return __assign({ text: String(value), value: value, isValue: false }, config.yAxisLabel);
        });
        var measuredYValues = textMeasure(config.yAxisLabel.fontSize, boxedYValues);
        var yColumnWidth = (_e = (0, d3_array_1.max)(measuredYValues, function (_a) {
            var width = _a.width;
            return width;
        })) !== null && _e !== void 0 ? _e : 0;
        if (typeof config.yAxisLabel.width === 'number') {
            yColumnWidth = config.yAxisLabel.width;
        }
        else if (typeof config.yAxisLabel.width === 'object' && yColumnWidth > config.yAxisLabel.width.max) {
            yColumnWidth = config.yAxisLabel.width.max;
        }
        width -= yColumnWidth + rightOverflow + totalHorizontalPadding;
        left += yColumnWidth + totalHorizontalPadding;
    }
    var legendWidth = 0;
    if (showLegend && (legendPosition === common_1.Position.Right || legendPosition === common_1.Position.Left)) {
        legendWidth = legendSize.width - legendSize.margin * 2;
    }
    width -= legendWidth;
    return {
        height: height,
        width: width,
        top: top,
        left: left,
    };
});
//# sourceMappingURL=compute_chart_dimensions.js.map