"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _fs = _interopRequireDefault(require("fs"));
var _react = require("react");
var _path = _interopRequireDefault(require("path"));
var _moment = _interopRequireDefault(require("moment"));
require("moment-timezone");
var _reactDom = _interopRequireDefault(require("react-dom"));
var _enzyme = require("enzyme");
var _reactTestRenderer = require("react-test-renderer");
var _addonStoryshots = _interopRequireWildcard(require("@storybook/addon-storyshots"));
var _styleSheetSerializer = _interopRequireDefault(require("jest-styled-components/src/styleSheetSerializer"));
var _jestSpecificSnapshot = require("jest-specific-snapshot");
var _jquery = _interopRequireDefault(require("jquery"));
var _observer = require("@elastic/eui/test-env/components/observer/observer");
var _reactDropzone = _interopRequireDefault(require("react-dropzone"));
var _rendered_element = require("../shareable_runtime/components/rendered_element");
function _getRequireWildcardCache(nodeInterop) {
  if (typeof WeakMap !== "function") return null;
  var cacheBabelInterop = new WeakMap();
  var cacheNodeInterop = new WeakMap();
  return (_getRequireWildcardCache = function (nodeInterop) {
    return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
  })(nodeInterop);
}
function _interopRequireWildcard(obj, nodeInterop) {
  if (!nodeInterop && obj && obj.__esModule) {
    return obj;
  }
  if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
    return {
      default: obj
    };
  }
  var cache = _getRequireWildcardCache(nodeInterop);
  if (cache && cache.has(obj)) {
    return cache.get(obj);
  }
  var newObj = {};
  var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var key in obj) {
    if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
      var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
      if (desc && (desc.get || desc.set)) {
        Object.defineProperty(newObj, key, desc);
      } else {
        newObj[key] = obj[key];
      }
    }
  }
  newObj.default = obj;
  if (cache) {
    cache.set(obj, newObj);
  }
  return newObj;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// This file is skipped
// @storybook/addon-storyshots is not supported in Jest 27+ https://github.com/storybookjs/storybook/issues/15916

// @ts-expect-error untyped library

// Several of the renderers, used by the runtime, use jQuery.

// @ts-expect-error jQuery global
global.$ = _jquery.default;
// @ts-expect-error jQuery global
global.jQuery = _jquery.default;

// Set our default timezone to UTC for tests so we can generate predictable snapshots
_moment.default.tz.setDefault('UTC');

// Freeze time for the tests for predictable snapshots
const testTime = new Date(Date.UTC(2019, 5, 1)); // June 1 2019
Date.now = jest.fn(() => testTime.getTime());

// Mock telemetry service
jest.mock('../public/lib/ui_metric', () => ({
  trackCanvasUiMetric: () => {}
}));

// Mock EUI generated ids to be consistently predictable for snapshots.
jest.mock(`@elastic/eui/lib/components/form/form_row/make_id`, () => () => `generated-id`);

// Mock react-datepicker dep used by eui to avoid rendering the entire large component
jest.mock('@elastic/eui/packages/react-datepicker', () => {
  return {
    __esModule: true,
    default: 'ReactDatePicker'
  };
});

// Mock React Portal for components that use modals, tooltips, etc
// @ts-expect-error Portal mocks are notoriously difficult to type
_reactDom.default.createPortal = jest.fn(element => element);

// To be resolved by EUI team.
// https://github.com/elastic/eui/issues/3712
jest.mock('@elastic/eui/lib/components/overlay_mask/overlay_mask', () => {
  return {
    EuiOverlayMask: ({
      children
    }) => children
  };
});

// Disabling this test due to https://github.com/elastic/eui/issues/2242
jest.mock('../public/components/workpad_header/share_menu/flyout/__stories__/flyout.stories', () => {
  return 'Disabled Panel';
});

// @ts-expect-error untyped library

jest.mock('@elastic/eui/test-env/components/observer/observer');
_observer.EuiObserver.mockImplementation(() => 'EuiObserver');

// @ts-expect-error untyped library

jest.mock('react-dropzone');
_reactDropzone.default.mockImplementation(() => 'Dropzone');

// This element uses a `ref` and cannot be rendered by Jest snapshots.

jest.mock('../shareable_runtime/components/rendered_element');
// @ts-expect-error
_rendered_element.RenderedElement.mockImplementation(() => 'RenderedElement');

// Some of the code requires that this directory exists, but the tests don't actually require any css to be present
const cssDir = _path.default.resolve(__dirname, '../../../../built_assets/css');
if (!_fs.default.existsSync(cssDir)) {
  _fs.default.mkdirSync(cssDir, {
    recursive: true
  });
}

// Mock index for datasource stories
jest.mock('../public/lib/es_service', () => ({
  getDefaultIndex: () => Promise.resolve('test index')
}));
(0, _jestSpecificSnapshot.addSerializer)(_styleSheetSerializer.default);
const converter = new _addonStoryshots.Stories2SnapsConverter();

// Initialize Storyshots and build the Jest Snapshots
(0, _addonStoryshots.default)({
  configPath: _path.default.resolve(__dirname),
  framework: 'react',
  asyncJest: true,
  test: async ({
    story,
    context,
    done
  }) => {
    const renderer = (0, _reactTestRenderer.create)( /*#__PURE__*/(0, _react.createElement)(story.render));
    // wait until the element will perform all renders and resolve all promises (lazy loading, especially)
    await (0, _reactTestRenderer.act)(() => new Promise(resolve => setTimeout(resolve, 0)));
    // save each snapshot to a different file (similar to "multiSnapshotWithOptions")
    const snapshotFileName = converter.getSnapshotFileName(context);
    expect(renderer).toMatchSpecificSnapshot(snapshotFileName);
    done === null || done === void 0 ? void 0 : done();
  },
  // Don't snapshot tests that start with 'redux'
  storyNameRegex: /^((?!.*?redux).)*$/,
  renderer: _enzyme.shallow
});