"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Fonts = void 0;
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * `Inter` is the latest version of `Inter UI` and used specifically in v8 of Kibana from EUI Amsterdam
 */
const getInter = url => {
  return {
    family: 'Inter',
    variants: [{
      style: 'normal',
      weight: 100,
      sources: [`${url}/fonts/inter/Inter-Thin.woff2`, `${url}/fonts/inter/Inter-Thin.woff`]
    }, {
      style: 'italic',
      weight: 100,
      sources: [`${url}/fonts/inter/Inter-ThinItalic.woff2`, `${url}/fonts/inter/Inter-ThinItalic.woff`]
    }, {
      style: 'normal',
      weight: 200,
      sources: [`${url}/fonts/inter/Inter-ExtraLight.woff2`, `${url}/fonts/inter/Inter-ExtraLight.woff`]
    }, {
      style: 'italic',
      weight: 200,
      sources: [`${url}/fonts/inter/Inter-ExtraLightItalic.woff2`, `${url}/fonts/inter/Inter-ExtraLightItalic.woff`]
    }, {
      style: 'normal',
      weight: 300,
      sources: [`${url}/fonts/inter/Inter-Light.woff2`, `${url}/fonts/inter/Inter-Light.woff`]
    }, {
      style: 'italic',
      weight: 300,
      sources: [`${url}/fonts/inter/Inter-LightItalic.woff2`, `${url}/fonts/inter/Inter-LightItalic.woff`]
    }, {
      style: 'normal',
      weight: 400,
      sources: [`${url}/fonts/inter/Inter-Regular.woff2`, `${url}/fonts/inter/Inter-Regular.woff`]
    }, {
      style: 'italic',
      weight: 400,
      sources: [`${url}/fonts/inter/Inter-Italic.woff2`, `${url}/fonts/inter/Inter-Italic.woff`]
    }, {
      style: 'normal',
      weight: 500,
      sources: [`${url}/fonts/inter/Inter-Medium.woff2`, `${url}/fonts/inter/Inter-Medium.woff`]
    }, {
      style: 'italic',
      weight: 500,
      sources: [`${url}/fonts/inter/Inter-MediumItalic.woff2`, `${url}/fonts/inter/Inter-MediumItalic.woff`]
    }, {
      style: 'normal',
      weight: 600,
      sources: [`${url}/fonts/inter/Inter-SemiBold.woff2`, `${url}/fonts/inter/Inter-SemiBold.woff`]
    }, {
      style: 'italic',
      weight: 600,
      sources: [`${url}/fonts/inter/Inter-SemiBoldItalic.woff2`, `${url}/fonts/inter/Inter-SemiBoldItalic.woff`]
    }, {
      style: 'normal',
      weight: 700,
      sources: [`${url}/fonts/inter/Inter-Bold.woff2`, `${url}/fonts/inter/Inter-Bold.woff`]
    }, {
      style: 'italic',
      weight: 700,
      sources: [`${url}/fonts/inter/Inter-BoldItalic.woff2`, `${url}/fonts/inter/Inter-BoldItalic.woff`]
    }, {
      style: 'normal',
      weight: 800,
      sources: [`${url}/fonts/inter/Inter-ExtraBold.woff2`, `${url}/fonts/inter/Inter-ExtraBold.woff`]
    }, {
      style: 'italic',
      weight: 800,
      sources: [`${url}/fonts/inter/Inter-ExtraBoldItalic.woff2`, `${url}/fonts/inter/Inter-ExtraBoldItalic.woff`]
    }, {
      style: 'normal',
      weight: 900,
      sources: [`${url}/fonts/inter/Inter-Black.woff2`, `${url}/fonts/inter/Inter-Black.woff`]
    }, {
      style: 'italic',
      weight: 900,
      sources: [`${url}/fonts/inter/Inter-BlackItalic.woff2`, `${url}/fonts/inter/Inter-BlackItalic.woff`]
    }]
  };
};
const getInterUi = url => {
  return {
    family: 'Inter UI',
    variants: [{
      style: 'normal',
      weight: 100,
      sources: [`${url}/fonts/inter_ui/Inter-UI-Thin-BETA.woff2`, `${url}/fonts/inter_ui/Inter-UI-Thin-BETA.woff`]
    }, {
      style: 'italic',
      weight: 100,
      sources: [`${url}/fonts/inter_ui/Inter-UI-ThinItalic-BETA.woff2`, `${url}/fonts/inter_ui/Inter-UI-ThinItalic-BETA.woff`]
    }, {
      style: 'normal',
      weight: 200,
      sources: [`${url}/fonts/inter_ui/Inter-UI-ExtraLight-BETA.woff2`, `${url}/fonts/inter_ui/Inter-UI-ExtraLight-BETA.woff`]
    }, {
      style: 'italic',
      weight: 200,
      sources: [`${url}/fonts/inter_ui/Inter-UI-ExtraLightItalic-BETA.woff2`, `${url}/fonts/inter_ui/Inter-UI-ExtraLightItalic-BETA.woff`]
    }, {
      style: 'normal',
      weight: 300,
      sources: [`${url}/fonts/inter_ui/Inter-UI-Light-BETA.woff2`, `${url}/fonts/inter_ui/Inter-UI-Light-BETA.woff`]
    }, {
      style: 'italic',
      weight: 300,
      sources: [`${url}/fonts/inter_ui/Inter-UI-LightItalic-BETA.woff2`, `${url}/fonts/inter_ui/Inter-UI-LightItalic-BETA.woff`]
    }, {
      style: 'normal',
      weight: 400,
      sources: [`${url}/fonts/inter_ui/Inter-UI-Regular.woff2`, `${url}/fonts/inter_ui/Inter-UI-Regular.woff`]
    }, {
      style: 'italic',
      weight: 400,
      sources: [`${url}/fonts/inter_ui/Inter-UI-Italic.woff2`, `${url}/fonts/inter_ui/Inter-UI-Italic.woff`]
    }, {
      style: 'normal',
      weight: 500,
      sources: [`${url}/fonts/inter_ui/Inter-UI-Medium.woff2`, `${url}/fonts/inter_ui/Inter-UI-Medium.woff`]
    }, {
      style: 'italic',
      weight: 500,
      sources: [`${url}/fonts/inter_ui/Inter-UI-MediumItalic.woff2`, `${url}/fonts/inter_ui/Inter-UI-MediumItalic.woff`]
    }, {
      style: 'normal',
      weight: 600,
      sources: [`${url}/fonts/inter_ui/Inter-UI-SemiBold.woff2`, `${url}/fonts/inter_ui/Inter-UI-SemiBold.woff`]
    }, {
      style: 'italic',
      weight: 600,
      sources: [`${url}/fonts/inter_ui/Inter-UI-SemiBoldItalic.woff2`, `${url}/fonts/inter_ui/Inter-UI-SemiBoldItalic.woff`]
    }, {
      style: 'normal',
      weight: 700,
      sources: [`${url}/fonts/inter_ui/Inter-UI-Bold.woff2`, `${url}/fonts/inter_ui/Inter-UI-Bold.woff`]
    }, {
      style: 'italic',
      weight: 700,
      sources: [`${url}/fonts/inter_ui/Inter-UI-BoldItalic.woff2`, `${url}/fonts/inter_ui/Inter-UI-BoldItalic.woff`]
    }, {
      style: 'normal',
      weight: 800,
      sources: [`${url}/fonts/inter_ui/Inter-UI-ExtraBold.woff2`, `${url}/fonts/inter_ui/Inter-UI-ExtraBold.woff`]
    }, {
      style: 'italic',
      weight: 800,
      sources: [`${url}/fonts/inter_ui/Inter-UI-ExtraBoldItalic.woff2`, `${url}/fonts/inter_ui/Inter-UI-ExtraBoldItalic.woff`]
    }, {
      style: 'normal',
      weight: 900,
      sources: [`${url}/fonts/inter_ui/Inter-UI-Black.woff2`, `${url}/fonts/inter_ui/Inter-UI-Black.woff`]
    }, {
      style: 'italic',
      weight: 900,
      sources: [`${url}/fonts/inter_ui/Inter-UI-BlackItalic.woff2`, `${url}/fonts/inter_ui/Inter-UI-BlackItalic.woff`]
    }]
  };
};
const getRoboto = url => {
  return {
    family: 'Roboto Mono',
    variants: [{
      style: 'normal',
      weight: 400,
      format: 'woff2',
      sources: ['Roboto Mono', 'RobotoMono-Regular', `${url}/fonts/roboto_mono/RobotoMono-Regular.ttf`],
      unicodeRange: 'U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD'
    }, {
      style: 'italic',
      weight: 400,
      sources: ['Roboto Mono Italic', 'RobotoMono-Italic', `${url}/fonts/roboto_mono/RobotoMono-Italic.ttf`],
      unicodeRange: 'U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD'
    }, {
      style: 'normal',
      weight: 700,
      format: 'woff2',
      sources: ['Roboto Mono Bold', 'RobotoMono-Bold', `${url}/fonts/roboto_mono/RobotoMono-Bold.ttf`],
      unicodeRange: 'U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD'
    }, {
      style: 'italic',
      weight: 700,
      format: 'woff2',
      sources: ['Roboto Mono Bold Italic', 'RobotoMono-BoldItalic', `${url}/fonts/roboto_mono/RobotoMono-BoldItalic.ttf`],
      unicodeRange: 'U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD'
    }]
  };
};
const Fonts = ({
  url,
  themeVersion
}) => {
  /**
   * If `themeVersion` is not provided, we want to fallback to the newest font family `Inter`
   */
  const sansFont = themeVersion === 'v7' ? getInterUi(url) : getInter(url);
  const codeFont = getRoboto(url);

  /* eslint-disable react/no-danger */
  return /*#__PURE__*/_react.default.createElement("style", {
    dangerouslySetInnerHTML: {
      __html: `
        ${[sansFont, codeFont].flatMap(({
        family,
        variants
      }) => variants.map(({
        style,
        weight,
        format,
        sources,
        unicodeRange
      }) => {
        const src = sources.map(source => source.startsWith(url) ? `url('${source}') format('${format || source.split('.').pop()}')` : `local('${source}')`).join(', ');
        return `
        @font-face {
          font-family: '${family}';
          font-style: ${style};
          font-weight: ${weight};
          src: ${src};${unicodeRange ? `
          unicode-range: ${unicodeRange};` : ''}
        }`;
      })).join('\n')}
      `
    }
  });
  /* eslint-enable react/no-danger */
};
exports.Fonts = Fonts;