/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import * as t from 'io-ts';
import { entriesArray } from '../entries';
import { entriesList } from '../entries_list';

/**
 * Types the nonEmptyEntriesArray as:
 *   - An array of entries of length 1 or greater
 *
 */
export var nonEmptyEntriesArray = new t.Type('NonEmptyEntriesArray', entriesArray.is, function (input, context) {
  if (Array.isArray(input) && input.length === 0) {
    return t.failure(input, context);
  } else {
    if (Array.isArray(input) && input.some(function (entry) {
      return entriesList.is(entry);
    }) && input.some(function (entry) {
      return !entriesList.is(entry);
    })) {
      // fail when an exception item contains both a value list entry and a non-value list entry
      return t.failure(input, context, 'Cannot have entry of type list and other');
    }
    return entriesArray.validate(input, context);
  }
}, t.identity);