"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogLevel = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _std = require("@kbn/std");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Represents the log level, manages string to `LogLevel` conversion and comparison of log level
 * priorities between themselves.
 * @internal
 */
class LogLevel {
  /**
   * Converts string representation of log level into `LogLevel` instance.
   * @param level - String representation of log level.
   * @returns Instance of `LogLevel` class.
   */
  static fromId(level) {
    switch (level) {
      case 'all':
        return LogLevel.All;
      case 'fatal':
        return LogLevel.Fatal;
      case 'error':
        return LogLevel.Error;
      case 'warn':
        return LogLevel.Warn;
      case 'info':
        return LogLevel.Info;
      case 'debug':
        return LogLevel.Debug;
      case 'trace':
        return LogLevel.Trace;
      case 'off':
        return LogLevel.Off;
      default:
        return (0, _std.assertNever)(level);
    }
  }
  constructor(id, value) {
    this.id = id;
    this.value = value;
  }

  /**
   * Indicates whether current log level covers the one that is passed as an argument.
   * @param level - Instance of `LogLevel` to compare to.
   * @returns True if specified `level` is covered by this log level.
   */
  supports(level) {
    return this.value >= level.value;
  }
}
exports.LogLevel = LogLevel;
(0, _defineProperty2.default)(LogLevel, "Off", new LogLevel('off', 1));
(0, _defineProperty2.default)(LogLevel, "Fatal", new LogLevel('fatal', 2));
(0, _defineProperty2.default)(LogLevel, "Error", new LogLevel('error', 3));
(0, _defineProperty2.default)(LogLevel, "Warn", new LogLevel('warn', 4));
(0, _defineProperty2.default)(LogLevel, "Info", new LogLevel('info', 5));
(0, _defineProperty2.default)(LogLevel, "Debug", new LogLevel('debug', 6));
(0, _defineProperty2.default)(LogLevel, "Trace", new LogLevel('trace', 7));
(0, _defineProperty2.default)(LogLevel, "All", new LogLevel('all', 8));