"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.propsToSchema = propsToSchema;
var _PathReporter = require("io-ts/lib/PathReporter");
var _configSchema = require("@kbn/config-schema");
var _Either = require("fp-ts/lib/Either");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function propsToSchema(type) {
  return _configSchema.schema.object({}, {
    unknowns: 'allow',
    validate: val => {
      const decoded = type.decode(val);
      if ((0, _Either.isLeft)(decoded)) {
        return _PathReporter.PathReporter.report(decoded).join('\n');
      }
    }
  });
}