import _objectSpread from "@babel/runtime/helpers/objectSpread2";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import * as ast from '../ast';
import * as literal from '../node_types/literal';
export function buildNodeParams(path, child) {
  var pathNode = typeof path === 'string' ? ast.fromLiteralExpression(path) : literal.buildNode(path);
  return {
    arguments: [pathNode, child]
  };
}
export function toElasticsearchQuery(node, indexPattern) {
  var _context$nested;
  var config = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var context = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
  var _node$arguments = _slicedToArray(node.arguments, 2),
    path = _node$arguments[0],
    child = _node$arguments[1];
  var stringPath = ast.toElasticsearchQuery(path);
  var fullPath = context !== null && context !== void 0 && (_context$nested = context.nested) !== null && _context$nested !== void 0 && _context$nested.path ? "".concat(context.nested.path, ".").concat(stringPath) : stringPath;
  return {
    nested: {
      path: fullPath,
      query: ast.toElasticsearchQuery(child, indexPattern, config, _objectSpread(_objectSpread({}, context), {}, {
        nested: {
          path: fullPath
        }
      })),
      score_mode: 'none'
    }
  };
}