import _objectSpread from "@babel/runtime/helpers/objectSpread2";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import * as literal from '../node_types/literal';
export function buildNodeParams(fieldName) {
  return {
    arguments: [literal.buildNode(fieldName)]
  };
}
export function toElasticsearchQuery(node, indexPattern) {
  var _indexPattern$fields;
  var config = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var context = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
  var _node$arguments = _slicedToArray(node.arguments, 1),
    fieldNameArg = _node$arguments[0];
  var fullFieldNameArg = _objectSpread(_objectSpread({}, fieldNameArg), {}, {
    value: context !== null && context !== void 0 && context.nested ? "".concat(context.nested.path, ".").concat(fieldNameArg.value) : fieldNameArg.value
  });
  var fieldName = literal.toElasticsearchQuery(fullFieldNameArg);
  var field = indexPattern === null || indexPattern === void 0 ? void 0 : (_indexPattern$fields = indexPattern.fields) === null || _indexPattern$fields === void 0 ? void 0 : _indexPattern$fields.find(function (fld) {
    return fld.name === fieldName;
  });
  if (field !== null && field !== void 0 && field.scripted) {
    throw new Error("Exists query does not support scripted fields");
  }
  return {
    exists: {
      field: fieldName
    }
  };
}