"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.geometries = void 0;
var create_selector_1 = require("../../../../state/create_selector");
var get_chart_theme_1 = require("../../../../state/selectors/get_chart_theme");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var viewmodel_types_1 = require("../../layout/types/viewmodel_types");
var compute_chart_dimensions_1 = require("./compute_chart_dimensions");
var get_color_scale_1 = require("./get_color_scale");
var get_grid_full_height_1 = require("./get_grid_full_height");
var get_heatmap_spec_1 = require("./get_heatmap_spec");
var get_heatmap_table_1 = require("./get_heatmap_table");
var scenegraph_1 = require("./scenegraph");
var getDeselectedSeriesSelector = function (state) { return state.interactions.deselectedDataSeries; };
exports.geometries = (0, create_selector_1.createCustomCachedSelector)([
    get_heatmap_spec_1.getHeatmapSpecSelector,
    compute_chart_dimensions_1.computeChartDimensionsSelector,
    get_settings_specs_1.getSettingsSpecSelector,
    get_heatmap_table_1.getHeatmapTableSelector,
    get_color_scale_1.getColorScale,
    getDeselectedSeriesSelector,
    get_grid_full_height_1.getGridHeightParamsSelector,
    get_chart_theme_1.getChartThemeSelector,
], function (heatmapSpec, chartDimensions, settingSpec, heatmapTable, _a, deselectedSeries, gridHeightParams, theme) {
    var bands = _a.bands, colorScale = _a.scale;
    var disabledBandLabels = new Set(deselectedSeries.map(function (_a) {
        var specId = _a.specId;
        return specId;
    }));
    var bandsToHide = bands
        .filter(function (_a) {
        var label = _a.label;
        return disabledBandLabels.has(label);
    })
        .map(function (_a) {
        var start = _a.start, end = _a.end;
        return [start, end];
    });
    return heatmapSpec
        ? (0, scenegraph_1.render)(heatmapSpec, settingSpec, chartDimensions, heatmapTable, colorScale, bandsToHide, gridHeightParams, theme)
        : (0, viewmodel_types_1.nullShapeViewModel)();
});
//# sourceMappingURL=geometries.js.map