"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerGenerateFromSavedObject = registerGenerateFromSavedObject;
var _configSchema = require("@kbn/config-schema");
var _assert = _interopRequireDefault(require("assert"));
var _moment = _interopRequireDefault(require("moment"));
var _ = require("..");
var _constants = require("../../../common/constants");
var _authorized_user_pre_routing = require("../lib/authorized_user_pre_routing");
var _request_handler = require("../lib/request_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CsvSavedSearchExportParamsSchema = _configSchema.schema.object({
  savedObjectId: _configSchema.schema.string({
    minLength: 2
  })
});
const CsvSavedSearchExportBodySchema = _configSchema.schema.nullable(_configSchema.schema.object({
  state: _configSchema.schema.maybe(_configSchema.schema.object({
    query: _configSchema.schema.maybe(_configSchema.schema.any({
      validate: input => {
        const failMessage = 'Must be a object of Query DSL or an array of Query DSL objects';
        if (typeof input !== 'object') {
          return failMessage;
        }
        if (Array.isArray(input)) {
          for (let i = 0; i < input.length; i++) {
            if (typeof input[i] !== 'object') {
              return failMessage;
            }
          }
        }
      }
    }))
  })),
  timerange: _configSchema.schema.maybe(_configSchema.schema.object({
    timezone: _configSchema.schema.maybe(_configSchema.schema.string()),
    min: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.number(), _configSchema.schema.string({
      minLength: 5
    })])),
    max: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.number(), _configSchema.schema.string({
      minLength: 5
    })]))
  }))
}));

/**
 * Register an API Endpoint for queuing report jobs
 * Only CSV export from Saved Search ID is supported.
 * @public
 */
function registerGenerateFromSavedObject(reporting, logger) {
  const csvSavedSearchExportPath = `${_constants.API_BASE_URL_V1}/generate/csv/saved-object/search:{savedObjectId}`;
  const setupDeps = reporting.getPluginSetupDeps();
  const {
    router
  } = setupDeps;
  router.post({
    path: csvSavedSearchExportPath,
    validate: {
      params: CsvSavedSearchExportParamsSchema,
      body: CsvSavedSearchExportBodySchema
    }
  }, (0, _authorized_user_pre_routing.authorizedUserPreRouting)(reporting, async (user, context, req, res) => {
    var _req$body, _req$body$timerange, _req$body2, _req$body2$timerange;
    // 1. Parse the optional time range for validation
    let minTime;
    let maxTime;
    if ((_req$body = req.body) !== null && _req$body !== void 0 && (_req$body$timerange = _req$body.timerange) !== null && _req$body$timerange !== void 0 && _req$body$timerange.min || (_req$body2 = req.body) !== null && _req$body2 !== void 0 && (_req$body2$timerange = _req$body2.timerange) !== null && _req$body2$timerange !== void 0 && _req$body2$timerange.max) {
      try {
        var _req$body3, _req$body3$timerange, _req$body4, _req$body4$timerange, _req$body5, _req$body5$timerange, _req$body6, _req$body6$timerange;
        minTime = (_req$body3 = req.body) !== null && _req$body3 !== void 0 && (_req$body3$timerange = _req$body3.timerange) !== null && _req$body3$timerange !== void 0 && _req$body3$timerange.min ? (0, _moment.default)((_req$body4 = req.body) === null || _req$body4 === void 0 ? void 0 : (_req$body4$timerange = _req$body4.timerange) === null || _req$body4$timerange === void 0 ? void 0 : _req$body4$timerange.min) : minTime;
        maxTime = (_req$body5 = req.body) !== null && _req$body5 !== void 0 && (_req$body5$timerange = _req$body5.timerange) !== null && _req$body5$timerange !== void 0 && _req$body5$timerange.max ? (0, _moment.default)((_req$body6 = req.body) === null || _req$body6 === void 0 ? void 0 : (_req$body6$timerange = _req$body6.timerange) === null || _req$body6$timerange === void 0 ? void 0 : _req$body6$timerange.max) : maxTime;
        if (minTime) (0, _assert.default)(minTime.isValid(), `Min time is not valid`);
        if (maxTime) (0, _assert.default)(maxTime.isValid(), `Max time is not valid`);
      } catch (err) {
        return res.badRequest((0, _.wrapError)(err));
      }
    }
    try {
      var _req$body7, _req$body7$timerange, _req$body8, _req$body9, _searchObject$attribu;
      // 2. Read the saved object to get the title
      const searchObject = await context.core.savedObjects.client.get('search', req.params.savedObjectId);

      // 3. Store the job params in the Report queue
      const requestHandler = new _request_handler.RequestHandler(reporting, user, context, req, res, logger);
      const jobParams = {
        browserTimezone: ((_req$body7 = req.body) === null || _req$body7 === void 0 ? void 0 : (_req$body7$timerange = _req$body7.timerange) === null || _req$body7$timerange === void 0 ? void 0 : _req$body7$timerange.timezone) || 'UTC',
        timerange: (_req$body8 = req.body) === null || _req$body8 === void 0 ? void 0 : _req$body8.timerange,
        savedObjectId: req.params.savedObjectId,
        state: (_req$body9 = req.body) === null || _req$body9 === void 0 ? void 0 : _req$body9.state,
        title: (_searchObject$attribu = searchObject.attributes.title) !== null && _searchObject$attribu !== void 0 ? _searchObject$attribu : 'Unknown search',
        objectType: 'saved search',
        version: '7.17'
      };
      const result = await requestHandler.handleGenerateRequest(_constants.CSV_SAVED_OBJECT_JOB_TYPE, jobParams);

      // 4. Return details of the stored report
      return res.ok({
        body: result,
        headers: {
          'content-type': 'application/json'
        }
      });
    } catch (err) {
      return res.customError((0, _.wrapError)(err));
    }
  }));
}