"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChromiumArchivePaths = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _path = _interopRequireDefault(require("path"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var BaseUrl;
(function (BaseUrl) {
  BaseUrl["common"] = "https://commondatastorage.googleapis.com/chromium-browser-snapshots";
  BaseUrl["custom"] = "https://storage.googleapis.com/headless_shell";
})(BaseUrl || (BaseUrl = {}));
function isCommonPackage(p) {
  return p.location === 'common';
}
class ChromiumArchivePaths {
  constructor() {
    (0, _defineProperty2.default)(this, "packages", [{
      platform: 'darwin',
      architecture: 'x64',
      archiveFilename: 'chrome-mac.zip',
      archiveChecksum: '2ce969500158dd98e3ad4502dbb6b13c',
      binaryChecksum: '9960dd00ab27b4e9ee1455692bb65701',
      binaryRelativePath: 'chrome-mac/Chromium.app/Contents/MacOS/Chromium',
      revision: 1121448,
      location: 'common',
      archivePath: 'Mac',
      isPreInstalled: false
    }, {
      platform: 'darwin',
      architecture: 'arm64',
      archiveFilename: 'chrome-mac.zip',
      archiveChecksum: 'a4fea96b155483e0617d909c9b2cb32a',
      binaryChecksum: '4cc4ee072b23e4a65e714ff543eea21b',
      binaryRelativePath: 'chrome-mac/Chromium.app/Contents/MacOS/Chromium',
      revision: 1121443,
      location: 'common',
      archivePath: 'Mac_Arm',
      isPreInstalled: false
    }, {
      platform: 'linux',
      architecture: 'x64',
      archiveFilename: 'chromium-38c3182-locales-linux_x64.zip',
      archiveChecksum: '9635c58ccd7a6260dcfc0be7fa1545f6',
      binaryChecksum: '02b21e91e39eb9aa68bbb4fedfa73204',
      binaryRelativePath: 'headless_shell-linux_x64/headless_shell',
      revision: 1121455,
      location: 'custom',
      isPreInstalled: true
    }, {
      platform: 'linux',
      architecture: 'arm64',
      archiveFilename: 'chromium-38c3182-locales-linux_arm64.zip',
      archiveChecksum: '96dca82cccea6ae82aaf0bc46104a501',
      binaryChecksum: '753e07c59b6f269b2f06091155d53f4b',
      binaryRelativePath: 'headless_shell-linux_arm64/headless_shell',
      revision: 1121455,
      location: 'custom',
      isPreInstalled: true
    }, {
      platform: 'win32',
      architecture: 'x64',
      archiveFilename: 'chrome-win.zip',
      archiveChecksum: '76b6c8aa15f0b16df18f793c9953f59f',
      binaryChecksum: '762fe3b0ffe86d525bb3ed91f870cb7a',
      binaryRelativePath: _path.default.join('chrome-win', 'chrome.exe'),
      revision: 1121435,
      location: 'common',
      archivePath: 'Win',
      isPreInstalled: true
    }]);
    // zip files get downloaded to a .chromium directory in the kibana root
    (0, _defineProperty2.default)(this, "archivesPath", _path.default.resolve(__dirname, '../../../../../../.chromium'));
  }
  find(platform, architecture, packages = this.packages) {
    return packages.find(p => p.platform === platform && p.architecture === architecture);
  }
  resolvePath(p) {
    // adding architecture to the path allows it to download two binaries that have the same name, but are different architecture
    return _path.default.resolve(this.archivesPath, p.architecture, p.archiveFilename);
  }
  getAllArchiveFilenames() {
    return this.packages.map(p => this.resolvePath(p));
  }
  getDownloadUrl(p) {
    if (isCommonPackage(p)) {
      const {
        common
      } = BaseUrl;
      const {
        archivePath,
        revision,
        archiveFilename
      } = p;
      return `${common}/${archivePath}/${revision}/${archiveFilename}`;
    }
    return BaseUrl.custom + '/' + p.archiveFilename; // revision is not used for URL if package is a custom build
  }

  getBinaryPath(p, chromiumPath = _path.default.resolve(__dirname, '../../../chromium')) {
    return _path.default.join(chromiumPath, p.binaryRelativePath);
  }
}
exports.ChromiumArchivePaths = ChromiumArchivePaths;