"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getClusterStatus = getClusterStatus;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * @param cluster {Object} clusterStats from getClusterStatus
 * @param unassignedShards {Object} shardStats from getShardStats
 * @return top-level cluster summary data
 */
function getClusterStatus(cluster, shardStats) {
  var _cluster$elasticsearc, _cluster$elasticsearc2, _ref, _clusterStatsLegacy$i, _clusterStatsLegacy$i2, _clusterStatsLegacy$i3, _clusterStatsMB$indic, _clusterStatsMB$indic2, _ref2, _cluster$elasticsearc3, _cluster$elasticsearc4, _cluster$elasticsearc5, _cluster$elasticsearc6, _cluster$cluster_stat, _ref3, _clusterStatsLegacy$i4, _clusterStatsLegacy$i5, _clusterStatsMB$indic3, _ref4, _clusterStatsLegacy$i6, _clusterStatsLegacy$i7, _clusterStatsLegacy$i8, _clusterStatsMB$indic4, _clusterStatsMB$indic5, _ref5, _clusterStatsMB$indic6, _clusterStatsMB$indic7, _clusterStatsMB$indic8, _clusterStatsMB$indic9, _clusterStatsLegacy$i9, _clusterStatsLegacy$i10, _ref6, _clusterStatsLegacy$n, _clusterStatsLegacy$n2, _clusterStatsLegacy$n3, _clusterStatsMB$nodes, _ref7, _clusterStatsMB$nodes2, _clusterStatsMB$nodes3, _clusterStatsMB$nodes4, _clusterStatsMB$nodes5, _clusterStatsLegacy$n4, _clusterStatsLegacy$n5, _ref8, _clusterStatsMB$nodes6, _clusterStatsMB$nodes7, _clusterStatsLegacy$n6, _ref9, _clusterStatsMB$nodes8, _clusterStatsMB$nodes9, _clusterStatsMB$nodes10, _clusterStatsMB$nodes11, _clusterStatsMB$nodes12, _clusterStatsMB$nodes13, _clusterStatsLegacy$n7, _clusterStatsLegacy$n8, _clusterStatsLegacy$n9, _ref10, _clusterStatsMB$nodes14, _clusterStatsMB$nodes15, _clusterStatsMB$nodes16, _clusterStatsMB$nodes17, _clusterStatsMB$nodes18, _clusterStatsMB$nodes19, _clusterStatsLegacy$n10, _clusterStatsLegacy$n11, _clusterStatsLegacy$n12;
  const clusterStatsLegacy = cluster.cluster_stats;
  const clusterStatsMB = (_cluster$elasticsearc = cluster.elasticsearch) === null || _cluster$elasticsearc === void 0 ? void 0 : (_cluster$elasticsearc2 = _cluster$elasticsearc.cluster) === null || _cluster$elasticsearc2 === void 0 ? void 0 : _cluster$elasticsearc2.stats;
  const clusterTotalShards = (_ref = (_clusterStatsLegacy$i = clusterStatsLegacy === null || clusterStatsLegacy === void 0 ? void 0 : (_clusterStatsLegacy$i2 = clusterStatsLegacy.indices) === null || _clusterStatsLegacy$i2 === void 0 ? void 0 : (_clusterStatsLegacy$i3 = _clusterStatsLegacy$i2.shards) === null || _clusterStatsLegacy$i3 === void 0 ? void 0 : _clusterStatsLegacy$i3.total) !== null && _clusterStatsLegacy$i !== void 0 ? _clusterStatsLegacy$i : clusterStatsMB === null || clusterStatsMB === void 0 ? void 0 : (_clusterStatsMB$indic = clusterStatsMB.indices) === null || _clusterStatsMB$indic === void 0 ? void 0 : (_clusterStatsMB$indic2 = _clusterStatsMB$indic.shards) === null || _clusterStatsMB$indic2 === void 0 ? void 0 : _clusterStatsMB$indic2.count) !== null && _ref !== void 0 ? _ref : 0;
  let unassignedShardsTotal = 0;
  const unassignedShards = (0, _lodash.get)(shardStats, 'indicesTotals.unassigned');
  if (unassignedShards !== undefined) {
    const {
      replica,
      primary
    } = unassignedShards;
    unassignedShardsTotal = replica + primary || 0; // replica + primary will be NaN if unassignedShards is not passed
  }

  const totalShards = clusterTotalShards + unassignedShardsTotal;
  return {
    status: (_ref2 = (_cluster$elasticsearc3 = (_cluster$elasticsearc4 = cluster.elasticsearch) === null || _cluster$elasticsearc4 === void 0 ? void 0 : (_cluster$elasticsearc5 = _cluster$elasticsearc4.cluster) === null || _cluster$elasticsearc5 === void 0 ? void 0 : (_cluster$elasticsearc6 = _cluster$elasticsearc5.stats) === null || _cluster$elasticsearc6 === void 0 ? void 0 : _cluster$elasticsearc6.status) !== null && _cluster$elasticsearc3 !== void 0 ? _cluster$elasticsearc3 : (_cluster$cluster_stat = cluster.cluster_state) === null || _cluster$cluster_stat === void 0 ? void 0 : _cluster$cluster_stat.status) !== null && _ref2 !== void 0 ? _ref2 : 'unknown',
    // index-based stats
    indicesCount: (_ref3 = (_clusterStatsLegacy$i4 = clusterStatsLegacy === null || clusterStatsLegacy === void 0 ? void 0 : (_clusterStatsLegacy$i5 = clusterStatsLegacy.indices) === null || _clusterStatsLegacy$i5 === void 0 ? void 0 : _clusterStatsLegacy$i5.count) !== null && _clusterStatsLegacy$i4 !== void 0 ? _clusterStatsLegacy$i4 : clusterStatsMB === null || clusterStatsMB === void 0 ? void 0 : (_clusterStatsMB$indic3 = clusterStatsMB.indices) === null || _clusterStatsMB$indic3 === void 0 ? void 0 : _clusterStatsMB$indic3.total) !== null && _ref3 !== void 0 ? _ref3 : 0,
    documentCount: (_ref4 = (_clusterStatsLegacy$i6 = clusterStatsLegacy === null || clusterStatsLegacy === void 0 ? void 0 : (_clusterStatsLegacy$i7 = clusterStatsLegacy.indices) === null || _clusterStatsLegacy$i7 === void 0 ? void 0 : (_clusterStatsLegacy$i8 = _clusterStatsLegacy$i7.docs) === null || _clusterStatsLegacy$i8 === void 0 ? void 0 : _clusterStatsLegacy$i8.count) !== null && _clusterStatsLegacy$i6 !== void 0 ? _clusterStatsLegacy$i6 : clusterStatsMB === null || clusterStatsMB === void 0 ? void 0 : (_clusterStatsMB$indic4 = clusterStatsMB.indices) === null || _clusterStatsMB$indic4 === void 0 ? void 0 : (_clusterStatsMB$indic5 = _clusterStatsMB$indic4.docs) === null || _clusterStatsMB$indic5 === void 0 ? void 0 : _clusterStatsMB$indic5.total) !== null && _ref4 !== void 0 ? _ref4 : 0,
    dataSize: (_ref5 = (_clusterStatsMB$indic6 = clusterStatsMB === null || clusterStatsMB === void 0 ? void 0 : (_clusterStatsMB$indic7 = clusterStatsMB.indices) === null || _clusterStatsMB$indic7 === void 0 ? void 0 : (_clusterStatsMB$indic8 = _clusterStatsMB$indic7.store) === null || _clusterStatsMB$indic8 === void 0 ? void 0 : (_clusterStatsMB$indic9 = _clusterStatsMB$indic8.size) === null || _clusterStatsMB$indic9 === void 0 ? void 0 : _clusterStatsMB$indic9.bytes) !== null && _clusterStatsMB$indic6 !== void 0 ? _clusterStatsMB$indic6 : clusterStatsLegacy === null || clusterStatsLegacy === void 0 ? void 0 : (_clusterStatsLegacy$i9 = clusterStatsLegacy.indices) === null || _clusterStatsLegacy$i9 === void 0 ? void 0 : (_clusterStatsLegacy$i10 = _clusterStatsLegacy$i9.store) === null || _clusterStatsLegacy$i10 === void 0 ? void 0 : _clusterStatsLegacy$i10.size_in_bytes) !== null && _ref5 !== void 0 ? _ref5 : 0,
    // node-based stats
    nodesCount: (_ref6 = (_clusterStatsLegacy$n = clusterStatsLegacy === null || clusterStatsLegacy === void 0 ? void 0 : (_clusterStatsLegacy$n2 = clusterStatsLegacy.nodes) === null || _clusterStatsLegacy$n2 === void 0 ? void 0 : (_clusterStatsLegacy$n3 = _clusterStatsLegacy$n2.count) === null || _clusterStatsLegacy$n3 === void 0 ? void 0 : _clusterStatsLegacy$n3.total) !== null && _clusterStatsLegacy$n !== void 0 ? _clusterStatsLegacy$n : clusterStatsMB === null || clusterStatsMB === void 0 ? void 0 : (_clusterStatsMB$nodes = clusterStatsMB.nodes) === null || _clusterStatsMB$nodes === void 0 ? void 0 : _clusterStatsMB$nodes.count) !== null && _ref6 !== void 0 ? _ref6 : 0,
    upTime: (_ref7 = (_clusterStatsMB$nodes2 = clusterStatsMB === null || clusterStatsMB === void 0 ? void 0 : (_clusterStatsMB$nodes3 = clusterStatsMB.nodes) === null || _clusterStatsMB$nodes3 === void 0 ? void 0 : (_clusterStatsMB$nodes4 = _clusterStatsMB$nodes3.jvm) === null || _clusterStatsMB$nodes4 === void 0 ? void 0 : (_clusterStatsMB$nodes5 = _clusterStatsMB$nodes4.max_uptime) === null || _clusterStatsMB$nodes5 === void 0 ? void 0 : _clusterStatsMB$nodes5.ms) !== null && _clusterStatsMB$nodes2 !== void 0 ? _clusterStatsMB$nodes2 : clusterStatsLegacy === null || clusterStatsLegacy === void 0 ? void 0 : (_clusterStatsLegacy$n4 = clusterStatsLegacy.nodes) === null || _clusterStatsLegacy$n4 === void 0 ? void 0 : (_clusterStatsLegacy$n5 = _clusterStatsLegacy$n4.jvm) === null || _clusterStatsLegacy$n5 === void 0 ? void 0 : _clusterStatsLegacy$n5.max_uptime_in_millis) !== null && _ref7 !== void 0 ? _ref7 : 0,
    version: (_ref8 = (_clusterStatsMB$nodes6 = clusterStatsMB === null || clusterStatsMB === void 0 ? void 0 : (_clusterStatsMB$nodes7 = clusterStatsMB.nodes) === null || _clusterStatsMB$nodes7 === void 0 ? void 0 : _clusterStatsMB$nodes7.versions) !== null && _clusterStatsMB$nodes6 !== void 0 ? _clusterStatsMB$nodes6 : clusterStatsLegacy === null || clusterStatsLegacy === void 0 ? void 0 : (_clusterStatsLegacy$n6 = clusterStatsLegacy.nodes) === null || _clusterStatsLegacy$n6 === void 0 ? void 0 : _clusterStatsLegacy$n6.versions) !== null && _ref8 !== void 0 ? _ref8 : null,
    memUsed: (_ref9 = (_clusterStatsMB$nodes8 = clusterStatsMB === null || clusterStatsMB === void 0 ? void 0 : (_clusterStatsMB$nodes9 = clusterStatsMB.nodes) === null || _clusterStatsMB$nodes9 === void 0 ? void 0 : (_clusterStatsMB$nodes10 = _clusterStatsMB$nodes9.jvm) === null || _clusterStatsMB$nodes10 === void 0 ? void 0 : (_clusterStatsMB$nodes11 = _clusterStatsMB$nodes10.memory) === null || _clusterStatsMB$nodes11 === void 0 ? void 0 : (_clusterStatsMB$nodes12 = _clusterStatsMB$nodes11.heap) === null || _clusterStatsMB$nodes12 === void 0 ? void 0 : (_clusterStatsMB$nodes13 = _clusterStatsMB$nodes12.used) === null || _clusterStatsMB$nodes13 === void 0 ? void 0 : _clusterStatsMB$nodes13.bytes) !== null && _clusterStatsMB$nodes8 !== void 0 ? _clusterStatsMB$nodes8 : clusterStatsLegacy === null || clusterStatsLegacy === void 0 ? void 0 : (_clusterStatsLegacy$n7 = clusterStatsLegacy.nodes) === null || _clusterStatsLegacy$n7 === void 0 ? void 0 : (_clusterStatsLegacy$n8 = _clusterStatsLegacy$n7.jvm) === null || _clusterStatsLegacy$n8 === void 0 ? void 0 : (_clusterStatsLegacy$n9 = _clusterStatsLegacy$n8.mem) === null || _clusterStatsLegacy$n9 === void 0 ? void 0 : _clusterStatsLegacy$n9.heap_used_in_bytes) !== null && _ref9 !== void 0 ? _ref9 : 0,
    memMax: (_ref10 = (_clusterStatsMB$nodes14 = clusterStatsMB === null || clusterStatsMB === void 0 ? void 0 : (_clusterStatsMB$nodes15 = clusterStatsMB.nodes) === null || _clusterStatsMB$nodes15 === void 0 ? void 0 : (_clusterStatsMB$nodes16 = _clusterStatsMB$nodes15.jvm) === null || _clusterStatsMB$nodes16 === void 0 ? void 0 : (_clusterStatsMB$nodes17 = _clusterStatsMB$nodes16.memory) === null || _clusterStatsMB$nodes17 === void 0 ? void 0 : (_clusterStatsMB$nodes18 = _clusterStatsMB$nodes17.heap) === null || _clusterStatsMB$nodes18 === void 0 ? void 0 : (_clusterStatsMB$nodes19 = _clusterStatsMB$nodes18.max) === null || _clusterStatsMB$nodes19 === void 0 ? void 0 : _clusterStatsMB$nodes19.bytes) !== null && _clusterStatsMB$nodes14 !== void 0 ? _clusterStatsMB$nodes14 : clusterStatsLegacy === null || clusterStatsLegacy === void 0 ? void 0 : (_clusterStatsLegacy$n10 = clusterStatsLegacy.nodes) === null || _clusterStatsLegacy$n10 === void 0 ? void 0 : (_clusterStatsLegacy$n11 = _clusterStatsLegacy$n10.jvm) === null || _clusterStatsLegacy$n11 === void 0 ? void 0 : (_clusterStatsLegacy$n12 = _clusterStatsLegacy$n11.mem) === null || _clusterStatsLegacy$n12 === void 0 ? void 0 : _clusterStatsLegacy$n12.heap_max_in_bytes) !== null && _ref10 !== void 0 ? _ref10 : 0,
    unassignedShards: unassignedShardsTotal,
    totalShards
  };
}