"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapsTelemetrySavedObjects = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * The maps-telemetry saved object type isn't used, but in order to remove these fields from
 * the mappings we register this type with `type: 'object', enabled: true` to remove all
 * previous fields from the mappings until https://github.com/elastic/kibana/issues/67086 is
 * solved.
 */
const mapsTelemetrySavedObjects = {
  name: 'maps-telemetry',
  hidden: false,
  namespaceType: 'agnostic',
  mappings: {
    // @ts-ignore Core types don't support this since it's only really valid when removing a previously registered type
    type: 'object',
    enabled: false
  }
};
exports.mapsTelemetrySavedObjects = mapsTelemetrySavedObjects;