"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.userIsReArrangingProviders = exports.unEscapeFieldId = exports.sourceIsContent = exports.sourceAndDestinationAreSameTimelineProviders = exports.reasonIsDrop = exports.providerWasDroppedOnTimeline = exports.getTimelineProviderDroppableId = exports.getTimelineProviderDraggableId = exports.getProviderIdFromDraggable = exports.getFieldIdFromDraggable = exports.getDroppableId = exports.getDraggableId = exports.getDraggableFieldId = exports.fieldWasDroppedOnTimelineColumns = exports.escapeFieldId = exports.escapeDataProviderId = exports.escapeContextId = exports.droppableTimelineProvidersPrefix = exports.droppableTimelineFlyoutBottomBarPrefix = exports.droppableTimelineColumnsPrefix = exports.droppableIdPrefix = exports.droppableFieldPrefix = exports.droppableContentPrefix = exports.draggableTimelineProvidersPrefix = exports.draggableIsField = exports.draggableIsContent = exports.draggableIdPrefix = exports.draggableFieldPrefix = exports.draggableContentPrefix = exports.destinationIsTimelineProviders = exports.destinationIsTimelineColumns = exports.destinationIsTimelineButton = exports.IS_TIMELINE_FIELD_DRAGGING_CLASS_NAME = exports.DRAG_TYPE_FIELD = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const draggableIdPrefix = 'draggableId';
exports.draggableIdPrefix = draggableIdPrefix;
const droppableIdPrefix = 'droppableId';
exports.droppableIdPrefix = droppableIdPrefix;
const draggableContentPrefix = `${draggableIdPrefix}.content.`;
exports.draggableContentPrefix = draggableContentPrefix;
const draggableTimelineProvidersPrefix = `${draggableIdPrefix}.timelineProviders.`;
exports.draggableTimelineProvidersPrefix = draggableTimelineProvidersPrefix;
const draggableFieldPrefix = `${draggableIdPrefix}.field.`;
exports.draggableFieldPrefix = draggableFieldPrefix;
const droppableContentPrefix = `${droppableIdPrefix}.content.`;
exports.droppableContentPrefix = droppableContentPrefix;
const droppableFieldPrefix = `${droppableIdPrefix}.field.`;
exports.droppableFieldPrefix = droppableFieldPrefix;
const droppableTimelineProvidersPrefix = `${droppableIdPrefix}.timelineProviders.`;
exports.droppableTimelineProvidersPrefix = droppableTimelineProvidersPrefix;
const droppableTimelineColumnsPrefix = `${droppableIdPrefix}.timelineColumns.`;
exports.droppableTimelineColumnsPrefix = droppableTimelineColumnsPrefix;
const droppableTimelineFlyoutBottomBarPrefix = `${droppableIdPrefix}.flyoutButton.`;
exports.droppableTimelineFlyoutBottomBarPrefix = droppableTimelineFlyoutBottomBarPrefix;
const getDraggableId = dataProviderId => `${draggableContentPrefix}${dataProviderId}`;
exports.getDraggableId = getDraggableId;
const getDraggableFieldId = ({
  contextId,
  fieldId
}) => `${draggableFieldPrefix}${escapeContextId(contextId)}.${escapeFieldId(fieldId)}`;
exports.getDraggableFieldId = getDraggableFieldId;
const getTimelineProviderDroppableId = ({
  groupIndex,
  timelineId
}) => `${droppableTimelineProvidersPrefix}${timelineId}.group.${groupIndex}`;
exports.getTimelineProviderDroppableId = getTimelineProviderDroppableId;
const getTimelineProviderDraggableId = ({
  dataProviderId,
  groupIndex,
  timelineId
}) => `${draggableTimelineProvidersPrefix}${timelineId}.group.${groupIndex}.${dataProviderId}`;
exports.getTimelineProviderDraggableId = getTimelineProviderDraggableId;
const getDroppableId = visualizationPlaceholderId => `${droppableContentPrefix}${visualizationPlaceholderId}`;
exports.getDroppableId = getDroppableId;
const sourceIsContent = result => result.source.droppableId.startsWith(droppableContentPrefix);
exports.sourceIsContent = sourceIsContent;
const sourceAndDestinationAreSameTimelineProviders = result => {
  const regex = /^droppableId\.timelineProviders\.(\S+)\./;
  const sourceMatches = result.source.droppableId.match(regex) || [];
  const destinationMatches = result.destination && result.destination.droppableId.match(regex) || [];
  return sourceMatches.length >= 2 && destinationMatches.length >= 2 && sourceMatches[1] === destinationMatches[1];
};
exports.sourceAndDestinationAreSameTimelineProviders = sourceAndDestinationAreSameTimelineProviders;
const draggableIsContent = result => result.draggableId.startsWith(draggableContentPrefix);
exports.draggableIsContent = draggableIsContent;
const draggableIsField = result => result.draggableId.startsWith(draggableFieldPrefix);
exports.draggableIsField = draggableIsField;
const reasonIsDrop = result => result.reason === 'DROP';
exports.reasonIsDrop = reasonIsDrop;
const destinationIsTimelineProviders = result => result.destination != null && result.destination.droppableId.startsWith(droppableTimelineProvidersPrefix);
exports.destinationIsTimelineProviders = destinationIsTimelineProviders;
const destinationIsTimelineColumns = result => result.destination != null && result.destination.droppableId.startsWith(droppableTimelineColumnsPrefix);
exports.destinationIsTimelineColumns = destinationIsTimelineColumns;
const destinationIsTimelineButton = result => result.destination != null && result.destination.droppableId.startsWith(droppableTimelineFlyoutBottomBarPrefix);
exports.destinationIsTimelineButton = destinationIsTimelineButton;
const getProviderIdFromDraggable = result => result.draggableId.substring(result.draggableId.lastIndexOf('.') + 1);
exports.getProviderIdFromDraggable = getProviderIdFromDraggable;
const getFieldIdFromDraggable = result => unEscapeFieldId(result.draggableId.substring(result.draggableId.lastIndexOf('.') + 1));
exports.getFieldIdFromDraggable = getFieldIdFromDraggable;
const escapeDataProviderId = path => path.replace(/\./g, '_');
exports.escapeDataProviderId = escapeDataProviderId;
const escapeContextId = path => path.replace(/\./g, '_');
exports.escapeContextId = escapeContextId;
const escapeFieldId = path => path.replace(/\./g, '!!!DOT!!!');
exports.escapeFieldId = escapeFieldId;
const unEscapeFieldId = path => path.replace(/!!!DOT!!!/g, '.');
exports.unEscapeFieldId = unEscapeFieldId;
const providerWasDroppedOnTimeline = result => reasonIsDrop(result) && draggableIsContent(result) && sourceIsContent(result) && destinationIsTimelineProviders(result);
exports.providerWasDroppedOnTimeline = providerWasDroppedOnTimeline;
const userIsReArrangingProviders = result => reasonIsDrop(result) && sourceAndDestinationAreSameTimelineProviders(result);
exports.userIsReArrangingProviders = userIsReArrangingProviders;
const fieldWasDroppedOnTimelineColumns = result => reasonIsDrop(result) && draggableIsField(result) && destinationIsTimelineColumns(result);

/**
 * Prevents fields from being dragged or dropped to any area other than column
 * header drop zone in the timeline
 */
exports.fieldWasDroppedOnTimelineColumns = fieldWasDroppedOnTimelineColumns;
const DRAG_TYPE_FIELD = 'drag-type-field';

/** This class is added to the document body while timeline field dragging */
exports.DRAG_TYPE_FIELD = DRAG_TYPE_FIELD;
const IS_TIMELINE_FIELD_DRAGGING_CLASS_NAME = 'is-timeline-field-dragging';
exports.IS_TIMELINE_FIELD_DRAGGING_CLASS_NAME = IS_TIMELINE_FIELD_DRAGGING_CLASS_NAME;