/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { fold } from 'fp-ts/lib/Either';
import { pipe } from 'fp-ts/lib/pipeable';
import { formatErrors } from '../format_errors';

/*
 * FUNFACT: These don't have tests as these are used within test utilities. However, I could see
 * someone adding tests. If one day we see these escape tests, then they should have unit tests.
 */

var onLeft = function onLeft(errors) {
  return {
    schema: {},
    errors: errors
  };
};
var onRight = function onRight(schema) {
  return {
    schema: schema,
    errors: []
  };
};
export var foldLeftRight = fold(onLeft, onRight);

/**
 * Convenience utility to keep the error message handling within tests to be
 * very concise.
 * @param validation The validation to get the errors from
 */
export var getPaths = function getPaths(validation) {
  return pipe(validation, fold(function (errors) {
    return formatErrors(errors);
  }, function () {
    return ['no errors'];
  }));
};

/**
 * Convenience utility to remove text appended to links by EUI
 */
export var removeExternalLinkText = function removeExternalLinkText(str) {
  return str.replace(/\(opens in a new tab or window\)/g, '');
};