/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { fromLiteralExpression } from '../ast/ast';
export var wildcardSymbol = '@kuery-wildcard@';

// Copied from https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_Expressions
function escapeRegExp(str) {
  return str.replace(/[.*+?^${}()|[\]\\]/g, '\\$&'); // $& means the whole matched string
}

// See https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-query-string-query.html#_reserved_characters
function escapeQueryString(str) {
  return str.replace(/[+\-=&|><!(){}[\]^"~*?:\\/]/g, '\\$&'); // $& means the whole matched string
}

export function buildNode(value) {
  if (!value.includes(wildcardSymbol)) {
    return fromLiteralExpression(value);
  }
  return {
    type: 'wildcard',
    value: value
  };
}
export function test(node, str) {
  var value = node.value;
  var regex = value.split(wildcardSymbol).map(escapeRegExp).join('[\\s\\S]*');
  var regexp = new RegExp("^".concat(regex, "$"));
  return regexp.test(str);
}
export function toElasticsearchQuery(node) {
  var value = node.value;
  return value.split(wildcardSymbol).join('*');
}
export function toQueryStringQuery(node) {
  var value = node.value;
  return value.split(wildcardSymbol).map(escapeQueryString).join('*');
}
export function hasLeadingWildcard(node) {
  var value = node.value;
  // A lone wildcard turns into an `exists` query, so we're only concerned with
  // leading wildcards followed by additional characters.
  return value.startsWith(wildcardSymbol) && value.replace(wildcardSymbol, '').length > 0;
}