"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rawConfigServiceMock = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createRawConfigServiceMock = ({
  rawConfig = {},
  rawConfig$ = undefined
} = {}) => {
  const mocked = {
    loadConfig: jest.fn(),
    stop: jest.fn(),
    reloadConfig: jest.fn(),
    getConfig$: jest.fn().mockReturnValue(rawConfig$ || (0, _rxjs.of)(rawConfig))
  };
  return mocked;
};
const rawConfigServiceMock = {
  create: createRawConfigServiceMock
};
exports.rawConfigServiceMock = rawConfigServiceMock;