import _objectSpread from "@babel/runtime/helpers/objectSpread2";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import moment from 'moment-timezone';
import { UnreachableCaseError, wrapArray } from './util';
import { ApplicationUsageTracker } from './application_usage_tracker';
import { METRIC_TYPE } from './metrics';
var REPORT_VERSION = 3;
export var ReportManager = /*#__PURE__*/function () {
  function ReportManager(report) {
    _classCallCheck(this, ReportManager);
    _defineProperty(this, "report", void 0);
    this.report = report || ReportManager.createReport();
  }
  _createClass(ReportManager, [{
    key: "clearReport",
    value: function clearReport() {
      this.report = ReportManager.createReport();
    }
  }, {
    key: "isReportEmpty",
    value: function isReportEmpty() {
      var _this$report = this.report,
        uiCounter = _this$report.uiCounter,
        userAgent = _this$report.userAgent,
        appUsage = _this$report.application_usage;
      var noUiCounters = !uiCounter || Object.keys(uiCounter).length === 0;
      var noUserAgents = !userAgent || Object.keys(userAgent).length === 0;
      var noAppUsage = !appUsage || Object.keys(appUsage).length === 0;
      return noUiCounters && noUserAgents && noAppUsage;
    }
  }, {
    key: "incrementTotal",
    value: function incrementTotal(count, currentTotal) {
      var currentTotalNumber = typeof currentTotal === 'number' ? currentTotal : 0;
      return count + currentTotalNumber;
    }
  }, {
    key: "assignReports",
    value: function assignReports(newMetrics) {
      var _this = this;
      wrapArray(newMetrics).forEach(function (newMetric) {
        return _this.assignReport(_this.report, newMetric);
      });
      return {
        report: this.report
      };
    }
  }, {
    key: "assignReport",
    value: function assignReport(report, metric) {
      var key = ReportManager.createMetricKey(metric);
      switch (metric.type) {
        case METRIC_TYPE.USER_AGENT:
          {
            var appName = metric.appName,
              type = metric.type,
              userAgent = metric.userAgent;
            if (userAgent) {
              report.userAgent = _defineProperty({}, key, {
                key: key,
                appName: appName,
                type: type,
                userAgent: metric.userAgent
              });
            }
            return;
          }
        case METRIC_TYPE.CLICK:
        case METRIC_TYPE.LOADED:
        case METRIC_TYPE.COUNT:
          {
            var _report$uiCounter$key;
            var _appName = metric.appName,
              _type = metric.type,
              eventName = metric.eventName,
              count = metric.count;
            report.uiCounter = report.uiCounter || {};
            var currentTotal = (_report$uiCounter$key = report.uiCounter[key]) === null || _report$uiCounter$key === void 0 ? void 0 : _report$uiCounter$key.total;
            report.uiCounter[key] = {
              key: key,
              appName: _appName,
              eventName: eventName,
              type: _type,
              total: this.incrementTotal(count, currentTotal)
            };
            return;
          }
        case METRIC_TYPE.APPLICATION_USAGE:
          {
            var numberOfClicks = metric.numberOfClicks,
              startTime = metric.startTime,
              appId = metric.appId,
              viewId = metric.viewId;
            var minutesOnScreen = moment().diff(startTime, 'minutes', true);
            report.application_usage = report.application_usage || {};
            var appExistingData = report.application_usage[key] || {
              minutesOnScreen: 0,
              numberOfClicks: 0,
              appId: appId,
              viewId: viewId
            };
            report.application_usage[key] = _objectSpread(_objectSpread({}, appExistingData), {}, {
              minutesOnScreen: appExistingData.minutesOnScreen + minutesOnScreen,
              numberOfClicks: appExistingData.numberOfClicks + numberOfClicks
            });
            return;
          }
        default:
          throw new UnreachableCaseError(metric);
      }
    }
  }], [{
    key: "createReport",
    value: function createReport() {
      return {
        reportVersion: REPORT_VERSION
      };
    }
  }, {
    key: "createMetricKey",
    value: function createMetricKey(metric) {
      switch (metric.type) {
        case METRIC_TYPE.USER_AGENT:
          {
            var appName = metric.appName,
              type = metric.type;
            return "".concat(appName, "-").concat(type);
          }
        case METRIC_TYPE.CLICK:
        case METRIC_TYPE.LOADED:
        case METRIC_TYPE.COUNT:
          {
            var _appName2 = metric.appName,
              eventName = metric.eventName,
              _type2 = metric.type;
            return "".concat(_appName2, "-").concat(_type2, "-").concat(eventName);
          }
        case METRIC_TYPE.APPLICATION_USAGE:
          {
            var appId = metric.appId,
              viewId = metric.viewId;
            return ApplicationUsageTracker.serializeKey({
              appId: appId,
              viewId: viewId
            });
          }
        default:
          throw new UnreachableCaseError(metric);
      }
    }
  }]);
  return ReportManager;
}();
_defineProperty(ReportManager, "REPORT_VERSION", REPORT_VERSION);