"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScaleBand = void 0;
var d3_scale_1 = require("d3-scale");
var common_1 = require("../utils/common");
var constants_1 = require("./constants");
var ScaleBand = (function () {
    function ScaleBand(inputDomain, range, overrideBandwidth, barsPadding) {
        if (barsPadding === void 0) { barsPadding = 0; }
        var isObjectPad = typeof barsPadding === 'object';
        var safeBarPadding = isObjectPad ? 0 : (0, common_1.clamp)(barsPadding, 0, 1);
        this.type = constants_1.ScaleType.Ordinal;
        this.d3Scale = (0, d3_scale_1.scaleBand)();
        this.d3Scale.domain(inputDomain.length > 0 ? inputDomain : [undefined]);
        this.d3Scale.range(range);
        this.d3Scale.paddingInner(isObjectPad ? barsPadding.inner : safeBarPadding);
        this.d3Scale.paddingOuter(isObjectPad ? barsPadding.outer : safeBarPadding / 2);
        this.barsPadding = isObjectPad ? barsPadding.inner : safeBarPadding;
        this.outerPadding = this.d3Scale.paddingOuter();
        this.innerPadding = this.d3Scale.paddingInner();
        this.bandwidth = overrideBandwidth ? overrideBandwidth * (1 - safeBarPadding) : this.d3Scale.bandwidth() || 0;
        this.originalBandwidth = this.d3Scale.bandwidth() || 0;
        this.step = this.d3Scale.step();
        this.domain = (inputDomain.length > 0 ? __spreadArray([], __read(new Set(inputDomain)), false) : [undefined]);
        this.range = range.slice();
        this.bandwidthPadding = this.bandwidth;
        this.isInverted = false;
        this.invertedScale = (0, d3_scale_1.scaleQuantize)()
            .domain(range)
            .range(inputDomain.length > 0 ? __spreadArray([], __read(new Set(inputDomain)), false) : [undefined]);
        this.minInterval = 0;
    }
    ScaleBand.prototype.scale = function (value) {
        var scaleValue = this.d3Scale((0, common_1.stringifyNullsUndefined)(value));
        return typeof scaleValue === 'number' && Number.isFinite(scaleValue) ? scaleValue : NaN;
    };
    ScaleBand.prototype.pureScale = function (value) {
        return this.scale(value);
    };
    ScaleBand.prototype.ticks = function () {
        return this.domain;
    };
    ScaleBand.prototype.invert = function (value) {
        return this.invertedScale(value);
    };
    ScaleBand.prototype.invertWithStep = function (value) {
        return {
            value: this.invertedScale(value),
            withinBandwidth: true,
        };
    };
    ScaleBand.prototype.isSingleValue = function () {
        return this.domain.length < 2;
    };
    ScaleBand.prototype.isValueInDomain = function (value) {
        return this.domain.includes(value);
    };
    return ScaleBand;
}());
exports.ScaleBand = ScaleBand;
//# sourceMappingURL=scale_band.js.map