"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.shapeViewModel = void 0;
function shapeViewModel(spec, theme, chartDimensions) {
    var width = chartDimensions.width, height = chartDimensions.height;
    var margin = theme.chartMargins;
    var innerWidth = width - margin.left - margin.right;
    var innerHeight = height - margin.top - margin.bottom;
    var chartCenter = {
        x: margin.left + innerWidth / 2,
        y: margin.top + innerHeight / 2,
    };
    var subtype = spec.subtype, base = spec.base, target = spec.target, actual = spec.actual, bands = spec.bands, ticks = spec.ticks, bandFillColor = spec.bandFillColor, tickValueFormatter = spec.tickValueFormatter, labelMajor = spec.labelMajor, labelMinor = spec.labelMinor, centralMajor = spec.centralMajor, centralMinor = spec.centralMinor, bandLabels = spec.bandLabels, angleStart = spec.angleStart, angleEnd = spec.angleEnd;
    var _a = __read(__spreadArray(__spreadArray(__spreadArray(__spreadArray([base], __read((target ? [target] : [])), false), [actual], false), __read(bands), false), __read(ticks), false).reduce(function (_a, value) {
        var _b = __read(_a, 2), min = _b[0], max = _b[1];
        return [Math.min(min, value), Math.max(max, value)];
    }, [Infinity, -Infinity]), 2), lowestValue = _a[0], highestValue = _a[1];
    var aboveBaseCount = bands.filter(function (b) { return b > base; }).length;
    var belowBaseCount = bands.filter(function (b) { return b <= base; }).length;
    var callbackArgs = {
        base: base,
        target: target,
        actual: actual,
        highestValue: highestValue,
        lowestValue: lowestValue,
        aboveBaseCount: aboveBaseCount,
        belowBaseCount: belowBaseCount,
    };
    var bulletViewModel = {
        subtype: subtype,
        base: base,
        target: target,
        actual: actual,
        bands: bands.map(function (value, index) { return ({
            value: value,
            fillColor: bandFillColor(__assign({ value: value, index: index }, callbackArgs)),
            text: bandLabels,
        }); }),
        ticks: ticks.map(function (value, index) { return ({
            value: value,
            text: tickValueFormatter(__assign({ value: value, index: index }, callbackArgs)),
        }); }),
        labelMajor: typeof labelMajor === 'string' ? labelMajor : labelMajor(__assign({ value: NaN, index: 0 }, callbackArgs)),
        labelMinor: typeof labelMinor === 'string' ? labelMinor : labelMinor(__assign({ value: NaN, index: 0 }, callbackArgs)),
        centralMajor: typeof centralMajor === 'string' ? centralMajor : centralMajor(__assign({ value: NaN, index: 0 }, callbackArgs)),
        centralMinor: typeof centralMinor === 'string' ? centralMinor : centralMinor(__assign({ value: NaN, index: 0 }, callbackArgs)),
        highestValue: highestValue,
        lowestValue: lowestValue,
        aboveBaseCount: aboveBaseCount,
        belowBaseCount: belowBaseCount,
        angleStart: angleStart,
        angleEnd: angleEnd,
    };
    var pickQuads = function (x, y) {
        return -innerWidth / 2 <= x && x <= innerWidth / 2 && -innerHeight / 2 <= y && y <= innerHeight / 2
            ? [bulletViewModel]
            : [];
    };
    return {
        config: theme.goal,
        chartCenter: chartCenter,
        bulletViewModel: bulletViewModel,
        pickQuads: pickQuads,
    };
}
exports.shapeViewModel = shapeViewModel;
//# sourceMappingURL=viewmodel.js.map