"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = registerRoutes;
exports.wrapError = wrapError;

var _boom = _interopRequireDefault(require("@hapi/boom"));

var _deprecations = require("./deprecations");

var _diagnostic = require("./diagnostic");

var _generate = require("./generate");

var _management = require("./management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */


function registerRoutes(reporting, logger) {
  (0, _deprecations.registerDeprecationsRoutes)(reporting, logger);
  (0, _diagnostic.registerDiagnosticRoutes)(reporting, logger);
  (0, _generate.registerGenerateCsvFromSavedObjectImmediate)(reporting, logger);
  (0, _generate.registerGenerateFromSavedObject)(reporting, logger);
  (0, _generate.registerJobGenerationRoutes)(reporting, logger);
  (0, _generate.registerLegacy)(reporting, logger);
  (0, _management.registerJobInfoRoutes)(reporting);
}

function wrapError(error) {
  const boom = _boom.default.isBoom(error) ? error : _boom.default.boomify(error, {
    statusCode: error.statusCode
  });
  return {
    body: boom,
    headers: boom.output.headers,
    statusCode: boom.output.statusCode
  };
}