"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSortForSearchSource = getSortForSearchSource;

var _get_sort = require("./get_sort");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This file was copied from
 * src/plugins/discover/public/application/apps/main/components/doc_table/lib/get_sort_for_search_source.ts
 */


function getSortForSearchSource(sort, indexPattern, defaultDirection = 'desc') {
  if (!sort || !indexPattern || Array.isArray(sort) && sort.length === 0) {
    if (indexPattern !== null && indexPattern !== void 0 && indexPattern.timeFieldName) {
      // sorting by index order
      return [{
        _doc: defaultDirection
      }];
    } else {
      return [{
        _score: defaultDirection
      }];
    }
  }

  const {
    timeFieldName
  } = indexPattern;
  return (0, _get_sort.getSort)(sort, indexPattern).map(sortPair => {
    if (indexPattern.isTimeNanosBased() && timeFieldName && sortPair[timeFieldName]) {
      return {
        [timeFieldName]: {
          order: sortPair[timeFieldName],
          numeric_type: 'date_nanos'
        }
      };
    }

    return sortPair;
  });
}