"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runTaskFnFactory = void 0;

var _common = require("../../../../../../src/plugins/data/common");

var _constants = require("../../../common/constants");

var _services = require("../../services");

var _common2 = require("../common");

var _generate_csv = require("../csv_searchsource/generate_csv");

var _lib = require("./lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */


function isSavedObject(savedSearch) {
  var _attributes, _attributes$kibanaSav;

  return (savedSearch === null || savedSearch === void 0 ? void 0 : (_attributes = savedSearch.attributes) === null || _attributes === void 0 ? void 0 : (_attributes$kibanaSav = _attributes.kibanaSavedObjectMeta) === null || _attributes$kibanaSav === void 0 ? void 0 : _attributes$kibanaSav.searchSourceJSON) != null;
}

const runTaskFnFactory = (reporting, _logger) => {
  const config = reporting.getConfig();
  return async function runTask(jobId, job, cancellationToken, stream) {
    var _savedSearch$referenc;

    const logger = _logger.clone([_constants.CSV_JOB_TYPE, 'execute-job', jobId]);

    const encryptionKey = config.get('encryptionKey');
    const headers = await (0, _common2.decryptJobHeaders)(encryptionKey, job.headers, logger);
    const fakeRequest = reporting.getFakeRequest({
      headers
    }, job.spaceId, logger);
    const uiSettings = await reporting.getUiSettingsClient(fakeRequest, logger);
    const savedObjects = await reporting.getSavedObjectsClient(fakeRequest);
    const dataPluginStart = await reporting.getDataService();
    const fieldFormatsRegistry = await (0, _services.getFieldFormats)().fieldFormatServiceFactory(uiSettings);
    const [es, searchSourceStart] = await Promise.all([(await reporting.getEsClient()).asScoped(fakeRequest), await dataPluginStart.search.searchSource.asScoped(fakeRequest)]);
    const clients = {
      uiSettings,
      data: dataPluginStart.search.asScoped(fakeRequest),
      es
    };
    const dependencies = {
      searchSourceStart,
      fieldFormatsRegistry
    }; // Get the Saved Search Fields object from ID

    const savedSearch = await savedObjects.get('search', job.savedObjectId);

    if (!isSavedObject(savedSearch)) {
      throw new Error(`Saved search object is not valid`);
    } // allowed to throw an Invalid JSON error if the JSON is not parseable.


    const searchSourceFields = (0, _common.parseSearchSourceJSON)(savedSearch.attributes.kibanaSavedObjectMeta.searchSourceJSON);
    const indexRefName = searchSourceFields.indexRefName;

    if (!indexRefName) {
      throw new Error(`Saved Search data is missing a reference to an Index Pattern!`);
    } // Inject references into the Saved Search Fields


    const searchSourceFieldsWithRefs = (0, _common.injectReferences)({ ...searchSourceFields,
      indexRefName
    }, (_savedSearch$referenc = savedSearch.references) !== null && _savedSearch$referenc !== void 0 ? _savedSearch$referenc : []); // Form the Saved Search attributes and SearchSource into a config that's compatible with CsvGenerator

    const {
      columns,
      searchSource
    } = await (0, _lib.getSharingData)({
      uiSettings
    }, await searchSourceStart.create(searchSourceFieldsWithRefs), savedSearch, job.timerange, job.state);
    const jobParamsCsv = { ...job,
      columns,
      searchSource
    };
    const csv = new _generate_csv.CsvGenerator(jobParamsCsv, config, clients, dependencies, cancellationToken, logger, stream);
    return await csv.generateData();
  };
};

exports.runTaskFnFactory = runTaskFnFactory;