"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractEntityAndBoundaryReferences = extractEntityAndBoundaryReferences;
exports.extractRefsFromGeoContainmentAlert = extractRefsFromGeoContainmentAlert;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// These definitions are dupes of the SO-types in stack_alerts/geo_containment
// There are not exported to avoid deep imports from stack_alerts plugins into here

const GEO_CONTAINMENT_ID = '.geo-containment';

function extractEntityAndBoundaryReferences(params) {
  const {
    indexId,
    boundaryIndexId,
    ...otherParams
  } = params;
  const indexRefNamePrefix = 'tracked_index_';
  const boundaryRefNamePrefix = 'boundary_index_'; // Since these are stack-alerts, we need to prefix with the `param:`-namespace

  const references = [{
    name: `param:${indexRefNamePrefix}${indexId}`,
    type: `index-pattern`,
    id: indexId
  }, {
    name: `param:${boundaryRefNamePrefix}${boundaryIndexId}`,
    type: 'index-pattern',
    id: boundaryIndexId
  }];
  return {
    params: { ...otherParams,
      indexRefName: `${indexRefNamePrefix}${indexId}`,
      boundaryIndexRefName: `${boundaryRefNamePrefix}${boundaryIndexId}`
    },
    references
  };
}

function extractRefsFromGeoContainmentAlert(doc) {
  if (doc.attributes.alertTypeId !== GEO_CONTAINMENT_ID) {
    return doc;
  }

  const {
    attributes: {
      params
    }
  } = doc;
  const {
    params: newParams,
    references
  } = extractEntityAndBoundaryReferences(params);
  return { ...doc,
    attributes: { ...doc.attributes,
      params: newParams
    },
    references: [...(doc.references || []), ...references]
  };
}