"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPickedShapes = void 0;
var create_selector_1 = require("../../../../state/create_selector");
var geometries_1 = require("./geometries");
var get_grid_full_height_1 = require("./get_grid_full_height");
function getCurrentPointerPosition(state) {
    return state.interactions.pointer.current.position;
}
exports.getPickedShapes = (0, create_selector_1.createCustomCachedSelector)([geometries_1.geometries, getCurrentPointerPosition, get_grid_full_height_1.getGridHeightParamsSelector], function (geoms, pointerPosition, gridParams) {
    var picker = geoms.pickQuads;
    var x = pointerPosition.x, y = pointerPosition.y;
    var pickedData = picker(x, y);
    return Array.isArray(pickedData)
        ? pickedData.filter(function (_a) {
            var y = _a.y;
            return y < gridParams.gridCellHeight * gridParams.pageSize;
        })
        : pickedData;
});
//# sourceMappingURL=picked_shapes.js.map