"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

Object.defineProperty(exports, "__esModule", {
  value: true
});

const synthetics_1 = require("@elastic/synthetics");

const utils_1 = require("../utils");

synthetics_1.journey('TlsFlyoutInAlertingApp', async ({
  page,
  params
}) => {
  synthetics_1.before(async () => {
    await utils_1.waitForLoadingToFinish({
      page
    });
  });
  const baseUrl = `${params.kibanaUrl}/app/management/insightsAndAlerting/triggersActions/rules`;
  synthetics_1.step('Go to Alerting app', async () => {
    await page.goto(`${baseUrl}`, {
      waitUntil: 'networkidle'
    });
    await utils_1.loginToKibana({
      page
    });
  });
  synthetics_1.step('Open tls alert flyout', async () => {
    await page.click(utils_1.byTestId('createFirstAlertButton'));
    await utils_1.waitForLoadingToFinish({
      page
    });
    await page.click(utils_1.byTestId('"xpack.uptime.alerts.tlsCertificate-SelectOption"'));
    await utils_1.waitForLoadingToFinish({
      page
    });
    await utils_1.assertText({
      page,
      text: 'has a certificate expiring within'
    });
  });
  synthetics_1.step('Tls alert flyout has setting values', async () => {
    await utils_1.assertText({
      page,
      text: '30 days'
    });
    await utils_1.assertText({
      page,
      text: '730 days'
    });
  });
});