"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.fieldsBeat=void 0;/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */ /* eslint-disable @typescript-eslint/naming-convention */const fieldsBeat={_id:{category:'base',description:'Each document has an _id that uniquely identifies it',example:'Y-6TfmcB0WOhS6qyMv3s',name:'_id',type:'keyword'},_index:{category:'base',description:'An index is like a ‘database’ in a relational database. It has a mapping which defines multiple types. An index is a logical namespace which maps to one or more primary shards and can have zero or more replica shards.',example:'auditbeat-8.0.0-2019.02.19-000001',name:'_index',type:'keyword'},'@timestamp':{category:'base',description:'Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.',example:'2016-05-23T08:05:34.853Z',name:'@timestamp',type:'date'},labels:{category:'base',description:'Custom key/value pairs. Can be used to add meta information to events. Should not contain nested objects. All values are stored as keyword. Example: `docker` and `k8s` labels.',example:'{"application": "foo-bar", "env": "production"}',name:'labels',type:'object'},message:{category:'base',description:'For log events the message field contains the log message, optimized for viewing in a log viewer. For structured logs without an original message field, other fields can be concatenated to form a human-readable summary of the event. If multiple messages exist, they can be combined into one message.',example:'Hello World',name:'message',type:'text'},tags:{category:'base',description:'List of keywords used to tag each event.',example:'["production", "env2"]',name:'tags',type:'keyword'},'agent.ephemeral_id':{category:'agent',description:'Ephemeral identifier of this agent (if one exists). This id normally changes across restarts, but `agent.id` does not.',example:'8a4f500f',name:'agent.ephemeral_id',type:'keyword'},'agent.id':{category:'agent',description:'Unique identifier of this agent (if one exists). Example: For Beats this would be beat.id.',example:'8a4f500d',name:'agent.id',type:'keyword'},'agent.name':{category:'agent',description:'Custom name of the agent. This is a name that can be given to an agent. This can be helpful if for example two Filebeat instances are running on the same host but a human readable separation is needed on which Filebeat instance data is coming from. If no name is given, the name is often left empty.',example:'foo',name:'agent.name',type:'keyword'},'agent.type':{category:'agent',description:'Type of the agent. The agent type stays always the same and should be given by the agent used. In case of Filebeat the agent would always be Filebeat also if two Filebeat instances are run on the same machine.',example:'filebeat',name:'agent.type',type:'keyword'},'agent.version':{category:'agent',description:'Version of the agent.',example:'6.0.0-rc2',name:'agent.version',type:'keyword'},'as.number':{category:'as',description:'Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.',example:15169,name:'as.number',type:'long'},'as.organization.name':{category:'as',description:'Organization name.',example:'Google LLC',name:'as.organization.name',type:'keyword'},'client.address':{category:'client',description:'Some event client addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.',name:'client.address',type:'keyword'},'client.as.number':{category:'client',description:'Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.',example:15169,name:'client.as.number',type:'long'},'client.as.organization.name':{category:'client',description:'Organization name.',example:'Google LLC',name:'client.as.organization.name',type:'keyword'},'client.bytes':{category:'client',description:'Bytes sent from the client to the server.',example:184,name:'client.bytes',type:'long',format:'bytes'},'client.domain':{category:'client',description:'Client domain.',name:'client.domain',type:'keyword'},'client.geo.city_name':{category:'client',description:'City name.',example:'Montreal',name:'client.geo.city_name',type:'keyword'},'client.geo.continent_name':{category:'client',description:'Name of the continent.',example:'North America',name:'client.geo.continent_name',type:'keyword'},'client.geo.country_iso_code':{category:'client',description:'Country ISO code.',example:'CA',name:'client.geo.country_iso_code',type:'keyword'},'client.geo.country_name':{category:'client',description:'Country name.',example:'Canada',name:'client.geo.country_name',type:'keyword'},'client.geo.location':{category:'client',description:'Longitude and latitude.',example:'{ "lon": -73.614830, "lat": 45.505918 }',name:'client.geo.location',type:'geo_point'},'client.geo.name':{category:'client',description:'User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.',example:'boston-dc',name:'client.geo.name',type:'keyword'},'client.geo.region_iso_code':{category:'client',description:'Region ISO code.',example:'CA-QC',name:'client.geo.region_iso_code',type:'keyword'},'client.geo.region_name':{category:'client',description:'Region name.',example:'Quebec',name:'client.geo.region_name',type:'keyword'},'client.ip':{category:'client',description:'IP address of the client. Can be one or multiple IPv4 or IPv6 addresses.',name:'client.ip',type:'ip'},'client.mac':{category:'client',description:'MAC address of the client.',name:'client.mac',type:'keyword'},'client.nat.ip':{category:'client',description:'Translated IP of source based NAT sessions (e.g. internal client to internet). Typically connections traversing load balancers, firewalls, or routers.',name:'client.nat.ip',type:'ip'},'client.nat.port':{category:'client',description:'Translated port of source based NAT sessions (e.g. internal client to internet). Typically connections traversing load balancers, firewalls, or routers.',name:'client.nat.port',type:'long',format:'string'},'client.packets':{category:'client',description:'Packets sent from the client to the server.',example:12,name:'client.packets',type:'long'},'client.port':{category:'client',description:'Port of the client.',name:'client.port',type:'long',format:'string'},'client.registered_domain':{category:'client',description:'The highest registered client domain, stripped of the subdomain. For example, the registered domain for "foo.google.com" is "google.com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".',example:'google.com',name:'client.registered_domain',type:'keyword'},'client.top_level_domain':{category:'client',description:'The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for google.com is "com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".',example:'co.uk',name:'client.top_level_domain',type:'keyword'},'client.user.domain':{category:'client',description:'Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name.',name:'client.user.domain',type:'keyword'},'client.user.email':{category:'client',description:'User email address.',name:'client.user.email',type:'keyword'},'client.user.full_name':{category:'client',description:"User's full name, if available.",example:'Albert Einstein',name:'client.user.full_name',type:'keyword'},'client.user.group.domain':{category:'client',description:'Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name.',name:'client.user.group.domain',type:'keyword'},'client.user.group.id':{category:'client',description:'Unique identifier for the group on the system/platform.',name:'client.user.group.id',type:'keyword'},'client.user.group.name':{category:'client',description:'Name of the group.',name:'client.user.group.name',type:'keyword'},'client.user.hash':{category:'client',description:'Unique user hash to correlate information for a user in anonymized form. Useful if `user.id` or `user.name` contain confidential information and cannot be used.',name:'client.user.hash',type:'keyword'},'client.user.id':{category:'client',description:'Unique identifiers of the user.',name:'client.user.id',type:'keyword'},'client.user.name':{category:'client',description:'Short name or login of the user.',example:'albert',name:'client.user.name',type:'keyword'},'cloud.account.id':{category:'cloud',description:'The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.',example:666777888999,name:'cloud.account.id',type:'keyword'},'cloud.availability_zone':{category:'cloud',description:'Availability zone in which this host is running.',example:'us-east-1c',name:'cloud.availability_zone',type:'keyword'},'cloud.instance.id':{category:'cloud',description:'Instance ID of the host machine.',example:'i-1234567890abcdef0',name:'cloud.instance.id',type:'keyword'},'cloud.instance.name':{category:'cloud',description:'Instance name of the host machine.',name:'cloud.instance.name',type:'keyword'},'cloud.machine.type':{category:'cloud',description:'Machine type of the host machine.',example:'t2.medium',name:'cloud.machine.type',type:'keyword'},'cloud.provider':{category:'cloud',description:'Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.',example:'aws',name:'cloud.provider',type:'keyword'},'cloud.region':{category:'cloud',description:'Region in which this host is running.',example:'us-east-1',name:'cloud.region',type:'keyword'},'code_signature.exists':{category:'code_signature',description:'Boolean to capture if a signature is present.',example:'true',name:'code_signature.exists',type:'boolean'},'code_signature.status':{category:'code_signature',description:'Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked.',example:'ERROR_UNTRUSTED_ROOT',name:'code_signature.status',type:'keyword'},'code_signature.subject_name':{category:'code_signature',description:'Subject name of the code signer',example:'Microsoft Corporation',name:'code_signature.subject_name',type:'keyword'},'code_signature.trusted':{category:'code_signature',description:'Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status.',example:'true',name:'code_signature.trusted',type:'boolean'},'code_signature.valid':{category:'code_signature',description:'Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked.',example:'true',name:'code_signature.valid',type:'boolean'},'container.id':{category:'container',description:'Unique container id.',name:'container.id',type:'keyword'},'container.image.name':{category:'container',description:'Name of the image the container was built on.',name:'container.image.name',type:'keyword'},'container.image.tag':{category:'container',description:'Container image tags.',name:'container.image.tag',type:'keyword'},'container.labels':{category:'container',description:'Image labels.',name:'container.labels',type:'object'},'container.name':{category:'container',description:'Container name.',name:'container.name',type:'keyword'},'container.runtime':{category:'container',description:'Runtime managing this container.',example:'docker',name:'container.runtime',type:'keyword'},'destination.address':{category:'destination',description:'Some event destination addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.',name:'destination.address',type:'keyword'},'destination.as.number':{category:'destination',description:'Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.',example:15169,name:'destination.as.number',type:'long'},'destination.as.organization.name':{category:'destination',description:'Organization name.',example:'Google LLC',name:'destination.as.organization.name',type:'keyword'},'destination.bytes':{category:'destination',description:'Bytes sent from the destination to the source.',example:184,name:'destination.bytes',type:'long',format:'bytes'},'destination.domain':{category:'destination',description:'Destination domain.',name:'destination.domain',type:'keyword'},'destination.geo.city_name':{category:'destination',description:'City name.',example:'Montreal',name:'destination.geo.city_name',type:'keyword'},'destination.geo.continent_name':{category:'destination',description:'Name of the continent.',example:'North America',name:'destination.geo.continent_name',type:'keyword'},'destination.geo.country_iso_code':{category:'destination',description:'Country ISO code.',example:'CA',name:'destination.geo.country_iso_code',type:'keyword'},'destination.geo.country_name':{category:'destination',description:'Country name.',example:'Canada',name:'destination.geo.country_name',type:'keyword'},'destination.geo.location':{category:'destination',description:'Longitude and latitude.',example:'{ "lon": -73.614830, "lat": 45.505918 }',name:'destination.geo.location',type:'geo_point'},'destination.geo.name':{category:'destination',description:'User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.',example:'boston-dc',name:'destination.geo.name',type:'keyword'},'destination.geo.region_iso_code':{category:'destination',description:'Region ISO code.',example:'CA-QC',name:'destination.geo.region_iso_code',type:'keyword'},'destination.geo.region_name':{category:'destination',description:'Region name.',example:'Quebec',name:'destination.geo.region_name',type:'keyword'},'destination.ip':{category:'destination',description:'IP address of the destination. Can be one or multiple IPv4 or IPv6 addresses.',name:'destination.ip',type:'ip'},'destination.mac':{category:'destination',description:'MAC address of the destination.',name:'destination.mac',type:'keyword'},'destination.nat.ip':{category:'destination',description:'Translated ip of destination based NAT sessions (e.g. internet to private DMZ) Typically used with load balancers, firewalls, or routers.',name:'destination.nat.ip',type:'ip'},'destination.nat.port':{category:'destination',description:'Port the source session is translated to by NAT Device. Typically used with load balancers, firewalls, or routers.',name:'destination.nat.port',type:'long',format:'string'},'destination.packets':{category:'destination',description:'Packets sent from the destination to the source.',example:12,name:'destination.packets',type:'long'},'destination.port':{category:'destination',description:'Port of the destination.',name:'destination.port',type:'long',format:'string'},'destination.registered_domain':{category:'destination',description:'The highest registered destination domain, stripped of the subdomain. For example, the registered domain for "foo.google.com" is "google.com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".',example:'google.com',name:'destination.registered_domain',type:'keyword'},'destination.top_level_domain':{category:'destination',description:'The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for google.com is "com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".',example:'co.uk',name:'destination.top_level_domain',type:'keyword'},'destination.user.domain':{category:'destination',description:'Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name.',name:'destination.user.domain',type:'keyword'},'destination.user.email':{category:'destination',description:'User email address.',name:'destination.user.email',type:'keyword'},'destination.user.full_name':{category:'destination',description:"User's full name, if available.",example:'Albert Einstein',name:'destination.user.full_name',type:'keyword'},'destination.user.group.domain':{category:'destination',description:'Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name.',name:'destination.user.group.domain',type:'keyword'},'destination.user.group.id':{category:'destination',description:'Unique identifier for the group on the system/platform.',name:'destination.user.group.id',type:'keyword'},'destination.user.group.name':{category:'destination',description:'Name of the group.',name:'destination.user.group.name',type:'keyword'},'destination.user.hash':{category:'destination',description:'Unique user hash to correlate information for a user in anonymized form. Useful if `user.id` or `user.name` contain confidential information and cannot be used.',name:'destination.user.hash',type:'keyword'},'destination.user.id':{category:'destination',description:'Unique identifiers of the user.',name:'destination.user.id',type:'keyword'},'destination.user.name':{category:'destination',description:'Short name or login of the user.',example:'albert',name:'destination.user.name',type:'keyword'},'dll.code_signature.exists':{category:'dll',description:'Boolean to capture if a signature is present.',example:'true',name:'dll.code_signature.exists',type:'boolean'},'dll.code_signature.status':{category:'dll',description:'Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked.',example:'ERROR_UNTRUSTED_ROOT',name:'dll.code_signature.status',type:'keyword'},'dll.code_signature.subject_name':{category:'dll',description:'Subject name of the code signer',example:'Microsoft Corporation',name:'dll.code_signature.subject_name',type:'keyword'},'dll.code_signature.trusted':{category:'dll',description:'Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status.',example:'true',name:'dll.code_signature.trusted',type:'boolean'},'dll.code_signature.valid':{category:'dll',description:'Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked.',example:'true',name:'dll.code_signature.valid',type:'boolean'},'dll.hash.md5':{category:'dll',description:'MD5 hash.',name:'dll.hash.md5',type:'keyword'},'dll.hash.sha1':{category:'dll',description:'SHA1 hash.',name:'dll.hash.sha1',type:'keyword'},'dll.hash.sha256':{category:'dll',description:'SHA256 hash.',name:'dll.hash.sha256',type:'keyword'},'dll.hash.sha512':{category:'dll',description:'SHA512 hash.',name:'dll.hash.sha512',type:'keyword'},'dll.name':{category:'dll',description:'Name of the library. This generally maps to the name of the file on disk.',example:'kernel32.dll',name:'dll.name',type:'keyword'},'dll.path':{category:'dll',description:'Full file path of the library.',example:'C:\\Windows\\System32\\kernel32.dll',name:'dll.path',type:'keyword'},'dll.pe.company':{category:'dll',description:'Internal company name of the file, provided at compile-time.',example:'Microsoft Corporation',name:'dll.pe.company',type:'keyword'},'dll.pe.description':{category:'dll',description:'Internal description of the file, provided at compile-time.',example:'Paint',name:'dll.pe.description',type:'keyword'},'dll.pe.file_version':{category:'dll',description:'Internal version of the file, provided at compile-time.',example:'6.3.9600.17415',name:'dll.pe.file_version',type:'keyword'},'dll.pe.original_file_name':{category:'dll',description:'Internal name of the file, provided at compile-time.',example:'MSPAINT.EXE',name:'dll.pe.original_file_name',type:'keyword'},'dll.pe.product':{category:'dll',description:'Internal product name of the file, provided at compile-time.',example:'Microsoft® Windows® Operating System',name:'dll.pe.product',type:'keyword'},'dns.answers':{category:'dns',description:'An array containing an object for each answer section returned by the server. The main keys that should be present in these objects are defined by ECS. Records that have more information may contain more keys than what ECS defines. Not all DNS data sources give all details about DNS answers. At minimum, answer objects must contain the `data` key. If more information is available, map as much of it to ECS as possible, and add any additional fields to the answer objects as custom fields.',name:'dns.answers',type:'object'},'dns.answers.class':{category:'dns',description:'The class of DNS data contained in this resource record.',example:'IN',name:'dns.answers.class',type:'keyword'},'dns.answers.data':{category:'dns',description:'The data describing the resource. The meaning of this data depends on the type and class of the resource record.',example:'10.10.10.10',name:'dns.answers.data',type:'keyword'},'dns.answers.name':{category:'dns',description:"The domain name to which this resource record pertains. If a chain of CNAME is being resolved, each answer's `name` should be the one that corresponds with the answer's `data`. It should not simply be the original `question.name` repeated.",example:'www.google.com',name:'dns.answers.name',type:'keyword'},'dns.answers.ttl':{category:'dns',description:'The time interval in seconds that this resource record may be cached before it should be discarded. Zero values mean that the data should not be cached.',example:180,name:'dns.answers.ttl',type:'long'},'dns.answers.type':{category:'dns',description:'The type of data contained in this resource record.',example:'CNAME',name:'dns.answers.type',type:'keyword'},'dns.header_flags':{category:'dns',description:'Array of 2 letter DNS header flags. Expected values are: AA, TC, RD, RA, AD, CD, DO.',example:'["RD","RA"]',name:'dns.header_flags',type:'keyword'},'dns.id':{category:'dns',description:'The DNS packet identifier assigned by the program that generated the query. The identifier is copied to the response.',example:62111,name:'dns.id',type:'keyword'},'dns.op_code':{category:'dns',description:'The DNS operation code that specifies the kind of query in the message. This value is set by the originator of a query and copied into the response.',example:'QUERY',name:'dns.op_code',type:'keyword'},'dns.question.class':{category:'dns',description:'The class of records being queried.',example:'IN',name:'dns.question.class',type:'keyword'},'dns.question.name':{category:'dns',description:'The name being queried. If the name field contains non-printable characters (below 32 or above 126), those characters should be represented as escaped base 10 integers (\\DDD). Back slashes and quotes should be escaped. Tabs, carriage returns, and line feeds should be converted to \\t, \\r, and \\n respectively.',example:'www.google.com',name:'dns.question.name',type:'keyword'},'dns.question.registered_domain':{category:'dns',description:'The highest registered domain, stripped of the subdomain. For example, the registered domain for "foo.google.com" is "google.com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".',example:'google.com',name:'dns.question.registered_domain',type:'keyword'},'dns.question.subdomain':{category:'dns',description:'The subdomain is all of the labels under the registered_domain. If the domain has multiple levels of subdomain, such as "sub2.sub1.example.com", the subdomain field should contain "sub2.sub1", with no trailing period.',example:'www',name:'dns.question.subdomain',type:'keyword'},'dns.question.top_level_domain':{category:'dns',description:'The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for google.com is "com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".',example:'co.uk',name:'dns.question.top_level_domain',type:'keyword'},'dns.question.type':{category:'dns',description:'The type of record being queried.',example:'AAAA',name:'dns.question.type',type:'keyword'},'dns.resolved_ip':{category:'dns',description:'Array containing all IPs seen in `answers.data`. The `answers` array can be difficult to use, because of the variety of data formats it can contain. Extracting all IP addresses seen in there to `dns.resolved_ip` makes it possible to index them as IP addresses, and makes them easier to visualize and query for.',example:'["10.10.10.10","10.10.10.11"]',name:'dns.resolved_ip',type:'ip'},'dns.response_code':{category:'dns',description:'The DNS response code.',example:'NOERROR',name:'dns.response_code',type:'keyword'},'dns.type':{category:'dns',description:'The type of DNS event captured, query or answer. If your source of DNS events only gives you DNS queries, you should only create dns events of type `dns.type:query`. If your source of DNS events gives you answers as well, you should create one event per query (optionally as soon as the query is seen). And a second event containing all query details as well as an array of answers.',example:'answer',name:'dns.type',type:'keyword'},'ecs.version':{category:'ecs',description:'ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.',example:'1.0.0',name:'ecs.version',type:'keyword'},'error.code':{category:'error',description:'Error code describing the error.',name:'error.code',type:'keyword'},'error.id':{category:'error',description:'Unique identifier for the error.',name:'error.id',type:'keyword'},'error.message':{category:'error',description:'Error message.',name:'error.message',type:'text'},'error.stack_trace':{category:'error',description:'The stack trace of this error in plain text.',name:'error.stack_trace',type:'keyword'},'error.type':{category:'error',description:'The type of the error, for example the class name of the exception.',example:'java.lang.NullPointerException',name:'error.type',type:'keyword'},'event.action':{category:'event',description:'The action captured by the event. This describes the information in the event. It is more specific than `event.category`. Examples are `group-add`, `process-started`, `file-created`. The value is normally defined by the implementer.',example:'user-password-change',name:'event.action',type:'keyword'},'event.category':{category:'event',description:'This is one of four ECS Categorization Fields, and indicates the second level in the ECS category hierarchy. `event.category` represents the "big buckets" of ECS categories. For example, filtering on `event.category:process` yields all events relating to process activity. This field is closely related to `event.type`, which is used as a subcategory. This field is an array. This will allow proper categorization of some events that fall in multiple categories.',example:'authentication',name:'event.category',type:'keyword'},'event.code':{category:'event',description:'Identification code for this event, if one exists. Some event sources use event codes to identify messages unambiguously, regardless of message language or wording adjustments over time. An example of this is the Windows Event ID.',example:4648,name:'event.code',type:'keyword'},'event.created':{category:'event',description:"event.created contains the date/time when the event was first read by an agent, or by your pipeline. This field is distinct from @timestamp in that @timestamp typically contain the time extracted from the original event. In most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source. In case the two timestamps are identical, @timestamp should be used.",example:'2016-05-23T08:05:34.857Z',name:'event.created',type:'date'},'event.dataset':{category:'event',description:"Name of the dataset. If an event source publishes more than one type of log or events (e.g. access log, error log), the dataset is used to specify which one the event comes from. It's recommended but not required to start the dataset name with the module name, followed by a dot, then the dataset name.",example:'apache.access',name:'event.dataset',type:'keyword'},'event.duration':{category:'event',description:'Duration of the event in nanoseconds. If event.start and event.end are known this value should be the difference between the end and start time.',name:'event.duration',type:'long',format:'duration'},'event.end':{category:'event',description:'event.end contains the date when the event ended or when the activity was last observed.',name:'event.end',type:'date'},'event.hash':{category:'event',description:'Hash (perhaps logstash fingerprint) of raw field to be able to demonstrate log integrity.',example:'123456789012345678901234567890ABCD',name:'event.hash',type:'keyword'},'event.id':{category:'event',description:'Unique ID to describe the event.',example:'8a4f500d',name:'event.id',type:'keyword'},'event.ingested':{category:'event',description:"Timestamp when an event arrived in the central data store. This is different from `@timestamp`, which is when the event originally occurred.  It's also different from `event.created`, which is meant to capture the first time an agent saw the event. In normal conditions, assuming no tampering, the timestamps should chronologically look like this: `@timestamp` < `event.created` < `event.ingested`.",example:'2016-05-23T08:05:35.101Z',name:'event.ingested',type:'date'},'event.kind':{category:'event',description:'This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data coming in at a regular interval or not.',example:'alert',name:'event.kind',type:'keyword'},'event.module':{category:'event',description:'Name of the module this data is coming from. If your monitoring agent supports the concept of modules or plugins to process events of a given source (e.g. Apache logs), `event.module` should contain the name of this module.',example:'apache',name:'event.module',type:'keyword'},'event.original':{category:'event',description:'Raw text message of entire event. Used to demonstrate log integrity. This field is not indexed and doc_values are disabled. It cannot be searched, but it can be retrieved from `_source`.',example:'Sep 19 08:26:10 host CEF:0&#124;Security&#124; threatmanager&#124;1.0&#124;100&#124; worm successfully stopped&#124;10&#124;src=10.0.0.1 dst=2.1.2.2spt=1232',name:'event.original',type:'keyword'},'event.outcome':{category:'event',description:'This is one of four ECS Categorization Fields, and indicates the lowest level in the ECS category hierarchy. `event.outcome` simply denotes whether the event represents a success or a failure from the perspective of the entity that produced the event. Note that when a single transaction is described in multiple events, each event may populate different values of `event.outcome`, according to their perspective. Also note that in the case of a compound event (a single event that contains multiple logical events), this field should be populated with the value that best captures the overall success or failure from the perspective of the event producer. Further note that not all events will have an associated outcome. For example, this field is generally not populated for metric events, events with `event.type:info`, or any events for which an outcome does not make logical sense.',example:'success',name:'event.outcome',type:'keyword'},'event.provider':{category:'event',description:'Source of the event. Event transports such as Syslog or the Windows Event Log typically mention the source of an event. It can be the name of the software that generated the event (e.g. Sysmon, httpd), or of a subsystem of the operating system (kernel, Microsoft-Windows-Security-Auditing).',example:'kernel',name:'event.provider',type:'keyword'},'event.reference':{category:'event',description:'Reference URL linking to additional information about this event. This URL links to a static definition of the this event. Alert events, indicated by `event.kind:alert`, are a common use case for this field.',example:'https://system.vendor.com/event/#0001234',name:'event.reference',type:'keyword'},'event.risk_score':{category:'event',description:"Risk score or priority of the event (e.g. security solutions). Use your system's original value here.",name:'event.risk_score',type:'float'},'event.risk_score_norm':{category:'event',description:'Normalized risk score or priority of the event, on a scale of 0 to 100. This is mainly useful if you use more than one system that assigns risk scores, and you want to see a normalized value across all systems.',name:'event.risk_score_norm',type:'float'},'event.sequence':{category:'event',description:'Sequence number of the event. The sequence number is a value published by some event sources, to make the exact ordering of events unambiguous, regardless of the timestamp precision.',name:'event.sequence',type:'long',format:'string'},'event.severity':{category:'event',description:"The numeric severity of the event according to your event source. What the different severity values mean can be different between sources and use cases. It's up to the implementer to make sure severities are consistent across events from the same source. The Syslog severity belongs in `log.syslog.severity.code`. `event.severity` is meant to represent the severity according to the event source (e.g. firewall, IDS). If the event source does not publish its own severity, you may optionally copy the `log.syslog.severity.code` to `event.severity`.",example:7,name:'event.severity',type:'long',format:'string'},'event.start':{category:'event',description:'event.start contains the date when the event started or when the activity was first observed.',name:'event.start',type:'date'},'event.timezone':{category:'event',description:'This field should be populated when the event\'s timestamp does not include timezone information already (e.g. default Syslog timestamps). It\'s optional otherwise. Acceptable timezone formats are: a canonical ID (e.g. "Europe/Amsterdam"), abbreviated (e.g. "EST") or an HH:mm differential (e.g. "-05:00").',name:'event.timezone',type:'keyword'},'event.type':{category:'event',description:'This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy. `event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization. This field is an array. This will allow proper categorization of some events that fall in multiple event types.',name:'event.type',type:'keyword'},'event.url':{category:'event',description:'URL linking to an external system to continue investigation of this event. This URL links to another system where in-depth investigation of the specific occurence of this event can take place. Alert events, indicated by `event.kind:alert`, are a common use case for this field.',example:'https://mysystem.mydomain.com/alert/5271dedb-f5b0-4218-87f0-4ac4870a38fe',name:'event.url',type:'keyword'},'file.accessed':{category:'file',description:'Last time the file was accessed. Note that not all filesystems keep track of access time.',name:'file.accessed',type:'date'},'file.attributes':{category:'file',description:"Array of file attributes. Attributes names will vary by platform. Here's a non-exhaustive list of values that are expected in this field: archive, compressed, directory, encrypted, execute, hidden, read, readonly, system, write.",example:'["readonly", "system"]',name:'file.attributes',type:'keyword'},'file.code_signature.exists':{category:'file',description:'Boolean to capture if a signature is present.',example:'true',name:'file.code_signature.exists',type:'boolean'},'file.code_signature.status':{category:'file',description:'Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked.',example:'ERROR_UNTRUSTED_ROOT',name:'file.code_signature.status',type:'keyword'},'file.code_signature.subject_name':{category:'file',description:'Subject name of the code signer',example:'Microsoft Corporation',name:'file.code_signature.subject_name',type:'keyword'},'file.code_signature.trusted':{category:'file',description:'Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status.',example:'true',name:'file.code_signature.trusted',type:'boolean'},'file.code_signature.valid':{category:'file',description:'Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked.',example:'true',name:'file.code_signature.valid',type:'boolean'},'file.created':{category:'file',description:'File creation time. Note that not all filesystems store the creation time.',name:'file.created',type:'date'},'file.ctime':{category:'file',description:'Last time the file attributes or metadata changed. Note that changes to the file content will update `mtime`. This implies `ctime` will be adjusted at the same time, since `mtime` is an attribute of the file.',name:'file.ctime',type:'date'},'file.device':{category:'file',description:'Device that is the source of the file.',example:'sda',name:'file.device',type:'keyword'},'file.directory':{category:'file',description:'Directory where the file is located. It should include the drive letter, when appropriate.',example:'/home/alice',name:'file.directory',type:'keyword'},'file.drive_letter':{category:'file',description:'Drive letter where the file is located. This field is only relevant on Windows. The value should be uppercase, and not include the colon.',example:'C',name:'file.drive_letter',type:'keyword'},'file.extension':{category:'file',description:'File extension.',example:'png',name:'file.extension',type:'keyword'},'file.gid':{category:'file',description:'Primary group ID (GID) of the file.',example:'1001',name:'file.gid',type:'keyword'},'file.group':{category:'file',description:'Primary group name of the file.',example:'alice',name:'file.group',type:'keyword'},'file.hash.md5':{category:'file',description:'MD5 hash.',name:'file.hash.md5',type:'keyword'},'file.hash.sha1':{category:'file',description:'SHA1 hash.',name:'file.hash.sha1',type:'keyword'},'file.hash.sha256':{category:'file',description:'SHA256 hash.',name:'file.hash.sha256',type:'keyword'},'file.hash.sha512':{category:'file',description:'SHA512 hash.',name:'file.hash.sha512',type:'keyword'},'file.inode':{category:'file',description:'Inode representing the file in the filesystem.',example:'256383',name:'file.inode',type:'keyword'},'file.mime_type':{category:'file',description:'MIME type should identify the format of the file or stream of bytes using https://www.iana.org/assignments/media-types/media-types.xhtml[IANA official types], where possible. When more than one type is applicable, the most specific type should be used.',name:'file.mime_type',type:'keyword'},'file.mode':{category:'file',description:'Mode of the file in octal representation.',example:'0640',name:'file.mode',type:'keyword'},'file.mtime':{category:'file',description:'Last time the file content was modified.',name:'file.mtime',type:'date'},'file.name':{category:'file',description:'Name of the file including the extension, without the directory.',example:'example.png',name:'file.name',type:'keyword'},'file.owner':{category:'file',description:"File owner's username.",example:'alice',name:'file.owner',type:'keyword'},'file.path':{category:'file',description:'Full path to the file, including the file name. It should include the drive letter, when appropriate.',example:'/home/alice/example.png',name:'file.path',type:'keyword'},'file.pe.company':{category:'file',description:'Internal company name of the file, provided at compile-time.',example:'Microsoft Corporation',name:'file.pe.company',type:'keyword'},'file.pe.description':{category:'file',description:'Internal description of the file, provided at compile-time.',example:'Paint',name:'file.pe.description',type:'keyword'},'file.pe.file_version':{category:'file',description:'Internal version of the file, provided at compile-time.',example:'6.3.9600.17415',name:'file.pe.file_version',type:'keyword'},'file.pe.original_file_name':{category:'file',description:'Internal name of the file, provided at compile-time.',example:'MSPAINT.EXE',name:'file.pe.original_file_name',type:'keyword'},'file.pe.product':{category:'file',description:'Internal product name of the file, provided at compile-time.',example:'Microsoft® Windows® Operating System',name:'file.pe.product',type:'keyword'},'file.size':{category:'file',description:'File size in bytes. Only relevant when `file.type` is "file".',example:16384,name:'file.size',type:'long'},'file.target_path':{category:'file',description:'Target path for symlinks.',name:'file.target_path',type:'keyword'},'file.type':{category:'file',description:'File type (file, dir, or symlink).',example:'file',name:'file.type',type:'keyword'},'file.uid':{category:'file',description:'The user ID (UID) or security identifier (SID) of the file owner.',example:'1001',name:'file.uid',type:'keyword'},'geo.city_name':{category:'geo',description:'City name.',example:'Montreal',name:'geo.city_name',type:'keyword'},'geo.continent_name':{category:'geo',description:'Name of the continent.',example:'North America',name:'geo.continent_name',type:'keyword'},'geo.country_iso_code':{category:'geo',description:'Country ISO code.',example:'CA',name:'geo.country_iso_code',type:'keyword'},'geo.country_name':{category:'geo',description:'Country name.',example:'Canada',name:'geo.country_name',type:'keyword'},'geo.location':{category:'geo',description:'Longitude and latitude.',example:'{ "lon": -73.614830, "lat": 45.505918 }',name:'geo.location',type:'geo_point'},'geo.name':{category:'geo',description:'User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.',example:'boston-dc',name:'geo.name',type:'keyword'},'geo.region_iso_code':{category:'geo',description:'Region ISO code.',example:'CA-QC',name:'geo.region_iso_code',type:'keyword'},'geo.region_name':{category:'geo',description:'Region name.',example:'Quebec',name:'geo.region_name',type:'keyword'},'group.domain':{category:'group',description:'Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name.',name:'group.domain',type:'keyword'},'group.id':{category:'group',description:'Unique identifier for the group on the system/platform.',name:'group.id',type:'keyword'},'group.name':{category:'group',description:'Name of the group.',name:'group.name',type:'keyword'},'hash.md5':{category:'hash',description:'MD5 hash.',name:'hash.md5',type:'keyword'},'hash.sha1':{category:'hash',description:'SHA1 hash.',name:'hash.sha1',type:'keyword'},'hash.sha256':{category:'hash',description:'SHA256 hash.',name:'hash.sha256',type:'keyword'},'hash.sha512':{category:'hash',description:'SHA512 hash.',name:'hash.sha512',type:'keyword'},'host.architecture':{category:'host',description:'Operating system architecture.',example:'x86_64',name:'host.architecture',type:'keyword'},'host.domain':{category:'host',description:"Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.",example:'CONTOSO',name:'host.domain',type:'keyword'},'host.geo.city_name':{category:'host',description:'City name.',example:'Montreal',name:'host.geo.city_name',type:'keyword'},'host.geo.continent_name':{category:'host',description:'Name of the continent.',example:'North America',name:'host.geo.continent_name',type:'keyword'},'host.geo.country_iso_code':{category:'host',description:'Country ISO code.',example:'CA',name:'host.geo.country_iso_code',type:'keyword'},'host.geo.country_name':{category:'host',description:'Country name.',example:'Canada',name:'host.geo.country_name',type:'keyword'},'host.geo.location':{category:'host',description:'Longitude and latitude.',example:'{ "lon": -73.614830, "lat": 45.505918 }',name:'host.geo.location',type:'geo_point'},'host.geo.name':{category:'host',description:'User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.',example:'boston-dc',name:'host.geo.name',type:'keyword'},'host.geo.region_iso_code':{category:'host',description:'Region ISO code.',example:'CA-QC',name:'host.geo.region_iso_code',type:'keyword'},'host.geo.region_name':{category:'host',description:'Region name.',example:'Quebec',name:'host.geo.region_name',type:'keyword'},'host.hostname':{category:'host',description:'Hostname of the host. It normally contains what the `hostname` command returns on the host machine.',name:'host.hostname',type:'keyword'},'host.id':{category:'host',description:'Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.',name:'host.id',type:'keyword'},'host.ip':{category:'host',description:'Host ip addresses.',name:'host.ip',type:'ip'},'host.mac':{category:'host',description:'Host mac addresses.',name:'host.mac',type:'keyword'},'host.name':{category:'host',description:'Name of the host. It can contain what `hostname` returns on Unix systems, the fully qualified domain name, or a name specified by the user. The sender decides which value to use.',name:'host.name',type:'keyword'},'host.os.family':{category:'host',description:'OS family (such as redhat, debian, freebsd, windows).',example:'debian',name:'host.os.family',type:'keyword'},'host.os.full':{category:'host',description:'Operating system name, including the version or code name.',example:'Mac OS Mojave',name:'host.os.full',type:'keyword'},'host.os.kernel':{category:'host',description:'Operating system kernel version as a raw string.',example:'4.4.0-112-generic',name:'host.os.kernel',type:'keyword'},'host.os.name':{category:'host',description:'Operating system name, without the version.',example:'Mac OS X',name:'host.os.name',type:'keyword'},'host.os.platform':{category:'host',description:'Operating system platform (such centos, ubuntu, windows).',example:'darwin',name:'host.os.platform',type:'keyword'},'host.os.version':{category:'host',description:'Operating system version as a raw string.',example:'10.14.1',name:'host.os.version',type:'keyword'},'host.type':{category:'host',description:'Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.',name:'host.type',type:'keyword'},'host.uptime':{category:'host',description:'Seconds the host has been up.',example:1325,name:'host.uptime',type:'long'},'host.user.domain':{category:'host',description:'Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name.',name:'host.user.domain',type:'keyword'},'host.user.email':{category:'host',description:'User email address.',name:'host.user.email',type:'keyword'},'host.user.full_name':{category:'host',description:"User's full name, if available.",example:'Albert Einstein',name:'host.user.full_name',type:'keyword'},'host.user.group.domain':{category:'host',description:'Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name.',name:'host.user.group.domain',type:'keyword'},'host.user.group.id':{category:'host',description:'Unique identifier for the group on the system/platform.',name:'host.user.group.id',type:'keyword'},'host.user.group.name':{category:'host',description:'Name of the group.',name:'host.user.group.name',type:'keyword'},'host.user.hash':{category:'host',description:'Unique user hash to correlate information for a user in anonymized form. Useful if `user.id` or `user.name` contain confidential information and cannot be used.',name:'host.user.hash',type:'keyword'},'host.user.id':{category:'host',description:'Unique identifiers of the user.',name:'host.user.id',type:'keyword'},'host.user.name':{category:'host',description:'Short name or login of the user.',example:'albert',name:'host.user.name',type:'keyword'},'http.request.body.bytes':{category:'http',description:'Size in bytes of the request body.',example:887,name:'http.request.body.bytes',type:'long',format:'bytes'},'http.request.body.content':{category:'http',description:'The full HTTP request body.',example:'Hello world',name:'http.request.body.content',type:'keyword'},'http.request.bytes':{category:'http',description:'Total size in bytes of the request (body and headers).',example:1437,name:'http.request.bytes',type:'long',format:'bytes'},'http.request.method':{category:'http',description:'HTTP request method. The field value must be normalized to lowercase for querying. See the documentation section "Implementing ECS".',example:'get, post, put',name:'http.request.method',type:'keyword'},'http.request.referrer':{category:'http',description:'Referrer for this HTTP request.',example:'https://blog.example.com/',name:'http.request.referrer',type:'keyword'},'http.response.body.bytes':{category:'http',description:'Size in bytes of the response body.',example:887,name:'http.response.body.bytes',type:'long',format:'bytes'},'http.response.body.content':{category:'http',description:'The full HTTP response body.',example:'Hello world',name:'http.response.body.content',type:'keyword'},'http.response.bytes':{category:'http',description:'Total size in bytes of the response (body and headers).',example:1437,name:'http.response.bytes',type:'long',format:'bytes'},'http.response.status_code':{category:'http',description:'HTTP response status code.',example:404,name:'http.response.status_code',type:'long',format:'string'},'http.version':{category:'http',description:'HTTP version.',example:1.1,name:'http.version',type:'keyword'},'interface.alias':{category:'interface',description:'Interface alias as reported by the system, typically used in firewall implementations for e.g. inside, outside, or dmz logical interface naming.',example:'outside',name:'interface.alias',type:'keyword'},'interface.id':{category:'interface',description:'Interface ID as reported by an observer (typically SNMP interface ID).',example:10,name:'interface.id',type:'keyword'},'interface.name':{category:'interface',description:'Interface name as reported by the system.',example:'eth0',name:'interface.name',type:'keyword'},'log.level':{category:'log',description:"Original log level of the log event. If the source of the event provides a log level or textual severity, this is the one that goes in `log.level`. If your source doesn't specify one, you may put your event transport's severity here (e.g. Syslog severity). Some examples are `warn`, `err`, `i`, `informational`.",example:'error',name:'log.level',type:'keyword'},'log.logger':{category:'log',description:'The name of the logger inside an application. This is usually the name of the class which initialized the logger, or can be a custom name.',example:'org.elasticsearch.bootstrap.Bootstrap',name:'log.logger',type:'keyword'},'log.origin.file.line':{category:'log',description:'The line number of the file containing the source code which originated the log event.',example:42,name:'log.origin.file.line',type:'integer'},'log.origin.file.name':{category:'log',description:'The name of the file containing the source code which originated the log event. Note that this is not the name of the log file.',example:'Bootstrap.java',name:'log.origin.file.name',type:'keyword'},'log.origin.function':{category:'log',description:'The name of the function or method which originated the log event.',example:'init',name:'log.origin.function',type:'keyword'},'log.original':{category:'log',description:"This is the original log message and contains the full log message before splitting it up in multiple parts. In contrast to the `message` field which can contain an extracted part of the log message, this field contains the original, full log message. It can have already some modifications applied like encoding or new lines removed to clean up the log message. This field is not indexed and doc_values are disabled so it can't be queried but the value can be retrieved from `_source`.",example:'Sep 19 08:26:10 localhost My log',name:'log.original',type:'keyword'},'log.syslog':{category:'log',description:'The Syslog metadata of the event, if the event was transmitted via Syslog. Please see RFCs 5424 or 3164.',name:'log.syslog',type:'object'},'log.syslog.facility.code':{category:'log',description:'The Syslog numeric facility of the log event, if available. According to RFCs 5424 and 3164, this value should be an integer between 0 and 23.',example:23,name:'log.syslog.facility.code',type:'long',format:'string'},'log.syslog.facility.name':{category:'log',description:'The Syslog text-based facility of the log event, if available.',example:'local7',name:'log.syslog.facility.name',type:'keyword'},'log.syslog.priority':{category:'log',description:'Syslog numeric priority of the event, if available. According to RFCs 5424 and 3164, the priority is 8 * facility + severity. This number is therefore expected to contain a value between 0 and 191.',example:135,name:'log.syslog.priority',type:'long',format:'string'},'log.syslog.severity.code':{category:'log',description:"The Syslog numeric severity of the log event, if available. If the event source publishing via Syslog provides a different numeric severity value (e.g. firewall, IDS), your source's numeric severity should go to `event.severity`. If the event source does not specify a distinct severity, you can optionally copy the Syslog severity to `event.severity`.",example:3,name:'log.syslog.severity.code',type:'long'},'log.syslog.severity.name':{category:'log',description:"The Syslog numeric severity of the log event, if available. If the event source publishing via Syslog provides a different severity value (e.g. firewall, IDS), your source's text severity should go to `log.level`. If the event source does not specify a distinct severity, you can optionally copy the Syslog severity to `log.level`.",example:'Error',name:'log.syslog.severity.name',type:'keyword'},'network.application':{category:'network',description:'A name given to an application level protocol. This can be arbitrarily assigned for things like microservices, but also apply to things like skype, icq, facebook, twitter. This would be used in situations where the vendor or service can be decoded such as from the source/dest IP owners, ports, or wire format. The field value must be normalized to lowercase for querying. See the documentation section "Implementing ECS".',example:'aim',name:'network.application',type:'keyword'},'network.bytes':{category:'network',description:'Total bytes transferred in both directions. If `source.bytes` and `destination.bytes` are known, `network.bytes` is their sum.',example:368,name:'network.bytes',type:'long',format:'bytes'},'network.community_id':{category:'network',description:'A hash of source and destination IPs and ports, as well as the protocol used in a communication. This is a tool-agnostic standard to identify flows. Learn more at https://github.com/corelight/community-id-spec.',example:'1:hO+sN4H+MG5MY/8hIrXPqc4ZQz0=',name:'network.community_id',type:'keyword'},'network.direction':{category:'network',description:"Direction of the network traffic. Recommended values are:   * inbound   * outbound   * internal   * external   * unknown  When mapping events from a host-based monitoring context, populate this field from the host's point of view. When mapping events from a network or perimeter-based monitoring context, populate this field from the point of view of your network perimeter.",example:'inbound',name:'network.direction',type:'keyword'},'network.forwarded_ip':{category:'network',description:'Host IP address when the source IP address is the proxy.',example:'192.1.1.2',name:'network.forwarded_ip',type:'ip'},'network.iana_number':{category:'network',description:'IANA Protocol Number (https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml). Standardized list of protocols. This aligns well with NetFlow and sFlow related logs which use the IANA Protocol Number.',example:6,name:'network.iana_number',type:'keyword'},'network.inner':{category:'network',description:'Network.inner fields are added in addition to network.vlan fields to describe  the innermost VLAN when q-in-q VLAN tagging is present. Allowed fields include  vlan.id and vlan.name. Inner vlan fields are typically used when sending traffic with multiple 802.1q encapsulations to a network sensor (e.g. Zeek, Wireshark.)',name:'network.inner',type:'object'},'network.inner.vlan.id':{category:'network',description:'VLAN ID as reported by the observer.',example:10,name:'network.inner.vlan.id',type:'keyword'},'network.inner.vlan.name':{category:'network',description:'Optional VLAN name as reported by the observer.',example:'outside',name:'network.inner.vlan.name',type:'keyword'},'network.name':{category:'network',description:'Name given by operators to sections of their network.',example:'Guest Wifi',name:'network.name',type:'keyword'},'network.packets':{category:'network',description:'Total packets transferred in both directions. If `source.packets` and `destination.packets` are known, `network.packets` is their sum.',example:24,name:'network.packets',type:'long'},'network.protocol':{category:'network',description:'L7 Network protocol name. ex. http, lumberjack, transport protocol. The field value must be normalized to lowercase for querying. See the documentation section "Implementing ECS".',example:'http',name:'network.protocol',type:'keyword'},'network.transport':{category:'network',description:'Same as network.iana_number, but instead using the Keyword name of the transport layer (udp, tcp, ipv6-icmp, etc.) The field value must be normalized to lowercase for querying. See the documentation section "Implementing ECS".',example:'tcp',name:'network.transport',type:'keyword'},'network.type':{category:'network',description:'In the OSI Model this would be the Network Layer. ipv4, ipv6, ipsec, pim, etc The field value must be normalized to lowercase for querying. See the documentation section "Implementing ECS".',example:'ipv4',name:'network.type',type:'keyword'},'network.vlan.id':{category:'network',description:'VLAN ID as reported by the observer.',example:10,name:'network.vlan.id',type:'keyword'},'network.vlan.name':{category:'network',description:'Optional VLAN name as reported by the observer.',example:'outside',name:'network.vlan.name',type:'keyword'},'observer.egress':{category:'observer',description:'Observer.egress holds information like interface number and name, vlan, and zone information to  classify egress traffic.  Single armed monitoring such as a network sensor on a span port should  only use observer.ingress to categorize traffic.',name:'observer.egress',type:'object'},'observer.egress.interface.alias':{category:'observer',description:'Interface alias as reported by the system, typically used in firewall implementations for e.g. inside, outside, or dmz logical interface naming.',example:'outside',name:'observer.egress.interface.alias',type:'keyword'},'observer.egress.interface.id':{category:'observer',description:'Interface ID as reported by an observer (typically SNMP interface ID).',example:10,name:'observer.egress.interface.id',type:'keyword'},'observer.egress.interface.name':{category:'observer',description:'Interface name as reported by the system.',example:'eth0',name:'observer.egress.interface.name',type:'keyword'},'observer.egress.vlan.id':{category:'observer',description:'VLAN ID as reported by the observer.',example:10,name:'observer.egress.vlan.id',type:'keyword'},'observer.egress.vlan.name':{category:'observer',description:'Optional VLAN name as reported by the observer.',example:'outside',name:'observer.egress.vlan.name',type:'keyword'},'observer.egress.zone':{category:'observer',description:'Network zone of outbound traffic as reported by the observer to categorize the destination area of egress  traffic, e.g. Internal, External, DMZ, HR, Legal, etc.',example:'Public_Internet',name:'observer.egress.zone',type:'keyword'},'observer.geo.city_name':{category:'observer',description:'City name.',example:'Montreal',name:'observer.geo.city_name',type:'keyword'},'observer.geo.continent_name':{category:'observer',description:'Name of the continent.',example:'North America',name:'observer.geo.continent_name',type:'keyword'},'observer.geo.country_iso_code':{category:'observer',description:'Country ISO code.',example:'CA',name:'observer.geo.country_iso_code',type:'keyword'},'observer.geo.country_name':{category:'observer',description:'Country name.',example:'Canada',name:'observer.geo.country_name',type:'keyword'},'observer.geo.location':{category:'observer',description:'Longitude and latitude.',example:'{ "lon": -73.614830, "lat": 45.505918 }',name:'observer.geo.location',type:'geo_point'},'observer.geo.name':{category:'observer',description:'User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.',example:'boston-dc',name:'observer.geo.name',type:'keyword'},'observer.geo.region_iso_code':{category:'observer',description:'Region ISO code.',example:'CA-QC',name:'observer.geo.region_iso_code',type:'keyword'},'observer.geo.region_name':{category:'observer',description:'Region name.',example:'Quebec',name:'observer.geo.region_name',type:'keyword'},'observer.hostname':{category:'observer',description:'Hostname of the observer.',name:'observer.hostname',type:'keyword'},'observer.ingress':{category:'observer',description:'Observer.ingress holds information like interface number and name, vlan, and zone information to  classify ingress traffic.  Single armed monitoring such as a network sensor on a span port should  only use observer.ingress to categorize traffic.',name:'observer.ingress',type:'object'},'observer.ingress.interface.alias':{category:'observer',description:'Interface alias as reported by the system, typically used in firewall implementations for e.g. inside, outside, or dmz logical interface naming.',example:'outside',name:'observer.ingress.interface.alias',type:'keyword'},'observer.ingress.interface.id':{category:'observer',description:'Interface ID as reported by an observer (typically SNMP interface ID).',example:10,name:'observer.ingress.interface.id',type:'keyword'},'observer.ingress.interface.name':{category:'observer',description:'Interface name as reported by the system.',example:'eth0',name:'observer.ingress.interface.name',type:'keyword'},'observer.ingress.vlan.id':{category:'observer',description:'VLAN ID as reported by the observer.',example:10,name:'observer.ingress.vlan.id',type:'keyword'},'observer.ingress.vlan.name':{category:'observer',description:'Optional VLAN name as reported by the observer.',example:'outside',name:'observer.ingress.vlan.name',type:'keyword'},'observer.ingress.zone':{category:'observer',description:'Network zone of incoming traffic as reported by the observer to categorize the source area of ingress  traffic. e.g. internal, External, DMZ, HR, Legal, etc.',example:'DMZ',name:'observer.ingress.zone',type:'keyword'},'observer.ip':{category:'observer',description:'IP addresses of the observer.',name:'observer.ip',type:'ip'},'observer.mac':{category:'observer',description:'MAC addresses of the observer',name:'observer.mac',type:'keyword'},'observer.name':{category:'observer',description:'Custom name of the observer. This is a name that can be given to an observer. This can be helpful for example if multiple firewalls of the same model are used in an organization. If no custom name is needed, the field can be left empty.',example:'1_proxySG',name:'observer.name',type:'keyword'},'observer.os.family':{category:'observer',description:'OS family (such as redhat, debian, freebsd, windows).',example:'debian',name:'observer.os.family',type:'keyword'},'observer.os.full':{category:'observer',description:'Operating system name, including the version or code name.',example:'Mac OS Mojave',name:'observer.os.full',type:'keyword'},'observer.os.kernel':{category:'observer',description:'Operating system kernel version as a raw string.',example:'4.4.0-112-generic',name:'observer.os.kernel',type:'keyword'},'observer.os.name':{category:'observer',description:'Operating system name, without the version.',example:'Mac OS X',name:'observer.os.name',type:'keyword'},'observer.os.platform':{category:'observer',description:'Operating system platform (such centos, ubuntu, windows).',example:'darwin',name:'observer.os.platform',type:'keyword'},'observer.os.version':{category:'observer',description:'Operating system version as a raw string.',example:'10.14.1',name:'observer.os.version',type:'keyword'},'observer.product':{category:'observer',description:'The product name of the observer.',example:'s200',name:'observer.product',type:'keyword'},'observer.serial_number':{category:'observer',description:'Observer serial number.',name:'observer.serial_number',type:'keyword'},'observer.type':{category:'observer',description:'The type of the observer the data is coming from. There is no predefined list of observer types. Some examples are `forwarder`, `firewall`, `ids`, `ips`, `proxy`, `poller`, `sensor`, `APM server`.',example:'firewall',name:'observer.type',type:'keyword'},'observer.vendor':{category:'observer',description:'Vendor name of the observer.',example:'Symantec',name:'observer.vendor',type:'keyword'},'observer.version':{category:'observer',description:'Observer version.',name:'observer.version',type:'keyword'},'organization.id':{category:'organization',description:'Unique identifier for the organization.',name:'organization.id',type:'keyword'},'organization.name':{category:'organization',description:'Organization name.',name:'organization.name',type:'keyword'},'os.family':{category:'os',description:'OS family (such as redhat, debian, freebsd, windows).',example:'debian',name:'os.family',type:'keyword'},'os.full':{category:'os',description:'Operating system name, including the version or code name.',example:'Mac OS Mojave',name:'os.full',type:'keyword'},'os.kernel':{category:'os',description:'Operating system kernel version as a raw string.',example:'4.4.0-112-generic',name:'os.kernel',type:'keyword'},'os.name':{category:'os',description:'Operating system name, without the version.',example:'Mac OS X',name:'os.name',type:'keyword'},'os.platform':{category:'os',description:'Operating system platform (such centos, ubuntu, windows).',example:'darwin',name:'os.platform',type:'keyword'},'os.version':{category:'os',description:'Operating system version as a raw string.',example:'10.14.1',name:'os.version',type:'keyword'},'package.architecture':{category:'package',description:'Package architecture.',example:'x86_64',name:'package.architecture',type:'keyword'},'package.build_version':{category:'package',description:'Additional information about the build version of the installed package. For example use the commit SHA of a non-released package.',example:'36f4f7e89dd61b0988b12ee000b98966867710cd',name:'package.build_version',type:'keyword'},'package.checksum':{category:'package',description:'Checksum of the installed package for verification.',example:'68b329da9893e34099c7d8ad5cb9c940',name:'package.checksum',type:'keyword'},'package.description':{category:'package',description:'Description of the package.',example:'Open source programming language to build simple/reliable/efficient software.',name:'package.description',type:'keyword'},'package.install_scope':{category:'package',description:'Indicating how the package was installed, e.g. user-local, global.',example:'global',name:'package.install_scope',type:'keyword'},'package.installed':{category:'package',description:'Time when package was installed.',name:'package.installed',type:'date'},'package.license':{category:'package',description:'License under which the package was released. Use a short name, e.g. the license identifier from SPDX License List where possible (https://spdx.org/licenses/).',example:'Apache License 2.0',name:'package.license',type:'keyword'},'package.name':{category:'package',description:'Package name',example:'go',name:'package.name',type:'keyword'},'package.path':{category:'package',description:'Path where the package is installed.',example:'/usr/local/Cellar/go/1.12.9/',name:'package.path',type:'keyword'},'package.reference':{category:'package',description:'Home page or reference URL of the software in this package, if available.',example:'https://golang.org',name:'package.reference',type:'keyword'},'package.size':{category:'package',description:'Package size in bytes.',example:62231,name:'package.size',type:'long',format:'string'},'package.type':{category:'package',description:'Type of package. This should contain the package file type, rather than the package manager name. Examples: rpm, dpkg, brew, npm, gem, nupkg, jar.',example:'rpm',name:'package.type',type:'keyword'},'package.version':{category:'package',description:'Package version',example:'1.12.9',name:'package.version',type:'keyword'},'pe.company':{category:'pe',description:'Internal company name of the file, provided at compile-time.',example:'Microsoft Corporation',name:'pe.company',type:'keyword'},'pe.description':{category:'pe',description:'Internal description of the file, provided at compile-time.',example:'Paint',name:'pe.description',type:'keyword'},'pe.file_version':{category:'pe',description:'Internal version of the file, provided at compile-time.',example:'6.3.9600.17415',name:'pe.file_version',type:'keyword'},'pe.original_file_name':{category:'pe',description:'Internal name of the file, provided at compile-time.',example:'MSPAINT.EXE',name:'pe.original_file_name',type:'keyword'},'pe.product':{category:'pe',description:'Internal product name of the file, provided at compile-time.',example:'Microsoft® Windows® Operating System',name:'pe.product',type:'keyword'},'process.args':{category:'process',description:'Array of process arguments, starting with the absolute path to the executable. May be filtered to protect sensitive information.',example:'["/usr/bin/ssh","-l","user","10.0.0.16"]',name:'process.args',type:'keyword'},'process.args_count':{category:'process',description:'Length of the process.args array. This field can be useful for querying or performing bucket analysis on how many arguments were provided to start a process. More arguments may be an indication of suspicious activity.',example:4,name:'process.args_count',type:'long'},'process.code_signature.exists':{category:'process',description:'Boolean to capture if a signature is present.',example:'true',name:'process.code_signature.exists',type:'boolean'},'process.code_signature.status':{category:'process',description:'Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked.',example:'ERROR_UNTRUSTED_ROOT',name:'process.code_signature.status',type:'keyword'},'process.code_signature.subject_name':{category:'process',description:'Subject name of the code signer',example:'Microsoft Corporation',name:'process.code_signature.subject_name',type:'keyword'},'process.code_signature.trusted':{category:'process',description:'Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status.',example:'true',name:'process.code_signature.trusted',type:'boolean'},'process.code_signature.valid':{category:'process',description:'Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked.',example:'true',name:'process.code_signature.valid',type:'boolean'},'process.command_line':{category:'process',description:'Full command line that started the process, including the absolute path to the executable, and all arguments. Some arguments may be filtered to protect sensitive information.',example:'/usr/bin/ssh -l user 10.0.0.16',name:'process.command_line',type:'keyword'},'process.entity_id':{category:'process',description:'Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts.',example:'c2c455d9f99375d',name:'process.entity_id',type:'keyword'},'process.executable':{category:'process',description:'Absolute path to the process executable.',example:'/usr/bin/ssh',name:'process.executable',type:'keyword'},'process.exit_code':{category:'process',description:'The exit code of the process, if this is a termination event. The field should be absent if there is no exit code for the event (e.g. process start).',example:137,name:'process.exit_code',type:'long'},'process.hash.md5':{category:'process',description:'MD5 hash.',name:'process.hash.md5',type:'keyword'},'process.hash.sha1':{category:'process',description:'SHA1 hash.',name:'process.hash.sha1',type:'keyword'},'process.hash.sha256':{category:'process',description:'SHA256 hash.',name:'process.hash.sha256',type:'keyword'},'process.hash.sha512':{category:'process',description:'SHA512 hash.',name:'process.hash.sha512',type:'keyword'},'process.name':{category:'process',description:'Process name. Sometimes called program name or similar.',example:'ssh',name:'process.name',type:'keyword'},'process.parent.args':{category:'process',description:'Array of process arguments. May be filtered to protect sensitive information.',example:'["ssh","-l","user","10.0.0.16"]',name:'process.parent.args',type:'keyword'},'process.parent.args_count':{category:'process',description:'Length of the process.args array. This field can be useful for querying or performing bucket analysis on how many arguments were provided to start a process. More arguments may be an indication of suspicious activity.',example:4,name:'process.parent.args_count',type:'long'},'process.parent.code_signature.exists':{category:'process',description:'Boolean to capture if a signature is present.',example:'true',name:'process.parent.code_signature.exists',type:'boolean'},'process.parent.code_signature.status':{category:'process',description:'Additional information about the certificate status. This is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked.',example:'ERROR_UNTRUSTED_ROOT',name:'process.parent.code_signature.status',type:'keyword'},'process.parent.code_signature.subject_name':{category:'process',description:'Subject name of the code signer',example:'Microsoft Corporation',name:'process.parent.code_signature.subject_name',type:'keyword'},'process.parent.code_signature.trusted':{category:'process',description:'Stores the trust status of the certificate chain. Validating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status.',example:'true',name:'process.parent.code_signature.trusted',type:'boolean'},'process.parent.code_signature.valid':{category:'process',description:'Boolean to capture if the digital signature is verified against the binary content. Leave unpopulated if a certificate was unchecked.',example:'true',name:'process.parent.code_signature.valid',type:'boolean'},'process.parent.command_line':{category:'process',description:'Full command line that started the process, including the absolute path to the executable, and all arguments. Some arguments may be filtered to protect sensitive information.',example:'/usr/bin/ssh -l user 10.0.0.16',name:'process.parent.command_line',type:'keyword'},'process.parent.entity_id':{category:'process',description:'Unique identifier for the process. The implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process. Constructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts.',example:'c2c455d9f99375d',name:'process.parent.entity_id',type:'keyword'},'process.parent.executable':{category:'process',description:'Absolute path to the process executable.',example:'/usr/bin/ssh',name:'process.parent.executable',type:'keyword'},'process.parent.exit_code':{category:'process',description:'The exit code of the process, if this is a termination event. The field should be absent if there is no exit code for the event (e.g. process start).',example:137,name:'process.parent.exit_code',type:'long'},'process.parent.hash.md5':{category:'process',description:'MD5 hash.',name:'process.parent.hash.md5',type:'keyword'},'process.parent.hash.sha1':{category:'process',description:'SHA1 hash.',name:'process.parent.hash.sha1',type:'keyword'},'process.parent.hash.sha256':{category:'process',description:'SHA256 hash.',name:'process.parent.hash.sha256',type:'keyword'},'process.parent.hash.sha512':{category:'process',description:'SHA512 hash.',name:'process.parent.hash.sha512',type:'keyword'},'process.parent.name':{category:'process',description:'Process name. Sometimes called program name or similar.',example:'ssh',name:'process.parent.name',type:'keyword'},'process.parent.pgid':{category:'process',description:'Identifier of the group of processes the process belongs to.',name:'process.parent.pgid',type:'long',format:'string'},'process.parent.pid':{category:'process',description:'Process id.',example:4242,name:'process.parent.pid',type:'long',format:'string'},'process.parent.ppid':{category:'process',description:"Parent process' pid.",example:4241,name:'process.parent.ppid',type:'long',format:'string'},'process.parent.start':{category:'process',description:'The time the process started.',example:'2016-05-23T08:05:34.853Z',name:'process.parent.start',type:'date'},'process.parent.thread.id':{category:'process',description:'Thread ID.',example:4242,name:'process.parent.thread.id',type:'long',format:'string'},'process.parent.thread.name':{category:'process',description:'Thread name.',example:'thread-0',name:'process.parent.thread.name',type:'keyword'},'process.parent.title':{category:'process',description:'Process title. The proctitle, some times the same as process name. Can also be different: for example a browser setting its title to the web page currently opened.',name:'process.parent.title',type:'keyword'},'process.parent.uptime':{category:'process',description:'Seconds the process has been up.',example:1325,name:'process.parent.uptime',type:'long'},'process.parent.working_directory':{category:'process',description:'The working directory of the process.',example:'/home/alice',name:'process.parent.working_directory',type:'keyword'},'process.pe.company':{category:'process',description:'Internal company name of the file, provided at compile-time.',example:'Microsoft Corporation',name:'process.pe.company',type:'keyword'},'process.pe.description':{category:'process',description:'Internal description of the file, provided at compile-time.',example:'Paint',name:'process.pe.description',type:'keyword'},'process.pe.file_version':{category:'process',description:'Internal version of the file, provided at compile-time.',example:'6.3.9600.17415',name:'process.pe.file_version',type:'keyword'},'process.pe.original_file_name':{category:'process',description:'Internal name of the file, provided at compile-time.',example:'MSPAINT.EXE',name:'process.pe.original_file_name',type:'keyword'},'process.pe.product':{category:'process',description:'Internal product name of the file, provided at compile-time.',example:'Microsoft® Windows® Operating System',name:'process.pe.product',type:'keyword'},'process.pgid':{category:'process',description:'Identifier of the group of processes the process belongs to.',name:'process.pgid',type:'long',format:'string'},'process.pid':{category:'process',description:'Process id.',example:4242,name:'process.pid',type:'long',format:'string'},'process.ppid':{category:'process',description:"Parent process' pid.",example:4241,name:'process.ppid',type:'long',format:'string'},'process.start':{category:'process',description:'The time the process started.',example:'2016-05-23T08:05:34.853Z',name:'process.start',type:'date'},'process.thread.id':{category:'process',description:'Thread ID.',example:4242,name:'process.thread.id',type:'long',format:'string'},'process.thread.name':{category:'process',description:'Thread name.',example:'thread-0',name:'process.thread.name',type:'keyword'},'process.title':{category:'process',description:'Process title. The proctitle, some times the same as process name. Can also be different: for example a browser setting its title to the web page currently opened.',name:'process.title',type:'keyword'},'process.uptime':{category:'process',description:'Seconds the process has been up.',example:1325,name:'process.uptime',type:'long'},'process.working_directory':{category:'process',description:'The working directory of the process.',example:'/home/alice',name:'process.working_directory',type:'keyword'},'registry.data.bytes':{category:'registry',description:'Original bytes written with base64 encoding. For Windows registry operations, such as SetValueEx and RegQueryValueEx, this corresponds to the data pointed by `lp_data`. This is optional but provides better recoverability and should be populated for REG_BINARY encoded values.',example:'ZQBuAC0AVQBTAAAAZQBuAAAAAAA=',name:'registry.data.bytes',type:'keyword'},'registry.data.strings':{category:'registry',description:'Content when writing string types. Populated as an array when writing string data to the registry. For single string registry types (REG_SZ, REG_EXPAND_SZ), this should be an array with one string. For sequences of string with REG_MULTI_SZ, this array will be variable length. For numeric data, such as REG_DWORD and REG_QWORD, this should be populated with the decimal representation (e.g `"1"`).',example:'["C:\\rta\\red_ttp\\bin\\myapp.exe"]',name:'registry.data.strings',type:'keyword'},'registry.data.type':{category:'registry',description:'Standard registry type for encoding contents',example:'REG_SZ',name:'registry.data.type',type:'keyword'},'registry.hive':{category:'registry',description:'Abbreviated name for the hive.',example:'HKLM',name:'registry.hive',type:'keyword'},'registry.key':{category:'registry',description:'Hive-relative path of keys.',example:'SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Image File Execution Options\\winword.exe',name:'registry.key',type:'keyword'},'registry.path':{category:'registry',description:'Full path, including hive, key and value',example:'HKLM\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Image File Execution Options\\winword.exe\\Debugger',name:'registry.path',type:'keyword'},'registry.value':{category:'registry',description:'Name of the value written.',example:'Debugger',name:'registry.value',type:'keyword'},'related.hash':{category:'related',description:"All the hashes seen on your event. Populating this field, then using it to search for hashes can help in situations where you're unsure what the hash algorithm is (and therefore which key name to search).",name:'related.hash',type:'keyword'},'related.ip':{category:'related',description:'All of the IPs seen on your event.',name:'related.ip',type:'ip'},'related.user':{category:'related',description:'All the user names seen on your event.',name:'related.user',type:'keyword'},'rule.author':{category:'rule',description:'Name, organization, or pseudonym of the author or authors who created the rule used to generate this event.',example:'["Star-Lord"]',name:'rule.author',type:'keyword'},'rule.category':{category:'rule',description:'A categorization value keyword used by the entity using the rule for detection of this event.',example:'Attempted Information Leak',name:'rule.category',type:'keyword'},'rule.description':{category:'rule',description:'The description of the rule generating the event.',example:'Block requests to public DNS over HTTPS / TLS protocols',name:'rule.description',type:'keyword'},'rule.id':{category:'rule',description:'A rule ID that is unique within the scope of an agent, observer, or other entity using the rule for detection of this event.',example:101,name:'rule.id',type:'keyword'},'rule.license':{category:'rule',description:'Name of the license under which the rule used to generate this event is made available.',example:'Apache 2.0',name:'rule.license',type:'keyword'},'rule.name':{category:'rule',description:'The name of the rule or signature generating the event.',example:'BLOCK_DNS_over_TLS',name:'rule.name',type:'keyword'},'rule.reference':{category:'rule',description:"Reference URL to additional information about the rule used to generate this event. The URL can point to the vendor's documentation about the rule. If that's not available, it can also be a link to a more general page describing this type of alert.",example:'https://en.wikipedia.org/wiki/DNS_over_TLS',name:'rule.reference',type:'keyword'},'rule.ruleset':{category:'rule',description:'Name of the ruleset, policy, group, or parent category in which the rule used to generate this event is a member.',example:'Standard_Protocol_Filters',name:'rule.ruleset',type:'keyword'},'rule.uuid':{category:'rule',description:'A rule ID that is unique within the scope of a set or group of agents, observers, or other entities using the rule for detection of this event.',example:1100110011,name:'rule.uuid',type:'keyword'},'rule.version':{category:'rule',description:'The version / revision of the rule being used for analysis.',example:1.1,name:'rule.version',type:'keyword'},'server.address':{category:'server',description:'Some event server addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.',name:'server.address',type:'keyword'},'server.as.number':{category:'server',description:'Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.',example:15169,name:'server.as.number',type:'long'},'server.as.organization.name':{category:'server',description:'Organization name.',example:'Google LLC',name:'server.as.organization.name',type:'keyword'},'server.bytes':{category:'server',description:'Bytes sent from the server to the client.',example:184,name:'server.bytes',type:'long',format:'bytes'},'server.domain':{category:'server',description:'Server domain.',name:'server.domain',type:'keyword'},'server.geo.city_name':{category:'server',description:'City name.',example:'Montreal',name:'server.geo.city_name',type:'keyword'},'server.geo.continent_name':{category:'server',description:'Name of the continent.',example:'North America',name:'server.geo.continent_name',type:'keyword'},'server.geo.country_iso_code':{category:'server',description:'Country ISO code.',example:'CA',name:'server.geo.country_iso_code',type:'keyword'},'server.geo.country_name':{category:'server',description:'Country name.',example:'Canada',name:'server.geo.country_name',type:'keyword'},'server.geo.location':{category:'server',description:'Longitude and latitude.',example:'{ "lon": -73.614830, "lat": 45.505918 }',name:'server.geo.location',type:'geo_point'},'server.geo.name':{category:'server',description:'User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.',example:'boston-dc',name:'server.geo.name',type:'keyword'},'server.geo.region_iso_code':{category:'server',description:'Region ISO code.',example:'CA-QC',name:'server.geo.region_iso_code',type:'keyword'},'server.geo.region_name':{category:'server',description:'Region name.',example:'Quebec',name:'server.geo.region_name',type:'keyword'},'server.ip':{category:'server',description:'IP address of the server. Can be one or multiple IPv4 or IPv6 addresses.',name:'server.ip',type:'ip'},'server.mac':{category:'server',description:'MAC address of the server.',name:'server.mac',type:'keyword'},'server.nat.ip':{category:'server',description:'Translated ip of destination based NAT sessions (e.g. internet to private DMZ) Typically used with load balancers, firewalls, or routers.',name:'server.nat.ip',type:'ip'},'server.nat.port':{category:'server',description:'Translated port of destination based NAT sessions (e.g. internet to private DMZ) Typically used with load balancers, firewalls, or routers.',name:'server.nat.port',type:'long',format:'string'},'server.packets':{category:'server',description:'Packets sent from the server to the client.',example:12,name:'server.packets',type:'long'},'server.port':{category:'server',description:'Port of the server.',name:'server.port',type:'long',format:'string'},'server.registered_domain':{category:'server',description:'The highest registered server domain, stripped of the subdomain. For example, the registered domain for "foo.google.com" is "google.com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".',example:'google.com',name:'server.registered_domain',type:'keyword'},'server.top_level_domain':{category:'server',description:'The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for google.com is "com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".',example:'co.uk',name:'server.top_level_domain',type:'keyword'},'server.user.domain':{category:'server',description:'Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name.',name:'server.user.domain',type:'keyword'},'server.user.email':{category:'server',description:'User email address.',name:'server.user.email',type:'keyword'},'server.user.full_name':{category:'server',description:"User's full name, if available.",example:'Albert Einstein',name:'server.user.full_name',type:'keyword'},'server.user.group.domain':{category:'server',description:'Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name.',name:'server.user.group.domain',type:'keyword'},'server.user.group.id':{category:'server',description:'Unique identifier for the group on the system/platform.',name:'server.user.group.id',type:'keyword'},'server.user.group.name':{category:'server',description:'Name of the group.',name:'server.user.group.name',type:'keyword'},'server.user.hash':{category:'server',description:'Unique user hash to correlate information for a user in anonymized form. Useful if `user.id` or `user.name` contain confidential information and cannot be used.',name:'server.user.hash',type:'keyword'},'server.user.id':{category:'server',description:'Unique identifiers of the user.',name:'server.user.id',type:'keyword'},'server.user.name':{category:'server',description:'Short name or login of the user.',example:'albert',name:'server.user.name',type:'keyword'},'service.ephemeral_id':{category:'service',description:'Ephemeral identifier of this service (if one exists). This id normally changes across restarts, but `service.id` does not.',example:'8a4f500f',name:'service.ephemeral_id',type:'keyword'},'service.id':{category:'service',description:'Unique identifier of the running service. If the service is comprised of many nodes, the `service.id` should be the same for all nodes. This id should uniquely identify the service. This makes it possible to correlate logs and metrics for one specific service, no matter which particular node emitted the event. Note that if you need to see the events from one specific host of the service, you should filter on that `host.name` or `host.id` instead.',example:'d37e5ebfe0ae6c4972dbe9f0174a1637bb8247f6',name:'service.id',type:'keyword'},'service.name':{category:'service',description:'Name of the service data is collected from. The name of the service is normally user given. This allows for distributed services that run on multiple hosts to correlate the related instances based on the name. In the case of Elasticsearch the `service.name` could contain the cluster name. For Beats the `service.name` is by default a copy of the `service.type` field if no name is specified.',example:'elasticsearch-metrics',name:'service.name',type:'keyword'},'service.node.name':{category:'service',description:"Name of a service node. This allows for two nodes of the same service running on the same host to be differentiated. Therefore, `service.node.name` should typically be unique across nodes of a given service. In the case of Elasticsearch, the `service.node.name` could contain the unique node name within the Elasticsearch cluster. In cases where the service doesn't have the concept of a node name, the host name or container name can be used to distinguish running instances that make up this service. If those do not provide uniqueness (e.g. multiple instances of the service running on the same host) - the node name can be manually set.",example:'instance-0000000016',name:'service.node.name',type:'keyword'},'service.state':{category:'service',description:'Current state of the service.',name:'service.state',type:'keyword'},'service.type':{category:'service',description:'The type of the service data is collected from. The type can be used to group and correlate logs and metrics from one service type. Example: If logs or metrics are collected from Elasticsearch, `service.type` would be `elasticsearch`.',example:'elasticsearch',name:'service.type',type:'keyword'},'service.version':{category:'service',description:'Version of the service the data was collected from. This allows to look at a data set only for a specific version of a service.',example:'3.2.4',name:'service.version',type:'keyword'},'source.address':{category:'source',description:'Some event source addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.',name:'source.address',type:'keyword'},'source.as.number':{category:'source',description:'Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.',example:15169,name:'source.as.number',type:'long'},'source.as.organization.name':{category:'source',description:'Organization name.',example:'Google LLC',name:'source.as.organization.name',type:'keyword'},'source.bytes':{category:'source',description:'Bytes sent from the source to the destination.',example:184,name:'source.bytes',type:'long',format:'bytes'},'source.domain':{category:'source',description:'Source domain.',name:'source.domain',type:'keyword'},'source.geo.city_name':{category:'source',description:'City name.',example:'Montreal',name:'source.geo.city_name',type:'keyword'},'source.geo.continent_name':{category:'source',description:'Name of the continent.',example:'North America',name:'source.geo.continent_name',type:'keyword'},'source.geo.country_iso_code':{category:'source',description:'Country ISO code.',example:'CA',name:'source.geo.country_iso_code',type:'keyword'},'source.geo.country_name':{category:'source',description:'Country name.',example:'Canada',name:'source.geo.country_name',type:'keyword'},'source.geo.location':{category:'source',description:'Longitude and latitude.',example:'{ "lon": -73.614830, "lat": 45.505918 }',name:'source.geo.location',type:'geo_point'},'source.geo.name':{category:'source',description:'User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.',example:'boston-dc',name:'source.geo.name',type:'keyword'},'source.geo.region_iso_code':{category:'source',description:'Region ISO code.',example:'CA-QC',name:'source.geo.region_iso_code',type:'keyword'},'source.geo.region_name':{category:'source',description:'Region name.',example:'Quebec',name:'source.geo.region_name',type:'keyword'},'source.ip':{category:'source',description:'IP address of the source. Can be one or multiple IPv4 or IPv6 addresses.',name:'source.ip',type:'ip'},'source.mac':{category:'source',description:'MAC address of the source.',name:'source.mac',type:'keyword'},'source.nat.ip':{category:'source',description:'Translated ip of source based NAT sessions (e.g. internal client to internet) Typically connections traversing load balancers, firewalls, or routers.',name:'source.nat.ip',type:'ip'},'source.nat.port':{category:'source',description:'Translated port of source based NAT sessions. (e.g. internal client to internet) Typically used with load balancers, firewalls, or routers.',name:'source.nat.port',type:'long',format:'string'},'source.packets':{category:'source',description:'Packets sent from the source to the destination.',example:12,name:'source.packets',type:'long'},'source.port':{category:'source',description:'Port of the source.',name:'source.port',type:'long',format:'string'},'source.registered_domain':{category:'source',description:'The highest registered source domain, stripped of the subdomain. For example, the registered domain for "foo.google.com" is "google.com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".',example:'google.com',name:'source.registered_domain',type:'keyword'},'source.top_level_domain':{category:'source',description:'The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for google.com is "com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".',example:'co.uk',name:'source.top_level_domain',type:'keyword'},'source.user.domain':{category:'source',description:'Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name.',name:'source.user.domain',type:'keyword'},'source.user.email':{category:'source',description:'User email address.',name:'source.user.email',type:'keyword'},'source.user.full_name':{category:'source',description:"User's full name, if available.",example:'Albert Einstein',name:'source.user.full_name',type:'keyword'},'source.user.group.domain':{category:'source',description:'Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name.',name:'source.user.group.domain',type:'keyword'},'source.user.group.id':{category:'source',description:'Unique identifier for the group on the system/platform.',name:'source.user.group.id',type:'keyword'},'source.user.group.name':{category:'source',description:'Name of the group.',name:'source.user.group.name',type:'keyword'},'source.user.hash':{category:'source',description:'Unique user hash to correlate information for a user in anonymized form. Useful if `user.id` or `user.name` contain confidential information and cannot be used.',name:'source.user.hash',type:'keyword'},'source.user.id':{category:'source',description:'Unique identifiers of the user.',name:'source.user.id',type:'keyword'},'source.user.name':{category:'source',description:'Short name or login of the user.',example:'albert',name:'source.user.name',type:'keyword'},'threat.framework':{category:'threat',description:'Name of the threat framework used to further categorize and classify the tactic and technique of the reported threat. Framework classification can be provided by detecting systems, evaluated at ingest time, or retrospectively tagged to events.',example:'MITRE ATT&CK',name:'threat.framework',type:'keyword'},'threat.tactic.id':{category:'threat',description:'The id of tactic used by this threat. You can use the Mitre ATT&CK Matrix Tactic categorization, for example. (ex. https://attack.mitre.org/tactics/TA0040/ )',example:'TA0040',name:'threat.tactic.id',type:'keyword'},'threat.tactic.name':{category:'threat',description:'Name of the type of tactic used by this threat. You can use the Mitre ATT&CK Matrix Tactic categorization, for example. (ex. https://attack.mitre.org/tactics/TA0040/ )',example:'impact',name:'threat.tactic.name',type:'keyword'},'threat.tactic.reference':{category:'threat',description:'The reference url of tactic used by this threat. You can use the Mitre ATT&CK Matrix Tactic categorization, for example. (ex. https://attack.mitre.org/tactics/TA0040/ )',example:'https://attack.mitre.org/tactics/TA0040/',name:'threat.tactic.reference',type:'keyword'},'threat.technique.id':{category:'threat',description:'The id of technique used by this tactic. You can use the Mitre ATT&CK Matrix Tactic categorization, for example. (ex. https://attack.mitre.org/techniques/T1499/ )',example:'T1499',name:'threat.technique.id',type:'keyword'},'threat.technique.name':{category:'threat',description:'The name of technique used by this tactic. You can use the Mitre ATT&CK Matrix Tactic categorization, for example. (ex. https://attack.mitre.org/techniques/T1499/ )',example:'endpoint denial of service',name:'threat.technique.name',type:'keyword'},'threat.technique.reference':{category:'threat',description:'The reference url of technique used by this tactic. You can use the Mitre ATT&CK Matrix Tactic categorization, for example. (ex. https://attack.mitre.org/techniques/T1499/ )',example:'https://attack.mitre.org/techniques/T1499/',name:'threat.technique.reference',type:'keyword'},'tls.cipher':{category:'tls',description:'String indicating the cipher used during the current connection.',example:'TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256',name:'tls.cipher',type:'keyword'},'tls.client.certificate':{category:'tls',description:'PEM-encoded stand-alone certificate offered by the client. This is usually mutually-exclusive of `client.certificate_chain` since this value also exists in that list.',example:'MII...',name:'tls.client.certificate',type:'keyword'},'tls.client.certificate_chain':{category:'tls',description:'Array of PEM-encoded certificates that make up the certificate chain offered by the client. This is usually mutually-exclusive of `client.certificate` since that value should be the first certificate in the chain.',example:'["MII...","MII..."]',name:'tls.client.certificate_chain',type:'keyword'},'tls.client.hash.md5':{category:'tls',description:'Certificate fingerprint using the MD5 digest of DER-encoded version of certificate offered by the client. For consistency with other hash values, this value should be formatted as an uppercase hash.',example:'0F76C7F2C55BFD7D8E8B8F4BFBF0C9EC',name:'tls.client.hash.md5',type:'keyword'},'tls.client.hash.sha1':{category:'tls',description:'Certificate fingerprint using the SHA1 digest of DER-encoded version of certificate offered by the client. For consistency with other hash values, this value should be formatted as an uppercase hash.',example:'9E393D93138888D288266C2D915214D1D1CCEB2A',name:'tls.client.hash.sha1',type:'keyword'},'tls.client.hash.sha256':{category:'tls',description:'Certificate fingerprint using the SHA256 digest of DER-encoded version of certificate offered by the client. For consistency with other hash values, this value should be formatted as an uppercase hash.',example:'0687F666A054EF17A08E2F2162EAB4CBC0D265E1D7875BE74BF3C712CA92DAF0',name:'tls.client.hash.sha256',type:'keyword'},'tls.client.issuer':{category:'tls',description:'Distinguished name of subject of the issuer of the x.509 certificate presented by the client.',example:'CN=MyDomain Root CA, OU=Infrastructure Team, DC=mydomain, DC=com',name:'tls.client.issuer',type:'keyword'},'tls.client.ja3':{category:'tls',description:'A hash that identifies clients based on how they perform an SSL/TLS handshake.',example:'d4e5b18d6b55c71272893221c96ba240',name:'tls.client.ja3',type:'keyword'},'tls.client.not_after':{category:'tls',description:'Date/Time indicating when client certificate is no longer considered valid.',example:'2021-01-01T00:00:00.000Z',name:'tls.client.not_after',type:'date'},'tls.client.not_before':{category:'tls',description:'Date/Time indicating when client certificate is first considered valid.',example:'1970-01-01T00:00:00.000Z',name:'tls.client.not_before',type:'date'},'tls.client.server_name':{category:'tls',description:'Also called an SNI, this tells the server which hostname to which the client is attempting to connect. When this value is available, it should get copied to `destination.domain`.',example:'www.elastic.co',name:'tls.client.server_name',type:'keyword'},'tls.client.subject':{category:'tls',description:'Distinguished name of subject of the x.509 certificate presented by the client.',example:'CN=myclient, OU=Documentation Team, DC=mydomain, DC=com',name:'tls.client.subject',type:'keyword'},'tls.client.supported_ciphers':{category:'tls',description:'Array of ciphers offered by the client during the client hello.',example:'["TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384","TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384","..."]',name:'tls.client.supported_ciphers',type:'keyword'},'tls.curve':{category:'tls',description:'String indicating the curve used for the given cipher, when applicable.',example:'secp256r1',name:'tls.curve',type:'keyword'},'tls.established':{category:'tls',description:'Boolean flag indicating if the TLS negotiation was successful and transitioned to an encrypted tunnel.',name:'tls.established',type:'boolean'},'tls.next_protocol':{category:'tls',description:'String indicating the protocol being tunneled. Per the values in the IANA registry (https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids), this string should be lower case.',example:'http/1.1',name:'tls.next_protocol',type:'keyword'},'tls.resumed':{category:'tls',description:'Boolean flag indicating if this TLS connection was resumed from an existing TLS negotiation.',name:'tls.resumed',type:'boolean'},'tls.server.certificate':{category:'tls',description:'PEM-encoded stand-alone certificate offered by the server. This is usually mutually-exclusive of `server.certificate_chain` since this value also exists in that list.',example:'MII...',name:'tls.server.certificate',type:'keyword'},'tls.server.certificate_chain':{category:'tls',description:'Array of PEM-encoded certificates that make up the certificate chain offered by the server. This is usually mutually-exclusive of `server.certificate` since that value should be the first certificate in the chain.',example:'["MII...","MII..."]',name:'tls.server.certificate_chain',type:'keyword'},'tls.server.hash.md5':{category:'tls',description:'Certificate fingerprint using the MD5 digest of DER-encoded version of certificate offered by the server. For consistency with other hash values, this value should be formatted as an uppercase hash.',example:'0F76C7F2C55BFD7D8E8B8F4BFBF0C9EC',name:'tls.server.hash.md5',type:'keyword'},'tls.server.hash.sha1':{category:'tls',description:'Certificate fingerprint using the SHA1 digest of DER-encoded version of certificate offered by the server. For consistency with other hash values, this value should be formatted as an uppercase hash.',example:'9E393D93138888D288266C2D915214D1D1CCEB2A',name:'tls.server.hash.sha1',type:'keyword'},'tls.server.hash.sha256':{category:'tls',description:'Certificate fingerprint using the SHA256 digest of DER-encoded version of certificate offered by the server. For consistency with other hash values, this value should be formatted as an uppercase hash.',example:'0687F666A054EF17A08E2F2162EAB4CBC0D265E1D7875BE74BF3C712CA92DAF0',name:'tls.server.hash.sha256',type:'keyword'},'tls.server.issuer':{category:'tls',description:'Subject of the issuer of the x.509 certificate presented by the server.',example:'CN=MyDomain Root CA, OU=Infrastructure Team, DC=mydomain, DC=com',name:'tls.server.issuer',type:'keyword'},'tls.server.ja3s':{category:'tls',description:'A hash that identifies servers based on how they perform an SSL/TLS handshake.',example:'394441ab65754e2207b1e1b457b3641d',name:'tls.server.ja3s',type:'keyword'},'tls.server.not_after':{category:'tls',description:'Timestamp indicating when server certificate is no longer considered valid.',example:'2021-01-01T00:00:00.000Z',name:'tls.server.not_after',type:'date'},'tls.server.not_before':{category:'tls',description:'Timestamp indicating when server certificate is first considered valid.',example:'1970-01-01T00:00:00.000Z',name:'tls.server.not_before',type:'date'},'tls.server.subject':{category:'tls',description:'Subject of the x.509 certificate presented by the server.',example:'CN=www.mydomain.com, OU=Infrastructure Team, DC=mydomain, DC=com',name:'tls.server.subject',type:'keyword'},'tls.version':{category:'tls',description:'Numeric part of the version parsed from the original string.',example:'1.2',name:'tls.version',type:'keyword'},'tls.version_protocol':{category:'tls',description:'Normalized lowercase protocol name parsed from original string.',example:'tls',name:'tls.version_protocol',type:'keyword'},'tracing.trace.id':{category:'tracing',description:'Unique identifier of the trace. A trace groups multiple events like transactions that belong together. For example, a user request handled by multiple inter-connected services.',example:'4bf92f3577b34da6a3ce929d0e0e4736',name:'tracing.trace.id',type:'keyword'},'tracing.transaction.id':{category:'tracing',description:'Unique identifier of the transaction. A transaction is the highest level of work measured within a service, such as a request to a server.',example:'00f067aa0ba902b7',name:'tracing.transaction.id',type:'keyword'},'url.domain':{category:'url',description:'Domain of the url, such as "www.elastic.co". In some cases a URL may refer to an IP and/or port directly, without a domain name. In this case, the IP address would go to the `domain` field.',example:'www.elastic.co',name:'url.domain',type:'keyword'},'url.extension':{category:'url',description:'The field contains the file extension from the original request url. The file extension is only set if it exists, as not every url has a file extension. The leading period must not be included. For example, the value must be "png", not ".png".',example:'png',name:'url.extension',type:'keyword'},'url.fragment':{category:'url',description:'Portion of the url after the `#`, such as "top". The `#` is not part of the fragment.',name:'url.fragment',type:'keyword'},'url.full':{category:'url',description:'If full URLs are important to your use case, they should be stored in `url.full`, whether this field is reconstructed or present in the event source.',example:'https://www.elastic.co:443/search?q=elasticsearch#top',name:'url.full',type:'keyword'},'url.original':{category:'url',description:'Unmodified original url as seen in the event source. Note that in network monitoring, the observed URL may be a full URL, whereas in access logs, the URL is often just represented as a path. This field is meant to represent the URL as it was observed, complete or not.',example:'https://www.elastic.co:443/search?q=elasticsearch#top or /search?q=elasticsearch',name:'url.original',type:'keyword'},'url.password':{category:'url',description:'Password of the request.',name:'url.password',type:'keyword'},'url.path':{category:'url',description:'Path of the request, such as "/search".',name:'url.path',type:'keyword'},'url.port':{category:'url',description:'Port of the request, such as 443.',example:443,name:'url.port',type:'long',format:'string'},'url.query':{category:'url',description:'The query field describes the query string of the request, such as "q=elasticsearch". The `?` is excluded from the query string. If a URL contains no `?`, there is no query field. If there is a `?` but no query, the query field exists with an empty string. The `exists` query can be used to differentiate between the two cases.',name:'url.query',type:'keyword'},'url.registered_domain':{category:'url',description:'The highest registered url domain, stripped of the subdomain. For example, the registered domain for "foo.google.com" is "google.com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".',example:'google.com',name:'url.registered_domain',type:'keyword'},'url.scheme':{category:'url',description:'Scheme of the request, such as "https". Note: The `:` is not part of the scheme.',example:'https',name:'url.scheme',type:'keyword'},'url.top_level_domain':{category:'url',description:'The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for google.com is "com". This value can be determined precisely with a list like the public suffix list (http://publicsuffix.org). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".',example:'co.uk',name:'url.top_level_domain',type:'keyword'},'url.username':{category:'url',description:'Username of the request.',name:'url.username',type:'keyword'},'user.domain':{category:'user',description:'Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name.',name:'user.domain',type:'keyword'},'user.email':{category:'user',description:'User email address.',name:'user.email',type:'keyword'},'user.full_name':{category:'user',description:"User's full name, if available.",example:'Albert Einstein',name:'user.full_name',type:'keyword'},'user.group.domain':{category:'user',description:'Name of the directory the group is a member of. For example, an LDAP or Active Directory domain name.',name:'user.group.domain',type:'keyword'},'user.group.id':{category:'user',description:'Unique identifier for the group on the system/platform.',name:'user.group.id',type:'keyword'},'user.group.name':{category:'user',description:'Name of the group.',name:'user.group.name',type:'keyword'},'user.hash':{category:'user',description:'Unique user hash to correlate information for a user in anonymized form. Useful if `user.id` or `user.name` contain confidential information and cannot be used.',name:'user.hash',type:'keyword'},'user.id':{category:'user',description:'Unique identifiers of the user.',name:'user.id',type:'keyword'},'user.name':{category:'user',description:'Short name or login of the user.',example:'albert',name:'user.name',type:'keyword'},'user_agent.device.name':{category:'user_agent',description:'Name of the device.',example:'iPhone',name:'user_agent.device.name',type:'keyword'},'user_agent.name':{category:'user_agent',description:'Name of the user agent.',example:'Safari',name:'user_agent.name',type:'keyword'},'user_agent.original':{category:'user_agent',description:'Unparsed user_agent string.',example:'Mozilla/5.0 (iPhone; CPU iPhone OS 12_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.0 Mobile/15E148 Safari/604.1',name:'user_agent.original',type:'keyword'},'user_agent.os.family':{category:'user_agent',description:'OS family (such as redhat, debian, freebsd, windows).',example:'debian',name:'user_agent.os.family',type:'keyword'},'user_agent.os.full':{category:'user_agent',description:'Operating system name, including the version or code name.',example:'Mac OS Mojave',name:'user_agent.os.full',type:'keyword'},'user_agent.os.kernel':{category:'user_agent',description:'Operating system kernel version as a raw string.',example:'4.4.0-112-generic',name:'user_agent.os.kernel',type:'keyword'},'user_agent.os.name':{category:'user_agent',description:'Operating system name, without the version.',example:'Mac OS X',name:'user_agent.os.name',type:'keyword'},'user_agent.os.platform':{category:'user_agent',description:'Operating system platform (such centos, ubuntu, windows).',example:'darwin',name:'user_agent.os.platform',type:'keyword'},'user_agent.os.version':{category:'user_agent',description:'Operating system version as a raw string.',example:'10.14.1',name:'user_agent.os.version',type:'keyword'},'user_agent.version':{category:'user_agent',description:'Version of the user agent.',example:12,name:'user_agent.version',type:'keyword'},'vlan.id':{category:'vlan',description:'VLAN ID as reported by the observer.',example:10,name:'vlan.id',type:'keyword'},'vlan.name':{category:'vlan',description:'Optional VLAN name as reported by the observer.',example:'outside',name:'vlan.name',type:'keyword'},'vulnerability.category':{category:'vulnerability',description:'The type of system or architecture that the vulnerability affects. These may be platform-specific (for example, Debian or SUSE) or general (for example, Database or Firewall). For example (https://qualysguard.qualys.com/qwebhelp/fo_portal/knowledgebase/vulnerability_categories.htm[Qualys vulnerability categories]) This field must be an array.',example:'["Firewall"]',name:'vulnerability.category',type:'keyword'},'vulnerability.classification':{category:'vulnerability',description:'The classification of the vulnerability scoring system. For example (https://www.first.org/cvss/)',example:'CVSS',name:'vulnerability.classification',type:'keyword'},'vulnerability.description':{category:'vulnerability',description:'The description of the vulnerability that provides additional context of the vulnerability. For example (https://cve.mitre.org/about/faqs.html#cve_entry_descriptions_created[Common Vulnerabilities and Exposure CVE description])',example:'In macOS before 2.12.6, there is a vulnerability in the RPC...',name:'vulnerability.description',type:'keyword'},'vulnerability.enumeration':{category:'vulnerability',description:'The type of identifier used for this vulnerability. For example (https://cve.mitre.org/about/)',example:'CVE',name:'vulnerability.enumeration',type:'keyword'},'vulnerability.id':{category:'vulnerability',description:'The identification (ID) is the number portion of a vulnerability entry. It includes a unique identification number for the vulnerability. For example (https://cve.mitre.org/about/faqs.html#what_is_cve_id)[Common Vulnerabilities and Exposure CVE ID]',example:'CVE-2019-00001',name:'vulnerability.id',type:'keyword'},'vulnerability.reference':{category:'vulnerability',description:'A resource that provides additional information, context, and mitigations for the identified vulnerability.',example:'https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2019-6111',name:'vulnerability.reference',type:'keyword'},'vulnerability.report_id':{category:'vulnerability',description:'The report or scan identification number.',example:20191018.0001,name:'vulnerability.report_id',type:'keyword'},'vulnerability.scanner.vendor':{category:'vulnerability',description:'The name of the vulnerability scanner vendor.',example:'Tenable',name:'vulnerability.scanner.vendor',type:'keyword'},'vulnerability.score.base':{category:'vulnerability',description:'Scores can range from 0.0 to 10.0, with 10.0 being the most severe. Base scores cover an assessment for exploitability metrics (attack vector, complexity, privileges, and user interaction), impact metrics (confidentiality, integrity, and availability), and scope. For example (https://www.first.org/cvss/specification-document)',example:5.5,name:'vulnerability.score.base',type:'float'},'vulnerability.score.environmental':{category:'vulnerability',description:'Scores can range from 0.0 to 10.0, with 10.0 being the most severe. Environmental scores cover an assessment for any modified Base metrics, confidentiality, integrity, and availability requirements. For example (https://www.first.org/cvss/specification-document)',example:5.5,name:'vulnerability.score.environmental',type:'float'},'vulnerability.score.temporal':{category:'vulnerability',description:'Scores can range from 0.0 to 10.0, with 10.0 being the most severe. Temporal scores cover an assessment for code maturity, remediation level, and confidence. For example (https://www.first.org/cvss/specification-document)',name:'vulnerability.score.temporal',type:'float'},'vulnerability.score.version':{category:'vulnerability',description:'The National Vulnerability Database (NVD) provides qualitative severity rankings of "Low", "Medium", and "High" for CVSS v2.0 base score ranges in addition to the severity ratings for CVSS v3.0 as they are defined in the CVSS v3.0 specification. CVSS is owned and managed by FIRST.Org, Inc. (FIRST), a US-based non-profit organization, whose mission is to help computer security incident response teams across the world. For example (https://nvd.nist.gov/vuln-metrics/cvss)',example:2,name:'vulnerability.score.version',type:'keyword'},'vulnerability.severity':{category:'vulnerability',description:'The severity of the vulnerability can help with metrics and internal prioritization regarding remediation. For example (https://nvd.nist.gov/vuln-metrics/cvss)',example:'Critical',name:'vulnerability.severity',type:'keyword'},'agent.hostname':{category:'agent',description:'Deprecated - use agent.name or agent.id to identify an agent. Hostname of the agent. ',name:'agent.hostname',type:'keyword'},'beat.timezone':{category:'beat',name:'beat.timezone',type:'alias'},fields:{category:'base',description:'Contains user configurable fields. ',name:'fields',type:'object'},'beat.name':{category:'beat',name:'beat.name',type:'alias'},'beat.hostname':{category:'beat',name:'beat.hostname',type:'alias'},'timeseries.instance':{category:'timeseries',description:'Time series instance id',name:'timeseries.instance',type:'keyword'},'cloud.project.id':{category:'cloud',description:'Name of the project in Google Cloud. ',example:'project-x',name:'cloud.project.id'},'cloud.image.id':{category:'cloud',description:'Image ID for the cloud instance. ',example:'ami-abcd1234',name:'cloud.image.id'},'meta.cloud.provider':{category:'meta',name:'meta.cloud.provider',type:'alias'},'meta.cloud.instance_id':{category:'meta',name:'meta.cloud.instance_id',type:'alias'},'meta.cloud.instance_name':{category:'meta',name:'meta.cloud.instance_name',type:'alias'},'meta.cloud.machine_type':{category:'meta',name:'meta.cloud.machine_type',type:'alias'},'meta.cloud.availability_zone':{category:'meta',name:'meta.cloud.availability_zone',type:'alias'},'meta.cloud.project_id':{category:'meta',name:'meta.cloud.project_id',type:'alias'},'meta.cloud.region':{category:'meta',name:'meta.cloud.region',type:'alias'},'docker.container.id':{category:'docker',name:'docker.container.id',type:'alias'},'docker.container.image':{category:'docker',name:'docker.container.image',type:'alias'},'docker.container.name':{category:'docker',name:'docker.container.name',type:'alias'},'docker.container.labels':{category:'docker',description:'Image labels. ',name:'docker.container.labels',type:'object'},'host.containerized':{category:'host',description:'If the host is a container. ',name:'host.containerized',type:'boolean'},'host.os.build':{category:'host',description:'OS build information. ',example:'18D109',name:'host.os.build',type:'keyword'},'host.os.codename':{category:'host',description:'OS codename, if any. ',example:'stretch',name:'host.os.codename',type:'keyword'},'kubernetes.pod.name':{category:'kubernetes',description:'Kubernetes pod name ',name:'kubernetes.pod.name',type:'keyword'},'kubernetes.pod.uid':{category:'kubernetes',description:'Kubernetes Pod UID ',name:'kubernetes.pod.uid',type:'keyword'},'kubernetes.namespace':{category:'kubernetes',description:'Kubernetes namespace ',name:'kubernetes.namespace',type:'keyword'},'kubernetes.node.name':{category:'kubernetes',description:'Kubernetes node name ',name:'kubernetes.node.name',type:'keyword'},'kubernetes.labels.*':{category:'kubernetes',description:'Kubernetes labels map ',name:'kubernetes.labels.*',type:'object'},'kubernetes.annotations.*':{category:'kubernetes',description:'Kubernetes annotations map ',name:'kubernetes.annotations.*',type:'object'},'kubernetes.replicaset.name':{category:'kubernetes',description:'Kubernetes replicaset name ',name:'kubernetes.replicaset.name',type:'keyword'},'kubernetes.deployment.name':{category:'kubernetes',description:'Kubernetes deployment name ',name:'kubernetes.deployment.name',type:'keyword'},'kubernetes.statefulset.name':{category:'kubernetes',description:'Kubernetes statefulset name ',name:'kubernetes.statefulset.name',type:'keyword'},'kubernetes.container.name':{category:'kubernetes',description:'Kubernetes container name ',name:'kubernetes.container.name',type:'keyword'},'kubernetes.container.image':{category:'kubernetes',description:'Kubernetes container image ',name:'kubernetes.container.image',type:'keyword'},'process.exe':{category:'process',name:'process.exe',type:'alias'},'jolokia.agent.version':{category:'jolokia',description:'Version number of jolokia agent. ',name:'jolokia.agent.version',type:'keyword'},'jolokia.agent.id':{category:'jolokia',description:'Each agent has a unique id which can be either provided during startup of the agent in form of a configuration parameter or being autodetected. If autodected, the id has several parts: The IP, the process id, hashcode of the agent and its type. ',name:'jolokia.agent.id',type:'keyword'},'jolokia.server.product':{category:'jolokia',description:'The container product if detected. ',name:'jolokia.server.product',type:'keyword'},'jolokia.server.version':{category:'jolokia',description:"The container's version (if detected). ",name:'jolokia.server.version',type:'keyword'},'jolokia.server.vendor':{category:'jolokia',description:'The vendor of the container the agent is running in. ',name:'jolokia.server.vendor',type:'keyword'},'jolokia.url':{category:'jolokia',description:'The URL how this agent can be contacted. ',name:'jolokia.url',type:'keyword'},'jolokia.secured':{category:'jolokia',description:'Whether the agent was configured for authentication or not. ',name:'jolokia.secured',type:'boolean'},'file.setuid':{category:'file',description:'Set if the file has the `setuid` bit set. Omitted otherwise.',example:'true',name:'file.setuid',type:'boolean'},'file.setgid':{category:'file',description:'Set if the file has the `setgid` bit set. Omitted otherwise.',example:'true',name:'file.setgid',type:'boolean'},'file.origin':{category:'file',description:'An array of strings describing a possible external origin for this file. For example, the URL it was downloaded from. Only supported in macOS, via the kMDItemWhereFroms attribute. Omitted if origin information is not available. ',name:'file.origin',type:'keyword'},'file.selinux.user':{category:'file',description:'The owner of the object.',name:'file.selinux.user',type:'keyword'},'file.selinux.role':{category:'file',description:"The object's SELinux role.",name:'file.selinux.role',type:'keyword'},'file.selinux.domain':{category:'file',description:"The object's SELinux domain or type.",name:'file.selinux.domain',type:'keyword'},'file.selinux.level':{category:'file',description:"The object's SELinux level.",example:'s0',name:'file.selinux.level',type:'keyword'},'user.audit.id':{category:'user',description:'Audit user ID.',name:'user.audit.id',type:'keyword'},'user.audit.name':{category:'user',description:'Audit user name.',name:'user.audit.name',type:'keyword'},'user.effective.id':{category:'user',description:'Effective user ID.',name:'user.effective.id',type:'keyword'},'user.effective.name':{category:'user',description:'Effective user name.',name:'user.effective.name',type:'keyword'},'user.effective.group.id':{category:'user',description:'Effective group ID.',name:'user.effective.group.id',type:'keyword'},'user.effective.group.name':{category:'user',description:'Effective group name.',name:'user.effective.group.name',type:'keyword'},'user.filesystem.id':{category:'user',description:'Filesystem user ID.',name:'user.filesystem.id',type:'keyword'},'user.filesystem.name':{category:'user',description:'Filesystem user name.',name:'user.filesystem.name',type:'keyword'},'user.filesystem.group.id':{category:'user',description:'Filesystem group ID.',name:'user.filesystem.group.id',type:'keyword'},'user.filesystem.group.name':{category:'user',description:'Filesystem group name.',name:'user.filesystem.group.name',type:'keyword'},'user.saved.id':{category:'user',description:'Saved user ID.',name:'user.saved.id',type:'keyword'},'user.saved.name':{category:'user',description:'Saved user name.',name:'user.saved.name',type:'keyword'},'user.saved.group.id':{category:'user',description:'Saved group ID.',name:'user.saved.group.id',type:'keyword'},'user.saved.group.name':{category:'user',description:'Saved group name.',name:'user.saved.group.name',type:'keyword'},'user.auid':{category:'user',name:'user.auid',type:'alias'},'user.uid':{category:'user',name:'user.uid',type:'alias'},'user.euid':{category:'user',name:'user.euid',type:'alias'},'user.fsuid':{category:'user',name:'user.fsuid',type:'alias'},'user.suid':{category:'user',name:'user.suid',type:'alias'},'user.gid':{category:'user',name:'user.gid',type:'alias'},'user.egid':{category:'user',name:'user.egid',type:'alias'},'user.sgid':{category:'user',name:'user.sgid',type:'alias'},'user.fsgid':{category:'user',name:'user.fsgid',type:'alias'},'user.name_map.auid':{category:'user',name:'user.name_map.auid',type:'alias'},'user.name_map.uid':{category:'user',name:'user.name_map.uid',type:'alias'},'user.name_map.euid':{category:'user',name:'user.name_map.euid',type:'alias'},'user.name_map.fsuid':{category:'user',name:'user.name_map.fsuid',type:'alias'},'user.name_map.suid':{category:'user',name:'user.name_map.suid',type:'alias'},'user.name_map.gid':{category:'user',name:'user.name_map.gid',type:'alias'},'user.name_map.egid':{category:'user',name:'user.name_map.egid',type:'alias'},'user.name_map.sgid':{category:'user',name:'user.name_map.sgid',type:'alias'},'user.name_map.fsgid':{category:'user',name:'user.name_map.fsgid',type:'alias'},'user.selinux.user':{category:'user',description:'account submitted for authentication',name:'user.selinux.user',type:'keyword'},'user.selinux.role':{category:'user',description:"user's SELinux role",name:'user.selinux.role',type:'keyword'},'user.selinux.domain':{category:'user',description:"The actor's SELinux domain or type.",name:'user.selinux.domain',type:'keyword'},'user.selinux.level':{category:'user',description:"The actor's SELinux level.",example:'s0',name:'user.selinux.level',type:'keyword'},'user.selinux.category':{category:'user',description:"The actor's SELinux category or compartments.",name:'user.selinux.category',type:'keyword'},'process.cwd':{category:'process',description:'The current working directory.',name:'process.cwd',type:'alias'},'source.path':{category:'source',description:'This is the path associated with a unix socket.',name:'source.path',type:'keyword'},'destination.path':{category:'destination',description:'This is the path associated with a unix socket.',name:'destination.path',type:'keyword'},'auditd.message_type':{category:'auditd',description:'The audit message type (e.g. syscall or apparmor_denied). ',example:'syscall',name:'auditd.message_type',type:'keyword'},'auditd.sequence':{category:'auditd',description:'The sequence number of the event as assigned by the kernel. Sequence numbers are stored as a uint32 in the kernel and can rollover. ',name:'auditd.sequence',type:'long'},'auditd.session':{category:'auditd',description:'The session ID assigned to a login. All events related to a login session will have the same value. ',name:'auditd.session',type:'keyword'},'auditd.result':{category:'auditd',description:'The result of the audited operation (success/fail).',example:'success or fail',name:'auditd.result',type:'keyword'},'auditd.summary.actor.primary':{category:'auditd',description:"The primary identity of the actor. This is the actor's original login ID. It will not change even if the user changes to another account. ",name:'auditd.summary.actor.primary',type:'keyword'},'auditd.summary.actor.secondary':{category:'auditd',description:'The secondary identity of the actor. This is typically the same as the primary, except for when the user has used `su`.',name:'auditd.summary.actor.secondary',type:'keyword'},'auditd.summary.object.type':{category:'auditd',description:'A description of the what the "thing" is (e.g. file, socket, user-session). ',name:'auditd.summary.object.type',type:'keyword'},'auditd.summary.object.primary':{category:'auditd',description:'',name:'auditd.summary.object.primary',type:'keyword'},'auditd.summary.object.secondary':{category:'auditd',description:'',name:'auditd.summary.object.secondary',type:'keyword'},'auditd.summary.how':{category:'auditd',description:'This describes how the action was performed. Usually this is the exe or command that was being executed that triggered the event. ',name:'auditd.summary.how',type:'keyword'},'auditd.paths.inode':{category:'auditd',description:'inode number',name:'auditd.paths.inode',type:'keyword'},'auditd.paths.dev':{category:'auditd',description:'device name as found in /dev',name:'auditd.paths.dev',type:'keyword'},'auditd.paths.obj_user':{category:'auditd',description:'',name:'auditd.paths.obj_user',type:'keyword'},'auditd.paths.obj_role':{category:'auditd',description:'',name:'auditd.paths.obj_role',type:'keyword'},'auditd.paths.obj_domain':{category:'auditd',description:'',name:'auditd.paths.obj_domain',type:'keyword'},'auditd.paths.obj_level':{category:'auditd',description:'',name:'auditd.paths.obj_level',type:'keyword'},'auditd.paths.objtype':{category:'auditd',description:'',name:'auditd.paths.objtype',type:'keyword'},'auditd.paths.ouid':{category:'auditd',description:'file owner user ID',name:'auditd.paths.ouid',type:'keyword'},'auditd.paths.rdev':{category:'auditd',description:'the device identifier (special files only)',name:'auditd.paths.rdev',type:'keyword'},'auditd.paths.nametype':{category:'auditd',description:'kind of file operation being referenced',name:'auditd.paths.nametype',type:'keyword'},'auditd.paths.ogid':{category:'auditd',description:'file owner group ID',name:'auditd.paths.ogid',type:'keyword'},'auditd.paths.item':{category:'auditd',description:'which item is being recorded',name:'auditd.paths.item',type:'keyword'},'auditd.paths.mode':{category:'auditd',description:'mode flags on a file',name:'auditd.paths.mode',type:'keyword'},'auditd.paths.name':{category:'auditd',description:'file name in avcs',name:'auditd.paths.name',type:'keyword'},'auditd.data.action':{category:'auditd',description:'netfilter packet disposition',name:'auditd.data.action',type:'keyword'},'auditd.data.minor':{category:'auditd',description:'device minor number',name:'auditd.data.minor',type:'keyword'},'auditd.data.acct':{category:'auditd',description:"a user's account name",name:'auditd.data.acct',type:'keyword'},'auditd.data.addr':{category:'auditd',description:'the remote address that the user is connecting from',name:'auditd.data.addr',type:'keyword'},'auditd.data.cipher':{category:'auditd',description:'name of crypto cipher selected',name:'auditd.data.cipher',type:'keyword'},'auditd.data.id':{category:'auditd',description:'during account changes',name:'auditd.data.id',type:'keyword'},'auditd.data.entries':{category:'auditd',description:'number of entries in the netfilter table',name:'auditd.data.entries',type:'keyword'},'auditd.data.kind':{category:'auditd',description:'server or client in crypto operation',name:'auditd.data.kind',type:'keyword'},'auditd.data.ksize':{category:'auditd',description:'key size for crypto operation',name:'auditd.data.ksize',type:'keyword'},'auditd.data.spid':{category:'auditd',description:'sent process ID',name:'auditd.data.spid',type:'keyword'},'auditd.data.arch':{category:'auditd',description:'the elf architecture flags',name:'auditd.data.arch',type:'keyword'},'auditd.data.argc':{category:'auditd',description:'the number of arguments to an execve syscall',name:'auditd.data.argc',type:'keyword'},'auditd.data.major':{category:'auditd',description:'device major number',name:'auditd.data.major',type:'keyword'},'auditd.data.unit':{category:'auditd',description:'systemd unit',name:'auditd.data.unit',type:'keyword'},'auditd.data.table':{category:'auditd',description:'netfilter table name',name:'auditd.data.table',type:'keyword'},'auditd.data.terminal':{category:'auditd',description:'terminal name the user is running programs on',name:'auditd.data.terminal',type:'keyword'},'auditd.data.grantors':{category:'auditd',description:'pam modules approving the action',name:'auditd.data.grantors',type:'keyword'},'auditd.data.direction':{category:'auditd',description:'direction of crypto operation',name:'auditd.data.direction',type:'keyword'},'auditd.data.op':{category:'auditd',description:'the operation being performed that is audited',name:'auditd.data.op',type:'keyword'},'auditd.data.tty':{category:'auditd',description:'tty udevice the user is running programs on',name:'auditd.data.tty',type:'keyword'},'auditd.data.syscall':{category:'auditd',description:'syscall number in effect when the event occurred',name:'auditd.data.syscall',type:'keyword'},'auditd.data.data':{category:'auditd',description:'TTY text',name:'auditd.data.data',type:'keyword'},'auditd.data.family':{category:'auditd',description:'netfilter protocol',name:'auditd.data.family',type:'keyword'},'auditd.data.mac':{category:'auditd',description:'crypto MAC algorithm selected',name:'auditd.data.mac',type:'keyword'},'auditd.data.pfs':{category:'auditd',description:'perfect forward secrecy method',name:'auditd.data.pfs',type:'keyword'},'auditd.data.items':{category:'auditd',description:'the number of path records in the event',name:'auditd.data.items',type:'keyword'},'auditd.data.a0':{category:'auditd',description:'',name:'auditd.data.a0',type:'keyword'},'auditd.data.a1':{category:'auditd',description:'',name:'auditd.data.a1',type:'keyword'},'auditd.data.a2':{category:'auditd',description:'',name:'auditd.data.a2',type:'keyword'},'auditd.data.a3':{category:'auditd',description:'',name:'auditd.data.a3',type:'keyword'},'auditd.data.hostname':{category:'auditd',description:'the hostname that the user is connecting from',name:'auditd.data.hostname',type:'keyword'},'auditd.data.lport':{category:'auditd',description:'local network port',name:'auditd.data.lport',type:'keyword'},'auditd.data.rport':{category:'auditd',description:'remote port number',name:'auditd.data.rport',type:'keyword'},'auditd.data.exit':{category:'auditd',description:'syscall exit code',name:'auditd.data.exit',type:'keyword'},'auditd.data.fp':{category:'auditd',description:'crypto key finger print',name:'auditd.data.fp',type:'keyword'},'auditd.data.laddr':{category:'auditd',description:'local network address',name:'auditd.data.laddr',type:'keyword'},'auditd.data.sport':{category:'auditd',description:'local port number',name:'auditd.data.sport',type:'keyword'},'auditd.data.capability':{category:'auditd',description:'posix capabilities',name:'auditd.data.capability',type:'keyword'},'auditd.data.nargs':{category:'auditd',description:'the number of arguments to a socket call',name:'auditd.data.nargs',type:'keyword'},'auditd.data.new-enabled':{category:'auditd',description:'new TTY audit enabled setting',name:'auditd.data.new-enabled',type:'keyword'},'auditd.data.audit_backlog_limit':{category:'auditd',description:"audit system's backlog queue size",name:'auditd.data.audit_backlog_limit',type:'keyword'},'auditd.data.dir':{category:'auditd',description:'directory name',name:'auditd.data.dir',type:'keyword'},'auditd.data.cap_pe':{category:'auditd',description:'process effective capability map',name:'auditd.data.cap_pe',type:'keyword'},'auditd.data.model':{category:'auditd',description:'security model being used for virt',name:'auditd.data.model',type:'keyword'},'auditd.data.new_pp':{category:'auditd',description:'new process permitted capability map',name:'auditd.data.new_pp',type:'keyword'},'auditd.data.old-enabled':{category:'auditd',description:'present TTY audit enabled setting',name:'auditd.data.old-enabled',type:'keyword'},'auditd.data.oauid':{category:'auditd',description:"object's login user ID",name:'auditd.data.oauid',type:'keyword'},'auditd.data.old':{category:'auditd',description:'old value',name:'auditd.data.old',type:'keyword'},'auditd.data.banners':{category:'auditd',description:'banners used on printed page',name:'auditd.data.banners',type:'keyword'},'auditd.data.feature':{category:'auditd',description:'kernel feature being changed',name:'auditd.data.feature',type:'keyword'},'auditd.data.vm-ctx':{category:'auditd',description:"the vm's context string",name:'auditd.data.vm-ctx',type:'keyword'},'auditd.data.opid':{category:'auditd',description:"object's process ID",name:'auditd.data.opid',type:'keyword'},'auditd.data.seperms':{category:'auditd',description:'SELinux permissions being used',name:'auditd.data.seperms',type:'keyword'},'auditd.data.seresult':{category:'auditd',description:'SELinux AVC decision granted/denied',name:'auditd.data.seresult',type:'keyword'},'auditd.data.new-rng':{category:'auditd',description:'device name of rng being added from a vm',name:'auditd.data.new-rng',type:'keyword'},'auditd.data.old-net':{category:'auditd',description:'present MAC address assigned to vm',name:'auditd.data.old-net',type:'keyword'},'auditd.data.sigev_signo':{category:'auditd',description:'signal number',name:'auditd.data.sigev_signo',type:'keyword'},'auditd.data.ino':{category:'auditd',description:'inode number',name:'auditd.data.ino',type:'keyword'},'auditd.data.old_enforcing':{category:'auditd',description:'old MAC enforcement status',name:'auditd.data.old_enforcing',type:'keyword'},'auditd.data.old-vcpu':{category:'auditd',description:'present number of CPU cores',name:'auditd.data.old-vcpu',type:'keyword'},'auditd.data.range':{category:'auditd',description:"user's SE Linux range",name:'auditd.data.range',type:'keyword'},'auditd.data.res':{category:'auditd',description:'result of the audited operation(success/fail)',name:'auditd.data.res',type:'keyword'},'auditd.data.added':{category:'auditd',description:'number of new files detected',name:'auditd.data.added',type:'keyword'},'auditd.data.fam':{category:'auditd',description:'socket address family',name:'auditd.data.fam',type:'keyword'},'auditd.data.nlnk-pid':{category:'auditd',description:'pid of netlink packet sender',name:'auditd.data.nlnk-pid',type:'keyword'},'auditd.data.subj':{category:'auditd',description:"lspp subject's context string",name:'auditd.data.subj',type:'keyword'},'auditd.data.a[0-3]':{category:'auditd',description:'the arguments to a syscall',name:'auditd.data.a[0-3]',type:'keyword'},'auditd.data.cgroup':{category:'auditd',description:'path to cgroup in sysfs',name:'auditd.data.cgroup',type:'keyword'},'auditd.data.kernel':{category:'auditd',description:"kernel's version number",name:'auditd.data.kernel',type:'keyword'},'auditd.data.ocomm':{category:'auditd',description:"object's command line name",name:'auditd.data.ocomm',type:'keyword'},'auditd.data.new-net':{category:'auditd',description:'MAC address being assigned to vm',name:'auditd.data.new-net',type:'keyword'},'auditd.data.permissive':{category:'auditd',description:'SELinux is in permissive mode',name:'auditd.data.permissive',type:'keyword'},'auditd.data.class':{category:'auditd',description:'resource class assigned to vm',name:'auditd.data.class',type:'keyword'},'auditd.data.compat':{category:'auditd',description:'is_compat_task result',name:'auditd.data.compat',type:'keyword'},'auditd.data.fi':{category:'auditd',description:'file assigned inherited capability map',name:'auditd.data.fi',type:'keyword'},'auditd.data.changed':{category:'auditd',description:'number of changed files',name:'auditd.data.changed',type:'keyword'},'auditd.data.msg':{category:'auditd',description:'the payload of the audit record',name:'auditd.data.msg',type:'keyword'},'auditd.data.dport':{category:'auditd',description:'remote port number',name:'auditd.data.dport',type:'keyword'},'auditd.data.new-seuser':{category:'auditd',description:'new SELinux user',name:'auditd.data.new-seuser',type:'keyword'},'auditd.data.invalid_context':{category:'auditd',description:'SELinux context',name:'auditd.data.invalid_context',type:'keyword'},'auditd.data.dmac':{category:'auditd',description:'remote MAC address',name:'auditd.data.dmac',type:'keyword'},'auditd.data.ipx-net':{category:'auditd',description:'IPX network number',name:'auditd.data.ipx-net',type:'keyword'},'auditd.data.iuid':{category:'auditd',description:"ipc object's user ID",name:'auditd.data.iuid',type:'keyword'},'auditd.data.macproto':{category:'auditd',description:'ethernet packet type ID field',name:'auditd.data.macproto',type:'keyword'},'auditd.data.obj':{category:'auditd',description:'lspp object context string',name:'auditd.data.obj',type:'keyword'},'auditd.data.ipid':{category:'auditd',description:'IP datagram fragment identifier',name:'auditd.data.ipid',type:'keyword'},'auditd.data.new-fs':{category:'auditd',description:'file system being added to vm',name:'auditd.data.new-fs',type:'keyword'},'auditd.data.vm-pid':{category:'auditd',description:"vm's process ID",name:'auditd.data.vm-pid',type:'keyword'},'auditd.data.cap_pi':{category:'auditd',description:'process inherited capability map',name:'auditd.data.cap_pi',type:'keyword'},'auditd.data.old-auid':{category:'auditd',description:'previous auid value',name:'auditd.data.old-auid',type:'keyword'},'auditd.data.oses':{category:'auditd',description:"object's session ID",name:'auditd.data.oses',type:'keyword'},'auditd.data.fd':{category:'auditd',description:'file descriptor number',name:'auditd.data.fd',type:'keyword'},'auditd.data.igid':{category:'auditd',description:"ipc object's group ID",name:'auditd.data.igid',type:'keyword'},'auditd.data.new-disk':{category:'auditd',description:'disk being added to vm',name:'auditd.data.new-disk',type:'keyword'},'auditd.data.parent':{category:'auditd',description:'the inode number of the parent file',name:'auditd.data.parent',type:'keyword'},'auditd.data.len':{category:'auditd',description:'length',name:'auditd.data.len',type:'keyword'},'auditd.data.oflag':{category:'auditd',description:'open syscall flags',name:'auditd.data.oflag',type:'keyword'},'auditd.data.uuid':{category:'auditd',description:'a UUID',name:'auditd.data.uuid',type:'keyword'},'auditd.data.code':{category:'auditd',description:'seccomp action code',name:'auditd.data.code',type:'keyword'},'auditd.data.nlnk-grp':{category:'auditd',description:'netlink group number',name:'auditd.data.nlnk-grp',type:'keyword'},'auditd.data.cap_fp':{category:'auditd',description:'file permitted capability map',name:'auditd.data.cap_fp',type:'keyword'},'auditd.data.new-mem':{category:'auditd',description:'new amount of memory in KB',name:'auditd.data.new-mem',type:'keyword'},'auditd.data.seperm':{category:'auditd',description:'SELinux permission being decided on',name:'auditd.data.seperm',type:'keyword'},'auditd.data.enforcing':{category:'auditd',description:'new MAC enforcement status',name:'auditd.data.enforcing',type:'keyword'},'auditd.data.new-chardev':{category:'auditd',description:'new character device being assigned to vm',name:'auditd.data.new-chardev',type:'keyword'},'auditd.data.old-rng':{category:'auditd',description:'device name of rng being removed from a vm',name:'auditd.data.old-rng',type:'keyword'},'auditd.data.outif':{category:'auditd',description:'out interface number',name:'auditd.data.outif',type:'keyword'},'auditd.data.cmd':{category:'auditd',description:'command being executed',name:'auditd.data.cmd',type:'keyword'},'auditd.data.hook':{category:'auditd',description:'netfilter hook that packet came from',name:'auditd.data.hook',type:'keyword'},'auditd.data.new-level':{category:'auditd',description:'new run level',name:'auditd.data.new-level',type:'keyword'},'auditd.data.sauid':{category:'auditd',description:'sent login user ID',name:'auditd.data.sauid',type:'keyword'},'auditd.data.sig':{category:'auditd',description:'signal number',name:'auditd.data.sig',type:'keyword'},'auditd.data.audit_backlog_wait_time':{category:'auditd',description:"audit system's backlog wait time",name:'auditd.data.audit_backlog_wait_time',type:'keyword'},'auditd.data.printer':{category:'auditd',description:'printer name',name:'auditd.data.printer',type:'keyword'},'auditd.data.old-mem':{category:'auditd',description:'present amount of memory in KB',name:'auditd.data.old-mem',type:'keyword'},'auditd.data.perm':{category:'auditd',description:'the file permission being used',name:'auditd.data.perm',type:'keyword'},'auditd.data.old_pi':{category:'auditd',description:'old process inherited capability map',name:'auditd.data.old_pi',type:'keyword'},'auditd.data.state':{category:'auditd',description:'audit daemon configuration resulting state',name:'auditd.data.state',type:'keyword'},'auditd.data.format':{category:'auditd',description:"audit log's format",name:'auditd.data.format',type:'keyword'},'auditd.data.new_gid':{category:'auditd',description:'new group ID being assigned',name:'auditd.data.new_gid',type:'keyword'},'auditd.data.tcontext':{category:'auditd',description:"the target's or object's context string",name:'auditd.data.tcontext',type:'keyword'},'auditd.data.maj':{category:'auditd',description:'device major number',name:'auditd.data.maj',type:'keyword'},'auditd.data.watch':{category:'auditd',description:'file name in a watch record',name:'auditd.data.watch',type:'keyword'},'auditd.data.device':{category:'auditd',description:'device name',name:'auditd.data.device',type:'keyword'},'auditd.data.grp':{category:'auditd',description:'group name',name:'auditd.data.grp',type:'keyword'},'auditd.data.bool':{category:'auditd',description:'name of SELinux boolean',name:'auditd.data.bool',type:'keyword'},'auditd.data.icmp_type':{category:'auditd',description:'type of icmp message',name:'auditd.data.icmp_type',type:'keyword'},'auditd.data.new_lock':{category:'auditd',description:'new value of feature lock',name:'auditd.data.new_lock',type:'keyword'},'auditd.data.old_prom':{category:'auditd',description:'network promiscuity flag',name:'auditd.data.old_prom',type:'keyword'},'auditd.data.acl':{category:'auditd',description:'access mode of resource assigned to vm',name:'auditd.data.acl',type:'keyword'},'auditd.data.ip':{category:'auditd',description:'network address of a printer',name:'auditd.data.ip',type:'keyword'},'auditd.data.new_pi':{category:'auditd',description:'new process inherited capability map',name:'auditd.data.new_pi',type:'keyword'},'auditd.data.default-context':{category:'auditd',description:'default MAC context',name:'auditd.data.default-context',type:'keyword'},'auditd.data.inode_gid':{category:'auditd',description:"group ID of the inode's owner",name:'auditd.data.inode_gid',type:'keyword'},'auditd.data.new-log_passwd':{category:'auditd',description:'new value for TTY password logging',name:'auditd.data.new-log_passwd',type:'keyword'},'auditd.data.new_pe':{category:'auditd',description:'new process effective capability map',name:'auditd.data.new_pe',type:'keyword'},'auditd.data.selected-context':{category:'auditd',description:'new MAC context assigned to session',name:'auditd.data.selected-context',type:'keyword'},'auditd.data.cap_fver':{category:'auditd',description:'file system capabilities version number',name:'auditd.data.cap_fver',type:'keyword'},'auditd.data.file':{category:'auditd',description:'file name',name:'auditd.data.file',type:'keyword'},'auditd.data.net':{category:'auditd',description:'network MAC address',name:'auditd.data.net',type:'keyword'},'auditd.data.virt':{category:'auditd',description:'kind of virtualization being referenced',name:'auditd.data.virt',type:'keyword'},'auditd.data.cap_pp':{category:'auditd',description:'process permitted capability map',name:'auditd.data.cap_pp',type:'keyword'},'auditd.data.old-range':{category:'auditd',description:'present SELinux range',name:'auditd.data.old-range',type:'keyword'},'auditd.data.resrc':{category:'auditd',description:'resource being assigned',name:'auditd.data.resrc',type:'keyword'},'auditd.data.new-range':{category:'auditd',description:'new SELinux range',name:'auditd.data.new-range',type:'keyword'},'auditd.data.obj_gid':{category:'auditd',description:'group ID of object',name:'auditd.data.obj_gid',type:'keyword'},'auditd.data.proto':{category:'auditd',description:'network protocol',name:'auditd.data.proto',type:'keyword'},'auditd.data.old-disk':{category:'auditd',description:'disk being removed from vm',name:'auditd.data.old-disk',type:'keyword'},'auditd.data.audit_failure':{category:'auditd',description:"audit system's failure mode",name:'auditd.data.audit_failure',type:'keyword'},'auditd.data.inif':{category:'auditd',description:'in interface number',name:'auditd.data.inif',type:'keyword'},'auditd.data.vm':{category:'auditd',description:'virtual machine name',name:'auditd.data.vm',type:'keyword'},'auditd.data.flags':{category:'auditd',description:'mmap syscall flags',name:'auditd.data.flags',type:'keyword'},'auditd.data.nlnk-fam':{category:'auditd',description:'netlink protocol number',name:'auditd.data.nlnk-fam',type:'keyword'},'auditd.data.old-fs':{category:'auditd',description:'file system being removed from vm',name:'auditd.data.old-fs',type:'keyword'},'auditd.data.old-ses':{category:'auditd',description:'previous ses value',name:'auditd.data.old-ses',type:'keyword'},'auditd.data.seqno':{category:'auditd',description:'sequence number',name:'auditd.data.seqno',type:'keyword'},'auditd.data.fver':{category:'auditd',description:'file system capabilities version number',name:'auditd.data.fver',type:'keyword'},'auditd.data.qbytes':{category:'auditd',description:'ipc objects quantity of bytes',name:'auditd.data.qbytes',type:'keyword'},'auditd.data.seuser':{category:'auditd',description:"user's SE Linux user acct",name:'auditd.data.seuser',type:'keyword'},'auditd.data.cap_fe':{category:'auditd',description:'file assigned effective capability map',name:'auditd.data.cap_fe',type:'keyword'},'auditd.data.new-vcpu':{category:'auditd',description:'new number of CPU cores',name:'auditd.data.new-vcpu',type:'keyword'},'auditd.data.old-level':{category:'auditd',description:'old run level',name:'auditd.data.old-level',type:'keyword'},'auditd.data.old_pp':{category:'auditd',description:'old process permitted capability map',name:'auditd.data.old_pp',type:'keyword'},'auditd.data.daddr':{category:'auditd',description:'remote IP address',name:'auditd.data.daddr',type:'keyword'},'auditd.data.old-role':{category:'auditd',description:'present SELinux role',name:'auditd.data.old-role',type:'keyword'},'auditd.data.ioctlcmd':{category:'auditd',description:'The request argument to the ioctl syscall',name:'auditd.data.ioctlcmd',type:'keyword'},'auditd.data.smac':{category:'auditd',description:'local MAC address',name:'auditd.data.smac',type:'keyword'},'auditd.data.apparmor':{category:'auditd',description:'apparmor event information',name:'auditd.data.apparmor',type:'keyword'},'auditd.data.fe':{category:'auditd',description:'file assigned effective capability map',name:'auditd.data.fe',type:'keyword'},'auditd.data.perm_mask':{category:'auditd',description:'file permission mask that triggered a watch event',name:'auditd.data.perm_mask',type:'keyword'},'auditd.data.ses':{category:'auditd',description:'login session ID',name:'auditd.data.ses',type:'keyword'},'auditd.data.cap_fi':{category:'auditd',description:'file inherited capability map',name:'auditd.data.cap_fi',type:'keyword'},'auditd.data.obj_uid':{category:'auditd',description:'user ID of object',name:'auditd.data.obj_uid',type:'keyword'},'auditd.data.reason':{category:'auditd',description:'text string denoting a reason for the action',name:'auditd.data.reason',type:'keyword'},'auditd.data.list':{category:'auditd',description:"the audit system's filter list number",name:'auditd.data.list',type:'keyword'},'auditd.data.old_lock':{category:'auditd',description:'present value of feature lock',name:'auditd.data.old_lock',type:'keyword'},'auditd.data.bus':{category:'auditd',description:'name of subsystem bus a vm resource belongs to',name:'auditd.data.bus',type:'keyword'},'auditd.data.old_pe':{category:'auditd',description:'old process effective capability map',name:'auditd.data.old_pe',type:'keyword'},'auditd.data.new-role':{category:'auditd',description:'new SELinux role',name:'auditd.data.new-role',type:'keyword'},'auditd.data.prom':{category:'auditd',description:'network promiscuity flag',name:'auditd.data.prom',type:'keyword'},'auditd.data.uri':{category:'auditd',description:'URI pointing to a printer',name:'auditd.data.uri',type:'keyword'},'auditd.data.audit_enabled':{category:'auditd',description:"audit systems's enable/disable status",name:'auditd.data.audit_enabled',type:'keyword'},'auditd.data.old-log_passwd':{category:'auditd',description:'present value for TTY password logging',name:'auditd.data.old-log_passwd',type:'keyword'},'auditd.data.old-seuser':{category:'auditd',description:'present SELinux user',name:'auditd.data.old-seuser',type:'keyword'},'auditd.data.per':{category:'auditd',description:'linux personality',name:'auditd.data.per',type:'keyword'},'auditd.data.scontext':{category:'auditd',description:"the subject's context string",name:'auditd.data.scontext',type:'keyword'},'auditd.data.tclass':{category:'auditd',description:"target's object classification",name:'auditd.data.tclass',type:'keyword'},'auditd.data.ver':{category:'auditd',description:"audit daemon's version number",name:'auditd.data.ver',type:'keyword'},'auditd.data.new':{category:'auditd',description:'value being set in feature',name:'auditd.data.new',type:'keyword'},'auditd.data.val':{category:'auditd',description:'generic value associated with the operation',name:'auditd.data.val',type:'keyword'},'auditd.data.img-ctx':{category:'auditd',description:"the vm's disk image context string",name:'auditd.data.img-ctx',type:'keyword'},'auditd.data.old-chardev':{category:'auditd',description:'present character device assigned to vm',name:'auditd.data.old-chardev',type:'keyword'},'auditd.data.old_val':{category:'auditd',description:'current value of SELinux boolean',name:'auditd.data.old_val',type:'keyword'},'auditd.data.success':{category:'auditd',description:'whether the syscall was successful or not',name:'auditd.data.success',type:'keyword'},'auditd.data.inode_uid':{category:'auditd',description:"user ID of the inode's owner",name:'auditd.data.inode_uid',type:'keyword'},'auditd.data.removed':{category:'auditd',description:'number of deleted files',name:'auditd.data.removed',type:'keyword'},'auditd.data.socket.port':{category:'auditd',description:'The port number.',name:'auditd.data.socket.port',type:'keyword'},'auditd.data.socket.saddr':{category:'auditd',description:'The raw socket address structure.',name:'auditd.data.socket.saddr',type:'keyword'},'auditd.data.socket.addr':{category:'auditd',description:'The remote address.',name:'auditd.data.socket.addr',type:'keyword'},'auditd.data.socket.family':{category:'auditd',description:'The socket family (unix, ipv4, ipv6, netlink).',example:'unix',name:'auditd.data.socket.family',type:'keyword'},'auditd.data.socket.path':{category:'auditd',description:'This is the path associated with a unix socket.',name:'auditd.data.socket.path',type:'keyword'},'auditd.messages':{category:'auditd',description:'An ordered list of the raw messages received from the kernel that were used to construct this document. This field is present if an error occurred processing the data or if `include_raw_message` is set in the config. ',name:'auditd.messages',type:'alias'},'auditd.warnings':{category:'auditd',description:'The warnings generated by the Beat during the construction of the event. These are disabled by default and are used for development and debug purposes only. ',name:'auditd.warnings',type:'alias'},'geoip.continent_name':{category:'geoip',description:'The name of the continent. ',name:'geoip.continent_name',type:'keyword'},'geoip.city_name':{category:'geoip',description:'The name of the city. ',name:'geoip.city_name',type:'keyword'},'geoip.region_name':{category:'geoip',description:'The name of the region. ',name:'geoip.region_name',type:'keyword'},'geoip.country_iso_code':{category:'geoip',description:'Country ISO code. ',name:'geoip.country_iso_code',type:'keyword'},'geoip.location':{category:'geoip',description:'The longitude and latitude. ',name:'geoip.location',type:'geo_point'},'hash.blake2b_256':{category:'hash',description:'BLAKE2b-256 hash of the file.',name:'hash.blake2b_256',type:'keyword'},'hash.blake2b_384':{category:'hash',description:'BLAKE2b-384 hash of the file.',name:'hash.blake2b_384',type:'keyword'},'hash.blake2b_512':{category:'hash',description:'BLAKE2b-512 hash of the file.',name:'hash.blake2b_512',type:'keyword'},'hash.sha224':{category:'hash',description:'SHA224 hash of the file.',name:'hash.sha224',type:'keyword'},'hash.sha384':{category:'hash',description:'SHA384 hash of the file.',name:'hash.sha384',type:'keyword'},'hash.sha3_224':{category:'hash',description:'SHA3_224 hash of the file.',name:'hash.sha3_224',type:'keyword'},'hash.sha3_256':{category:'hash',description:'SHA3_256 hash of the file.',name:'hash.sha3_256',type:'keyword'},'hash.sha3_384':{category:'hash',description:'SHA3_384 hash of the file.',name:'hash.sha3_384',type:'keyword'},'hash.sha3_512':{category:'hash',description:'SHA3_512 hash of the file.',name:'hash.sha3_512',type:'keyword'},'hash.sha512_224':{category:'hash',description:'SHA512/224 hash of the file.',name:'hash.sha512_224',type:'keyword'},'hash.sha512_256':{category:'hash',description:'SHA512/256 hash of the file.',name:'hash.sha512_256',type:'keyword'},'hash.xxh64':{category:'hash',description:'XX64 hash of the file.',name:'hash.xxh64',type:'keyword'},'event.origin':{category:'event',description:'Origin of the event. This can be a file path (e.g. `/var/log/log.1`), or the name of the system component that supplied the data (e.g. `netlink`). ',name:'event.origin',type:'keyword'},'user.entity_id':{category:'user',description:'ID uniquely identifying the user on a host. It is computed as a SHA-256 hash of the host ID, user ID, and user name. ',name:'user.entity_id',type:'keyword'},'user.terminal':{category:'user',description:'Terminal of the user. ',name:'user.terminal',type:'keyword'},'process.hash.blake2b_256':{category:'process',description:'BLAKE2b-256 hash of the executable.',name:'process.hash.blake2b_256',type:'keyword'},'process.hash.blake2b_384':{category:'process',description:'BLAKE2b-384 hash of the executable.',name:'process.hash.blake2b_384',type:'keyword'},'process.hash.blake2b_512':{category:'process',description:'BLAKE2b-512 hash of the executable.',name:'process.hash.blake2b_512',type:'keyword'},'process.hash.sha224':{category:'process',description:'SHA224 hash of the executable.',name:'process.hash.sha224',type:'keyword'},'process.hash.sha384':{category:'process',description:'SHA384 hash of the executable.',name:'process.hash.sha384',type:'keyword'},'process.hash.sha3_224':{category:'process',description:'SHA3_224 hash of the executable.',name:'process.hash.sha3_224',type:'keyword'},'process.hash.sha3_256':{category:'process',description:'SHA3_256 hash of the executable.',name:'process.hash.sha3_256',type:'keyword'},'process.hash.sha3_384':{category:'process',description:'SHA3_384 hash of the executable.',name:'process.hash.sha3_384',type:'keyword'},'process.hash.sha3_512':{category:'process',description:'SHA3_512 hash of the executable.',name:'process.hash.sha3_512',type:'keyword'},'process.hash.sha512_224':{category:'process',description:'SHA512/224 hash of the executable.',name:'process.hash.sha512_224',type:'keyword'},'process.hash.sha512_256':{category:'process',description:'SHA512/256 hash of the executable.',name:'process.hash.sha512_256',type:'keyword'},'process.hash.xxh64':{category:'process',description:'XX64 hash of the executable.',name:'process.hash.xxh64',type:'keyword'},'socket.entity_id':{category:'socket',description:'ID uniquely identifying the socket. It is computed as a SHA-256 hash of the host ID, socket inode, local IP, local port, remote IP, and remote port. ',name:'socket.entity_id',type:'keyword'},'system.audit.host.uptime':{category:'system',description:'Uptime in nanoseconds. ',name:'system.audit.host.uptime',type:'long',format:'duration'},'system.audit.host.boottime':{category:'system',description:'Boot time. ',name:'system.audit.host.boottime',type:'date'},'system.audit.host.containerized':{category:'system',description:'Set if host is a container. ',name:'system.audit.host.containerized',type:'boolean'},'system.audit.host.timezone.name':{category:'system',description:'Name of the timezone of the host, e.g. BST. ',name:'system.audit.host.timezone.name',type:'keyword'},'system.audit.host.timezone.offset.sec':{category:'system',description:'Timezone offset in seconds. ',name:'system.audit.host.timezone.offset.sec',type:'long'},'system.audit.host.hostname':{category:'system',description:'Hostname. ',name:'system.audit.host.hostname',type:'keyword'},'system.audit.host.id':{category:'system',description:'Host ID. ',name:'system.audit.host.id',type:'keyword'},'system.audit.host.architecture':{category:'system',description:'Host architecture (e.g. x86_64). ',name:'system.audit.host.architecture',type:'keyword'},'system.audit.host.mac':{category:'system',description:'MAC addresses. ',name:'system.audit.host.mac',type:'keyword'},'system.audit.host.ip':{category:'system',description:'IP addresses. ',name:'system.audit.host.ip',type:'ip'},'system.audit.host.os.codename':{category:'system',description:'OS codename, if any (e.g. stretch). ',name:'system.audit.host.os.codename',type:'keyword'},'system.audit.host.os.platform':{category:'system',description:'OS platform (e.g. centos, ubuntu, windows). ',name:'system.audit.host.os.platform',type:'keyword'},'system.audit.host.os.name':{category:'system',description:'OS name (e.g. Mac OS X). ',name:'system.audit.host.os.name',type:'keyword'},'system.audit.host.os.family':{category:'system',description:'OS family (e.g. redhat, debian, freebsd, windows). ',name:'system.audit.host.os.family',type:'keyword'},'system.audit.host.os.version':{category:'system',description:'OS version. ',name:'system.audit.host.os.version',type:'keyword'},'system.audit.host.os.kernel':{category:'system',description:"The operating system's kernel version. ",name:'system.audit.host.os.kernel',type:'keyword'},'system.audit.package.entity_id':{category:'system',description:'ID uniquely identifying the package. It is computed as a SHA-256 hash of the   host ID, package name, and package version. ',name:'system.audit.package.entity_id',type:'keyword'},'system.audit.package.name':{category:'system',description:'Package name. ',name:'system.audit.package.name',type:'keyword'},'system.audit.package.version':{category:'system',description:'Package version. ',name:'system.audit.package.version',type:'keyword'},'system.audit.package.release':{category:'system',description:'Package release. ',name:'system.audit.package.release',type:'keyword'},'system.audit.package.arch':{category:'system',description:'Package architecture. ',name:'system.audit.package.arch',type:'keyword'},'system.audit.package.license':{category:'system',description:'Package license. ',name:'system.audit.package.license',type:'keyword'},'system.audit.package.installtime':{category:'system',description:'Package install time. ',name:'system.audit.package.installtime',type:'date'},'system.audit.package.size':{category:'system',description:'Package size. ',name:'system.audit.package.size',type:'long'},'system.audit.package.summary':{category:'system',description:'Package summary. ',name:'system.audit.package.summary'},'system.audit.package.url':{category:'system',description:'Package URL. ',name:'system.audit.package.url',type:'keyword'},'system.audit.user.name':{category:'system',description:'User name. ',name:'system.audit.user.name',type:'keyword'},'system.audit.user.uid':{category:'system',description:'User ID. ',name:'system.audit.user.uid',type:'keyword'},'system.audit.user.gid':{category:'system',description:'Group ID. ',name:'system.audit.user.gid',type:'keyword'},'system.audit.user.dir':{category:'system',description:"User's home directory. ",name:'system.audit.user.dir',type:'keyword'},'system.audit.user.shell':{category:'system',description:'Program to run at login. ',name:'system.audit.user.shell',type:'keyword'},'system.audit.user.user_information':{category:'system',description:'General user information. On Linux, this is the gecos field. ',name:'system.audit.user.user_information',type:'keyword'},'system.audit.user.group.name':{category:'system',description:'Group name. ',name:'system.audit.user.group.name',type:'keyword'},'system.audit.user.group.gid':{category:'system',description:'Group ID. ',name:'system.audit.user.group.gid',type:'integer'},'system.audit.user.password.type':{category:'system',description:"A user's password type. Possible values are `shadow_password` (the password hash is in the shadow file), `password_disabled`, `no_password` (this is dangerous as anyone can log in), and `crypt_password` (when the password field in /etc/passwd seems to contain an encrypted password). ",name:'system.audit.user.password.type',type:'keyword'},'system.audit.user.password.last_changed':{category:'system',description:"The day the user's password was last changed. ",name:'system.audit.user.password.last_changed',type:'date'},'log.file.path':{category:'log',description:'The file from which the line was read. This field contains the absolute path to the file. For example: `/var/log/system.log`. ',name:'log.file.path',type:'keyword'},'log.source.address':{category:'log',description:'Source address from which the log event was read / sent from. ',name:'log.source.address',type:'keyword'},'log.offset':{category:'log',description:'The file offset the reported line starts at. ',name:'log.offset',type:'long'},stream:{category:'base',description:"Log stream when reading container logs, can be 'stdout' or 'stderr' ",name:'stream',type:'keyword'},'input.type':{category:'input',description:'The input type from which the event was generated. This field is set to the value specified for the `type` option in the input section of the Filebeat config file. ',name:'input.type'},'syslog.facility':{category:'syslog',description:'The facility extracted from the priority. ',name:'syslog.facility',type:'long'},'syslog.priority':{category:'syslog',description:'The priority of the syslog event. ',name:'syslog.priority',type:'long'},'syslog.severity_label':{category:'syslog',description:'The human readable severity. ',name:'syslog.severity_label',type:'keyword'},'syslog.facility_label':{category:'syslog',description:'The human readable facility. ',name:'syslog.facility_label',type:'keyword'},'process.program':{category:'process',description:'The name of the program. ',name:'process.program',type:'keyword'},'log.flags':{category:'log',description:'This field contains the flags of the event. ',name:'log.flags'},'http.response.content_length':{category:'http',name:'http.response.content_length',type:'alias'},'user_agent.os.full_name':{category:'user_agent',name:'user_agent.os.full_name',type:'keyword'},'fileset.name':{category:'fileset',description:'The Filebeat fileset that generated this event. ',name:'fileset.name',type:'keyword'},'fileset.module':{category:'fileset',name:'fileset.module',type:'alias'},read_timestamp:{category:'base',name:'read_timestamp',type:'alias'},'docker.attrs':{category:'docker',description:"docker.attrs contains labels and environment variables written by docker's JSON File logging driver. These fields are only available when they are configured in the logging driver options. ",name:'docker.attrs',type:'object'},'icmp.code':{category:'icmp',description:'ICMP code. ',name:'icmp.code',type:'keyword'},'icmp.type':{category:'icmp',description:'ICMP type. ',name:'icmp.type',type:'keyword'},'igmp.type':{category:'igmp',description:'IGMP type. ',name:'igmp.type',type:'keyword'},'azure.eventhub':{category:'azure',description:'Name of the eventhub. ',name:'azure.eventhub',type:'keyword'},'azure.offset':{category:'azure',description:'The offset. ',name:'azure.offset',type:'long'},'azure.enqueued_time':{category:'azure',description:'The enqueued time. ',name:'azure.enqueued_time',type:'date'},'azure.partition_id':{category:'azure',description:'The partition id. ',name:'azure.partition_id',type:'long'},'azure.consumer_group':{category:'azure',description:'The consumer group. ',name:'azure.consumer_group',type:'keyword'},'azure.sequence_number':{category:'azure',description:'The sequence number. ',name:'azure.sequence_number',type:'long'},'kafka.topic':{category:'kafka',description:'Kafka topic ',name:'kafka.topic',type:'keyword'},'kafka.partition':{category:'kafka',description:'Kafka partition number ',name:'kafka.partition',type:'long'},'kafka.offset':{category:'kafka',description:'Kafka offset of this message ',name:'kafka.offset',type:'long'},'kafka.key':{category:'kafka',description:'Kafka key, corresponding to the Kafka value stored in the message ',name:'kafka.key',type:'keyword'},'kafka.block_timestamp':{category:'kafka',description:'Kafka outer (compressed) block timestamp ',name:'kafka.block_timestamp',type:'date'},'kafka.headers':{category:'kafka',description:'An array of Kafka header strings for this message, in the form "<key>: <value>". ',name:'kafka.headers',type:'array'},'apache2.access.remote_ip':{category:'apache2',name:'apache2.access.remote_ip',type:'alias'},'apache2.access.ssl.protocol':{category:'apache2',name:'apache2.access.ssl.protocol',type:'alias'},'apache2.access.ssl.cipher':{category:'apache2',name:'apache2.access.ssl.cipher',type:'alias'},'apache2.access.body_sent.bytes':{category:'apache2',name:'apache2.access.body_sent.bytes',type:'alias'},'apache2.access.user_name':{category:'apache2',name:'apache2.access.user_name',type:'alias'},'apache2.access.method':{category:'apache2',name:'apache2.access.method',type:'alias'},'apache2.access.url':{category:'apache2',name:'apache2.access.url',type:'alias'},'apache2.access.http_version':{category:'apache2',name:'apache2.access.http_version',type:'alias'},'apache2.access.response_code':{category:'apache2',name:'apache2.access.response_code',type:'alias'},'apache2.access.referrer':{category:'apache2',name:'apache2.access.referrer',type:'alias'},'apache2.access.agent':{category:'apache2',name:'apache2.access.agent',type:'alias'},'apache2.access.user_agent.device':{category:'apache2',name:'apache2.access.user_agent.device',type:'alias'},'apache2.access.user_agent.name':{category:'apache2',name:'apache2.access.user_agent.name',type:'alias'},'apache2.access.user_agent.os':{category:'apache2',name:'apache2.access.user_agent.os',type:'alias'},'apache2.access.user_agent.os_name':{category:'apache2',name:'apache2.access.user_agent.os_name',type:'alias'},'apache2.access.user_agent.original':{category:'apache2',name:'apache2.access.user_agent.original',type:'alias'},'apache2.access.geoip.continent_name':{category:'apache2',name:'apache2.access.geoip.continent_name',type:'alias'},'apache2.access.geoip.country_iso_code':{category:'apache2',name:'apache2.access.geoip.country_iso_code',type:'alias'},'apache2.access.geoip.location':{category:'apache2',name:'apache2.access.geoip.location',type:'alias'},'apache2.access.geoip.region_name':{category:'apache2',name:'apache2.access.geoip.region_name',type:'alias'},'apache2.access.geoip.city_name':{category:'apache2',name:'apache2.access.geoip.city_name',type:'alias'},'apache2.access.geoip.region_iso_code':{category:'apache2',name:'apache2.access.geoip.region_iso_code',type:'alias'},'apache2.error.level':{category:'apache2',name:'apache2.error.level',type:'alias'},'apache2.error.message':{category:'apache2',name:'apache2.error.message',type:'alias'},'apache2.error.pid':{category:'apache2',name:'apache2.error.pid',type:'alias'},'apache2.error.tid':{category:'apache2',name:'apache2.error.tid',type:'alias'},'apache2.error.module':{category:'apache2',name:'apache2.error.module',type:'alias'},'apache.access.ssl.protocol':{category:'apache',description:'SSL protocol version. ',name:'apache.access.ssl.protocol',type:'keyword'},'apache.access.ssl.cipher':{category:'apache',description:'SSL cipher name. ',name:'apache.access.ssl.cipher',type:'keyword'},'apache.error.module':{category:'apache',description:'The module producing the logged message. ',name:'apache.error.module',type:'keyword'},'user.audit.group.id':{category:'user',description:'Unique identifier for the group on the system/platform. ',name:'user.audit.group.id',type:'keyword'},'user.audit.group.name':{category:'user',description:'Name of the group. ',name:'user.audit.group.name',type:'keyword'},'user.owner.id':{category:'user',description:'One or multiple unique identifiers of the user. ',name:'user.owner.id',type:'keyword'},'user.owner.name':{category:'user',description:'Short name or login of the user. ',example:'albert',name:'user.owner.name',type:'keyword'},'user.owner.group.id':{category:'user',description:'Unique identifier for the group on the system/platform. ',name:'user.owner.group.id',type:'keyword'},'user.owner.group.name':{category:'user',description:'Name of the group. ',name:'user.owner.group.name',type:'keyword'},'auditd.log.old_auid':{category:'auditd',description:'For login events this is the old audit ID used for the user prior to this login. ',name:'auditd.log.old_auid'},'auditd.log.new_auid':{category:'auditd',description:'For login events this is the new audit ID. The audit ID can be used to trace future events to the user even if their identity changes (like becoming root). ',name:'auditd.log.new_auid'},'auditd.log.old_ses':{category:'auditd',description:'For login events this is the old session ID used for the user prior to this login. ',name:'auditd.log.old_ses'},'auditd.log.new_ses':{category:'auditd',description:'For login events this is the new session ID. It can be used to tie a user to future events by session ID. ',name:'auditd.log.new_ses'},'auditd.log.sequence':{category:'auditd',description:'The audit event sequence number. ',name:'auditd.log.sequence',type:'long'},'auditd.log.items':{category:'auditd',description:'The number of items in an event. ',name:'auditd.log.items'},'auditd.log.item':{category:'auditd',description:'The item field indicates which item out of the total number of items. This number is zero-based; a value of 0 means it is the first item. ',name:'auditd.log.item'},'auditd.log.tty':{category:'auditd',name:'auditd.log.tty',type:'keyword'},'auditd.log.a0':{category:'auditd',description:'The first argument to the system call. ',name:'auditd.log.a0'},'auditd.log.addr':{category:'auditd',name:'auditd.log.addr',type:'ip'},'auditd.log.rport':{category:'auditd',name:'auditd.log.rport',type:'long'},'auditd.log.laddr':{category:'auditd',name:'auditd.log.laddr',type:'ip'},'auditd.log.lport':{category:'auditd',name:'auditd.log.lport',type:'long'},'auditd.log.acct':{category:'auditd',name:'auditd.log.acct',type:'alias'},'auditd.log.pid':{category:'auditd',name:'auditd.log.pid',type:'alias'},'auditd.log.ppid':{category:'auditd',name:'auditd.log.ppid',type:'alias'},'auditd.log.res':{category:'auditd',name:'auditd.log.res',type:'alias'},'auditd.log.record_type':{category:'auditd',name:'auditd.log.record_type',type:'alias'},'auditd.log.geoip.continent_name':{category:'auditd',name:'auditd.log.geoip.continent_name',type:'alias'},'auditd.log.geoip.country_iso_code':{category:'auditd',name:'auditd.log.geoip.country_iso_code',type:'alias'},'auditd.log.geoip.location':{category:'auditd',name:'auditd.log.geoip.location',type:'alias'},'auditd.log.geoip.region_name':{category:'auditd',name:'auditd.log.geoip.region_name',type:'alias'},'auditd.log.geoip.city_name':{category:'auditd',name:'auditd.log.geoip.city_name',type:'alias'},'auditd.log.geoip.region_iso_code':{category:'auditd',name:'auditd.log.geoip.region_iso_code',type:'alias'},'auditd.log.arch':{category:'auditd',name:'auditd.log.arch',type:'alias'},'auditd.log.gid':{category:'auditd',name:'auditd.log.gid',type:'alias'},'auditd.log.uid':{category:'auditd',name:'auditd.log.uid',type:'alias'},'auditd.log.agid':{category:'auditd',name:'auditd.log.agid',type:'alias'},'auditd.log.auid':{category:'auditd',name:'auditd.log.auid',type:'alias'},'auditd.log.fsgid':{category:'auditd',name:'auditd.log.fsgid',type:'alias'},'auditd.log.fsuid':{category:'auditd',name:'auditd.log.fsuid',type:'alias'},'auditd.log.egid':{category:'auditd',name:'auditd.log.egid',type:'alias'},'auditd.log.euid':{category:'auditd',name:'auditd.log.euid',type:'alias'},'auditd.log.sgid':{category:'auditd',name:'auditd.log.sgid',type:'alias'},'auditd.log.suid':{category:'auditd',name:'auditd.log.suid',type:'alias'},'auditd.log.ogid':{category:'auditd',name:'auditd.log.ogid',type:'alias'},'auditd.log.ouid':{category:'auditd',name:'auditd.log.ouid',type:'alias'},'auditd.log.comm':{category:'auditd',name:'auditd.log.comm',type:'alias'},'auditd.log.exe':{category:'auditd',name:'auditd.log.exe',type:'alias'},'auditd.log.terminal':{category:'auditd',name:'auditd.log.terminal',type:'alias'},'auditd.log.msg':{category:'auditd',name:'auditd.log.msg',type:'alias'},'auditd.log.src':{category:'auditd',name:'auditd.log.src',type:'alias'},'auditd.log.dst':{category:'auditd',name:'auditd.log.dst',type:'alias'},'elasticsearch.component':{category:'elasticsearch',description:'Elasticsearch component from where the log event originated',example:'o.e.c.m.MetaDataCreateIndexService',name:'elasticsearch.component',type:'keyword'},'elasticsearch.cluster.uuid':{category:'elasticsearch',description:'UUID of the cluster',example:'GmvrbHlNTiSVYiPf8kxg9g',name:'elasticsearch.cluster.uuid',type:'keyword'},'elasticsearch.cluster.name':{category:'elasticsearch',description:'Name of the cluster',example:'docker-cluster',name:'elasticsearch.cluster.name',type:'keyword'},'elasticsearch.node.id':{category:'elasticsearch',description:'ID of the node',example:'DSiWcTyeThWtUXLB9J0BMw',name:'elasticsearch.node.id',type:'keyword'},'elasticsearch.node.name':{category:'elasticsearch',description:'Name of the node',example:'vWNJsZ3',name:'elasticsearch.node.name',type:'keyword'},'elasticsearch.index.name':{category:'elasticsearch',description:'Index name',example:'filebeat-test-input',name:'elasticsearch.index.name',type:'keyword'},'elasticsearch.index.id':{category:'elasticsearch',description:'Index id',example:'aOGgDwbURfCV57AScqbCgw',name:'elasticsearch.index.id',type:'keyword'},'elasticsearch.shard.id':{category:'elasticsearch',description:'Id of the shard',example:'0',name:'elasticsearch.shard.id',type:'keyword'},'elasticsearch.audit.layer':{category:'elasticsearch',description:'The layer from which this event originated: rest, transport or ip_filter',example:'rest',name:'elasticsearch.audit.layer',type:'keyword'},'elasticsearch.audit.event_type':{category:'elasticsearch',description:'The type of event that occurred: anonymous_access_denied, authentication_failed, access_denied, access_granted, connection_granted, connection_denied, tampered_request, run_as_granted, run_as_denied',example:'access_granted',name:'elasticsearch.audit.event_type',type:'keyword'},'elasticsearch.audit.origin.type':{category:'elasticsearch',description:'Where the request originated: rest (request originated from a REST API request), transport (request was received on the transport channel), local_node (the local node issued the request)',example:'local_node',name:'elasticsearch.audit.origin.type',type:'keyword'},'elasticsearch.audit.realm':{category:'elasticsearch',description:'The authentication realm the authentication was validated against',name:'elasticsearch.audit.realm',type:'keyword'},'elasticsearch.audit.user.realm':{category:'elasticsearch',description:"The user's authentication realm, if authenticated",name:'elasticsearch.audit.user.realm',type:'keyword'},'elasticsearch.audit.user.roles':{category:'elasticsearch',description:'Roles to which the principal belongs',example:'["kibana_admin","beats_admin"]',name:'elasticsearch.audit.user.roles',type:'keyword'},'elasticsearch.audit.action':{category:'elasticsearch',description:'The name of the action that was executed',example:'cluster:monitor/main',name:'elasticsearch.audit.action',type:'keyword'},'elasticsearch.audit.url.params':{category:'elasticsearch',description:'REST URI parameters',example:'{username=jacknich2}',name:'elasticsearch.audit.url.params'},'elasticsearch.audit.indices':{category:'elasticsearch',description:'Indices accessed by action',example:'["foo-2019.01.04","foo-2019.01.03","foo-2019.01.06"]',name:'elasticsearch.audit.indices',type:'keyword'},'elasticsearch.audit.request.id':{category:'elasticsearch',description:'Unique ID of request',example:'WzL_kb6VSvOhAq0twPvHOQ',name:'elasticsearch.audit.request.id',type:'keyword'},'elasticsearch.audit.request.name':{category:'elasticsearch',description:'The type of request that was executed',example:'ClearScrollRequest',name:'elasticsearch.audit.request.name',type:'keyword'},'elasticsearch.audit.request_body':{category:'elasticsearch',name:'elasticsearch.audit.request_body',type:'alias'},'elasticsearch.audit.origin_address':{category:'elasticsearch',name:'elasticsearch.audit.origin_address',type:'alias'},'elasticsearch.audit.uri':{category:'elasticsearch',name:'elasticsearch.audit.uri',type:'alias'},'elasticsearch.audit.principal':{category:'elasticsearch',name:'elasticsearch.audit.principal',type:'alias'},'elasticsearch.audit.message':{category:'elasticsearch',name:'elasticsearch.audit.message',type:'text'},'elasticsearch.deprecation':{category:'elasticsearch',description:'',name:'elasticsearch.deprecation',type:'group'},'elasticsearch.gc.phase.name':{category:'elasticsearch',description:'Name of the GC collection phase. ',name:'elasticsearch.gc.phase.name',type:'keyword'},'elasticsearch.gc.phase.duration_sec':{category:'elasticsearch',description:'Collection phase duration according to the Java virtual machine. ',name:'elasticsearch.gc.phase.duration_sec',type:'float'},'elasticsearch.gc.phase.scrub_symbol_table_time_sec':{category:'elasticsearch',description:'Pause time in seconds cleaning up symbol tables. ',name:'elasticsearch.gc.phase.scrub_symbol_table_time_sec',type:'float'},'elasticsearch.gc.phase.scrub_string_table_time_sec':{category:'elasticsearch',description:'Pause time in seconds cleaning up string tables. ',name:'elasticsearch.gc.phase.scrub_string_table_time_sec',type:'float'},'elasticsearch.gc.phase.weak_refs_processing_time_sec':{category:'elasticsearch',description:'Time spent processing weak references in seconds. ',name:'elasticsearch.gc.phase.weak_refs_processing_time_sec',type:'float'},'elasticsearch.gc.phase.parallel_rescan_time_sec':{category:'elasticsearch',description:'Time spent in seconds marking live objects while application is stopped. ',name:'elasticsearch.gc.phase.parallel_rescan_time_sec',type:'float'},'elasticsearch.gc.phase.class_unload_time_sec':{category:'elasticsearch',description:'Time spent unloading unused classes in seconds. ',name:'elasticsearch.gc.phase.class_unload_time_sec',type:'float'},'elasticsearch.gc.phase.cpu_time.user_sec':{category:'elasticsearch',description:'CPU time spent outside the kernel. ',name:'elasticsearch.gc.phase.cpu_time.user_sec',type:'float'},'elasticsearch.gc.phase.cpu_time.sys_sec':{category:'elasticsearch',description:'CPU time spent inside the kernel.  ',name:'elasticsearch.gc.phase.cpu_time.sys_sec',type:'float'},'elasticsearch.gc.phase.cpu_time.real_sec':{category:'elasticsearch',description:'Total elapsed CPU time spent to complete the collection from start to finish. ',name:'elasticsearch.gc.phase.cpu_time.real_sec',type:'float'},'elasticsearch.gc.jvm_runtime_sec':{category:'elasticsearch',description:'The time from JVM start up in seconds, as a floating point number. ',name:'elasticsearch.gc.jvm_runtime_sec',type:'float'},'elasticsearch.gc.threads_total_stop_time_sec':{category:'elasticsearch',description:'Garbage collection threads total stop time seconds. ',name:'elasticsearch.gc.threads_total_stop_time_sec',type:'float'},'elasticsearch.gc.stopping_threads_time_sec':{category:'elasticsearch',description:'Time took to stop threads seconds. ',name:'elasticsearch.gc.stopping_threads_time_sec',type:'float'},'elasticsearch.gc.tags':{category:'elasticsearch',description:'GC logging tags. ',name:'elasticsearch.gc.tags',type:'keyword'},'elasticsearch.gc.heap.size_kb':{category:'elasticsearch',description:'Total heap size in kilobytes. ',name:'elasticsearch.gc.heap.size_kb',type:'integer'},'elasticsearch.gc.heap.used_kb':{category:'elasticsearch',description:'Used heap in kilobytes. ',name:'elasticsearch.gc.heap.used_kb',type:'integer'},'elasticsearch.gc.old_gen.size_kb':{category:'elasticsearch',description:'Total size of old generation in kilobytes. ',name:'elasticsearch.gc.old_gen.size_kb',type:'integer'},'elasticsearch.gc.old_gen.used_kb':{category:'elasticsearch',description:'Old generation occupancy in kilobytes. ',name:'elasticsearch.gc.old_gen.used_kb',type:'integer'},'elasticsearch.gc.young_gen.size_kb':{category:'elasticsearch',description:'Total size of young generation in kilobytes. ',name:'elasticsearch.gc.young_gen.size_kb',type:'integer'},'elasticsearch.gc.young_gen.used_kb':{category:'elasticsearch',description:'Young generation occupancy in kilobytes. ',name:'elasticsearch.gc.young_gen.used_kb',type:'integer'},'elasticsearch.server.stacktrace':{category:'elasticsearch',name:'elasticsearch.server.stacktrace'},'elasticsearch.server.gc.young.one':{category:'elasticsearch',description:'',example:'',name:'elasticsearch.server.gc.young.one',type:'long'},'elasticsearch.server.gc.young.two':{category:'elasticsearch',description:'',example:'',name:'elasticsearch.server.gc.young.two',type:'long'},'elasticsearch.server.gc.overhead_seq':{category:'elasticsearch',description:'Sequence number',example:3449992,name:'elasticsearch.server.gc.overhead_seq',type:'long'},'elasticsearch.server.gc.collection_duration.ms':{category:'elasticsearch',description:'Time spent in GC, in milliseconds',example:1600,name:'elasticsearch.server.gc.collection_duration.ms',type:'float'},'elasticsearch.server.gc.observation_duration.ms':{category:'elasticsearch',description:'Total time over which collection was observed, in milliseconds',example:1800,name:'elasticsearch.server.gc.observation_duration.ms',type:'float'},'elasticsearch.slowlog.logger':{category:'elasticsearch',description:'Logger name',example:'index.search.slowlog.fetch',name:'elasticsearch.slowlog.logger',type:'keyword'},'elasticsearch.slowlog.took':{category:'elasticsearch',description:'Time it took to execute the query',example:'300ms',name:'elasticsearch.slowlog.took',type:'keyword'},'elasticsearch.slowlog.types':{category:'elasticsearch',description:'Types',example:'',name:'elasticsearch.slowlog.types',type:'keyword'},'elasticsearch.slowlog.stats':{category:'elasticsearch',description:'Stats groups',example:'group1',name:'elasticsearch.slowlog.stats',type:'keyword'},'elasticsearch.slowlog.search_type':{category:'elasticsearch',description:'Search type',example:'QUERY_THEN_FETCH',name:'elasticsearch.slowlog.search_type',type:'keyword'},'elasticsearch.slowlog.source_query':{category:'elasticsearch',description:'Slow query',example:'{"query":{"match_all":{"boost":1.0}}}',name:'elasticsearch.slowlog.source_query',type:'keyword'},'elasticsearch.slowlog.extra_source':{category:'elasticsearch',description:'Extra source information',example:'',name:'elasticsearch.slowlog.extra_source',type:'keyword'},'elasticsearch.slowlog.total_hits':{category:'elasticsearch',description:'Total hits',example:42,name:'elasticsearch.slowlog.total_hits',type:'keyword'},'elasticsearch.slowlog.total_shards':{category:'elasticsearch',description:'Total queried shards',example:22,name:'elasticsearch.slowlog.total_shards',type:'keyword'},'elasticsearch.slowlog.routing':{category:'elasticsearch',description:'Routing',example:'s01HZ2QBk9jw4gtgaFtn',name:'elasticsearch.slowlog.routing',type:'keyword'},'elasticsearch.slowlog.id':{category:'elasticsearch',description:'Id',example:'',name:'elasticsearch.slowlog.id',type:'keyword'},'elasticsearch.slowlog.type':{category:'elasticsearch',description:'Type',example:'doc',name:'elasticsearch.slowlog.type',type:'keyword'},'elasticsearch.slowlog.source':{category:'elasticsearch',description:'Source of document that was indexed',name:'elasticsearch.slowlog.source',type:'keyword'},'haproxy.frontend_name':{category:'haproxy',description:'Name of the frontend (or listener) which received and processed the connection.',name:'haproxy.frontend_name'},'haproxy.backend_name':{category:'haproxy',description:'Name of the backend (or listener) which was selected to manage the connection to the server.',name:'haproxy.backend_name'},'haproxy.server_name':{category:'haproxy',description:'Name of the last server to which the connection was sent.',name:'haproxy.server_name'},'haproxy.total_waiting_time_ms':{category:'haproxy',description:'Total time in milliseconds spent waiting in the various queues',name:'haproxy.total_waiting_time_ms',type:'long'},'haproxy.connection_wait_time_ms':{category:'haproxy',description:'Total time in milliseconds spent waiting for the connection to establish to the final server',name:'haproxy.connection_wait_time_ms',type:'long'},'haproxy.bytes_read':{category:'haproxy',description:'Total number of bytes transmitted to the client when the log is emitted.',name:'haproxy.bytes_read',type:'long'},'haproxy.time_queue':{category:'haproxy',description:'Total time in milliseconds spent waiting in the various queues.',name:'haproxy.time_queue',type:'long'},'haproxy.time_backend_connect':{category:'haproxy',description:'Total time in milliseconds spent waiting for the connection to establish to the final server, including retries.',name:'haproxy.time_backend_connect',type:'long'},'haproxy.server_queue':{category:'haproxy',description:'Total number of requests which were processed before this one in the server queue.',name:'haproxy.server_queue',type:'long'},'haproxy.backend_queue':{category:'haproxy',description:"Total number of requests which were processed before this one in the backend's global queue.",name:'haproxy.backend_queue',type:'long'},'haproxy.bind_name':{category:'haproxy',description:'Name of the listening address which received the connection.',name:'haproxy.bind_name'},'haproxy.error_message':{category:'haproxy',description:'Error message logged by HAProxy in case of error.',name:'haproxy.error_message',type:'text'},'haproxy.source':{category:'haproxy',description:'The HAProxy source of the log',name:'haproxy.source',type:'keyword'},'haproxy.termination_state':{category:'haproxy',description:'Condition the session was in when the session ended.',name:'haproxy.termination_state'},'haproxy.mode':{category:'haproxy',description:'mode that the frontend is operating (TCP or HTTP)',name:'haproxy.mode',type:'keyword'},'haproxy.connections.active':{category:'haproxy',description:'Total number of concurrent connections on the process when the session was logged.',name:'haproxy.connections.active',type:'long'},'haproxy.connections.frontend':{category:'haproxy',description:'Total number of concurrent connections on the frontend when the session was logged.',name:'haproxy.connections.frontend',type:'long'},'haproxy.connections.backend':{category:'haproxy',description:'Total number of concurrent connections handled by the backend when the session was logged.',name:'haproxy.connections.backend',type:'long'},'haproxy.connections.server':{category:'haproxy',description:'Total number of concurrent connections still active on the server when the session was logged.',name:'haproxy.connections.server',type:'long'},'haproxy.connections.retries':{category:'haproxy',description:'Number of connection retries experienced by this session when trying to connect to the server.',name:'haproxy.connections.retries',type:'long'},'haproxy.client.ip':{category:'haproxy',name:'haproxy.client.ip',type:'alias'},'haproxy.client.port':{category:'haproxy',name:'haproxy.client.port',type:'alias'},'haproxy.process_name':{category:'haproxy',name:'haproxy.process_name',type:'alias'},'haproxy.pid':{category:'haproxy',name:'haproxy.pid',type:'alias'},'haproxy.destination.port':{category:'haproxy',name:'haproxy.destination.port',type:'alias'},'haproxy.destination.ip':{category:'haproxy',name:'haproxy.destination.ip',type:'alias'},'haproxy.geoip.continent_name':{category:'haproxy',name:'haproxy.geoip.continent_name',type:'alias'},'haproxy.geoip.country_iso_code':{category:'haproxy',name:'haproxy.geoip.country_iso_code',type:'alias'},'haproxy.geoip.location':{category:'haproxy',name:'haproxy.geoip.location',type:'alias'},'haproxy.geoip.region_name':{category:'haproxy',name:'haproxy.geoip.region_name',type:'alias'},'haproxy.geoip.city_name':{category:'haproxy',name:'haproxy.geoip.city_name',type:'alias'},'haproxy.geoip.region_iso_code':{category:'haproxy',name:'haproxy.geoip.region_iso_code',type:'alias'},'haproxy.http.response.captured_cookie':{category:'haproxy',description:'Optional "name=value" entry indicating that the client had this cookie in the response. ',name:'haproxy.http.response.captured_cookie'},'haproxy.http.response.captured_headers':{category:'haproxy',description:'List of headers captured in the response due to the presence of the "capture response header" statement in the frontend. ',name:'haproxy.http.response.captured_headers',type:'keyword'},'haproxy.http.response.status_code':{category:'haproxy',name:'haproxy.http.response.status_code',type:'alias'},'haproxy.http.request.captured_cookie':{category:'haproxy',description:'Optional "name=value" entry indicating that the server has returned a cookie with its request. ',name:'haproxy.http.request.captured_cookie'},'haproxy.http.request.captured_headers':{category:'haproxy',description:'List of headers captured in the request due to the presence of the "capture request header" statement in the frontend. ',name:'haproxy.http.request.captured_headers',type:'keyword'},'haproxy.http.request.raw_request_line':{category:'haproxy',description:'Complete HTTP request line, including the method, request and HTTP version string.',name:'haproxy.http.request.raw_request_line',type:'keyword'},'haproxy.http.request.time_wait_without_data_ms':{category:'haproxy',description:'Total time in milliseconds spent waiting for the server to send a full HTTP response, not counting data.',name:'haproxy.http.request.time_wait_without_data_ms',type:'long'},'haproxy.http.request.time_wait_ms':{category:'haproxy',description:'Total time in milliseconds spent waiting for a full HTTP request from the client (not counting body) after the first byte was received.',name:'haproxy.http.request.time_wait_ms',type:'long'},'haproxy.tcp.connection_waiting_time_ms':{category:'haproxy',description:'Total time in milliseconds elapsed between the accept and the last close',name:'haproxy.tcp.connection_waiting_time_ms',type:'long'},'icinga.debug.facility':{category:'icinga',description:'Specifies what component of Icinga logged the message. ',name:'icinga.debug.facility',type:'keyword'},'icinga.debug.severity':{category:'icinga',name:'icinga.debug.severity',type:'alias'},'icinga.debug.message':{category:'icinga',name:'icinga.debug.message',type:'alias'},'icinga.main.facility':{category:'icinga',description:'Specifies what component of Icinga logged the message. ',name:'icinga.main.facility',type:'keyword'},'icinga.main.severity':{category:'icinga',name:'icinga.main.severity',type:'alias'},'icinga.main.message':{category:'icinga',name:'icinga.main.message',type:'alias'},'icinga.startup.facility':{category:'icinga',description:'Specifies what component of Icinga logged the message. ',name:'icinga.startup.facility',type:'keyword'},'icinga.startup.severity':{category:'icinga',name:'icinga.startup.severity',type:'alias'},'icinga.startup.message':{category:'icinga',name:'icinga.startup.message',type:'alias'},'iis.access.sub_status':{category:'iis',description:'The HTTP substatus code. ',name:'iis.access.sub_status',type:'long'},'iis.access.win32_status':{category:'iis',description:'The Windows status code. ',name:'iis.access.win32_status',type:'long'},'iis.access.site_name':{category:'iis',description:'The site name and instance number. ',name:'iis.access.site_name',type:'keyword'},'iis.access.server_name':{category:'iis',description:'The name of the server on which the log file entry was generated. ',name:'iis.access.server_name',type:'keyword'},'iis.access.cookie':{category:'iis',description:'The content of the cookie sent or received, if any. ',name:'iis.access.cookie',type:'keyword'},'iis.access.body_received.bytes':{category:'iis',name:'iis.access.body_received.bytes',type:'alias'},'iis.access.body_sent.bytes':{category:'iis',name:'iis.access.body_sent.bytes',type:'alias'},'iis.access.server_ip':{category:'iis',name:'iis.access.server_ip',type:'alias'},'iis.access.method':{category:'iis',name:'iis.access.method',type:'alias'},'iis.access.url':{category:'iis',name:'iis.access.url',type:'alias'},'iis.access.query_string':{category:'iis',name:'iis.access.query_string',type:'alias'},'iis.access.port':{category:'iis',name:'iis.access.port',type:'alias'},'iis.access.user_name':{category:'iis',name:'iis.access.user_name',type:'alias'},'iis.access.remote_ip':{category:'iis',name:'iis.access.remote_ip',type:'alias'},'iis.access.referrer':{category:'iis',name:'iis.access.referrer',type:'alias'},'iis.access.response_code':{category:'iis',name:'iis.access.response_code',type:'alias'},'iis.access.http_version':{category:'iis',name:'iis.access.http_version',type:'alias'},'iis.access.hostname':{category:'iis',name:'iis.access.hostname',type:'alias'},'iis.access.user_agent.device':{category:'iis',name:'iis.access.user_agent.device',type:'alias'},'iis.access.user_agent.name':{category:'iis',name:'iis.access.user_agent.name',type:'alias'},'iis.access.user_agent.os':{category:'iis',name:'iis.access.user_agent.os',type:'alias'},'iis.access.user_agent.os_name':{category:'iis',name:'iis.access.user_agent.os_name',type:'alias'},'iis.access.user_agent.original':{category:'iis',name:'iis.access.user_agent.original',type:'alias'},'iis.access.geoip.continent_name':{category:'iis',name:'iis.access.geoip.continent_name',type:'alias'},'iis.access.geoip.country_iso_code':{category:'iis',name:'iis.access.geoip.country_iso_code',type:'alias'},'iis.access.geoip.location':{category:'iis',name:'iis.access.geoip.location',type:'alias'},'iis.access.geoip.region_name':{category:'iis',name:'iis.access.geoip.region_name',type:'alias'},'iis.access.geoip.city_name':{category:'iis',name:'iis.access.geoip.city_name',type:'alias'},'iis.access.geoip.region_iso_code':{category:'iis',name:'iis.access.geoip.region_iso_code',type:'alias'},'iis.error.reason_phrase':{category:'iis',description:'The HTTP reason phrase. ',name:'iis.error.reason_phrase',type:'keyword'},'iis.error.queue_name':{category:'iis',description:'The IIS application pool name. ',name:'iis.error.queue_name',type:'keyword'},'iis.error.remote_ip':{category:'iis',name:'iis.error.remote_ip',type:'alias'},'iis.error.remote_port':{category:'iis',name:'iis.error.remote_port',type:'alias'},'iis.error.server_ip':{category:'iis',name:'iis.error.server_ip',type:'alias'},'iis.error.server_port':{category:'iis',name:'iis.error.server_port',type:'alias'},'iis.error.http_version':{category:'iis',name:'iis.error.http_version',type:'alias'},'iis.error.method':{category:'iis',name:'iis.error.method',type:'alias'},'iis.error.url':{category:'iis',name:'iis.error.url',type:'alias'},'iis.error.response_code':{category:'iis',name:'iis.error.response_code',type:'alias'},'iis.error.geoip.continent_name':{category:'iis',name:'iis.error.geoip.continent_name',type:'alias'},'iis.error.geoip.country_iso_code':{category:'iis',name:'iis.error.geoip.country_iso_code',type:'alias'},'iis.error.geoip.location':{category:'iis',name:'iis.error.geoip.location',type:'alias'},'iis.error.geoip.region_name':{category:'iis',name:'iis.error.geoip.region_name',type:'alias'},'iis.error.geoip.city_name':{category:'iis',name:'iis.error.geoip.city_name',type:'alias'},'iis.error.geoip.region_iso_code':{category:'iis',name:'iis.error.geoip.region_iso_code',type:'alias'},'kafka.log.level':{category:'kafka',name:'kafka.log.level',type:'alias'},'kafka.log.message':{category:'kafka',name:'kafka.log.message',type:'alias'},'kafka.log.component':{category:'kafka',description:'Component the log is coming from. ',name:'kafka.log.component',type:'keyword'},'kafka.log.class':{category:'kafka',description:'Java class the log is coming from. ',name:'kafka.log.class',type:'keyword'},'kafka.log.thread':{category:'kafka',description:'Thread name the log is coming from. ',name:'kafka.log.thread',type:'keyword'},'kafka.log.trace.class':{category:'kafka',description:'Java class the trace is coming from. ',name:'kafka.log.trace.class',type:'keyword'},'kafka.log.trace.message':{category:'kafka',description:'Message part of the trace. ',name:'kafka.log.trace.message',type:'text'},'kibana.log.tags':{category:'kibana',description:'Kibana logging tags. ',name:'kibana.log.tags',type:'keyword'},'kibana.log.state':{category:'kibana',description:'Current state of Kibana. ',name:'kibana.log.state',type:'keyword'},'kibana.log.meta':{category:'kibana',name:'kibana.log.meta',type:'object'},'kibana.log.kibana.log.meta.req.headers.referer':{category:'kibana',name:'kibana.log.kibana.log.meta.req.headers.referer',type:'alias'},'kibana.log.kibana.log.meta.req.referer':{category:'kibana',name:'kibana.log.kibana.log.meta.req.referer',type:'alias'},'kibana.log.kibana.log.meta.req.headers.user-agent':{category:'kibana',name:'kibana.log.kibana.log.meta.req.headers.user-agent',type:'alias'},'kibana.log.kibana.log.meta.req.remoteAddress':{category:'kibana',name:'kibana.log.kibana.log.meta.req.remoteAddress',type:'alias'},'kibana.log.kibana.log.meta.req.url':{category:'kibana',name:'kibana.log.kibana.log.meta.req.url',type:'alias'},'kibana.log.kibana.log.meta.statusCode':{category:'kibana',name:'kibana.log.kibana.log.meta.statusCode',type:'alias'},'kibana.log.kibana.log.meta.method':{category:'kibana',name:'kibana.log.kibana.log.meta.method',type:'alias'},'logstash.log.module':{category:'logstash',description:'The module or class where the event originate. ',name:'logstash.log.module',type:'keyword'},'logstash.log.thread':{category:'logstash',description:'Information about the running thread where the log originate. ',name:'logstash.log.thread',type:'keyword'},'logstash.log.log_event':{category:'logstash',description:'key and value debugging information. ',name:'logstash.log.log_event',type:'object'},'logstash.log.pipeline_id':{category:'logstash',description:'The ID of the pipeline. ',example:'main',name:'logstash.log.pipeline_id',type:'keyword'},'logstash.log.message':{category:'logstash',name:'logstash.log.message',type:'alias'},'logstash.log.level':{category:'logstash',name:'logstash.log.level',type:'alias'},'logstash.slowlog.module':{category:'logstash',description:'The module or class where the event originate. ',name:'logstash.slowlog.module',type:'keyword'},'logstash.slowlog.thread':{category:'logstash',description:'Information about the running thread where the log originate. ',name:'logstash.slowlog.thread',type:'keyword'},'logstash.slowlog.event':{category:'logstash',description:'Raw dump of the original event ',name:'logstash.slowlog.event',type:'keyword'},'logstash.slowlog.plugin_name':{category:'logstash',description:'Name of the plugin ',name:'logstash.slowlog.plugin_name',type:'keyword'},'logstash.slowlog.plugin_type':{category:'logstash',description:'Type of the plugin: Inputs, Filters, Outputs or Codecs. ',name:'logstash.slowlog.plugin_type',type:'keyword'},'logstash.slowlog.took_in_millis':{category:'logstash',description:'Execution time for the plugin in milliseconds. ',name:'logstash.slowlog.took_in_millis',type:'long'},'logstash.slowlog.plugin_params':{category:'logstash',description:'String value of the plugin configuration ',name:'logstash.slowlog.plugin_params',type:'keyword'},'logstash.slowlog.plugin_params_object':{category:'logstash',description:'key -> value of the configuration used by the plugin. ',name:'logstash.slowlog.plugin_params_object',type:'object'},'logstash.slowlog.level':{category:'logstash',name:'logstash.slowlog.level',type:'alias'},'logstash.slowlog.took_in_nanos':{category:'logstash',name:'logstash.slowlog.took_in_nanos',type:'alias'},'mongodb.log.component':{category:'mongodb',description:'Functional categorization of message ',example:'COMMAND',name:'mongodb.log.component',type:'keyword'},'mongodb.log.context':{category:'mongodb',description:'Context of message ',example:'initandlisten',name:'mongodb.log.context',type:'keyword'},'mongodb.log.severity':{category:'mongodb',name:'mongodb.log.severity',type:'alias'},'mongodb.log.message':{category:'mongodb',name:'mongodb.log.message',type:'alias'},'mysql.thread_id':{category:'mysql',description:'The connection or thread ID for the query. ',name:'mysql.thread_id',type:'long'},'mysql.error.thread_id':{category:'mysql',name:'mysql.error.thread_id',type:'alias'},'mysql.error.level':{category:'mysql',name:'mysql.error.level',type:'alias'},'mysql.error.message':{category:'mysql',name:'mysql.error.message',type:'alias'},'mysql.slowlog.lock_time.sec':{category:'mysql',description:'The amount of time the query waited for the lock to be available. The value is in seconds, as a floating point number. ',name:'mysql.slowlog.lock_time.sec',type:'float'},'mysql.slowlog.rows_sent':{category:'mysql',description:'The number of rows returned by the query. ',name:'mysql.slowlog.rows_sent',type:'long'},'mysql.slowlog.rows_examined':{category:'mysql',description:'The number of rows scanned by the query. ',name:'mysql.slowlog.rows_examined',type:'long'},'mysql.slowlog.rows_affected':{category:'mysql',description:'The number of rows modified by the query. ',name:'mysql.slowlog.rows_affected',type:'long'},'mysql.slowlog.bytes_sent':{category:'mysql',description:'The number of bytes sent to client. ',name:'mysql.slowlog.bytes_sent',type:'long',format:'bytes'},'mysql.slowlog.bytes_received':{category:'mysql',description:'The number of bytes received from client. ',name:'mysql.slowlog.bytes_received',type:'long',format:'bytes'},'mysql.slowlog.query':{category:'mysql',description:'The slow query. ',name:'mysql.slowlog.query'},'mysql.slowlog.id':{category:'mysql',name:'mysql.slowlog.id',type:'alias'},'mysql.slowlog.schema':{category:'mysql',description:'The schema where the slow query was executed. ',name:'mysql.slowlog.schema',type:'keyword'},'mysql.slowlog.current_user':{category:'mysql',description:'Current authenticated user, used to determine access privileges. Can differ from the value for user. ',name:'mysql.slowlog.current_user',type:'keyword'},'mysql.slowlog.last_errno':{category:'mysql',description:'Last SQL error seen. ',name:'mysql.slowlog.last_errno',type:'keyword'},'mysql.slowlog.killed':{category:'mysql',description:'Code of the reason if the query was killed. ',name:'mysql.slowlog.killed',type:'keyword'},'mysql.slowlog.query_cache_hit':{category:'mysql',description:'Whether the query cache was hit. ',name:'mysql.slowlog.query_cache_hit',type:'boolean'},'mysql.slowlog.tmp_table':{category:'mysql',description:'Whether a temporary table was used to resolve the query. ',name:'mysql.slowlog.tmp_table',type:'boolean'},'mysql.slowlog.tmp_table_on_disk':{category:'mysql',description:'Whether the query needed temporary tables on disk. ',name:'mysql.slowlog.tmp_table_on_disk',type:'boolean'},'mysql.slowlog.tmp_tables':{category:'mysql',description:'Number of temporary tables created for this query ',name:'mysql.slowlog.tmp_tables',type:'long'},'mysql.slowlog.tmp_disk_tables':{category:'mysql',description:'Number of temporary tables created on disk for this query. ',name:'mysql.slowlog.tmp_disk_tables',type:'long'},'mysql.slowlog.tmp_table_sizes':{category:'mysql',description:'Size of temporary tables created for this query.',name:'mysql.slowlog.tmp_table_sizes',type:'long',format:'bytes'},'mysql.slowlog.filesort':{category:'mysql',description:'Whether filesort optimization was used. ',name:'mysql.slowlog.filesort',type:'boolean'},'mysql.slowlog.filesort_on_disk':{category:'mysql',description:'Whether filesort optimization was used and it needed temporary tables on disk. ',name:'mysql.slowlog.filesort_on_disk',type:'boolean'},'mysql.slowlog.priority_queue':{category:'mysql',description:'Whether a priority queue was used for filesort. ',name:'mysql.slowlog.priority_queue',type:'boolean'},'mysql.slowlog.full_scan':{category:'mysql',description:'Whether a full table scan was needed for the slow query. ',name:'mysql.slowlog.full_scan',type:'boolean'},'mysql.slowlog.full_join':{category:'mysql',description:'Whether a full join was needed for the slow query (no indexes were used for joins). ',name:'mysql.slowlog.full_join',type:'boolean'},'mysql.slowlog.merge_passes':{category:'mysql',description:'Number of merge passes executed for the query. ',name:'mysql.slowlog.merge_passes',type:'long'},'mysql.slowlog.sort_merge_passes':{category:'mysql',description:'Number of merge passes that the sort algorithm has had to do. ',name:'mysql.slowlog.sort_merge_passes',type:'long'},'mysql.slowlog.sort_range_count':{category:'mysql',description:'Number of sorts that were done using ranges.  ',name:'mysql.slowlog.sort_range_count',type:'long'},'mysql.slowlog.sort_rows':{category:'mysql',description:'Number of sorted rows. ',name:'mysql.slowlog.sort_rows',type:'long'},'mysql.slowlog.sort_scan_count':{category:'mysql',description:'Number of sorts that were done by scanning the table. ',name:'mysql.slowlog.sort_scan_count',type:'long'},'mysql.slowlog.log_slow_rate_type':{category:'mysql',description:'Type of slow log rate limit, it can be `session` if the rate limit is applied per session, or `query` if it applies per query. ',name:'mysql.slowlog.log_slow_rate_type',type:'keyword'},'mysql.slowlog.log_slow_rate_limit':{category:'mysql',description:'Slow log rate limit, a value of 100 means that one in a hundred queries or sessions are being logged. ',name:'mysql.slowlog.log_slow_rate_limit',type:'keyword'},'mysql.slowlog.read_first':{category:'mysql',description:'The number of times the first entry in an index was read. ',name:'mysql.slowlog.read_first',type:'long'},'mysql.slowlog.read_last':{category:'mysql',description:'The number of times the last key in an index was read. ',name:'mysql.slowlog.read_last',type:'long'},'mysql.slowlog.read_key':{category:'mysql',description:'The number of requests to read a row based on a key. ',name:'mysql.slowlog.read_key',type:'long'},'mysql.slowlog.read_next':{category:'mysql',description:'The number of requests to read the next row in key order. ',name:'mysql.slowlog.read_next',type:'long'},'mysql.slowlog.read_prev':{category:'mysql',description:'The number of requests to read the previous row in key order. ',name:'mysql.slowlog.read_prev',type:'long'},'mysql.slowlog.read_rnd':{category:'mysql',description:'The number of requests to read a row based on a fixed position.  ',name:'mysql.slowlog.read_rnd',type:'long'},'mysql.slowlog.read_rnd_next':{category:'mysql',description:'The number of requests to read the next row in the data file. ',name:'mysql.slowlog.read_rnd_next',type:'long'},'mysql.slowlog.innodb.trx_id':{category:'mysql',description:'Transaction ID ',name:'mysql.slowlog.innodb.trx_id',type:'keyword'},'mysql.slowlog.innodb.io_r_ops':{category:'mysql',description:'Number of page read operations. ',name:'mysql.slowlog.innodb.io_r_ops',type:'long'},'mysql.slowlog.innodb.io_r_bytes':{category:'mysql',description:'Bytes read during page read operations. ',name:'mysql.slowlog.innodb.io_r_bytes',type:'long',format:'bytes'},'mysql.slowlog.innodb.io_r_wait.sec':{category:'mysql',description:'How long it took to read all needed data from storage. ',name:'mysql.slowlog.innodb.io_r_wait.sec',type:'long'},'mysql.slowlog.innodb.rec_lock_wait.sec':{category:'mysql',description:'How long the query waited for locks. ',name:'mysql.slowlog.innodb.rec_lock_wait.sec',type:'long'},'mysql.slowlog.innodb.queue_wait.sec':{category:'mysql',description:'How long the query waited to enter the InnoDB queue and to be executed once in the queue. ',name:'mysql.slowlog.innodb.queue_wait.sec',type:'long'},'mysql.slowlog.innodb.pages_distinct':{category:'mysql',description:'Approximated count of pages accessed to execute the query. ',name:'mysql.slowlog.innodb.pages_distinct',type:'long'},'mysql.slowlog.user':{category:'mysql',name:'mysql.slowlog.user',type:'alias'},'mysql.slowlog.host':{category:'mysql',name:'mysql.slowlog.host',type:'alias'},'mysql.slowlog.ip':{category:'mysql',name:'mysql.slowlog.ip',type:'alias'},'nats.log.client.id':{category:'nats',description:'The id of the client ',name:'nats.log.client.id',type:'integer'},'nats.log.msg.bytes':{category:'nats',description:'Size of the payload in bytes ',name:'nats.log.msg.bytes',type:'long',format:'bytes'},'nats.log.msg.type':{category:'nats',description:'The protocol message type ',name:'nats.log.msg.type',type:'keyword'},'nats.log.msg.subject':{category:'nats',description:'Subject name this message was received on ',name:'nats.log.msg.subject',type:'keyword'},'nats.log.msg.sid':{category:'nats',description:'The unique alphanumeric subscription ID of the subject ',name:'nats.log.msg.sid',type:'integer'},'nats.log.msg.reply_to':{category:'nats',description:'The inbox subject on which the publisher is listening for responses ',name:'nats.log.msg.reply_to',type:'keyword'},'nats.log.msg.max_messages':{category:'nats',description:'An optional number of messages to wait for before automatically unsubscribing ',name:'nats.log.msg.max_messages',type:'integer'},'nats.log.msg.error.message':{category:'nats',description:'Details about the error occurred ',name:'nats.log.msg.error.message',type:'text'},'nats.log.msg.queue_group':{category:'nats',description:'The queue group which subscriber will join ',name:'nats.log.msg.queue_group',type:'text'},'nginx.access.remote_ip_list':{category:'nginx',description:'An array of remote IP addresses. It is a list because it is common to include, besides the client IP address, IP addresses from headers like `X-Forwarded-For`. Real source IP is restored to `source.ip`. ',name:'nginx.access.remote_ip_list',type:'array'},'nginx.access.body_sent.bytes':{category:'nginx',name:'nginx.access.body_sent.bytes',type:'alias'},'nginx.access.user_name':{category:'nginx',name:'nginx.access.user_name',type:'alias'},'nginx.access.method':{category:'nginx',name:'nginx.access.method',type:'alias'},'nginx.access.url':{category:'nginx',name:'nginx.access.url',type:'alias'},'nginx.access.http_version':{category:'nginx',name:'nginx.access.http_version',type:'alias'},'nginx.access.response_code':{category:'nginx',name:'nginx.access.response_code',type:'alias'},'nginx.access.referrer':{category:'nginx',name:'nginx.access.referrer',type:'alias'},'nginx.access.agent':{category:'nginx',name:'nginx.access.agent',type:'alias'},'nginx.access.user_agent.device':{category:'nginx',name:'nginx.access.user_agent.device',type:'alias'},'nginx.access.user_agent.name':{category:'nginx',name:'nginx.access.user_agent.name',type:'alias'},'nginx.access.user_agent.os':{category:'nginx',name:'nginx.access.user_agent.os',type:'alias'},'nginx.access.user_agent.os_name':{category:'nginx',name:'nginx.access.user_agent.os_name',type:'alias'},'nginx.access.user_agent.original':{category:'nginx',name:'nginx.access.user_agent.original',type:'alias'},'nginx.access.geoip.continent_name':{category:'nginx',name:'nginx.access.geoip.continent_name',type:'alias'},'nginx.access.geoip.country_iso_code':{category:'nginx',name:'nginx.access.geoip.country_iso_code',type:'alias'},'nginx.access.geoip.location':{category:'nginx',name:'nginx.access.geoip.location',type:'alias'},'nginx.access.geoip.region_name':{category:'nginx',name:'nginx.access.geoip.region_name',type:'alias'},'nginx.access.geoip.city_name':{category:'nginx',name:'nginx.access.geoip.city_name',type:'alias'},'nginx.access.geoip.region_iso_code':{category:'nginx',name:'nginx.access.geoip.region_iso_code',type:'alias'},'nginx.error.connection_id':{category:'nginx',description:'Connection identifier. ',name:'nginx.error.connection_id',type:'long'},'nginx.error.level':{category:'nginx',name:'nginx.error.level',type:'alias'},'nginx.error.pid':{category:'nginx',name:'nginx.error.pid',type:'alias'},'nginx.error.tid':{category:'nginx',name:'nginx.error.tid',type:'alias'},'nginx.error.message':{category:'nginx',name:'nginx.error.message',type:'alias'},'nginx.ingress_controller.remote_ip_list':{category:'nginx',description:'An array of remote IP addresses. It is a list because it is common to include, besides the client IP address, IP addresses from headers like `X-Forwarded-For`. Real source IP is restored to `source.ip`. ',name:'nginx.ingress_controller.remote_ip_list',type:'array'},'nginx.ingress_controller.http.request.length':{category:'nginx',description:'The request length (including request line, header, and request body) ',name:'nginx.ingress_controller.http.request.length',type:'long',format:'bytes'},'nginx.ingress_controller.http.request.time':{category:'nginx',description:'Time elapsed since the first bytes were read from the client ',name:'nginx.ingress_controller.http.request.time',type:'double',format:'duration'},'nginx.ingress_controller.upstream.name':{category:'nginx',description:'The name of the upstream. ',name:'nginx.ingress_controller.upstream.name',type:'keyword'},'nginx.ingress_controller.upstream.alternative_name':{category:'nginx',description:'The name of the alternative upstream. ',name:'nginx.ingress_controller.upstream.alternative_name',type:'keyword'},'nginx.ingress_controller.upstream.response.length':{category:'nginx',description:'The length of the response obtained from the upstream server ',name:'nginx.ingress_controller.upstream.response.length',type:'long',format:'bytes'},'nginx.ingress_controller.upstream.response.time':{category:'nginx',description:'The time spent on receiving the response from the upstream server as seconds with millisecond resolution ',name:'nginx.ingress_controller.upstream.response.time',type:'double',format:'duration'},'nginx.ingress_controller.upstream.response.status_code':{category:'nginx',description:'The status code of the response obtained from the upstream server ',name:'nginx.ingress_controller.upstream.response.status_code',type:'long'},'nginx.ingress_controller.http.request.id':{category:'nginx',description:'The randomly generated ID of the request ',name:'nginx.ingress_controller.http.request.id',type:'keyword'},'nginx.ingress_controller.upstream.ip':{category:'nginx',description:'The IP address of the upstream server. If several servers were contacted during request processing, their addresses are separated by commas. ',name:'nginx.ingress_controller.upstream.ip',type:'ip'},'nginx.ingress_controller.upstream.port':{category:'nginx',description:'The port of the upstream server. ',name:'nginx.ingress_controller.upstream.port',type:'long'},'nginx.ingress_controller.body_sent.bytes':{category:'nginx',name:'nginx.ingress_controller.body_sent.bytes',type:'alias'},'nginx.ingress_controller.user_name':{category:'nginx',name:'nginx.ingress_controller.user_name',type:'alias'},'nginx.ingress_controller.method':{category:'nginx',name:'nginx.ingress_controller.method',type:'alias'},'nginx.ingress_controller.url':{category:'nginx',name:'nginx.ingress_controller.url',type:'alias'},'nginx.ingress_controller.http_version':{category:'nginx',name:'nginx.ingress_controller.http_version',type:'alias'},'nginx.ingress_controller.response_code':{category:'nginx',name:'nginx.ingress_controller.response_code',type:'alias'},'nginx.ingress_controller.referrer':{category:'nginx',name:'nginx.ingress_controller.referrer',type:'alias'},'nginx.ingress_controller.agent':{category:'nginx',name:'nginx.ingress_controller.agent',type:'alias'},'nginx.ingress_controller.user_agent.device':{category:'nginx',name:'nginx.ingress_controller.user_agent.device',type:'alias'},'nginx.ingress_controller.user_agent.name':{category:'nginx',name:'nginx.ingress_controller.user_agent.name',type:'alias'},'nginx.ingress_controller.user_agent.os':{category:'nginx',name:'nginx.ingress_controller.user_agent.os',type:'alias'},'nginx.ingress_controller.user_agent.os_name':{category:'nginx',name:'nginx.ingress_controller.user_agent.os_name',type:'alias'},'nginx.ingress_controller.user_agent.original':{category:'nginx',name:'nginx.ingress_controller.user_agent.original',type:'alias'},'nginx.ingress_controller.geoip.continent_name':{category:'nginx',name:'nginx.ingress_controller.geoip.continent_name',type:'alias'},'nginx.ingress_controller.geoip.country_iso_code':{category:'nginx',name:'nginx.ingress_controller.geoip.country_iso_code',type:'alias'},'nginx.ingress_controller.geoip.location':{category:'nginx',name:'nginx.ingress_controller.geoip.location',type:'alias'},'nginx.ingress_controller.geoip.region_name':{category:'nginx',name:'nginx.ingress_controller.geoip.region_name',type:'alias'},'nginx.ingress_controller.geoip.city_name':{category:'nginx',name:'nginx.ingress_controller.geoip.city_name',type:'alias'},'nginx.ingress_controller.geoip.region_iso_code':{category:'nginx',name:'nginx.ingress_controller.geoip.region_iso_code',type:'alias'},'osquery.result.name':{category:'osquery',description:'The name of the query that generated this event. ',name:'osquery.result.name',type:'keyword'},'osquery.result.action':{category:'osquery',description:'For incremental data, marks whether the entry was added or removed. It can be one of "added", "removed", or "snapshot". ',name:'osquery.result.action',type:'keyword'},'osquery.result.host_identifier':{category:'osquery',description:'The identifier for the host on which the osquery agent is running. Normally the hostname. ',name:'osquery.result.host_identifier',type:'keyword'},'osquery.result.unix_time':{category:'osquery',description:'Unix timestamp of the event, in seconds since the epoch. Used for computing the `@timestamp` column. ',name:'osquery.result.unix_time',type:'long'},'osquery.result.calendar_time':{category:'osquery',description:'String representation of the collection time, as formatted by osquery. ',name:'osquery.result.calendar_time',type:'keyword'},'postgresql.log.timestamp':{category:'postgresql',description:'The timestamp from the log line. ',name:'postgresql.log.timestamp'},'postgresql.log.core_id':{category:'postgresql',description:'Core id ',name:'postgresql.log.core_id',type:'long'},'postgresql.log.database':{category:'postgresql',description:'Name of database ',example:'mydb',name:'postgresql.log.database'},'postgresql.log.query':{category:'postgresql',description:'Query statement. ',example:'SELECT * FROM users;',name:'postgresql.log.query'},'postgresql.log.query_step':{category:'postgresql',description:'Statement step when using extended query protocol (one of statement, parse, bind or execute) ',example:'parse',name:'postgresql.log.query_step'},'postgresql.log.query_name':{category:'postgresql',description:'Name given to a query when using extended query protocol. If it is "<unnamed>", or not present, this field is ignored. ',example:'pdo_stmt_00000001',name:'postgresql.log.query_name'},'postgresql.log.error.code':{category:'postgresql',description:'Error code returned by Postgres (if any)',name:'postgresql.log.error.code',type:'long'},'postgresql.log.timezone':{category:'postgresql',name:'postgresql.log.timezone',type:'alias'},'postgresql.log.thread_id':{category:'postgresql',name:'postgresql.log.thread_id',type:'alias'},'postgresql.log.user':{category:'postgresql',name:'postgresql.log.user',type:'alias'},'postgresql.log.level':{category:'postgresql',name:'postgresql.log.level',type:'alias'},'postgresql.log.message':{category:'postgresql',name:'postgresql.log.message',type:'alias'},'redis.log.role':{category:'redis',description:'The role of the Redis instance. Can be one of `master`, `slave`, `child` (for RDF/AOF writing child), or `sentinel`. ',name:'redis.log.role',type:'keyword'},'redis.log.pid':{category:'redis',name:'redis.log.pid',type:'alias'},'redis.log.level':{category:'redis',name:'redis.log.level',type:'alias'},'redis.log.message':{category:'redis',name:'redis.log.message',type:'alias'},'redis.slowlog.cmd':{category:'redis',description:'The command executed. ',name:'redis.slowlog.cmd',type:'keyword'},'redis.slowlog.duration.us':{category:'redis',description:'How long it took to execute the command in microseconds. ',name:'redis.slowlog.duration.us',type:'long'},'redis.slowlog.id':{category:'redis',description:'The ID of the query. ',name:'redis.slowlog.id',type:'long'},'redis.slowlog.key':{category:'redis',description:'The key on which the command was executed. ',name:'redis.slowlog.key',type:'keyword'},'redis.slowlog.args':{category:'redis',description:'The arguments with which the command was called. ',name:'redis.slowlog.args',type:'keyword'},'santa.action':{category:'santa',description:'Action',example:'EXEC',name:'santa.action',type:'keyword'},'santa.decision':{category:'santa',description:'Decision that santad took.',example:'ALLOW',name:'santa.decision',type:'keyword'},'santa.reason':{category:'santa',description:'Reason for the decsision.',example:'CERT',name:'santa.reason',type:'keyword'},'santa.mode':{category:'santa',description:'Operating mode of Santa.',example:'M',name:'santa.mode',type:'keyword'},'santa.disk.volume':{category:'santa',description:'The volume name.',name:'santa.disk.volume'},'santa.disk.bus':{category:'santa',description:'The disk bus protocol.',name:'santa.disk.bus'},'santa.disk.serial':{category:'santa',description:'The disk serial number.',name:'santa.disk.serial'},'santa.disk.bsdname':{category:'santa',description:'The disk BSD name.',example:'disk1s3',name:'santa.disk.bsdname'},'santa.disk.model':{category:'santa',description:'The disk model.',example:'APPLE SSD SM0512L',name:'santa.disk.model'},'santa.disk.fs':{category:'santa',description:'The disk volume kind (filesystem type).',example:'apfs',name:'santa.disk.fs'},'santa.disk.mount':{category:'santa',description:'The disk volume path.',name:'santa.disk.mount'},'santa.certificate.common_name':{category:'santa',description:'Common name from code signing certificate.',name:'santa.certificate.common_name',type:'keyword'},'santa.certificate.sha256':{category:'santa',description:'SHA256 hash of code signing certificate.',name:'santa.certificate.sha256',type:'keyword'},'system.auth.timestamp':{category:'system',name:'system.auth.timestamp',type:'alias'},'system.auth.hostname':{category:'system',name:'system.auth.hostname',type:'alias'},'system.auth.program':{category:'system',name:'system.auth.program',type:'alias'},'system.auth.pid':{category:'system',name:'system.auth.pid',type:'alias'},'system.auth.message':{category:'system',name:'system.auth.message',type:'alias'},'system.auth.user':{category:'system',name:'system.auth.user',type:'alias'},'system.auth.ssh.method':{category:'system',description:'The SSH authentication method. Can be one of "password" or "publickey". ',name:'system.auth.ssh.method'},'system.auth.ssh.signature':{category:'system',description:'The signature of the client public key. ',name:'system.auth.ssh.signature'},'system.auth.ssh.dropped_ip':{category:'system',description:'The client IP from SSH connections that are open and immediately dropped. ',name:'system.auth.ssh.dropped_ip',type:'ip'},'system.auth.ssh.event':{category:'system',description:'The SSH event as found in the logs (Accepted, Invalid, Failed, etc.) ',example:'Accepted',name:'system.auth.ssh.event'},'system.auth.ssh.ip':{category:'system',name:'system.auth.ssh.ip',type:'alias'},'system.auth.ssh.port':{category:'system',name:'system.auth.ssh.port',type:'alias'},'system.auth.ssh.geoip.continent_name':{category:'system',name:'system.auth.ssh.geoip.continent_name',type:'alias'},'system.auth.ssh.geoip.country_iso_code':{category:'system',name:'system.auth.ssh.geoip.country_iso_code',type:'alias'},'system.auth.ssh.geoip.location':{category:'system',name:'system.auth.ssh.geoip.location',type:'alias'},'system.auth.ssh.geoip.region_name':{category:'system',name:'system.auth.ssh.geoip.region_name',type:'alias'},'system.auth.ssh.geoip.city_name':{category:'system',name:'system.auth.ssh.geoip.city_name',type:'alias'},'system.auth.ssh.geoip.region_iso_code':{category:'system',name:'system.auth.ssh.geoip.region_iso_code',type:'alias'},'system.auth.sudo.error':{category:'system',description:'The error message in case the sudo command failed. ',example:'user NOT in sudoers',name:'system.auth.sudo.error'},'system.auth.sudo.tty':{category:'system',description:'The TTY where the sudo command is executed. ',name:'system.auth.sudo.tty'},'system.auth.sudo.pwd':{category:'system',description:'The current directory where the sudo command is executed. ',name:'system.auth.sudo.pwd'},'system.auth.sudo.user':{category:'system',description:'The target user to which the sudo command is switching. ',example:'root',name:'system.auth.sudo.user'},'system.auth.sudo.command':{category:'system',description:'The command executed via sudo. ',name:'system.auth.sudo.command'},'system.auth.useradd.home':{category:'system',description:'The home folder for the new user.',name:'system.auth.useradd.home'},'system.auth.useradd.shell':{category:'system',description:'The default shell for the new user.',name:'system.auth.useradd.shell'},'system.auth.useradd.name':{category:'system',name:'system.auth.useradd.name',type:'alias'},'system.auth.useradd.uid':{category:'system',name:'system.auth.useradd.uid',type:'alias'},'system.auth.useradd.gid':{category:'system',name:'system.auth.useradd.gid',type:'alias'},'system.auth.groupadd.name':{category:'system',name:'system.auth.groupadd.name',type:'alias'},'system.auth.groupadd.gid':{category:'system',name:'system.auth.groupadd.gid',type:'alias'},'system.syslog.timestamp':{category:'system',name:'system.syslog.timestamp',type:'alias'},'system.syslog.hostname':{category:'system',name:'system.syslog.hostname',type:'alias'},'system.syslog.program':{category:'system',name:'system.syslog.program',type:'alias'},'system.syslog.pid':{category:'system',name:'system.syslog.pid',type:'alias'},'system.syslog.message':{category:'system',name:'system.syslog.message',type:'alias'},'traefik.access.user_identifier':{category:'traefik',description:'Is the RFC 1413 identity of the client ',name:'traefik.access.user_identifier',type:'keyword'},'traefik.access.request_count':{category:'traefik',description:'The number of requests ',name:'traefik.access.request_count',type:'long'},'traefik.access.frontend_name':{category:'traefik',description:'The name of the frontend used ',name:'traefik.access.frontend_name',type:'keyword'},'traefik.access.backend_url':{category:'traefik',description:'The url of the backend where request is forwarded',name:'traefik.access.backend_url',type:'keyword'},'traefik.access.body_sent.bytes':{category:'traefik',name:'traefik.access.body_sent.bytes',type:'alias'},'traefik.access.remote_ip':{category:'traefik',name:'traefik.access.remote_ip',type:'alias'},'traefik.access.user_name':{category:'traefik',name:'traefik.access.user_name',type:'alias'},'traefik.access.method':{category:'traefik',name:'traefik.access.method',type:'alias'},'traefik.access.url':{category:'traefik',name:'traefik.access.url',type:'alias'},'traefik.access.http_version':{category:'traefik',name:'traefik.access.http_version',type:'alias'},'traefik.access.response_code':{category:'traefik',name:'traefik.access.response_code',type:'alias'},'traefik.access.referrer':{category:'traefik',name:'traefik.access.referrer',type:'alias'},'traefik.access.agent':{category:'traefik',name:'traefik.access.agent',type:'alias'},'traefik.access.user_agent.device':{category:'traefik',name:'traefik.access.user_agent.device',type:'alias'},'traefik.access.user_agent.name':{category:'traefik',name:'traefik.access.user_agent.name',type:'alias'},'traefik.access.user_agent.os':{category:'traefik',name:'traefik.access.user_agent.os',type:'alias'},'traefik.access.user_agent.os_name':{category:'traefik',name:'traefik.access.user_agent.os_name',type:'alias'},'traefik.access.user_agent.original':{category:'traefik',name:'traefik.access.user_agent.original',type:'alias'},'traefik.access.geoip.continent_name':{category:'traefik',name:'traefik.access.geoip.continent_name',type:'alias'},'traefik.access.geoip.country_iso_code':{category:'traefik',name:'traefik.access.geoip.country_iso_code',type:'alias'},'traefik.access.geoip.location':{category:'traefik',name:'traefik.access.geoip.location',type:'alias'},'traefik.access.geoip.region_name':{category:'traefik',name:'traefik.access.geoip.region_name',type:'alias'},'traefik.access.geoip.city_name':{category:'traefik',name:'traefik.access.geoip.city_name',type:'alias'},'traefik.access.geoip.region_iso_code':{category:'traefik',name:'traefik.access.geoip.region_iso_code',type:'alias'},'activemq.caller':{category:'activemq',description:'Name of the caller issuing the logging request (class or resource). ',name:'activemq.caller',type:'keyword'},'activemq.thread':{category:'activemq',description:'Thread that generated the logging event. ',name:'activemq.thread',type:'keyword'},'activemq.user':{category:'activemq',description:'User that generated the logging event. ',name:'activemq.user',type:'keyword'},'activemq.audit':{category:'activemq',description:'Fields from ActiveMQ audit logs. ',name:'activemq.audit',type:'group'},'activemq.log.stack_trace':{category:'activemq',name:'activemq.log.stack_trace',type:'keyword'},'aws.cloudtrail.event_version':{category:'aws',description:'The CloudTrail version of the log event format. ',name:'aws.cloudtrail.event_version',type:'keyword'},'aws.cloudtrail.user_identity.type':{category:'aws',description:'The type of the identity ',name:'aws.cloudtrail.user_identity.type',type:'keyword'},'aws.cloudtrail.user_identity.arn':{category:'aws',description:'The Amazon Resource Name (ARN) of the principal that made the call.',name:'aws.cloudtrail.user_identity.arn',type:'keyword'},'aws.cloudtrail.user_identity.access_key_id':{category:'aws',description:'The access key ID that was used to sign the request.',name:'aws.cloudtrail.user_identity.access_key_id',type:'keyword'},'aws.cloudtrail.user_identity.session_context.mfa_authenticated':{category:'aws',description:'The value is true if the root user or IAM user whose credentials were used for the request also was authenticated with an MFA device; otherwise, false.',name:'aws.cloudtrail.user_identity.session_context.mfa_authenticated',type:'keyword'},'aws.cloudtrail.user_identity.session_context.creation_date':{category:'aws',description:'The date and time when the temporary security credentials were issued.',name:'aws.cloudtrail.user_identity.session_context.creation_date',type:'date'},'aws.cloudtrail.user_identity.session_context.session_issuer.type':{category:'aws',description:'The source of the temporary security credentials, such as Root, IAMUser, or Role.',name:'aws.cloudtrail.user_identity.session_context.session_issuer.type',type:'keyword'},'aws.cloudtrail.user_identity.session_context.session_issuer.principal_id':{category:'aws',description:'The internal ID of the entity that was used to get credentials.',name:'aws.cloudtrail.user_identity.session_context.session_issuer.principal_id',type:'keyword'},'aws.cloudtrail.user_identity.session_context.session_issuer.arn':{category:'aws',description:'The ARN of the source (account, IAM user, or role) that was used to get temporary security credentials.',name:'aws.cloudtrail.user_identity.session_context.session_issuer.arn',type:'keyword'},'aws.cloudtrail.user_identity.session_context.session_issuer.account_id':{category:'aws',description:'The account that owns the entity that was used to get credentials.',name:'aws.cloudtrail.user_identity.session_context.session_issuer.account_id',type:'keyword'},'aws.cloudtrail.user_identity.invoked_by':{category:'aws',description:'The name of the AWS service that made the request, such as Amazon EC2 Auto Scaling or AWS Elastic Beanstalk.',name:'aws.cloudtrail.user_identity.invoked_by',type:'keyword'},'aws.cloudtrail.error_code':{category:'aws',description:'The AWS service error if the request returns an error.',name:'aws.cloudtrail.error_code',type:'keyword'},'aws.cloudtrail.error_message':{category:'aws',description:'If the request returns an error, the description of the error.',name:'aws.cloudtrail.error_message',type:'keyword'},'aws.cloudtrail.request_parameters':{category:'aws',description:'The parameters, if any, that were sent with the request.',name:'aws.cloudtrail.request_parameters',type:'keyword'},'aws.cloudtrail.response_elements':{category:'aws',description:'The response element for actions that make changes (create, update, or delete actions).',name:'aws.cloudtrail.response_elements',type:'keyword'},'aws.cloudtrail.additional_eventdata':{category:'aws',description:'Additional data about the event that was not part of the request or response.',name:'aws.cloudtrail.additional_eventdata',type:'keyword'},'aws.cloudtrail.request_id':{category:'aws',description:'The value that identifies the request. The service being called generates this value.',name:'aws.cloudtrail.request_id',type:'keyword'},'aws.cloudtrail.event_type':{category:'aws',description:'Identifies the type of event that generated the event record.',name:'aws.cloudtrail.event_type',type:'keyword'},'aws.cloudtrail.api_version':{category:'aws',description:'Identifies the API version associated with the AwsApiCall eventType value.',name:'aws.cloudtrail.api_version',type:'keyword'},'aws.cloudtrail.management_event':{category:'aws',description:'A Boolean value that identifies whether the event is a management event.',name:'aws.cloudtrail.management_event',type:'keyword'},'aws.cloudtrail.read_only':{category:'aws',description:'Identifies whether this operation is a read-only operation.',name:'aws.cloudtrail.read_only',type:'keyword'},'aws.cloudtrail.resources.arn':{category:'aws',description:'Resource ARNs',name:'aws.cloudtrail.resources.arn',type:'keyword'},'aws.cloudtrail.resources.account_id':{category:'aws',description:'Account ID of the resource owner',name:'aws.cloudtrail.resources.account_id',type:'keyword'},'aws.cloudtrail.resources.type':{category:'aws',description:'Resource type identifier in the format: AWS::aws-service-name::data-type-name',name:'aws.cloudtrail.resources.type',type:'keyword'},'aws.cloudtrail.recipient_account_id':{category:'aws',description:'Represents the account ID that received this event.',name:'aws.cloudtrail.recipient_account_id',type:'keyword'},'aws.cloudtrail.service_event_details':{category:'aws',description:'Identifies the service event, including what triggered the event and the result.',name:'aws.cloudtrail.service_event_details',type:'keyword'},'aws.cloudtrail.shared_event_id':{category:'aws',description:'GUID generated by CloudTrail to uniquely identify CloudTrail events from the same AWS action that is sent to different AWS accounts.',name:'aws.cloudtrail.shared_event_id',type:'keyword'},'aws.cloudtrail.vpc_endpoint_id':{category:'aws',description:'Identifies the VPC endpoint in which requests were made from a VPC to another AWS service, such as Amazon S3.',name:'aws.cloudtrail.vpc_endpoint_id',type:'keyword'},'aws.cloudtrail.console_login.additional_eventdata.mobile_version':{category:'aws',description:'Identifies whether ConsoleLogin was from mobile version',name:'aws.cloudtrail.console_login.additional_eventdata.mobile_version',type:'boolean'},'aws.cloudtrail.console_login.additional_eventdata.login_to':{category:'aws',description:'URL for ConsoleLogin',name:'aws.cloudtrail.console_login.additional_eventdata.login_to',type:'keyword'},'aws.cloudtrail.console_login.additional_eventdata.mfa_used':{category:'aws',description:'Identifies whether multi factor authentication was used during ConsoleLogin',name:'aws.cloudtrail.console_login.additional_eventdata.mfa_used',type:'boolean'},'aws.cloudtrail.flattened.additional_eventdata':{category:'aws',description:'Additional data about the event that was not part of the request or response. ',name:'aws.cloudtrail.flattened.additional_eventdata',type:'flattened'},'aws.cloudtrail.flattened.request_parameters':{category:'aws',description:'The parameters, if any, that were sent with the request.',name:'aws.cloudtrail.flattened.request_parameters',type:'flattened'},'aws.cloudtrail.flattened.response_elements':{category:'aws',description:'The response element for actions that make changes (create, update, or delete actions).',name:'aws.cloudtrail.flattened.response_elements',type:'flattened'},'aws.cloudtrail.flattened.service_event_details':{category:'aws',description:'Identifies the service event, including what triggered the event and the result.',name:'aws.cloudtrail.flattened.service_event_details',type:'flattened'},'aws.cloudwatch.message':{category:'aws',description:'CloudWatch log message. ',name:'aws.cloudwatch.message',type:'text'},'aws.ec2.ip_address':{category:'aws',description:'The internet address of the requester. ',name:'aws.ec2.ip_address',type:'keyword'},'aws.elb.name':{category:'aws',description:'The name of the load balancer. ',name:'aws.elb.name',type:'keyword'},'aws.elb.type':{category:'aws',description:'The type of the load balancer for v2 Load Balancers. ',name:'aws.elb.type',type:'keyword'},'aws.elb.target_group.arn':{category:'aws',description:'The ARN of the target group handling the request. ',name:'aws.elb.target_group.arn',type:'keyword'},'aws.elb.listener':{category:'aws',description:'The ELB listener that received the connection. ',name:'aws.elb.listener',type:'keyword'},'aws.elb.protocol':{category:'aws',description:'The protocol of the load balancer (http or tcp). ',name:'aws.elb.protocol',type:'keyword'},'aws.elb.request_processing_time.sec':{category:'aws',description:'The total time in seconds since the connection or request is received until it is sent to a registered backend. ',name:'aws.elb.request_processing_time.sec',type:'float'},'aws.elb.backend_processing_time.sec':{category:'aws',description:'The total time in seconds since the connection is sent to the backend till the backend starts responding. ',name:'aws.elb.backend_processing_time.sec',type:'float'},'aws.elb.response_processing_time.sec':{category:'aws',description:'The total time in seconds since the response is received from the backend till it is sent to the client. ',name:'aws.elb.response_processing_time.sec',type:'float'},'aws.elb.connection_time.ms':{category:'aws',description:'The total time of the connection in milliseconds, since it is opened till it is closed. ',name:'aws.elb.connection_time.ms',type:'long'},'aws.elb.tls_handshake_time.ms':{category:'aws',description:'The total time for the TLS handshake to complete in milliseconds once the connection has been established. ',name:'aws.elb.tls_handshake_time.ms',type:'long'},'aws.elb.backend.ip':{category:'aws',description:'The IP address of the backend processing this connection. ',name:'aws.elb.backend.ip',type:'keyword'},'aws.elb.backend.port':{category:'aws',description:'The port in the backend processing this connection. ',name:'aws.elb.backend.port',type:'keyword'},'aws.elb.backend.http.response.status_code':{category:'aws',description:'The status code from the backend (status code sent to the client from ELB is stored in `http.response.status_code` ',name:'aws.elb.backend.http.response.status_code',type:'keyword'},'aws.elb.ssl_cipher':{category:'aws',description:'The SSL cipher used in TLS/SSL connections. ',name:'aws.elb.ssl_cipher',type:'keyword'},'aws.elb.ssl_protocol':{category:'aws',description:'The SSL protocol used in TLS/SSL connections. ',name:'aws.elb.ssl_protocol',type:'keyword'},'aws.elb.chosen_cert.arn':{category:'aws',description:'The ARN of the chosen certificate presented to the client in TLS/SSL connections. ',name:'aws.elb.chosen_cert.arn',type:'keyword'},'aws.elb.chosen_cert.serial':{category:'aws',description:'The serial number of the chosen certificate presented to the client in TLS/SSL connections. ',name:'aws.elb.chosen_cert.serial',type:'keyword'},'aws.elb.incoming_tls_alert':{category:'aws',description:'The integer value of TLS alerts received by the load balancer from the client, if present. ',name:'aws.elb.incoming_tls_alert',type:'keyword'},'aws.elb.tls_named_group':{category:'aws',description:'The TLS named group. ',name:'aws.elb.tls_named_group',type:'keyword'},'aws.elb.trace_id':{category:'aws',description:'The contents of the `X-Amzn-Trace-Id` header. ',name:'aws.elb.trace_id',type:'keyword'},'aws.elb.matched_rule_priority':{category:'aws',description:'The priority value of the rule that matched the request, if a rule matched. ',name:'aws.elb.matched_rule_priority',type:'keyword'},'aws.elb.action_executed':{category:'aws',description:'The action executed when processing the request (forward, fixed-response, authenticate...). It can contain several values. ',name:'aws.elb.action_executed',type:'keyword'},'aws.elb.redirect_url':{category:'aws',description:'The URL used if a redirection action was executed. ',name:'aws.elb.redirect_url',type:'keyword'},'aws.elb.error.reason':{category:'aws',description:'The error reason if the executed action failed. ',name:'aws.elb.error.reason',type:'keyword'},'aws.s3access.bucket_owner':{category:'aws',description:'The canonical user ID of the owner of the source bucket. ',name:'aws.s3access.bucket_owner',type:'keyword'},'aws.s3access.bucket':{category:'aws',description:'The name of the bucket that the request was processed against. ',name:'aws.s3access.bucket',type:'keyword'},'aws.s3access.remote_ip':{category:'aws',description:'The apparent internet address of the requester. ',name:'aws.s3access.remote_ip',type:'ip'},'aws.s3access.requester':{category:'aws',description:'The canonical user ID of the requester, or a - for unauthenticated requests. ',name:'aws.s3access.requester',type:'keyword'},'aws.s3access.request_id':{category:'aws',description:'A string generated by Amazon S3 to uniquely identify each request. ',name:'aws.s3access.request_id',type:'keyword'},'aws.s3access.operation':{category:'aws',description:'The operation listed here is declared as SOAP.operation, REST.HTTP_method.resource_type, WEBSITE.HTTP_method.resource_type, or BATCH.DELETE.OBJECT. ',name:'aws.s3access.operation',type:'keyword'},'aws.s3access.key':{category:'aws',description:'The "key" part of the request, URL encoded, or "-" if the operation does not take a key parameter. ',name:'aws.s3access.key',type:'keyword'},'aws.s3access.request_uri':{category:'aws',description:'The Request-URI part of the HTTP request message. ',name:'aws.s3access.request_uri',type:'keyword'},'aws.s3access.http_status':{category:'aws',description:'The numeric HTTP status code of the response. ',name:'aws.s3access.http_status',type:'long'},'aws.s3access.error_code':{category:'aws',description:'The Amazon S3 Error Code, or "-" if no error occurred. ',name:'aws.s3access.error_code',type:'keyword'},'aws.s3access.bytes_sent':{category:'aws',description:'The number of response bytes sent, excluding HTTP protocol overhead, or "-" if zero. ',name:'aws.s3access.bytes_sent',type:'long'},'aws.s3access.object_size':{category:'aws',description:'The total size of the object in question. ',name:'aws.s3access.object_size',type:'long'},'aws.s3access.total_time':{category:'aws',description:"The number of milliseconds the request was in flight from the server's perspective. ",name:'aws.s3access.total_time',type:'long'},'aws.s3access.turn_around_time':{category:'aws',description:'The number of milliseconds that Amazon S3 spent processing your request. ',name:'aws.s3access.turn_around_time',type:'long'},'aws.s3access.referrer':{category:'aws',description:'The value of the HTTP Referrer header, if present. ',name:'aws.s3access.referrer',type:'keyword'},'aws.s3access.user_agent':{category:'aws',description:'The value of the HTTP User-Agent header. ',name:'aws.s3access.user_agent',type:'keyword'},'aws.s3access.version_id':{category:'aws',description:'The version ID in the request, or "-" if the operation does not take a versionId parameter. ',name:'aws.s3access.version_id',type:'keyword'},'aws.s3access.host_id':{category:'aws',description:'The x-amz-id-2 or Amazon S3 extended request ID. ',name:'aws.s3access.host_id',type:'keyword'},'aws.s3access.signature_version':{category:'aws',description:'The signature version, SigV2 or SigV4, that was used to authenticate the request or a - for unauthenticated requests. ',name:'aws.s3access.signature_version',type:'keyword'},'aws.s3access.cipher_suite':{category:'aws',description:'The Secure Sockets Layer (SSL) cipher that was negotiated for HTTPS request or a - for HTTP. ',name:'aws.s3access.cipher_suite',type:'keyword'},'aws.s3access.authentication_type':{category:'aws',description:'The type of request authentication used, AuthHeader for authentication headers, QueryString for query string (pre-signed URL) or a - for unauthenticated requests. ',name:'aws.s3access.authentication_type',type:'keyword'},'aws.s3access.host_header':{category:'aws',description:'The endpoint used to connect to Amazon S3. ',name:'aws.s3access.host_header',type:'keyword'},'aws.s3access.tls_version':{category:'aws',description:'The Transport Layer Security (TLS) version negotiated by the client. ',name:'aws.s3access.tls_version',type:'keyword'},'aws.vpcflow.version':{category:'aws',description:'The VPC Flow Logs version. If you use the default format, the version is 2. If you specify a custom format, the version is 3. ',name:'aws.vpcflow.version',type:'keyword'},'aws.vpcflow.account_id':{category:'aws',description:'The AWS account ID for the flow log. ',name:'aws.vpcflow.account_id',type:'keyword'},'aws.vpcflow.interface_id':{category:'aws',description:'The ID of the network interface for which the traffic is recorded. ',name:'aws.vpcflow.interface_id',type:'keyword'},'aws.vpcflow.action':{category:'aws',description:'The action that is associated with the traffic, ACCEPT or REJECT. ',name:'aws.vpcflow.action',type:'keyword'},'aws.vpcflow.log_status':{category:'aws',description:'The logging status of the flow log, OK, NODATA or SKIPDATA. ',name:'aws.vpcflow.log_status',type:'keyword'},'aws.vpcflow.instance_id':{category:'aws',description:"The ID of the instance that's associated with network interface for which the traffic is recorded, if the instance is owned by you. ",name:'aws.vpcflow.instance_id',type:'keyword'},'aws.vpcflow.pkt_srcaddr':{category:'aws',description:'The packet-level (original) source IP address of the traffic. ',name:'aws.vpcflow.pkt_srcaddr',type:'ip'},'aws.vpcflow.pkt_dstaddr':{category:'aws',description:'The packet-level (original) destination IP address for the traffic. ',name:'aws.vpcflow.pkt_dstaddr',type:'ip'},'aws.vpcflow.vpc_id':{category:'aws',description:'The ID of the VPC that contains the network interface for which the traffic is recorded. ',name:'aws.vpcflow.vpc_id',type:'keyword'},'aws.vpcflow.subnet_id':{category:'aws',description:'The ID of the subnet that contains the network interface for which the traffic is recorded. ',name:'aws.vpcflow.subnet_id',type:'keyword'},'aws.vpcflow.tcp_flags':{category:'aws',description:'The bitmask value for the following TCP flags: 2=SYN,18=SYN-ACK,1=FIN,4=RST ',name:'aws.vpcflow.tcp_flags',type:'keyword'},'aws.vpcflow.type':{category:'aws',description:'The type of traffic: IPv4, IPv6, or EFA. ',name:'aws.vpcflow.type',type:'keyword'},'azure.subscription_id':{category:'azure',description:'Azure subscription ID ',name:'azure.subscription_id',type:'keyword'},'azure.correlation_id':{category:'azure',description:'Correlation ID ',name:'azure.correlation_id',type:'keyword'},'azure.tenant_id':{category:'azure',description:'tenant ID ',name:'azure.tenant_id',type:'keyword'},'azure.resource.id':{category:'azure',description:'Resource ID ',name:'azure.resource.id',type:'keyword'},'azure.resource.group':{category:'azure',description:'Resource group ',name:'azure.resource.group',type:'keyword'},'azure.resource.provider':{category:'azure',description:'Resource type/namespace ',name:'azure.resource.provider',type:'keyword'},'azure.resource.namespace':{category:'azure',description:'Resource type/namespace ',name:'azure.resource.namespace',type:'keyword'},'azure.resource.name':{category:'azure',description:'Name ',name:'azure.resource.name',type:'keyword'},'azure.resource.authorization_rule':{category:'azure',description:'Authorization rule ',name:'azure.resource.authorization_rule',type:'keyword'},'azure.activitylogs.identity.claims_initiated_by_user.name':{category:'azure',description:'Name ',name:'azure.activitylogs.identity.claims_initiated_by_user.name',type:'keyword'},'azure.activitylogs.identity.claims_initiated_by_user.givenname':{category:'azure',description:'Givenname ',name:'azure.activitylogs.identity.claims_initiated_by_user.givenname',type:'keyword'},'azure.activitylogs.identity.claims_initiated_by_user.surname':{category:'azure',description:'Surname ',name:'azure.activitylogs.identity.claims_initiated_by_user.surname',type:'keyword'},'azure.activitylogs.identity.claims_initiated_by_user.fullname':{category:'azure',description:'Fullname ',name:'azure.activitylogs.identity.claims_initiated_by_user.fullname',type:'keyword'},'azure.activitylogs.identity.claims_initiated_by_user.schema':{category:'azure',description:'Schema ',name:'azure.activitylogs.identity.claims_initiated_by_user.schema',type:'keyword'},'azure.activitylogs.identity.claims.*':{category:'azure',description:'Claims ',name:'azure.activitylogs.identity.claims.*',type:'object'},'azure.activitylogs.identity.authorization.scope':{category:'azure',description:'Scope ',name:'azure.activitylogs.identity.authorization.scope',type:'keyword'},'azure.activitylogs.identity.authorization.action':{category:'azure',description:'Action ',name:'azure.activitylogs.identity.authorization.action',type:'keyword'},'azure.activitylogs.identity.authorization.evidence.role_assignment_scope':{category:'azure',description:'Role assignment scope ',name:'azure.activitylogs.identity.authorization.evidence.role_assignment_scope',type:'keyword'},'azure.activitylogs.identity.authorization.evidence.role_definition_id':{category:'azure',description:'Role definition ID ',name:'azure.activitylogs.identity.authorization.evidence.role_definition_id',type:'keyword'},'azure.activitylogs.identity.authorization.evidence.role':{category:'azure',description:'Role ',name:'azure.activitylogs.identity.authorization.evidence.role',type:'keyword'},'azure.activitylogs.identity.authorization.evidence.role_assignment_id':{category:'azure',description:'Role assignment ID ',name:'azure.activitylogs.identity.authorization.evidence.role_assignment_id',type:'keyword'},'azure.activitylogs.identity.authorization.evidence.principal_id':{category:'azure',description:'Principal ID ',name:'azure.activitylogs.identity.authorization.evidence.principal_id',type:'keyword'},'azure.activitylogs.identity.authorization.evidence.principal_type':{category:'azure',description:'Principal type ',name:'azure.activitylogs.identity.authorization.evidence.principal_type',type:'keyword'},'azure.activitylogs.operation_name':{category:'azure',description:'Operation name ',name:'azure.activitylogs.operation_name',type:'keyword'},'azure.activitylogs.result_type':{category:'azure',description:'Result type ',name:'azure.activitylogs.result_type',type:'keyword'},'azure.activitylogs.result_signature':{category:'azure',description:'Result signature ',name:'azure.activitylogs.result_signature',type:'keyword'},'azure.activitylogs.category':{category:'azure',description:'Category ',name:'azure.activitylogs.category',type:'keyword'},'azure.activitylogs.event_category':{category:'azure',description:'Event Category ',name:'azure.activitylogs.event_category',type:'keyword'},'azure.activitylogs.properties.service_request_id':{category:'azure',description:'Service Request Id ',name:'azure.activitylogs.properties.service_request_id',type:'keyword'},'azure.activitylogs.properties.status_code':{category:'azure',description:'Status code ',name:'azure.activitylogs.properties.status_code',type:'keyword'},'azure.auditlogs.category':{category:'azure',description:'The category of the operation.  Currently, Audit is the only supported value. ',name:'azure.auditlogs.category',type:'keyword'},'azure.auditlogs.operation_name':{category:'azure',description:'The operation name ',name:'azure.auditlogs.operation_name',type:'keyword'},'azure.auditlogs.operation_version':{category:'azure',description:'The operation version ',name:'azure.auditlogs.operation_version',type:'keyword'},'azure.auditlogs.identity':{category:'azure',description:'Identity ',name:'azure.auditlogs.identity',type:'keyword'},'azure.auditlogs.tenant_id':{category:'azure',description:'Tenant ID ',name:'azure.auditlogs.tenant_id',type:'keyword'},'azure.auditlogs.result_signature':{category:'azure',description:'Result signature ',name:'azure.auditlogs.result_signature',type:'keyword'},'azure.auditlogs.properties.result':{category:'azure',description:'Log result ',name:'azure.auditlogs.properties.result',type:'keyword'},'azure.auditlogs.properties.activity_display_name':{category:'azure',description:'Activity display name ',name:'azure.auditlogs.properties.activity_display_name',type:'keyword'},'azure.auditlogs.properties.result_reason':{category:'azure',description:'Reason for the log result ',name:'azure.auditlogs.properties.result_reason',type:'keyword'},'azure.auditlogs.properties.correlation_id':{category:'azure',description:'Correlation ID ',name:'azure.auditlogs.properties.correlation_id',type:'keyword'},'azure.auditlogs.properties.logged_by_service':{category:'azure',description:'Logged by service ',name:'azure.auditlogs.properties.logged_by_service',type:'keyword'},'azure.auditlogs.properties.operation_type':{category:'azure',description:'Operation type ',name:'azure.auditlogs.properties.operation_type',type:'keyword'},'azure.auditlogs.properties.id':{category:'azure',description:'ID ',name:'azure.auditlogs.properties.id',type:'keyword'},'azure.auditlogs.properties.activity_datetime':{category:'azure',description:'Activity timestamp ',name:'azure.auditlogs.properties.activity_datetime',type:'date'},'azure.auditlogs.properties.category':{category:'azure',description:'category ',name:'azure.auditlogs.properties.category',type:'keyword'},'azure.auditlogs.properties.target_resources.*.display_name':{category:'azure',description:'Display name ',name:'azure.auditlogs.properties.target_resources.*.display_name',type:'keyword'},'azure.auditlogs.properties.target_resources.*.id':{category:'azure',description:'ID ',name:'azure.auditlogs.properties.target_resources.*.id',type:'keyword'},'azure.auditlogs.properties.target_resources.*.type':{category:'azure',description:'Type ',name:'azure.auditlogs.properties.target_resources.*.type',type:'keyword'},'azure.auditlogs.properties.target_resources.*.ip_address':{category:'azure',description:'ip Address ',name:'azure.auditlogs.properties.target_resources.*.ip_address',type:'keyword'},'azure.auditlogs.properties.target_resources.*.user_principal_name':{category:'azure',description:'User principal name ',name:'azure.auditlogs.properties.target_resources.*.user_principal_name',type:'keyword'},'azure.auditlogs.properties.target_resources.*.modified_properties.*.new_value':{category:'azure',description:'New value ',name:'azure.auditlogs.properties.target_resources.*.modified_properties.*.new_value',type:'keyword'},'azure.auditlogs.properties.target_resources.*.modified_properties.*.display_name':{category:'azure',description:'Display value ',name:'azure.auditlogs.properties.target_resources.*.modified_properties.*.display_name',type:'keyword'},'azure.auditlogs.properties.target_resources.*.modified_properties.*.old_value':{category:'azure',description:'Old value ',name:'azure.auditlogs.properties.target_resources.*.modified_properties.*.old_value',type:'keyword'},'azure.auditlogs.properties.initiated_by.app.servicePrincipalName':{category:'azure',description:'Service principal name ',name:'azure.auditlogs.properties.initiated_by.app.servicePrincipalName',type:'keyword'},'azure.auditlogs.properties.initiated_by.app.displayName':{category:'azure',description:'Display name ',name:'azure.auditlogs.properties.initiated_by.app.displayName',type:'keyword'},'azure.auditlogs.properties.initiated_by.app.appId':{category:'azure',description:'App ID ',name:'azure.auditlogs.properties.initiated_by.app.appId',type:'keyword'},'azure.auditlogs.properties.initiated_by.app.servicePrincipalId':{category:'azure',description:'Service principal ID ',name:'azure.auditlogs.properties.initiated_by.app.servicePrincipalId',type:'keyword'},'azure.auditlogs.properties.initiated_by.user.userPrincipalName':{category:'azure',description:'User principal name ',name:'azure.auditlogs.properties.initiated_by.user.userPrincipalName',type:'keyword'},'azure.auditlogs.properties.initiated_by.user.displayName':{category:'azure',description:'Display name ',name:'azure.auditlogs.properties.initiated_by.user.displayName',type:'keyword'},'azure.auditlogs.properties.initiated_by.user.id':{category:'azure',description:'ID ',name:'azure.auditlogs.properties.initiated_by.user.id',type:'keyword'},'azure.auditlogs.properties.initiated_by.user.ipAddress':{category:'azure',description:'ip Address ',name:'azure.auditlogs.properties.initiated_by.user.ipAddress',type:'keyword'},'azure.signinlogs.operation_name':{category:'azure',description:'The operation name ',name:'azure.signinlogs.operation_name',type:'keyword'},'azure.signinlogs.operation_version':{category:'azure',description:'The operation version ',name:'azure.signinlogs.operation_version',type:'keyword'},'azure.signinlogs.tenant_id':{category:'azure',description:'Tenant ID ',name:'azure.signinlogs.tenant_id',type:'keyword'},'azure.signinlogs.result_signature':{category:'azure',description:'Result signature ',name:'azure.signinlogs.result_signature',type:'keyword'},'azure.signinlogs.result_description':{category:'azure',description:'Result description ',name:'azure.signinlogs.result_description',type:'keyword'},'azure.signinlogs.result_type':{category:'azure',description:'Result type ',name:'azure.signinlogs.result_type',type:'keyword'},'azure.signinlogs.identity':{category:'azure',description:'Identity ',name:'azure.signinlogs.identity',type:'keyword'},'azure.signinlogs.category':{category:'azure',description:'Category ',name:'azure.signinlogs.category',type:'keyword'},'azure.signinlogs.properties.id':{category:'azure',description:'ID ',name:'azure.signinlogs.properties.id',type:'keyword'},'azure.signinlogs.properties.created_at':{category:'azure',description:'Created date time ',name:'azure.signinlogs.properties.created_at',type:'date'},'azure.signinlogs.properties.user_display_name':{category:'azure',description:'User display name ',name:'azure.signinlogs.properties.user_display_name',type:'keyword'},'azure.signinlogs.properties.correlation_id':{category:'azure',description:'Correlation ID ',name:'azure.signinlogs.properties.correlation_id',type:'keyword'},'azure.signinlogs.properties.user_principal_name':{category:'azure',description:'User principal name ',name:'azure.signinlogs.properties.user_principal_name',type:'keyword'},'azure.signinlogs.properties.user_id':{category:'azure',description:'User ID ',name:'azure.signinlogs.properties.user_id',type:'keyword'},'azure.signinlogs.properties.app_id':{category:'azure',description:'App ID ',name:'azure.signinlogs.properties.app_id',type:'keyword'},'azure.signinlogs.properties.app_display_name':{category:'azure',description:'App display name ',name:'azure.signinlogs.properties.app_display_name',type:'keyword'},'azure.signinlogs.properties.ip_address':{category:'azure',description:'Ip address ',name:'azure.signinlogs.properties.ip_address',type:'keyword'},'azure.signinlogs.properties.client_app_used':{category:'azure',description:'Client app used ',name:'azure.signinlogs.properties.client_app_used',type:'keyword'},'azure.signinlogs.properties.conditional_access_status':{category:'azure',description:'Conditional access status ',name:'azure.signinlogs.properties.conditional_access_status',type:'keyword'},'azure.signinlogs.properties.original_request_id':{category:'azure',description:'Original request ID ',name:'azure.signinlogs.properties.original_request_id',type:'keyword'},'azure.signinlogs.properties.is_interactive':{category:'azure',description:'Is interactive ',name:'azure.signinlogs.properties.is_interactive',type:'keyword'},'azure.signinlogs.properties.token_issuer_name':{category:'azure',description:'Token issuer name ',name:'azure.signinlogs.properties.token_issuer_name',type:'keyword'},'azure.signinlogs.properties.token_issuer_type':{category:'azure',description:'Token issuer type ',name:'azure.signinlogs.properties.token_issuer_type',type:'keyword'},'azure.signinlogs.properties.processing_time_ms':{category:'azure',description:'Processing time in milliseconds ',name:'azure.signinlogs.properties.processing_time_ms',type:'float'},'azure.signinlogs.properties.risk_detail':{category:'azure',description:'Risk detail ',name:'azure.signinlogs.properties.risk_detail',type:'keyword'},'azure.signinlogs.properties.risk_level_aggregated':{category:'azure',description:'Risk level aggregated ',name:'azure.signinlogs.properties.risk_level_aggregated',type:'keyword'},'azure.signinlogs.properties.risk_level_during_signin':{category:'azure',description:'Risk level during signIn ',name:'azure.signinlogs.properties.risk_level_during_signin',type:'keyword'},'azure.signinlogs.properties.risk_state':{category:'azure',description:'Risk state ',name:'azure.signinlogs.properties.risk_state',type:'keyword'},'azure.signinlogs.properties.resource_display_name':{category:'azure',description:'Resource display name ',name:'azure.signinlogs.properties.resource_display_name',type:'keyword'},'azure.signinlogs.properties.status.error_code':{category:'azure',description:'Error code ',name:'azure.signinlogs.properties.status.error_code',type:'keyword'},'azure.signinlogs.properties.device_detail.device_id':{category:'azure',description:'Device ID ',name:'azure.signinlogs.properties.device_detail.device_id',type:'keyword'},'azure.signinlogs.properties.device_detail.operating_system':{category:'azure',description:'Operating system ',name:'azure.signinlogs.properties.device_detail.operating_system',type:'keyword'},'azure.signinlogs.properties.device_detail.browser':{category:'azure',description:'Browser ',name:'azure.signinlogs.properties.device_detail.browser',type:'keyword'},'azure.signinlogs.properties.device_detail.display_name':{category:'azure',description:'Display name ',name:'azure.signinlogs.properties.device_detail.display_name',type:'keyword'},'azure.signinlogs.properties.device_detail.trust_type':{category:'azure',description:'Trust type ',name:'azure.signinlogs.properties.device_detail.trust_type',type:'keyword'},'azure.signinlogs.properties.service_principal_id':{category:'azure',description:'Status ',name:'azure.signinlogs.properties.service_principal_id',type:'keyword'},'network.interface.name':{category:'network',description:'Name of the network interface where the traffic has been observed. ',name:'network.interface.name',type:'keyword'},'rsa.internal.msg':{category:'rsa',description:'This key is used to capture the raw message that comes into the Log Decoder',name:'rsa.internal.msg',type:'keyword'},'rsa.internal.messageid':{category:'rsa',name:'rsa.internal.messageid',type:'keyword'},'rsa.internal.event_desc':{category:'rsa',name:'rsa.internal.event_desc',type:'keyword'},'rsa.internal.message':{category:'rsa',description:'This key captures the contents of instant messages',name:'rsa.internal.message',type:'keyword'},'rsa.internal.time':{category:'rsa',description:'This is the time at which a session hits a NetWitness Decoder. This key should never be used to parse Meta data from a session (Logs/Packets) Directly, this is a Reserved key in NetWitness.',name:'rsa.internal.time',type:'date'},'rsa.internal.level':{category:'rsa',description:'Deprecated key defined only in table map.',name:'rsa.internal.level',type:'long'},'rsa.internal.msg_id':{category:'rsa',description:'This is the Message ID1 value that identifies the exact log parser definition which parses a particular log session. This key should never be used to parse Meta data from a session (Logs/Packets) Directly, this is a Reserved key in NetWitness',name:'rsa.internal.msg_id',type:'keyword'},'rsa.internal.msg_vid':{category:'rsa',description:'This is the Message ID2 value that identifies the exact log parser definition which parses a particular log session. This key should never be used to parse Meta data from a session (Logs/Packets) Directly, this is a Reserved key in NetWitness',name:'rsa.internal.msg_vid',type:'keyword'},'rsa.internal.data':{category:'rsa',description:'Deprecated key defined only in table map.',name:'rsa.internal.data',type:'keyword'},'rsa.internal.obj_server':{category:'rsa',description:'Deprecated key defined only in table map.',name:'rsa.internal.obj_server',type:'keyword'},'rsa.internal.obj_val':{category:'rsa',description:'Deprecated key defined only in table map.',name:'rsa.internal.obj_val',type:'keyword'},'rsa.internal.resource':{category:'rsa',description:'Deprecated key defined only in table map.',name:'rsa.internal.resource',type:'keyword'},'rsa.internal.obj_id':{category:'rsa',description:'Deprecated key defined only in table map.',name:'rsa.internal.obj_id',type:'keyword'},'rsa.internal.statement':{category:'rsa',description:'Deprecated key defined only in table map.',name:'rsa.internal.statement',type:'keyword'},'rsa.internal.audit_class':{category:'rsa',description:'Deprecated key defined only in table map.',name:'rsa.internal.audit_class',type:'keyword'},'rsa.internal.entry':{category:'rsa',description:'Deprecated key defined only in table map.',name:'rsa.internal.entry',type:'keyword'},'rsa.internal.hcode':{category:'rsa',description:'Deprecated key defined only in table map.',name:'rsa.internal.hcode',type:'keyword'},'rsa.internal.inode':{category:'rsa',description:'Deprecated key defined only in table map.',name:'rsa.internal.inode',type:'long'},'rsa.internal.resource_class':{category:'rsa',description:'Deprecated key defined only in table map.',name:'rsa.internal.resource_class',type:'keyword'},'rsa.internal.dead':{category:'rsa',description:'Deprecated key defined only in table map.',name:'rsa.internal.dead',type:'long'},'rsa.internal.feed_desc':{category:'rsa',description:'This is used to capture the description of the feed. This key should never be used to parse Meta data from a session (Logs/Packets) Directly, this is a Reserved key in NetWitness',name:'rsa.internal.feed_desc',type:'keyword'},'rsa.internal.feed_name':{category:'rsa',description:'This is used to capture the name of the feed. This key should never be used to parse Meta data from a session (Logs/Packets) Directly, this is a Reserved key in NetWitness',name:'rsa.internal.feed_name',type:'keyword'},'rsa.internal.cid':{category:'rsa',description:'This is the unique identifier used to identify a NetWitness Concentrator. This key should never be used to parse Meta data from a session (Logs/Packets) Directly, this is a Reserved key in NetWitness',name:'rsa.internal.cid',type:'keyword'},'rsa.internal.device_class':{category:'rsa',description:'This is the Classification of the Log Event Source under a predefined fixed set of Event Source Classifications. This key should never be used to parse Meta data from a session (Logs/Packets) Directly, this is a Reserved key in NetWitness',name:'rsa.internal.device_class',type:'keyword'},'rsa.internal.device_group':{category:'rsa',description:'This key should never be used to parse Meta data from a session (Logs/Packets) Directly, this is a Reserved key in NetWitness',name:'rsa.internal.device_group',type:'keyword'},'rsa.internal.device_host':{category:'rsa',description:'This is the Hostname of the log Event Source sending the logs to NetWitness. This key should never be used to parse Meta data from a session (Logs/Packets) Directly, this is a Reserved key in NetWitness',name:'rsa.internal.device_host',type:'keyword'},'rsa.internal.device_ip':{category:'rsa',description:'This is the IPv4 address of the Log Event Source sending the logs to NetWitness. This key should never be used to parse Meta data from a session (Logs/Packets) Directly, this is a Reserved key in NetWitness',name:'rsa.internal.device_ip',type:'ip'},'rsa.internal.device_ipv6':{category:'rsa',description:'This is the IPv6 address of the Log Event Source sending the logs to NetWitness. This key should never be used to parse Meta data from a session (Logs/Packets) Directly, this is a Reserved key in NetWitness',name:'rsa.internal.device_ipv6',type:'ip'},'rsa.internal.device_type':{category:'rsa',description:'This is the name of the log parser which parsed a given session. This key should never be used to parse Meta data from a session (Logs/Packets) Directly, this is a Reserved key in NetWitness',name:'rsa.internal.device_type',type:'keyword'},'rsa.internal.device_type_id':{category:'rsa',description:'Deprecated key defined only in table map.',name:'rsa.internal.device_type_id',type:'long'},'rsa.internal.did':{category:'rsa',description:'This is the unique identifier used to identify a NetWitness Decoder. This key should never be used to parse Meta data from a session (Logs/Packets) Directly, this is a Reserved key in NetWitness',name:'rsa.internal.did',type:'keyword'},'rsa.internal.entropy_req':{category:'rsa',description:'This key is only used by the Entropy Parser, the Meta Type can be either UInt16 or Float32 based on the configuration',name:'rsa.internal.entropy_req',type:'long'},'rsa.internal.entropy_res':{category:'rsa',description:'This key is only used by the Entropy Parser, the Meta Type can be either UInt16 or Float32 based on the configuration',name:'rsa.internal.entropy_res',type:'long'},'rsa.internal.event_name':{category:'rsa',description:'Deprecated key defined only in table map.',name:'rsa.internal.event_name',type:'keyword'},'rsa.internal.feed_category':{category:'rsa',description:'This is used to capture the category of the feed. This key should never be used to parse Meta data from a session (Logs/Packets) Directly, this is a Reserved key in NetWitness',name:'rsa.internal.feed_category',type:'keyword'},'rsa.internal.forward_ip':{category:'rsa',description:'This key should be used to capture the IPV4 address of a relay system which forwarded the events from the original system to NetWitness.',name:'rsa.internal.forward_ip',type:'ip'},'rsa.internal.forward_ipv6':{category:'rsa',description:'This key is used to capture the IPV6 address of a relay system which forwarded the events from the original system to NetWitness. This key should never be used to parse Meta data from a session (Logs/Packets) Directly, this is a Reserved key in NetWitness',name:'rsa.internal.forward_ipv6',type:'ip'},'rsa.internal.header_id':{category:'rsa',description:'This is the Header ID value that identifies the exact log parser header definition that parses a particular log session. This key should never be used to parse Meta data from a session (Logs/Packets) Directly, this is a Reserved key in NetWitness',name:'rsa.internal.header_id',type:'keyword'},'rsa.internal.lc_cid':{category:'rsa',description:'This is a unique Identifier of a Log Collector. This key should never be used to parse Meta data from a session (Logs/Packets) Directly, this is a Reserved key in NetWitness',name:'rsa.internal.lc_cid',type:'keyword'},'rsa.internal.lc_ctime':{category:'rsa',description:'This is the time at which a log is collected in a NetWitness Log Collector. This key should never be used to parse Meta data from a session (Logs/Packets) Directly, this is a Reserved key in NetWitness',name:'rsa.internal.lc_ctime',type:'date'},'rsa.internal.mcb_req':{category:'rsa',description:'This key is only used by the Entropy Parser, the most common byte request is simply which byte for each side (0 thru 255) was seen the most',name:'rsa.internal.mcb_req',type:'long'},'rsa.internal.mcb_res':{category:'rsa',description:'This key is only used by the Entropy Parser, the most common byte response is simply which byte for each side (0 thru 255) was seen the most',name:'rsa.internal.mcb_res',type:'long'},'rsa.internal.mcbc_req':{category:'rsa',description:'This key is only used by the Entropy Parser, the most common byte count is the number of times the most common byte (above) was seen in the session streams',name:'rsa.internal.mcbc_req',type:'long'},'rsa.internal.mcbc_res':{category:'rsa',description:'This key is only used by the Entropy Parser, the most common byte count is the number of times the most common byte (above) was seen in the session streams',name:'rsa.internal.mcbc_res',type:'long'},'rsa.internal.medium':{category:'rsa',description:'This key is used to identify if it’s a log/packet session or Layer 2 Encapsulation Type. This key should never be used to parse Meta data from a session (Logs/Packets) Directly, this is a Reserved key in NetWitness. 32 = log, 33 = correlation session, &lt; 32 is packet session',name:'rsa.internal.medium',type:'long'},'rsa.internal.node_name':{category:'rsa',description:'Deprecated key defined only in table map.',name:'rsa.internal.node_name',type:'keyword'},'rsa.internal.nwe_callback_id':{category:'rsa',description:'This key denotes that event is endpoint related',name:'rsa.internal.nwe_callback_id',type:'keyword'},'rsa.internal.parse_error':{category:'rsa',description:'This is a special key that stores any Meta key validation error found while parsing a log session. This key should never be used to parse Meta data from a session (Logs/Packets) Directly, this is a Reserved key in NetWitness',name:'rsa.internal.parse_error',type:'keyword'},'rsa.internal.payload_req':{category:'rsa',description:'This key is only used by the Entropy Parser, the payload size metrics are the payload sizes of each session side at the time of parsing. However, in order to keep',name:'rsa.internal.payload_req',type:'long'},'rsa.internal.payload_res':{category:'rsa',description:'This key is only used by the Entropy Parser, the payload size metrics are the payload sizes of each session side at the time of parsing. However, in order to keep',name:'rsa.internal.payload_res',type:'long'},'rsa.internal.process_vid_dst':{category:'rsa',description:'Endpoint generates and uses a unique virtual ID to identify any similar group of process. This ID represents the target process.',name:'rsa.internal.process_vid_dst',type:'keyword'},'rsa.internal.process_vid_src':{category:'rsa',description:'Endpoint generates and uses a unique virtual ID to identify any similar group of process. This ID represents the source process.',name:'rsa.internal.process_vid_src',type:'keyword'},'rsa.internal.rid':{category:'rsa',description:'This is a special ID of the Remote Session created by NetWitness Decoder. This key should never be used to parse Meta data from a session (Logs/Packets) Directly, this is a Reserved key in NetWitness',name:'rsa.internal.rid',type:'long'},'rsa.internal.session_split':{category:'rsa',description:'This key should never be used to parse Meta data from a session (Logs/Packets) Directly, this is a Reserved key in NetWitness',name:'rsa.internal.session_split',type:'keyword'},'rsa.internal.site':{category:'rsa',description:'Deprecated key defined only in table map.',name:'rsa.internal.site',type:'keyword'},'rsa.internal.size':{category:'rsa',description:'This is the size of the session as seen by the NetWitness Decoder. This key should never be used to parse Meta data from a session (Logs/Packets) Directly, this is a Reserved key in NetWitness',name:'rsa.internal.size',type:'long'},'rsa.internal.sourcefile':{category:'rsa',description:'This is the name of the log file or PCAPs that can be imported into NetWitness. This key should never be used to parse Meta data from a session (Logs/Packets) Directly, this is a Reserved key in NetWitness',name:'rsa.internal.sourcefile',type:'keyword'},'rsa.internal.ubc_req':{category:'rsa',description:'This key is only used by the Entropy Parser, Unique byte count is the number of unique bytes seen in each stream. 256 would mean all byte values of 0 thru 255 were seen at least once',name:'rsa.internal.ubc_req',type:'long'},'rsa.internal.ubc_res':{category:'rsa',description:'This key is only used by the Entropy Parser, Unique byte count is the number of unique bytes seen in each stream. 256 would mean all byte values of 0 thru 255 were seen at least once',name:'rsa.internal.ubc_res',type:'long'},'rsa.internal.word':{category:'rsa',description:'This is used by the Word Parsing technology to capture the first 5 character of every word in an unparsed log',name:'rsa.internal.word',type:'keyword'},'rsa.time.event_time':{category:'rsa',description:'This key is used to capture the time mentioned in a raw session that represents the actual time an event occured in a standard normalized form',name:'rsa.time.event_time',type:'date'},'rsa.time.duration_time':{category:'rsa',description:'This key is used to capture the normalized duration/lifetime in seconds.',name:'rsa.time.duration_time',type:'double'},'rsa.time.event_time_str':{category:'rsa',description:'This key is used to capture the incomplete time mentioned in a session as a string',name:'rsa.time.event_time_str',type:'keyword'},'rsa.time.starttime':{category:'rsa',description:'This key is used to capture the Start time mentioned in a session in a standard form',name:'rsa.time.starttime',type:'date'},'rsa.time.month':{category:'rsa',name:'rsa.time.month',type:'keyword'},'rsa.time.day':{category:'rsa',name:'rsa.time.day',type:'keyword'},'rsa.time.endtime':{category:'rsa',description:'This key is used to capture the End time mentioned in a session in a standard form',name:'rsa.time.endtime',type:'date'},'rsa.time.timezone':{category:'rsa',description:'This key is used to capture the timezone of the Event Time',name:'rsa.time.timezone',type:'keyword'},'rsa.time.duration_str':{category:'rsa',description:'A text string version of the duration',name:'rsa.time.duration_str',type:'keyword'},'rsa.time.date':{category:'rsa',name:'rsa.time.date',type:'keyword'},'rsa.time.year':{category:'rsa',name:'rsa.time.year',type:'keyword'},'rsa.time.recorded_time':{category:'rsa',description:"The event time as recorded by the system the event is collected from. The usage scenario is a multi-tier application where the management layer of the system records it's own timestamp at the time of collection from its child nodes. Must be in timestamp format.",name:'rsa.time.recorded_time',type:'date'},'rsa.time.datetime':{category:'rsa',name:'rsa.time.datetime',type:'keyword'},'rsa.time.effective_time':{category:'rsa',description:'This key is the effective time referenced by an individual event in a Standard Timestamp format',name:'rsa.time.effective_time',type:'date'},'rsa.time.expire_time':{category:'rsa',description:'This key is the timestamp that explicitly refers to an expiration.',name:'rsa.time.expire_time',type:'date'},'rsa.time.process_time':{category:'rsa',description:'Deprecated, use duration.time',name:'rsa.time.process_time',type:'keyword'},'rsa.time.hour':{category:'rsa',name:'rsa.time.hour',type:'keyword'},'rsa.time.min':{category:'rsa',name:'rsa.time.min',type:'keyword'},'rsa.time.timestamp':{category:'rsa',name:'rsa.time.timestamp',type:'keyword'},'rsa.time.event_queue_time':{category:'rsa',description:'This key is the Time that the event was queued.',name:'rsa.time.event_queue_time',type:'date'},'rsa.time.p_time1':{category:'rsa',name:'rsa.time.p_time1',type:'keyword'},'rsa.time.tzone':{category:'rsa',name:'rsa.time.tzone',type:'keyword'},'rsa.time.eventtime':{category:'rsa',name:'rsa.time.eventtime',type:'keyword'},'rsa.time.gmtdate':{category:'rsa',name:'rsa.time.gmtdate',type:'keyword'},'rsa.time.gmttime':{category:'rsa',name:'rsa.time.gmttime',type:'keyword'},'rsa.time.p_date':{category:'rsa',name:'rsa.time.p_date',type:'keyword'},'rsa.time.p_month':{category:'rsa',name:'rsa.time.p_month',type:'keyword'},'rsa.time.p_time':{category:'rsa',name:'rsa.time.p_time',type:'keyword'},'rsa.time.p_time2':{category:'rsa',name:'rsa.time.p_time2',type:'keyword'},'rsa.time.p_year':{category:'rsa',name:'rsa.time.p_year',type:'keyword'},'rsa.time.expire_time_str':{category:'rsa',description:'This key is used to capture incomplete timestamp that explicitly refers to an expiration.',name:'rsa.time.expire_time_str',type:'keyword'},'rsa.time.stamp':{category:'rsa',description:'Deprecated key defined only in table map.',name:'rsa.time.stamp',type:'date'},'rsa.misc.action':{category:'rsa',name:'rsa.misc.action',type:'keyword'},'rsa.misc.result':{category:'rsa',description:'This key is used to capture the outcome/result string value of an action in a session.',name:'rsa.misc.result',type:'keyword'},'rsa.misc.severity':{category:'rsa',description:'This key is used to capture the severity given the session',name:'rsa.misc.severity',type:'keyword'},'rsa.misc.event_type':{category:'rsa',description:'This key captures the event category type as specified by the event source.',name:'rsa.misc.event_type',type:'keyword'},'rsa.misc.reference_id':{category:'rsa',description:'This key is used to capture an event id from the session directly',name:'rsa.misc.reference_id',type:'keyword'},'rsa.misc.version':{category:'rsa',description:'This key captures Version of the application or OS which is generating the event.',name:'rsa.misc.version',type:'keyword'},'rsa.misc.disposition':{category:'rsa',description:'This key captures the The end state of an action.',name:'rsa.misc.disposition',type:'keyword'},'rsa.misc.result_code':{category:'rsa',description:'This key is used to capture the outcome/result numeric value of an action in a session',name:'rsa.misc.result_code',type:'keyword'},'rsa.misc.category':{category:'rsa',description:'This key is used to capture the category of an event given by the vendor in the session',name:'rsa.misc.category',type:'keyword'},'rsa.misc.obj_name':{category:'rsa',description:'This is used to capture name of object',name:'rsa.misc.obj_name',type:'keyword'},'rsa.misc.obj_type':{category:'rsa',description:'This is used to capture type of object',name:'rsa.misc.obj_type',type:'keyword'},'rsa.misc.event_source':{category:'rsa',description:'This key captures Source of the event that’s not a hostname',name:'rsa.misc.event_source',type:'keyword'},'rsa.misc.log_session_id':{category:'rsa',description:'This key is used to capture a sessionid from the session directly',name:'rsa.misc.log_session_id',type:'keyword'},'rsa.misc.group':{category:'rsa',description:'This key captures the Group Name value',name:'rsa.misc.group',type:'keyword'},'rsa.misc.policy_name':{category:'rsa',description:'This key is used to capture the Policy Name only.',name:'rsa.misc.policy_name',type:'keyword'},'rsa.misc.rule_name':{category:'rsa',description:'This key captures the Rule Name',name:'rsa.misc.rule_name',type:'keyword'},'rsa.misc.context':{category:'rsa',description:'This key captures Information which adds additional context to the event.',name:'rsa.misc.context',type:'keyword'},'rsa.misc.change_new':{category:'rsa',description:'This key is used to capture the new values of the attribute that’s changing in a session',name:'rsa.misc.change_new',type:'keyword'},'rsa.misc.space':{category:'rsa',name:'rsa.misc.space',type:'keyword'},'rsa.misc.client':{category:'rsa',description:'This key is used to capture only the name of the client application requesting resources of the server. See the user.agent meta key for capture of the specific user agent identifier or browser identification string.',name:'rsa.misc.client',type:'keyword'},'rsa.misc.msgIdPart1':{category:'rsa',name:'rsa.misc.msgIdPart1',type:'keyword'},'rsa.misc.msgIdPart2':{category:'rsa',name:'rsa.misc.msgIdPart2',type:'keyword'},'rsa.misc.change_old':{category:'rsa',description:'This key is used to capture the old value of the attribute that’s changing in a session',name:'rsa.misc.change_old',type:'keyword'},'rsa.misc.operation_id':{category:'rsa',description:'An alert number or operation number. The values should be unique and non-repeating.',name:'rsa.misc.operation_id',type:'keyword'},'rsa.misc.event_state':{category:'rsa',description:'This key captures the current state of the object/item referenced within the event. Describing an on-going event.',name:'rsa.misc.event_state',type:'keyword'},'rsa.misc.group_object':{category:'rsa',description:'This key captures a collection/grouping of entities. Specific usage',name:'rsa.misc.group_object',type:'keyword'},'rsa.misc.node':{category:'rsa',description:'Common use case is the node name within a cluster. The cluster name is reflected by the host name.',name:'rsa.misc.node',type:'keyword'},'rsa.misc.rule':{category:'rsa',description:'This key captures the Rule number',name:'rsa.misc.rule',type:'keyword'},'rsa.misc.device_name':{category:'rsa',description:'This is used to capture name of the Device associated with the node Like: a physical disk, printer, etc',name:'rsa.misc.device_name',type:'keyword'},'rsa.misc.param':{category:'rsa',description:'This key is the parameters passed as part of a command or application, etc.',name:'rsa.misc.param',type:'keyword'},'rsa.misc.change_attrib':{category:'rsa',description:'This key is used to capture the name of the attribute that’s changing in a session',name:'rsa.misc.change_attrib',type:'keyword'},'rsa.misc.event_computer':{category:'rsa',description:'This key is a windows only concept, where this key is used to capture fully qualified domain name in a windows log.',name:'rsa.misc.event_computer',type:'keyword'},'rsa.misc.reference_id1':{category:'rsa',description:'This key is for Linked ID to be used as an addition to "reference.id"',name:'rsa.misc.reference_id1',type:'keyword'},'rsa.misc.event_log':{category:'rsa',description:'This key captures the Name of the event log',name:'rsa.misc.event_log',type:'keyword'},'rsa.misc.OS':{category:'rsa',description:'This key captures the Name of the Operating System',name:'rsa.misc.OS',type:'keyword'},'rsa.misc.terminal':{category:'rsa',description:'This key captures the Terminal Names only',name:'rsa.misc.terminal',type:'keyword'},'rsa.misc.msgIdPart3':{category:'rsa',name:'rsa.misc.msgIdPart3',type:'keyword'},'rsa.misc.filter':{category:'rsa',description:'This key captures Filter used to reduce result set',name:'rsa.misc.filter',type:'keyword'},'rsa.misc.serial_number':{category:'rsa',description:'This key is the Serial number associated with a physical asset.',name:'rsa.misc.serial_number',type:'keyword'},'rsa.misc.checksum':{category:'rsa',description:'This key is used to capture the checksum or hash of the entity such as a file or process. Checksum should be used over checksum.src or checksum.dst when it is unclear whether the entity is a source or target of an action.',name:'rsa.misc.checksum',type:'keyword'},'rsa.misc.event_user':{category:'rsa',description:'This key is a windows only concept, where this key is used to capture combination of domain name and username in a windows log.',name:'rsa.misc.event_user',type:'keyword'},'rsa.misc.virusname':{category:'rsa',description:'This key captures the name of the virus',name:'rsa.misc.virusname',type:'keyword'},'rsa.misc.content_type':{category:'rsa',description:'This key is used to capture Content Type only.',name:'rsa.misc.content_type',type:'keyword'},'rsa.misc.group_id':{category:'rsa',description:'This key captures Group ID Number (related to the group name)',name:'rsa.misc.group_id',type:'keyword'},'rsa.misc.policy_id':{category:'rsa',description:'This key is used to capture the Policy ID only, this should be a numeric value, use policy.name otherwise',name:'rsa.misc.policy_id',type:'keyword'},'rsa.misc.vsys':{category:'rsa',description:'This key captures Virtual System Name',name:'rsa.misc.vsys',type:'keyword'},'rsa.misc.connection_id':{category:'rsa',description:'This key captures the Connection ID',name:'rsa.misc.connection_id',type:'keyword'},'rsa.misc.reference_id2':{category:'rsa',description:'This key is for the 2nd Linked ID. Can be either linked to "reference.id" or "reference.id1" value but should not be used unless the other two variables are in play.',name:'rsa.misc.reference_id2',type:'keyword'},'rsa.misc.sensor':{category:'rsa',description:'This key captures Name of the sensor. Typically used in IDS/IPS based devices',name:'rsa.misc.sensor',type:'keyword'},'rsa.misc.sig_id':{category:'rsa',description:'This key captures IDS/IPS Int Signature ID',name:'rsa.misc.sig_id',type:'long'},'rsa.misc.port_name':{category:'rsa',description:'This key is used for Physical or logical port connection but does NOT include a network port. (Example: Printer port name).',name:'rsa.misc.port_name',type:'keyword'},'rsa.misc.rule_group':{category:'rsa',description:'This key captures the Rule group name',name:'rsa.misc.rule_group',type:'keyword'},'rsa.misc.risk_num':{category:'rsa',description:'This key captures a Numeric Risk value',name:'rsa.misc.risk_num',type:'double'},'rsa.misc.trigger_val':{category:'rsa',description:'This key captures the Value of the trigger or threshold condition.',name:'rsa.misc.trigger_val',type:'keyword'},'rsa.misc.log_session_id1':{category:'rsa',description:'This key is used to capture a Linked (Related) Session ID from the session directly',name:'rsa.misc.log_session_id1',type:'keyword'},'rsa.misc.comp_version':{category:'rsa',description:'This key captures the Version level of a sub-component of a product.',name:'rsa.misc.comp_version',type:'keyword'},'rsa.misc.content_version':{category:'rsa',description:'This key captures Version level of a signature or database content.',name:'rsa.misc.content_version',type:'keyword'},'rsa.misc.hardware_id':{category:'rsa',description:'This key is used to capture unique identifier for a device or system (NOT a Mac address)',name:'rsa.misc.hardware_id',type:'keyword'},'rsa.misc.risk':{category:'rsa',description:'This key captures the non-numeric risk value',name:'rsa.misc.risk',type:'keyword'},'rsa.misc.event_id':{category:'rsa',name:'rsa.misc.event_id',type:'keyword'},'rsa.misc.reason':{category:'rsa',name:'rsa.misc.reason',type:'keyword'},'rsa.misc.status':{category:'rsa',name:'rsa.misc.status',type:'keyword'},'rsa.misc.mail_id':{category:'rsa',description:'This key is used to capture the mailbox id/name',name:'rsa.misc.mail_id',type:'keyword'},'rsa.misc.rule_uid':{category:'rsa',description:'This key is the Unique Identifier for a rule.',name:'rsa.misc.rule_uid',type:'keyword'},'rsa.misc.trigger_desc':{category:'rsa',description:'This key captures the Description of the trigger or threshold condition.',name:'rsa.misc.trigger_desc',type:'keyword'},'rsa.misc.inout':{category:'rsa',name:'rsa.misc.inout',type:'keyword'},'rsa.misc.p_msgid':{category:'rsa',name:'rsa.misc.p_msgid',type:'keyword'},'rsa.misc.data_type':{category:'rsa',name:'rsa.misc.data_type',type:'keyword'},'rsa.misc.msgIdPart4':{category:'rsa',name:'rsa.misc.msgIdPart4',type:'keyword'},'rsa.misc.error':{category:'rsa',description:'This key captures All non successful Error codes or responses',name:'rsa.misc.error',type:'keyword'},'rsa.misc.index':{category:'rsa',name:'rsa.misc.index',type:'keyword'},'rsa.misc.listnum':{category:'rsa',description:'This key is used to capture listname or listnumber, primarily for collecting access-list',name:'rsa.misc.listnum',type:'keyword'},'rsa.misc.ntype':{category:'rsa',name:'rsa.misc.ntype',type:'keyword'},'rsa.misc.observed_val':{category:'rsa',description:'This key captures the Value observed (from the perspective of the device generating the log).',name:'rsa.misc.observed_val',type:'keyword'},'rsa.misc.policy_value':{category:'rsa',description:'This key captures the contents of the policy. This contains details about the policy',name:'rsa.misc.policy_value',type:'keyword'},'rsa.misc.pool_name':{category:'rsa',description:'This key captures the name of a resource pool',name:'rsa.misc.pool_name',type:'keyword'},'rsa.misc.rule_template':{category:'rsa',description:'A default set of parameters which are overlayed onto a rule (or rulename) which efffectively constitutes a template',name:'rsa.misc.rule_template',type:'keyword'},'rsa.misc.count':{category:'rsa',name:'rsa.misc.count',type:'keyword'},'rsa.misc.number':{category:'rsa',name:'rsa.misc.number',type:'keyword'},'rsa.misc.sigcat':{category:'rsa',name:'rsa.misc.sigcat',type:'keyword'},'rsa.misc.type':{category:'rsa',name:'rsa.misc.type',type:'keyword'},'rsa.misc.comments':{category:'rsa',description:'Comment information provided in the log message',name:'rsa.misc.comments',type:'keyword'},'rsa.misc.doc_number':{category:'rsa',description:'This key captures File Identification number',name:'rsa.misc.doc_number',type:'long'},'rsa.misc.expected_val':{category:'rsa',description:'This key captures the Value expected (from the perspective of the device generating the log).',name:'rsa.misc.expected_val',type:'keyword'},'rsa.misc.job_num':{category:'rsa',description:'This key captures the Job Number',name:'rsa.misc.job_num',type:'keyword'},'rsa.misc.spi_dst':{category:'rsa',description:'Destination SPI Index',name:'rsa.misc.spi_dst',type:'keyword'},'rsa.misc.spi_src':{category:'rsa',description:'Source SPI Index',name:'rsa.misc.spi_src',type:'keyword'},'rsa.misc.code':{category:'rsa',name:'rsa.misc.code',type:'keyword'},'rsa.misc.agent_id':{category:'rsa',description:'This key is used to capture agent id',name:'rsa.misc.agent_id',type:'keyword'},'rsa.misc.message_body':{category:'rsa',description:'This key captures the The contents of the message body.',name:'rsa.misc.message_body',type:'keyword'},'rsa.misc.phone':{category:'rsa',name:'rsa.misc.phone',type:'keyword'},'rsa.misc.sig_id_str':{category:'rsa',description:'This key captures a string object of the sigid variable.',name:'rsa.misc.sig_id_str',type:'keyword'},'rsa.misc.cmd':{category:'rsa',name:'rsa.misc.cmd',type:'keyword'},'rsa.misc.misc':{category:'rsa',name:'rsa.misc.misc',type:'keyword'},'rsa.misc.name':{category:'rsa',name:'rsa.misc.name',type:'keyword'},'rsa.misc.cpu':{category:'rsa',description:'This key is the CPU time used in the execution of the event being recorded.',name:'rsa.misc.cpu',type:'long'},'rsa.misc.event_desc':{category:'rsa',description:'This key is used to capture a description of an event available directly or inferred',name:'rsa.misc.event_desc',type:'keyword'},'rsa.misc.sig_id1':{category:'rsa',description:'This key captures IDS/IPS Int Signature ID. This must be linked to the sig.id',name:'rsa.misc.sig_id1',type:'long'},'rsa.misc.im_buddyid':{category:'rsa',name:'rsa.misc.im_buddyid',type:'keyword'},'rsa.misc.im_client':{category:'rsa',name:'rsa.misc.im_client',type:'keyword'},'rsa.misc.im_userid':{category:'rsa',name:'rsa.misc.im_userid',type:'keyword'},'rsa.misc.pid':{category:'rsa',name:'rsa.misc.pid',type:'keyword'},'rsa.misc.priority':{category:'rsa',name:'rsa.misc.priority',type:'keyword'},'rsa.misc.context_subject':{category:'rsa',description:'This key is to be used in an audit context where the subject is the object being identified',name:'rsa.misc.context_subject',type:'keyword'},'rsa.misc.context_target':{category:'rsa',name:'rsa.misc.context_target',type:'keyword'},'rsa.misc.cve':{category:'rsa',description:'This key captures CVE (Common Vulnerabilities and Exposures) - an identifier for known information security vulnerabilities.',name:'rsa.misc.cve',type:'keyword'},'rsa.misc.fcatnum':{category:'rsa',description:'This key captures Filter Category Number. Legacy Usage',name:'rsa.misc.fcatnum',type:'keyword'},'rsa.misc.library':{category:'rsa',description:'This key is used to capture library information in mainframe devices',name:'rsa.misc.library',type:'keyword'},'rsa.misc.parent_node':{category:'rsa',description:'This key captures the Parent Node Name. Must be related to node variable.',name:'rsa.misc.parent_node',type:'keyword'},'rsa.misc.risk_info':{category:'rsa',description:'Deprecated, use New Hunting Model (inv.*, ioc, boc, eoc, analysis.*)',name:'rsa.misc.risk_info',type:'keyword'},'rsa.misc.tcp_flags':{category:'rsa',description:'This key is captures the TCP flags set in any packet of session',name:'rsa.misc.tcp_flags',type:'long'},'rsa.misc.tos':{category:'rsa',description:'This key describes the type of service',name:'rsa.misc.tos',type:'long'},'rsa.misc.vm_target':{category:'rsa',description:'VMWare Target **VMWARE** only varaible.',name:'rsa.misc.vm_target',type:'keyword'},'rsa.misc.workspace':{category:'rsa',description:'This key captures Workspace Description',name:'rsa.misc.workspace',type:'keyword'},'rsa.misc.command':{category:'rsa',name:'rsa.misc.command',type:'keyword'},'rsa.misc.event_category':{category:'rsa',name:'rsa.misc.event_category',type:'keyword'},'rsa.misc.facilityname':{category:'rsa',name:'rsa.misc.facilityname',type:'keyword'},'rsa.misc.forensic_info':{category:'rsa',name:'rsa.misc.forensic_info',type:'keyword'},'rsa.misc.jobname':{category:'rsa',name:'rsa.misc.jobname',type:'keyword'},'rsa.misc.mode':{category:'rsa',name:'rsa.misc.mode',type:'keyword'},'rsa.misc.policy':{category:'rsa',name:'rsa.misc.policy',type:'keyword'},'rsa.misc.policy_waiver':{category:'rsa',name:'rsa.misc.policy_waiver',type:'keyword'},'rsa.misc.second':{category:'rsa',name:'rsa.misc.second',type:'keyword'},'rsa.misc.space1':{category:'rsa',name:'rsa.misc.space1',type:'keyword'},'rsa.misc.subcategory':{category:'rsa',name:'rsa.misc.subcategory',type:'keyword'},'rsa.misc.tbdstr2':{category:'rsa',name:'rsa.misc.tbdstr2',type:'keyword'},'rsa.misc.alert_id':{category:'rsa',description:'Deprecated, New Hunting Model (inv.*, ioc, boc, eoc, analysis.*)',name:'rsa.misc.alert_id',type:'keyword'},'rsa.misc.checksum_dst':{category:'rsa',description:'This key is used to capture the checksum or hash of the the target entity such as a process or file.',name:'rsa.misc.checksum_dst',type:'keyword'},'rsa.misc.checksum_src':{category:'rsa',description:'This key is used to capture the checksum or hash of the source entity such as a file or process.',name:'rsa.misc.checksum_src',type:'keyword'},'rsa.misc.fresult':{category:'rsa',description:'This key captures the Filter Result',name:'rsa.misc.fresult',type:'long'},'rsa.misc.payload_dst':{category:'rsa',description:'This key is used to capture destination payload',name:'rsa.misc.payload_dst',type:'keyword'},'rsa.misc.payload_src':{category:'rsa',description:'This key is used to capture source payload',name:'rsa.misc.payload_src',type:'keyword'},'rsa.misc.pool_id':{category:'rsa',description:'This key captures the identifier (typically numeric field) of a resource pool',name:'rsa.misc.pool_id',type:'keyword'},'rsa.misc.process_id_val':{category:'rsa',description:'This key is a failure key for Process ID when it is not an integer value',name:'rsa.misc.process_id_val',type:'keyword'},'rsa.misc.risk_num_comm':{category:'rsa',description:'This key captures Risk Number Community',name:'rsa.misc.risk_num_comm',type:'double'},'rsa.misc.risk_num_next':{category:'rsa',description:'This key captures Risk Number NextGen',name:'rsa.misc.risk_num_next',type:'double'},'rsa.misc.risk_num_sand':{category:'rsa',description:'This key captures Risk Number SandBox',name:'rsa.misc.risk_num_sand',type:'double'},'rsa.misc.risk_num_static':{category:'rsa',description:'This key captures Risk Number Static',name:'rsa.misc.risk_num_static',type:'double'},'rsa.misc.risk_suspicious':{category:'rsa',description:'Deprecated, use New Hunting Model (inv.*, ioc, boc, eoc, analysis.*)',name:'rsa.misc.risk_suspicious',type:'keyword'},'rsa.misc.risk_warning':{category:'rsa',description:'Deprecated, use New Hunting Model (inv.*, ioc, boc, eoc, analysis.*)',name:'rsa.misc.risk_warning',type:'keyword'},'rsa.misc.snmp_oid':{category:'rsa',description:'SNMP Object Identifier',name:'rsa.misc.snmp_oid',type:'keyword'},'rsa.misc.sql':{category:'rsa',description:'This key captures the SQL query',name:'rsa.misc.sql',type:'keyword'},'rsa.misc.vuln_ref':{category:'rsa',description:'This key captures the Vulnerability Reference details',name:'rsa.misc.vuln_ref',type:'keyword'},'rsa.misc.acl_id':{category:'rsa',name:'rsa.misc.acl_id',type:'keyword'},'rsa.misc.acl_op':{category:'rsa',name:'rsa.misc.acl_op',type:'keyword'},'rsa.misc.acl_pos':{category:'rsa',name:'rsa.misc.acl_pos',type:'keyword'},'rsa.misc.acl_table':{category:'rsa',name:'rsa.misc.acl_table',type:'keyword'},'rsa.misc.admin':{category:'rsa',name:'rsa.misc.admin',type:'keyword'},'rsa.misc.alarm_id':{category:'rsa',name:'rsa.misc.alarm_id',type:'keyword'},'rsa.misc.alarmname':{category:'rsa',name:'rsa.misc.alarmname',type:'keyword'},'rsa.misc.app_id':{category:'rsa',name:'rsa.misc.app_id',type:'keyword'},'rsa.misc.audit':{category:'rsa',name:'rsa.misc.audit',type:'keyword'},'rsa.misc.audit_object':{category:'rsa',name:'rsa.misc.audit_object',type:'keyword'},'rsa.misc.auditdata':{category:'rsa',name:'rsa.misc.auditdata',type:'keyword'},'rsa.misc.benchmark':{category:'rsa',name:'rsa.misc.benchmark',type:'keyword'},'rsa.misc.bypass':{category:'rsa',name:'rsa.misc.bypass',type:'keyword'},'rsa.misc.cache':{category:'rsa',name:'rsa.misc.cache',type:'keyword'},'rsa.misc.cache_hit':{category:'rsa',name:'rsa.misc.cache_hit',type:'keyword'},'rsa.misc.cefversion':{category:'rsa',name:'rsa.misc.cefversion',type:'keyword'},'rsa.misc.cfg_attr':{category:'rsa',name:'rsa.misc.cfg_attr',type:'keyword'},'rsa.misc.cfg_obj':{category:'rsa',name:'rsa.misc.cfg_obj',type:'keyword'},'rsa.misc.cfg_path':{category:'rsa',name:'rsa.misc.cfg_path',type:'keyword'},'rsa.misc.changes':{category:'rsa',name:'rsa.misc.changes',type:'keyword'},'rsa.misc.client_ip':{category:'rsa',name:'rsa.misc.client_ip',type:'keyword'},'rsa.misc.clustermembers':{category:'rsa',name:'rsa.misc.clustermembers',type:'keyword'},'rsa.misc.cn_acttimeout':{category:'rsa',name:'rsa.misc.cn_acttimeout',type:'keyword'},'rsa.misc.cn_asn_src':{category:'rsa',name:'rsa.misc.cn_asn_src',type:'keyword'},'rsa.misc.cn_bgpv4nxthop':{category:'rsa',name:'rsa.misc.cn_bgpv4nxthop',type:'keyword'},'rsa.misc.cn_ctr_dst_code':{category:'rsa',name:'rsa.misc.cn_ctr_dst_code',type:'keyword'},'rsa.misc.cn_dst_tos':{category:'rsa',name:'rsa.misc.cn_dst_tos',type:'keyword'},'rsa.misc.cn_dst_vlan':{category:'rsa',name:'rsa.misc.cn_dst_vlan',type:'keyword'},'rsa.misc.cn_engine_id':{category:'rsa',name:'rsa.misc.cn_engine_id',type:'keyword'},'rsa.misc.cn_engine_type':{category:'rsa',name:'rsa.misc.cn_engine_type',type:'keyword'},'rsa.misc.cn_f_switch':{category:'rsa',name:'rsa.misc.cn_f_switch',type:'keyword'},'rsa.misc.cn_flowsampid':{category:'rsa',name:'rsa.misc.cn_flowsampid',type:'keyword'},'rsa.misc.cn_flowsampintv':{category:'rsa',name:'rsa.misc.cn_flowsampintv',type:'keyword'},'rsa.misc.cn_flowsampmode':{category:'rsa',name:'rsa.misc.cn_flowsampmode',type:'keyword'},'rsa.misc.cn_inacttimeout':{category:'rsa',name:'rsa.misc.cn_inacttimeout',type:'keyword'},'rsa.misc.cn_inpermbyts':{category:'rsa',name:'rsa.misc.cn_inpermbyts',type:'keyword'},'rsa.misc.cn_inpermpckts':{category:'rsa',name:'rsa.misc.cn_inpermpckts',type:'keyword'},'rsa.misc.cn_invalid':{category:'rsa',name:'rsa.misc.cn_invalid',type:'keyword'},'rsa.misc.cn_ip_proto_ver':{category:'rsa',name:'rsa.misc.cn_ip_proto_ver',type:'keyword'},'rsa.misc.cn_ipv4_ident':{category:'rsa',name:'rsa.misc.cn_ipv4_ident',type:'keyword'},'rsa.misc.cn_l_switch':{category:'rsa',name:'rsa.misc.cn_l_switch',type:'keyword'},'rsa.misc.cn_log_did':{category:'rsa',name:'rsa.misc.cn_log_did',type:'keyword'},'rsa.misc.cn_log_rid':{category:'rsa',name:'rsa.misc.cn_log_rid',type:'keyword'},'rsa.misc.cn_max_ttl':{category:'rsa',name:'rsa.misc.cn_max_ttl',type:'keyword'},'rsa.misc.cn_maxpcktlen':{category:'rsa',name:'rsa.misc.cn_maxpcktlen',type:'keyword'},'rsa.misc.cn_min_ttl':{category:'rsa',name:'rsa.misc.cn_min_ttl',type:'keyword'},'rsa.misc.cn_minpcktlen':{category:'rsa',name:'rsa.misc.cn_minpcktlen',type:'keyword'},'rsa.misc.cn_mpls_lbl_1':{category:'rsa',name:'rsa.misc.cn_mpls_lbl_1',type:'keyword'},'rsa.misc.cn_mpls_lbl_10':{category:'rsa',name:'rsa.misc.cn_mpls_lbl_10',type:'keyword'},'rsa.misc.cn_mpls_lbl_2':{category:'rsa',name:'rsa.misc.cn_mpls_lbl_2',type:'keyword'},'rsa.misc.cn_mpls_lbl_3':{category:'rsa',name:'rsa.misc.cn_mpls_lbl_3',type:'keyword'},'rsa.misc.cn_mpls_lbl_4':{category:'rsa',name:'rsa.misc.cn_mpls_lbl_4',type:'keyword'},'rsa.misc.cn_mpls_lbl_5':{category:'rsa',name:'rsa.misc.cn_mpls_lbl_5',type:'keyword'},'rsa.misc.cn_mpls_lbl_6':{category:'rsa',name:'rsa.misc.cn_mpls_lbl_6',type:'keyword'},'rsa.misc.cn_mpls_lbl_7':{category:'rsa',name:'rsa.misc.cn_mpls_lbl_7',type:'keyword'},'rsa.misc.cn_mpls_lbl_8':{category:'rsa',name:'rsa.misc.cn_mpls_lbl_8',type:'keyword'},'rsa.misc.cn_mpls_lbl_9':{category:'rsa',name:'rsa.misc.cn_mpls_lbl_9',type:'keyword'},'rsa.misc.cn_mplstoplabel':{category:'rsa',name:'rsa.misc.cn_mplstoplabel',type:'keyword'},'rsa.misc.cn_mplstoplabip':{category:'rsa',name:'rsa.misc.cn_mplstoplabip',type:'keyword'},'rsa.misc.cn_mul_dst_byt':{category:'rsa',name:'rsa.misc.cn_mul_dst_byt',type:'keyword'},'rsa.misc.cn_mul_dst_pks':{category:'rsa',name:'rsa.misc.cn_mul_dst_pks',type:'keyword'},'rsa.misc.cn_muligmptype':{category:'rsa',name:'rsa.misc.cn_muligmptype',type:'keyword'},'rsa.misc.cn_sampalgo':{category:'rsa',name:'rsa.misc.cn_sampalgo',type:'keyword'},'rsa.misc.cn_sampint':{category:'rsa',name:'rsa.misc.cn_sampint',type:'keyword'},'rsa.misc.cn_seqctr':{category:'rsa',name:'rsa.misc.cn_seqctr',type:'keyword'},'rsa.misc.cn_spackets':{category:'rsa',name:'rsa.misc.cn_spackets',type:'keyword'},'rsa.misc.cn_src_tos':{category:'rsa',name:'rsa.misc.cn_src_tos',type:'keyword'},'rsa.misc.cn_src_vlan':{category:'rsa',name:'rsa.misc.cn_src_vlan',type:'keyword'},'rsa.misc.cn_sysuptime':{category:'rsa',name:'rsa.misc.cn_sysuptime',type:'keyword'},'rsa.misc.cn_template_id':{category:'rsa',name:'rsa.misc.cn_template_id',type:'keyword'},'rsa.misc.cn_totbytsexp':{category:'rsa',name:'rsa.misc.cn_totbytsexp',type:'keyword'},'rsa.misc.cn_totflowexp':{category:'rsa',name:'rsa.misc.cn_totflowexp',type:'keyword'},'rsa.misc.cn_totpcktsexp':{category:'rsa',name:'rsa.misc.cn_totpcktsexp',type:'keyword'},'rsa.misc.cn_unixnanosecs':{category:'rsa',name:'rsa.misc.cn_unixnanosecs',type:'keyword'},'rsa.misc.cn_v6flowlabel':{category:'rsa',name:'rsa.misc.cn_v6flowlabel',type:'keyword'},'rsa.misc.cn_v6optheaders':{category:'rsa',name:'rsa.misc.cn_v6optheaders',type:'keyword'},'rsa.misc.comp_class':{category:'rsa',name:'rsa.misc.comp_class',type:'keyword'},'rsa.misc.comp_name':{category:'rsa',name:'rsa.misc.comp_name',type:'keyword'},'rsa.misc.comp_rbytes':{category:'rsa',name:'rsa.misc.comp_rbytes',type:'keyword'},'rsa.misc.comp_sbytes':{category:'rsa',name:'rsa.misc.comp_sbytes',type:'keyword'},'rsa.misc.cpu_data':{category:'rsa',name:'rsa.misc.cpu_data',type:'keyword'},'rsa.misc.criticality':{category:'rsa',name:'rsa.misc.criticality',type:'keyword'},'rsa.misc.cs_agency_dst':{category:'rsa',name:'rsa.misc.cs_agency_dst',type:'keyword'},'rsa.misc.cs_analyzedby':{category:'rsa',name:'rsa.misc.cs_analyzedby',type:'keyword'},'rsa.misc.cs_av_other':{category:'rsa',name:'rsa.misc.cs_av_other',type:'keyword'},'rsa.misc.cs_av_primary':{category:'rsa',name:'rsa.misc.cs_av_primary',type:'keyword'},'rsa.misc.cs_av_secondary':{category:'rsa',name:'rsa.misc.cs_av_secondary',type:'keyword'},'rsa.misc.cs_bgpv6nxthop':{category:'rsa',name:'rsa.misc.cs_bgpv6nxthop',type:'keyword'},'rsa.misc.cs_bit9status':{category:'rsa',name:'rsa.misc.cs_bit9status',type:'keyword'},'rsa.misc.cs_context':{category:'rsa',name:'rsa.misc.cs_context',type:'keyword'},'rsa.misc.cs_control':{category:'rsa',name:'rsa.misc.cs_control',type:'keyword'},'rsa.misc.cs_data':{category:'rsa',name:'rsa.misc.cs_data',type:'keyword'},'rsa.misc.cs_datecret':{category:'rsa',name:'rsa.misc.cs_datecret',type:'keyword'},'rsa.misc.cs_dst_tld':{category:'rsa',name:'rsa.misc.cs_dst_tld',type:'keyword'},'rsa.misc.cs_eth_dst_ven':{category:'rsa',name:'rsa.misc.cs_eth_dst_ven',type:'keyword'},'rsa.misc.cs_eth_src_ven':{category:'rsa',name:'rsa.misc.cs_eth_src_ven',type:'keyword'},'rsa.misc.cs_event_uuid':{category:'rsa',name:'rsa.misc.cs_event_uuid',type:'keyword'},'rsa.misc.cs_filetype':{category:'rsa',name:'rsa.misc.cs_filetype',type:'keyword'},'rsa.misc.cs_fld':{category:'rsa',name:'rsa.misc.cs_fld',type:'keyword'},'rsa.misc.cs_if_desc':{category:'rsa',name:'rsa.misc.cs_if_desc',type:'keyword'},'rsa.misc.cs_if_name':{category:'rsa',name:'rsa.misc.cs_if_name',type:'keyword'},'rsa.misc.cs_ip_next_hop':{category:'rsa',name:'rsa.misc.cs_ip_next_hop',type:'keyword'},'rsa.misc.cs_ipv4dstpre':{category:'rsa',name:'rsa.misc.cs_ipv4dstpre',type:'keyword'},'rsa.misc.cs_ipv4srcpre':{category:'rsa',name:'rsa.misc.cs_ipv4srcpre',type:'keyword'},'rsa.misc.cs_lifetime':{category:'rsa',name:'rsa.misc.cs_lifetime',type:'keyword'},'rsa.misc.cs_log_medium':{category:'rsa',name:'rsa.misc.cs_log_medium',type:'keyword'},'rsa.misc.cs_loginname':{category:'rsa',name:'rsa.misc.cs_loginname',type:'keyword'},'rsa.misc.cs_modulescore':{category:'rsa',name:'rsa.misc.cs_modulescore',type:'keyword'},'rsa.misc.cs_modulesign':{category:'rsa',name:'rsa.misc.cs_modulesign',type:'keyword'},'rsa.misc.cs_opswatresult':{category:'rsa',name:'rsa.misc.cs_opswatresult',type:'keyword'},'rsa.misc.cs_payload':{category:'rsa',name:'rsa.misc.cs_payload',type:'keyword'},'rsa.misc.cs_registrant':{category:'rsa',name:'rsa.misc.cs_registrant',type:'keyword'},'rsa.misc.cs_registrar':{category:'rsa',name:'rsa.misc.cs_registrar',type:'keyword'},'rsa.misc.cs_represult':{category:'rsa',name:'rsa.misc.cs_represult',type:'keyword'},'rsa.misc.cs_rpayload':{category:'rsa',name:'rsa.misc.cs_rpayload',type:'keyword'},'rsa.misc.cs_sampler_name':{category:'rsa',name:'rsa.misc.cs_sampler_name',type:'keyword'},'rsa.misc.cs_sourcemodule':{category:'rsa',name:'rsa.misc.cs_sourcemodule',type:'keyword'},'rsa.misc.cs_streams':{category:'rsa',name:'rsa.misc.cs_streams',type:'keyword'},'rsa.misc.cs_targetmodule':{category:'rsa',name:'rsa.misc.cs_targetmodule',type:'keyword'},'rsa.misc.cs_v6nxthop':{category:'rsa',name:'rsa.misc.cs_v6nxthop',type:'keyword'},'rsa.misc.cs_whois_server':{category:'rsa',name:'rsa.misc.cs_whois_server',type:'keyword'},'rsa.misc.cs_yararesult':{category:'rsa',name:'rsa.misc.cs_yararesult',type:'keyword'},'rsa.misc.description':{category:'rsa',name:'rsa.misc.description',type:'keyword'},'rsa.misc.devvendor':{category:'rsa',name:'rsa.misc.devvendor',type:'keyword'},'rsa.misc.distance':{category:'rsa',name:'rsa.misc.distance',type:'keyword'},'rsa.misc.dstburb':{category:'rsa',name:'rsa.misc.dstburb',type:'keyword'},'rsa.misc.edomain':{category:'rsa',name:'rsa.misc.edomain',type:'keyword'},'rsa.misc.edomaub':{category:'rsa',name:'rsa.misc.edomaub',type:'keyword'},'rsa.misc.euid':{category:'rsa',name:'rsa.misc.euid',type:'keyword'},'rsa.misc.facility':{category:'rsa',name:'rsa.misc.facility',type:'keyword'},'rsa.misc.finterface':{category:'rsa',name:'rsa.misc.finterface',type:'keyword'},'rsa.misc.flags':{category:'rsa',name:'rsa.misc.flags',type:'keyword'},'rsa.misc.gaddr':{category:'rsa',name:'rsa.misc.gaddr',type:'keyword'},'rsa.misc.id3':{category:'rsa',name:'rsa.misc.id3',type:'keyword'},'rsa.misc.im_buddyname':{category:'rsa',name:'rsa.misc.im_buddyname',type:'keyword'},'rsa.misc.im_croomid':{category:'rsa',name:'rsa.misc.im_croomid',type:'keyword'},'rsa.misc.im_croomtype':{category:'rsa',name:'rsa.misc.im_croomtype',type:'keyword'},'rsa.misc.im_members':{category:'rsa',name:'rsa.misc.im_members',type:'keyword'},'rsa.misc.im_username':{category:'rsa',name:'rsa.misc.im_username',type:'keyword'},'rsa.misc.ipkt':{category:'rsa',name:'rsa.misc.ipkt',type:'keyword'},'rsa.misc.ipscat':{category:'rsa',name:'rsa.misc.ipscat',type:'keyword'},'rsa.misc.ipspri':{category:'rsa',name:'rsa.misc.ipspri',type:'keyword'},'rsa.misc.latitude':{category:'rsa',name:'rsa.misc.latitude',type:'keyword'},'rsa.misc.linenum':{category:'rsa',name:'rsa.misc.linenum',type:'keyword'},'rsa.misc.list_name':{category:'rsa',name:'rsa.misc.list_name',type:'keyword'},'rsa.misc.load_data':{category:'rsa',name:'rsa.misc.load_data',type:'keyword'},'rsa.misc.location_floor':{category:'rsa',name:'rsa.misc.location_floor',type:'keyword'},'rsa.misc.location_mark':{category:'rsa',name:'rsa.misc.location_mark',type:'keyword'},'rsa.misc.log_id':{category:'rsa',name:'rsa.misc.log_id',type:'keyword'},'rsa.misc.log_type':{category:'rsa',name:'rsa.misc.log_type',type:'keyword'},'rsa.misc.logid':{category:'rsa',name:'rsa.misc.logid',type:'keyword'},'rsa.misc.logip':{category:'rsa',name:'rsa.misc.logip',type:'keyword'},'rsa.misc.logname':{category:'rsa',name:'rsa.misc.logname',type:'keyword'},'rsa.misc.longitude':{category:'rsa',name:'rsa.misc.longitude',type:'keyword'},'rsa.misc.lport':{category:'rsa',name:'rsa.misc.lport',type:'keyword'},'rsa.misc.mbug_data':{category:'rsa',name:'rsa.misc.mbug_data',type:'keyword'},'rsa.misc.misc_name':{category:'rsa',name:'rsa.misc.misc_name',type:'keyword'},'rsa.misc.msg_type':{category:'rsa',name:'rsa.misc.msg_type',type:'keyword'},'rsa.misc.msgid':{category:'rsa',name:'rsa.misc.msgid',type:'keyword'},'rsa.misc.netsessid':{category:'rsa',name:'rsa.misc.netsessid',type:'keyword'},'rsa.misc.num':{category:'rsa',name:'rsa.misc.num',type:'keyword'},'rsa.misc.number1':{category:'rsa',name:'rsa.misc.number1',type:'keyword'},'rsa.misc.number2':{category:'rsa',name:'rsa.misc.number2',type:'keyword'},'rsa.misc.nwwn':{category:'rsa',name:'rsa.misc.nwwn',type:'keyword'},'rsa.misc.object':{category:'rsa',name:'rsa.misc.object',type:'keyword'},'rsa.misc.operation':{category:'rsa',name:'rsa.misc.operation',type:'keyword'},'rsa.misc.opkt':{category:'rsa',name:'rsa.misc.opkt',type:'keyword'},'rsa.misc.orig_from':{category:'rsa',name:'rsa.misc.orig_from',type:'keyword'},'rsa.misc.owner_id':{category:'rsa',name:'rsa.misc.owner_id',type:'keyword'},'rsa.misc.p_action':{category:'rsa',name:'rsa.misc.p_action',type:'keyword'},'rsa.misc.p_filter':{category:'rsa',name:'rsa.misc.p_filter',type:'keyword'},'rsa.misc.p_group_object':{category:'rsa',name:'rsa.misc.p_group_object',type:'keyword'},'rsa.misc.p_id':{category:'rsa',name:'rsa.misc.p_id',type:'keyword'},'rsa.misc.p_msgid1':{category:'rsa',name:'rsa.misc.p_msgid1',type:'keyword'},'rsa.misc.p_msgid2':{category:'rsa',name:'rsa.misc.p_msgid2',type:'keyword'},'rsa.misc.p_result1':{category:'rsa',name:'rsa.misc.p_result1',type:'keyword'},'rsa.misc.password_chg':{category:'rsa',name:'rsa.misc.password_chg',type:'keyword'},'rsa.misc.password_expire':{category:'rsa',name:'rsa.misc.password_expire',type:'keyword'},'rsa.misc.permgranted':{category:'rsa',name:'rsa.misc.permgranted',type:'keyword'},'rsa.misc.permwanted':{category:'rsa',name:'rsa.misc.permwanted',type:'keyword'},'rsa.misc.pgid':{category:'rsa',name:'rsa.misc.pgid',type:'keyword'},'rsa.misc.policyUUID':{category:'rsa',name:'rsa.misc.policyUUID',type:'keyword'},'rsa.misc.prog_asp_num':{category:'rsa',name:'rsa.misc.prog_asp_num',type:'keyword'},'rsa.misc.program':{category:'rsa',name:'rsa.misc.program',type:'keyword'},'rsa.misc.real_data':{category:'rsa',name:'rsa.misc.real_data',type:'keyword'},'rsa.misc.rec_asp_device':{category:'rsa',name:'rsa.misc.rec_asp_device',type:'keyword'},'rsa.misc.rec_asp_num':{category:'rsa',name:'rsa.misc.rec_asp_num',type:'keyword'},'rsa.misc.rec_library':{category:'rsa',name:'rsa.misc.rec_library',type:'keyword'},'rsa.misc.recordnum':{category:'rsa',name:'rsa.misc.recordnum',type:'keyword'},'rsa.misc.ruid':{category:'rsa',name:'rsa.misc.ruid',type:'keyword'},'rsa.misc.sburb':{category:'rsa',name:'rsa.misc.sburb',type:'keyword'},'rsa.misc.sdomain_fld':{category:'rsa',name:'rsa.misc.sdomain_fld',type:'keyword'},'rsa.misc.sec':{category:'rsa',name:'rsa.misc.sec',type:'keyword'},'rsa.misc.sensorname':{category:'rsa',name:'rsa.misc.sensorname',type:'keyword'},'rsa.misc.seqnum':{category:'rsa',name:'rsa.misc.seqnum',type:'keyword'},'rsa.misc.session':{category:'rsa',name:'rsa.misc.session',type:'keyword'},'rsa.misc.sessiontype':{category:'rsa',name:'rsa.misc.sessiontype',type:'keyword'},'rsa.misc.sigUUID':{category:'rsa',name:'rsa.misc.sigUUID',type:'keyword'},'rsa.misc.spi':{category:'rsa',name:'rsa.misc.spi',type:'keyword'},'rsa.misc.srcburb':{category:'rsa',name:'rsa.misc.srcburb',type:'keyword'},'rsa.misc.srcdom':{category:'rsa',name:'rsa.misc.srcdom',type:'keyword'},'rsa.misc.srcservice':{category:'rsa',name:'rsa.misc.srcservice',type:'keyword'},'rsa.misc.state':{category:'rsa',name:'rsa.misc.state',type:'keyword'},'rsa.misc.status1':{category:'rsa',name:'rsa.misc.status1',type:'keyword'},'rsa.misc.svcno':{category:'rsa',name:'rsa.misc.svcno',type:'keyword'},'rsa.misc.system':{category:'rsa',name:'rsa.misc.system',type:'keyword'},'rsa.misc.tbdstr1':{category:'rsa',name:'rsa.misc.tbdstr1',type:'keyword'},'rsa.misc.tgtdom':{category:'rsa',name:'rsa.misc.tgtdom',type:'keyword'},'rsa.misc.tgtdomain':{category:'rsa',name:'rsa.misc.tgtdomain',type:'keyword'},'rsa.misc.threshold':{category:'rsa',name:'rsa.misc.threshold',type:'keyword'},'rsa.misc.type1':{category:'rsa',name:'rsa.misc.type1',type:'keyword'},'rsa.misc.udb_class':{category:'rsa',name:'rsa.misc.udb_class',type:'keyword'},'rsa.misc.url_fld':{category:'rsa',name:'rsa.misc.url_fld',type:'keyword'},'rsa.misc.user_div':{category:'rsa',name:'rsa.misc.user_div',type:'keyword'},'rsa.misc.userid':{category:'rsa',name:'rsa.misc.userid',type:'keyword'},'rsa.misc.username_fld':{category:'rsa',name:'rsa.misc.username_fld',type:'keyword'},'rsa.misc.utcstamp':{category:'rsa',name:'rsa.misc.utcstamp',type:'keyword'},'rsa.misc.v_instafname':{category:'rsa',name:'rsa.misc.v_instafname',type:'keyword'},'rsa.misc.virt_data':{category:'rsa',name:'rsa.misc.virt_data',type:'keyword'},'rsa.misc.vpnid':{category:'rsa',name:'rsa.misc.vpnid',type:'keyword'},'rsa.misc.autorun_type':{category:'rsa',description:'This is used to capture Auto Run type',name:'rsa.misc.autorun_type',type:'keyword'},'rsa.misc.cc_number':{category:'rsa',description:'Valid Credit Card Numbers only',name:'rsa.misc.cc_number',type:'long'},'rsa.misc.content':{category:'rsa',description:'This key captures the content type from protocol headers',name:'rsa.misc.content',type:'keyword'},'rsa.misc.ein_number':{category:'rsa',description:'Employee Identification Numbers only',name:'rsa.misc.ein_number',type:'long'},'rsa.misc.found':{category:'rsa',description:'This is used to capture the results of regex match',name:'rsa.misc.found',type:'keyword'},'rsa.misc.language':{category:'rsa',description:'This is used to capture list of languages the client support and what it prefers',name:'rsa.misc.language',type:'keyword'},'rsa.misc.lifetime':{category:'rsa',description:'This key is used to capture the session lifetime in seconds.',name:'rsa.misc.lifetime',type:'long'},'rsa.misc.link':{category:'rsa',description:'This key is used to link the sessions together. This key should never be used to parse Meta data from a session (Logs/Packets) Directly, this is a Reserved key in NetWitness',name:'rsa.misc.link',type:'keyword'},'rsa.misc.match':{category:'rsa',description:'This key is for regex match name from search.ini',name:'rsa.misc.match',type:'keyword'},'rsa.misc.param_dst':{category:'rsa',description:'This key captures the command line/launch argument of the target process or file',name:'rsa.misc.param_dst',type:'keyword'},'rsa.misc.param_src':{category:'rsa',description:'This key captures source parameter',name:'rsa.misc.param_src',type:'keyword'},'rsa.misc.search_text':{category:'rsa',description:'This key captures the Search Text used',name:'rsa.misc.search_text',type:'keyword'},'rsa.misc.sig_name':{category:'rsa',description:'This key is used to capture the Signature Name only.',name:'rsa.misc.sig_name',type:'keyword'},'rsa.misc.snmp_value':{category:'rsa',description:'SNMP set request value',name:'rsa.misc.snmp_value',type:'keyword'},'rsa.misc.streams':{category:'rsa',description:'This key captures number of streams in session',name:'rsa.misc.streams',type:'long'},'rsa.db.index':{category:'rsa',description:'This key captures IndexID of the index.',name:'rsa.db.index',type:'keyword'},'rsa.db.instance':{category:'rsa',description:'This key is used to capture the database server instance name',name:'rsa.db.instance',type:'keyword'},'rsa.db.database':{category:'rsa',description:'This key is used to capture the name of a database or an instance as seen in a session',name:'rsa.db.database',type:'keyword'},'rsa.db.transact_id':{category:'rsa',description:'This key captures the SQL transantion ID of the current session',name:'rsa.db.transact_id',type:'keyword'},'rsa.db.permissions':{category:'rsa',description:'This key captures permission or privilege level assigned to a resource.',name:'rsa.db.permissions',type:'keyword'},'rsa.db.table_name':{category:'rsa',description:'This key is used to capture the table name',name:'rsa.db.table_name',type:'keyword'},'rsa.db.db_id':{category:'rsa',description:'This key is used to capture the unique identifier for a database',name:'rsa.db.db_id',type:'keyword'},'rsa.db.db_pid':{category:'rsa',description:'This key captures the process id of a connection with database server',name:'rsa.db.db_pid',type:'long'},'rsa.db.lread':{category:'rsa',description:'This key is used for the number of logical reads',name:'rsa.db.lread',type:'long'},'rsa.db.lwrite':{category:'rsa',description:'This key is used for the number of logical writes',name:'rsa.db.lwrite',type:'long'},'rsa.db.pread':{category:'rsa',description:'This key is used for the number of physical writes',name:'rsa.db.pread',type:'long'},'rsa.network.alias_host':{category:'rsa',description:'This key should be used when the source or destination context of a hostname is not clear.Also it captures the Device Hostname. Any Hostname that isnt ad.computer.',name:'rsa.network.alias_host',type:'keyword'},'rsa.network.domain':{category:'rsa',name:'rsa.network.domain',type:'keyword'},'rsa.network.host_dst':{category:'rsa',description:'This key should only be used when it’s a Destination Hostname',name:'rsa.network.host_dst',type:'keyword'},'rsa.network.network_service':{category:'rsa',description:'This is used to capture layer 7 protocols/service names',name:'rsa.network.network_service',type:'keyword'},'rsa.network.interface':{category:'rsa',description:'This key should be used when the source or destination context of an interface is not clear',name:'rsa.network.interface',type:'keyword'},'rsa.network.network_port':{category:'rsa',description:'Deprecated, use port. NOTE: There is a type discrepancy as currently used, TM: Int32, INDEX: UInt64 (why neither chose the correct UInt16?!)',name:'rsa.network.network_port',type:'long'},'rsa.network.eth_host':{category:'rsa',description:'Deprecated, use alias.mac',name:'rsa.network.eth_host',type:'keyword'},'rsa.network.sinterface':{category:'rsa',description:'This key should only be used when it’s a Source Interface',name:'rsa.network.sinterface',type:'keyword'},'rsa.network.dinterface':{category:'rsa',description:'This key should only be used when it’s a Destination Interface',name:'rsa.network.dinterface',type:'keyword'},'rsa.network.vlan':{category:'rsa',description:'This key should only be used to capture the ID of the Virtual LAN',name:'rsa.network.vlan',type:'long'},'rsa.network.zone_src':{category:'rsa',description:'This key should only be used when it’s a Source Zone.',name:'rsa.network.zone_src',type:'keyword'},'rsa.network.zone':{category:'rsa',description:'This key should be used when the source or destination context of a Zone is not clear',name:'rsa.network.zone',type:'keyword'},'rsa.network.zone_dst':{category:'rsa',description:'This key should only be used when it’s a Destination Zone.',name:'rsa.network.zone_dst',type:'keyword'},'rsa.network.gateway':{category:'rsa',description:'This key is used to capture the IP Address of the gateway',name:'rsa.network.gateway',type:'keyword'},'rsa.network.icmp_type':{category:'rsa',description:'This key is used to capture the ICMP type only',name:'rsa.network.icmp_type',type:'long'},'rsa.network.mask':{category:'rsa',description:'This key is used to capture the device network IPmask.',name:'rsa.network.mask',type:'keyword'},'rsa.network.icmp_code':{category:'rsa',description:'This key is used to capture the ICMP code only',name:'rsa.network.icmp_code',type:'long'},'rsa.network.protocol_detail':{category:'rsa',description:'This key should be used to capture additional protocol information',name:'rsa.network.protocol_detail',type:'keyword'},'rsa.network.dmask':{category:'rsa',description:'This key is used for Destionation Device network mask',name:'rsa.network.dmask',type:'keyword'},'rsa.network.port':{category:'rsa',description:'This key should only be used to capture a Network Port when the directionality is not clear',name:'rsa.network.port',type:'long'},'rsa.network.smask':{category:'rsa',description:'This key is used for capturing source Network Mask',name:'rsa.network.smask',type:'keyword'},'rsa.network.netname':{category:'rsa',description:'This key is used to capture the network name associated with an IP range. This is configured by the end user.',name:'rsa.network.netname',type:'keyword'},'rsa.network.paddr':{category:'rsa',description:'Deprecated',name:'rsa.network.paddr',type:'ip'},'rsa.network.faddr':{category:'rsa',name:'rsa.network.faddr',type:'keyword'},'rsa.network.lhost':{category:'rsa',name:'rsa.network.lhost',type:'keyword'},'rsa.network.origin':{category:'rsa',name:'rsa.network.origin',type:'keyword'},'rsa.network.remote_domain_id':{category:'rsa',name:'rsa.network.remote_domain_id',type:'keyword'},'rsa.network.addr':{category:'rsa',name:'rsa.network.addr',type:'keyword'},'rsa.network.dns_a_record':{category:'rsa',name:'rsa.network.dns_a_record',type:'keyword'},'rsa.network.dns_ptr_record':{category:'rsa',name:'rsa.network.dns_ptr_record',type:'keyword'},'rsa.network.fhost':{category:'rsa',name:'rsa.network.fhost',type:'keyword'},'rsa.network.fport':{category:'rsa',name:'rsa.network.fport',type:'keyword'},'rsa.network.laddr':{category:'rsa',name:'rsa.network.laddr',type:'keyword'},'rsa.network.linterface':{category:'rsa',name:'rsa.network.linterface',type:'keyword'},'rsa.network.phost':{category:'rsa',name:'rsa.network.phost',type:'keyword'},'rsa.network.ad_computer_dst':{category:'rsa',description:'Deprecated, use host.dst',name:'rsa.network.ad_computer_dst',type:'keyword'},'rsa.network.eth_type':{category:'rsa',description:'This key is used to capture Ethernet Type, Used for Layer 3 Protocols Only',name:'rsa.network.eth_type',type:'long'},'rsa.network.ip_proto':{category:'rsa',description:'This key should be used to capture the Protocol number, all the protocol nubers are converted into string in UI',name:'rsa.network.ip_proto',type:'long'},'rsa.network.dns_cname_record':{category:'rsa',name:'rsa.network.dns_cname_record',type:'keyword'},'rsa.network.dns_id':{category:'rsa',name:'rsa.network.dns_id',type:'keyword'},'rsa.network.dns_opcode':{category:'rsa',name:'rsa.network.dns_opcode',type:'keyword'},'rsa.network.dns_resp':{category:'rsa',name:'rsa.network.dns_resp',type:'keyword'},'rsa.network.dns_type':{category:'rsa',name:'rsa.network.dns_type',type:'keyword'},'rsa.network.domain1':{category:'rsa',name:'rsa.network.domain1',type:'keyword'},'rsa.network.host_type':{category:'rsa',name:'rsa.network.host_type',type:'keyword'},'rsa.network.packet_length':{category:'rsa',name:'rsa.network.packet_length',type:'keyword'},'rsa.network.host_orig':{category:'rsa',description:'This is used to capture the original hostname in case of a Forwarding Agent or a Proxy in between.',name:'rsa.network.host_orig',type:'keyword'},'rsa.network.rpayload':{category:'rsa',description:'This key is used to capture the total number of payload bytes seen in the retransmitted packets.',name:'rsa.network.rpayload',type:'keyword'},'rsa.network.vlan_name':{category:'rsa',description:'This key should only be used to capture the name of the Virtual LAN',name:'rsa.network.vlan_name',type:'keyword'},'rsa.investigations.ec_activity':{category:'rsa',description:'This key captures the particular event activity(Ex:Logoff)',name:'rsa.investigations.ec_activity',type:'keyword'},'rsa.investigations.ec_theme':{category:'rsa',description:'This key captures the Theme of a particular Event(Ex:Authentication)',name:'rsa.investigations.ec_theme',type:'keyword'},'rsa.investigations.ec_subject':{category:'rsa',description:'This key captures the Subject of a particular Event(Ex:User)',name:'rsa.investigations.ec_subject',type:'keyword'},'rsa.investigations.ec_outcome':{category:'rsa',description:'This key captures the outcome of a particular Event(Ex:Success)',name:'rsa.investigations.ec_outcome',type:'keyword'},'rsa.investigations.event_cat':{category:'rsa',description:'This key captures the Event category number',name:'rsa.investigations.event_cat',type:'long'},'rsa.investigations.event_cat_name':{category:'rsa',description:'This key captures the event category name corresponding to the event cat code',name:'rsa.investigations.event_cat_name',type:'keyword'},'rsa.investigations.event_vcat':{category:'rsa',description:'This is a vendor supplied category. This should be used in situations where the vendor has adopted their own event_category taxonomy.',name:'rsa.investigations.event_vcat',type:'keyword'},'rsa.investigations.analysis_file':{category:'rsa',description:'This is used to capture all indicators used in a File Analysis. This key should be used to capture an analysis of a file',name:'rsa.investigations.analysis_file',type:'keyword'},'rsa.investigations.analysis_service':{category:'rsa',description:'This is used to capture all indicators used in a Service Analysis. This key should be used to capture an analysis of a service',name:'rsa.investigations.analysis_service',type:'keyword'},'rsa.investigations.analysis_session':{category:'rsa',description:'This is used to capture all indicators used for a Session Analysis. This key should be used to capture an analysis of a session',name:'rsa.investigations.analysis_session',type:'keyword'},'rsa.investigations.boc':{category:'rsa',description:'This is used to capture behaviour of compromise',name:'rsa.investigations.boc',type:'keyword'},'rsa.investigations.eoc':{category:'rsa',description:'This is used to capture Enablers of Compromise',name:'rsa.investigations.eoc',type:'keyword'},'rsa.investigations.inv_category':{category:'rsa',description:'This used to capture investigation category',name:'rsa.investigations.inv_category',type:'keyword'},'rsa.investigations.inv_context':{category:'rsa',description:'This used to capture investigation context',name:'rsa.investigations.inv_context',type:'keyword'},'rsa.investigations.ioc':{category:'rsa',description:'This is key capture indicator of compromise',name:'rsa.investigations.ioc',type:'keyword'},'rsa.counters.dclass_c1':{category:'rsa',description:'This is a generic counter key that should be used with the label dclass.c1.str only',name:'rsa.counters.dclass_c1',type:'long'},'rsa.counters.dclass_c2':{category:'rsa',description:'This is a generic counter key that should be used with the label dclass.c2.str only',name:'rsa.counters.dclass_c2',type:'long'},'rsa.counters.event_counter':{category:'rsa',description:'This is used to capture the number of times an event repeated',name:'rsa.counters.event_counter',type:'long'},'rsa.counters.dclass_r1':{category:'rsa',description:'This is a generic ratio key that should be used with the label dclass.r1.str only',name:'rsa.counters.dclass_r1',type:'keyword'},'rsa.counters.dclass_c3':{category:'rsa',description:'This is a generic counter key that should be used with the label dclass.c3.str only',name:'rsa.counters.dclass_c3',type:'long'},'rsa.counters.dclass_c1_str':{category:'rsa',description:'This is a generic counter string key that should be used with the label dclass.c1 only',name:'rsa.counters.dclass_c1_str',type:'keyword'},'rsa.counters.dclass_c2_str':{category:'rsa',description:'This is a generic counter string key that should be used with the label dclass.c2 only',name:'rsa.counters.dclass_c2_str',type:'keyword'},'rsa.counters.dclass_r1_str':{category:'rsa',description:'This is a generic ratio string key that should be used with the label dclass.r1 only',name:'rsa.counters.dclass_r1_str',type:'keyword'},'rsa.counters.dclass_r2':{category:'rsa',description:'This is a generic ratio key that should be used with the label dclass.r2.str only',name:'rsa.counters.dclass_r2',type:'keyword'},'rsa.counters.dclass_c3_str':{category:'rsa',description:'This is a generic counter string key that should be used with the label dclass.c3 only',name:'rsa.counters.dclass_c3_str',type:'keyword'},'rsa.counters.dclass_r3':{category:'rsa',description:'This is a generic ratio key that should be used with the label dclass.r3.str only',name:'rsa.counters.dclass_r3',type:'keyword'},'rsa.counters.dclass_r2_str':{category:'rsa',description:'This is a generic ratio string key that should be used with the label dclass.r2 only',name:'rsa.counters.dclass_r2_str',type:'keyword'},'rsa.counters.dclass_r3_str':{category:'rsa',description:'This is a generic ratio string key that should be used with the label dclass.r3 only',name:'rsa.counters.dclass_r3_str',type:'keyword'},'rsa.identity.auth_method':{category:'rsa',description:'This key is used to capture authentication methods used only',name:'rsa.identity.auth_method',type:'keyword'},'rsa.identity.user_role':{category:'rsa',description:'This key is used to capture the Role of a user only',name:'rsa.identity.user_role',type:'keyword'},'rsa.identity.dn':{category:'rsa',description:'X.500 (LDAP) Distinguished Name',name:'rsa.identity.dn',type:'keyword'},'rsa.identity.logon_type':{category:'rsa',description:'This key is used to capture the type of logon method used.',name:'rsa.identity.logon_type',type:'keyword'},'rsa.identity.profile':{category:'rsa',description:'This key is used to capture the user profile',name:'rsa.identity.profile',type:'keyword'},'rsa.identity.accesses':{category:'rsa',description:'This key is used to capture actual privileges used in accessing an object',name:'rsa.identity.accesses',type:'keyword'},'rsa.identity.realm':{category:'rsa',description:'Radius realm or similar grouping of accounts',name:'rsa.identity.realm',type:'keyword'},'rsa.identity.user_sid_dst':{category:'rsa',description:'This key captures Destination User Session ID',name:'rsa.identity.user_sid_dst',type:'keyword'},'rsa.identity.dn_src':{category:'rsa',description:'An X.500 (LDAP) Distinguished name that is used in a context that indicates a Source dn',name:'rsa.identity.dn_src',type:'keyword'},'rsa.identity.org':{category:'rsa',description:'This key captures the User organization',name:'rsa.identity.org',type:'keyword'},'rsa.identity.dn_dst':{category:'rsa',description:'An X.500 (LDAP) Distinguished name that used in a context that indicates a Destination dn',name:'rsa.identity.dn_dst',type:'keyword'},'rsa.identity.firstname':{category:'rsa',description:'This key is for First Names only, this is used for Healthcare predominantly to capture Patients information',name:'rsa.identity.firstname',type:'keyword'},'rsa.identity.lastname':{category:'rsa',description:'This key is for Last Names only, this is used for Healthcare predominantly to capture Patients information',name:'rsa.identity.lastname',type:'keyword'},'rsa.identity.user_dept':{category:'rsa',description:"User's Department Names only",name:'rsa.identity.user_dept',type:'keyword'},'rsa.identity.user_sid_src':{category:'rsa',description:'This key captures Source User Session ID',name:'rsa.identity.user_sid_src',type:'keyword'},'rsa.identity.federated_sp':{category:'rsa',description:'This key is the Federated Service Provider. This is the application requesting authentication.',name:'rsa.identity.federated_sp',type:'keyword'},'rsa.identity.federated_idp':{category:'rsa',description:'This key is the federated Identity Provider. This is the server providing the authentication.',name:'rsa.identity.federated_idp',type:'keyword'},'rsa.identity.logon_type_desc':{category:'rsa',description:"This key is used to capture the textual description of an integer logon type as stored in the meta key 'logon.type'.",name:'rsa.identity.logon_type_desc',type:'keyword'},'rsa.identity.middlename':{category:'rsa',description:'This key is for Middle Names only, this is used for Healthcare predominantly to capture Patients information',name:'rsa.identity.middlename',type:'keyword'},'rsa.identity.password':{category:'rsa',description:'This key is for Passwords seen in any session, plain text or encrypted',name:'rsa.identity.password',type:'keyword'},'rsa.identity.host_role':{category:'rsa',description:'This key should only be used to capture the role of a Host Machine',name:'rsa.identity.host_role',type:'keyword'},'rsa.identity.ldap':{category:'rsa',description:'This key is for Uninterpreted LDAP values. Ldap Values that don’t have a clear query or response context',name:'rsa.identity.ldap',type:'keyword'},'rsa.identity.ldap_query':{category:'rsa',description:'This key is the Search criteria from an LDAP search',name:'rsa.identity.ldap_query',type:'keyword'},'rsa.identity.ldap_response':{category:'rsa',description:'This key is to capture Results from an LDAP search',name:'rsa.identity.ldap_response',type:'keyword'},'rsa.identity.owner':{category:'rsa',description:'This is used to capture username the process or service is running as, the author of the task',name:'rsa.identity.owner',type:'keyword'},'rsa.identity.service_account':{category:'rsa',description:'This key is a windows specific key, used for capturing name of the account a service (referenced in the event) is running under. Legacy Usage',name:'rsa.identity.service_account',type:'keyword'},'rsa.email.email_dst':{category:'rsa',description:'This key is used to capture the Destination email address only, when the destination context is not clear use email',name:'rsa.email.email_dst',type:'keyword'},'rsa.email.email_src':{category:'rsa',description:'This key is used to capture the source email address only, when the source context is not clear use email',name:'rsa.email.email_src',type:'keyword'},'rsa.email.subject':{category:'rsa',description:'This key is used to capture the subject string from an Email only.',name:'rsa.email.subject',type:'keyword'},'rsa.email.email':{category:'rsa',description:'This key is used to capture a generic email address where the source or destination context is not clear',name:'rsa.email.email',type:'keyword'},'rsa.email.trans_from':{category:'rsa',description:'Deprecated key defined only in table map.',name:'rsa.email.trans_from',type:'keyword'},'rsa.email.trans_to':{category:'rsa',description:'Deprecated key defined only in table map.',name:'rsa.email.trans_to',type:'keyword'},'rsa.file.privilege':{category:'rsa',description:'Deprecated, use permissions',name:'rsa.file.privilege',type:'keyword'},'rsa.file.attachment':{category:'rsa',description:'This key captures the attachment file name',name:'rsa.file.attachment',type:'keyword'},'rsa.file.filesystem':{category:'rsa',name:'rsa.file.filesystem',type:'keyword'},'rsa.file.binary':{category:'rsa',description:'Deprecated key defined only in table map.',name:'rsa.file.binary',type:'keyword'},'rsa.file.filename_dst':{category:'rsa',description:'This is used to capture name of the file targeted by the action',name:'rsa.file.filename_dst',type:'keyword'},'rsa.file.filename_src':{category:'rsa',description:'This is used to capture name of the parent filename, the file which performed the action',name:'rsa.file.filename_src',type:'keyword'},'rsa.file.filename_tmp':{category:'rsa',name:'rsa.file.filename_tmp',type:'keyword'},'rsa.file.directory_dst':{category:'rsa',description:'<span>This key is used to capture the directory of the target process or file</span>',name:'rsa.file.directory_dst',type:'keyword'},'rsa.file.directory_src':{category:'rsa',description:'This key is used to capture the directory of the source process or file',name:'rsa.file.directory_src',type:'keyword'},'rsa.file.file_entropy':{category:'rsa',description:'This is used to capture entropy vale of a file',name:'rsa.file.file_entropy',type:'double'},'rsa.file.file_vendor':{category:'rsa',description:'This is used to capture Company name of file located in version_info',name:'rsa.file.file_vendor',type:'keyword'},'rsa.file.task_name':{category:'rsa',description:'This is used to capture name of the task',name:'rsa.file.task_name',type:'keyword'},'rsa.web.fqdn':{category:'rsa',description:'Fully Qualified Domain Names',name:'rsa.web.fqdn',type:'keyword'},'rsa.web.web_cookie':{category:'rsa',description:'This key is used to capture the Web cookies specifically.',name:'rsa.web.web_cookie',type:'keyword'},'rsa.web.alias_host':{category:'rsa',name:'rsa.web.alias_host',type:'keyword'},'rsa.web.reputation_num':{category:'rsa',description:'Reputation Number of an entity. Typically used for Web Domains',name:'rsa.web.reputation_num',type:'double'},'rsa.web.web_ref_domain':{category:'rsa',description:"Web referer's domain",name:'rsa.web.web_ref_domain',type:'keyword'},'rsa.web.web_ref_query':{category:'rsa',description:"This key captures Web referer's query portion of the URL",name:'rsa.web.web_ref_query',type:'keyword'},'rsa.web.remote_domain':{category:'rsa',name:'rsa.web.remote_domain',type:'keyword'},'rsa.web.web_ref_page':{category:'rsa',description:"This key captures Web referer's page information",name:'rsa.web.web_ref_page',type:'keyword'},'rsa.web.web_ref_root':{category:'rsa',description:"Web referer's root URL path",name:'rsa.web.web_ref_root',type:'keyword'},'rsa.web.cn_asn_dst':{category:'rsa',name:'rsa.web.cn_asn_dst',type:'keyword'},'rsa.web.cn_rpackets':{category:'rsa',name:'rsa.web.cn_rpackets',type:'keyword'},'rsa.web.urlpage':{category:'rsa',name:'rsa.web.urlpage',type:'keyword'},'rsa.web.urlroot':{category:'rsa',name:'rsa.web.urlroot',type:'keyword'},'rsa.web.p_url':{category:'rsa',name:'rsa.web.p_url',type:'keyword'},'rsa.web.p_user_agent':{category:'rsa',name:'rsa.web.p_user_agent',type:'keyword'},'rsa.web.p_web_cookie':{category:'rsa',name:'rsa.web.p_web_cookie',type:'keyword'},'rsa.web.p_web_method':{category:'rsa',name:'rsa.web.p_web_method',type:'keyword'},'rsa.web.p_web_referer':{category:'rsa',name:'rsa.web.p_web_referer',type:'keyword'},'rsa.web.web_extension_tmp':{category:'rsa',name:'rsa.web.web_extension_tmp',type:'keyword'},'rsa.web.web_page':{category:'rsa',name:'rsa.web.web_page',type:'keyword'},'rsa.threat.threat_category':{category:'rsa',description:'This key captures Threat Name/Threat Category/Categorization of alert',name:'rsa.threat.threat_category',type:'keyword'},'rsa.threat.threat_desc':{category:'rsa',description:'This key is used to capture the threat description from the session directly or inferred',name:'rsa.threat.threat_desc',type:'keyword'},'rsa.threat.alert':{category:'rsa',description:'This key is used to capture name of the alert',name:'rsa.threat.alert',type:'keyword'},'rsa.threat.threat_source':{category:'rsa',description:'This key is used to capture source of the threat',name:'rsa.threat.threat_source',type:'keyword'},'rsa.crypto.crypto':{category:'rsa',description:'This key is used to capture the Encryption Type or Encryption Key only',name:'rsa.crypto.crypto',type:'keyword'},'rsa.crypto.cipher_src':{category:'rsa',description:'This key is for Source (Client) Cipher',name:'rsa.crypto.cipher_src',type:'keyword'},'rsa.crypto.cert_subject':{category:'rsa',description:'This key is used to capture the Certificate organization only',name:'rsa.crypto.cert_subject',type:'keyword'},'rsa.crypto.peer':{category:'rsa',description:"This key is for Encryption peer's IP Address",name:'rsa.crypto.peer',type:'keyword'},'rsa.crypto.cipher_size_src':{category:'rsa',description:'This key captures Source (Client) Cipher Size',name:'rsa.crypto.cipher_size_src',type:'long'},'rsa.crypto.ike':{category:'rsa',description:'IKE negotiation phase.',name:'rsa.crypto.ike',type:'keyword'},'rsa.crypto.scheme':{category:'rsa',description:'This key captures the Encryption scheme used',name:'rsa.crypto.scheme',type:'keyword'},'rsa.crypto.peer_id':{category:'rsa',description:'This key is for Encryption peer’s identity',name:'rsa.crypto.peer_id',type:'keyword'},'rsa.crypto.sig_type':{category:'rsa',description:'This key captures the Signature Type',name:'rsa.crypto.sig_type',type:'keyword'},'rsa.crypto.cert_issuer':{category:'rsa',name:'rsa.crypto.cert_issuer',type:'keyword'},'rsa.crypto.cert_host_name':{category:'rsa',description:'Deprecated key defined only in table map.',name:'rsa.crypto.cert_host_name',type:'keyword'},'rsa.crypto.cert_error':{category:'rsa',description:'This key captures the Certificate Error String',name:'rsa.crypto.cert_error',type:'keyword'},'rsa.crypto.cipher_dst':{category:'rsa',description:'This key is for Destination (Server) Cipher',name:'rsa.crypto.cipher_dst',type:'keyword'},'rsa.crypto.cipher_size_dst':{category:'rsa',description:'This key captures Destination (Server) Cipher Size',name:'rsa.crypto.cipher_size_dst',type:'long'},'rsa.crypto.ssl_ver_src':{category:'rsa',description:'Deprecated, use version',name:'rsa.crypto.ssl_ver_src',type:'keyword'},'rsa.crypto.d_certauth':{category:'rsa',name:'rsa.crypto.d_certauth',type:'keyword'},'rsa.crypto.s_certauth':{category:'rsa',name:'rsa.crypto.s_certauth',type:'keyword'},'rsa.crypto.ike_cookie1':{category:'rsa',description:'ID of the negotiation — sent for ISAKMP Phase One',name:'rsa.crypto.ike_cookie1',type:'keyword'},'rsa.crypto.ike_cookie2':{category:'rsa',description:'ID of the negotiation — sent for ISAKMP Phase Two',name:'rsa.crypto.ike_cookie2',type:'keyword'},'rsa.crypto.cert_checksum':{category:'rsa',name:'rsa.crypto.cert_checksum',type:'keyword'},'rsa.crypto.cert_host_cat':{category:'rsa',description:'This key is used for the hostname category value of a certificate',name:'rsa.crypto.cert_host_cat',type:'keyword'},'rsa.crypto.cert_serial':{category:'rsa',description:'This key is used to capture the Certificate serial number only',name:'rsa.crypto.cert_serial',type:'keyword'},'rsa.crypto.cert_status':{category:'rsa',description:'This key captures Certificate validation status',name:'rsa.crypto.cert_status',type:'keyword'},'rsa.crypto.ssl_ver_dst':{category:'rsa',description:'Deprecated, use version',name:'rsa.crypto.ssl_ver_dst',type:'keyword'},'rsa.crypto.cert_keysize':{category:'rsa',name:'rsa.crypto.cert_keysize',type:'keyword'},'rsa.crypto.cert_username':{category:'rsa',name:'rsa.crypto.cert_username',type:'keyword'},'rsa.crypto.https_insact':{category:'rsa',name:'rsa.crypto.https_insact',type:'keyword'},'rsa.crypto.https_valid':{category:'rsa',name:'rsa.crypto.https_valid',type:'keyword'},'rsa.crypto.cert_ca':{category:'rsa',description:'This key is used to capture the Certificate signing authority only',name:'rsa.crypto.cert_ca',type:'keyword'},'rsa.crypto.cert_common':{category:'rsa',description:'This key is used to capture the Certificate common name only',name:'rsa.crypto.cert_common',type:'keyword'},'rsa.wireless.wlan_ssid':{category:'rsa',description:'This key is used to capture the ssid of a Wireless Session',name:'rsa.wireless.wlan_ssid',type:'keyword'},'rsa.wireless.access_point':{category:'rsa',description:'This key is used to capture the access point name.',name:'rsa.wireless.access_point',type:'keyword'},'rsa.wireless.wlan_channel':{category:'rsa',description:'This is used to capture the channel names',name:'rsa.wireless.wlan_channel',type:'long'},'rsa.wireless.wlan_name':{category:'rsa',description:'This key captures either WLAN number/name',name:'rsa.wireless.wlan_name',type:'keyword'},'rsa.storage.disk_volume':{category:'rsa',description:'A unique name assigned to logical units (volumes) within a physical disk',name:'rsa.storage.disk_volume',type:'keyword'},'rsa.storage.lun':{category:'rsa',description:'Logical Unit Number.This key is a very useful concept in Storage.',name:'rsa.storage.lun',type:'keyword'},'rsa.storage.pwwn':{category:'rsa',description:'This uniquely identifies a port on a HBA.',name:'rsa.storage.pwwn',type:'keyword'},'rsa.physical.org_dst':{category:'rsa',description:'This is used to capture the destination organization based on the GEOPIP Maxmind database.',name:'rsa.physical.org_dst',type:'keyword'},'rsa.physical.org_src':{category:'rsa',description:'This is used to capture the source organization based on the GEOPIP Maxmind database.',name:'rsa.physical.org_src',type:'keyword'},'rsa.healthcare.patient_fname':{category:'rsa',description:'This key is for First Names only, this is used for Healthcare predominantly to capture Patients information',name:'rsa.healthcare.patient_fname',type:'keyword'},'rsa.healthcare.patient_id':{category:'rsa',description:'This key captures the unique ID for a patient',name:'rsa.healthcare.patient_id',type:'keyword'},'rsa.healthcare.patient_lname':{category:'rsa',description:'This key is for Last Names only, this is used for Healthcare predominantly to capture Patients information',name:'rsa.healthcare.patient_lname',type:'keyword'},'rsa.healthcare.patient_mname':{category:'rsa',description:'This key is for Middle Names only, this is used for Healthcare predominantly to capture Patients information',name:'rsa.healthcare.patient_mname',type:'keyword'},'rsa.endpoint.host_state':{category:'rsa',description:'This key is used to capture the current state of the machine, such as <strong>blacklisted</strong>, <strong>infected</strong>, <strong>firewall disabled</strong> and so on',name:'rsa.endpoint.host_state',type:'keyword'},'rsa.endpoint.registry_key':{category:'rsa',description:'This key captures the path to the registry key',name:'rsa.endpoint.registry_key',type:'keyword'},'rsa.endpoint.registry_value':{category:'rsa',description:'This key captures values or decorators used within a registry entry',name:'rsa.endpoint.registry_value',type:'keyword'},'forcepoint.virus_id':{category:'forcepoint',description:'Virus ID ',name:'forcepoint.virus_id',type:'keyword'},'checkpoint.app_risk':{category:'checkpoint',description:'Application risk.',name:'checkpoint.app_risk',type:'keyword'},'checkpoint.app_severity':{category:'checkpoint',description:'Application threat severity.',name:'checkpoint.app_severity',type:'keyword'},'checkpoint.app_sig_id':{category:'checkpoint',description:'The signature ID which the application was detected by.',name:'checkpoint.app_sig_id',type:'keyword'},'checkpoint.auth_method':{category:'checkpoint',description:'Password authentication protocol used.',name:'checkpoint.auth_method',type:'keyword'},'checkpoint.category':{category:'checkpoint',description:'Category.',name:'checkpoint.category',type:'keyword'},'checkpoint.confidence_level':{category:'checkpoint',description:'Confidence level determined.',name:'checkpoint.confidence_level',type:'integer'},'checkpoint.connectivity_state':{category:'checkpoint',description:'Connectivity state.',name:'checkpoint.connectivity_state',type:'keyword'},'checkpoint.cookie':{category:'checkpoint',description:'IKE cookie.',name:'checkpoint.cookie',type:'keyword'},'checkpoint.dst_phone_number':{category:'checkpoint',description:'Destination IP-Phone.',name:'checkpoint.dst_phone_number',type:'keyword'},'checkpoint.email_control':{category:'checkpoint',description:'Engine name.',name:'checkpoint.email_control',type:'keyword'},'checkpoint.email_id':{category:'checkpoint',description:'Internal email ID.',name:'checkpoint.email_id',type:'keyword'},'checkpoint.email_recipients_num':{category:'checkpoint',description:'Number of recipients.',name:'checkpoint.email_recipients_num',type:'long'},'checkpoint.email_session_id':{category:'checkpoint',description:'Internal email session ID.',name:'checkpoint.email_session_id',type:'keyword'},'checkpoint.email_spool_id':{category:'checkpoint',description:'Internal email spool ID.',name:'checkpoint.email_spool_id',type:'keyword'},'checkpoint.email_subject':{category:'checkpoint',description:'Email subject.',name:'checkpoint.email_subject',type:'keyword'},'checkpoint.event_count':{category:'checkpoint',description:'Number of events associated with the log.',name:'checkpoint.event_count',type:'long'},'checkpoint.frequency':{category:'checkpoint',description:'Scan frequency.',name:'checkpoint.frequency',type:'keyword'},'checkpoint.icmp_type':{category:'checkpoint',description:'ICMP type.',name:'checkpoint.icmp_type',type:'long'},'checkpoint.icmp_code':{category:'checkpoint',description:'ICMP code.',name:'checkpoint.icmp_code',type:'long'},'checkpoint.identity_type':{category:'checkpoint',description:'Identity type.',name:'checkpoint.identity_type',type:'keyword'},'checkpoint.incident_extension':{category:'checkpoint',description:'Format of original data.',name:'checkpoint.incident_extension',type:'keyword'},'checkpoint.integrity_av_invoke_type':{category:'checkpoint',description:'Scan invoke type.',name:'checkpoint.integrity_av_invoke_type',type:'keyword'},'checkpoint.malware_family':{category:'checkpoint',description:'Malware family.',name:'checkpoint.malware_family',type:'keyword'},'checkpoint.peer_gateway':{category:'checkpoint',description:'Main IP of the peer Security Gateway.',name:'checkpoint.peer_gateway',type:'ip'},'checkpoint.performance_impact':{category:'checkpoint',description:'Protection performance impact.',name:'checkpoint.performance_impact',type:'integer'},'checkpoint.protection_id':{category:'checkpoint',description:'Protection malware ID.',name:'checkpoint.protection_id',type:'keyword'},'checkpoint.protection_name':{category:'checkpoint',description:'Specific signature name of the attack.',name:'checkpoint.protection_name',type:'keyword'},'checkpoint.protection_type':{category:'checkpoint',description:'Type of protection used to detect the attack.',name:'checkpoint.protection_type',type:'keyword'},'checkpoint.scan_result':{category:'checkpoint',description:'Scan result.',name:'checkpoint.scan_result',type:'keyword'},'checkpoint.sensor_mode':{category:'checkpoint',description:'Sensor mode.',name:'checkpoint.sensor_mode',type:'keyword'},'checkpoint.severity':{category:'checkpoint',description:'Threat severity.',name:'checkpoint.severity',type:'keyword'},'checkpoint.spyware_name':{category:'checkpoint',description:'Spyware name.',name:'checkpoint.spyware_name',type:'keyword'},'checkpoint.spyware_status':{category:'checkpoint',description:'Spyware status.',name:'checkpoint.spyware_status',type:'keyword'},'checkpoint.subs_exp':{category:'checkpoint',description:'The expiration date of the subscription.',name:'checkpoint.subs_exp',type:'date'},'checkpoint.tcp_flags':{category:'checkpoint',description:'TCP packet flags.',name:'checkpoint.tcp_flags',type:'keyword'},'checkpoint.termination_reason':{category:'checkpoint',description:'Termination reason.',name:'checkpoint.termination_reason',type:'keyword'},'checkpoint.update_status':{category:'checkpoint',description:'Update status.',name:'checkpoint.update_status',type:'keyword'},'checkpoint.user_status':{category:'checkpoint',description:'User response.',name:'checkpoint.user_status',type:'keyword'},'checkpoint.uuid':{category:'checkpoint',description:'External ID.',name:'checkpoint.uuid',type:'keyword'},'checkpoint.virus_name':{category:'checkpoint',description:'Virus name.',name:'checkpoint.virus_name',type:'keyword'},'checkpoint.voip_log_type':{category:'checkpoint',description:'VoIP log types.',name:'checkpoint.voip_log_type',type:'keyword'},'cef.extensions.cp_app_risk':{category:'cef',name:'cef.extensions.cp_app_risk',type:'keyword'},'cef.extensions.cp_severity':{category:'cef',name:'cef.extensions.cp_severity',type:'keyword'},'cef.extensions.ifname':{category:'cef',name:'cef.extensions.ifname',type:'keyword'},'cef.extensions.inzone':{category:'cef',name:'cef.extensions.inzone',type:'keyword'},'cef.extensions.layer_uuid':{category:'cef',name:'cef.extensions.layer_uuid',type:'keyword'},'cef.extensions.layer_name':{category:'cef',name:'cef.extensions.layer_name',type:'keyword'},'cef.extensions.logid':{category:'cef',name:'cef.extensions.logid',type:'keyword'},'cef.extensions.loguid':{category:'cef',name:'cef.extensions.loguid',type:'keyword'},'cef.extensions.match_id':{category:'cef',name:'cef.extensions.match_id',type:'keyword'},'cef.extensions.nat_addtnl_rulenum':{category:'cef',name:'cef.extensions.nat_addtnl_rulenum',type:'keyword'},'cef.extensions.nat_rulenum':{category:'cef',name:'cef.extensions.nat_rulenum',type:'keyword'},'cef.extensions.origin':{category:'cef',name:'cef.extensions.origin',type:'keyword'},'cef.extensions.originsicname':{category:'cef',name:'cef.extensions.originsicname',type:'keyword'},'cef.extensions.outzone':{category:'cef',name:'cef.extensions.outzone',type:'keyword'},'cef.extensions.parent_rule':{category:'cef',name:'cef.extensions.parent_rule',type:'keyword'},'cef.extensions.product':{category:'cef',name:'cef.extensions.product',type:'keyword'},'cef.extensions.rule_action':{category:'cef',name:'cef.extensions.rule_action',type:'keyword'},'cef.extensions.rule_uid':{category:'cef',name:'cef.extensions.rule_uid',type:'keyword'},'cef.extensions.sequencenum':{category:'cef',name:'cef.extensions.sequencenum',type:'keyword'},'cef.extensions.service_id':{category:'cef',name:'cef.extensions.service_id',type:'keyword'},'cef.extensions.version':{category:'cef',name:'cef.extensions.version',type:'keyword'},'checkpoint.calc_desc':{category:'checkpoint',description:'Log description. ',name:'checkpoint.calc_desc',type:'keyword'},'checkpoint.dst_country':{category:'checkpoint',description:'Destination country. ',name:'checkpoint.dst_country',type:'keyword'},'checkpoint.dst_user_name':{category:'checkpoint',description:'Connected user name on the destination IP. ',name:'checkpoint.dst_user_name',type:'keyword'},'checkpoint.sys_message':{category:'checkpoint',description:'System messages ',name:'checkpoint.sys_message',type:'keyword'},'checkpoint.logid':{category:'checkpoint',description:'System messages ',name:'checkpoint.logid',type:'keyword'},'checkpoint.failure_impact':{category:'checkpoint',description:'The impact of update service failure. ',name:'checkpoint.failure_impact',type:'keyword'},'checkpoint.id':{category:'checkpoint',description:'Override application ID. ',name:'checkpoint.id',type:'integer'},'checkpoint.information':{category:'checkpoint',description:'Policy installation status for a specific blade. ',name:'checkpoint.information',type:'keyword'},'checkpoint.layer_name':{category:'checkpoint',description:'Layer name. ',name:'checkpoint.layer_name',type:'keyword'},'checkpoint.layer_uuid':{category:'checkpoint',description:'Layer UUID. ',name:'checkpoint.layer_uuid',type:'keyword'},'checkpoint.log_id':{category:'checkpoint',description:'Unique identity for logs. ',name:'checkpoint.log_id',type:'integer'},'checkpoint.origin_sic_name':{category:'checkpoint',description:'Machine SIC. ',name:'checkpoint.origin_sic_name',type:'keyword'},'checkpoint.policy_mgmt':{category:'checkpoint',description:'Name of the Management Server that manages this Security Gateway. ',name:'checkpoint.policy_mgmt',type:'keyword'},'checkpoint.policy_name':{category:'checkpoint',description:'Name of the last policy that this Security Gateway fetched. ',name:'checkpoint.policy_name',type:'keyword'},'checkpoint.protocol':{category:'checkpoint',description:'Protocol detected on the connection. ',name:'checkpoint.protocol',type:'keyword'},'checkpoint.proxy_src_ip':{category:'checkpoint',description:'Sender source IP (even when using proxy). ',name:'checkpoint.proxy_src_ip',type:'ip'},'checkpoint.rule':{category:'checkpoint',description:'Matched rule number. ',name:'checkpoint.rule',type:'integer'},'checkpoint.rule_action':{category:'checkpoint',description:'Action of the matched rule in the access policy. ',name:'checkpoint.rule_action',type:'keyword'},'checkpoint.scan_direction':{category:'checkpoint',description:'Scan direction. ',name:'checkpoint.scan_direction',type:'keyword'},'checkpoint.session_id':{category:'checkpoint',description:'Log uuid. ',name:'checkpoint.session_id',type:'keyword'},'checkpoint.source_os':{category:'checkpoint',description:'OS which generated the attack. ',name:'checkpoint.source_os',type:'keyword'},'checkpoint.src_country':{category:'checkpoint',description:'Country name, derived from connection source IP address. ',name:'checkpoint.src_country',type:'keyword'},'checkpoint.src_user_name':{category:'checkpoint',description:'User name connected to source IP ',name:'checkpoint.src_user_name',type:'keyword'},'checkpoint.ticket_id':{category:'checkpoint',description:'Unique ID per file. ',name:'checkpoint.ticket_id',type:'keyword'},'checkpoint.tls_server_host_name':{category:'checkpoint',description:'SNI/CN from encrypted TLS connection used by URLF for categorization. ',name:'checkpoint.tls_server_host_name',type:'keyword'},'checkpoint.verdict':{category:'checkpoint',description:'TE engine verdict Possible values: Malicious/Benign/Error. ',name:'checkpoint.verdict',type:'keyword'},'checkpoint.user':{category:'checkpoint',description:'Source user name. ',name:'checkpoint.user',type:'keyword'},'checkpoint.vendor_list':{category:'checkpoint',description:'The vendor name that provided the verdict for a malicious URL. ',name:'checkpoint.vendor_list',type:'keyword'},'checkpoint.web_server_type':{category:'checkpoint',description:'Web server detected in the HTTP response. ',name:'checkpoint.web_server_type',type:'keyword'},'checkpoint.client_name':{category:'checkpoint',description:'Client Application or Software Blade that detected the event. ',name:'checkpoint.client_name',type:'keyword'},'checkpoint.client_version':{category:'checkpoint',description:'Build version of SandBlast Agent client installed on the computer. ',name:'checkpoint.client_version',type:'keyword'},'checkpoint.extension_version':{category:'checkpoint',description:'Build version of the SandBlast Agent browser extension. ',name:'checkpoint.extension_version',type:'keyword'},'checkpoint.host_time':{category:'checkpoint',description:'Local time on the endpoint computer. ',name:'checkpoint.host_time',type:'keyword'},'checkpoint.installed_products':{category:'checkpoint',description:'List of installed Endpoint Software Blades. ',name:'checkpoint.installed_products',type:'keyword'},'checkpoint.cc':{category:'checkpoint',description:'The Carbon Copy address of the email. ',name:'checkpoint.cc',type:'keyword'},'checkpoint.parent_process_username':{category:'checkpoint',description:'Owner username of the parent process of the process that triggered the attack. ',name:'checkpoint.parent_process_username',type:'keyword'},'checkpoint.process_username':{category:'checkpoint',description:'Owner username of the process that triggered the attack. ',name:'checkpoint.process_username',type:'keyword'},'checkpoint.audit_status':{category:'checkpoint',description:'Audit Status. Can be Success or Failure. ',name:'checkpoint.audit_status',type:'keyword'},'checkpoint.objecttable':{category:'checkpoint',description:'Table of affected objects. ',name:'checkpoint.objecttable',type:'keyword'},'checkpoint.objecttype':{category:'checkpoint',description:'The type of the affected object. ',name:'checkpoint.objecttype',type:'keyword'},'checkpoint.operation_number':{category:'checkpoint',description:'The operation nuber. ',name:'checkpoint.operation_number',type:'keyword'},'checkpoint.suppressed_logs':{category:'checkpoint',description:'Aggregated connections for five minutes on the same source, destination and port. ',name:'checkpoint.suppressed_logs',type:'integer'},'checkpoint.blade_name':{category:'checkpoint',description:'Blade name. ',name:'checkpoint.blade_name',type:'keyword'},'checkpoint.status':{category:'checkpoint',description:'Ok/Warning/Error. ',name:'checkpoint.status',type:'keyword'},'checkpoint.short_desc':{category:'checkpoint',description:'Short description of the process that was executed. ',name:'checkpoint.short_desc',type:'keyword'},'checkpoint.long_desc':{category:'checkpoint',description:'More information on the process (usually describing error reason in failure). ',name:'checkpoint.long_desc',type:'keyword'},'checkpoint.scan_hosts_hour':{category:'checkpoint',description:'Number of unique hosts during the last hour. ',name:'checkpoint.scan_hosts_hour',type:'integer'},'checkpoint.scan_hosts_day':{category:'checkpoint',description:'Number of unique hosts during the last day. ',name:'checkpoint.scan_hosts_day',type:'integer'},'checkpoint.scan_hosts_week':{category:'checkpoint',description:'Number of unique hosts during the last week. ',name:'checkpoint.scan_hosts_week',type:'integer'},'checkpoint.unique_detected_hour':{category:'checkpoint',description:'Detected virus for a specific host during the last hour. ',name:'checkpoint.unique_detected_hour',type:'integer'},'checkpoint.unique_detected_day':{category:'checkpoint',description:'Detected virus for a specific host during the last day. ',name:'checkpoint.unique_detected_day',type:'integer'},'checkpoint.unique_detected_week':{category:'checkpoint',description:'Detected virus for a specific host during the last week. ',name:'checkpoint.unique_detected_week',type:'integer'},'checkpoint.scan_mail':{category:'checkpoint',description:'Number of emails that were scanned by "AB malicious activity" engine. ',name:'checkpoint.scan_mail',type:'integer'},'checkpoint.additional_ip':{category:'checkpoint',description:'DNS host name. ',name:'checkpoint.additional_ip',type:'keyword'},'checkpoint.description':{category:'checkpoint',description:'Additional explanation how the security gateway enforced the connection. ',name:'checkpoint.description',type:'keyword'},'checkpoint.email_spam_category':{category:'checkpoint',description:'Email categories. Possible values: spam/not spam/phishing. ',name:'checkpoint.email_spam_category',type:'keyword'},'checkpoint.email_control_analysis':{category:'checkpoint',description:'Message classification, received from spam vendor engine. ',name:'checkpoint.email_control_analysis',type:'keyword'},'checkpoint.scan_results':{category:'checkpoint',description:'"Infected"/description of a failure. ',name:'checkpoint.scan_results',type:'keyword'},'checkpoint.original_queue_id':{category:'checkpoint',description:'Original postfix email queue id. ',name:'checkpoint.original_queue_id',type:'keyword'},'checkpoint.risk':{category:'checkpoint',description:'Risk level we got from the engine. ',name:'checkpoint.risk',type:'keyword'},'checkpoint.observable_name':{category:'checkpoint',description:'IOC observable signature name. ',name:'checkpoint.observable_name',type:'keyword'},'checkpoint.observable_id':{category:'checkpoint',description:'IOC observable signature id. ',name:'checkpoint.observable_id',type:'keyword'},'checkpoint.observable_comment':{category:'checkpoint',description:'IOC observable signature description. ',name:'checkpoint.observable_comment',type:'keyword'},'checkpoint.indicator_name':{category:'checkpoint',description:'IOC indicator name. ',name:'checkpoint.indicator_name',type:'keyword'},'checkpoint.indicator_description':{category:'checkpoint',description:'IOC indicator description. ',name:'checkpoint.indicator_description',type:'keyword'},'checkpoint.indicator_reference':{category:'checkpoint',description:'IOC indicator reference. ',name:'checkpoint.indicator_reference',type:'keyword'},'checkpoint.indicator_uuid':{category:'checkpoint',description:'IOC indicator uuid. ',name:'checkpoint.indicator_uuid',type:'keyword'},'checkpoint.app_desc':{category:'checkpoint',description:'Application description. ',name:'checkpoint.app_desc',type:'keyword'},'checkpoint.app_id':{category:'checkpoint',description:'Application ID. ',name:'checkpoint.app_id',type:'integer'},'checkpoint.certificate_resource':{category:'checkpoint',description:'HTTPS resource Possible values: SNI or domain name (DN). ',name:'checkpoint.certificate_resource',type:'keyword'},'checkpoint.certificate_validation':{category:'checkpoint',description:'Precise error, describing HTTPS certificate failure under "HTTPS categorize websites" feature. ',name:'checkpoint.certificate_validation',type:'keyword'},'checkpoint.browse_time':{category:'checkpoint',description:'Application session browse time. ',name:'checkpoint.browse_time',type:'keyword'},'checkpoint.limit_requested':{category:'checkpoint',description:'Indicates whether data limit was requested for the session. ',name:'checkpoint.limit_requested',type:'integer'},'checkpoint.limit_applied':{category:'checkpoint',description:'Indicates whether the session was actually date limited. ',name:'checkpoint.limit_applied',type:'integer'},'checkpoint.dropped_total':{category:'checkpoint',description:'Amount of dropped packets (both incoming and outgoing). ',name:'checkpoint.dropped_total',type:'integer'},'checkpoint.client_type_os':{category:'checkpoint',description:'Client OS detected in the HTTP request. ',name:'checkpoint.client_type_os',type:'keyword'},'checkpoint.name':{category:'checkpoint',description:'Application name. ',name:'checkpoint.name',type:'keyword'},'checkpoint.properties':{category:'checkpoint',description:'Application categories. ',name:'checkpoint.properties',type:'keyword'},'checkpoint.sig_id':{category:'checkpoint',description:"Application's signature ID which how it was detected by. ",name:'checkpoint.sig_id',type:'keyword'},'checkpoint.desc':{category:'checkpoint',description:'Override application description. ',name:'checkpoint.desc',type:'keyword'},'checkpoint.referrer_self_uid':{category:'checkpoint',description:'UUID of the current log. ',name:'checkpoint.referrer_self_uid',type:'keyword'},'checkpoint.referrer_parent_uid':{category:'checkpoint',description:'Log UUID of the referring application. ',name:'checkpoint.referrer_parent_uid',type:'keyword'},'checkpoint.needs_browse_time':{category:'checkpoint',description:'Browse time required for the connection. ',name:'checkpoint.needs_browse_time',type:'integer'},'checkpoint.cluster_info':{category:'checkpoint',description:'Cluster information. Possible options: Failover reason/cluster state changes/CP cluster or 3rd party. ',name:'checkpoint.cluster_info',type:'keyword'},'checkpoint.sync':{category:'checkpoint',description:'Sync status and the reason (stable, at risk). ',name:'checkpoint.sync',type:'keyword'},'checkpoint.file_direction':{category:'checkpoint',description:'File direction. Possible options: upload/download. ',name:'checkpoint.file_direction',type:'keyword'},'checkpoint.invalid_file_size':{category:'checkpoint',description:'File_size field is valid only if this field is set to 0. ',name:'checkpoint.invalid_file_size',type:'integer'},'checkpoint.top_archive_file_name':{category:'checkpoint',description:'In case of archive file: the file that was sent/received. ',name:'checkpoint.top_archive_file_name',type:'keyword'},'checkpoint.data_type_name':{category:'checkpoint',description:'Data type in rulebase that was matched. ',name:'checkpoint.data_type_name',type:'keyword'},'checkpoint.specific_data_type_name':{category:'checkpoint',description:'Compound/Group scenario, data type that was matched. ',name:'checkpoint.specific_data_type_name',type:'keyword'},'checkpoint.word_list':{category:'checkpoint',description:'Words matched by data type. ',name:'checkpoint.word_list',type:'keyword'},'checkpoint.info':{category:'checkpoint',description:'Special log message. ',name:'checkpoint.info',type:'keyword'},'checkpoint.outgoing_url':{category:'checkpoint',description:'URL related to this log (for HTTP). ',name:'checkpoint.outgoing_url',type:'keyword'},'checkpoint.dlp_rule_name':{category:'checkpoint',description:'Matched rule name. ',name:'checkpoint.dlp_rule_name',type:'keyword'},'checkpoint.dlp_recipients':{category:'checkpoint',description:'Mail recipients. ',name:'checkpoint.dlp_recipients',type:'keyword'},'checkpoint.dlp_subject':{category:'checkpoint',description:'Mail subject. ',name:'checkpoint.dlp_subject',type:'keyword'},'checkpoint.dlp_word_list':{category:'checkpoint',description:'Phrases matched by data type. ',name:'checkpoint.dlp_word_list',type:'keyword'},'checkpoint.dlp_template_score':{category:'checkpoint',description:'Template data type match score. ',name:'checkpoint.dlp_template_score',type:'keyword'},'checkpoint.message_size':{category:'checkpoint',description:'Mail/post size. ',name:'checkpoint.message_size',type:'integer'},'checkpoint.dlp_incident_uid':{category:'checkpoint',description:'Unique ID of the matched rule. ',name:'checkpoint.dlp_incident_uid',type:'keyword'},'checkpoint.dlp_related_incident_uid':{category:'checkpoint',description:'Other ID related to this one. ',name:'checkpoint.dlp_related_incident_uid',type:'keyword'},'checkpoint.dlp_data_type_name':{category:'checkpoint',description:'Matched data type. ',name:'checkpoint.dlp_data_type_name',type:'keyword'},'checkpoint.dlp_data_type_uid':{category:'checkpoint',description:'Unique ID of the matched data type. ',name:'checkpoint.dlp_data_type_uid',type:'keyword'},'checkpoint.dlp_violation_description':{category:'checkpoint',description:'Violation descriptions described in the rulebase. ',name:'checkpoint.dlp_violation_description',type:'keyword'},'checkpoint.dlp_relevant_data_types':{category:'checkpoint',description:'In case of Compound/Group: the inner data types that were matched. ',name:'checkpoint.dlp_relevant_data_types',type:'keyword'},'checkpoint.dlp_action_reason':{category:'checkpoint',description:'Action chosen reason. ',name:'checkpoint.dlp_action_reason',type:'keyword'},'checkpoint.dlp_categories':{category:'checkpoint',description:'Data type category. ',name:'checkpoint.dlp_categories',type:'keyword'},'checkpoint.dlp_transint':{category:'checkpoint',description:'HTTP/SMTP/FTP. ',name:'checkpoint.dlp_transint',type:'keyword'},'checkpoint.duplicate':{category:'checkpoint',description:'Log marked as duplicated, when mail is split and the Security Gateway sees it twice. ',name:'checkpoint.duplicate',type:'keyword'},'checkpoint.matched_file':{category:'checkpoint',description:'Unique ID of the matched data type. ',name:'checkpoint.matched_file',type:'keyword'},'checkpoint.matched_file_text_segments':{category:'checkpoint',description:'Fingerprint: number of text segments matched by this traffic. ',name:'checkpoint.matched_file_text_segments',type:'integer'},'checkpoint.matched_file_percentage':{category:'checkpoint',description:'Fingerprint: match percentage of the traffic. ',name:'checkpoint.matched_file_percentage',type:'integer'},'checkpoint.dlp_additional_action':{category:'checkpoint',description:'Watermark/None. ',name:'checkpoint.dlp_additional_action',type:'keyword'},'checkpoint.dlp_watermark_profile':{category:'checkpoint',description:'Watermark which was applied. ',name:'checkpoint.dlp_watermark_profile',type:'keyword'},'checkpoint.dlp_repository_id':{category:'checkpoint',description:'ID of scanned repository. ',name:'checkpoint.dlp_repository_id',type:'keyword'},'checkpoint.dlp_repository_root_path':{category:'checkpoint',description:'Repository path. ',name:'checkpoint.dlp_repository_root_path',type:'keyword'},'checkpoint.scan_id':{category:'checkpoint',description:'Sequential number of scan. ',name:'checkpoint.scan_id',type:'keyword'},'checkpoint.special_properties':{category:'checkpoint',description:"If this field is set to '1' the log will not be shown (in use for monitoring scan progress). ",name:'checkpoint.special_properties',type:'integer'},'checkpoint.dlp_repository_total_size':{category:'checkpoint',description:'Repository size. ',name:'checkpoint.dlp_repository_total_size',type:'integer'},'checkpoint.dlp_repository_files_number':{category:'checkpoint',description:'Number of files in repository. ',name:'checkpoint.dlp_repository_files_number',type:'integer'},'checkpoint.dlp_repository_scanned_files_number':{category:'checkpoint',description:'Number of scanned files in repository. ',name:'checkpoint.dlp_repository_scanned_files_number',type:'integer'},'checkpoint.duration':{category:'checkpoint',description:'Scan duration.       ',name:'checkpoint.duration',type:'keyword'},'checkpoint.dlp_fingerprint_long_status':{category:'checkpoint',description:'Scan status - long format. ',name:'checkpoint.dlp_fingerprint_long_status',type:'keyword'},'checkpoint.dlp_fingerprint_short_status':{category:'checkpoint',description:'Scan status - short format. ',name:'checkpoint.dlp_fingerprint_short_status',type:'keyword'},'checkpoint.dlp_repository_directories_number':{category:'checkpoint',description:'Number of directories in repository. ',name:'checkpoint.dlp_repository_directories_number',type:'integer'},'checkpoint.dlp_repository_unreachable_directories_number':{category:'checkpoint',description:'Number of directories the Security Gateway was unable to read. ',name:'checkpoint.dlp_repository_unreachable_directories_number',type:'integer'},'checkpoint.dlp_fingerprint_files_number':{category:'checkpoint',description:'Number of successfully scanned files in repository. ',name:'checkpoint.dlp_fingerprint_files_number',type:'integer'},'checkpoint.dlp_repository_skipped_files_number':{category:'checkpoint',description:'Skipped number of files because of configuration. ',name:'checkpoint.dlp_repository_skipped_files_number',type:'integer'},'checkpoint.dlp_repository_scanned_directories_number':{category:'checkpoint',description:'Amount of directories scanned. ',name:'checkpoint.dlp_repository_scanned_directories_number',type:'integer'},'checkpoint.number_of_errors':{category:'checkpoint',description:'Number of files that were not  scanned due to an error. ',name:'checkpoint.number_of_errors',type:'integer'},'checkpoint.next_scheduled_scan_date':{category:'checkpoint',description:'Next scan scheduled time according to time object.      ',name:'checkpoint.next_scheduled_scan_date',type:'keyword'},'checkpoint.dlp_repository_scanned_total_size':{category:'checkpoint',description:'Size scanned. ',name:'checkpoint.dlp_repository_scanned_total_size',type:'integer'},'checkpoint.dlp_repository_reached_directories_number':{category:'checkpoint',description:'Number of scanned directories in repository. ',name:'checkpoint.dlp_repository_reached_directories_number',type:'integer'},'checkpoint.dlp_repository_not_scanned_directories_percentage':{category:'checkpoint',description:'Percentage of directories the Security Gateway was unable to read. ',name:'checkpoint.dlp_repository_not_scanned_directories_percentage',type:'integer'},'checkpoint.speed':{category:'checkpoint',description:'Current scan speed. ',name:'checkpoint.speed',type:'integer'},'checkpoint.dlp_repository_scan_progress':{category:'checkpoint',description:'Scan percentage. ',name:'checkpoint.dlp_repository_scan_progress',type:'integer'},'checkpoint.sub_policy_name':{category:'checkpoint',description:'Layer name. ',name:'checkpoint.sub_policy_name',type:'keyword'},'checkpoint.sub_policy_uid':{category:'checkpoint',description:'Layer uid. ',name:'checkpoint.sub_policy_uid',type:'keyword'},'checkpoint.fw_message':{category:'checkpoint',description:'Used for various firewall errors. ',name:'checkpoint.fw_message',type:'keyword'},'checkpoint.message':{category:'checkpoint',description:'ISP link has failed. ',name:'checkpoint.message',type:'keyword'},'checkpoint.isp_link':{category:'checkpoint',description:'Name of ISP link. ',name:'checkpoint.isp_link',type:'keyword'},'checkpoint.fw_subproduct':{category:'checkpoint',description:'Can be vpn/non vpn. ',name:'checkpoint.fw_subproduct',type:'keyword'},'checkpoint.sctp_error':{category:'checkpoint',description:'Error information, what caused sctp to fail on out_of_state. ',name:'checkpoint.sctp_error',type:'keyword'},'checkpoint.chunk_type':{category:'checkpoint',description:'Chunck of the sctp stream. ',name:'checkpoint.chunk_type',type:'keyword'},'checkpoint.sctp_association_state':{category:'checkpoint',description:'The bad state you were trying to update to. ',name:'checkpoint.sctp_association_state',type:'keyword'},'checkpoint.tcp_packet_out_of_state':{category:'checkpoint',description:'State violation. ',name:'checkpoint.tcp_packet_out_of_state',type:'keyword'},'checkpoint.connectivity_level':{category:'checkpoint',description:'Log for a new connection in wire mode. ',name:'checkpoint.connectivity_level',type:'keyword'},'checkpoint.ip_option':{category:'checkpoint',description:'IP option that was dropped. ',name:'checkpoint.ip_option',type:'integer'},'checkpoint.tcp_state':{category:'checkpoint',description:'Log reinting a tcp state change. ',name:'checkpoint.tcp_state',type:'keyword'},'checkpoint.expire_time':{category:'checkpoint',description:'Connection closing time. ',name:'checkpoint.expire_time',type:'keyword'},'checkpoint.rpc_prog':{category:'checkpoint',description:'Log for new RPC state - prog values. ',name:'checkpoint.rpc_prog',type:'integer'},'checkpoint.dce-rpc_interface_uuid':{category:'checkpoint',description:'Log for new RPC state - UUID values ',name:'checkpoint.dce-rpc_interface_uuid',type:'keyword'},'checkpoint.elapsed':{category:'checkpoint',description:'Time passed since start time. ',name:'checkpoint.elapsed',type:'keyword'},'checkpoint.icmp':{category:'checkpoint',description:'Number of packets, received by the client. ',name:'checkpoint.icmp',type:'keyword'},'checkpoint.capture_uuid':{category:'checkpoint',description:'UUID generated for the capture. Used when enabling the capture when logging. ',name:'checkpoint.capture_uuid',type:'keyword'},'checkpoint.diameter_app_ID':{category:'checkpoint',description:'The ID of diameter application. ',name:'checkpoint.diameter_app_ID',type:'integer'},'checkpoint.diameter_cmd_code':{category:'checkpoint',description:'Diameter not allowed application command id. ',name:'checkpoint.diameter_cmd_code',type:'integer'},'checkpoint.diameter_msg_type':{category:'checkpoint',description:'Diameter message type. ',name:'checkpoint.diameter_msg_type',type:'keyword'},'checkpoint.cp_message':{category:'checkpoint',description:'Used to log a general message. ',name:'checkpoint.cp_message',type:'integer'},'checkpoint.log_delay':{category:'checkpoint',description:'Time left before deleting template. ',name:'checkpoint.log_delay',type:'integer'},'checkpoint.attack_status':{category:'checkpoint',description:'In case of a malicious event on an endpoint computer, the status of the attack. ',name:'checkpoint.attack_status',type:'keyword'},'checkpoint.impacted_files':{category:'checkpoint',description:'In case of an infection on an endpoint computer, the list of files that the malware impacted. ',name:'checkpoint.impacted_files',type:'keyword'},'checkpoint.remediated_files':{category:'checkpoint',description:'In case of an infection and a successful cleaning of that infection, this is a list of remediated files on the computer. ',name:'checkpoint.remediated_files',type:'keyword'},'checkpoint.triggered_by':{category:'checkpoint',description:'The name of the mechanism that triggered the Software Blade to enforce a protection. ',name:'checkpoint.triggered_by',type:'keyword'},'checkpoint.https_inspection_rule_id':{category:'checkpoint',description:'ID of the matched rule. ',name:'checkpoint.https_inspection_rule_id',type:'keyword'},'checkpoint.https_inspection_rule_name':{category:'checkpoint',description:'Name of the matched rule. ',name:'checkpoint.https_inspection_rule_name',type:'keyword'},'checkpoint.app_properties':{category:'checkpoint',description:'List of all found categories. ',name:'checkpoint.app_properties',type:'keyword'},'checkpoint.https_validation':{category:'checkpoint',description:'Precise error, describing HTTPS inspection failure. ',name:'checkpoint.https_validation',type:'keyword'},'checkpoint.https_inspection_action':{category:'checkpoint',description:'HTTPS inspection action (Inspect/Bypass/Error). ',name:'checkpoint.https_inspection_action',type:'keyword'},'checkpoint.icap_service_id':{category:'checkpoint',description:'Service ID, can work with multiple servers, treated as services. ',name:'checkpoint.icap_service_id',type:'integer'},'checkpoint.icap_server_name':{category:'checkpoint',description:'Server name. ',name:'checkpoint.icap_server_name',type:'keyword'},'checkpoint.internal_error':{category:'checkpoint',description:'Internal error, for troubleshooting ',name:'checkpoint.internal_error',type:'keyword'},'checkpoint.icap_more_info':{category:'checkpoint',description:'Free text for verdict. ',name:'checkpoint.icap_more_info',type:'integer'},'checkpoint.reply_status':{category:'checkpoint',description:'ICAP reply status code, e.g. 200 or 204. ',name:'checkpoint.reply_status',type:'integer'},'checkpoint.icap_server_service':{category:'checkpoint',description:'Service name, as given in the ICAP URI ',name:'checkpoint.icap_server_service',type:'keyword'},'checkpoint.mirror_and_decrypt_type':{category:'checkpoint',description:'Information about decrypt and forward. Possible values: Mirror only, Decrypt and mirror, Partial mirroring (HTTPS inspection Bypass). ',name:'checkpoint.mirror_and_decrypt_type',type:'keyword'},'checkpoint.interface_name':{category:'checkpoint',description:'Designated interface for mirror And decrypt. ',name:'checkpoint.interface_name',type:'keyword'},'checkpoint.session_uid':{category:'checkpoint',description:'HTTP session-id. ',name:'checkpoint.session_uid',type:'keyword'},'checkpoint.broker_publisher':{category:'checkpoint',description:'IP address of the broker publisher who shared the session information. ',name:'checkpoint.broker_publisher',type:'ip'},'checkpoint.src_user_dn':{category:'checkpoint',description:'User distinguished name connected to source IP. ',name:'checkpoint.src_user_dn',type:'keyword'},'checkpoint.proxy_user_name':{category:'checkpoint',description:'User name connected to proxy IP. ',name:'checkpoint.proxy_user_name',type:'keyword'},'checkpoint.proxy_machine_name':{category:'checkpoint',description:'Machine name connected to proxy IP. ',name:'checkpoint.proxy_machine_name',type:'integer'},'checkpoint.proxy_user_dn':{category:'checkpoint',description:'User distinguished name connected to proxy IP. ',name:'checkpoint.proxy_user_dn',type:'keyword'},'checkpoint.query':{category:'checkpoint',description:'DNS query. ',name:'checkpoint.query',type:'keyword'},'checkpoint.dns_query':{category:'checkpoint',description:'DNS query. ',name:'checkpoint.dns_query',type:'keyword'},'checkpoint.inspection_item':{category:'checkpoint',description:'Blade element performed inspection. ',name:'checkpoint.inspection_item',type:'keyword'},'checkpoint.inspection_category':{category:'checkpoint',description:'Inspection category: protocol anomaly, signature etc. ',name:'checkpoint.inspection_category',type:'keyword'},'checkpoint.inspection_profile':{category:'checkpoint',description:'Profile which the activated protection belongs to. ',name:'checkpoint.inspection_profile',type:'keyword'},'checkpoint.summary':{category:'checkpoint',description:'Summary message of a non-compliant DNS traffic drops or detects. ',name:'checkpoint.summary',type:'keyword'},'checkpoint.question_rdata':{category:'checkpoint',description:'List of question records domains. ',name:'checkpoint.question_rdata',type:'keyword'},'checkpoint.answer_rdata':{category:'checkpoint',description:'List of answer resource records to the questioned domains. ',name:'checkpoint.answer_rdata',type:'keyword'},'checkpoint.authority_rdata':{category:'checkpoint',description:'List of authoritative servers. ',name:'checkpoint.authority_rdata',type:'keyword'},'checkpoint.additional_rdata':{category:'checkpoint',description:'List of additional resource records. ',name:'checkpoint.additional_rdata',type:'keyword'},'checkpoint.files_names':{category:'checkpoint',description:'List of files requested by FTP. ',name:'checkpoint.files_names',type:'keyword'},'checkpoint.ftp_user':{category:'checkpoint',description:'FTP username. ',name:'checkpoint.ftp_user',type:'keyword'},'checkpoint.mime_from':{category:'checkpoint',description:"Sender's address. ",name:'checkpoint.mime_from',type:'keyword'},'checkpoint.mime_to':{category:'checkpoint',description:'List of receiver address. ',name:'checkpoint.mime_to',type:'keyword'},'checkpoint.bcc':{category:'checkpoint',description:'List of BCC addresses. ',name:'checkpoint.bcc',type:'keyword'},'checkpoint.content_type':{category:'checkpoint',description:'Mail content type. Possible values: application/msword, text/html, image/gif etc. ',name:'checkpoint.content_type',type:'keyword'},'checkpoint.user_agent':{category:'checkpoint',description:'String identifying requesting software user agent. ',name:'checkpoint.user_agent',type:'keyword'},'checkpoint.referrer':{category:'checkpoint',description:'Referrer HTTP request header, previous web page address. ',name:'checkpoint.referrer',type:'keyword'},'checkpoint.http_location':{category:'checkpoint',description:'Response header, indicates the URL to redirect a page to. ',name:'checkpoint.http_location',type:'keyword'},'checkpoint.content_disposition':{category:'checkpoint',description:'Indicates how the content is expected to be displayed inline in the browser. ',name:'checkpoint.content_disposition',type:'keyword'},'checkpoint.via':{category:'checkpoint',description:'Via header is added by proxies for tracking purposes to avoid sending reqests in loop. ',name:'checkpoint.via',type:'keyword'},'checkpoint.http_server':{category:'checkpoint',description:'Server HTTP header value, contains information about the software used by the origin server, which handles the request. ',name:'checkpoint.http_server',type:'keyword'},'checkpoint.content_length':{category:'checkpoint',description:'Indicates the size of the entity-body of the HTTP header. ',name:'checkpoint.content_length',type:'keyword'},'checkpoint.authorization':{category:'checkpoint',description:'Authorization HTTP header value. ',name:'checkpoint.authorization',type:'keyword'},'checkpoint.http_host':{category:'checkpoint',description:'Domain name of the server that the HTTP request is sent to. ',name:'checkpoint.http_host',type:'keyword'},'checkpoint.inspection_settings_log':{category:'checkpoint',description:'Indicats that the log was released by inspection settings. ',name:'checkpoint.inspection_settings_log',type:'keyword'},'checkpoint.cvpn_resource':{category:'checkpoint',description:'Mobile Access application. ',name:'checkpoint.cvpn_resource',type:'keyword'},'checkpoint.cvpn_category':{category:'checkpoint',description:'Mobile Access application type. ',name:'checkpoint.cvpn_category',type:'keyword'},'checkpoint.url':{category:'checkpoint',description:'Translated URL. ',name:'checkpoint.url',type:'keyword'},'checkpoint.reject_id':{category:'checkpoint',description:'A reject ID that corresponds to the one presented in the Mobile Access error page. ',name:'checkpoint.reject_id',type:'keyword'},'checkpoint.fs-proto':{category:'checkpoint',description:'The file share protocol used in mobile acess file share application. ',name:'checkpoint.fs-proto',type:'keyword'},'checkpoint.app_package':{category:'checkpoint',description:'Unique identifier of the application on the protected mobile device. ',name:'checkpoint.app_package',type:'keyword'},'checkpoint.appi_name':{category:'checkpoint',description:'Name of application downloaded on the protected mobile device. ',name:'checkpoint.appi_name',type:'keyword'},'checkpoint.app_repackaged':{category:'checkpoint',description:'Indicates whether the original application was repackage not by the official developer. ',name:'checkpoint.app_repackaged',type:'keyword'},'checkpoint.app_sid_id':{category:'checkpoint',description:'Unique SHA identifier of a mobile application. ',name:'checkpoint.app_sid_id',type:'keyword'},'checkpoint.app_version':{category:'checkpoint',description:'Version of the application downloaded on the protected mobile device. ',name:'checkpoint.app_version',type:'keyword'},'checkpoint.developer_certificate_name':{category:'checkpoint',description:"Name of the developer's certificate that was used to sign the mobile application. ",name:'checkpoint.developer_certificate_name',type:'keyword'},'checkpoint.email_message_id':{category:'checkpoint',description:'Email session id (uniqe ID of the mail). ',name:'checkpoint.email_message_id',type:'keyword'},'checkpoint.email_queue_id':{category:'checkpoint',description:'Postfix email queue id. ',name:'checkpoint.email_queue_id',type:'keyword'},'checkpoint.email_queue_name':{category:'checkpoint',description:'Postfix email queue name. ',name:'checkpoint.email_queue_name',type:'keyword'},'checkpoint.file_name':{category:'checkpoint',description:'Malicious file name. ',name:'checkpoint.file_name',type:'keyword'},'checkpoint.failure_reason':{category:'checkpoint',description:'MTA failure description. ',name:'checkpoint.failure_reason',type:'keyword'},'checkpoint.email_headers':{category:'checkpoint',description:'String containing all the email headers. ',name:'checkpoint.email_headers',type:'keyword'},'checkpoint.arrival_time':{category:'checkpoint',description:'Email arrival timestamp. ',name:'checkpoint.arrival_time',type:'keyword'},'checkpoint.email_status':{category:'checkpoint',description:"Describes the email's state. Possible options: delivered, deferred, skipped, bounced, hold, new, scan_started, scan_ended ",name:'checkpoint.email_status',type:'keyword'},'checkpoint.status_update':{category:'checkpoint',description:'Last time log was updated. ',name:'checkpoint.status_update',type:'keyword'},'checkpoint.delivery_time':{category:'checkpoint',description:'Timestamp of when email was delivered (MTA finished handling the email. ',name:'checkpoint.delivery_time',type:'keyword'},'checkpoint.links_num':{category:'checkpoint',description:'Number of links in the mail. ',name:'checkpoint.links_num',type:'integer'},'checkpoint.attachments_num':{category:'checkpoint',description:'Number of attachments in the mail. ',name:'checkpoint.attachments_num',type:'integer'},'checkpoint.email_content':{category:'checkpoint',description:'Mail contents. Possible options: attachments/links & attachments/links/text only. ',name:'checkpoint.email_content',type:'keyword'},'checkpoint.allocated_ports':{category:'checkpoint',description:'Amount of allocated ports. ',name:'checkpoint.allocated_ports',type:'integer'},'checkpoint.capacity':{category:'checkpoint',description:'Capacity of the ports. ',name:'checkpoint.capacity',type:'integer'},'checkpoint.ports_usage':{category:'checkpoint',description:'Percentage of allocated ports. ',name:'checkpoint.ports_usage',type:'integer'},'checkpoint.nat_exhausted_pool':{category:'checkpoint',description:'4-tuple of an exhausted pool. ',name:'checkpoint.nat_exhausted_pool',type:'keyword'},'checkpoint.nat_rulenum':{category:'checkpoint',description:'NAT rulebase first matched rule. ',name:'checkpoint.nat_rulenum',type:'integer'},'checkpoint.nat_addtnl_rulenum':{category:'checkpoint',description:'When matching 2 automatic rules , second rule match will be shown otherwise field will be 0. ',name:'checkpoint.nat_addtnl_rulenum',type:'integer'},'checkpoint.message_info':{category:'checkpoint',description:'Used for information messages, for example:NAT connection has ended. ',name:'checkpoint.message_info',type:'keyword'},'checkpoint.nat46':{category:'checkpoint',description:'NAT 46 status, in most cases "enabled". ',name:'checkpoint.nat46',type:'keyword'},'checkpoint.end_time':{category:'checkpoint',description:'TCP connection end time. ',name:'checkpoint.end_time',type:'keyword'},'checkpoint.tcp_end_reason':{category:'checkpoint',description:'Reason for TCP connection closure. ',name:'checkpoint.tcp_end_reason',type:'keyword'},'checkpoint.cgnet':{category:'checkpoint',description:'Describes NAT allocation for specific subscriber. ',name:'checkpoint.cgnet',type:'keyword'},'checkpoint.subscriber':{category:'checkpoint',description:'Source IP before CGNAT. ',name:'checkpoint.subscriber',type:'ip'},'checkpoint.hide_ip':{category:'checkpoint',description:'Source IP which will be used after CGNAT. ',name:'checkpoint.hide_ip',type:'ip'},'checkpoint.int_start':{category:'checkpoint',description:'Subscriber start int which will be used for NAT. ',name:'checkpoint.int_start',type:'integer'},'checkpoint.int_end':{category:'checkpoint',description:'Subscriber end int which will be used for NAT. ',name:'checkpoint.int_end',type:'integer'},'checkpoint.packet_amount':{category:'checkpoint',description:'Amount of packets dropped. ',name:'checkpoint.packet_amount',type:'integer'},'checkpoint.monitor_reason':{category:'checkpoint',description:'Aggregated logs of monitored packets. ',name:'checkpoint.monitor_reason',type:'keyword'},'checkpoint.drops_amount':{category:'checkpoint',description:'Amount of multicast packets dropped. ',name:'checkpoint.drops_amount',type:'integer'},'checkpoint.securexl_message':{category:'checkpoint',description:'Two options for a SecureXL message: 1. Missed accounting records after heavy load on logging system. 2. FW log message regarding a packet drop. ',name:'checkpoint.securexl_message',type:'keyword'},'checkpoint.conns_amount':{category:'checkpoint',description:'Connections amount of aggregated log info. ',name:'checkpoint.conns_amount',type:'integer'},'checkpoint.scope':{category:'checkpoint',description:'IP related to the attack. ',name:'checkpoint.scope',type:'keyword'},'checkpoint.analyzed_on':{category:'checkpoint',description:'Check Point ThreatCloud / emulator name. ',name:'checkpoint.analyzed_on',type:'keyword'},'checkpoint.detected_on':{category:'checkpoint',description:'System and applications version the file was emulated on. ',name:'checkpoint.detected_on',type:'keyword'},'checkpoint.dropped_file_name':{category:'checkpoint',description:'List of names dropped from the original file. ',name:'checkpoint.dropped_file_name',type:'keyword'},'checkpoint.dropped_file_type':{category:'checkpoint',description:'List of file types dropped from the original file. ',name:'checkpoint.dropped_file_type',type:'keyword'},'checkpoint.dropped_file_hash':{category:'checkpoint',description:'List of file hashes dropped from the original file. ',name:'checkpoint.dropped_file_hash',type:'keyword'},'checkpoint.dropped_file_verdict':{category:'checkpoint',description:'List of file verdics dropped from the original file. ',name:'checkpoint.dropped_file_verdict',type:'keyword'},'checkpoint.emulated_on':{category:'checkpoint',description:'Images the files were emulated on. ',name:'checkpoint.emulated_on',type:'keyword'},'checkpoint.extracted_file_type':{category:'checkpoint',description:'Types of extracted files in case of an archive. ',name:'checkpoint.extracted_file_type',type:'keyword'},'checkpoint.extracted_file_names':{category:'checkpoint',description:'Names of extracted files in case of an archive. ',name:'checkpoint.extracted_file_names',type:'keyword'},'checkpoint.extracted_file_hash':{category:'checkpoint',description:'Archive hash in case of extracted files. ',name:'checkpoint.extracted_file_hash',type:'keyword'},'checkpoint.extracted_file_verdict':{category:'checkpoint',description:'Verdict of extracted files in case of an archive. ',name:'checkpoint.extracted_file_verdict',type:'keyword'},'checkpoint.extracted_file_uid':{category:'checkpoint',description:'UID of extracted files in case of an archive. ',name:'checkpoint.extracted_file_uid',type:'keyword'},'checkpoint.mitre_initial_access':{category:'checkpoint',description:'The adversary is trying to break into your network. ',name:'checkpoint.mitre_initial_access',type:'keyword'},'checkpoint.mitre_execution':{category:'checkpoint',description:'The adversary is trying to run malicious code. ',name:'checkpoint.mitre_execution',type:'keyword'},'checkpoint.mitre_persistence':{category:'checkpoint',description:'The adversary is trying to maintain his foothold. ',name:'checkpoint.mitre_persistence',type:'keyword'},'checkpoint.mitre_privilege_escalation':{category:'checkpoint',description:'The adversary is trying to gain higher-level permissions. ',name:'checkpoint.mitre_privilege_escalation',type:'keyword'},'checkpoint.mitre_defense_evasion':{category:'checkpoint',description:'The adversary is trying to avoid being detected. ',name:'checkpoint.mitre_defense_evasion',type:'keyword'},'checkpoint.mitre_credential_access':{category:'checkpoint',description:'The adversary is trying to steal account names and passwords. ',name:'checkpoint.mitre_credential_access',type:'keyword'},'checkpoint.mitre_discovery':{category:'checkpoint',description:'The adversary is trying to expose information about your environment. ',name:'checkpoint.mitre_discovery',type:'keyword'},'checkpoint.mitre_lateral_movement':{category:'checkpoint',description:'The adversary is trying to explore your environment. ',name:'checkpoint.mitre_lateral_movement',type:'keyword'},'checkpoint.mitre_collection':{category:'checkpoint',description:'The adversary is trying to collect data of interest to achieve his goal. ',name:'checkpoint.mitre_collection',type:'keyword'},'checkpoint.mitre_command_and_control':{category:'checkpoint',description:'The adversary is trying to communicate with compromised systems in order to control them. ',name:'checkpoint.mitre_command_and_control',type:'keyword'},'checkpoint.mitre_exfiltration':{category:'checkpoint',description:'The adversary is trying to steal data. ',name:'checkpoint.mitre_exfiltration',type:'keyword'},'checkpoint.mitre_impact':{category:'checkpoint',description:'The adversary is trying to manipulate, interrupt, or destroy your systems and data. ',name:'checkpoint.mitre_impact',type:'keyword'},'checkpoint.parent_file_hash':{category:'checkpoint',description:"Archive's hash in case of extracted files. ",name:'checkpoint.parent_file_hash',type:'keyword'},'checkpoint.parent_file_name':{category:'checkpoint',description:"Archive's name in case of extracted files. ",name:'checkpoint.parent_file_name',type:'keyword'},'checkpoint.parent_file_uid':{category:'checkpoint',description:"Archive's UID in case of extracted files. ",name:'checkpoint.parent_file_uid',type:'keyword'},'checkpoint.similiar_iocs':{category:'checkpoint',description:'Other IoCs similar to the ones found, related to the malicious file. ',name:'checkpoint.similiar_iocs',type:'keyword'},'checkpoint.similar_hashes':{category:'checkpoint',description:'Hashes found similar to the malicious file. ',name:'checkpoint.similar_hashes',type:'keyword'},'checkpoint.similar_strings':{category:'checkpoint',description:'Strings found similar to the malicious file. ',name:'checkpoint.similar_strings',type:'keyword'},'checkpoint.similar_communication':{category:'checkpoint',description:'Network action found similar to the malicious file. ',name:'checkpoint.similar_communication',type:'keyword'},'checkpoint.te_verdict_determined_by':{category:'checkpoint',description:'Emulators determined file verdict. ',name:'checkpoint.te_verdict_determined_by',type:'keyword'},'checkpoint.packet_capture_unique_id':{category:'checkpoint',description:'Identifier of the packet capture files. ',name:'checkpoint.packet_capture_unique_id',type:'keyword'},'checkpoint.total_attachments':{category:'checkpoint',description:'The number of attachments in an email. ',name:'checkpoint.total_attachments',type:'integer'},'checkpoint.additional_info':{category:'checkpoint',description:'ID of original file/mail which are sent by admin. ',name:'checkpoint.additional_info',type:'keyword'},'checkpoint.content_risk':{category:'checkpoint',description:'File risk. ',name:'checkpoint.content_risk',type:'integer'},'checkpoint.operation':{category:'checkpoint',description:'Operation made by Threat Extraction. ',name:'checkpoint.operation',type:'keyword'},'checkpoint.scrubbed_content':{category:'checkpoint',description:'Active content that was found. ',name:'checkpoint.scrubbed_content',type:'keyword'},'checkpoint.scrub_time':{category:'checkpoint',description:'Extraction process duration. ',name:'checkpoint.scrub_time',type:'keyword'},'checkpoint.scrub_download_time':{category:'checkpoint',description:'File download time from resource. ',name:'checkpoint.scrub_download_time',type:'keyword'},'checkpoint.scrub_total_time':{category:'checkpoint',description:'Threat extraction total file handling time. ',name:'checkpoint.scrub_total_time',type:'keyword'},'checkpoint.scrub_activity':{category:'checkpoint',description:'The result of the extraction ',name:'checkpoint.scrub_activity',type:'keyword'},'checkpoint.watermark':{category:'checkpoint',description:'Reports whether watermark is added to the cleaned file. ',name:'checkpoint.watermark',type:'keyword'},'checkpoint.source_object':{category:'checkpoint',description:'Matched object name on source column. ',name:'checkpoint.source_object',type:'integer'},'checkpoint.destination_object':{category:'checkpoint',description:'Matched object name on destination column. ',name:'checkpoint.destination_object',type:'keyword'},'checkpoint.drop_reason':{category:'checkpoint',description:'Drop reason description. ',name:'checkpoint.drop_reason',type:'keyword'},'checkpoint.hit':{category:'checkpoint',description:'Number of hits on a rule. ',name:'checkpoint.hit',type:'integer'},'checkpoint.rulebase_id':{category:'checkpoint',description:'Layer number. ',name:'checkpoint.rulebase_id',type:'integer'},'checkpoint.first_hit_time':{category:'checkpoint',description:'First hit time in current interval. ',name:'checkpoint.first_hit_time',type:'integer'},'checkpoint.last_hit_time':{category:'checkpoint',description:'Last hit time in current interval. ',name:'checkpoint.last_hit_time',type:'integer'},'checkpoint.rematch_info':{category:'checkpoint',description:'Information sent when old connections cannot be matched during policy installation. ',name:'checkpoint.rematch_info',type:'keyword'},'checkpoint.last_rematch_time':{category:'checkpoint',description:'Connection rematched time. ',name:'checkpoint.last_rematch_time',type:'keyword'},'checkpoint.action_reason':{category:'checkpoint',description:'Connection drop reason. ',name:'checkpoint.action_reason',type:'integer'},'checkpoint.c_bytes':{category:'checkpoint',description:'Boolean value indicates whether bytes sent from the client side are used. ',name:'checkpoint.c_bytes',type:'integer'},'checkpoint.context_num':{category:'checkpoint',description:'Serial number of the log for a specific connection. ',name:'checkpoint.context_num',type:'integer'},'checkpoint.match_id':{category:'checkpoint',description:'Private key of the rule ',name:'checkpoint.match_id',type:'integer'},'checkpoint.alert':{category:'checkpoint',description:'Alert level of matched rule (for connection logs). ',name:'checkpoint.alert',type:'keyword'},'checkpoint.parent_rule':{category:'checkpoint',description:'Parent rule number, in case of inline layer. ',name:'checkpoint.parent_rule',type:'integer'},'checkpoint.match_fk':{category:'checkpoint',description:'Rule number. ',name:'checkpoint.match_fk',type:'integer'},'checkpoint.dropped_outgoing':{category:'checkpoint',description:'Number of outgoing bytes dropped when using UP-limit feature. ',name:'checkpoint.dropped_outgoing',type:'integer'},'checkpoint.dropped_incoming':{category:'checkpoint',description:'Number of incoming bytes dropped when using UP-limit feature. ',name:'checkpoint.dropped_incoming',type:'integer'},'checkpoint.media_type':{category:'checkpoint',description:'Media used (audio, video, etc.) ',name:'checkpoint.media_type',type:'keyword'},'checkpoint.sip_reason':{category:'checkpoint',description:"Explains why 'source_ip' isn't allowed to redirect (handover). ",name:'checkpoint.sip_reason',type:'keyword'},'checkpoint.voip_method':{category:'checkpoint',description:'Registration request. ',name:'checkpoint.voip_method',type:'keyword'},'checkpoint.registered_ip-phones':{category:'checkpoint',description:'Registered IP-Phones. ',name:'checkpoint.registered_ip-phones',type:'keyword'},'checkpoint.voip_reg_user_type':{category:'checkpoint',description:'Registered IP-Phone type. ',name:'checkpoint.voip_reg_user_type',type:'keyword'},'checkpoint.voip_call_id':{category:'checkpoint',description:'Call-ID. ',name:'checkpoint.voip_call_id',type:'keyword'},'checkpoint.voip_reg_int':{category:'checkpoint',description:'Registration port. ',name:'checkpoint.voip_reg_int',type:'integer'},'checkpoint.voip_reg_ipp':{category:'checkpoint',description:'Registration IP protocol. ',name:'checkpoint.voip_reg_ipp',type:'integer'},'checkpoint.voip_reg_period':{category:'checkpoint',description:'Registration period. ',name:'checkpoint.voip_reg_period',type:'integer'},'checkpoint.src_phone_number':{category:'checkpoint',description:'Source IP-Phone. ',name:'checkpoint.src_phone_number',type:'keyword'},'checkpoint.voip_from_user_type':{category:'checkpoint',description:'Source IP-Phone type. ',name:'checkpoint.voip_from_user_type',type:'keyword'},'checkpoint.voip_to_user_type':{category:'checkpoint',description:'Destination IP-Phone type. ',name:'checkpoint.voip_to_user_type',type:'keyword'},'checkpoint.voip_call_dir':{category:'checkpoint',description:'Call direction: in/out. ',name:'checkpoint.voip_call_dir',type:'keyword'},'checkpoint.voip_call_state':{category:'checkpoint',description:'Call state. Possible values: in/out. ',name:'checkpoint.voip_call_state',type:'keyword'},'checkpoint.voip_call_term_time':{category:'checkpoint',description:'Call termination time stamp. ',name:'checkpoint.voip_call_term_time',type:'keyword'},'checkpoint.voip_duration':{category:'checkpoint',description:'Call duration (seconds). ',name:'checkpoint.voip_duration',type:'keyword'},'checkpoint.voip_media_port':{category:'checkpoint',description:'Media int. ',name:'checkpoint.voip_media_port',type:'keyword'},'checkpoint.voip_media_ipp':{category:'checkpoint',description:'Media IP protocol. ',name:'checkpoint.voip_media_ipp',type:'keyword'},'checkpoint.voip_est_codec':{category:'checkpoint',description:'Estimated codec. ',name:'checkpoint.voip_est_codec',type:'keyword'},'checkpoint.voip_exp':{category:'checkpoint',description:'Expiration. ',name:'checkpoint.voip_exp',type:'integer'},'checkpoint.voip_attach_sz':{category:'checkpoint',description:'Attachment size. ',name:'checkpoint.voip_attach_sz',type:'integer'},'checkpoint.voip_attach_action_info':{category:'checkpoint',description:'Attachment action Info. ',name:'checkpoint.voip_attach_action_info',type:'keyword'},'checkpoint.voip_media_codec':{category:'checkpoint',description:'Estimated codec. ',name:'checkpoint.voip_media_codec',type:'keyword'},'checkpoint.voip_reject_reason':{category:'checkpoint',description:'Reject reason. ',name:'checkpoint.voip_reject_reason',type:'keyword'},'checkpoint.voip_reason_info':{category:'checkpoint',description:'Information. ',name:'checkpoint.voip_reason_info',type:'keyword'},'checkpoint.voip_config':{category:'checkpoint',description:'Configuration. ',name:'checkpoint.voip_config',type:'keyword'},'checkpoint.voip_reg_server':{category:'checkpoint',description:'Registrar server IP address. ',name:'checkpoint.voip_reg_server',type:'ip'},'checkpoint.scv_user':{category:'checkpoint',description:'Username whose packets are dropped on SCV. ',name:'checkpoint.scv_user',type:'keyword'},'checkpoint.scv_message_info':{category:'checkpoint',description:'Drop reason. ',name:'checkpoint.scv_message_info',type:'keyword'},'checkpoint.ppp':{category:'checkpoint',description:'Authentication status. ',name:'checkpoint.ppp',type:'keyword'},'checkpoint.scheme':{category:'checkpoint',description:'Describes the scheme used for the log. ',name:'checkpoint.scheme',type:'keyword'},'checkpoint.machine':{category:'checkpoint',description:'L2TP machine which triggered the log and the log refers to it. ',name:'checkpoint.machine',type:'keyword'},'checkpoint.vpn_feature_name':{category:'checkpoint',description:'L2TP /IKE / Link Selection. ',name:'checkpoint.vpn_feature_name',type:'keyword'},'checkpoint.reject_category':{category:'checkpoint',description:'Authentication failure reason. ',name:'checkpoint.reject_category',type:'keyword'},'checkpoint.peer_ip_probing_status_update':{category:'checkpoint',description:'IP address response status. ',name:'checkpoint.peer_ip_probing_status_update',type:'keyword'},'checkpoint.peer_ip':{category:'checkpoint',description:'IP address which the client connects to. ',name:'checkpoint.peer_ip',type:'keyword'},'checkpoint.link_probing_status_update':{category:'checkpoint',description:'IP address response status. ',name:'checkpoint.link_probing_status_update',type:'keyword'},'checkpoint.source_interface':{category:'checkpoint',description:'External Interface name for source interface or Null if not found. ',name:'checkpoint.source_interface',type:'keyword'},'checkpoint.next_hop_ip':{category:'checkpoint',description:'Next hop IP address. ',name:'checkpoint.next_hop_ip',type:'keyword'},'checkpoint.srckeyid':{category:'checkpoint',description:'Initiator Spi ID. ',name:'checkpoint.srckeyid',type:'keyword'},'checkpoint.dstkeyid':{category:'checkpoint',description:'Responder Spi ID. ',name:'checkpoint.dstkeyid',type:'keyword'},'checkpoint.encryption_failure':{category:'checkpoint',description:'Message indicating why the encryption failed. ',name:'checkpoint.encryption_failure',type:'keyword'},'checkpoint.ike_ids':{category:'checkpoint',description:'All QM ids. ',name:'checkpoint.ike_ids',type:'keyword'},'checkpoint.community':{category:'checkpoint',description:'Community name for the IPSec key and the use of the IKEv. ',name:'checkpoint.community',type:'keyword'},'checkpoint.ike':{category:'checkpoint',description:'IKEMode (PHASE1, PHASE2, etc..). ',name:'checkpoint.ike',type:'keyword'},'checkpoint.cookieI':{category:'checkpoint',description:'Initiator cookie. ',name:'checkpoint.cookieI',type:'keyword'},'checkpoint.cookieR':{category:'checkpoint',description:'Responder cookie. ',name:'checkpoint.cookieR',type:'keyword'},'checkpoint.msgid':{category:'checkpoint',description:'Message ID. ',name:'checkpoint.msgid',type:'keyword'},'checkpoint.methods':{category:'checkpoint',description:'IPSEc methods. ',name:'checkpoint.methods',type:'keyword'},'checkpoint.connection_uid':{category:'checkpoint',description:'Calculation of md5 of the IP and user name as UID. ',name:'checkpoint.connection_uid',type:'keyword'},'checkpoint.site_name':{category:'checkpoint',description:'Site name. ',name:'checkpoint.site_name',type:'keyword'},'checkpoint.esod_rule_name':{category:'checkpoint',description:'Unknown rule name. ',name:'checkpoint.esod_rule_name',type:'keyword'},'checkpoint.esod_rule_action':{category:'checkpoint',description:'Unknown rule action. ',name:'checkpoint.esod_rule_action',type:'keyword'},'checkpoint.esod_rule_type':{category:'checkpoint',description:'Unknown rule type. ',name:'checkpoint.esod_rule_type',type:'keyword'},'checkpoint.esod_noncompliance_reason':{category:'checkpoint',description:'Non-compliance reason. ',name:'checkpoint.esod_noncompliance_reason',type:'keyword'},'checkpoint.esod_associated_policies':{category:'checkpoint',description:'Associated policies. ',name:'checkpoint.esod_associated_policies',type:'keyword'},'checkpoint.spyware_type':{category:'checkpoint',description:'Spyware type. ',name:'checkpoint.spyware_type',type:'keyword'},'checkpoint.anti_virus_type':{category:'checkpoint',description:'Anti virus type. ',name:'checkpoint.anti_virus_type',type:'keyword'},'checkpoint.end_user_firewall_type':{category:'checkpoint',description:'End user firewall type. ',name:'checkpoint.end_user_firewall_type',type:'keyword'},'checkpoint.esod_scan_status':{category:'checkpoint',description:'Scan failed. ',name:'checkpoint.esod_scan_status',type:'keyword'},'checkpoint.esod_access_status':{category:'checkpoint',description:'Access denied. ',name:'checkpoint.esod_access_status',type:'keyword'},'checkpoint.client_type':{category:'checkpoint',description:'Endpoint Connect. ',name:'checkpoint.client_type',type:'keyword'},'checkpoint.precise_error':{category:'checkpoint',description:'HTTP parser error. ',name:'checkpoint.precise_error',type:'keyword'},'checkpoint.method':{category:'checkpoint',description:'HTTP method. ',name:'checkpoint.method',type:'keyword'},'checkpoint.trusted_domain':{category:'checkpoint',description:'In case of phishing event, the domain, which the attacker was impersonating. ',name:'checkpoint.trusted_domain',type:'keyword'},'cisco.asa.message_id':{category:'cisco',description:'The Cisco ASA message identifier. ',name:'cisco.asa.message_id',type:'keyword'},'cisco.asa.suffix':{category:'cisco',description:'Optional suffix after %ASA identifier. ',example:'session',name:'cisco.asa.suffix',type:'keyword'},'cisco.asa.source_interface':{category:'cisco',description:'Source interface for the flow or event. ',name:'cisco.asa.source_interface',type:'keyword'},'cisco.asa.destination_interface':{category:'cisco',description:'Destination interface for the flow or event. ',name:'cisco.asa.destination_interface',type:'keyword'},'cisco.asa.rule_name':{category:'cisco',description:'Name of the Access Control List rule that matched this event. ',name:'cisco.asa.rule_name',type:'keyword'},'cisco.asa.source_username':{category:'cisco',description:'Name of the user that is the source for this event. ',name:'cisco.asa.source_username',type:'keyword'},'cisco.asa.destination_username':{category:'cisco',description:'Name of the user that is the destination for this event. ',name:'cisco.asa.destination_username',type:'keyword'},'cisco.asa.mapped_source_ip':{category:'cisco',description:'The translated source IP address. ',name:'cisco.asa.mapped_source_ip',type:'ip'},'cisco.asa.mapped_source_host':{category:'cisco',description:'The translated source host. ',name:'cisco.asa.mapped_source_host',type:'keyword'},'cisco.asa.mapped_source_port':{category:'cisco',description:'The translated source port. ',name:'cisco.asa.mapped_source_port',type:'long'},'cisco.asa.mapped_destination_ip':{category:'cisco',description:'The translated destination IP address. ',name:'cisco.asa.mapped_destination_ip',type:'ip'},'cisco.asa.mapped_destination_host':{category:'cisco',description:'The translated destination host. ',name:'cisco.asa.mapped_destination_host',type:'keyword'},'cisco.asa.mapped_destination_port':{category:'cisco',description:'The translated destination port. ',name:'cisco.asa.mapped_destination_port',type:'long'},'cisco.asa.threat_level':{category:'cisco',description:'Threat level for malware / botnet traffic. One of very-low, low, moderate, high or very-high. ',name:'cisco.asa.threat_level',type:'keyword'},'cisco.asa.threat_category':{category:'cisco',description:'Category for the malware / botnet traffic. For example: virus, botnet, trojan, etc. ',name:'cisco.asa.threat_category',type:'keyword'},'cisco.asa.connection_id':{category:'cisco',description:'Unique identifier for a flow. ',name:'cisco.asa.connection_id',type:'keyword'},'cisco.asa.icmp_type':{category:'cisco',description:'ICMP type. ',name:'cisco.asa.icmp_type',type:'short'},'cisco.asa.icmp_code':{category:'cisco',description:'ICMP code. ',name:'cisco.asa.icmp_code',type:'short'},'cisco.asa.connection_type':{category:'cisco',description:'The VPN connection type ',name:'cisco.asa.connection_type',type:'keyword'},'cisco.asa.dap_records':{category:'cisco',description:'The assigned DAP records ',name:'cisco.asa.dap_records',type:'keyword'},'cisco.ftd.message_id':{category:'cisco',description:'The Cisco FTD message identifier. ',name:'cisco.ftd.message_id',type:'keyword'},'cisco.ftd.suffix':{category:'cisco',description:'Optional suffix after %FTD identifier. ',example:'session',name:'cisco.ftd.suffix',type:'keyword'},'cisco.ftd.source_interface':{category:'cisco',description:'Source interface for the flow or event. ',name:'cisco.ftd.source_interface',type:'keyword'},'cisco.ftd.destination_interface':{category:'cisco',description:'Destination interface for the flow or event. ',name:'cisco.ftd.destination_interface',type:'keyword'},'cisco.ftd.rule_name':{category:'cisco',description:'Name of the Access Control List rule that matched this event. ',name:'cisco.ftd.rule_name',type:'keyword'},'cisco.ftd.source_username':{category:'cisco',description:'Name of the user that is the source for this event. ',name:'cisco.ftd.source_username',type:'keyword'},'cisco.ftd.destination_username':{category:'cisco',description:'Name of the user that is the destination for this event. ',name:'cisco.ftd.destination_username',type:'keyword'},'cisco.ftd.mapped_source_ip':{category:'cisco',description:'The translated source IP address. Use ECS source.nat.ip. ',name:'cisco.ftd.mapped_source_ip',type:'ip'},'cisco.ftd.mapped_source_host':{category:'cisco',description:'The translated source host. ',name:'cisco.ftd.mapped_source_host',type:'keyword'},'cisco.ftd.mapped_source_port':{category:'cisco',description:'The translated source port. Use ECS source.nat.port. ',name:'cisco.ftd.mapped_source_port',type:'long'},'cisco.ftd.mapped_destination_ip':{category:'cisco',description:'The translated destination IP address. Use ECS destination.nat.ip. ',name:'cisco.ftd.mapped_destination_ip',type:'ip'},'cisco.ftd.mapped_destination_host':{category:'cisco',description:'The translated destination host. ',name:'cisco.ftd.mapped_destination_host',type:'keyword'},'cisco.ftd.mapped_destination_port':{category:'cisco',description:'The translated destination port. Use ECS destination.nat.port. ',name:'cisco.ftd.mapped_destination_port',type:'long'},'cisco.ftd.threat_level':{category:'cisco',description:'Threat level for malware / botnet traffic. One of very-low, low, moderate, high or very-high. ',name:'cisco.ftd.threat_level',type:'keyword'},'cisco.ftd.threat_category':{category:'cisco',description:'Category for the malware / botnet traffic. For example: virus, botnet, trojan, etc. ',name:'cisco.ftd.threat_category',type:'keyword'},'cisco.ftd.connection_id':{category:'cisco',description:'Unique identifier for a flow. ',name:'cisco.ftd.connection_id',type:'keyword'},'cisco.ftd.icmp_type':{category:'cisco',description:'ICMP type. ',name:'cisco.ftd.icmp_type',type:'short'},'cisco.ftd.icmp_code':{category:'cisco',description:'ICMP code. ',name:'cisco.ftd.icmp_code',type:'short'},'cisco.ftd.security':{category:'cisco',description:'Raw fields for Security Events.',name:'cisco.ftd.security',type:'object'},'cisco.ftd.connection_type':{category:'cisco',description:'The VPN connection type ',name:'cisco.ftd.connection_type',type:'keyword'},'cisco.ftd.dap_records':{category:'cisco',description:'The assigned DAP records ',name:'cisco.ftd.dap_records',type:'keyword'},'cisco.ios.access_list':{category:'cisco',description:'Name of the IP access list. ',name:'cisco.ios.access_list',type:'keyword'},'cisco.ios.facility':{category:'cisco',description:'The facility to which the message refers (for example, SNMP, SYS, and so forth). A facility can be a hardware device, a protocol, or a module of the system software. It denotes the source or the cause of the system message. ',example:'SEC',name:'cisco.ios.facility',type:'keyword'},'coredns.id':{category:'coredns',description:'id of the DNS transaction ',name:'coredns.id',type:'keyword'},'coredns.query.size':{category:'coredns',description:'size of the DNS query ',name:'coredns.query.size',type:'integer',format:'bytes'},'coredns.query.class':{category:'coredns',description:'DNS query class ',name:'coredns.query.class',type:'keyword'},'coredns.query.name':{category:'coredns',description:'DNS query name ',name:'coredns.query.name',type:'keyword'},'coredns.query.type':{category:'coredns',description:'DNS query type ',name:'coredns.query.type',type:'keyword'},'coredns.response.code':{category:'coredns',description:'DNS response code ',name:'coredns.response.code',type:'keyword'},'coredns.response.flags':{category:'coredns',description:'DNS response flags ',name:'coredns.response.flags',type:'keyword'},'coredns.response.size':{category:'coredns',description:'size of the DNS response ',name:'coredns.response.size',type:'integer',format:'bytes'},'coredns.dnssec_ok':{category:'coredns',description:'dnssec flag ',name:'coredns.dnssec_ok',type:'boolean'},'crowdstrike.metadata.eventType':{category:'crowdstrike',description:'DetectionSummaryEvent, FirewallMatchEvent, IncidentSummaryEvent, RemoteResponseSessionStartEvent, RemoteResponseSessionEndEvent, AuthActivityAuditEvent, or UserActivityAuditEvent ',name:'crowdstrike.metadata.eventType',type:'keyword'},'crowdstrike.metadata.eventCreationTime':{category:'crowdstrike',description:'The time this event occurred on the endpoint in UTC UNIX_MS format. ',name:'crowdstrike.metadata.eventCreationTime',type:'date'},'crowdstrike.metadata.offset':{category:'crowdstrike',description:'Offset number that tracks the location of the event in stream. This is used to identify unique detection events. ',name:'crowdstrike.metadata.offset',type:'integer'},'crowdstrike.metadata.customerIDString':{category:'crowdstrike',description:'Customer identifier ',name:'crowdstrike.metadata.customerIDString',type:'keyword'},'crowdstrike.metadata.version':{category:'crowdstrike',description:'Schema version ',name:'crowdstrike.metadata.version',type:'keyword'},'crowdstrike.event.ProcessStartTime':{category:'crowdstrike',description:'The process start time in UTC UNIX_MS format. ',name:'crowdstrike.event.ProcessStartTime',type:'date'},'crowdstrike.event.ProcessEndTime':{category:'crowdstrike',description:'The process termination time in UTC UNIX_MS format. ',name:'crowdstrike.event.ProcessEndTime',type:'date'},'crowdstrike.event.ProcessId':{category:'crowdstrike',description:'Process ID related to the detection. ',name:'crowdstrike.event.ProcessId',type:'integer'},'crowdstrike.event.ParentProcessId':{category:'crowdstrike',description:'Parent process ID related to the detection. ',name:'crowdstrike.event.ParentProcessId',type:'integer'},'crowdstrike.event.ComputerName':{category:'crowdstrike',description:'Name of the computer where the detection occurred. ',name:'crowdstrike.event.ComputerName',type:'keyword'},'crowdstrike.event.UserName':{category:'crowdstrike',description:'User name associated with the detection. ',name:'crowdstrike.event.UserName',type:'keyword'},'crowdstrike.event.DetectName':{category:'crowdstrike',description:'Name of the detection. ',name:'crowdstrike.event.DetectName',type:'keyword'},'crowdstrike.event.DetectDescription':{category:'crowdstrike',description:'Description of the detection. ',name:'crowdstrike.event.DetectDescription',type:'keyword'},'crowdstrike.event.Severity':{category:'crowdstrike',description:'Severity score of the detection. ',name:'crowdstrike.event.Severity',type:'integer'},'crowdstrike.event.SeverityName':{category:'crowdstrike',description:'Severity score text. ',name:'crowdstrike.event.SeverityName',type:'keyword'},'crowdstrike.event.FileName':{category:'crowdstrike',description:'File name of the associated process for the detection. ',name:'crowdstrike.event.FileName',type:'keyword'},'crowdstrike.event.FilePath':{category:'crowdstrike',description:'Path of the executable associated with the detection. ',name:'crowdstrike.event.FilePath',type:'keyword'},'crowdstrike.event.CommandLine':{category:'crowdstrike',description:'Executable path with command line arguments. ',name:'crowdstrike.event.CommandLine',type:'keyword'},'crowdstrike.event.SHA1String':{category:'crowdstrike',description:'SHA1 sum of the executable associated with the detection. ',name:'crowdstrike.event.SHA1String',type:'keyword'},'crowdstrike.event.SHA256String':{category:'crowdstrike',description:'SHA256 sum of the executable associated with the detection. ',name:'crowdstrike.event.SHA256String',type:'keyword'},'crowdstrike.event.MD5String':{category:'crowdstrike',description:'MD5 sum of the executable associated with the detection. ',name:'crowdstrike.event.MD5String',type:'keyword'},'crowdstrike.event.MachineDomain':{category:'crowdstrike',description:'Domain for the machine associated with the detection. ',name:'crowdstrike.event.MachineDomain',type:'keyword'},'crowdstrike.event.FalconHostLink':{category:'crowdstrike',description:'URL to view the detection in Falcon. ',name:'crowdstrike.event.FalconHostLink',type:'keyword'},'crowdstrike.event.SensorId':{category:'crowdstrike',description:'Unique ID associated with the Falcon sensor. ',name:'crowdstrike.event.SensorId',type:'keyword'},'crowdstrike.event.DetectId':{category:'crowdstrike',description:'Unique ID associated with the detection. ',name:'crowdstrike.event.DetectId',type:'keyword'},'crowdstrike.event.LocalIP':{category:'crowdstrike',description:'IP address of the host associated with the detection. ',name:'crowdstrike.event.LocalIP',type:'keyword'},'crowdstrike.event.MACAddress':{category:'crowdstrike',description:'MAC address of the host associated with the detection. ',name:'crowdstrike.event.MACAddress',type:'keyword'},'crowdstrike.event.Tactic':{category:'crowdstrike',description:'MITRE tactic category of the detection. ',name:'crowdstrike.event.Tactic',type:'keyword'},'crowdstrike.event.Technique':{category:'crowdstrike',description:'MITRE technique category of the detection. ',name:'crowdstrike.event.Technique',type:'keyword'},'crowdstrike.event.Objective':{category:'crowdstrike',description:'Method of detection. ',name:'crowdstrike.event.Objective',type:'keyword'},'crowdstrike.event.PatternDispositionDescription':{category:'crowdstrike',description:'Action taken by Falcon. ',name:'crowdstrike.event.PatternDispositionDescription',type:'keyword'},'crowdstrike.event.PatternDispositionValue':{category:'crowdstrike',description:'Unique ID associated with action taken. ',name:'crowdstrike.event.PatternDispositionValue',type:'integer'},'crowdstrike.event.PatternDispositionFlags':{category:'crowdstrike',description:'Flags indicating actions taken. ',name:'crowdstrike.event.PatternDispositionFlags',type:'object'},'crowdstrike.event.State':{category:'crowdstrike',description:'Whether the incident summary is open and ongoing or closed. ',name:'crowdstrike.event.State',type:'keyword'},'crowdstrike.event.IncidentStartTime':{category:'crowdstrike',description:'Start time for the incident in UTC UNIX format. ',name:'crowdstrike.event.IncidentStartTime',type:'date'},'crowdstrike.event.IncidentEndTime':{category:'crowdstrike',description:'End time for the incident in UTC UNIX format. ',name:'crowdstrike.event.IncidentEndTime',type:'date'},'crowdstrike.event.FineScore':{category:'crowdstrike',description:'Score for incident. ',name:'crowdstrike.event.FineScore',type:'float'},'crowdstrike.event.UserId':{category:'crowdstrike',description:'Email address or user ID associated with the event. ',name:'crowdstrike.event.UserId',type:'keyword'},'crowdstrike.event.UserIp':{category:'crowdstrike',description:'IP address associated with the user. ',name:'crowdstrike.event.UserIp',type:'keyword'},'crowdstrike.event.OperationName':{category:'crowdstrike',description:'Event subtype. ',name:'crowdstrike.event.OperationName',type:'keyword'},'crowdstrike.event.ServiceName':{category:'crowdstrike',description:'Service associated with this event. ',name:'crowdstrike.event.ServiceName',type:'keyword'},'crowdstrike.event.Success':{category:'crowdstrike',description:'Indicator of whether or not this event was successful. ',name:'crowdstrike.event.Success',type:'boolean'},'crowdstrike.event.UTCTimestamp':{category:'crowdstrike',description:'Timestamp associated with this event in UTC UNIX format. ',name:'crowdstrike.event.UTCTimestamp',type:'date'},'crowdstrike.event.AuditKeyValues':{category:'crowdstrike',description:'Fields that were changed in this event. ',name:'crowdstrike.event.AuditKeyValues',type:'nested'},'crowdstrike.event.ExecutablesWritten':{category:'crowdstrike',description:'Detected executables written to disk by a process. ',name:'crowdstrike.event.ExecutablesWritten',type:'nested'},'crowdstrike.event.SessionId':{category:'crowdstrike',description:'Session ID of the remote response session. ',name:'crowdstrike.event.SessionId',type:'keyword'},'crowdstrike.event.HostnameField':{category:'crowdstrike',description:'Host name of the machine for the remote session. ',name:'crowdstrike.event.HostnameField',type:'keyword'},'crowdstrike.event.StartTimestamp':{category:'crowdstrike',description:'Start time for the remote session in UTC UNIX format. ',name:'crowdstrike.event.StartTimestamp',type:'date'},'crowdstrike.event.EndTimestamp':{category:'crowdstrike',description:'End time for the remote session in UTC UNIX format. ',name:'crowdstrike.event.EndTimestamp',type:'date'},'crowdstrike.event.LateralMovement':{category:'crowdstrike',description:'Lateral movement field for incident. ',name:'crowdstrike.event.LateralMovement',type:'long'},'crowdstrike.event.ParentImageFileName':{category:'crowdstrike',description:'Path to the parent process. ',name:'crowdstrike.event.ParentImageFileName',type:'keyword'},'crowdstrike.event.ParentCommandLine':{category:'crowdstrike',description:'Parent process command line arguments. ',name:'crowdstrike.event.ParentCommandLine',type:'keyword'},'crowdstrike.event.GrandparentImageFileName':{category:'crowdstrike',description:'Path to the grandparent process. ',name:'crowdstrike.event.GrandparentImageFileName',type:'keyword'},'crowdstrike.event.GrandparentCommandLine':{category:'crowdstrike',description:'Grandparent process command line arguments. ',name:'crowdstrike.event.GrandparentCommandLine',type:'keyword'},'crowdstrike.event.IOCType':{category:'crowdstrike',description:'CrowdStrike type for indicator of compromise. ',name:'crowdstrike.event.IOCType',type:'keyword'},'crowdstrike.event.IOCValue':{category:'crowdstrike',description:'CrowdStrike value for indicator of compromise. ',name:'crowdstrike.event.IOCValue',type:'keyword'},'crowdstrike.event.CustomerId':{category:'crowdstrike',description:'Customer identifier. ',name:'crowdstrike.event.CustomerId',type:'keyword'},'crowdstrike.event.DeviceId':{category:'crowdstrike',description:'Device on which the event occurred. ',name:'crowdstrike.event.DeviceId',type:'keyword'},'crowdstrike.event.Ipv':{category:'crowdstrike',description:'Protocol for network request. ',name:'crowdstrike.event.Ipv',type:'keyword'},'crowdstrike.event.ConnectionDirection':{category:'crowdstrike',description:'Direction for network connection. ',name:'crowdstrike.event.ConnectionDirection',type:'keyword'},'crowdstrike.event.EventType':{category:'crowdstrike',description:'CrowdStrike provided event type. ',name:'crowdstrike.event.EventType',type:'keyword'},'crowdstrike.event.HostName':{category:'crowdstrike',description:'Host name of the local machine. ',name:'crowdstrike.event.HostName',type:'keyword'},'crowdstrike.event.ICMPCode':{category:'crowdstrike',description:'RFC2780 ICMP Code field. ',name:'crowdstrike.event.ICMPCode',type:'keyword'},'crowdstrike.event.ICMPType':{category:'crowdstrike',description:'RFC2780 ICMP Type field. ',name:'crowdstrike.event.ICMPType',type:'keyword'},'crowdstrike.event.ImageFileName':{category:'crowdstrike',description:'File name of the associated process for the detection. ',name:'crowdstrike.event.ImageFileName',type:'keyword'},'crowdstrike.event.PID':{category:'crowdstrike',description:'Associated process id for the detection. ',name:'crowdstrike.event.PID',type:'long'},'crowdstrike.event.LocalAddress':{category:'crowdstrike',description:'IP address of local machine. ',name:'crowdstrike.event.LocalAddress',type:'ip'},'crowdstrike.event.LocalPort':{category:'crowdstrike',description:'Port of local machine. ',name:'crowdstrike.event.LocalPort',type:'long'},'crowdstrike.event.RemoteAddress':{category:'crowdstrike',description:'IP address of remote machine. ',name:'crowdstrike.event.RemoteAddress',type:'ip'},'crowdstrike.event.RemotePort':{category:'crowdstrike',description:'Port of remote machine. ',name:'crowdstrike.event.RemotePort',type:'long'},'crowdstrike.event.RuleAction':{category:'crowdstrike',description:'Firewall rule action. ',name:'crowdstrike.event.RuleAction',type:'keyword'},'crowdstrike.event.RuleDescription':{category:'crowdstrike',description:'Firewall rule description. ',name:'crowdstrike.event.RuleDescription',type:'keyword'},'crowdstrike.event.RuleFamilyID':{category:'crowdstrike',description:'Firewall rule family id. ',name:'crowdstrike.event.RuleFamilyID',type:'keyword'},'crowdstrike.event.RuleGroupName':{category:'crowdstrike',description:'Firewall rule group name. ',name:'crowdstrike.event.RuleGroupName',type:'keyword'},'crowdstrike.event.RuleName':{category:'crowdstrike',description:'Firewall rule name. ',name:'crowdstrike.event.RuleName',type:'keyword'},'crowdstrike.event.RuleId':{category:'crowdstrike',description:'Firewall rule id. ',name:'crowdstrike.event.RuleId',type:'keyword'},'crowdstrike.event.MatchCount':{category:'crowdstrike',description:'Number of firewall rule matches. ',name:'crowdstrike.event.MatchCount',type:'long'},'crowdstrike.event.MatchCountSinceLastReport':{category:'crowdstrike',description:'Number of firewall rule matches since the last report. ',name:'crowdstrike.event.MatchCountSinceLastReport',type:'long'},'crowdstrike.event.Timestamp':{category:'crowdstrike',description:'Firewall rule triggered timestamp. ',name:'crowdstrike.event.Timestamp',type:'date'},'crowdstrike.event.Flags.Audit':{category:'crowdstrike',description:'CrowdStrike audit flag. ',name:'crowdstrike.event.Flags.Audit',type:'boolean'},'crowdstrike.event.Flags.Log':{category:'crowdstrike',description:'CrowdStrike log flag. ',name:'crowdstrike.event.Flags.Log',type:'boolean'},'crowdstrike.event.Flags.Monitor':{category:'crowdstrike',description:'CrowdStrike monitor flag. ',name:'crowdstrike.event.Flags.Monitor',type:'boolean'},'crowdstrike.event.Protocol':{category:'crowdstrike',description:'CrowdStrike provided protocol. ',name:'crowdstrike.event.Protocol',type:'keyword'},'crowdstrike.event.NetworkProfile':{category:'crowdstrike',description:'CrowdStrike network profile. ',name:'crowdstrike.event.NetworkProfile',type:'keyword'},'crowdstrike.event.PolicyName':{category:'crowdstrike',description:'CrowdStrike policy name. ',name:'crowdstrike.event.PolicyName',type:'keyword'},'crowdstrike.event.PolicyID':{category:'crowdstrike',description:'CrowdStrike policy id. ',name:'crowdstrike.event.PolicyID',type:'keyword'},'crowdstrike.event.Status':{category:'crowdstrike',description:'CrowdStrike status. ',name:'crowdstrike.event.Status',type:'keyword'},'crowdstrike.event.TreeID':{category:'crowdstrike',description:'CrowdStrike tree id. ',name:'crowdstrike.event.TreeID',type:'keyword'},'crowdstrike.event.Commands':{category:'crowdstrike',description:'Commands run in a remote session. ',name:'crowdstrike.event.Commands',type:'keyword'},'envoyproxy.log_type':{category:'envoyproxy',description:'Envoy log type, normally ACCESS ',name:'envoyproxy.log_type',type:'keyword'},'envoyproxy.response_flags':{category:'envoyproxy',description:'Response flags ',name:'envoyproxy.response_flags',type:'keyword'},'envoyproxy.upstream_service_time':{category:'envoyproxy',description:'Upstream service time in nanoseconds ',name:'envoyproxy.upstream_service_time',type:'long',format:'duration'},'envoyproxy.request_id':{category:'envoyproxy',description:'ID of the request ',name:'envoyproxy.request_id',type:'keyword'},'envoyproxy.authority':{category:'envoyproxy',description:'Envoy proxy authority field ',name:'envoyproxy.authority',type:'keyword'},'envoyproxy.proxy_type':{category:'envoyproxy',description:'Envoy proxy type, tcp or http ',name:'envoyproxy.proxy_type',type:'keyword'},'fortinet.file.hash.crc32':{category:'fortinet',description:'CRC32 Hash of file ',name:'fortinet.file.hash.crc32',type:'keyword'},'fortinet.firewall.acct_stat':{category:'fortinet',description:'Accounting state (RADIUS) ',name:'fortinet.firewall.acct_stat',type:'keyword'},'fortinet.firewall.acktime':{category:'fortinet',description:'Alarm Acknowledge Time ',name:'fortinet.firewall.acktime',type:'keyword'},'fortinet.firewall.act':{category:'fortinet',description:'Action ',name:'fortinet.firewall.act',type:'keyword'},'fortinet.firewall.action':{category:'fortinet',description:'Status of the session ',name:'fortinet.firewall.action',type:'keyword'},'fortinet.firewall.activity':{category:'fortinet',description:'HA activity message ',name:'fortinet.firewall.activity',type:'keyword'},'fortinet.firewall.addr':{category:'fortinet',description:'IP Address ',name:'fortinet.firewall.addr',type:'ip'},'fortinet.firewall.addr_type':{category:'fortinet',description:'Address Type ',name:'fortinet.firewall.addr_type',type:'keyword'},'fortinet.firewall.addrgrp':{category:'fortinet',description:'Address Group ',name:'fortinet.firewall.addrgrp',type:'keyword'},'fortinet.firewall.adgroup':{category:'fortinet',description:'AD Group Name ',name:'fortinet.firewall.adgroup',type:'keyword'},'fortinet.firewall.admin':{category:'fortinet',description:'Admin User ',name:'fortinet.firewall.admin',type:'keyword'},'fortinet.firewall.age':{category:'fortinet',description:'Time in seconds - time passed since last seen ',name:'fortinet.firewall.age',type:'integer'},'fortinet.firewall.agent':{category:'fortinet',description:'User agent - eg. agent="Mozilla/5.0" ',name:'fortinet.firewall.agent',type:'keyword'},'fortinet.firewall.alarmid':{category:'fortinet',description:'Alarm ID ',name:'fortinet.firewall.alarmid',type:'integer'},'fortinet.firewall.alert':{category:'fortinet',description:'Alert ',name:'fortinet.firewall.alert',type:'keyword'},'fortinet.firewall.analyticscksum':{category:'fortinet',description:'The checksum of the file submitted for analytics ',name:'fortinet.firewall.analyticscksum',type:'keyword'},'fortinet.firewall.analyticssubmit':{category:'fortinet',description:'The flag for analytics submission ',name:'fortinet.firewall.analyticssubmit',type:'keyword'},'fortinet.firewall.ap':{category:'fortinet',description:'Access Point ',name:'fortinet.firewall.ap',type:'keyword'},'fortinet.firewall.app-type':{category:'fortinet',description:'Address Type ',name:'fortinet.firewall.app-type',type:'keyword'},'fortinet.firewall.appact':{category:'fortinet',description:'The security action from app control ',name:'fortinet.firewall.appact',type:'keyword'},'fortinet.firewall.appid':{category:'fortinet',description:'Application ID ',name:'fortinet.firewall.appid',type:'integer'},'fortinet.firewall.applist':{category:'fortinet',description:'Application Control profile ',name:'fortinet.firewall.applist',type:'keyword'},'fortinet.firewall.apprisk':{category:'fortinet',description:'Application Risk Level ',name:'fortinet.firewall.apprisk',type:'keyword'},'fortinet.firewall.apscan':{category:'fortinet',description:'The name of the AP, which scanned and detected the rogue AP ',name:'fortinet.firewall.apscan',type:'keyword'},'fortinet.firewall.apsn':{category:'fortinet',description:'Access Point ',name:'fortinet.firewall.apsn',type:'keyword'},'fortinet.firewall.apstatus':{category:'fortinet',description:'Access Point status ',name:'fortinet.firewall.apstatus',type:'keyword'},'fortinet.firewall.aptype':{category:'fortinet',description:'Access Point type ',name:'fortinet.firewall.aptype',type:'keyword'},'fortinet.firewall.assigned':{category:'fortinet',description:'Assigned IP Address ',name:'fortinet.firewall.assigned',type:'ip'},'fortinet.firewall.assignip':{category:'fortinet',description:'Assigned IP Address ',name:'fortinet.firewall.assignip',type:'ip'},'fortinet.firewall.attachment':{category:'fortinet',description:'The flag for email attachement ',name:'fortinet.firewall.attachment',type:'keyword'},'fortinet.firewall.attack':{category:'fortinet',description:'Attack Name ',name:'fortinet.firewall.attack',type:'keyword'},'fortinet.firewall.attackcontext':{category:'fortinet',description:'The trigger patterns and the packetdata with base64 encoding ',name:'fortinet.firewall.attackcontext',type:'keyword'},'fortinet.firewall.attackcontextid':{category:'fortinet',description:'Attack context id / total ',name:'fortinet.firewall.attackcontextid',type:'keyword'},'fortinet.firewall.attackid':{category:'fortinet',description:'Attack ID ',name:'fortinet.firewall.attackid',type:'integer'},'fortinet.firewall.auditid':{category:'fortinet',description:'Audit ID ',name:'fortinet.firewall.auditid',type:'long'},'fortinet.firewall.auditscore':{category:'fortinet',description:'The Audit Score ',name:'fortinet.firewall.auditscore',type:'keyword'},'fortinet.firewall.audittime':{category:'fortinet',description:'The time of the audit ',name:'fortinet.firewall.audittime',type:'long'},'fortinet.firewall.authgrp':{category:'fortinet',description:'Authorization Group ',name:'fortinet.firewall.authgrp',type:'keyword'},'fortinet.firewall.authid':{category:'fortinet',description:'Authentication ID ',name:'fortinet.firewall.authid',type:'keyword'},'fortinet.firewall.authproto':{category:'fortinet',description:'The protocol that initiated the authentication ',name:'fortinet.firewall.authproto',type:'keyword'},'fortinet.firewall.authserver':{category:'fortinet',description:'Authentication server ',name:'fortinet.firewall.authserver',type:'keyword'},'fortinet.firewall.bandwidth':{category:'fortinet',description:'Bandwidth ',name:'fortinet.firewall.bandwidth',type:'keyword'},'fortinet.firewall.banned_rule':{category:'fortinet',description:'NAC quarantine Banned Rule Name ',name:'fortinet.firewall.banned_rule',type:'keyword'},'fortinet.firewall.banned_src':{category:'fortinet',description:'NAC quarantine Banned Source IP ',name:'fortinet.firewall.banned_src',type:'keyword'},'fortinet.firewall.banword':{category:'fortinet',description:'Banned word ',name:'fortinet.firewall.banword',type:'keyword'},'fortinet.firewall.botnetdomain':{category:'fortinet',description:'Botnet Domain Name ',name:'fortinet.firewall.botnetdomain',type:'keyword'},'fortinet.firewall.botnetip':{category:'fortinet',description:'Botnet IP Address ',name:'fortinet.firewall.botnetip',type:'ip'},'fortinet.firewall.bssid':{category:'fortinet',description:'Service Set ID ',name:'fortinet.firewall.bssid',type:'keyword'},'fortinet.firewall.call_id':{category:'fortinet',description:'Caller ID ',name:'fortinet.firewall.call_id',type:'keyword'},'fortinet.firewall.carrier_ep':{category:'fortinet',description:'The FortiOS Carrier end-point identification ',name:'fortinet.firewall.carrier_ep',type:'keyword'},'fortinet.firewall.cat':{category:'fortinet',description:'DNS category ID ',name:'fortinet.firewall.cat',type:'integer'},'fortinet.firewall.category':{category:'fortinet',description:'Authentication category ',name:'fortinet.firewall.category',type:'keyword'},'fortinet.firewall.cc':{category:'fortinet',description:'CC Email Address ',name:'fortinet.firewall.cc',type:'keyword'},'fortinet.firewall.cdrcontent':{category:'fortinet',description:'Cdrcontent ',name:'fortinet.firewall.cdrcontent',type:'keyword'},'fortinet.firewall.centralnatid':{category:'fortinet',description:'Central NAT ID ',name:'fortinet.firewall.centralnatid',type:'integer'},'fortinet.firewall.cert':{category:'fortinet',description:'Certificate ',name:'fortinet.firewall.cert',type:'keyword'},'fortinet.firewall.cert-type':{category:'fortinet',description:'Certificate type ',name:'fortinet.firewall.cert-type',type:'keyword'},'fortinet.firewall.certhash':{category:'fortinet',description:'Certificate hash ',name:'fortinet.firewall.certhash',type:'keyword'},'fortinet.firewall.cfgattr':{category:'fortinet',description:'Configuration attribute ',name:'fortinet.firewall.cfgattr',type:'keyword'},'fortinet.firewall.cfgobj':{category:'fortinet',description:'Configuration object ',name:'fortinet.firewall.cfgobj',type:'keyword'},'fortinet.firewall.cfgpath':{category:'fortinet',description:'Configuration path ',name:'fortinet.firewall.cfgpath',type:'keyword'},'fortinet.firewall.cfgtid':{category:'fortinet',description:'Configuration transaction ID ',name:'fortinet.firewall.cfgtid',type:'keyword'},'fortinet.firewall.cfgtxpower':{category:'fortinet',description:'Configuration TX power ',name:'fortinet.firewall.cfgtxpower',type:'integer'},'fortinet.firewall.channel':{category:'fortinet',description:'Wireless Channel ',name:'fortinet.firewall.channel',type:'integer'},'fortinet.firewall.channeltype':{category:'fortinet',description:'SSH channel type ',name:'fortinet.firewall.channeltype',type:'keyword'},'fortinet.firewall.chassisid':{category:'fortinet',description:'Chassis ID ',name:'fortinet.firewall.chassisid',type:'integer'},'fortinet.firewall.checksum':{category:'fortinet',description:'The checksum of the scanned file ',name:'fortinet.firewall.checksum',type:'keyword'},'fortinet.firewall.chgheaders':{category:'fortinet',description:'HTTP Headers ',name:'fortinet.firewall.chgheaders',type:'keyword'},'fortinet.firewall.cldobjid':{category:'fortinet',description:'Connector object ID ',name:'fortinet.firewall.cldobjid',type:'keyword'},'fortinet.firewall.client_addr':{category:'fortinet',description:'Wifi client address ',name:'fortinet.firewall.client_addr',type:'keyword'},'fortinet.firewall.cloudaction':{category:'fortinet',description:'Cloud Action ',name:'fortinet.firewall.cloudaction',type:'keyword'},'fortinet.firewall.clouduser':{category:'fortinet',description:'Cloud User ',name:'fortinet.firewall.clouduser',type:'keyword'},'fortinet.firewall.column':{category:'fortinet',description:'VOIP Column ',name:'fortinet.firewall.column',type:'integer'},'fortinet.firewall.command':{category:'fortinet',description:'CLI Command ',name:'fortinet.firewall.command',type:'keyword'},'fortinet.firewall.community':{category:'fortinet',description:'SNMP Community ',name:'fortinet.firewall.community',type:'keyword'},'fortinet.firewall.configcountry':{category:'fortinet',description:'Configuration country ',name:'fortinet.firewall.configcountry',type:'keyword'},'fortinet.firewall.connection_type':{category:'fortinet',description:'FortiClient Connection Type ',name:'fortinet.firewall.connection_type',type:'keyword'},'fortinet.firewall.conserve':{category:'fortinet',description:'Flag for conserve mode ',name:'fortinet.firewall.conserve',type:'keyword'},'fortinet.firewall.constraint':{category:'fortinet',description:'WAF http protocol restrictions ',name:'fortinet.firewall.constraint',type:'keyword'},'fortinet.firewall.contentdisarmed':{category:'fortinet',description:'Email scanned content ',name:'fortinet.firewall.contentdisarmed',type:'keyword'},'fortinet.firewall.contenttype':{category:'fortinet',description:'Content Type from HTTP header ',name:'fortinet.firewall.contenttype',type:'keyword'},'fortinet.firewall.cookies':{category:'fortinet',description:'VPN Cookie ',name:'fortinet.firewall.cookies',type:'keyword'},'fortinet.firewall.count':{category:'fortinet',description:'Counts of action type ',name:'fortinet.firewall.count',type:'integer'},'fortinet.firewall.countapp':{category:'fortinet',description:'Number of App Ctrl logs associated with the session ',name:'fortinet.firewall.countapp',type:'integer'},'fortinet.firewall.countav':{category:'fortinet',description:'Number of AV logs associated with the session ',name:'fortinet.firewall.countav',type:'integer'},'fortinet.firewall.countcifs':{category:'fortinet',description:'Number of CIFS logs associated with the session ',name:'fortinet.firewall.countcifs',type:'integer'},'fortinet.firewall.countdlp':{category:'fortinet',description:'Number of DLP logs associated with the session ',name:'fortinet.firewall.countdlp',type:'integer'},'fortinet.firewall.countdns':{category:'fortinet',description:'Number of DNS logs associated with the session ',name:'fortinet.firewall.countdns',type:'integer'},'fortinet.firewall.countemail':{category:'fortinet',description:'Number of email logs associated with the session ',name:'fortinet.firewall.countemail',type:'integer'},'fortinet.firewall.countff':{category:'fortinet',description:'Number of ff logs associated with the session ',name:'fortinet.firewall.countff',type:'integer'},'fortinet.firewall.countips':{category:'fortinet',description:'Number of IPS logs associated with the session ',name:'fortinet.firewall.countips',type:'integer'},'fortinet.firewall.countssh':{category:'fortinet',description:'Number of SSH logs associated with the session ',name:'fortinet.firewall.countssh',type:'integer'},'fortinet.firewall.countssl':{category:'fortinet',description:'Number of SSL logs associated with the session ',name:'fortinet.firewall.countssl',type:'integer'},'fortinet.firewall.countwaf':{category:'fortinet',description:'Number of WAF logs associated with the session ',name:'fortinet.firewall.countwaf',type:'integer'},'fortinet.firewall.countweb':{category:'fortinet',description:'Number of Web filter logs associated with the session ',name:'fortinet.firewall.countweb',type:'integer'},'fortinet.firewall.cpu':{category:'fortinet',description:'CPU Usage ',name:'fortinet.firewall.cpu',type:'integer'},'fortinet.firewall.craction':{category:'fortinet',description:'Client Reputation Action ',name:'fortinet.firewall.craction',type:'integer'},'fortinet.firewall.criticalcount':{category:'fortinet',description:'Number of critical ratings ',name:'fortinet.firewall.criticalcount',type:'integer'},'fortinet.firewall.crl':{category:'fortinet',description:'Client Reputation Level ',name:'fortinet.firewall.crl',type:'keyword'},'fortinet.firewall.crlevel':{category:'fortinet',description:'Client Reputation Level ',name:'fortinet.firewall.crlevel',type:'keyword'},'fortinet.firewall.crscore':{category:'fortinet',description:'Some description ',name:'fortinet.firewall.crscore',type:'integer'},'fortinet.firewall.cveid':{category:'fortinet',description:'CVE ID ',name:'fortinet.firewall.cveid',type:'keyword'},'fortinet.firewall.daemon':{category:'fortinet',description:'Daemon name ',name:'fortinet.firewall.daemon',type:'keyword'},'fortinet.firewall.datarange':{category:'fortinet',description:'Data range for reports ',name:'fortinet.firewall.datarange',type:'keyword'},'fortinet.firewall.date':{category:'fortinet',description:'Date ',name:'fortinet.firewall.date',type:'keyword'},'fortinet.firewall.ddnsserver':{category:'fortinet',description:'DDNS server ',name:'fortinet.firewall.ddnsserver',type:'ip'},'fortinet.firewall.desc':{category:'fortinet',description:'Description ',name:'fortinet.firewall.desc',type:'keyword'},'fortinet.firewall.detectionmethod':{category:'fortinet',description:'Detection method ',name:'fortinet.firewall.detectionmethod',type:'keyword'},'fortinet.firewall.devcategory':{category:'fortinet',description:'Device category ',name:'fortinet.firewall.devcategory',type:'keyword'},'fortinet.firewall.devintfname':{category:'fortinet',description:'HA device Interface Name ',name:'fortinet.firewall.devintfname',type:'keyword'},'fortinet.firewall.devtype':{category:'fortinet',description:'Device type ',name:'fortinet.firewall.devtype',type:'keyword'},'fortinet.firewall.dhcp_msg':{category:'fortinet',description:'DHCP Message ',name:'fortinet.firewall.dhcp_msg',type:'keyword'},'fortinet.firewall.dintf':{category:'fortinet',description:'Destination interface ',name:'fortinet.firewall.dintf',type:'keyword'},'fortinet.firewall.disk':{category:'fortinet',description:'Assosciated disk ',name:'fortinet.firewall.disk',type:'keyword'},'fortinet.firewall.disklograte':{category:'fortinet',description:'Disk logging rate ',name:'fortinet.firewall.disklograte',type:'long'},'fortinet.firewall.dlpextra':{category:'fortinet',description:'DLP extra information ',name:'fortinet.firewall.dlpextra',type:'keyword'},'fortinet.firewall.docsource':{category:'fortinet',description:'DLP fingerprint document source ',name:'fortinet.firewall.docsource',type:'keyword'},'fortinet.firewall.domainctrlauthstate':{category:'fortinet',description:'CIFS domain auth state ',name:'fortinet.firewall.domainctrlauthstate',type:'integer'},'fortinet.firewall.domainctrlauthtype':{category:'fortinet',description:'CIFS domain auth type ',name:'fortinet.firewall.domainctrlauthtype',type:'integer'},'fortinet.firewall.domainctrldomain':{category:'fortinet',description:'CIFS domain auth domain ',name:'fortinet.firewall.domainctrldomain',type:'keyword'},'fortinet.firewall.domainctrlip':{category:'fortinet',description:'CIFS Domain IP ',name:'fortinet.firewall.domainctrlip',type:'ip'},'fortinet.firewall.domainctrlname':{category:'fortinet',description:'CIFS Domain name ',name:'fortinet.firewall.domainctrlname',type:'keyword'},'fortinet.firewall.domainctrlprotocoltype':{category:'fortinet',description:'CIFS Domain connection protocol ',name:'fortinet.firewall.domainctrlprotocoltype',type:'integer'},'fortinet.firewall.domainctrlusername':{category:'fortinet',description:'CIFS Domain username ',name:'fortinet.firewall.domainctrlusername',type:'keyword'},'fortinet.firewall.domainfilteridx':{category:'fortinet',description:'Domain filter ID ',name:'fortinet.firewall.domainfilteridx',type:'integer'},'fortinet.firewall.domainfilterlist':{category:'fortinet',description:'Domain filter name ',name:'fortinet.firewall.domainfilterlist',type:'keyword'},'fortinet.firewall.ds':{category:'fortinet',description:'Direction with distribution system ',name:'fortinet.firewall.ds',type:'keyword'},'fortinet.firewall.dst_int':{category:'fortinet',description:'Destination interface ',name:'fortinet.firewall.dst_int',type:'keyword'},'fortinet.firewall.dstintfrole':{category:'fortinet',description:'Destination interface role ',name:'fortinet.firewall.dstintfrole',type:'keyword'},'fortinet.firewall.dstcountry':{category:'fortinet',description:'Destination country ',name:'fortinet.firewall.dstcountry',type:'keyword'},'fortinet.firewall.dstdevcategory':{category:'fortinet',description:'Destination device category ',name:'fortinet.firewall.dstdevcategory',type:'keyword'},'fortinet.firewall.dstdevtype':{category:'fortinet',description:'Destination device type ',name:'fortinet.firewall.dstdevtype',type:'keyword'},'fortinet.firewall.dstfamily':{category:'fortinet',description:'Destination OS family ',name:'fortinet.firewall.dstfamily',type:'keyword'},'fortinet.firewall.dsthwvendor':{category:'fortinet',description:'Destination HW vendor ',name:'fortinet.firewall.dsthwvendor',type:'keyword'},'fortinet.firewall.dsthwversion':{category:'fortinet',description:'Destination HW version ',name:'fortinet.firewall.dsthwversion',type:'keyword'},'fortinet.firewall.dstinetsvc':{category:'fortinet',description:'Destination interface service ',name:'fortinet.firewall.dstinetsvc',type:'keyword'},'fortinet.firewall.dstosname':{category:'fortinet',description:'Destination OS name ',name:'fortinet.firewall.dstosname',type:'keyword'},'fortinet.firewall.dstosversion':{category:'fortinet',description:'Destination OS version ',name:'fortinet.firewall.dstosversion',type:'keyword'},'fortinet.firewall.dstserver':{category:'fortinet',description:'Destination server ',name:'fortinet.firewall.dstserver',type:'integer'},'fortinet.firewall.dstssid':{category:'fortinet',description:'Destination SSID ',name:'fortinet.firewall.dstssid',type:'keyword'},'fortinet.firewall.dstswversion':{category:'fortinet',description:'Destination software version ',name:'fortinet.firewall.dstswversion',type:'keyword'},'fortinet.firewall.dstunauthusersource':{category:'fortinet',description:'Destination unauthenticated source ',name:'fortinet.firewall.dstunauthusersource',type:'keyword'},'fortinet.firewall.dstuuid':{category:'fortinet',description:'UUID of the Destination IP address ',name:'fortinet.firewall.dstuuid',type:'keyword'},'fortinet.firewall.duid':{category:'fortinet',description:'DHCP UID ',name:'fortinet.firewall.duid',type:'keyword'},'fortinet.firewall.eapolcnt':{category:'fortinet',description:'EAPOL packet count ',name:'fortinet.firewall.eapolcnt',type:'integer'},'fortinet.firewall.eapoltype':{category:'fortinet',description:'EAPOL packet type ',name:'fortinet.firewall.eapoltype',type:'keyword'},'fortinet.firewall.encrypt':{category:'fortinet',description:'Whether the packet is encrypted or not ',name:'fortinet.firewall.encrypt',type:'integer'},'fortinet.firewall.encryption':{category:'fortinet',description:'Encryption method ',name:'fortinet.firewall.encryption',type:'keyword'},'fortinet.firewall.epoch':{category:'fortinet',description:'Epoch used for locating file ',name:'fortinet.firewall.epoch',type:'integer'},'fortinet.firewall.espauth':{category:'fortinet',description:'ESP Authentication ',name:'fortinet.firewall.espauth',type:'keyword'},'fortinet.firewall.esptransform':{category:'fortinet',description:'ESP Transform ',name:'fortinet.firewall.esptransform',type:'keyword'},'fortinet.firewall.exch':{category:'fortinet',description:'Mail Exchanges from DNS response answer section ',name:'fortinet.firewall.exch',type:'keyword'},'fortinet.firewall.exchange':{category:'fortinet',description:'Mail Exchanges from DNS response answer section ',name:'fortinet.firewall.exchange',type:'keyword'},'fortinet.firewall.expectedsignature':{category:'fortinet',description:'Expected SSL signature ',name:'fortinet.firewall.expectedsignature',type:'keyword'},'fortinet.firewall.expiry':{category:'fortinet',description:'FortiGuard override expiry timestamp ',name:'fortinet.firewall.expiry',type:'keyword'},'fortinet.firewall.fams_pause':{category:'fortinet',description:'Fortinet Analysis and Management Service Pause ',name:'fortinet.firewall.fams_pause',type:'integer'},'fortinet.firewall.fazlograte':{category:'fortinet',description:'FortiAnalyzer Logging Rate ',name:'fortinet.firewall.fazlograte',type:'long'},'fortinet.firewall.fctemssn':{category:'fortinet',description:'FortiClient Endpoint SSN ',name:'fortinet.firewall.fctemssn',type:'keyword'},'fortinet.firewall.fctuid':{category:'fortinet',description:'FortiClient UID ',name:'fortinet.firewall.fctuid',type:'keyword'},'fortinet.firewall.field':{category:'fortinet',description:'NTP status field ',name:'fortinet.firewall.field',type:'keyword'},'fortinet.firewall.filefilter':{category:'fortinet',description:'The filter used to identify the affected file ',name:'fortinet.firewall.filefilter',type:'keyword'},'fortinet.firewall.filehashsrc':{category:'fortinet',description:'Filehash source ',name:'fortinet.firewall.filehashsrc',type:'keyword'},'fortinet.firewall.filtercat':{category:'fortinet',description:'DLP filter category ',name:'fortinet.firewall.filtercat',type:'keyword'},'fortinet.firewall.filteridx':{category:'fortinet',description:'DLP filter ID ',name:'fortinet.firewall.filteridx',type:'integer'},'fortinet.firewall.filtername':{category:'fortinet',description:'DLP rule name ',name:'fortinet.firewall.filtername',type:'keyword'},'fortinet.firewall.filtertype':{category:'fortinet',description:'DLP filter type ',name:'fortinet.firewall.filtertype',type:'keyword'},'fortinet.firewall.fortiguardresp':{category:'fortinet',description:'Antispam ESP value ',name:'fortinet.firewall.fortiguardresp',type:'keyword'},'fortinet.firewall.forwardedfor':{category:'fortinet',description:'Email address forwarded ',name:'fortinet.firewall.forwardedfor',type:'keyword'},'fortinet.firewall.fqdn':{category:'fortinet',description:'FQDN ',name:'fortinet.firewall.fqdn',type:'keyword'},'fortinet.firewall.frametype':{category:'fortinet',description:'Wireless frametype ',name:'fortinet.firewall.frametype',type:'keyword'},'fortinet.firewall.freediskstorage':{category:'fortinet',description:'Free disk integer ',name:'fortinet.firewall.freediskstorage',type:'integer'},'fortinet.firewall.from':{category:'fortinet',description:'From email address ',name:'fortinet.firewall.from',type:'keyword'},'fortinet.firewall.from_vcluster':{category:'fortinet',description:'Source virtual cluster number ',name:'fortinet.firewall.from_vcluster',type:'integer'},'fortinet.firewall.fsaverdict':{category:'fortinet',description:'FSA verdict ',name:'fortinet.firewall.fsaverdict',type:'keyword'},'fortinet.firewall.fwserver_name':{category:'fortinet',description:'Web proxy server name ',name:'fortinet.firewall.fwserver_name',type:'keyword'},'fortinet.firewall.gateway':{category:'fortinet',description:'Gateway ip address for PPPoE status report ',name:'fortinet.firewall.gateway',type:'ip'},'fortinet.firewall.green':{category:'fortinet',description:'Memory status ',name:'fortinet.firewall.green',type:'keyword'},'fortinet.firewall.groupid':{category:'fortinet',description:'User Group ID ',name:'fortinet.firewall.groupid',type:'integer'},'fortinet.firewall.ha-prio':{category:'fortinet',description:'HA Priority ',name:'fortinet.firewall.ha-prio',type:'integer'},'fortinet.firewall.ha_group':{category:'fortinet',description:'HA Group ',name:'fortinet.firewall.ha_group',type:'keyword'},'fortinet.firewall.ha_role':{category:'fortinet',description:'HA Role ',name:'fortinet.firewall.ha_role',type:'keyword'},'fortinet.firewall.handshake':{category:'fortinet',description:'SSL Handshake ',name:'fortinet.firewall.handshake',type:'keyword'},'fortinet.firewall.hash':{category:'fortinet',description:'Hash value of downloaded file ',name:'fortinet.firewall.hash',type:'keyword'},'fortinet.firewall.hbdn_reason':{category:'fortinet',description:'Heartbeat down reason ',name:'fortinet.firewall.hbdn_reason',type:'keyword'},'fortinet.firewall.highcount':{category:'fortinet',description:'Highcount fabric summary ',name:'fortinet.firewall.highcount',type:'integer'},'fortinet.firewall.host':{category:'fortinet',description:'Hostname ',name:'fortinet.firewall.host',type:'keyword'},'fortinet.firewall.iaid':{category:'fortinet',description:'DHCPv6 id ',name:'fortinet.firewall.iaid',type:'keyword'},'fortinet.firewall.icmpcode':{category:'fortinet',description:'Destination Port of the ICMP message ',name:'fortinet.firewall.icmpcode',type:'keyword'},'fortinet.firewall.icmpid':{category:'fortinet',description:'Source port of the ICMP message ',name:'fortinet.firewall.icmpid',type:'keyword'},'fortinet.firewall.icmptype':{category:'fortinet',description:'The type of ICMP message ',name:'fortinet.firewall.icmptype',type:'keyword'},'fortinet.firewall.identifier':{category:'fortinet',description:'Network traffic identifier ',name:'fortinet.firewall.identifier',type:'integer'},'fortinet.firewall.in_spi':{category:'fortinet',description:'IPSEC inbound SPI ',name:'fortinet.firewall.in_spi',type:'keyword'},'fortinet.firewall.incidentserialno':{category:'fortinet',description:'Incident serial number ',name:'fortinet.firewall.incidentserialno',type:'integer'},'fortinet.firewall.infected':{category:'fortinet',description:'Infected MMS ',name:'fortinet.firewall.infected',type:'integer'},'fortinet.firewall.infectedfilelevel':{category:'fortinet',description:'DLP infected file level ',name:'fortinet.firewall.infectedfilelevel',type:'integer'},'fortinet.firewall.informationsource':{category:'fortinet',description:'Information source ',name:'fortinet.firewall.informationsource',type:'keyword'},'fortinet.firewall.init':{category:'fortinet',description:'IPSEC init stage ',name:'fortinet.firewall.init',type:'keyword'},'fortinet.firewall.initiator':{category:'fortinet',description:'Original login user name for Fortiguard override ',name:'fortinet.firewall.initiator',type:'keyword'},'fortinet.firewall.interface':{category:'fortinet',description:'Related interface ',name:'fortinet.firewall.interface',type:'keyword'},'fortinet.firewall.intf':{category:'fortinet',description:'Related interface ',name:'fortinet.firewall.intf',type:'keyword'},'fortinet.firewall.invalidmac':{category:'fortinet',description:'The MAC address with invalid OUI ',name:'fortinet.firewall.invalidmac',type:'keyword'},'fortinet.firewall.ip':{category:'fortinet',description:'Related IP ',name:'fortinet.firewall.ip',type:'ip'},'fortinet.firewall.iptype':{category:'fortinet',description:'Related IP type ',name:'fortinet.firewall.iptype',type:'keyword'},'fortinet.firewall.keyword':{category:'fortinet',description:'Keyword used for search ',name:'fortinet.firewall.keyword',type:'keyword'},'fortinet.firewall.kind':{category:'fortinet',description:'VOIP kind ',name:'fortinet.firewall.kind',type:'keyword'},'fortinet.firewall.lanin':{category:'fortinet',description:'LAN incoming traffic in bytes ',name:'fortinet.firewall.lanin',type:'long'},'fortinet.firewall.lanout':{category:'fortinet',description:'LAN outbound traffic in bytes ',name:'fortinet.firewall.lanout',type:'long'},'fortinet.firewall.lease':{category:'fortinet',description:'DHCP lease ',name:'fortinet.firewall.lease',type:'integer'},'fortinet.firewall.license_limit':{category:'fortinet',description:'Maximum Number of FortiClients for the License ',name:'fortinet.firewall.license_limit',type:'keyword'},'fortinet.firewall.limit':{category:'fortinet',description:'Virtual Domain Resource Limit ',name:'fortinet.firewall.limit',type:'integer'},'fortinet.firewall.line':{category:'fortinet',description:'VOIP line ',name:'fortinet.firewall.line',type:'keyword'},'fortinet.firewall.live':{category:'fortinet',description:'Time in seconds ',name:'fortinet.firewall.live',type:'integer'},'fortinet.firewall.local':{category:'fortinet',description:'Local IP for a PPPD Connection ',name:'fortinet.firewall.local',type:'ip'},'fortinet.firewall.log':{category:'fortinet',description:'Log message ',name:'fortinet.firewall.log',type:'keyword'},'fortinet.firewall.login':{category:'fortinet',description:'SSH login ',name:'fortinet.firewall.login',type:'keyword'},'fortinet.firewall.lowcount':{category:'fortinet',description:'Fabric lowcount ',name:'fortinet.firewall.lowcount',type:'integer'},'fortinet.firewall.mac':{category:'fortinet',description:'DHCP mac address ',name:'fortinet.firewall.mac',type:'keyword'},'fortinet.firewall.malform_data':{category:'fortinet',description:'VOIP malformed data ',name:'fortinet.firewall.malform_data',type:'integer'},'fortinet.firewall.malform_desc':{category:'fortinet',description:'VOIP malformed data description ',name:'fortinet.firewall.malform_desc',type:'keyword'},'fortinet.firewall.manuf':{category:'fortinet',description:'Manufacturer name ',name:'fortinet.firewall.manuf',type:'keyword'},'fortinet.firewall.masterdstmac':{category:'fortinet',description:'Master mac address for a host with multiple network interfaces ',name:'fortinet.firewall.masterdstmac',type:'keyword'},'fortinet.firewall.mastersrcmac':{category:'fortinet',description:'The master MAC address for a host that has multiple network interfaces ',name:'fortinet.firewall.mastersrcmac',type:'keyword'},'fortinet.firewall.mediumcount':{category:'fortinet',description:'Fabric medium count ',name:'fortinet.firewall.mediumcount',type:'integer'},'fortinet.firewall.mem':{category:'fortinet',description:'Memory usage system statistics ',name:'fortinet.firewall.mem',type:'keyword'},'fortinet.firewall.meshmode':{category:'fortinet',description:'Wireless mesh mode ',name:'fortinet.firewall.meshmode',type:'keyword'},'fortinet.firewall.message_type':{category:'fortinet',description:'VOIP message type ',name:'fortinet.firewall.message_type',type:'keyword'},'fortinet.firewall.method':{category:'fortinet',description:'HTTP method ',name:'fortinet.firewall.method',type:'keyword'},'fortinet.firewall.mgmtcnt':{category:'fortinet',description:'The number of unauthorized client flooding managemet frames ',name:'fortinet.firewall.mgmtcnt',type:'integer'},'fortinet.firewall.mode':{category:'fortinet',description:'IPSEC mode ',name:'fortinet.firewall.mode',type:'keyword'},'fortinet.firewall.module':{category:'fortinet',description:'PCI-DSS module ',name:'fortinet.firewall.module',type:'keyword'},'fortinet.firewall.monitor-name':{category:'fortinet',description:'Health Monitor Name ',name:'fortinet.firewall.monitor-name',type:'keyword'},'fortinet.firewall.monitor-type':{category:'fortinet',description:'Health Monitor Type ',name:'fortinet.firewall.monitor-type',type:'keyword'},'fortinet.firewall.mpsk':{category:'fortinet',description:'Wireless MPSK ',name:'fortinet.firewall.mpsk',type:'keyword'},'fortinet.firewall.msgproto':{category:'fortinet',description:'Message Protocol Number ',name:'fortinet.firewall.msgproto',type:'keyword'},'fortinet.firewall.mtu':{category:'fortinet',description:'Max Transmission Unit Value ',name:'fortinet.firewall.mtu',type:'integer'},'fortinet.firewall.name':{category:'fortinet',description:'Name ',name:'fortinet.firewall.name',type:'keyword'},'fortinet.firewall.nat':{category:'fortinet',description:'NAT IP Address ',name:'fortinet.firewall.nat',type:'keyword'},'fortinet.firewall.netid':{category:'fortinet',description:'Connector NetID ',name:'fortinet.firewall.netid',type:'keyword'},'fortinet.firewall.new_status':{category:'fortinet',description:'New status on user change ',name:'fortinet.firewall.new_status',type:'keyword'},'fortinet.firewall.new_value':{category:'fortinet',description:'New Virtual Domain Name ',name:'fortinet.firewall.new_value',type:'keyword'},'fortinet.firewall.newchannel':{category:'fortinet',description:'New Channel Number ',name:'fortinet.firewall.newchannel',type:'integer'},'fortinet.firewall.newchassisid':{category:'fortinet',description:'New Chassis ID ',name:'fortinet.firewall.newchassisid',type:'integer'},'fortinet.firewall.newslot':{category:'fortinet',description:'New Slot Number ',name:'fortinet.firewall.newslot',type:'integer'},'fortinet.firewall.nextstat':{category:'fortinet',description:'Time interval in seconds for the next statistics. ',name:'fortinet.firewall.nextstat',type:'integer'},'fortinet.firewall.nf_type':{category:'fortinet',description:'Notification Type ',name:'fortinet.firewall.nf_type',type:'keyword'},'fortinet.firewall.noise':{category:'fortinet',description:'Wifi Noise ',name:'fortinet.firewall.noise',type:'integer'},'fortinet.firewall.old_status':{category:'fortinet',description:'Original Status ',name:'fortinet.firewall.old_status',type:'keyword'},'fortinet.firewall.old_value':{category:'fortinet',description:'Original Virtual Domain name ',name:'fortinet.firewall.old_value',type:'keyword'},'fortinet.firewall.oldchannel':{category:'fortinet',description:'Original channel ',name:'fortinet.firewall.oldchannel',type:'integer'},'fortinet.firewall.oldchassisid':{category:'fortinet',description:'Original Chassis Number ',name:'fortinet.firewall.oldchassisid',type:'integer'},'fortinet.firewall.oldslot':{category:'fortinet',description:'Original Slot Number ',name:'fortinet.firewall.oldslot',type:'integer'},'fortinet.firewall.oldsn':{category:'fortinet',description:'Old Serial number ',name:'fortinet.firewall.oldsn',type:'keyword'},'fortinet.firewall.oldwprof':{category:'fortinet',description:'Old Web Filter Profile ',name:'fortinet.firewall.oldwprof',type:'keyword'},'fortinet.firewall.onwire':{category:'fortinet',description:'A flag to indicate if the AP is onwire or not ',name:'fortinet.firewall.onwire',type:'keyword'},'fortinet.firewall.opercountry':{category:'fortinet',description:'Operating Country ',name:'fortinet.firewall.opercountry',type:'keyword'},'fortinet.firewall.opertxpower':{category:'fortinet',description:'Operating TX power ',name:'fortinet.firewall.opertxpower',type:'integer'},'fortinet.firewall.osname':{category:'fortinet',description:'Operating System name ',name:'fortinet.firewall.osname',type:'keyword'},'fortinet.firewall.osversion':{category:'fortinet',description:'Operating System version ',name:'fortinet.firewall.osversion',type:'keyword'},'fortinet.firewall.out_spi':{category:'fortinet',description:'Out SPI ',name:'fortinet.firewall.out_spi',type:'keyword'},'fortinet.firewall.outintf':{category:'fortinet',description:'Out interface ',name:'fortinet.firewall.outintf',type:'keyword'},'fortinet.firewall.passedcount':{category:'fortinet',description:'Fabric passed count ',name:'fortinet.firewall.passedcount',type:'integer'},'fortinet.firewall.passwd':{category:'fortinet',description:'Changed user password information ',name:'fortinet.firewall.passwd',type:'keyword'},'fortinet.firewall.path':{category:'fortinet',description:'Path of looped configuration for security fabric ',name:'fortinet.firewall.path',type:'keyword'},'fortinet.firewall.peer':{category:'fortinet',description:'WAN optimization peer ',name:'fortinet.firewall.peer',type:'keyword'},'fortinet.firewall.peer_notif':{category:'fortinet',description:'VPN peer notification ',name:'fortinet.firewall.peer_notif',type:'keyword'},'fortinet.firewall.phase2_name':{category:'fortinet',description:'VPN phase2 name ',name:'fortinet.firewall.phase2_name',type:'keyword'},'fortinet.firewall.phone':{category:'fortinet',description:'VOIP Phone ',name:'fortinet.firewall.phone',type:'keyword'},'fortinet.firewall.pid':{category:'fortinet',description:'Process ID ',name:'fortinet.firewall.pid',type:'integer'},'fortinet.firewall.policytype':{category:'fortinet',description:'Policy Type ',name:'fortinet.firewall.policytype',type:'keyword'},'fortinet.firewall.poolname':{category:'fortinet',description:'IP Pool name ',name:'fortinet.firewall.poolname',type:'keyword'},'fortinet.firewall.port':{category:'fortinet',description:'Log upload error port ',name:'fortinet.firewall.port',type:'integer'},'fortinet.firewall.portbegin':{category:'fortinet',description:'IP Pool port number to begin ',name:'fortinet.firewall.portbegin',type:'integer'},'fortinet.firewall.portend':{category:'fortinet',description:'IP Pool port number to end ',name:'fortinet.firewall.portend',type:'integer'},'fortinet.firewall.probeproto':{category:'fortinet',description:'Link Monitor Probe Protocol ',name:'fortinet.firewall.probeproto',type:'keyword'},'fortinet.firewall.process':{category:'fortinet',description:'URL Filter process ',name:'fortinet.firewall.process',type:'keyword'},'fortinet.firewall.processtime':{category:'fortinet',description:'Process time for reports ',name:'fortinet.firewall.processtime',type:'integer'},'fortinet.firewall.profile':{category:'fortinet',description:'Profile Name ',name:'fortinet.firewall.profile',type:'keyword'},'fortinet.firewall.profile_vd':{category:'fortinet',description:'Virtual Domain Name ',name:'fortinet.firewall.profile_vd',type:'keyword'},'fortinet.firewall.profilegroup':{category:'fortinet',description:'Profile Group Name ',name:'fortinet.firewall.profilegroup',type:'keyword'},'fortinet.firewall.profiletype':{category:'fortinet',description:'Profile Type ',name:'fortinet.firewall.profiletype',type:'keyword'},'fortinet.firewall.qtypeval':{category:'fortinet',description:'DNS question type value ',name:'fortinet.firewall.qtypeval',type:'integer'},'fortinet.firewall.quarskip':{category:'fortinet',description:'Quarantine skip explanation ',name:'fortinet.firewall.quarskip',type:'keyword'},'fortinet.firewall.quotaexceeded':{category:'fortinet',description:'If quota has been exceeded ',name:'fortinet.firewall.quotaexceeded',type:'keyword'},'fortinet.firewall.quotamax':{category:'fortinet',description:'Maximum quota allowed - in seconds if time-based - in bytes if traffic-based ',name:'fortinet.firewall.quotamax',type:'long'},'fortinet.firewall.quotatype':{category:'fortinet',description:'Quota type ',name:'fortinet.firewall.quotatype',type:'keyword'},'fortinet.firewall.quotaused':{category:'fortinet',description:'Quota used - in seconds if time-based - in bytes if trafficbased) ',name:'fortinet.firewall.quotaused',type:'long'},'fortinet.firewall.radioband':{category:'fortinet',description:'Radio band ',name:'fortinet.firewall.radioband',type:'keyword'},'fortinet.firewall.radioid':{category:'fortinet',description:'Radio ID ',name:'fortinet.firewall.radioid',type:'integer'},'fortinet.firewall.radioidclosest':{category:'fortinet',description:'Radio ID on the AP closest the rogue AP ',name:'fortinet.firewall.radioidclosest',type:'integer'},'fortinet.firewall.radioiddetected':{category:'fortinet',description:'Radio ID on the AP which detected the rogue AP ',name:'fortinet.firewall.radioiddetected',type:'integer'},'fortinet.firewall.rate':{category:'fortinet',description:'Wireless rogue rate value ',name:'fortinet.firewall.rate',type:'keyword'},'fortinet.firewall.rawdata':{category:'fortinet',description:'Raw data value ',name:'fortinet.firewall.rawdata',type:'keyword'},'fortinet.firewall.rawdataid':{category:'fortinet',description:'Raw data ID ',name:'fortinet.firewall.rawdataid',type:'keyword'},'fortinet.firewall.rcvddelta':{category:'fortinet',description:'Received bytes delta ',name:'fortinet.firewall.rcvddelta',type:'keyword'},'fortinet.firewall.reason':{category:'fortinet',description:'Alert reason ',name:'fortinet.firewall.reason',type:'keyword'},'fortinet.firewall.received':{category:'fortinet',description:'Server key exchange received ',name:'fortinet.firewall.received',type:'integer'},'fortinet.firewall.receivedsignature':{category:'fortinet',description:'Server key exchange received signature ',name:'fortinet.firewall.receivedsignature',type:'keyword'},'fortinet.firewall.red':{category:'fortinet',description:'Memory information in red ',name:'fortinet.firewall.red',type:'keyword'},'fortinet.firewall.referralurl':{category:'fortinet',description:'Web filter referralurl ',name:'fortinet.firewall.referralurl',type:'keyword'},'fortinet.firewall.remote':{category:'fortinet',description:'Remote PPP IP address ',name:'fortinet.firewall.remote',type:'ip'},'fortinet.firewall.remotewtptime':{category:'fortinet',description:'Remote Wifi Radius authentication time ',name:'fortinet.firewall.remotewtptime',type:'keyword'},'fortinet.firewall.reporttype':{category:'fortinet',description:'Report type ',name:'fortinet.firewall.reporttype',type:'keyword'},'fortinet.firewall.reqtype':{category:'fortinet',description:'Request type ',name:'fortinet.firewall.reqtype',type:'keyword'},'fortinet.firewall.request_name':{category:'fortinet',description:'VOIP request name ',name:'fortinet.firewall.request_name',type:'keyword'},'fortinet.firewall.result':{category:'fortinet',description:'VPN phase result ',name:'fortinet.firewall.result',type:'keyword'},'fortinet.firewall.role':{category:'fortinet',description:'VPN Phase 2 role ',name:'fortinet.firewall.role',type:'keyword'},'fortinet.firewall.rssi':{category:'fortinet',description:'Received signal strength indicator ',name:'fortinet.firewall.rssi',type:'integer'},'fortinet.firewall.rsso_key':{category:'fortinet',description:'RADIUS SSO attribute value ',name:'fortinet.firewall.rsso_key',type:'keyword'},'fortinet.firewall.ruledata':{category:'fortinet',description:'Rule data ',name:'fortinet.firewall.ruledata',type:'keyword'},'fortinet.firewall.ruletype':{category:'fortinet',description:'Rule type ',name:'fortinet.firewall.ruletype',type:'keyword'},'fortinet.firewall.scanned':{category:'fortinet',description:'Number of Scanned MMSs ',name:'fortinet.firewall.scanned',type:'integer'},'fortinet.firewall.scantime':{category:'fortinet',description:'Scanned time ',name:'fortinet.firewall.scantime',type:'long'},'fortinet.firewall.scope':{category:'fortinet',description:'FortiGuard Override Scope ',name:'fortinet.firewall.scope',type:'keyword'},'fortinet.firewall.security':{category:'fortinet',description:'Wireless rogue security ',name:'fortinet.firewall.security',type:'keyword'},'fortinet.firewall.sensitivity':{category:'fortinet',description:'Sensitivity for document fingerprint ',name:'fortinet.firewall.sensitivity',type:'keyword'},'fortinet.firewall.sensor':{category:'fortinet',description:'NAC Sensor Name ',name:'fortinet.firewall.sensor',type:'keyword'},'fortinet.firewall.sentdelta':{category:'fortinet',description:'Sent bytes delta ',name:'fortinet.firewall.sentdelta',type:'keyword'},'fortinet.firewall.seq':{category:'fortinet',description:'Sequence number ',name:'fortinet.firewall.seq',type:'keyword'},'fortinet.firewall.serial':{category:'fortinet',description:'WAN optimisation serial ',name:'fortinet.firewall.serial',type:'keyword'},'fortinet.firewall.serialno':{category:'fortinet',description:'Serial number ',name:'fortinet.firewall.serialno',type:'keyword'},'fortinet.firewall.server':{category:'fortinet',description:'AD server FQDN or IP ',name:'fortinet.firewall.server',type:'keyword'},'fortinet.firewall.session_id':{category:'fortinet',description:'Session ID ',name:'fortinet.firewall.session_id',type:'keyword'},'fortinet.firewall.sessionid':{category:'fortinet',description:'WAD Session ID ',name:'fortinet.firewall.sessionid',type:'integer'},'fortinet.firewall.setuprate':{category:'fortinet',description:'Session Setup Rate ',name:'fortinet.firewall.setuprate',type:'long'},'fortinet.firewall.severity':{category:'fortinet',description:'Severity ',name:'fortinet.firewall.severity',type:'keyword'},'fortinet.firewall.shaperdroprcvdbyte':{category:'fortinet',description:'Received bytes dropped by shaper ',name:'fortinet.firewall.shaperdroprcvdbyte',type:'integer'},'fortinet.firewall.shaperdropsentbyte':{category:'fortinet',description:'Sent bytes dropped by shaper ',name:'fortinet.firewall.shaperdropsentbyte',type:'integer'},'fortinet.firewall.shaperperipdropbyte':{category:'fortinet',description:'Dropped bytes per IP by shaper ',name:'fortinet.firewall.shaperperipdropbyte',type:'integer'},'fortinet.firewall.shaperperipname':{category:'fortinet',description:'Traffic shaper name (per IP) ',name:'fortinet.firewall.shaperperipname',type:'keyword'},'fortinet.firewall.shaperrcvdname':{category:'fortinet',description:'Traffic shaper name for received traffic ',name:'fortinet.firewall.shaperrcvdname',type:'keyword'},'fortinet.firewall.shapersentname':{category:'fortinet',description:'Traffic shaper name for sent traffic ',name:'fortinet.firewall.shapersentname',type:'keyword'},'fortinet.firewall.shapingpolicyid':{category:'fortinet',description:'Traffic shaper policy ID ',name:'fortinet.firewall.shapingpolicyid',type:'integer'},'fortinet.firewall.signal':{category:'fortinet',description:'Wireless rogue API signal ',name:'fortinet.firewall.signal',type:'integer'},'fortinet.firewall.size':{category:'fortinet',description:'Email size in bytes ',name:'fortinet.firewall.size',type:'long'},'fortinet.firewall.slot':{category:'fortinet',description:'Slot number ',name:'fortinet.firewall.slot',type:'integer'},'fortinet.firewall.sn':{category:'fortinet',description:'Security fabric serial number ',name:'fortinet.firewall.sn',type:'keyword'},'fortinet.firewall.snclosest':{category:'fortinet',description:'SN of the AP closest to the rogue AP ',name:'fortinet.firewall.snclosest',type:'keyword'},'fortinet.firewall.sndetected':{category:'fortinet',description:'SN of the AP which detected the rogue AP ',name:'fortinet.firewall.sndetected',type:'keyword'},'fortinet.firewall.snmeshparent':{category:'fortinet',description:'SN of the mesh parent ',name:'fortinet.firewall.snmeshparent',type:'keyword'},'fortinet.firewall.spi':{category:'fortinet',description:'IPSEC SPI ',name:'fortinet.firewall.spi',type:'keyword'},'fortinet.firewall.src_int':{category:'fortinet',description:'Source interface ',name:'fortinet.firewall.src_int',type:'keyword'},'fortinet.firewall.srcintfrole':{category:'fortinet',description:'Source interface role ',name:'fortinet.firewall.srcintfrole',type:'keyword'},'fortinet.firewall.srccountry':{category:'fortinet',description:'Source country ',name:'fortinet.firewall.srccountry',type:'keyword'},'fortinet.firewall.srcfamily':{category:'fortinet',description:'Source family ',name:'fortinet.firewall.srcfamily',type:'keyword'},'fortinet.firewall.srchwvendor':{category:'fortinet',description:'Source hardware vendor ',name:'fortinet.firewall.srchwvendor',type:'keyword'},'fortinet.firewall.srchwversion':{category:'fortinet',description:'Source hardware version ',name:'fortinet.firewall.srchwversion',type:'keyword'},'fortinet.firewall.srcinetsvc':{category:'fortinet',description:'Source interface service ',name:'fortinet.firewall.srcinetsvc',type:'keyword'},'fortinet.firewall.srcname':{category:'fortinet',description:'Source name ',name:'fortinet.firewall.srcname',type:'keyword'},'fortinet.firewall.srcserver':{category:'fortinet',description:'Source server ',name:'fortinet.firewall.srcserver',type:'integer'},'fortinet.firewall.srcssid':{category:'fortinet',description:'Source SSID ',name:'fortinet.firewall.srcssid',type:'keyword'},'fortinet.firewall.srcswversion':{category:'fortinet',description:'Source software version ',name:'fortinet.firewall.srcswversion',type:'keyword'},'fortinet.firewall.srcuuid':{category:'fortinet',description:'Source UUID ',name:'fortinet.firewall.srcuuid',type:'keyword'},'fortinet.firewall.sscname':{category:'fortinet',description:'SSC name ',name:'fortinet.firewall.sscname',type:'keyword'},'fortinet.firewall.ssid':{category:'fortinet',description:'Base Service Set ID ',name:'fortinet.firewall.ssid',type:'keyword'},'fortinet.firewall.sslaction':{category:'fortinet',description:'SSL Action ',name:'fortinet.firewall.sslaction',type:'keyword'},'fortinet.firewall.ssllocal':{category:'fortinet',description:'WAD SSL local ',name:'fortinet.firewall.ssllocal',type:'keyword'},'fortinet.firewall.sslremote':{category:'fortinet',description:'WAD SSL remote ',name:'fortinet.firewall.sslremote',type:'keyword'},'fortinet.firewall.stacount':{category:'fortinet',description:'Number of stations/clients ',name:'fortinet.firewall.stacount',type:'integer'},'fortinet.firewall.stage':{category:'fortinet',description:'IPSEC stage ',name:'fortinet.firewall.stage',type:'keyword'},'fortinet.firewall.stamac':{category:'fortinet',description:'802.1x station mac ',name:'fortinet.firewall.stamac',type:'keyword'},'fortinet.firewall.state':{category:'fortinet',description:'Admin login state ',name:'fortinet.firewall.state',type:'keyword'},'fortinet.firewall.status':{category:'fortinet',description:'Status ',name:'fortinet.firewall.status',type:'keyword'},'fortinet.firewall.stitch':{category:'fortinet',description:'Automation stitch triggered ',name:'fortinet.firewall.stitch',type:'keyword'},'fortinet.firewall.subject':{category:'fortinet',description:'Email subject ',name:'fortinet.firewall.subject',type:'keyword'},'fortinet.firewall.submodule':{category:'fortinet',description:'Configuration Sub-Module Name ',name:'fortinet.firewall.submodule',type:'keyword'},'fortinet.firewall.subservice':{category:'fortinet',description:'AV subservice ',name:'fortinet.firewall.subservice',type:'keyword'},'fortinet.firewall.subtype':{category:'fortinet',description:'Log subtype ',name:'fortinet.firewall.subtype',type:'keyword'},'fortinet.firewall.suspicious':{category:'fortinet',description:'Number of Suspicious MMSs ',name:'fortinet.firewall.suspicious',type:'integer'},'fortinet.firewall.switchproto':{category:'fortinet',description:'Protocol change information ',name:'fortinet.firewall.switchproto',type:'keyword'},'fortinet.firewall.sync_status':{category:'fortinet',description:'The sync status with the master ',name:'fortinet.firewall.sync_status',type:'keyword'},'fortinet.firewall.sync_type':{category:'fortinet',description:'The sync type with the master ',name:'fortinet.firewall.sync_type',type:'keyword'},'fortinet.firewall.sysuptime':{category:'fortinet',description:'System uptime ',name:'fortinet.firewall.sysuptime',type:'keyword'},'fortinet.firewall.tamac':{category:'fortinet',description:'the MAC address of Transmitter, if none, then Receiver ',name:'fortinet.firewall.tamac',type:'keyword'},'fortinet.firewall.threattype':{category:'fortinet',description:'WIDS threat type ',name:'fortinet.firewall.threattype',type:'keyword'},'fortinet.firewall.time':{category:'fortinet',description:'Time of the event ',name:'fortinet.firewall.time',type:'keyword'},'fortinet.firewall.to':{category:'fortinet',description:'Email to field ',name:'fortinet.firewall.to',type:'keyword'},'fortinet.firewall.to_vcluster':{category:'fortinet',description:'destination virtual cluster number ',name:'fortinet.firewall.to_vcluster',type:'integer'},'fortinet.firewall.total':{category:'fortinet',description:'Total memory ',name:'fortinet.firewall.total',type:'integer'},'fortinet.firewall.totalsession':{category:'fortinet',description:'Total Number of Sessions ',name:'fortinet.firewall.totalsession',type:'integer'},'fortinet.firewall.trace_id':{category:'fortinet',description:'Session clash trace ID ',name:'fortinet.firewall.trace_id',type:'keyword'},'fortinet.firewall.trandisp':{category:'fortinet',description:'NAT translation type ',name:'fortinet.firewall.trandisp',type:'keyword'},'fortinet.firewall.transid':{category:'fortinet',description:'HTTP transaction ID ',name:'fortinet.firewall.transid',type:'integer'},'fortinet.firewall.translationid':{category:'fortinet',description:'DNS filter transaltion ID ',name:'fortinet.firewall.translationid',type:'keyword'},'fortinet.firewall.trigger':{category:'fortinet',description:'Automation stitch trigger ',name:'fortinet.firewall.trigger',type:'keyword'},'fortinet.firewall.trueclntip':{category:'fortinet',description:'File filter true client IP ',name:'fortinet.firewall.trueclntip',type:'ip'},'fortinet.firewall.tunnelid':{category:'fortinet',description:'IPSEC tunnel ID ',name:'fortinet.firewall.tunnelid',type:'integer'},'fortinet.firewall.tunnelip':{category:'fortinet',description:'IPSEC tunnel IP ',name:'fortinet.firewall.tunnelip',type:'ip'},'fortinet.firewall.tunneltype':{category:'fortinet',description:'IPSEC tunnel type ',name:'fortinet.firewall.tunneltype',type:'keyword'},'fortinet.firewall.type':{category:'fortinet',description:'Module type ',name:'fortinet.firewall.type',type:'keyword'},'fortinet.firewall.ui':{category:'fortinet',description:'Admin authentication UI type ',name:'fortinet.firewall.ui',type:'keyword'},'fortinet.firewall.unauthusersource':{category:'fortinet',description:'Unauthenticated user source ',name:'fortinet.firewall.unauthusersource',type:'keyword'},'fortinet.firewall.unit':{category:'fortinet',description:'Power supply unit ',name:'fortinet.firewall.unit',type:'integer'},'fortinet.firewall.urlfilteridx':{category:'fortinet',description:'URL filter ID ',name:'fortinet.firewall.urlfilteridx',type:'integer'},'fortinet.firewall.urlfilterlist':{category:'fortinet',description:'URL filter list ',name:'fortinet.firewall.urlfilterlist',type:'keyword'},'fortinet.firewall.urlsource':{category:'fortinet',description:'URL filter source ',name:'fortinet.firewall.urlsource',type:'keyword'},'fortinet.firewall.urltype':{category:'fortinet',description:'URL filter type ',name:'fortinet.firewall.urltype',type:'keyword'},'fortinet.firewall.used':{category:'fortinet',description:'Number of Used IPs ',name:'fortinet.firewall.used',type:'integer'},'fortinet.firewall.used_for_type':{category:'fortinet',description:'Connection for the type ',name:'fortinet.firewall.used_for_type',type:'integer'},'fortinet.firewall.utmaction':{category:'fortinet',description:'Security action performed by UTM ',name:'fortinet.firewall.utmaction',type:'keyword'},'fortinet.firewall.vap':{category:'fortinet',description:'Virtual AP ',name:'fortinet.firewall.vap',type:'keyword'},'fortinet.firewall.vapmode':{category:'fortinet',description:'Virtual AP mode ',name:'fortinet.firewall.vapmode',type:'keyword'},'fortinet.firewall.vcluster':{category:'fortinet',description:'virtual cluster id ',name:'fortinet.firewall.vcluster',type:'integer'},'fortinet.firewall.vcluster_member':{category:'fortinet',description:'Virtual cluster member ',name:'fortinet.firewall.vcluster_member',type:'integer'},'fortinet.firewall.vcluster_state':{category:'fortinet',description:'Virtual cluster state ',name:'fortinet.firewall.vcluster_state',type:'keyword'},'fortinet.firewall.vd':{category:'fortinet',description:'Virtual Domain Name ',name:'fortinet.firewall.vd',type:'keyword'},'fortinet.firewall.vdname':{category:'fortinet',description:'Virtual Domain Name ',name:'fortinet.firewall.vdname',type:'keyword'},'fortinet.firewall.vendorurl':{category:'fortinet',description:'Vulnerability scan vendor name ',name:'fortinet.firewall.vendorurl',type:'keyword'},'fortinet.firewall.version':{category:'fortinet',description:'Version ',name:'fortinet.firewall.version',type:'keyword'},'fortinet.firewall.vip':{category:'fortinet',description:'Virtual IP ',name:'fortinet.firewall.vip',type:'keyword'},'fortinet.firewall.virus':{category:'fortinet',description:'Virus name ',name:'fortinet.firewall.virus',type:'keyword'},'fortinet.firewall.virusid':{category:'fortinet',description:'Virus ID (unique virus identifier) ',name:'fortinet.firewall.virusid',type:'integer'},'fortinet.firewall.voip_proto':{category:'fortinet',description:'VOIP protocol ',name:'fortinet.firewall.voip_proto',type:'keyword'},'fortinet.firewall.vpn':{category:'fortinet',description:'VPN description ',name:'fortinet.firewall.vpn',type:'keyword'},'fortinet.firewall.vpntunnel':{category:'fortinet',description:'IPsec Vpn Tunnel Name ',name:'fortinet.firewall.vpntunnel',type:'keyword'},'fortinet.firewall.vpntype':{category:'fortinet',description:'The type of the VPN tunnel ',name:'fortinet.firewall.vpntype',type:'keyword'},'fortinet.firewall.vrf':{category:'fortinet',description:'VRF number ',name:'fortinet.firewall.vrf',type:'integer'},'fortinet.firewall.vulncat':{category:'fortinet',description:'Vulnerability Category ',name:'fortinet.firewall.vulncat',type:'keyword'},'fortinet.firewall.vulnid':{category:'fortinet',description:'Vulnerability ID ',name:'fortinet.firewall.vulnid',type:'integer'},'fortinet.firewall.vulnname':{category:'fortinet',description:'Vulnerability name ',name:'fortinet.firewall.vulnname',type:'keyword'},'fortinet.firewall.vwlid':{category:'fortinet',description:'VWL ID ',name:'fortinet.firewall.vwlid',type:'integer'},'fortinet.firewall.vwlquality':{category:'fortinet',description:'VWL quality ',name:'fortinet.firewall.vwlquality',type:'keyword'},'fortinet.firewall.vwlservice':{category:'fortinet',description:'VWL service ',name:'fortinet.firewall.vwlservice',type:'keyword'},'fortinet.firewall.vwpvlanid':{category:'fortinet',description:'VWP VLAN ID ',name:'fortinet.firewall.vwpvlanid',type:'integer'},'fortinet.firewall.wanin':{category:'fortinet',description:'WAN incoming traffic in bytes ',name:'fortinet.firewall.wanin',type:'long'},'fortinet.firewall.wanoptapptype':{category:'fortinet',description:'WAN Optimization Application type ',name:'fortinet.firewall.wanoptapptype',type:'keyword'},'fortinet.firewall.wanout':{category:'fortinet',description:'WAN outgoing traffic in bytes ',name:'fortinet.firewall.wanout',type:'long'},'fortinet.firewall.weakwepiv':{category:'fortinet',description:'Weak Wep Initiation Vector ',name:'fortinet.firewall.weakwepiv',type:'keyword'},'fortinet.firewall.xauthgroup':{category:'fortinet',description:'XAuth Group Name ',name:'fortinet.firewall.xauthgroup',type:'keyword'},'fortinet.firewall.xauthuser':{category:'fortinet',description:'XAuth User Name ',name:'fortinet.firewall.xauthuser',type:'keyword'},'fortinet.firewall.xid':{category:'fortinet',description:'Wireless X ID ',name:'fortinet.firewall.xid',type:'integer'},'googlecloud.destination.instance.project_id':{category:'googlecloud',description:'ID of the project containing the VM. ',name:'googlecloud.destination.instance.project_id',type:'keyword'},'googlecloud.destination.instance.region':{category:'googlecloud',description:'Region of the VM. ',name:'googlecloud.destination.instance.region',type:'keyword'},'googlecloud.destination.instance.zone':{category:'googlecloud',description:'Zone of the VM. ',name:'googlecloud.destination.instance.zone',type:'keyword'},'googlecloud.destination.vpc.project_id':{category:'googlecloud',description:'ID of the project containing the VM. ',name:'googlecloud.destination.vpc.project_id',type:'keyword'},'googlecloud.destination.vpc.vpc_name':{category:'googlecloud',description:'VPC on which the VM is operating. ',name:'googlecloud.destination.vpc.vpc_name',type:'keyword'},'googlecloud.destination.vpc.subnetwork_name':{category:'googlecloud',description:'Subnetwork on which the VM is operating. ',name:'googlecloud.destination.vpc.subnetwork_name',type:'keyword'},'googlecloud.source.instance.project_id':{category:'googlecloud',description:'ID of the project containing the VM. ',name:'googlecloud.source.instance.project_id',type:'keyword'},'googlecloud.source.instance.region':{category:'googlecloud',description:'Region of the VM. ',name:'googlecloud.source.instance.region',type:'keyword'},'googlecloud.source.instance.zone':{category:'googlecloud',description:'Zone of the VM. ',name:'googlecloud.source.instance.zone',type:'keyword'},'googlecloud.source.vpc.project_id':{category:'googlecloud',description:'ID of the project containing the VM. ',name:'googlecloud.source.vpc.project_id',type:'keyword'},'googlecloud.source.vpc.vpc_name':{category:'googlecloud',description:'VPC on which the VM is operating. ',name:'googlecloud.source.vpc.vpc_name',type:'keyword'},'googlecloud.source.vpc.subnetwork_name':{category:'googlecloud',description:'Subnetwork on which the VM is operating. ',name:'googlecloud.source.vpc.subnetwork_name',type:'keyword'},'googlecloud.audit.type':{category:'googlecloud',description:'Type property. ',name:'googlecloud.audit.type',type:'keyword'},'googlecloud.audit.authentication_info.principal_email':{category:'googlecloud',description:'The email address of the authenticated user making the request.  ',name:'googlecloud.audit.authentication_info.principal_email',type:'keyword'},'googlecloud.audit.authentication_info.authority_selector':{category:'googlecloud',description:'The authority selector specified by the requestor, if any. It is not guaranteed  that the principal was allowed to use this authority.  ',name:'googlecloud.audit.authentication_info.authority_selector',type:'keyword'},'googlecloud.audit.authorization_info.permission':{category:'googlecloud',description:'The required IAM permission.  ',name:'googlecloud.audit.authorization_info.permission',type:'keyword'},'googlecloud.audit.authorization_info.granted':{category:'googlecloud',description:'Whether or not authorization for resource and permission was granted.  ',name:'googlecloud.audit.authorization_info.granted',type:'boolean'},'googlecloud.audit.authorization_info.resource_attributes.service':{category:'googlecloud',description:'The name of the service. ',name:'googlecloud.audit.authorization_info.resource_attributes.service',type:'keyword'},'googlecloud.audit.authorization_info.resource_attributes.name':{category:'googlecloud',description:'The name of the resource. ',name:'googlecloud.audit.authorization_info.resource_attributes.name',type:'keyword'},'googlecloud.audit.authorization_info.resource_attributes.type':{category:'googlecloud',description:'The type of the resource. ',name:'googlecloud.audit.authorization_info.resource_attributes.type',type:'keyword'},'googlecloud.audit.method_name':{category:'googlecloud',description:"The name of the service method or operation. For API calls, this  should be the name of the API method.  For example, 'google.datastore.v1.Datastore.RunQuery'. ",name:'googlecloud.audit.method_name',type:'keyword'},'googlecloud.audit.num_response_items':{category:'googlecloud',description:'The number of items returned from a List or Query API method, if applicable. ',name:'googlecloud.audit.num_response_items',type:'long'},'googlecloud.audit.request.proto_name':{category:'googlecloud',description:'Type property of the request. ',name:'googlecloud.audit.request.proto_name',type:'keyword'},'googlecloud.audit.request.filter':{category:'googlecloud',description:'Filter of the request. ',name:'googlecloud.audit.request.filter',type:'keyword'},'googlecloud.audit.request.name':{category:'googlecloud',description:'Name of the request.  ',name:'googlecloud.audit.request.name',type:'keyword'},'googlecloud.audit.request.resource_name':{category:'googlecloud',description:'Name of the request resource.  ',name:'googlecloud.audit.request.resource_name',type:'keyword'},'googlecloud.audit.request_metadata.caller_ip':{category:'googlecloud',description:'The IP address of the caller.  ',name:'googlecloud.audit.request_metadata.caller_ip',type:'ip'},'googlecloud.audit.request_metadata.caller_supplied_user_agent':{category:'googlecloud',description:'The user agent of the caller. This information is not authenticated and  should be treated accordingly. ',name:'googlecloud.audit.request_metadata.caller_supplied_user_agent',type:'keyword'},'googlecloud.audit.response.proto_name':{category:'googlecloud',description:'Type property of the response. ',name:'googlecloud.audit.response.proto_name',type:'keyword'},'googlecloud.audit.response.details.group':{category:'googlecloud',description:'The name of the group. ',name:'googlecloud.audit.response.details.group',type:'keyword'},'googlecloud.audit.response.details.kind':{category:'googlecloud',description:'The kind of the response details. ',name:'googlecloud.audit.response.details.kind',type:'keyword'},'googlecloud.audit.response.details.name':{category:'googlecloud',description:'The name of the response details. ',name:'googlecloud.audit.response.details.name',type:'keyword'},'googlecloud.audit.response.details.uid':{category:'googlecloud',description:'The uid of the response details. ',name:'googlecloud.audit.response.details.uid',type:'keyword'},'googlecloud.audit.response.status':{category:'googlecloud',description:'Status of the response.  ',name:'googlecloud.audit.response.status',type:'keyword'},'googlecloud.audit.resource_name':{category:'googlecloud',description:"The resource or collection that is the target of the operation.  The name is a scheme-less URI, not including the API service name.  For example, 'shelves/SHELF_ID/books'. ",name:'googlecloud.audit.resource_name',type:'keyword'},'googlecloud.audit.resource_location.current_locations':{category:'googlecloud',description:'Current locations of the resource. ',name:'googlecloud.audit.resource_location.current_locations',type:'keyword'},'googlecloud.audit.service_name':{category:'googlecloud',description:'The name of the API service performing the operation.  For example, datastore.googleapis.com. ',name:'googlecloud.audit.service_name',type:'keyword'},'googlecloud.audit.status.code':{category:'googlecloud',description:'The status code, which should be an enum value of google.rpc.Code.  ',name:'googlecloud.audit.status.code',type:'integer'},'googlecloud.audit.status.message':{category:'googlecloud',description:'A developer-facing error message, which should be in English. Any user-facing  error message should be localized and sent in the google.rpc.Status.details  field, or localized by the client.  ',name:'googlecloud.audit.status.message',type:'keyword'},'googlecloud.firewall.rule_details.priority':{category:'googlecloud',description:'The priority for the firewall rule.',name:'googlecloud.firewall.rule_details.priority',type:'long'},'googlecloud.firewall.rule_details.action':{category:'googlecloud',description:'Action that the rule performs on match.',name:'googlecloud.firewall.rule_details.action',type:'keyword'},'googlecloud.firewall.rule_details.direction':{category:'googlecloud',description:'Direction of traffic that matches this rule.',name:'googlecloud.firewall.rule_details.direction',type:'keyword'},'googlecloud.firewall.rule_details.reference':{category:'googlecloud',description:'Reference to the firewall rule.',name:'googlecloud.firewall.rule_details.reference',type:'keyword'},'googlecloud.firewall.rule_details.source_range':{category:'googlecloud',description:'List of source ranges that the firewall rule applies to.',name:'googlecloud.firewall.rule_details.source_range',type:'keyword'},'googlecloud.firewall.rule_details.destination_range':{category:'googlecloud',description:'List of destination ranges that the firewall applies to.',name:'googlecloud.firewall.rule_details.destination_range',type:'keyword'},'googlecloud.firewall.rule_details.source_tag':{category:'googlecloud',description:'List of all the source tags that the firewall rule applies to. ',name:'googlecloud.firewall.rule_details.source_tag',type:'keyword'},'googlecloud.firewall.rule_details.target_tag':{category:'googlecloud',description:'List of all the target tags that the firewall rule applies to. ',name:'googlecloud.firewall.rule_details.target_tag',type:'keyword'},'googlecloud.firewall.rule_details.ip_port_info':{category:'googlecloud',description:'List of ip protocols and applicable port ranges for rules. ',name:'googlecloud.firewall.rule_details.ip_port_info',type:'array'},'googlecloud.firewall.rule_details.source_service_account':{category:'googlecloud',description:'List of all the source service accounts that the firewall rule applies to. ',name:'googlecloud.firewall.rule_details.source_service_account',type:'keyword'},'googlecloud.firewall.rule_details.target_service_account':{category:'googlecloud',description:'List of all the target service accounts that the firewall rule applies to. ',name:'googlecloud.firewall.rule_details.target_service_account',type:'keyword'},'googlecloud.vpcflow.reporter':{category:'googlecloud',description:"The side which reported the flow. Can be either 'SRC' or 'DEST'. ",name:'googlecloud.vpcflow.reporter',type:'keyword'},'googlecloud.vpcflow.rtt.ms':{category:'googlecloud',description:'Latency as measured (for TCP flows only) during the time interval. This is the time elapsed between sending a SEQ and receiving a corresponding ACK and it contains the network RTT as well as the application related delay. ',name:'googlecloud.vpcflow.rtt.ms',type:'long'},'gsuite.actor.type':{category:'gsuite',description:'The type of actor. Values can be:   *USER*: Another user in the same domain.   *EXTERNAL_USER*: A user outside the domain.   *KEY*: A non-human actor. ',name:'gsuite.actor.type',type:'keyword'},'gsuite.actor.key':{category:'gsuite',description:'Only present when `actor.type` is `KEY`. Can be the `consumer_key` of the requestor for OAuth 2LO API requests or an identifier for robot accounts. ',name:'gsuite.actor.key',type:'keyword'},'gsuite.event.type':{category:'gsuite',description:'The type of GSuite event, mapped from `items[].events[].type` in the original payload. Each fileset can have a different set of values for it, more details can be found at https://developers.google.com/admin-sdk/reports/v1/reference/activities/list ',example:'audit#activity',name:'gsuite.event.type',type:'keyword'},'gsuite.kind':{category:'gsuite',description:'The type of API resource, mapped from `kind` in the original payload. More details can be found at https://developers.google.com/admin-sdk/reports/v1/reference/activities/list ',example:'audit#activity',name:'gsuite.kind',type:'keyword'},'gsuite.organization.domain':{category:'gsuite',description:"The domain that is affected by the report's event. ",name:'gsuite.organization.domain',type:'keyword'},'gsuite.admin.application.edition':{category:'gsuite',description:'The GSuite edition.',name:'gsuite.admin.application.edition',type:'keyword'},'gsuite.admin.application.name':{category:'gsuite',description:"The application's name.",name:'gsuite.admin.application.name',type:'keyword'},'gsuite.admin.application.enabled':{category:'gsuite',description:'The enabled application.',name:'gsuite.admin.application.enabled',type:'keyword'},'gsuite.admin.application.licences_order_number':{category:'gsuite',description:'Order number used to redeem licenses.',name:'gsuite.admin.application.licences_order_number',type:'keyword'},'gsuite.admin.application.licences_purchased':{category:'gsuite',description:'Number of licences purchased.',name:'gsuite.admin.application.licences_purchased',type:'keyword'},'gsuite.admin.application.id':{category:'gsuite',description:'The application ID.',name:'gsuite.admin.application.id',type:'keyword'},'gsuite.admin.application.asp_id':{category:'gsuite',description:'The application specific password ID.',name:'gsuite.admin.application.asp_id',type:'keyword'},'gsuite.admin.application.package_id':{category:'gsuite',description:'The mobile application package ID.',name:'gsuite.admin.application.package_id',type:'keyword'},'gsuite.admin.group.email':{category:'gsuite',description:"The group's primary email address.",name:'gsuite.admin.group.email',type:'keyword'},'gsuite.admin.new_value':{category:'gsuite',description:'The new value for the setting.',name:'gsuite.admin.new_value',type:'keyword'},'gsuite.admin.old_value':{category:'gsuite',description:'The old value for the setting.',name:'gsuite.admin.old_value',type:'keyword'},'gsuite.admin.org_unit.name':{category:'gsuite',description:'The organizational unit name.',name:'gsuite.admin.org_unit.name',type:'keyword'},'gsuite.admin.org_unit.full':{category:'gsuite',description:'The org unit full path including the root org unit name.',name:'gsuite.admin.org_unit.full',type:'keyword'},'gsuite.admin.setting.name':{category:'gsuite',description:'The setting name.',name:'gsuite.admin.setting.name',type:'keyword'},'gsuite.admin.user_defined_setting.name':{category:'gsuite',description:'The name of the user-defined setting.',name:'gsuite.admin.user_defined_setting.name',type:'keyword'},'gsuite.admin.setting.description':{category:'gsuite',description:'The setting name.',name:'gsuite.admin.setting.description',type:'keyword'},'gsuite.admin.group.priorities':{category:'gsuite',description:'Group priorities.',name:'gsuite.admin.group.priorities',type:'keyword'},'gsuite.admin.domain.alias':{category:'gsuite',description:'The domain alias.',name:'gsuite.admin.domain.alias',type:'keyword'},'gsuite.admin.domain.name':{category:'gsuite',description:'The primary domain name.',name:'gsuite.admin.domain.name',type:'keyword'},'gsuite.admin.domain.secondary_name':{category:'gsuite',description:'The secondary domain name.',name:'gsuite.admin.domain.secondary_name',type:'keyword'},'gsuite.admin.managed_configuration':{category:'gsuite',description:'The name of the managed configuration.',name:'gsuite.admin.managed_configuration',type:'keyword'},'gsuite.admin.non_featured_services_selection':{category:'gsuite',description:'Non-featured services selection. For a list of possible values refer to https://developers.google.com/admin-sdk/reports/v1/appendix/activity/admin-application-settings#FLASHLIGHT_EDU_NON_FEATURED_SERVICES_SELECTED ',name:'gsuite.admin.non_featured_services_selection',type:'keyword'},'gsuite.admin.field':{category:'gsuite',description:'The name of the field.',name:'gsuite.admin.field',type:'keyword'},'gsuite.admin.resource.id':{category:'gsuite',description:'The name of the resource identifier.',name:'gsuite.admin.resource.id',type:'keyword'},'gsuite.admin.user.email':{category:'gsuite',description:"The user's primary email address.",name:'gsuite.admin.user.email',type:'keyword'},'gsuite.admin.user.nickname':{category:'gsuite',description:"The user's nickname.",name:'gsuite.admin.user.nickname',type:'keyword'},'gsuite.admin.user.birthdate':{category:'gsuite',description:"The user's birth date.",name:'gsuite.admin.user.birthdate',type:'date'},'gsuite.admin.gateway.name':{category:'gsuite',description:'Gateway name. Present on some chat settings.',name:'gsuite.admin.gateway.name',type:'keyword'},'gsuite.admin.chrome_os.session_type':{category:'gsuite',description:'Chrome OS session type.',name:'gsuite.admin.chrome_os.session_type',type:'keyword'},'gsuite.admin.device.serial_number':{category:'gsuite',description:'Device serial number.',name:'gsuite.admin.device.serial_number',type:'keyword'},'gsuite.admin.device.id':{category:'gsuite',name:'gsuite.admin.device.id',type:'keyword'},'gsuite.admin.device.type':{category:'gsuite',description:'Device type.',name:'gsuite.admin.device.type',type:'keyword'},'gsuite.admin.print_server.name':{category:'gsuite',description:'The name of the print server.',name:'gsuite.admin.print_server.name',type:'keyword'},'gsuite.admin.printer.name':{category:'gsuite',description:'The name of the printer.',name:'gsuite.admin.printer.name',type:'keyword'},'gsuite.admin.device.command_details':{category:'gsuite',description:'Command details.',name:'gsuite.admin.device.command_details',type:'keyword'},'gsuite.admin.role.id':{category:'gsuite',description:'Unique identifier for this role privilege.',name:'gsuite.admin.role.id',type:'keyword'},'gsuite.admin.role.name':{category:'gsuite',description:'The role name. For a list of possible values refer to https://developers.google.com/admin-sdk/reports/v1/appendix/activity/admin-delegated-admin-settings ',name:'gsuite.admin.role.name',type:'keyword'},'gsuite.admin.privilege.name':{category:'gsuite',description:'Privilege name.',name:'gsuite.admin.privilege.name',type:'keyword'},'gsuite.admin.service.name':{category:'gsuite',description:'The service name.',name:'gsuite.admin.service.name',type:'keyword'},'gsuite.admin.url.name':{category:'gsuite',description:'The website name.',name:'gsuite.admin.url.name',type:'keyword'},'gsuite.admin.product.name':{category:'gsuite',description:'The product name.',name:'gsuite.admin.product.name',type:'keyword'},'gsuite.admin.product.sku':{category:'gsuite',description:'The product SKU.',name:'gsuite.admin.product.sku',type:'keyword'},'gsuite.admin.bulk_upload.failed':{category:'gsuite',description:'Number of failed records in bulk upload operation.',name:'gsuite.admin.bulk_upload.failed',type:'long'},'gsuite.admin.bulk_upload.total':{category:'gsuite',description:'Number of total records in bulk upload operation.',name:'gsuite.admin.bulk_upload.total',type:'long'},'gsuite.admin.group.allowed_list':{category:'gsuite',description:'Names of allow-listed groups.',name:'gsuite.admin.group.allowed_list',type:'keyword'},'gsuite.admin.email.quarantine_name':{category:'gsuite',description:'The name of the quarantine.',name:'gsuite.admin.email.quarantine_name',type:'keyword'},'gsuite.admin.email.log_search_filter.message_id':{category:'gsuite',description:"The log search filter's email message ID.",name:'gsuite.admin.email.log_search_filter.message_id',type:'keyword'},'gsuite.admin.email.log_search_filter.start_date':{category:'gsuite',description:"The log search filter's start date.",name:'gsuite.admin.email.log_search_filter.start_date',type:'date'},'gsuite.admin.email.log_search_filter.end_date':{category:'gsuite',description:"The log search filter's ending date.",name:'gsuite.admin.email.log_search_filter.end_date',type:'date'},'gsuite.admin.email.log_search_filter.recipient.value':{category:'gsuite',description:"The log search filter's email recipient.",name:'gsuite.admin.email.log_search_filter.recipient.value',type:'keyword'},'gsuite.admin.email.log_search_filter.sender.value':{category:'gsuite',description:"The log search filter's email sender.",name:'gsuite.admin.email.log_search_filter.sender.value',type:'keyword'},'gsuite.admin.email.log_search_filter.recipient.ip':{category:'gsuite',description:"The log search filter's email recipient's IP address.",name:'gsuite.admin.email.log_search_filter.recipient.ip',type:'ip'},'gsuite.admin.email.log_search_filter.sender.ip':{category:'gsuite',description:"The log search filter's email sender's IP address.",name:'gsuite.admin.email.log_search_filter.sender.ip',type:'ip'},'gsuite.admin.chrome_licenses.enabled':{category:'gsuite',description:'Licences enabled. For a list of possible values refer to https://developers.google.com/admin-sdk/reports/v1/appendix/activity/admin-org-settings ',name:'gsuite.admin.chrome_licenses.enabled',type:'keyword'},'gsuite.admin.chrome_licenses.allowed':{category:'gsuite',description:'Licences enabled. For a list of possible values refer to https://developers.google.com/admin-sdk/reports/v1/appendix/activity/admin-org-settings ',name:'gsuite.admin.chrome_licenses.allowed',type:'keyword'},'gsuite.admin.oauth2.service.name':{category:'gsuite',description:'OAuth2 service name. For a list of possible values refer to https://developers.google.com/admin-sdk/reports/v1/appendix/activity/admin-security-settings ',name:'gsuite.admin.oauth2.service.name',type:'keyword'},'gsuite.admin.oauth2.application.id':{category:'gsuite',description:'OAuth2 application ID.',name:'gsuite.admin.oauth2.application.id',type:'keyword'},'gsuite.admin.oauth2.application.name':{category:'gsuite',description:'OAuth2 application name.',name:'gsuite.admin.oauth2.application.name',type:'keyword'},'gsuite.admin.oauth2.application.type':{category:'gsuite',description:'OAuth2 application type. For a list of possible values refer to https://developers.google.com/admin-sdk/reports/v1/appendix/activity/admin-security-settings ',name:'gsuite.admin.oauth2.application.type',type:'keyword'},'gsuite.admin.verification_method':{category:'gsuite',description:'Related verification method. For a list of possible values refer to https://developers.google.com/admin-sdk/reports/v1/appendix/activity/admin-security-settings and https://developers.google.com/admin-sdk/reports/v1/appendix/activity/admin-domain-settings ',name:'gsuite.admin.verification_method',type:'keyword'},'gsuite.admin.alert.name':{category:'gsuite',description:'The alert name.',name:'gsuite.admin.alert.name',type:'keyword'},'gsuite.admin.rule.name':{category:'gsuite',description:'The rule name.',name:'gsuite.admin.rule.name',type:'keyword'},'gsuite.admin.api.client.name':{category:'gsuite',description:'The API client name.',name:'gsuite.admin.api.client.name',type:'keyword'},'gsuite.admin.api.scopes':{category:'gsuite',description:'The API scopes.',name:'gsuite.admin.api.scopes',type:'keyword'},'gsuite.admin.mdm.token':{category:'gsuite',description:'The MDM vendor enrollment token.',name:'gsuite.admin.mdm.token',type:'keyword'},'gsuite.admin.mdm.vendor':{category:'gsuite',description:"The MDM vendor's name.",name:'gsuite.admin.mdm.vendor',type:'keyword'},'gsuite.admin.info_type':{category:'gsuite',description:'This will be used to state what kind of information was changed. For a list of possible values refer to https://developers.google.com/admin-sdk/reports/v1/appendix/activity/admin-domain-settings ',name:'gsuite.admin.info_type',type:'keyword'},'gsuite.admin.email_monitor.dest_email':{category:'gsuite',description:'The destination address of the email monitor.',name:'gsuite.admin.email_monitor.dest_email',type:'keyword'},'gsuite.admin.email_monitor.level.chat':{category:'gsuite',description:'The chat email monitor level.',name:'gsuite.admin.email_monitor.level.chat',type:'keyword'},'gsuite.admin.email_monitor.level.draft':{category:'gsuite',description:'The draft email monitor level.',name:'gsuite.admin.email_monitor.level.draft',type:'keyword'},'gsuite.admin.email_monitor.level.incoming':{category:'gsuite',description:'The incoming email monitor level.',name:'gsuite.admin.email_monitor.level.incoming',type:'keyword'},'gsuite.admin.email_monitor.level.outgoing':{category:'gsuite',description:'The outgoing email monitor level.',name:'gsuite.admin.email_monitor.level.outgoing',type:'keyword'},'gsuite.admin.email_dump.include_deleted':{category:'gsuite',description:'Indicates if deleted emails are included in the export.',name:'gsuite.admin.email_dump.include_deleted',type:'boolean'},'gsuite.admin.email_dump.package_content':{category:'gsuite',description:'The contents of the mailbox package.',name:'gsuite.admin.email_dump.package_content',type:'keyword'},'gsuite.admin.email_dump.query':{category:'gsuite',description:'The search query used for the dump.',name:'gsuite.admin.email_dump.query',type:'keyword'},'gsuite.admin.request.id':{category:'gsuite',description:'The request ID.',name:'gsuite.admin.request.id',type:'keyword'},'gsuite.admin.mobile.action.id':{category:'gsuite',description:"The mobile device action's ID.",name:'gsuite.admin.mobile.action.id',type:'keyword'},'gsuite.admin.mobile.action.type':{category:'gsuite',description:"The mobile device action's type. For a list of possible values refer to https://developers.google.com/admin-sdk/reports/v1/appendix/activity/admin-mobile-settings ",name:'gsuite.admin.mobile.action.type',type:'keyword'},'gsuite.admin.mobile.certificate.name':{category:'gsuite',description:'The mobile certificate common name.',name:'gsuite.admin.mobile.certificate.name',type:'keyword'},'gsuite.admin.mobile.company_owned_devices':{category:'gsuite',description:'The number of devices a company owns.',name:'gsuite.admin.mobile.company_owned_devices',type:'long'},'gsuite.admin.distribution.entity.name':{category:'gsuite',description:'The distribution entity value, which can be a group name or an org-unit name. For a list of possible values refer to https://developers.google.com/admin-sdk/reports/v1/appendix/activity/admin-mobile-settings ',name:'gsuite.admin.distribution.entity.name',type:'keyword'},'gsuite.admin.distribution.entity.type':{category:'gsuite',description:'The distribution entity type, which can be a group or an org-unit. For a list of possible values refer to https://developers.google.com/admin-sdk/reports/v1/appendix/activity/admin-mobile-settings ',name:'gsuite.admin.distribution.entity.type',type:'keyword'},'gsuite.drive.billable':{category:'gsuite',description:'Whether this activity is billable.',name:'gsuite.drive.billable',type:'boolean'},'gsuite.drive.source_folder_id':{category:'gsuite',name:'gsuite.drive.source_folder_id',type:'keyword'},'gsuite.drive.source_folder_title':{category:'gsuite',name:'gsuite.drive.source_folder_title',type:'keyword'},'gsuite.drive.destination_folder_id':{category:'gsuite',name:'gsuite.drive.destination_folder_id',type:'keyword'},'gsuite.drive.destination_folder_title':{category:'gsuite',name:'gsuite.drive.destination_folder_title',type:'keyword'},'gsuite.drive.file.id':{category:'gsuite',name:'gsuite.drive.file.id',type:'keyword'},'gsuite.drive.file.type':{category:'gsuite',description:'Document Drive type. For a list of possible values refer to https://developers.google.com/admin-sdk/reports/v1/appendix/activity/drive ',name:'gsuite.drive.file.type',type:'keyword'},'gsuite.drive.originating_app_id':{category:'gsuite',description:'The Google Cloud Project ID of the application that performed the action. ',name:'gsuite.drive.originating_app_id',type:'keyword'},'gsuite.drive.file.owner.email':{category:'gsuite',name:'gsuite.drive.file.owner.email',type:'keyword'},'gsuite.drive.file.owner.is_shared_drive':{category:'gsuite',description:'Boolean flag denoting whether owner is a shared drive. ',name:'gsuite.drive.file.owner.is_shared_drive',type:'boolean'},'gsuite.drive.primary_event':{category:'gsuite',description:'Whether this is a primary event. A single user action in Drive may generate several events. ',name:'gsuite.drive.primary_event',type:'boolean'},'gsuite.drive.shared_drive_id':{category:'gsuite',description:'The unique identifier of the Team Drive. Only populated for for events relating to a Team Drive or item contained inside a Team Drive. ',name:'gsuite.drive.shared_drive_id',type:'keyword'},'gsuite.drive.visibility':{category:'gsuite',description:'Visibility of target file. For a list of possible values refer to https://developers.google.com/admin-sdk/reports/v1/appendix/activity/drive ',name:'gsuite.drive.visibility',type:'keyword'},'gsuite.drive.new_value':{category:'gsuite',description:'When a setting or property of the file changes, the new value for it will appear here. ',name:'gsuite.drive.new_value',type:'keyword'},'gsuite.drive.old_value':{category:'gsuite',description:'When a setting or property of the file changes, the old value for it will appear here. ',name:'gsuite.drive.old_value',type:'keyword'},'gsuite.drive.sheets_import_range_recipient_doc':{category:'gsuite',description:'Doc ID of the recipient of a sheets import range.',name:'gsuite.drive.sheets_import_range_recipient_doc',type:'keyword'},'gsuite.drive.old_visibility':{category:'gsuite',description:'When visibility changes, this holds the old value. ',name:'gsuite.drive.old_visibility',type:'keyword'},'gsuite.drive.visibility_change':{category:'gsuite',description:'When visibility changes, this holds the new overall visibility of the file. ',name:'gsuite.drive.visibility_change',type:'keyword'},'gsuite.drive.target_domain':{category:'gsuite',description:'The domain for which the acccess scope was changed. This can also be the alias all to indicate the access scope was changed for all domains that have visibility for this document. ',name:'gsuite.drive.target_domain',type:'keyword'},'gsuite.drive.added_role':{category:'gsuite',description:'Added membership role of a user/group in a Team Drive. For a list of possible values refer to https://developers.google.com/admin-sdk/reports/v1/appendix/activity/drive ',name:'gsuite.drive.added_role',type:'keyword'},'gsuite.drive.membership_change_type':{category:'gsuite',description:'Type of change in Team Drive membership of a user/group. For a list of possible values refer to https://developers.google.com/admin-sdk/reports/v1/appendix/activity/drive ',name:'gsuite.drive.membership_change_type',type:'keyword'},'gsuite.drive.shared_drive_settings_change_type':{category:'gsuite',description:'Type of change in Team Drive settings. For a list of possible values refer to https://developers.google.com/admin-sdk/reports/v1/appendix/activity/drive ',name:'gsuite.drive.shared_drive_settings_change_type',type:'keyword'},'gsuite.drive.removed_role':{category:'gsuite',description:'Removed membership role of a user/group in a Team Drive. For a list of possible values refer to https://developers.google.com/admin-sdk/reports/v1/appendix/activity/drive ',name:'gsuite.drive.removed_role',type:'keyword'},'gsuite.drive.target':{category:'gsuite',description:'Target user or group.',name:'gsuite.drive.target',type:'keyword'},'gsuite.groups.acl_permission':{category:'gsuite',description:'Group permission setting updated. For a list of possible values refer to https://developers.google.com/admin-sdk/reports/v1/appendix/activity/groups ',name:'gsuite.groups.acl_permission',type:'keyword'},'gsuite.groups.email':{category:'gsuite',description:'Group email. ',name:'gsuite.groups.email',type:'keyword'},'gsuite.groups.member.email':{category:'gsuite',description:'Member email. ',name:'gsuite.groups.member.email',type:'keyword'},'gsuite.groups.member.role':{category:'gsuite',description:'Member role. For a list of possible values refer to https://developers.google.com/admin-sdk/reports/v1/appendix/activity/groups ',name:'gsuite.groups.member.role',type:'keyword'},'gsuite.groups.setting':{category:'gsuite',description:'Group setting updated. For a list of possible values refer to https://developers.google.com/admin-sdk/reports/v1/appendix/activity/groups ',name:'gsuite.groups.setting',type:'keyword'},'gsuite.groups.new_value':{category:'gsuite',description:'New value(s) of the group setting. For a list of possible values refer to https://developers.google.com/admin-sdk/reports/v1/appendix/activity/groups ',name:'gsuite.groups.new_value',type:'keyword'},'gsuite.groups.old_value':{category:'gsuite',description:'Old value(s) of the group setting. For a list of possible values refer to https://developers.google.com/admin-sdk/reports/v1/appendix/activity/groups',name:'gsuite.groups.old_value',type:'keyword'},'gsuite.groups.value':{category:'gsuite',description:'Value of the group setting. For a list of possible values refer to https://developers.google.com/admin-sdk/reports/v1/appendix/activity/groups ',name:'gsuite.groups.value',type:'keyword'},'gsuite.groups.message.id':{category:'gsuite',description:'SMTP message Id of an email message. Present for moderation events. ',name:'gsuite.groups.message.id',type:'keyword'},'gsuite.groups.message.moderation_action':{category:'gsuite',description:'Message moderation action. Possible values are `approved` and `rejected`. ',name:'gsuite.groups.message.moderation_action',type:'keyword'},'gsuite.groups.status':{category:'gsuite',description:'A status describing the output of an operation. Possible values are `failed` and `succeeded`. ',name:'gsuite.groups.status',type:'keyword'},'gsuite.login.affected_email_address':{category:'gsuite',name:'gsuite.login.affected_email_address',type:'keyword'},'gsuite.login.challenge_method':{category:'gsuite',description:'Login challenge method. For a list of possible values refer to https://developers.google.com/admin-sdk/reports/v1/appendix/activity/login. ',name:'gsuite.login.challenge_method',type:'keyword'},'gsuite.login.failure_type':{category:'gsuite',description:'Login failure type. For a list of possible values refer to https://developers.google.com/admin-sdk/reports/v1/appendix/activity/login. ',name:'gsuite.login.failure_type',type:'keyword'},'gsuite.login.type':{category:'gsuite',description:'Login credentials type. For a list of possible values refer to https://developers.google.com/admin-sdk/reports/v1/appendix/activity/login. ',name:'gsuite.login.type',type:'keyword'},'gsuite.login.is_second_factor':{category:'gsuite',name:'gsuite.login.is_second_factor',type:'boolean'},'gsuite.login.is_suspicious':{category:'gsuite',name:'gsuite.login.is_suspicious',type:'boolean'},'gsuite.saml.application_name':{category:'gsuite',description:'Saml SP application name. ',name:'gsuite.saml.application_name',type:'keyword'},'gsuite.saml.failure_type':{category:'gsuite',description:'Login failure type. For a list of possible values refer to https://developers.google.com/admin-sdk/reports/v1/appendix/activity/saml. ',name:'gsuite.saml.failure_type',type:'keyword'},'gsuite.saml.initiated_by':{category:'gsuite',description:'Requester of SAML authentication. ',name:'gsuite.saml.initiated_by',type:'keyword'},'gsuite.saml.orgunit_path':{category:'gsuite',description:'User orgunit. ',name:'gsuite.saml.orgunit_path',type:'keyword'},'gsuite.saml.status_code':{category:'gsuite',description:'SAML status code. ',name:'gsuite.saml.status_code',type:'long'},'gsuite.saml.second_level_status_code':{category:'gsuite',description:'SAML second level status code. ',name:'gsuite.saml.second_level_status_code',type:'long'},'ibmmq.errorlog.installation':{category:'ibmmq',description:'This is the installation name which can be given at installation time. Each installation of IBM MQ on UNIX, Linux, and Windows, has a unique identifier known as an installation name. The installation name is used to associate things such as queue managers and configuration files with an installation. ',name:'ibmmq.errorlog.installation',type:'keyword'},'ibmmq.errorlog.qmgr':{category:'ibmmq',description:'Name of the queue manager. Queue managers provide queuing services to applications, and manages the queues that belong to them. ',name:'ibmmq.errorlog.qmgr',type:'keyword'},'ibmmq.errorlog.arithinsert':{category:'ibmmq',description:'Changing content based on error.id',name:'ibmmq.errorlog.arithinsert',type:'keyword'},'ibmmq.errorlog.commentinsert':{category:'ibmmq',description:'Changing content based on error.id',name:'ibmmq.errorlog.commentinsert',type:'keyword'},'ibmmq.errorlog.errordescription':{category:'ibmmq',description:'Please add description',example:'Please add example',name:'ibmmq.errorlog.errordescription',type:'text'},'ibmmq.errorlog.explanation':{category:'ibmmq',description:'Explaines the error in more detail',name:'ibmmq.errorlog.explanation',type:'keyword'},'ibmmq.errorlog.action':{category:'ibmmq',description:'Defines what to do when the error occurs',name:'ibmmq.errorlog.action',type:'keyword'},'ibmmq.errorlog.code':{category:'ibmmq',description:'Error code.',name:'ibmmq.errorlog.code',type:'keyword'},'iptables.ether_type':{category:'iptables',description:'Value of the ethernet type field identifying the network layer protocol. ',name:'iptables.ether_type',type:'long'},'iptables.flow_label':{category:'iptables',description:'IPv6 flow label. ',name:'iptables.flow_label',type:'integer'},'iptables.fragment_flags':{category:'iptables',description:'IP fragment flags. A combination of CE, DF and MF. ',name:'iptables.fragment_flags',type:'keyword'},'iptables.fragment_offset':{category:'iptables',description:'Offset of the current IP fragment. ',name:'iptables.fragment_offset',type:'long'},'iptables.icmp.code':{category:'iptables',description:'ICMP code. ',name:'iptables.icmp.code',type:'long'},'iptables.icmp.id':{category:'iptables',description:'ICMP ID. ',name:'iptables.icmp.id',type:'long'},'iptables.icmp.parameter':{category:'iptables',description:'ICMP parameter. ',name:'iptables.icmp.parameter',type:'long'},'iptables.icmp.redirect':{category:'iptables',description:'ICMP redirect address. ',name:'iptables.icmp.redirect',type:'ip'},'iptables.icmp.seq':{category:'iptables',description:'ICMP sequence number. ',name:'iptables.icmp.seq',type:'long'},'iptables.icmp.type':{category:'iptables',description:'ICMP type. ',name:'iptables.icmp.type',type:'long'},'iptables.id':{category:'iptables',description:'Packet identifier. ',name:'iptables.id',type:'long'},'iptables.incomplete_bytes':{category:'iptables',description:'Number of incomplete bytes. ',name:'iptables.incomplete_bytes',type:'long'},'iptables.input_device':{category:'iptables',description:'Device that received the packet. ',name:'iptables.input_device',type:'keyword'},'iptables.precedence_bits':{category:'iptables',description:'IP precedence bits. ',name:'iptables.precedence_bits',type:'short'},'iptables.tos':{category:'iptables',description:'IP Type of Service field. ',name:'iptables.tos',type:'long'},'iptables.length':{category:'iptables',description:'Packet length. ',name:'iptables.length',type:'long'},'iptables.output_device':{category:'iptables',description:'Device that output the packet. ',name:'iptables.output_device',type:'keyword'},'iptables.tcp.flags':{category:'iptables',description:'TCP flags. ',name:'iptables.tcp.flags',type:'keyword'},'iptables.tcp.reserved_bits':{category:'iptables',description:'TCP reserved bits. ',name:'iptables.tcp.reserved_bits',type:'short'},'iptables.tcp.seq':{category:'iptables',description:'TCP sequence number. ',name:'iptables.tcp.seq',type:'long'},'iptables.tcp.ack':{category:'iptables',description:'TCP Acknowledgment number. ',name:'iptables.tcp.ack',type:'long'},'iptables.tcp.window':{category:'iptables',description:'Advertised TCP window size. ',name:'iptables.tcp.window',type:'long'},'iptables.ttl':{category:'iptables',description:'Time To Live field. ',name:'iptables.ttl',type:'integer'},'iptables.udp.length':{category:'iptables',description:'Length of the UDP header and payload. ',name:'iptables.udp.length',type:'long'},'iptables.ubiquiti.input_zone':{category:'iptables',description:'Input zone. ',name:'iptables.ubiquiti.input_zone',type:'keyword'},'iptables.ubiquiti.output_zone':{category:'iptables',description:'Output zone. ',name:'iptables.ubiquiti.output_zone',type:'keyword'},'iptables.ubiquiti.rule_number':{category:'iptables',description:'The rule number within the rule set.',name:'iptables.ubiquiti.rule_number',type:'keyword'},'iptables.ubiquiti.rule_set':{category:'iptables',description:'The rule set name.',name:'iptables.ubiquiti.rule_set',type:'keyword'},'microsoft.defender_atp.lastUpdateTime':{category:'microsoft',description:'The date and time (in UTC) the alert was last updated. ',name:'microsoft.defender_atp.lastUpdateTime',type:'date'},'microsoft.defender_atp.resolvedTime':{category:'microsoft',description:"The date and time in which the status of the alert was changed to 'Resolved'. ",name:'microsoft.defender_atp.resolvedTime',type:'date'},'microsoft.defender_atp.incidentId':{category:'microsoft',description:'The Incident ID of the Alert. ',name:'microsoft.defender_atp.incidentId',type:'keyword'},'microsoft.defender_atp.investigationId':{category:'microsoft',description:'The Investigation ID related to the Alert. ',name:'microsoft.defender_atp.investigationId',type:'keyword'},'microsoft.defender_atp.investigationState':{category:'microsoft',description:'The current state of the Investigation. ',name:'microsoft.defender_atp.investigationState',type:'keyword'},'microsoft.defender_atp.assignedTo':{category:'microsoft',description:'Owner of the alert. ',name:'microsoft.defender_atp.assignedTo',type:'keyword'},'microsoft.defender_atp.status':{category:'microsoft',description:"Specifies the current status of the alert. Possible values are: 'Unknown', 'New', 'InProgress' and 'Resolved'. ",name:'microsoft.defender_atp.status',type:'keyword'},'microsoft.defender_atp.classification':{category:'microsoft',description:"Specification of the alert. Possible values are: 'Unknown', 'FalsePositive', 'TruePositive'. ",name:'microsoft.defender_atp.classification',type:'keyword'},'microsoft.defender_atp.determination':{category:'microsoft',description:"Specifies the determination of the alert. Possible values are: 'NotAvailable', 'Apt', 'Malware', 'SecurityPersonnel', 'SecurityTesting', 'UnwantedSoftware', 'Other'. ",name:'microsoft.defender_atp.determination',type:'keyword'},'microsoft.defender_atp.threatFamilyName':{category:'microsoft',description:'Threat family. ',name:'microsoft.defender_atp.threatFamilyName',type:'keyword'},'microsoft.defender_atp.rbacGroupName':{category:'microsoft',description:'User group related to the alert ',name:'microsoft.defender_atp.rbacGroupName',type:'keyword'},'microsoft.defender_atp.evidence.domainName':{category:'microsoft',description:'Domain name related to the alert ',name:'microsoft.defender_atp.evidence.domainName',type:'keyword'},'microsoft.defender_atp.evidence.ipAddress':{category:'microsoft',description:'IP address involved in the alert ',name:'microsoft.defender_atp.evidence.ipAddress',type:'ip'},'microsoft.defender_atp.evidence.aadUserId':{category:'microsoft',description:'ID of the user involved in the alert ',name:'microsoft.defender_atp.evidence.aadUserId',type:'keyword'},'microsoft.defender_atp.evidence.accountName':{category:'microsoft',description:'Username of the user involved in the alert ',name:'microsoft.defender_atp.evidence.accountName',type:'keyword'},'microsoft.defender_atp.evidence.entityType':{category:'microsoft',description:'The type of evidence ',name:'microsoft.defender_atp.evidence.entityType',type:'keyword'},'microsoft.defender_atp.evidence.userPrincipalName':{category:'microsoft',description:'Principal name of the user involved in the alert ',name:'microsoft.defender_atp.evidence.userPrincipalName',type:'keyword'},'misp.attack_pattern.id':{category:'misp',description:'Identifier of the threat indicator. ',name:'misp.attack_pattern.id',type:'keyword'},'misp.attack_pattern.name':{category:'misp',description:'Name of the attack pattern. ',name:'misp.attack_pattern.name',type:'keyword'},'misp.attack_pattern.description':{category:'misp',description:'Description of the attack pattern. ',name:'misp.attack_pattern.description',type:'text'},'misp.attack_pattern.kill_chain_phases':{category:'misp',description:'The kill chain phase(s) to which this attack pattern corresponds. ',name:'misp.attack_pattern.kill_chain_phases',type:'keyword'},'misp.campaign.id':{category:'misp',description:'Identifier of the campaign. ',name:'misp.campaign.id',type:'keyword'},'misp.campaign.name':{category:'misp',description:'Name of the campaign. ',name:'misp.campaign.name',type:'keyword'},'misp.campaign.description':{category:'misp',description:'Description of the campaign. ',name:'misp.campaign.description',type:'text'},'misp.campaign.aliases':{category:'misp',description:'Alternative names used to identify this campaign. ',name:'misp.campaign.aliases',type:'text'},'misp.campaign.first_seen':{category:'misp',description:'The time that this Campaign was first seen, in RFC3339 format. ',name:'misp.campaign.first_seen',type:'date'},'misp.campaign.last_seen':{category:'misp',description:'The time that this Campaign was last seen, in RFC3339 format. ',name:'misp.campaign.last_seen',type:'date'},'misp.campaign.objective':{category:'misp',description:"This field defines the Campaign's primary goal, objective, desired outcome, or intended effect. ",name:'misp.campaign.objective',type:'keyword'},'misp.course_of_action.id':{category:'misp',description:'Identifier of the Course of Action. ',name:'misp.course_of_action.id',type:'keyword'},'misp.course_of_action.name':{category:'misp',description:'The name used to identify the Course of Action. ',name:'misp.course_of_action.name',type:'keyword'},'misp.course_of_action.description':{category:'misp',description:'Description of the Course of Action. ',name:'misp.course_of_action.description',type:'text'},'misp.identity.id':{category:'misp',description:'Identifier of the Identity. ',name:'misp.identity.id',type:'keyword'},'misp.identity.name':{category:'misp',description:'The name used to identify the Identity. ',name:'misp.identity.name',type:'keyword'},'misp.identity.description':{category:'misp',description:'Description of the Identity. ',name:'misp.identity.description',type:'text'},'misp.identity.identity_class':{category:'misp',description:'The type of entity that this Identity describes, e.g., an individual or organization. Open Vocab - identity-class-ov  ',name:'misp.identity.identity_class',type:'keyword'},'misp.identity.labels':{category:'misp',description:'The list of roles that this Identity performs.   ',example:'CEO\n',name:'misp.identity.labels',type:'keyword'},'misp.identity.sectors':{category:'misp',description:'The list of sectors that this Identity belongs to. Open Vocab - industry-sector-ov  ',name:'misp.identity.sectors',type:'keyword'},'misp.identity.contact_information':{category:'misp',description:'The contact information (e-mail, phone number, etc.) for this Identity. ',name:'misp.identity.contact_information',type:'text'},'misp.intrusion_set.id':{category:'misp',description:'Identifier of the Intrusion Set. ',name:'misp.intrusion_set.id',type:'keyword'},'misp.intrusion_set.name':{category:'misp',description:'The name used to identify the Intrusion Set. ',name:'misp.intrusion_set.name',type:'keyword'},'misp.intrusion_set.description':{category:'misp',description:'Description of the Intrusion Set. ',name:'misp.intrusion_set.description',type:'text'},'misp.intrusion_set.aliases':{category:'misp',description:'Alternative names used to identify the Intrusion Set. ',name:'misp.intrusion_set.aliases',type:'text'},'misp.intrusion_set.first_seen':{category:'misp',description:'The time that this Intrusion Set was first seen, in RFC3339 format. ',name:'misp.intrusion_set.first_seen',type:'date'},'misp.intrusion_set.last_seen':{category:'misp',description:'The time that this Intrusion Set was last seen, in RFC3339 format. ',name:'misp.intrusion_set.last_seen',type:'date'},'misp.intrusion_set.goals':{category:'misp',description:'The high level goals of this Intrusion Set, namely, what are they trying to do. ',name:'misp.intrusion_set.goals',type:'text'},'misp.intrusion_set.resource_level':{category:'misp',description:'This defines the organizational level at which this Intrusion Set typically works. Open Vocab - attack-resource-level-ov ',name:'misp.intrusion_set.resource_level',type:'text'},'misp.intrusion_set.primary_motivation':{category:'misp',description:'The primary reason, motivation, or purpose behind this Intrusion Set. Open Vocab - attack-motivation-ov ',name:'misp.intrusion_set.primary_motivation',type:'text'},'misp.intrusion_set.secondary_motivations':{category:'misp',description:'The secondary reasons, motivations, or purposes behind this Intrusion Set. Open Vocab - attack-motivation-ov ',name:'misp.intrusion_set.secondary_motivations',type:'text'},'misp.malware.id':{category:'misp',description:'Identifier of the Malware. ',name:'misp.malware.id',type:'keyword'},'misp.malware.name':{category:'misp',description:'The name used to identify the Malware. ',name:'misp.malware.name',type:'keyword'},'misp.malware.description':{category:'misp',description:'Description of the Malware. ',name:'misp.malware.description',type:'text'},'misp.malware.labels':{category:'misp',description:'The type of malware being described.  Open Vocab - malware-label-ov.  adware,backdoor,bot,ddos,dropper,exploit-kit,keylogger,ransomware, remote-access-trojan,resource-exploitation,rogue-security-software,rootkit, screen-capture,spyware,trojan,virus,worm ',name:'misp.malware.labels',type:'keyword'},'misp.malware.kill_chain_phases':{category:'misp',description:'The list of kill chain phases for which this Malware instance can be used. ',name:'misp.malware.kill_chain_phases',type:'keyword',format:'string'},'misp.note.id':{category:'misp',description:'Identifier of the Note. ',name:'misp.note.id',type:'keyword'},'misp.note.summary':{category:'misp',description:'A brief description used as a summary of the Note. ',name:'misp.note.summary',type:'keyword'},'misp.note.description':{category:'misp',description:'The content of the Note. ',name:'misp.note.description',type:'text'},'misp.note.authors':{category:'misp',description:'The name of the author(s) of this Note. ',name:'misp.note.authors',type:'keyword'},'misp.note.object_refs':{category:'misp',description:'The STIX Objects (SDOs and SROs) that the note is being applied to. ',name:'misp.note.object_refs',type:'keyword'},'misp.threat_indicator.labels':{category:'misp',description:'list of type open-vocab that specifies the type of indicator.   ',example:'Domain Watchlist\n',name:'misp.threat_indicator.labels',type:'keyword'},'misp.threat_indicator.id':{category:'misp',description:'Identifier of the threat indicator. ',name:'misp.threat_indicator.id',type:'keyword'},'misp.threat_indicator.version':{category:'misp',description:'Version of the threat indicator. ',name:'misp.threat_indicator.version',type:'keyword'},'misp.threat_indicator.type':{category:'misp',description:'Type of the threat indicator. ',name:'misp.threat_indicator.type',type:'keyword'},'misp.threat_indicator.description':{category:'misp',description:'Description of the threat indicator. ',name:'misp.threat_indicator.description',type:'text'},'misp.threat_indicator.feed':{category:'misp',description:'Name of the threat feed. ',name:'misp.threat_indicator.feed',type:'text'},'misp.threat_indicator.valid_from':{category:'misp',description:'The time from which this Indicator should be considered valuable  intelligence, in RFC3339 format. ',name:'misp.threat_indicator.valid_from',type:'date'},'misp.threat_indicator.valid_until':{category:'misp',description:'The time at which this Indicator should no longer be considered valuable intelligence. If the valid_until property is omitted, then there is no constraint on the latest time for which the indicator should be used, in RFC3339 format. ',name:'misp.threat_indicator.valid_until',type:'date'},'misp.threat_indicator.severity':{category:'misp',description:'Threat severity to which this indicator corresponds. ',example:'high',name:'misp.threat_indicator.severity',type:'keyword',format:'string'},'misp.threat_indicator.confidence':{category:'misp',description:'Confidence level to which this indicator corresponds. ',example:'high',name:'misp.threat_indicator.confidence',type:'keyword'},'misp.threat_indicator.kill_chain_phases':{category:'misp',description:'The kill chain phase(s) to which this indicator corresponds. ',name:'misp.threat_indicator.kill_chain_phases',type:'keyword',format:'string'},'misp.threat_indicator.mitre_tactic':{category:'misp',description:'MITRE tactics to which this indicator corresponds. ',example:'Initial Access',name:'misp.threat_indicator.mitre_tactic',type:'keyword',format:'string'},'misp.threat_indicator.mitre_technique':{category:'misp',description:'MITRE techniques to which this indicator corresponds. ',example:'Drive-by Compromise',name:'misp.threat_indicator.mitre_technique',type:'keyword',format:'string'},'misp.threat_indicator.attack_pattern':{category:'misp',description:'The attack_pattern for this indicator is a STIX Pattern as specified in STIX Version 2.0 Part 5 - STIX Patterning.  ',example:"[destination:ip = '91.219.29.188/32']\n",name:'misp.threat_indicator.attack_pattern',type:'keyword'},'misp.threat_indicator.attack_pattern_kql':{category:'misp',description:'The attack_pattern for this indicator is KQL query that matches the attack_pattern specified in the STIX Pattern format.  ',example:'destination.ip: "91.219.29.188/32"\n',name:'misp.threat_indicator.attack_pattern_kql',type:'keyword'},'misp.threat_indicator.negate':{category:'misp',description:'When set to true, it specifies the absence of the attack_pattern. ',name:'misp.threat_indicator.negate',type:'boolean'},'misp.threat_indicator.intrusion_set':{category:'misp',description:'Name of the intrusion set if known. ',name:'misp.threat_indicator.intrusion_set',type:'keyword'},'misp.threat_indicator.campaign':{category:'misp',description:'Name of the attack campaign if known. ',name:'misp.threat_indicator.campaign',type:'keyword'},'misp.threat_indicator.threat_actor':{category:'misp',description:'Name of the threat actor if known. ',name:'misp.threat_indicator.threat_actor',type:'keyword'},'misp.observed_data.id':{category:'misp',description:'Identifier of the Observed Data. ',name:'misp.observed_data.id',type:'keyword'},'misp.observed_data.first_observed':{category:'misp',description:'The beginning of the time window that the data was observed, in RFC3339 format. ',name:'misp.observed_data.first_observed',type:'date'},'misp.observed_data.last_observed':{category:'misp',description:'The end of the time window that the data was observed, in RFC3339 format. ',name:'misp.observed_data.last_observed',type:'date'},'misp.observed_data.number_observed':{category:'misp',description:'The number of times the data represented in the objects property was observed. This MUST be an integer between 1 and 999,999,999 inclusive. ',name:'misp.observed_data.number_observed',type:'integer'},'misp.observed_data.objects':{category:'misp',description:'A dictionary of Cyber Observable Objects that describes the single fact that was observed. ',name:'misp.observed_data.objects',type:'keyword'},'misp.report.id':{category:'misp',description:'Identifier of the Report. ',name:'misp.report.id',type:'keyword'},'misp.report.labels':{category:'misp',description:'This field is an Open Vocabulary that specifies the primary subject of this report.  Open Vocab - report-label-ov. threat-report,attack-pattern,campaign,identity,indicator,malware,observed-data,threat-actor,tool,vulnerability ',name:'misp.report.labels',type:'keyword'},'misp.report.name':{category:'misp',description:'The name used to identify the Report. ',name:'misp.report.name',type:'keyword'},'misp.report.description':{category:'misp',description:'A description that provides more details and context about Report. ',name:'misp.report.description',type:'text'},'misp.report.published':{category:'misp',description:'The date that this report object was officially published by the creator of this report, in RFC3339 format. ',name:'misp.report.published',type:'date'},'misp.report.object_refs':{category:'misp',description:'Specifies the STIX Objects that are referred to by this Report. ',name:'misp.report.object_refs',type:'text'},'misp.threat_actor.id':{category:'misp',description:'Identifier of the Threat Actor. ',name:'misp.threat_actor.id',type:'keyword'},'misp.threat_actor.labels':{category:'misp',description:'This field specifies the type of threat actor.  Open Vocab - threat-actor-label-ov. activist,competitor,crime-syndicate,criminal,hacker,insider-accidental,insider-disgruntled,nation-state,sensationalist,spy,terrorist ',name:'misp.threat_actor.labels',type:'keyword'},'misp.threat_actor.name':{category:'misp',description:'The name used to identify this Threat Actor or Threat Actor group. ',name:'misp.threat_actor.name',type:'keyword'},'misp.threat_actor.description':{category:'misp',description:'A description that provides more details and context about the Threat Actor. ',name:'misp.threat_actor.description',type:'text'},'misp.threat_actor.aliases':{category:'misp',description:'A list of other names that this Threat Actor is believed to use. ',name:'misp.threat_actor.aliases',type:'text'},'misp.threat_actor.roles':{category:'misp',description:'This is a list of roles the Threat Actor plays.  Open Vocab - threat-actor-role-ov. agent,director,independent,sponsor,infrastructure-operator,infrastructure-architect,malware-author ',name:'misp.threat_actor.roles',type:'text'},'misp.threat_actor.goals':{category:'misp',description:'The high level goals of this Threat Actor, namely, what are they trying to do. ',name:'misp.threat_actor.goals',type:'text'},'misp.threat_actor.sophistication':{category:'misp',description:'The skill, specific knowledge, special training, or expertise a Threat Actor  must have to perform the attack.  Open Vocab - threat-actor-sophistication-ov. none,minimal,intermediate,advanced,strategic,expert,innovator ',name:'misp.threat_actor.sophistication',type:'text'},'misp.threat_actor.resource_level':{category:'misp',description:'This defines the organizational level at which this Threat Actor typically works.  Open Vocab - attack-resource-level-ov. individual,club,contest,team,organization,government ',name:'misp.threat_actor.resource_level',type:'text'},'misp.threat_actor.primary_motivation':{category:'misp',description:'The primary reason, motivation, or purpose behind this Threat Actor.  Open Vocab - attack-motivation-ov. accidental,coercion,dominance,ideology,notoriety,organizational-gain,personal-gain,personal-satisfaction,revenge,unpredictable ',name:'misp.threat_actor.primary_motivation',type:'text'},'misp.threat_actor.secondary_motivations':{category:'misp',description:'The secondary reasons, motivations, or purposes behind this Threat Actor.  Open Vocab - attack-motivation-ov. accidental,coercion,dominance,ideology,notoriety,organizational-gain,personal-gain,personal-satisfaction,revenge,unpredictable ',name:'misp.threat_actor.secondary_motivations',type:'text'},'misp.threat_actor.personal_motivations':{category:'misp',description:'The personal reasons, motivations, or purposes of the Threat Actor regardless of  organizational goals. Open Vocab - attack-motivation-ov. accidental,coercion,dominance,ideology,notoriety,organizational-gain,personal-gain,personal-satisfaction,revenge,unpredictable ',name:'misp.threat_actor.personal_motivations',type:'text'},'misp.tool.id':{category:'misp',description:'Identifier of the Tool. ',name:'misp.tool.id',type:'keyword'},'misp.tool.labels':{category:'misp',description:'The kind(s) of tool(s) being described.  Open Vocab - tool-label-ov. denial-of-service,exploitation,information-gathering,network-capture,credential-exploitation,remote-access,vulnerability-scanning ',name:'misp.tool.labels',type:'keyword'},'misp.tool.name':{category:'misp',description:'The name used to identify the Tool. ',name:'misp.tool.name',type:'keyword'},'misp.tool.description':{category:'misp',description:'A description that provides more details and context about the Tool. ',name:'misp.tool.description',type:'text'},'misp.tool.tool_version':{category:'misp',description:'The version identifier associated with the Tool. ',name:'misp.tool.tool_version',type:'keyword'},'misp.tool.kill_chain_phases':{category:'misp',description:'The list of kill chain phases for which this Tool instance can be used. ',name:'misp.tool.kill_chain_phases',type:'text'},'misp.vulnerability.id':{category:'misp',description:'Identifier of the Vulnerability. ',name:'misp.vulnerability.id',type:'keyword'},'misp.vulnerability.name':{category:'misp',description:'The name used to identify the Vulnerability. ',name:'misp.vulnerability.name',type:'keyword'},'misp.vulnerability.description':{category:'misp',description:'A description that provides more details and context about the Vulnerability. ',name:'misp.vulnerability.description',type:'text'},'mssql.log.origin':{category:'mssql',description:'Origin of the message, usually the server but it can also be a recovery process',name:'mssql.log.origin',type:'keyword'},'o365.audit.Actor.ID':{category:'o365',name:'o365.audit.Actor.ID',type:'keyword'},'o365.audit.Actor.Type':{category:'o365',name:'o365.audit.Actor.Type',type:'keyword'},'o365.audit.ActorContextId':{category:'o365',name:'o365.audit.ActorContextId',type:'keyword'},'o365.audit.ActorIpAddress':{category:'o365',name:'o365.audit.ActorIpAddress',type:'keyword'},'o365.audit.ActorUserId':{category:'o365',name:'o365.audit.ActorUserId',type:'keyword'},'o365.audit.ActorYammerUserId':{category:'o365',name:'o365.audit.ActorYammerUserId',type:'keyword'},'o365.audit.AlertEntityId':{category:'o365',name:'o365.audit.AlertEntityId',type:'keyword'},'o365.audit.AlertId':{category:'o365',name:'o365.audit.AlertId',type:'keyword'},'o365.audit.AlertLinks':{category:'o365',name:'o365.audit.AlertLinks',type:'array'},'o365.audit.AlertType':{category:'o365',name:'o365.audit.AlertType',type:'keyword'},'o365.audit.AppId':{category:'o365',name:'o365.audit.AppId',type:'keyword'},'o365.audit.ApplicationDisplayName':{category:'o365',name:'o365.audit.ApplicationDisplayName',type:'keyword'},'o365.audit.ApplicationId':{category:'o365',name:'o365.audit.ApplicationId',type:'keyword'},'o365.audit.AzureActiveDirectoryEventType':{category:'o365',name:'o365.audit.AzureActiveDirectoryEventType',type:'keyword'},'o365.audit.ExchangeMetaData.*':{category:'o365',name:'o365.audit.ExchangeMetaData.*',type:'object'},'o365.audit.Category':{category:'o365',name:'o365.audit.Category',type:'keyword'},'o365.audit.ClientAppId':{category:'o365',name:'o365.audit.ClientAppId',type:'keyword'},'o365.audit.ClientInfoString':{category:'o365',name:'o365.audit.ClientInfoString',type:'keyword'},'o365.audit.ClientIP':{category:'o365',name:'o365.audit.ClientIP',type:'keyword'},'o365.audit.ClientIPAddress':{category:'o365',name:'o365.audit.ClientIPAddress',type:'keyword'},'o365.audit.Comments':{category:'o365',name:'o365.audit.Comments',type:'text'},'o365.audit.CorrelationId':{category:'o365',name:'o365.audit.CorrelationId',type:'keyword'},'o365.audit.CreationTime':{category:'o365',name:'o365.audit.CreationTime',type:'keyword'},'o365.audit.CustomUniqueId':{category:'o365',name:'o365.audit.CustomUniqueId',type:'keyword'},'o365.audit.Data':{category:'o365',name:'o365.audit.Data',type:'keyword'},'o365.audit.DataType':{category:'o365',name:'o365.audit.DataType',type:'keyword'},'o365.audit.EntityType':{category:'o365',name:'o365.audit.EntityType',type:'keyword'},'o365.audit.EventData':{category:'o365',name:'o365.audit.EventData',type:'keyword'},'o365.audit.EventSource':{category:'o365',name:'o365.audit.EventSource',type:'keyword'},'o365.audit.ExceptionInfo.*':{category:'o365',name:'o365.audit.ExceptionInfo.*',type:'object'},'o365.audit.ExtendedProperties.*':{category:'o365',name:'o365.audit.ExtendedProperties.*',type:'object'},'o365.audit.ExternalAccess':{category:'o365',name:'o365.audit.ExternalAccess',type:'keyword'},'o365.audit.GroupName':{category:'o365',name:'o365.audit.GroupName',type:'keyword'},'o365.audit.Id':{category:'o365',name:'o365.audit.Id',type:'keyword'},'o365.audit.ImplicitShare':{category:'o365',name:'o365.audit.ImplicitShare',type:'keyword'},'o365.audit.IncidentId':{category:'o365',name:'o365.audit.IncidentId',type:'keyword'},'o365.audit.InternalLogonType':{category:'o365',name:'o365.audit.InternalLogonType',type:'keyword'},'o365.audit.InterSystemsId':{category:'o365',name:'o365.audit.InterSystemsId',type:'keyword'},'o365.audit.IntraSystemId':{category:'o365',name:'o365.audit.IntraSystemId',type:'keyword'},'o365.audit.Item.*':{category:'o365',name:'o365.audit.Item.*',type:'object'},'o365.audit.Item.*.*':{category:'o365',name:'o365.audit.Item.*.*',type:'object'},'o365.audit.ItemName':{category:'o365',name:'o365.audit.ItemName',type:'keyword'},'o365.audit.ItemType':{category:'o365',name:'o365.audit.ItemType',type:'keyword'},'o365.audit.ListId':{category:'o365',name:'o365.audit.ListId',type:'keyword'},'o365.audit.ListItemUniqueId':{category:'o365',name:'o365.audit.ListItemUniqueId',type:'keyword'},'o365.audit.LogonError':{category:'o365',name:'o365.audit.LogonError',type:'keyword'},'o365.audit.LogonType':{category:'o365',name:'o365.audit.LogonType',type:'keyword'},'o365.audit.LogonUserSid':{category:'o365',name:'o365.audit.LogonUserSid',type:'keyword'},'o365.audit.MailboxGuid':{category:'o365',name:'o365.audit.MailboxGuid',type:'keyword'},'o365.audit.MailboxOwnerMasterAccountSid':{category:'o365',name:'o365.audit.MailboxOwnerMasterAccountSid',type:'keyword'},'o365.audit.MailboxOwnerSid':{category:'o365',name:'o365.audit.MailboxOwnerSid',type:'keyword'},'o365.audit.MailboxOwnerUPN':{category:'o365',name:'o365.audit.MailboxOwnerUPN',type:'keyword'},'o365.audit.Members':{category:'o365',name:'o365.audit.Members',type:'array'},'o365.audit.Members.*':{category:'o365',name:'o365.audit.Members.*',type:'object'},'o365.audit.ModifiedProperties.*.*':{category:'o365',name:'o365.audit.ModifiedProperties.*.*',type:'object'},'o365.audit.Name':{category:'o365',name:'o365.audit.Name',type:'keyword'},'o365.audit.ObjectId':{category:'o365',name:'o365.audit.ObjectId',type:'keyword'},'o365.audit.Operation':{category:'o365',name:'o365.audit.Operation',type:'keyword'},'o365.audit.OrganizationId':{category:'o365',name:'o365.audit.OrganizationId',type:'keyword'},'o365.audit.OrganizationName':{category:'o365',name:'o365.audit.OrganizationName',type:'keyword'},'o365.audit.OriginatingServer':{category:'o365',name:'o365.audit.OriginatingServer',type:'keyword'},'o365.audit.Parameters.*':{category:'o365',name:'o365.audit.Parameters.*',type:'object'},'o365.audit.PolicyDetails':{category:'o365',name:'o365.audit.PolicyDetails',type:'array'},'o365.audit.PolicyId':{category:'o365',name:'o365.audit.PolicyId',type:'keyword'},'o365.audit.RecordType':{category:'o365',name:'o365.audit.RecordType',type:'keyword'},'o365.audit.ResultStatus':{category:'o365',name:'o365.audit.ResultStatus',type:'keyword'},'o365.audit.SensitiveInfoDetectionIsIncluded':{category:'o365',name:'o365.audit.SensitiveInfoDetectionIsIncluded',type:'keyword'},'o365.audit.SharePointMetaData.*':{category:'o365',name:'o365.audit.SharePointMetaData.*',type:'object'},'o365.audit.SessionId':{category:'o365',name:'o365.audit.SessionId',type:'keyword'},'o365.audit.Severity':{category:'o365',name:'o365.audit.Severity',type:'keyword'},'o365.audit.Site':{category:'o365',name:'o365.audit.Site',type:'keyword'},'o365.audit.SiteUrl':{category:'o365',name:'o365.audit.SiteUrl',type:'keyword'},'o365.audit.Source':{category:'o365',name:'o365.audit.Source',type:'keyword'},'o365.audit.SourceFileExtension':{category:'o365',name:'o365.audit.SourceFileExtension',type:'keyword'},'o365.audit.SourceFileName':{category:'o365',name:'o365.audit.SourceFileName',type:'keyword'},'o365.audit.SourceRelativeUrl':{category:'o365',name:'o365.audit.SourceRelativeUrl',type:'keyword'},'o365.audit.Status':{category:'o365',name:'o365.audit.Status',type:'keyword'},'o365.audit.SupportTicketId':{category:'o365',name:'o365.audit.SupportTicketId',type:'keyword'},'o365.audit.Target.ID':{category:'o365',name:'o365.audit.Target.ID',type:'keyword'},'o365.audit.Target.Type':{category:'o365',name:'o365.audit.Target.Type',type:'keyword'},'o365.audit.TargetContextId':{category:'o365',name:'o365.audit.TargetContextId',type:'keyword'},'o365.audit.TargetUserOrGroupName':{category:'o365',name:'o365.audit.TargetUserOrGroupName',type:'keyword'},'o365.audit.TargetUserOrGroupType':{category:'o365',name:'o365.audit.TargetUserOrGroupType',type:'keyword'},'o365.audit.TeamName':{category:'o365',name:'o365.audit.TeamName',type:'keyword'},'o365.audit.TeamGuid':{category:'o365',name:'o365.audit.TeamGuid',type:'keyword'},'o365.audit.UniqueSharingId':{category:'o365',name:'o365.audit.UniqueSharingId',type:'keyword'},'o365.audit.UserAgent':{category:'o365',name:'o365.audit.UserAgent',type:'keyword'},'o365.audit.UserId':{category:'o365',name:'o365.audit.UserId',type:'keyword'},'o365.audit.UserKey':{category:'o365',name:'o365.audit.UserKey',type:'keyword'},'o365.audit.UserType':{category:'o365',name:'o365.audit.UserType',type:'keyword'},'o365.audit.Version':{category:'o365',name:'o365.audit.Version',type:'keyword'},'o365.audit.WebId':{category:'o365',name:'o365.audit.WebId',type:'keyword'},'o365.audit.Workload':{category:'o365',name:'o365.audit.Workload',type:'keyword'},'o365.audit.YammerNetworkId':{category:'o365',name:'o365.audit.YammerNetworkId',type:'keyword'},'okta.uuid':{category:'okta',description:'The unique identifier of the Okta LogEvent. ',name:'okta.uuid',type:'keyword'},'okta.event_type':{category:'okta',description:'The type of the LogEvent. ',name:'okta.event_type',type:'keyword'},'okta.version':{category:'okta',description:'The version of the LogEvent. ',name:'okta.version',type:'keyword'},'okta.severity':{category:'okta',description:'The severity of the LogEvent. Must be one of DEBUG, INFO, WARN, or ERROR. ',name:'okta.severity',type:'keyword'},'okta.display_message':{category:'okta',description:'The display message of the LogEvent. ',name:'okta.display_message',type:'keyword'},'okta.actor.id':{category:'okta',description:'Identifier of the actor. ',name:'okta.actor.id',type:'keyword'},'okta.actor.type':{category:'okta',description:'Type of the actor. ',name:'okta.actor.type',type:'keyword'},'okta.actor.alternate_id':{category:'okta',description:'Alternate identifier of the actor. ',name:'okta.actor.alternate_id',type:'keyword'},'okta.actor.display_name':{category:'okta',description:'Display name of the actor. ',name:'okta.actor.display_name',type:'keyword'},'okta.client.ip':{category:'okta',description:'The IP address of the client. ',name:'okta.client.ip',type:'ip'},'okta.client.user_agent.raw_user_agent':{category:'okta',description:'The raw informaton of the user agent. ',name:'okta.client.user_agent.raw_user_agent',type:'keyword'},'okta.client.user_agent.os':{category:'okta',description:'The OS informaton. ',name:'okta.client.user_agent.os',type:'keyword'},'okta.client.user_agent.browser':{category:'okta',description:'The browser informaton of the client. ',name:'okta.client.user_agent.browser',type:'keyword'},'okta.client.zone':{category:'okta',description:'The zone information of the client. ',name:'okta.client.zone',type:'keyword'},'okta.client.device':{category:'okta',description:'The information of the client device. ',name:'okta.client.device',type:'keyword'},'okta.client.id':{category:'okta',description:'The identifier of the client. ',name:'okta.client.id',type:'keyword'},'okta.outcome.reason':{category:'okta',description:'The reason of the outcome. ',name:'okta.outcome.reason',type:'keyword'},'okta.outcome.result':{category:'okta',description:'The result of the outcome. Must be one of: SUCCESS, FAILURE, SKIPPED, ALLOW, DENY, CHALLENGE, UNKNOWN. ',name:'okta.outcome.result',type:'keyword'},'okta.target.id':{category:'okta',description:'Identifier of the actor. ',name:'okta.target.id',type:'keyword'},'okta.target.type':{category:'okta',description:'Type of the actor. ',name:'okta.target.type',type:'keyword'},'okta.target.alternate_id':{category:'okta',description:'Alternate identifier of the actor. ',name:'okta.target.alternate_id',type:'keyword'},'okta.target.display_name':{category:'okta',description:'Display name of the actor. ',name:'okta.target.display_name',type:'keyword'},'okta.transaction.id':{category:'okta',description:'Identifier of the transaction. ',name:'okta.transaction.id',type:'keyword'},'okta.transaction.type':{category:'okta',description:'The type of transaction. Must be one of "WEB", "JOB". ',name:'okta.transaction.type',type:'keyword'},'okta.debug_context.debug_data.device_fingerprint':{category:'okta',description:'The fingerprint of the device. ',name:'okta.debug_context.debug_data.device_fingerprint',type:'keyword'},'okta.debug_context.debug_data.request_id':{category:'okta',description:'The identifier of the request. ',name:'okta.debug_context.debug_data.request_id',type:'keyword'},'okta.debug_context.debug_data.request_uri':{category:'okta',description:'The request URI. ',name:'okta.debug_context.debug_data.request_uri',type:'keyword'},'okta.debug_context.debug_data.threat_suspected':{category:'okta',description:'Threat suspected. ',name:'okta.debug_context.debug_data.threat_suspected',type:'keyword'},'okta.debug_context.debug_data.url':{category:'okta',description:'The URL. ',name:'okta.debug_context.debug_data.url',type:'keyword'},'okta.authentication_context.authentication_provider':{category:'okta',description:'The information about the authentication provider. Must be one of OKTA_AUTHENTICATION_PROVIDER, ACTIVE_DIRECTORY, LDAP, FEDERATION, SOCIAL, FACTOR_PROVIDER. ',name:'okta.authentication_context.authentication_provider',type:'keyword'},'okta.authentication_context.authentication_step':{category:'okta',description:'The authentication step. ',name:'okta.authentication_context.authentication_step',type:'integer'},'okta.authentication_context.credential_provider':{category:'okta',description:'The information about credential provider. Must be one of OKTA_CREDENTIAL_PROVIDER, RSA, SYMANTEC, GOOGLE, DUO, YUBIKEY. ',name:'okta.authentication_context.credential_provider',type:'keyword'},'okta.authentication_context.credential_type':{category:'okta',description:'The information about credential type. Must be one of OTP, SMS, PASSWORD, ASSERTION, IWA, EMAIL, OAUTH2, JWT, CERTIFICATE, PRE_SHARED_SYMMETRIC_KEY, OKTA_CLIENT_SESSION, DEVICE_UDID. ',name:'okta.authentication_context.credential_type',type:'keyword'},'okta.authentication_context.issuer.id':{category:'okta',description:'The identifier of the issuer. ',name:'okta.authentication_context.issuer.id',type:'keyword'},'okta.authentication_context.issuer.type':{category:'okta',description:'The type of the issuer. ',name:'okta.authentication_context.issuer.type',type:'keyword'},'okta.authentication_context.external_session_id':{category:'okta',description:'The session identifer of the external session if any. ',name:'okta.authentication_context.external_session_id',type:'keyword'},'okta.authentication_context.interface':{category:'okta',description:'The interface used. e.g., Outlook, Office365, wsTrust ',name:'okta.authentication_context.interface',type:'keyword'},'okta.security_context.as.number':{category:'okta',description:'The AS number. ',name:'okta.security_context.as.number',type:'integer'},'okta.security_context.as.organization.name':{category:'okta',description:'The organization name. ',name:'okta.security_context.as.organization.name',type:'keyword'},'okta.security_context.isp':{category:'okta',description:'The Internet Service Provider. ',name:'okta.security_context.isp',type:'keyword'},'okta.security_context.domain':{category:'okta',description:'The domain name. ',name:'okta.security_context.domain',type:'keyword'},'okta.security_context.is_proxy':{category:'okta',description:'Whether it is a proxy or not. ',name:'okta.security_context.is_proxy',type:'boolean'},'okta.request.ip_chain.ip':{category:'okta',description:'IP address. ',name:'okta.request.ip_chain.ip',type:'ip'},'okta.request.ip_chain.version':{category:'okta',description:'IP version. Must be one of V4, V6. ',name:'okta.request.ip_chain.version',type:'keyword'},'okta.request.ip_chain.source':{category:'okta',description:'Source information. ',name:'okta.request.ip_chain.source',type:'keyword'},'okta.request.ip_chain.geographical_context.city':{category:'okta',description:'The city.',name:'okta.request.ip_chain.geographical_context.city',type:'keyword'},'okta.request.ip_chain.geographical_context.state':{category:'okta',description:'The state.',name:'okta.request.ip_chain.geographical_context.state',type:'keyword'},'okta.request.ip_chain.geographical_context.postal_code':{category:'okta',description:'The postal code.',name:'okta.request.ip_chain.geographical_context.postal_code',type:'keyword'},'okta.request.ip_chain.geographical_context.country':{category:'okta',description:'The country.',name:'okta.request.ip_chain.geographical_context.country',type:'keyword'},'okta.request.ip_chain.geographical_context.geolocation':{category:'okta',description:'Geolocation information. ',name:'okta.request.ip_chain.geographical_context.geolocation',type:'geo_point'},'panw.panos.ruleset':{category:'panw',description:'Name of the rule that matched this session. ',name:'panw.panos.ruleset',type:'keyword'},'panw.panos.source.zone':{category:'panw',description:'Source zone for this session. ',name:'panw.panos.source.zone',type:'keyword'},'panw.panos.source.interface':{category:'panw',description:'Source interface for this session. ',name:'panw.panos.source.interface',type:'keyword'},'panw.panos.source.nat.ip':{category:'panw',description:'Post-NAT source IP. ',name:'panw.panos.source.nat.ip',type:'ip'},'panw.panos.source.nat.port':{category:'panw',description:'Post-NAT source port. ',name:'panw.panos.source.nat.port',type:'long'},'panw.panos.destination.zone':{category:'panw',description:'Destination zone for this session. ',name:'panw.panos.destination.zone',type:'keyword'},'panw.panos.destination.interface':{category:'panw',description:'Destination interface for this session. ',name:'panw.panos.destination.interface',type:'keyword'},'panw.panos.destination.nat.ip':{category:'panw',description:'Post-NAT destination IP. ',name:'panw.panos.destination.nat.ip',type:'ip'},'panw.panos.destination.nat.port':{category:'panw',description:'Post-NAT destination port. ',name:'panw.panos.destination.nat.port',type:'long'},'panw.panos.network.pcap_id':{category:'panw',description:'Packet capture ID for a threat. ',name:'panw.panos.network.pcap_id',type:'keyword'},'panw.panos.network.nat.community_id':{category:'panw',description:'Community ID flow-hash for the NAT 5-tuple. ',name:'panw.panos.network.nat.community_id',type:'keyword'},'panw.panos.file.hash':{category:'panw',description:'Binary hash for a threat file sent to be analyzed by the WildFire service. ',name:'panw.panos.file.hash',type:'keyword'},'panw.panos.url.category':{category:'panw',description:"For threat URLs, it's the URL category. For WildFire, the verdict on the file and is either 'malicious', 'grayware', or 'benign'. ",name:'panw.panos.url.category',type:'keyword'},'panw.panos.flow_id':{category:'panw',description:'Internal numeric identifier for each session. ',name:'panw.panos.flow_id',type:'keyword'},'panw.panos.sequence_number':{category:'panw',description:'Log entry identifier that is incremented sequentially. Unique for each log type. ',name:'panw.panos.sequence_number',type:'long'},'panw.panos.threat.resource':{category:'panw',description:'URL or file name for a threat. ',name:'panw.panos.threat.resource',type:'keyword'},'panw.panos.threat.id':{category:'panw',description:'Palo Alto Networks identifier for the threat. ',name:'panw.panos.threat.id',type:'keyword'},'panw.panos.threat.name':{category:'panw',description:'Palo Alto Networks name for the threat. ',name:'panw.panos.threat.name',type:'keyword'},'panw.panos.action':{category:'panw',description:'Action taken for the session.',name:'panw.panos.action',type:'keyword'},'rabbitmq.log.pid':{category:'rabbitmq',description:'The Erlang process id',example:'<0.222.0>',name:'rabbitmq.log.pid',type:'keyword'},'sophos.xg.device':{category:'sophos',description:'device ',name:'sophos.xg.device',type:'keyword'},'sophos.xg.date':{category:'sophos',description:'Date (yyyy-mm-dd) when the event occurred ',name:'sophos.xg.date',type:'date'},'sophos.xg.timezone':{category:'sophos',description:'Time (hh:mm:ss) when the event occurred ',name:'sophos.xg.timezone',type:'keyword'},'sophos.xg.device_name':{category:'sophos',description:'Model number of the device ',name:'sophos.xg.device_name',type:'keyword'},'sophos.xg.device_id':{category:'sophos',description:'Serial number of the device ',name:'sophos.xg.device_id',type:'keyword'},'sophos.xg.log_id':{category:'sophos',description:'Unique 12 characters code (0101011) ',name:'sophos.xg.log_id',type:'keyword'},'sophos.xg.log_type':{category:'sophos',description:'Type of event e.g. firewall event ',name:'sophos.xg.log_type',type:'keyword'},'sophos.xg.log_component':{category:'sophos',description:'Component responsible for logging e.g. Firewall rule ',name:'sophos.xg.log_component',type:'keyword'},'sophos.xg.log_subtype':{category:'sophos',description:'Sub type of event ',name:'sophos.xg.log_subtype',type:'keyword'},'sophos.xg.hb_health':{category:'sophos',description:'Heartbeat status ',name:'sophos.xg.hb_health',type:'keyword'},'sophos.xg.priority':{category:'sophos',description:'Severity level of traffic ',name:'sophos.xg.priority',type:'keyword'},'sophos.xg.status':{category:'sophos',description:'Ultimate status of traffic – Allowed or Denied ',name:'sophos.xg.status',type:'keyword'},'sophos.xg.duration':{category:'sophos',description:'Durability of traffic (seconds) ',name:'sophos.xg.duration',type:'long'},'sophos.xg.fw_rule_id':{category:'sophos',description:'Firewall Rule ID which is applied on the traffic ',name:'sophos.xg.fw_rule_id',type:'integer'},'sophos.xg.user_name':{category:'sophos',description:'user_name ',name:'sophos.xg.user_name',type:'keyword'},'sophos.xg.user_group':{category:'sophos',description:'Group name to which the user belongs ',name:'sophos.xg.user_group',type:'keyword'},'sophos.xg.iap':{category:'sophos',description:'Internet Access policy ID applied on the traffic ',name:'sophos.xg.iap',type:'keyword'},'sophos.xg.ips_policy_id':{category:'sophos',description:'IPS policy ID applied on the traffic ',name:'sophos.xg.ips_policy_id',type:'integer'},'sophos.xg.policy_type':{category:'sophos',description:'Policy type applied to the traffic ',name:'sophos.xg.policy_type',type:'keyword'},'sophos.xg.appfilter_policy_id':{category:'sophos',description:'Application Filter policy applied on the traffic ',name:'sophos.xg.appfilter_policy_id',type:'integer'},'sophos.xg.application_filter_policy':{category:'sophos',description:'Application Filter policy applied on the traffic ',name:'sophos.xg.application_filter_policy',type:'integer'},'sophos.xg.application':{category:'sophos',description:'Application name ',name:'sophos.xg.application',type:'keyword'},'sophos.xg.application_name':{category:'sophos',description:'Application name ',name:'sophos.xg.application_name',type:'keyword'},'sophos.xg.application_risk':{category:'sophos',description:'Risk level assigned to the application ',name:'sophos.xg.application_risk',type:'keyword'},'sophos.xg.application_technology':{category:'sophos',description:'Technology of the application ',name:'sophos.xg.application_technology',type:'keyword'},'sophos.xg.application_category':{category:'sophos',description:'Application is resolved by signature or synchronized application ',name:'sophos.xg.application_category',type:'keyword'},'sophos.xg.appresolvedby':{category:'sophos',description:'Technology of the application ',name:'sophos.xg.appresolvedby',type:'keyword'},'sophos.xg.app_is_cloud':{category:'sophos',description:'Application is Cloud ',name:'sophos.xg.app_is_cloud',type:'keyword'},'sophos.xg.in_interface':{category:'sophos',description:'Interface for incoming traffic, e.g., Port A ',name:'sophos.xg.in_interface',type:'keyword'},'sophos.xg.out_interface':{category:'sophos',description:'Interface for outgoing traffic, e.g., Port B ',name:'sophos.xg.out_interface',type:'keyword'},'sophos.xg.src_ip':{category:'sophos',description:'Original source IP address of traffic ',name:'sophos.xg.src_ip',type:'ip'},'sophos.xg.src_mac':{category:'sophos',description:'Original source MAC address of traffic ',name:'sophos.xg.src_mac',type:'keyword'},'sophos.xg.src_country_code':{category:'sophos',description:'Code of the country to which the source IP belongs ',name:'sophos.xg.src_country_code',type:'keyword'},'sophos.xg.dst_ip':{category:'sophos',description:'Original destination IP address of traffic ',name:'sophos.xg.dst_ip',type:'ip'},'sophos.xg.dst_country_code':{category:'sophos',description:'Code of the country to which the destination IP belongs ',name:'sophos.xg.dst_country_code',type:'keyword'},'sophos.xg.protocol':{category:'sophos',description:'Protocol number of traffic ',name:'sophos.xg.protocol',type:'keyword'},'sophos.xg.src_port':{category:'sophos',description:'Original source port of TCP and UDP traffic ',name:'sophos.xg.src_port',type:'integer'},'sophos.xg.dst_port':{category:'sophos',description:'Original destination port of TCP and UDP traffic ',name:'sophos.xg.dst_port',type:'integer'},'sophos.xg.icmp_type':{category:'sophos',description:'ICMP type of ICMP traffic ',name:'sophos.xg.icmp_type',type:'keyword'},'sophos.xg.icmp_code':{category:'sophos',description:'ICMP code of ICMP traffic ',name:'sophos.xg.icmp_code',type:'keyword'},'sophos.xg.sent_pkts':{category:'sophos',description:'Total number of packets sent ',name:'sophos.xg.sent_pkts',type:'long'},'sophos.xg.received_pkts':{category:'sophos',description:'Total number of packets received ',name:'sophos.xg.received_pkts',type:'long'},'sophos.xg.sent_bytes':{category:'sophos',description:'Total number of bytes sent ',name:'sophos.xg.sent_bytes',type:'long'},'sophos.xg.recv_bytes':{category:'sophos',description:'Total number of bytes received ',name:'sophos.xg.recv_bytes',type:'long'},'sophos.xg.trans_src_ ip':{category:'sophos',description:'Translated source IP address for outgoing traffic ',name:'sophos.xg.trans_src_ ip',type:'ip'},'sophos.xg.trans_src_port':{category:'sophos',description:'Translated source port for outgoing traffic ',name:'sophos.xg.trans_src_port',type:'integer'},'sophos.xg.trans_dst_ip':{category:'sophos',description:'Translated destination IP address for outgoing traffic ',name:'sophos.xg.trans_dst_ip',type:'ip'},'sophos.xg.trans_dst_port':{category:'sophos',description:'Translated destination port for outgoing traffic ',name:'sophos.xg.trans_dst_port',type:'integer'},'sophos.xg.srczonetype':{category:'sophos',description:'Type of source zone, e.g., LAN ',name:'sophos.xg.srczonetype',type:'keyword'},'sophos.xg.srczone':{category:'sophos',description:'Name of source zone ',name:'sophos.xg.srczone',type:'keyword'},'sophos.xg.dstzonetype':{category:'sophos',description:'Type of destination zone, e.g., WAN ',name:'sophos.xg.dstzonetype',type:'keyword'},'sophos.xg.dstzone':{category:'sophos',description:'Name of destination zone ',name:'sophos.xg.dstzone',type:'keyword'},'sophos.xg.dir_disp':{category:'sophos',description:'TPacket direction. Possible values:“org”, “reply”, “” ',name:'sophos.xg.dir_disp',type:'keyword'},'sophos.xg.connevent':{category:'sophos',description:'Event on which this log is generated ',name:'sophos.xg.connevent',type:'keyword'},'sophos.xg.conn_id':{category:'sophos',description:'Unique identifier of connection ',name:'sophos.xg.conn_id',type:'integer'},'sophos.xg.vconn_id':{category:'sophos',description:'Connection ID of the master connection ',name:'sophos.xg.vconn_id',type:'integer'},'sophos.xg.idp_policy_id':{category:'sophos',description:'IPS policy ID which is applied on the traffic ',name:'sophos.xg.idp_policy_id',type:'integer'},'sophos.xg.idp_policy_name':{category:'sophos',description:'IPS policy name i.e. IPS policy name which is applied on the traffic ',name:'sophos.xg.idp_policy_name',type:'keyword'},'sophos.xg.signature_id':{category:'sophos',description:'Signature ID ',name:'sophos.xg.signature_id',type:'keyword'},'sophos.xg.signature_msg':{category:'sophos',description:'Signature messsage ',name:'sophos.xg.signature_msg',type:'keyword'},'sophos.xg.classification':{category:'sophos',description:'Signature classification ',name:'sophos.xg.classification',type:'keyword'},'sophos.xg.rule_priority':{category:'sophos',description:'Priority of IPS policy ',name:'sophos.xg.rule_priority',type:'keyword'},'sophos.xg.platform':{category:'sophos',description:'Platform of the traffic. ',name:'sophos.xg.platform',type:'keyword'},'sophos.xg.category':{category:'sophos',description:'IPS signature category. ',name:'sophos.xg.category',type:'keyword'},'sophos.xg.target':{category:'sophos',description:'Platform of the traffic. ',name:'sophos.xg.target',type:'keyword'},'sophos.xg.eventid':{category:'sophos',description:'ATP Evenet ID ',name:'sophos.xg.eventid',type:'keyword'},'sophos.xg.ep_uuid':{category:'sophos',description:'Endpoint UUID ',name:'sophos.xg.ep_uuid',type:'keyword'},'sophos.xg.threatname':{category:'sophos',description:'ATP threatname ',name:'sophos.xg.threatname',type:'keyword'},'sophos.xg.sourceip':{category:'sophos',description:'Original source IP address of traffic ',name:'sophos.xg.sourceip',type:'ip'},'sophos.xg.destinationip':{category:'sophos',description:'Original destination IP address of traffic ',name:'sophos.xg.destinationip',type:'ip'},'sophos.xg.login_user':{category:'sophos',description:'ATP login user ',name:'sophos.xg.login_user',type:'keyword'},'sophos.xg.eventtype':{category:'sophos',description:'ATP event type ',name:'sophos.xg.eventtype',type:'keyword'},'sophos.xg.execution_path':{category:'sophos',description:'ATP execution path ',name:'sophos.xg.execution_path',type:'keyword'},'sophos.xg.av_policy_name':{category:'sophos',description:'Malware scanning policy name which is applied on the traffic ',name:'sophos.xg.av_policy_name',type:'keyword'},'sophos.xg.from_email_address':{category:'sophos',description:'Sender email address ',name:'sophos.xg.from_email_address',type:'keyword'},'sophos.xg.to_email_address':{category:'sophos',description:'Receipeint email address ',name:'sophos.xg.to_email_address',type:'keyword'},'sophos.xg.subject':{category:'sophos',description:'Email subject ',name:'sophos.xg.subject',type:'keyword'},'sophos.xg.mailsize':{category:'sophos',description:'mailsize ',name:'sophos.xg.mailsize',type:'integer'},'sophos.xg.virus':{category:'sophos',description:'virus name ',name:'sophos.xg.virus',type:'keyword'},'sophos.xg.FTP_url':{category:'sophos',description:'FTP URL from which virus was downloaded ',name:'sophos.xg.FTP_url',type:'keyword'},'sophos.xg.FTP_direction':{category:'sophos',description:'Direction of FTP transfer: Upload or Download ',name:'sophos.xg.FTP_direction',type:'keyword'},'sophos.xg.filesize':{category:'sophos',description:'Size of the file that contained virus ',name:'sophos.xg.filesize',type:'integer'},'sophos.xg.filepath':{category:'sophos',description:'Path of the file containing virus ',name:'sophos.xg.filepath',type:'keyword'},'sophos.xg.filename':{category:'sophos',description:'File name associated with the event ',name:'sophos.xg.filename',type:'keyword'},'sophos.xg.ftpcommand':{category:'sophos',description:'FTP command used when virus was found ',name:'sophos.xg.ftpcommand',type:'keyword'},'sophos.xg.url':{category:'sophos',description:'URL from which virus was downloaded ',name:'sophos.xg.url',type:'keyword'},'sophos.xg.domainname':{category:'sophos',description:'Domain from which virus was downloaded ',name:'sophos.xg.domainname',type:'keyword'},'sophos.xg.quarantine':{category:'sophos',description:'Path and filename of the file quarantined ',name:'sophos.xg.quarantine',type:'keyword'},'sophos.xg.src_domainname':{category:'sophos',description:'Sender domain name ',name:'sophos.xg.src_domainname',type:'keyword'},'sophos.xg.dst_domainname':{category:'sophos',description:'Receiver domain name ',name:'sophos.xg.dst_domainname',type:'keyword'},'sophos.xg.reason':{category:'sophos',description:'Reason why the record was detected as spam/malicious ',name:'sophos.xg.reason',type:'keyword'},'sophos.xg.referer':{category:'sophos',description:'Referer ',name:'sophos.xg.referer',type:'keyword'},'sophos.xg.spamaction':{category:'sophos',description:'Spam Action ',name:'sophos.xg.spamaction',type:'keyword'},'sophos.xg.mailid':{category:'sophos',description:'mailid ',name:'sophos.xg.mailid',type:'keyword'},'sophos.xg.quarantine_reason':{category:'sophos',description:'Quarantine reason ',name:'sophos.xg.quarantine_reason',type:'keyword'},'sophos.xg.status_code':{category:'sophos',description:'Status code ',name:'sophos.xg.status_code',type:'keyword'},'sophos.xg.override_token':{category:'sophos',description:'Override token ',name:'sophos.xg.override_token',type:'keyword'},'sophos.xg.con_id':{category:'sophos',description:'Unique identifier of connection ',name:'sophos.xg.con_id',type:'integer'},'sophos.xg.override_authorizer':{category:'sophos',description:'Override authorizer ',name:'sophos.xg.override_authorizer',type:'keyword'},'sophos.xg.transactionid':{category:'sophos',description:'Transaction ID of the AV scan. ',name:'sophos.xg.transactionid',type:'keyword'},'sophos.xg.upload_file_type':{category:'sophos',description:'Upload file type ',name:'sophos.xg.upload_file_type',type:'keyword'},'sophos.xg.upload_file_name':{category:'sophos',description:'Upload file name ',name:'sophos.xg.upload_file_name',type:'keyword'},'sophos.xg.httpresponsecode':{category:'sophos',description:'code of HTTP response ',name:'sophos.xg.httpresponsecode',type:'long'},'sophos.xg.user_gp':{category:'sophos',description:'Group name to which the user belongs. ',name:'sophos.xg.user_gp',type:'keyword'},'sophos.xg.category_type':{category:'sophos',description:'Type of category under which website falls ',name:'sophos.xg.category_type',type:'keyword'},'sophos.xg.download_file_type':{category:'sophos',description:'Download file type ',name:'sophos.xg.download_file_type',type:'keyword'},'sophos.xg.exceptions':{category:'sophos',description:'List of the checks excluded by web exceptions. ',name:'sophos.xg.exceptions',type:'keyword'},'sophos.xg.contenttype':{category:'sophos',description:'Type of the content ',name:'sophos.xg.contenttype',type:'keyword'},'sophos.xg.override_name':{category:'sophos',description:'Override name ',name:'sophos.xg.override_name',type:'keyword'},'sophos.xg.activityname':{category:'sophos',description:'Web policy activity that matched and caused the policy result. ',name:'sophos.xg.activityname',type:'keyword'},'sophos.xg.download_file_name':{category:'sophos',description:'Download file name ',name:'sophos.xg.download_file_name',type:'keyword'},'sophos.xg.sha1sum':{category:'sophos',description:'SHA1 checksum of the item being analyzed ',name:'sophos.xg.sha1sum',type:'keyword'},'sophos.xg.message_id':{category:'sophos',description:'Message ID ',name:'sophos.xg.message_id',type:'keyword'},'sophos.xg.connid':{category:'sophos',description:'Connection ID ',name:'sophos.xg.connid',type:'keyword'},'sophos.xg.message':{category:'sophos',description:'Message ',name:'sophos.xg.message',type:'keyword'},'sophos.xg.email_subject':{category:'sophos',description:'Email Subject ',name:'sophos.xg.email_subject',type:'keyword'},'sophos.xg.file_path':{category:'sophos',description:'File path ',name:'sophos.xg.file_path',type:'keyword'},'sophos.xg.dstdomain':{category:'sophos',description:'Destination Domain ',name:'sophos.xg.dstdomain',type:'keyword'},'sophos.xg.file_size':{category:'sophos',description:'File Size ',name:'sophos.xg.file_size',type:'integer'},'sophos.xg.transaction_id':{category:'sophos',description:'Transaction ID ',name:'sophos.xg.transaction_id',type:'keyword'},'sophos.xg.website':{category:'sophos',description:'Website ',name:'sophos.xg.website',type:'keyword'},'sophos.xg.file_name':{category:'sophos',description:'Filename ',name:'sophos.xg.file_name',type:'keyword'},'sophos.xg.context_prefix':{category:'sophos',description:'Content Prefix ',name:'sophos.xg.context_prefix',type:'keyword'},'sophos.xg.site_category':{category:'sophos',description:'Site Category ',name:'sophos.xg.site_category',type:'keyword'},'sophos.xg.context_suffix':{category:'sophos',description:'Context Suffix ',name:'sophos.xg.context_suffix',type:'keyword'},'sophos.xg.dictionary_name':{category:'sophos',description:'Dictionary Name ',name:'sophos.xg.dictionary_name',type:'keyword'},'sophos.xg.action':{category:'sophos',description:'Event Action ',name:'sophos.xg.action',type:'keyword'},'sophos.xg.user':{category:'sophos',description:'User ',name:'sophos.xg.user',type:'keyword'},'sophos.xg.context_match':{category:'sophos',description:'Context Match ',name:'sophos.xg.context_match',type:'keyword'},'sophos.xg.direction':{category:'sophos',description:'Direction ',name:'sophos.xg.direction',type:'keyword'},'sophos.xg.auth_client':{category:'sophos',description:'Auth Client ',name:'sophos.xg.auth_client',type:'keyword'},'sophos.xg.auth_mechanism':{category:'sophos',description:'Auth mechanism ',name:'sophos.xg.auth_mechanism',type:'keyword'},'sophos.xg.connectionname':{category:'sophos',description:'Connectionname ',name:'sophos.xg.connectionname',type:'keyword'},'sophos.xg.remotenetwork':{category:'sophos',description:'remotenetwork ',name:'sophos.xg.remotenetwork',type:'keyword'},'sophos.xg.localgateway':{category:'sophos',description:'Localgateway ',name:'sophos.xg.localgateway',type:'keyword'},'sophos.xg.localnetwork':{category:'sophos',description:'Localnetwork ',name:'sophos.xg.localnetwork',type:'keyword'},'sophos.xg.connectiontype':{category:'sophos',description:'Connectiontype ',name:'sophos.xg.connectiontype',type:'keyword'},'sophos.xg.oldversion':{category:'sophos',description:'Oldversion ',name:'sophos.xg.oldversion',type:'keyword'},'sophos.xg.newversion':{category:'sophos',description:'Newversion ',name:'sophos.xg.newversion',type:'keyword'},'sophos.xg.ipaddress':{category:'sophos',description:'Ipaddress ',name:'sophos.xg.ipaddress',type:'keyword'},'sophos.xg.client_physical_address':{category:'sophos',description:'Client physical address ',name:'sophos.xg.client_physical_address',type:'keyword'},'sophos.xg.client_host_name':{category:'sophos',description:'Client host name ',name:'sophos.xg.client_host_name',type:'keyword'},'sophos.xg.raw_data':{category:'sophos',description:'Raw data ',name:'sophos.xg.raw_data',type:'keyword'},'sophos.xg.Mode':{category:'sophos',description:'Mode ',name:'sophos.xg.Mode',type:'keyword'},'sophos.xg.sessionid':{category:'sophos',description:'Sessionid ',name:'sophos.xg.sessionid',type:'keyword'},'sophos.xg.starttime':{category:'sophos',description:'Starttime ',name:'sophos.xg.starttime',type:'date'},'sophos.xg.remote_ip':{category:'sophos',description:'Remote IP ',name:'sophos.xg.remote_ip',type:'ip'},'sophos.xg.timestamp':{category:'sophos',description:'timestamp ',name:'sophos.xg.timestamp',type:'date'},'sophos.xg.SysLog_SERVER_NAME':{category:'sophos',description:'SysLog SERVER NAME ',name:'sophos.xg.SysLog_SERVER_NAME',type:'keyword'},'sophos.xg.backup_mode':{category:'sophos',description:'Backup mode ',name:'sophos.xg.backup_mode',type:'keyword'},'sophos.xg.source':{category:'sophos',description:'Source ',name:'sophos.xg.source',type:'keyword'},'sophos.xg.server':{category:'sophos',description:'Server ',name:'sophos.xg.server',type:'keyword'},'sophos.xg.host':{category:'sophos',description:'Host ',name:'sophos.xg.host',type:'keyword'},'sophos.xg.responsetime':{category:'sophos',description:'Responsetime ',name:'sophos.xg.responsetime',type:'long'},'sophos.xg.cookie':{category:'sophos',description:'cookie ',name:'sophos.xg.cookie',type:'keyword'},'sophos.xg.querystring':{category:'sophos',description:'querystring ',name:'sophos.xg.querystring',type:'keyword'},'sophos.xg.extra':{category:'sophos',description:'extra ',name:'sophos.xg.extra',type:'keyword'},'sophos.xg.PHPSESSID':{category:'sophos',description:'PHPSESSID ',name:'sophos.xg.PHPSESSID',type:'keyword'},'sophos.xg.start_time':{category:'sophos',description:'Start time ',name:'sophos.xg.start_time',type:'date'},'sophos.xg.eventtime':{category:'sophos',description:'Event time ',name:'sophos.xg.eventtime',type:'date'},'sophos.xg.red_id':{category:'sophos',description:'RED ID ',name:'sophos.xg.red_id',type:'keyword'},'sophos.xg.branch_name':{category:'sophos',description:'Branch Name ',name:'sophos.xg.branch_name',type:'keyword'},'sophos.xg.updatedip':{category:'sophos',description:'updatedip ',name:'sophos.xg.updatedip',type:'ip'},'sophos.xg.idle_cpu':{category:'sophos',description:'idle ## ',name:'sophos.xg.idle_cpu',type:'float'},'sophos.xg.system_cpu':{category:'sophos',description:'system ',name:'sophos.xg.system_cpu',type:'float'},'sophos.xg.user_cpu':{category:'sophos',description:'system ',name:'sophos.xg.user_cpu',type:'float'},'sophos.xg.used':{category:'sophos',description:'used ',name:'sophos.xg.used',type:'integer'},'sophos.xg.unit':{category:'sophos',description:'unit ',name:'sophos.xg.unit',type:'keyword'},'sophos.xg.total_memory':{category:'sophos',description:'Total Memory ',name:'sophos.xg.total_memory',type:'integer'},'sophos.xg.free':{category:'sophos',description:'free ',name:'sophos.xg.free',type:'integer'},'sophos.xg.transmittederrors':{category:'sophos',description:'transmitted errors ',name:'sophos.xg.transmittederrors',type:'keyword'},'sophos.xg.receivederrors':{category:'sophos',description:'received errors ',name:'sophos.xg.receivederrors',type:'keyword'},'sophos.xg.receivedkbits':{category:'sophos',description:'received kbits ',name:'sophos.xg.receivedkbits',type:'long'},'sophos.xg.transmittedkbits':{category:'sophos',description:'transmitted kbits ',name:'sophos.xg.transmittedkbits',type:'long'},'sophos.xg.transmitteddrops':{category:'sophos',description:'transmitted drops ',name:'sophos.xg.transmitteddrops',type:'long'},'sophos.xg.receiveddrops':{category:'sophos',description:'received drops ',name:'sophos.xg.receiveddrops',type:'long'},'sophos.xg.collisions':{category:'sophos',description:'collisions ',name:'sophos.xg.collisions',type:'long'},'sophos.xg.interface':{category:'sophos',description:'interface ',name:'sophos.xg.interface',type:'keyword'},'sophos.xg.Configuration':{category:'sophos',description:'Configuration ',name:'sophos.xg.Configuration',type:'float'},'sophos.xg.Reports':{category:'sophos',description:'Reports ',name:'sophos.xg.Reports',type:'float'},'sophos.xg.Signature':{category:'sophos',description:'Signature ',name:'sophos.xg.Signature',type:'float'},'sophos.xg.Temp':{category:'sophos',description:'Temp ',name:'sophos.xg.Temp',type:'float'},'sophos.xg.users':{category:'sophos',description:'users ',name:'sophos.xg.users',type:'keyword'},'sophos.xg.ssid':{category:'sophos',description:'ssid ',name:'sophos.xg.ssid',type:'keyword'},'sophos.xg.ap':{category:'sophos',description:'ap ',name:'sophos.xg.ap',type:'keyword'},'sophos.xg.clients_conn_ssid':{category:'sophos',description:'clients connection ssid ',name:'sophos.xg.clients_conn_ssid',type:'keyword'},'suricata.eve.event_type':{category:'suricata',name:'suricata.eve.event_type',type:'keyword'},'suricata.eve.app_proto_orig':{category:'suricata',name:'suricata.eve.app_proto_orig',type:'keyword'},'suricata.eve.tcp.tcp_flags':{category:'suricata',name:'suricata.eve.tcp.tcp_flags',type:'keyword'},'suricata.eve.tcp.psh':{category:'suricata',name:'suricata.eve.tcp.psh',type:'boolean'},'suricata.eve.tcp.tcp_flags_tc':{category:'suricata',name:'suricata.eve.tcp.tcp_flags_tc',type:'keyword'},'suricata.eve.tcp.ack':{category:'suricata',name:'suricata.eve.tcp.ack',type:'boolean'},'suricata.eve.tcp.syn':{category:'suricata',name:'suricata.eve.tcp.syn',type:'boolean'},'suricata.eve.tcp.state':{category:'suricata',name:'suricata.eve.tcp.state',type:'keyword'},'suricata.eve.tcp.tcp_flags_ts':{category:'suricata',name:'suricata.eve.tcp.tcp_flags_ts',type:'keyword'},'suricata.eve.tcp.rst':{category:'suricata',name:'suricata.eve.tcp.rst',type:'boolean'},'suricata.eve.tcp.fin':{category:'suricata',name:'suricata.eve.tcp.fin',type:'boolean'},'suricata.eve.fileinfo.sha1':{category:'suricata',name:'suricata.eve.fileinfo.sha1',type:'keyword'},'suricata.eve.fileinfo.filename':{category:'suricata',name:'suricata.eve.fileinfo.filename',type:'alias'},'suricata.eve.fileinfo.tx_id':{category:'suricata',name:'suricata.eve.fileinfo.tx_id',type:'long'},'suricata.eve.fileinfo.state':{category:'suricata',name:'suricata.eve.fileinfo.state',type:'keyword'},'suricata.eve.fileinfo.stored':{category:'suricata',name:'suricata.eve.fileinfo.stored',type:'boolean'},'suricata.eve.fileinfo.gaps':{category:'suricata',name:'suricata.eve.fileinfo.gaps',type:'boolean'},'suricata.eve.fileinfo.sha256':{category:'suricata',name:'suricata.eve.fileinfo.sha256',type:'keyword'},'suricata.eve.fileinfo.md5':{category:'suricata',name:'suricata.eve.fileinfo.md5',type:'keyword'},'suricata.eve.fileinfo.size':{category:'suricata',name:'suricata.eve.fileinfo.size',type:'alias'},'suricata.eve.icmp_type':{category:'suricata',name:'suricata.eve.icmp_type',type:'long'},'suricata.eve.dest_port':{category:'suricata',name:'suricata.eve.dest_port',type:'alias'},'suricata.eve.src_port':{category:'suricata',name:'suricata.eve.src_port',type:'alias'},'suricata.eve.proto':{category:'suricata',name:'suricata.eve.proto',type:'alias'},'suricata.eve.pcap_cnt':{category:'suricata',name:'suricata.eve.pcap_cnt',type:'long'},'suricata.eve.src_ip':{category:'suricata',name:'suricata.eve.src_ip',type:'alias'},'suricata.eve.dns.type':{category:'suricata',name:'suricata.eve.dns.type',type:'keyword'},'suricata.eve.dns.rrtype':{category:'suricata',name:'suricata.eve.dns.rrtype',type:'keyword'},'suricata.eve.dns.rrname':{category:'suricata',name:'suricata.eve.dns.rrname',type:'keyword'},'suricata.eve.dns.rdata':{category:'suricata',name:'suricata.eve.dns.rdata',type:'keyword'},'suricata.eve.dns.tx_id':{category:'suricata',name:'suricata.eve.dns.tx_id',type:'long'},'suricata.eve.dns.ttl':{category:'suricata',name:'suricata.eve.dns.ttl',type:'long'},'suricata.eve.dns.rcode':{category:'suricata',name:'suricata.eve.dns.rcode',type:'keyword'},'suricata.eve.dns.id':{category:'suricata',name:'suricata.eve.dns.id',type:'long'},'suricata.eve.flow_id':{category:'suricata',name:'suricata.eve.flow_id',type:'keyword'},'suricata.eve.email.status':{category:'suricata',name:'suricata.eve.email.status',type:'keyword'},'suricata.eve.dest_ip':{category:'suricata',name:'suricata.eve.dest_ip',type:'alias'},'suricata.eve.icmp_code':{category:'suricata',name:'suricata.eve.icmp_code',type:'long'},'suricata.eve.http.status':{category:'suricata',name:'suricata.eve.http.status',type:'alias'},'suricata.eve.http.redirect':{category:'suricata',name:'suricata.eve.http.redirect',type:'keyword'},'suricata.eve.http.http_user_agent':{category:'suricata',name:'suricata.eve.http.http_user_agent',type:'alias'},'suricata.eve.http.protocol':{category:'suricata',name:'suricata.eve.http.protocol',type:'keyword'},'suricata.eve.http.http_refer':{category:'suricata',name:'suricata.eve.http.http_refer',type:'alias'},'suricata.eve.http.url':{category:'suricata',name:'suricata.eve.http.url',type:'alias'},'suricata.eve.http.hostname':{category:'suricata',name:'suricata.eve.http.hostname',type:'alias'},'suricata.eve.http.length':{category:'suricata',name:'suricata.eve.http.length',type:'alias'},'suricata.eve.http.http_method':{category:'suricata',name:'suricata.eve.http.http_method',type:'alias'},'suricata.eve.http.http_content_type':{category:'suricata',name:'suricata.eve.http.http_content_type',type:'keyword'},'suricata.eve.timestamp':{category:'suricata',name:'suricata.eve.timestamp',type:'alias'},'suricata.eve.in_iface':{category:'suricata',name:'suricata.eve.in_iface',type:'keyword'},'suricata.eve.alert.category':{category:'suricata',name:'suricata.eve.alert.category',type:'keyword'},'suricata.eve.alert.severity':{category:'suricata',name:'suricata.eve.alert.severity',type:'alias'},'suricata.eve.alert.rev':{category:'suricata',name:'suricata.eve.alert.rev',type:'long'},'suricata.eve.alert.gid':{category:'suricata',name:'suricata.eve.alert.gid',type:'long'},'suricata.eve.alert.signature':{category:'suricata',name:'suricata.eve.alert.signature',type:'keyword'},'suricata.eve.alert.action':{category:'suricata',name:'suricata.eve.alert.action',type:'alias'},'suricata.eve.alert.signature_id':{category:'suricata',name:'suricata.eve.alert.signature_id',type:'long'},'suricata.eve.ssh.client.proto_version':{category:'suricata',name:'suricata.eve.ssh.client.proto_version',type:'keyword'},'suricata.eve.ssh.client.software_version':{category:'suricata',name:'suricata.eve.ssh.client.software_version',type:'keyword'},'suricata.eve.ssh.server.proto_version':{category:'suricata',name:'suricata.eve.ssh.server.proto_version',type:'keyword'},'suricata.eve.ssh.server.software_version':{category:'suricata',name:'suricata.eve.ssh.server.software_version',type:'keyword'},'suricata.eve.stats.capture.kernel_packets':{category:'suricata',name:'suricata.eve.stats.capture.kernel_packets',type:'long'},'suricata.eve.stats.capture.kernel_drops':{category:'suricata',name:'suricata.eve.stats.capture.kernel_drops',type:'long'},'suricata.eve.stats.capture.kernel_ifdrops':{category:'suricata',name:'suricata.eve.stats.capture.kernel_ifdrops',type:'long'},'suricata.eve.stats.uptime':{category:'suricata',name:'suricata.eve.stats.uptime',type:'long'},'suricata.eve.stats.detect.alert':{category:'suricata',name:'suricata.eve.stats.detect.alert',type:'long'},'suricata.eve.stats.http.memcap':{category:'suricata',name:'suricata.eve.stats.http.memcap',type:'long'},'suricata.eve.stats.http.memuse':{category:'suricata',name:'suricata.eve.stats.http.memuse',type:'long'},'suricata.eve.stats.file_store.open_files':{category:'suricata',name:'suricata.eve.stats.file_store.open_files',type:'long'},'suricata.eve.stats.defrag.max_frag_hits':{category:'suricata',name:'suricata.eve.stats.defrag.max_frag_hits',type:'long'},'suricata.eve.stats.defrag.ipv4.timeouts':{category:'suricata',name:'suricata.eve.stats.defrag.ipv4.timeouts',type:'long'},'suricata.eve.stats.defrag.ipv4.fragments':{category:'suricata',name:'suricata.eve.stats.defrag.ipv4.fragments',type:'long'},'suricata.eve.stats.defrag.ipv4.reassembled':{category:'suricata',name:'suricata.eve.stats.defrag.ipv4.reassembled',type:'long'},'suricata.eve.stats.defrag.ipv6.timeouts':{category:'suricata',name:'suricata.eve.stats.defrag.ipv6.timeouts',type:'long'},'suricata.eve.stats.defrag.ipv6.fragments':{category:'suricata',name:'suricata.eve.stats.defrag.ipv6.fragments',type:'long'},'suricata.eve.stats.defrag.ipv6.reassembled':{category:'suricata',name:'suricata.eve.stats.defrag.ipv6.reassembled',type:'long'},'suricata.eve.stats.flow.tcp_reuse':{category:'suricata',name:'suricata.eve.stats.flow.tcp_reuse',type:'long'},'suricata.eve.stats.flow.udp':{category:'suricata',name:'suricata.eve.stats.flow.udp',type:'long'},'suricata.eve.stats.flow.memcap':{category:'suricata',name:'suricata.eve.stats.flow.memcap',type:'long'},'suricata.eve.stats.flow.emerg_mode_entered':{category:'suricata',name:'suricata.eve.stats.flow.emerg_mode_entered',type:'long'},'suricata.eve.stats.flow.emerg_mode_over':{category:'suricata',name:'suricata.eve.stats.flow.emerg_mode_over',type:'long'},'suricata.eve.stats.flow.tcp':{category:'suricata',name:'suricata.eve.stats.flow.tcp',type:'long'},'suricata.eve.stats.flow.icmpv6':{category:'suricata',name:'suricata.eve.stats.flow.icmpv6',type:'long'},'suricata.eve.stats.flow.icmpv4':{category:'suricata',name:'suricata.eve.stats.flow.icmpv4',type:'long'},'suricata.eve.stats.flow.spare':{category:'suricata',name:'suricata.eve.stats.flow.spare',type:'long'},'suricata.eve.stats.flow.memuse':{category:'suricata',name:'suricata.eve.stats.flow.memuse',type:'long'},'suricata.eve.stats.tcp.pseudo_failed':{category:'suricata',name:'suricata.eve.stats.tcp.pseudo_failed',type:'long'},'suricata.eve.stats.tcp.ssn_memcap_drop':{category:'suricata',name:'suricata.eve.stats.tcp.ssn_memcap_drop',type:'long'},'suricata.eve.stats.tcp.insert_data_overlap_fail':{category:'suricata',name:'suricata.eve.stats.tcp.insert_data_overlap_fail',type:'long'},'suricata.eve.stats.tcp.sessions':{category:'suricata',name:'suricata.eve.stats.tcp.sessions',type:'long'},'suricata.eve.stats.tcp.pseudo':{category:'suricata',name:'suricata.eve.stats.tcp.pseudo',type:'long'},'suricata.eve.stats.tcp.synack':{category:'suricata',name:'suricata.eve.stats.tcp.synack',type:'long'},'suricata.eve.stats.tcp.insert_data_normal_fail':{category:'suricata',name:'suricata.eve.stats.tcp.insert_data_normal_fail',type:'long'},'suricata.eve.stats.tcp.syn':{category:'suricata',name:'suricata.eve.stats.tcp.syn',type:'long'},'suricata.eve.stats.tcp.memuse':{category:'suricata',name:'suricata.eve.stats.tcp.memuse',type:'long'},'suricata.eve.stats.tcp.invalid_checksum':{category:'suricata',name:'suricata.eve.stats.tcp.invalid_checksum',type:'long'},'suricata.eve.stats.tcp.segment_memcap_drop':{category:'suricata',name:'suricata.eve.stats.tcp.segment_memcap_drop',type:'long'},'suricata.eve.stats.tcp.overlap':{category:'suricata',name:'suricata.eve.stats.tcp.overlap',type:'long'},'suricata.eve.stats.tcp.insert_list_fail':{category:'suricata',name:'suricata.eve.stats.tcp.insert_list_fail',type:'long'},'suricata.eve.stats.tcp.rst':{category:'suricata',name:'suricata.eve.stats.tcp.rst',type:'long'},'suricata.eve.stats.tcp.stream_depth_reached':{category:'suricata',name:'suricata.eve.stats.tcp.stream_depth_reached',type:'long'},'suricata.eve.stats.tcp.reassembly_memuse':{category:'suricata',name:'suricata.eve.stats.tcp.reassembly_memuse',type:'long'},'suricata.eve.stats.tcp.reassembly_gap':{category:'suricata',name:'suricata.eve.stats.tcp.reassembly_gap',type:'long'},'suricata.eve.stats.tcp.overlap_diff_data':{category:'suricata',name:'suricata.eve.stats.tcp.overlap_diff_data',type:'long'},'suricata.eve.stats.tcp.no_flow':{category:'suricata',name:'suricata.eve.stats.tcp.no_flow',type:'long'},'suricata.eve.stats.decoder.avg_pkt_size':{category:'suricata',name:'suricata.eve.stats.decoder.avg_pkt_size',type:'long'},'suricata.eve.stats.decoder.bytes':{category:'suricata',name:'suricata.eve.stats.decoder.bytes',type:'long'},'suricata.eve.stats.decoder.tcp':{category:'suricata',name:'suricata.eve.stats.decoder.tcp',type:'long'},'suricata.eve.stats.decoder.raw':{category:'suricata',name:'suricata.eve.stats.decoder.raw',type:'long'},'suricata.eve.stats.decoder.ppp':{category:'suricata',name:'suricata.eve.stats.decoder.ppp',type:'long'},'suricata.eve.stats.decoder.vlan_qinq':{category:'suricata',name:'suricata.eve.stats.decoder.vlan_qinq',type:'long'},'suricata.eve.stats.decoder.null':{category:'suricata',name:'suricata.eve.stats.decoder.null',type:'long'},'suricata.eve.stats.decoder.ltnull.unsupported_type':{category:'suricata',name:'suricata.eve.stats.decoder.ltnull.unsupported_type',type:'long'},'suricata.eve.stats.decoder.ltnull.pkt_too_small':{category:'suricata',name:'suricata.eve.stats.decoder.ltnull.pkt_too_small',type:'long'},'suricata.eve.stats.decoder.invalid':{category:'suricata',name:'suricata.eve.stats.decoder.invalid',type:'long'},'suricata.eve.stats.decoder.gre':{category:'suricata',name:'suricata.eve.stats.decoder.gre',type:'long'},'suricata.eve.stats.decoder.ipv4':{category:'suricata',name:'suricata.eve.stats.decoder.ipv4',type:'long'},'suricata.eve.stats.decoder.ipv6':{category:'suricata',name:'suricata.eve.stats.decoder.ipv6',type:'long'},'suricata.eve.stats.decoder.pkts':{category:'suricata',name:'suricata.eve.stats.decoder.pkts',type:'long'},'suricata.eve.stats.decoder.ipv6_in_ipv6':{category:'suricata',name:'suricata.eve.stats.decoder.ipv6_in_ipv6',type:'long'},'suricata.eve.stats.decoder.ipraw.invalid_ip_version':{category:'suricata',name:'suricata.eve.stats.decoder.ipraw.invalid_ip_version',type:'long'},'suricata.eve.stats.decoder.pppoe':{category:'suricata',name:'suricata.eve.stats.decoder.pppoe',type:'long'},'suricata.eve.stats.decoder.udp':{category:'suricata',name:'suricata.eve.stats.decoder.udp',type:'long'},'suricata.eve.stats.decoder.dce.pkt_too_small':{category:'suricata',name:'suricata.eve.stats.decoder.dce.pkt_too_small',type:'long'},'suricata.eve.stats.decoder.vlan':{category:'suricata',name:'suricata.eve.stats.decoder.vlan',type:'long'},'suricata.eve.stats.decoder.sctp':{category:'suricata',name:'suricata.eve.stats.decoder.sctp',type:'long'},'suricata.eve.stats.decoder.max_pkt_size':{category:'suricata',name:'suricata.eve.stats.decoder.max_pkt_size',type:'long'},'suricata.eve.stats.decoder.teredo':{category:'suricata',name:'suricata.eve.stats.decoder.teredo',type:'long'},'suricata.eve.stats.decoder.mpls':{category:'suricata',name:'suricata.eve.stats.decoder.mpls',type:'long'},'suricata.eve.stats.decoder.sll':{category:'suricata',name:'suricata.eve.stats.decoder.sll',type:'long'},'suricata.eve.stats.decoder.icmpv6':{category:'suricata',name:'suricata.eve.stats.decoder.icmpv6',type:'long'},'suricata.eve.stats.decoder.icmpv4':{category:'suricata',name:'suricata.eve.stats.decoder.icmpv4',type:'long'},'suricata.eve.stats.decoder.erspan':{category:'suricata',name:'suricata.eve.stats.decoder.erspan',type:'long'},'suricata.eve.stats.decoder.ethernet':{category:'suricata',name:'suricata.eve.stats.decoder.ethernet',type:'long'},'suricata.eve.stats.decoder.ipv4_in_ipv6':{category:'suricata',name:'suricata.eve.stats.decoder.ipv4_in_ipv6',type:'long'},'suricata.eve.stats.decoder.ieee8021ah':{category:'suricata',name:'suricata.eve.stats.decoder.ieee8021ah',type:'long'},'suricata.eve.stats.dns.memcap_global':{category:'suricata',name:'suricata.eve.stats.dns.memcap_global',type:'long'},'suricata.eve.stats.dns.memcap_state':{category:'suricata',name:'suricata.eve.stats.dns.memcap_state',type:'long'},'suricata.eve.stats.dns.memuse':{category:'suricata',name:'suricata.eve.stats.dns.memuse',type:'long'},'suricata.eve.stats.flow_mgr.rows_busy':{category:'suricata',name:'suricata.eve.stats.flow_mgr.rows_busy',type:'long'},'suricata.eve.stats.flow_mgr.flows_timeout':{category:'suricata',name:'suricata.eve.stats.flow_mgr.flows_timeout',type:'long'},'suricata.eve.stats.flow_mgr.flows_notimeout':{category:'suricata',name:'suricata.eve.stats.flow_mgr.flows_notimeout',type:'long'},'suricata.eve.stats.flow_mgr.rows_skipped':{category:'suricata',name:'suricata.eve.stats.flow_mgr.rows_skipped',type:'long'},'suricata.eve.stats.flow_mgr.closed_pruned':{category:'suricata',name:'suricata.eve.stats.flow_mgr.closed_pruned',type:'long'},'suricata.eve.stats.flow_mgr.new_pruned':{category:'suricata',name:'suricata.eve.stats.flow_mgr.new_pruned',type:'long'},'suricata.eve.stats.flow_mgr.flows_removed':{category:'suricata',name:'suricata.eve.stats.flow_mgr.flows_removed',type:'long'},'suricata.eve.stats.flow_mgr.bypassed_pruned':{category:'suricata',name:'suricata.eve.stats.flow_mgr.bypassed_pruned',type:'long'},'suricata.eve.stats.flow_mgr.est_pruned':{category:'suricata',name:'suricata.eve.stats.flow_mgr.est_pruned',type:'long'},'suricata.eve.stats.flow_mgr.flows_timeout_inuse':{category:'suricata',name:'suricata.eve.stats.flow_mgr.flows_timeout_inuse',type:'long'},'suricata.eve.stats.flow_mgr.flows_checked':{category:'suricata',name:'suricata.eve.stats.flow_mgr.flows_checked',type:'long'},'suricata.eve.stats.flow_mgr.rows_maxlen':{category:'suricata',name:'suricata.eve.stats.flow_mgr.rows_maxlen',type:'long'},'suricata.eve.stats.flow_mgr.rows_checked':{category:'suricata',name:'suricata.eve.stats.flow_mgr.rows_checked',type:'long'},'suricata.eve.stats.flow_mgr.rows_empty':{category:'suricata',name:'suricata.eve.stats.flow_mgr.rows_empty',type:'long'},'suricata.eve.stats.app_layer.flow.tls':{category:'suricata',name:'suricata.eve.stats.app_layer.flow.tls',type:'long'},'suricata.eve.stats.app_layer.flow.ftp':{category:'suricata',name:'suricata.eve.stats.app_layer.flow.ftp',type:'long'},'suricata.eve.stats.app_layer.flow.http':{category:'suricata',name:'suricata.eve.stats.app_layer.flow.http',type:'long'},'suricata.eve.stats.app_layer.flow.failed_udp':{category:'suricata',name:'suricata.eve.stats.app_layer.flow.failed_udp',type:'long'},'suricata.eve.stats.app_layer.flow.dns_udp':{category:'suricata',name:'suricata.eve.stats.app_layer.flow.dns_udp',type:'long'},'suricata.eve.stats.app_layer.flow.dns_tcp':{category:'suricata',name:'suricata.eve.stats.app_layer.flow.dns_tcp',type:'long'},'suricata.eve.stats.app_layer.flow.smtp':{category:'suricata',name:'suricata.eve.stats.app_layer.flow.smtp',type:'long'},'suricata.eve.stats.app_layer.flow.failed_tcp':{category:'suricata',name:'suricata.eve.stats.app_layer.flow.failed_tcp',type:'long'},'suricata.eve.stats.app_layer.flow.msn':{category:'suricata',name:'suricata.eve.stats.app_layer.flow.msn',type:'long'},'suricata.eve.stats.app_layer.flow.ssh':{category:'suricata',name:'suricata.eve.stats.app_layer.flow.ssh',type:'long'},'suricata.eve.stats.app_layer.flow.imap':{category:'suricata',name:'suricata.eve.stats.app_layer.flow.imap',type:'long'},'suricata.eve.stats.app_layer.flow.dcerpc_udp':{category:'suricata',name:'suricata.eve.stats.app_layer.flow.dcerpc_udp',type:'long'},'suricata.eve.stats.app_layer.flow.dcerpc_tcp':{category:'suricata',name:'suricata.eve.stats.app_layer.flow.dcerpc_tcp',type:'long'},'suricata.eve.stats.app_layer.flow.smb':{category:'suricata',name:'suricata.eve.stats.app_layer.flow.smb',type:'long'},'suricata.eve.stats.app_layer.tx.tls':{category:'suricata',name:'suricata.eve.stats.app_layer.tx.tls',type:'long'},'suricata.eve.stats.app_layer.tx.ftp':{category:'suricata',name:'suricata.eve.stats.app_layer.tx.ftp',type:'long'},'suricata.eve.stats.app_layer.tx.http':{category:'suricata',name:'suricata.eve.stats.app_layer.tx.http',type:'long'},'suricata.eve.stats.app_layer.tx.dns_udp':{category:'suricata',name:'suricata.eve.stats.app_layer.tx.dns_udp',type:'long'},'suricata.eve.stats.app_layer.tx.dns_tcp':{category:'suricata',name:'suricata.eve.stats.app_layer.tx.dns_tcp',type:'long'},'suricata.eve.stats.app_layer.tx.smtp':{category:'suricata',name:'suricata.eve.stats.app_layer.tx.smtp',type:'long'},'suricata.eve.stats.app_layer.tx.ssh':{category:'suricata',name:'suricata.eve.stats.app_layer.tx.ssh',type:'long'},'suricata.eve.stats.app_layer.tx.dcerpc_udp':{category:'suricata',name:'suricata.eve.stats.app_layer.tx.dcerpc_udp',type:'long'},'suricata.eve.stats.app_layer.tx.dcerpc_tcp':{category:'suricata',name:'suricata.eve.stats.app_layer.tx.dcerpc_tcp',type:'long'},'suricata.eve.stats.app_layer.tx.smb':{category:'suricata',name:'suricata.eve.stats.app_layer.tx.smb',type:'long'},'suricata.eve.tls.notbefore':{category:'suricata',name:'suricata.eve.tls.notbefore',type:'date'},'suricata.eve.tls.issuerdn':{category:'suricata',name:'suricata.eve.tls.issuerdn',type:'keyword'},'suricata.eve.tls.sni':{category:'suricata',name:'suricata.eve.tls.sni',type:'keyword'},'suricata.eve.tls.version':{category:'suricata',name:'suricata.eve.tls.version',type:'keyword'},'suricata.eve.tls.session_resumed':{category:'suricata',name:'suricata.eve.tls.session_resumed',type:'boolean'},'suricata.eve.tls.fingerprint':{category:'suricata',name:'suricata.eve.tls.fingerprint',type:'keyword'},'suricata.eve.tls.serial':{category:'suricata',name:'suricata.eve.tls.serial',type:'keyword'},'suricata.eve.tls.notafter':{category:'suricata',name:'suricata.eve.tls.notafter',type:'date'},'suricata.eve.tls.subject':{category:'suricata',name:'suricata.eve.tls.subject',type:'keyword'},'suricata.eve.tls.ja3s.string':{category:'suricata',name:'suricata.eve.tls.ja3s.string',type:'keyword'},'suricata.eve.tls.ja3s.hash':{category:'suricata',name:'suricata.eve.tls.ja3s.hash',type:'keyword'},'suricata.eve.tls.ja3.string':{category:'suricata',name:'suricata.eve.tls.ja3.string',type:'keyword'},'suricata.eve.tls.ja3.hash':{category:'suricata',name:'suricata.eve.tls.ja3.hash',type:'keyword'},'suricata.eve.app_proto_ts':{category:'suricata',name:'suricata.eve.app_proto_ts',type:'keyword'},'suricata.eve.flow.bytes_toclient':{category:'suricata',name:'suricata.eve.flow.bytes_toclient',type:'alias'},'suricata.eve.flow.start':{category:'suricata',name:'suricata.eve.flow.start',type:'alias'},'suricata.eve.flow.pkts_toclient':{category:'suricata',name:'suricata.eve.flow.pkts_toclient',type:'alias'},'suricata.eve.flow.age':{category:'suricata',name:'suricata.eve.flow.age',type:'long'},'suricata.eve.flow.state':{category:'suricata',name:'suricata.eve.flow.state',type:'keyword'},'suricata.eve.flow.bytes_toserver':{category:'suricata',name:'suricata.eve.flow.bytes_toserver',type:'alias'},'suricata.eve.flow.reason':{category:'suricata',name:'suricata.eve.flow.reason',type:'keyword'},'suricata.eve.flow.pkts_toserver':{category:'suricata',name:'suricata.eve.flow.pkts_toserver',type:'alias'},'suricata.eve.flow.end':{category:'suricata',name:'suricata.eve.flow.end',type:'date'},'suricata.eve.flow.alerted':{category:'suricata',name:'suricata.eve.flow.alerted',type:'boolean'},'suricata.eve.app_proto':{category:'suricata',name:'suricata.eve.app_proto',type:'alias'},'suricata.eve.tx_id':{category:'suricata',name:'suricata.eve.tx_id',type:'long'},'suricata.eve.app_proto_tc':{category:'suricata',name:'suricata.eve.app_proto_tc',type:'keyword'},'suricata.eve.smtp.rcpt_to':{category:'suricata',name:'suricata.eve.smtp.rcpt_to',type:'keyword'},'suricata.eve.smtp.mail_from':{category:'suricata',name:'suricata.eve.smtp.mail_from',type:'keyword'},'suricata.eve.smtp.helo':{category:'suricata',name:'suricata.eve.smtp.helo',type:'keyword'},'suricata.eve.app_proto_expected':{category:'suricata',name:'suricata.eve.app_proto_expected',type:'keyword'},'suricata.eve.flags':{category:'suricata',name:'suricata.eve.flags',type:'group'},'zeek.session_id':{category:'zeek',description:'A unique identifier of the session ',name:'zeek.session_id',type:'keyword'},'zeek.capture_loss.ts_delta':{category:'zeek',description:'The time delay between this measurement and the last. ',name:'zeek.capture_loss.ts_delta',type:'integer'},'zeek.capture_loss.peer':{category:'zeek',description:'In the event that there are multiple Bro instances logging to the same host, this distinguishes each peer with its individual name. ',name:'zeek.capture_loss.peer',type:'keyword'},'zeek.capture_loss.gaps':{category:'zeek',description:'Number of missed ACKs from the previous measurement interval. ',name:'zeek.capture_loss.gaps',type:'integer'},'zeek.capture_loss.acks':{category:'zeek',description:'Total number of ACKs seen in the previous measurement interval. ',name:'zeek.capture_loss.acks',type:'integer'},'zeek.capture_loss.percent_lost':{category:'zeek',description:"Percentage of ACKs seen where the data being ACKed wasn't seen. ",name:'zeek.capture_loss.percent_lost',type:'double'},'zeek.connection.local_orig':{category:'zeek',description:'Indicates whether the session is originated locally. ',name:'zeek.connection.local_orig',type:'boolean'},'zeek.connection.local_resp':{category:'zeek',description:'Indicates whether the session is responded locally. ',name:'zeek.connection.local_resp',type:'boolean'},'zeek.connection.missed_bytes':{category:'zeek',description:'Missed bytes for the session. ',name:'zeek.connection.missed_bytes',type:'long'},'zeek.connection.state':{category:'zeek',description:'Code indicating the state of the session. ',name:'zeek.connection.state',type:'keyword'},'zeek.connection.state_message':{category:'zeek',description:'The state of the session. ',name:'zeek.connection.state_message',type:'keyword'},'zeek.connection.icmp.type':{category:'zeek',description:'ICMP message type. ',name:'zeek.connection.icmp.type',type:'integer'},'zeek.connection.icmp.code':{category:'zeek',description:'ICMP message code. ',name:'zeek.connection.icmp.code',type:'integer'},'zeek.connection.history':{category:'zeek',description:'Flags indicating the history of the session. ',name:'zeek.connection.history',type:'keyword'},'zeek.connection.vlan':{category:'zeek',description:'VLAN identifier. ',name:'zeek.connection.vlan',type:'integer'},'zeek.connection.inner_vlan':{category:'zeek',description:'VLAN identifier. ',name:'zeek.connection.inner_vlan',type:'integer'},'zeek.dce_rpc.rtt':{category:'zeek',description:"Round trip time from the request to the response. If either the request or response wasn't seen, this will be null. ",name:'zeek.dce_rpc.rtt',type:'integer'},'zeek.dce_rpc.named_pipe':{category:'zeek',description:'Remote pipe name. ',name:'zeek.dce_rpc.named_pipe',type:'keyword'},'zeek.dce_rpc.endpoint':{category:'zeek',description:'Endpoint name looked up from the uuid. ',name:'zeek.dce_rpc.endpoint',type:'keyword'},'zeek.dce_rpc.operation':{category:'zeek',description:'Operation seen in the call. ',name:'zeek.dce_rpc.operation',type:'keyword'},'zeek.dhcp.domain':{category:'zeek',description:'Domain given by the server in option 15. ',name:'zeek.dhcp.domain',type:'keyword'},'zeek.dhcp.duration':{category:'zeek',description:'Duration of the DHCP session representing the time from the first message to the last, in seconds. ',name:'zeek.dhcp.duration',type:'double'},'zeek.dhcp.hostname':{category:'zeek',description:'Name given by client in Hostname option 12. ',name:'zeek.dhcp.hostname',type:'keyword'},'zeek.dhcp.client_fqdn':{category:'zeek',description:'FQDN given by client in Client FQDN option 81. ',name:'zeek.dhcp.client_fqdn',type:'keyword'},'zeek.dhcp.lease_time':{category:'zeek',description:'IP address lease interval in seconds. ',name:'zeek.dhcp.lease_time',type:'integer'},'zeek.dhcp.address.assigned':{category:'zeek',description:'IP address assigned by the server. ',name:'zeek.dhcp.address.assigned',type:'ip'},'zeek.dhcp.address.client':{category:'zeek',description:'IP address of the client. If a transaction is only a client sending INFORM messages then there is no lease information exchanged so this is helpful to know who sent the messages. Getting an address in this field does require that the client sources at least one DHCP message using a non-broadcast address. ',name:'zeek.dhcp.address.client',type:'ip'},'zeek.dhcp.address.mac':{category:'zeek',description:"Client's hardware address. ",name:'zeek.dhcp.address.mac',type:'keyword'},'zeek.dhcp.address.requested':{category:'zeek',description:'IP address requested by the client. ',name:'zeek.dhcp.address.requested',type:'ip'},'zeek.dhcp.address.server':{category:'zeek',description:'IP address of the DHCP server. ',name:'zeek.dhcp.address.server',type:'ip'},'zeek.dhcp.msg.types':{category:'zeek',description:'List of DHCP message types seen in this exchange. ',name:'zeek.dhcp.msg.types',type:'keyword'},'zeek.dhcp.msg.origin':{category:'zeek',description:'(present if policy/protocols/dhcp/msg-orig.bro is loaded) The address that originated each message from the msg.types field. ',name:'zeek.dhcp.msg.origin',type:'ip'},'zeek.dhcp.msg.client':{category:'zeek',description:'Message typically accompanied with a DHCP_DECLINE so the client can tell the server why it rejected an address. ',name:'zeek.dhcp.msg.client',type:'keyword'},'zeek.dhcp.msg.server':{category:'zeek',description:'Message typically accompanied with a DHCP_NAK to let the client know why it rejected the request. ',name:'zeek.dhcp.msg.server',type:'keyword'},'zeek.dhcp.software.client':{category:'zeek',description:'(present if policy/protocols/dhcp/software.bro is loaded) Software reported by the client in the vendor_class option. ',name:'zeek.dhcp.software.client',type:'keyword'},'zeek.dhcp.software.server':{category:'zeek',description:'(present if policy/protocols/dhcp/software.bro is loaded) Software reported by the client in the vendor_class option. ',name:'zeek.dhcp.software.server',type:'keyword'},'zeek.dhcp.id.circuit':{category:'zeek',description:'(present if policy/protocols/dhcp/sub-opts.bro is loaded) Added by DHCP relay agents which terminate switched or permanent circuits. It encodes an agent-local identifier of the circuit from which a DHCP client-to-server packet was received. Typically it should represent a router or switch interface number. ',name:'zeek.dhcp.id.circuit',type:'keyword'},'zeek.dhcp.id.remote_agent':{category:'zeek',description:'(present if policy/protocols/dhcp/sub-opts.bro is loaded) A globally unique identifier added by relay agents to identify the remote host end of the circuit. ',name:'zeek.dhcp.id.remote_agent',type:'keyword'},'zeek.dhcp.id.subscriber':{category:'zeek',description:"(present if policy/protocols/dhcp/sub-opts.bro is loaded) The subscriber ID is a value independent of the physical network configuration so that a customer's DHCP configuration can be given to them correctly no matter where they are physically connected. ",name:'zeek.dhcp.id.subscriber',type:'keyword'},'zeek.dnp3.function.request':{category:'zeek',description:'The name of the function message in the request. ',name:'zeek.dnp3.function.request',type:'keyword'},'zeek.dnp3.function.reply':{category:'zeek',description:'The name of the function message in the reply. ',name:'zeek.dnp3.function.reply',type:'keyword'},'zeek.dnp3.id':{category:'zeek',description:"The response's internal indication number. ",name:'zeek.dnp3.id',type:'integer'},'zeek.dns.trans_id':{category:'zeek',description:'DNS transaction identifier. ',name:'zeek.dns.trans_id',type:'keyword'},'zeek.dns.rtt':{category:'zeek',description:'Round trip time for the query and response. ',name:'zeek.dns.rtt',type:'double'},'zeek.dns.query':{category:'zeek',description:'The domain name that is the subject of the DNS query. ',name:'zeek.dns.query',type:'keyword'},'zeek.dns.qclass':{category:'zeek',description:'The QCLASS value specifying the class of the query. ',name:'zeek.dns.qclass',type:'long'},'zeek.dns.qclass_name':{category:'zeek',description:'A descriptive name for the class of the query. ',name:'zeek.dns.qclass_name',type:'keyword'},'zeek.dns.qtype':{category:'zeek',description:'A QTYPE value specifying the type of the query. ',name:'zeek.dns.qtype',type:'long'},'zeek.dns.qtype_name':{category:'zeek',description:'A descriptive name for the type of the query. ',name:'zeek.dns.qtype_name',type:'keyword'},'zeek.dns.rcode':{category:'zeek',description:'The response code value in DNS response messages. ',name:'zeek.dns.rcode',type:'long'},'zeek.dns.rcode_name':{category:'zeek',description:'A descriptive name for the response code value. ',name:'zeek.dns.rcode_name',type:'keyword'},'zeek.dns.AA':{category:'zeek',description:'The Authoritative Answer bit for response messages specifies that the responding name server is an authority for the domain name in the question section. ',name:'zeek.dns.AA',type:'boolean'},'zeek.dns.TC':{category:'zeek',description:'The Truncation bit specifies that the message was truncated. ',name:'zeek.dns.TC',type:'boolean'},'zeek.dns.RD':{category:'zeek',description:'The Recursion Desired bit in a request message indicates that the client wants recursive service for this query. ',name:'zeek.dns.RD',type:'boolean'},'zeek.dns.RA':{category:'zeek',description:'The Recursion Available bit in a response message indicates that the name server supports recursive queries. ',name:'zeek.dns.RA',type:'boolean'},'zeek.dns.answers':{category:'zeek',description:'The set of resource descriptions in the query answer. ',name:'zeek.dns.answers',type:'keyword'},'zeek.dns.TTLs':{category:'zeek',description:'The caching intervals of the associated RRs described by the answers field. ',name:'zeek.dns.TTLs',type:'double'},'zeek.dns.rejected':{category:'zeek',description:'Indicates whether the DNS query was rejected by the server. ',name:'zeek.dns.rejected',type:'boolean'},'zeek.dns.total_answers':{category:'zeek',description:'The total number of resource records in the reply. ',name:'zeek.dns.total_answers',type:'integer'},'zeek.dns.total_replies':{category:'zeek',description:'The total number of resource records in the reply message. ',name:'zeek.dns.total_replies',type:'integer'},'zeek.dns.saw_query':{category:'zeek',description:'Whether the full DNS query has been seen. ',name:'zeek.dns.saw_query',type:'boolean'},'zeek.dns.saw_reply':{category:'zeek',description:'Whether the full DNS reply has been seen. ',name:'zeek.dns.saw_reply',type:'boolean'},'zeek.dpd.analyzer':{category:'zeek',description:'The analyzer that generated the violation. ',name:'zeek.dpd.analyzer',type:'keyword'},'zeek.dpd.failure_reason':{category:'zeek',description:'The textual reason for the analysis failure. ',name:'zeek.dpd.failure_reason',type:'keyword'},'zeek.dpd.packet_segment':{category:'zeek',description:'(present if policy/frameworks/dpd/packet-segment-logging.bro is loaded) A chunk of the payload that most likely resulted in the protocol violation. ',name:'zeek.dpd.packet_segment',type:'keyword'},'zeek.files.fuid':{category:'zeek',description:'A file unique identifier. ',name:'zeek.files.fuid',type:'keyword'},'zeek.files.tx_host':{category:'zeek',description:'The host that transferred the file. ',name:'zeek.files.tx_host',type:'ip'},'zeek.files.rx_host':{category:'zeek',description:'The host that received the file. ',name:'zeek.files.rx_host',type:'ip'},'zeek.files.session_ids':{category:'zeek',description:'The sessions that have this file. ',name:'zeek.files.session_ids',type:'keyword'},'zeek.files.source':{category:'zeek',description:'An identification of the source of the file data. E.g. it may be a network protocol over which it was transferred, or a local file path which was read, or some other input source. ',name:'zeek.files.source',type:'keyword'},'zeek.files.depth':{category:'zeek',description:'A value to represent the depth of this file in relation to its source. In SMTP, it is the depth of the MIME attachment on the message. In HTTP, it is the depth of the request within the TCP connection. ',name:'zeek.files.depth',type:'long'},'zeek.files.analyzers':{category:'zeek',description:'A set of analysis types done during the file analysis. ',name:'zeek.files.analyzers',type:'keyword'},'zeek.files.mime_type':{category:'zeek',description:'Mime type of the file. ',name:'zeek.files.mime_type',type:'keyword'},'zeek.files.filename':{category:'zeek',description:'Name of the file if available. ',name:'zeek.files.filename',type:'keyword'},'zeek.files.local_orig':{category:'zeek',description:'If the source of this file is a network connection, this field indicates if the data originated from the local network or not. ',name:'zeek.files.local_orig',type:'boolean'},'zeek.files.is_orig':{category:'zeek',description:'If the source of this file is a network connection, this field indicates if the file is being sent by the originator of the connection or the responder. ',name:'zeek.files.is_orig',type:'boolean'},'zeek.files.duration':{category:'zeek',description:'The duration the file was analyzed for. Not the duration of the session. ',name:'zeek.files.duration',type:'double'},'zeek.files.seen_bytes':{category:'zeek',description:'Number of bytes provided to the file analysis engine for the file. ',name:'zeek.files.seen_bytes',type:'long'},'zeek.files.total_bytes':{category:'zeek',description:'Total number of bytes that are supposed to comprise the full file. ',name:'zeek.files.total_bytes',type:'long'},'zeek.files.missing_bytes':{category:'zeek',description:'The number of bytes in the file stream that were completely missed during the process of analysis. ',name:'zeek.files.missing_bytes',type:'long'},'zeek.files.overflow_bytes':{category:'zeek',description:"The number of bytes in the file stream that were not delivered to stream file analyzers. This could be overlapping bytes or bytes that couldn't be reassembled. ",name:'zeek.files.overflow_bytes',type:'long'},'zeek.files.timedout':{category:'zeek',description:'Whether the file analysis timed out at least once for the file. ',name:'zeek.files.timedout',type:'boolean'},'zeek.files.parent_fuid':{category:'zeek',description:'Identifier associated with a container file from which this one was extracted as part of the file analysis. ',name:'zeek.files.parent_fuid',type:'keyword'},'zeek.files.md5':{category:'zeek',description:'An MD5 digest of the file contents. ',name:'zeek.files.md5',type:'keyword'},'zeek.files.sha1':{category:'zeek',description:'A SHA1 digest of the file contents. ',name:'zeek.files.sha1',type:'keyword'},'zeek.files.sha256':{category:'zeek',description:'A SHA256 digest of the file contents. ',name:'zeek.files.sha256',type:'keyword'},'zeek.files.extracted':{category:'zeek',description:'Local filename of extracted file. ',name:'zeek.files.extracted',type:'keyword'},'zeek.files.extracted_cutoff':{category:'zeek',description:'Indicate whether the file being extracted was cut off hence not extracted completely. ',name:'zeek.files.extracted_cutoff',type:'boolean'},'zeek.files.extracted_size':{category:'zeek',description:'The number of bytes extracted to disk. ',name:'zeek.files.extracted_size',type:'long'},'zeek.files.entropy':{category:'zeek',description:'The information density of the contents of the file. ',name:'zeek.files.entropy',type:'double'},'zeek.ftp.user':{category:'zeek',description:'User name for the current FTP session. ',name:'zeek.ftp.user',type:'keyword'},'zeek.ftp.password':{category:'zeek',description:'Password for the current FTP session if captured. ',name:'zeek.ftp.password',type:'keyword'},'zeek.ftp.command':{category:'zeek',description:'Command given by the client. ',name:'zeek.ftp.command',type:'keyword'},'zeek.ftp.arg':{category:'zeek',description:'Argument for the command if one is given. ',name:'zeek.ftp.arg',type:'keyword'},'zeek.ftp.file.size':{category:'zeek',description:'Size of the file if the command indicates a file transfer. ',name:'zeek.ftp.file.size',type:'long'},'zeek.ftp.file.mime_type':{category:'zeek',description:'Sniffed mime type of file. ',name:'zeek.ftp.file.mime_type',type:'keyword'},'zeek.ftp.file.fuid':{category:'zeek',description:'(present if base/protocols/ftp/files.bro is loaded) File unique ID. ',name:'zeek.ftp.file.fuid',type:'keyword'},'zeek.ftp.reply.code':{category:'zeek',description:'Reply code from the server in response to the command. ',name:'zeek.ftp.reply.code',type:'integer'},'zeek.ftp.reply.msg':{category:'zeek',description:'Reply message from the server in response to the command. ',name:'zeek.ftp.reply.msg',type:'keyword'},'zeek.ftp.data_channel.passive':{category:'zeek',description:'Whether PASV mode is toggled for control channel. ',name:'zeek.ftp.data_channel.passive',type:'boolean'},'zeek.ftp.data_channel.originating_host':{category:'zeek',description:'The host that will be initiating the data connection. ',name:'zeek.ftp.data_channel.originating_host',type:'ip'},'zeek.ftp.data_channel.response_host':{category:'zeek',description:'The host that will be accepting the data connection. ',name:'zeek.ftp.data_channel.response_host',type:'ip'},'zeek.ftp.data_channel.response_port':{category:'zeek',description:'The port at which the acceptor is listening for the data connection. ',name:'zeek.ftp.data_channel.response_port',type:'integer'},'zeek.ftp.cwd':{category:'zeek',description:"Current working directory that this session is in. By making the default value '.', we can indicate that unless something more concrete is discovered that the existing but unknown directory is ok to use. ",name:'zeek.ftp.cwd',type:'keyword'},'zeek.ftp.cmdarg.cmd':{category:'zeek',description:'Command. ',name:'zeek.ftp.cmdarg.cmd',type:'keyword'},'zeek.ftp.cmdarg.arg':{category:'zeek',description:'Argument for the command if one was given. ',name:'zeek.ftp.cmdarg.arg',type:'keyword'},'zeek.ftp.cmdarg.seq':{category:'zeek',description:'Counter to track how many commands have been executed. ',name:'zeek.ftp.cmdarg.seq',type:'integer'},'zeek.ftp.pending_commands':{category:'zeek',description:'Queue for commands that have been sent but not yet responded to are tracked here. ',name:'zeek.ftp.pending_commands',type:'integer'},'zeek.ftp.passive':{category:'zeek',description:'Indicates if the session is in active or passive mode. ',name:'zeek.ftp.passive',type:'boolean'},'zeek.ftp.capture_password':{category:'zeek',description:'Determines if the password will be captured for this request. ',name:'zeek.ftp.capture_password',type:'boolean'},'zeek.ftp.last_auth_requested':{category:'zeek',description:'present if base/protocols/ftp/gridftp.bro is loaded. Last authentication/security mechanism that was used. ',name:'zeek.ftp.last_auth_requested',type:'keyword'},'zeek.http.trans_depth':{category:'zeek',description:'Represents the pipelined depth into the connection of this request/response transaction. ',name:'zeek.http.trans_depth',type:'integer'},'zeek.http.status_msg':{category:'zeek',description:'Status message returned by the server. ',name:'zeek.http.status_msg',type:'keyword'},'zeek.http.info_code':{category:'zeek',description:'Last seen 1xx informational reply code returned by the server. ',name:'zeek.http.info_code',type:'integer'},'zeek.http.info_msg':{category:'zeek',description:'Last seen 1xx informational reply message returned by the server. ',name:'zeek.http.info_msg',type:'keyword'},'zeek.http.tags':{category:'zeek',description:'A set of indicators of various attributes discovered and related to a particular request/response pair. ',name:'zeek.http.tags',type:'keyword'},'zeek.http.password':{category:'zeek',description:'Password if basic-auth is performed for the request. ',name:'zeek.http.password',type:'keyword'},'zeek.http.captured_password':{category:'zeek',description:'Determines if the password will be captured for this request. ',name:'zeek.http.captured_password',type:'boolean'},'zeek.http.proxied':{category:'zeek',description:'All of the headers that may indicate if the HTTP request was proxied. ',name:'zeek.http.proxied',type:'keyword'},'zeek.http.range_request':{category:'zeek',description:'Indicates if this request can assume 206 partial content in response. ',name:'zeek.http.range_request',type:'boolean'},'zeek.http.client_header_names':{category:'zeek',description:'The vector of HTTP header names sent by the client. No header values are included here, just the header names. ',name:'zeek.http.client_header_names',type:'keyword'},'zeek.http.server_header_names':{category:'zeek',description:'The vector of HTTP header names sent by the server. No header values are included here, just the header names. ',name:'zeek.http.server_header_names',type:'keyword'},'zeek.http.orig_fuids':{category:'zeek',description:'An ordered vector of file unique IDs from the originator. ',name:'zeek.http.orig_fuids',type:'keyword'},'zeek.http.orig_mime_types':{category:'zeek',description:'An ordered vector of mime types from the originator. ',name:'zeek.http.orig_mime_types',type:'keyword'},'zeek.http.orig_filenames':{category:'zeek',description:'An ordered vector of filenames from the originator. ',name:'zeek.http.orig_filenames',type:'keyword'},'zeek.http.resp_fuids':{category:'zeek',description:'An ordered vector of file unique IDs from the responder. ',name:'zeek.http.resp_fuids',type:'keyword'},'zeek.http.resp_mime_types':{category:'zeek',description:'An ordered vector of mime types from the responder. ',name:'zeek.http.resp_mime_types',type:'keyword'},'zeek.http.resp_filenames':{category:'zeek',description:'An ordered vector of filenames from the responder. ',name:'zeek.http.resp_filenames',type:'keyword'},'zeek.http.orig_mime_depth':{category:'zeek',description:'Current number of MIME entities in the HTTP request message body. ',name:'zeek.http.orig_mime_depth',type:'integer'},'zeek.http.resp_mime_depth':{category:'zeek',description:'Current number of MIME entities in the HTTP response message body. ',name:'zeek.http.resp_mime_depth',type:'integer'},'zeek.intel.seen.indicator':{category:'zeek',description:'The intelligence indicator. ',name:'zeek.intel.seen.indicator',type:'keyword'},'zeek.intel.seen.indicator_type':{category:'zeek',description:'The type of data the indicator represents. ',name:'zeek.intel.seen.indicator_type',type:'keyword'},'zeek.intel.seen.host':{category:'zeek',description:'If the indicator type was Intel::ADDR, then this field will be present. ',name:'zeek.intel.seen.host',type:'keyword'},'zeek.intel.seen.conn':{category:'zeek',description:'If the data was discovered within a connection, the connection record should go here to give context to the data. ',name:'zeek.intel.seen.conn',type:'keyword'},'zeek.intel.seen.where':{category:'zeek',description:'Where the data was discovered. ',name:'zeek.intel.seen.where',type:'keyword'},'zeek.intel.seen.node':{category:'zeek',description:'The name of the node where the match was discovered. ',name:'zeek.intel.seen.node',type:'keyword'},'zeek.intel.seen.uid':{category:'zeek',description:'If the data was discovered within a connection, the connection uid should go here to give context to the data. If the conn field is provided, this will be automatically filled out. ',name:'zeek.intel.seen.uid',type:'keyword'},'zeek.intel.seen.f':{category:'zeek',description:'If the data was discovered within a file, the file record should go here to provide context to the data. ',name:'zeek.intel.seen.f',type:'object'},'zeek.intel.seen.fuid':{category:'zeek',description:'If the data was discovered within a file, the file uid should go here to provide context to the data. If the file record f is provided, this will be automatically filled out. ',name:'zeek.intel.seen.fuid',type:'keyword'},'zeek.intel.matched':{category:'zeek',description:'Event to represent a match in the intelligence data from data that was seen. ',name:'zeek.intel.matched',type:'keyword'},'zeek.intel.sources':{category:'zeek',description:'Sources which supplied data for this match. ',name:'zeek.intel.sources',type:'keyword'},'zeek.intel.fuid':{category:'zeek',description:'If a file was associated with this intelligence hit, this is the uid for the file. ',name:'zeek.intel.fuid',type:'keyword'},'zeek.intel.file_mime_type':{category:'zeek',description:'A mime type if the intelligence hit is related to a file. If the $f field is provided this will be automatically filled out. ',name:'zeek.intel.file_mime_type',type:'keyword'},'zeek.intel.file_desc':{category:'zeek',description:'Frequently files can be described to give a bit more context. If the $f field is provided this field will be automatically filled out. ',name:'zeek.intel.file_desc',type:'keyword'},'zeek.irc.nick':{category:'zeek',description:'Nickname given for the connection. ',name:'zeek.irc.nick',type:'keyword'},'zeek.irc.user':{category:'zeek',description:'Username given for the connection. ',name:'zeek.irc.user',type:'keyword'},'zeek.irc.command':{category:'zeek',description:'Command given by the client. ',name:'zeek.irc.command',type:'keyword'},'zeek.irc.value':{category:'zeek',description:'Value for the command given by the client. ',name:'zeek.irc.value',type:'keyword'},'zeek.irc.addl':{category:'zeek',description:'Any additional data for the command. ',name:'zeek.irc.addl',type:'keyword'},'zeek.irc.dcc.file.name':{category:'zeek',description:'Present if base/protocols/irc/dcc-send.bro is loaded. DCC filename requested. ',name:'zeek.irc.dcc.file.name',type:'keyword'},'zeek.irc.dcc.file.size':{category:'zeek',description:'Present if base/protocols/irc/dcc-send.bro is loaded. Size of the DCC transfer as indicated by the sender. ',name:'zeek.irc.dcc.file.size',type:'long'},'zeek.irc.dcc.mime_type':{category:'zeek',description:'present if base/protocols/irc/dcc-send.bro is loaded. Sniffed mime type of the file. ',name:'zeek.irc.dcc.mime_type',type:'keyword'},'zeek.irc.fuid':{category:'zeek',description:'present if base/protocols/irc/files.bro is loaded. File unique ID. ',name:'zeek.irc.fuid',type:'keyword'},'zeek.kerberos.request_type':{category:'zeek',description:'Request type - Authentication Service (AS) or Ticket Granting Service (TGS). ',name:'zeek.kerberos.request_type',type:'keyword'},'zeek.kerberos.client':{category:'zeek',description:'Client name. ',name:'zeek.kerberos.client',type:'keyword'},'zeek.kerberos.service':{category:'zeek',description:'Service name. ',name:'zeek.kerberos.service',type:'keyword'},'zeek.kerberos.success':{category:'zeek',description:'Request result. ',name:'zeek.kerberos.success',type:'boolean'},'zeek.kerberos.error.code':{category:'zeek',description:'Error code. ',name:'zeek.kerberos.error.code',type:'integer'},'zeek.kerberos.error.msg':{category:'zeek',description:'Error message. ',name:'zeek.kerberos.error.msg',type:'keyword'},'zeek.kerberos.valid.from':{category:'zeek',description:'Ticket valid from. ',name:'zeek.kerberos.valid.from',type:'date'},'zeek.kerberos.valid.until':{category:'zeek',description:'Ticket valid until. ',name:'zeek.kerberos.valid.until',type:'date'},'zeek.kerberos.valid.days':{category:'zeek',description:'Number of days the ticket is valid for. ',name:'zeek.kerberos.valid.days',type:'integer'},'zeek.kerberos.cipher':{category:'zeek',description:'Ticket encryption type. ',name:'zeek.kerberos.cipher',type:'keyword'},'zeek.kerberos.forwardable':{category:'zeek',description:'Forwardable ticket requested. ',name:'zeek.kerberos.forwardable',type:'boolean'},'zeek.kerberos.renewable':{category:'zeek',description:'Renewable ticket requested. ',name:'zeek.kerberos.renewable',type:'boolean'},'zeek.kerberos.ticket.auth':{category:'zeek',description:'Hash of ticket used to authorize request/transaction. ',name:'zeek.kerberos.ticket.auth',type:'keyword'},'zeek.kerberos.ticket.new':{category:'zeek',description:'Hash of ticket returned by the KDC. ',name:'zeek.kerberos.ticket.new',type:'keyword'},'zeek.kerberos.cert.client.value':{category:'zeek',description:'Client certificate. ',name:'zeek.kerberos.cert.client.value',type:'keyword'},'zeek.kerberos.cert.client.fuid':{category:'zeek',description:'File unique ID of client cert. ',name:'zeek.kerberos.cert.client.fuid',type:'keyword'},'zeek.kerberos.cert.client.subject':{category:'zeek',description:'Subject of client certificate. ',name:'zeek.kerberos.cert.client.subject',type:'keyword'},'zeek.kerberos.cert.server.value':{category:'zeek',description:'Server certificate. ',name:'zeek.kerberos.cert.server.value',type:'keyword'},'zeek.kerberos.cert.server.fuid':{category:'zeek',description:'File unique ID of server certificate. ',name:'zeek.kerberos.cert.server.fuid',type:'keyword'},'zeek.kerberos.cert.server.subject':{category:'zeek',description:'Subject of server certificate. ',name:'zeek.kerberos.cert.server.subject',type:'keyword'},'zeek.modbus.function':{category:'zeek',description:'The name of the function message that was sent. ',name:'zeek.modbus.function',type:'keyword'},'zeek.modbus.exception':{category:'zeek',description:'The exception if the response was a failure. ',name:'zeek.modbus.exception',type:'keyword'},'zeek.modbus.track_address':{category:'zeek',description:'Present if policy/protocols/modbus/track-memmap.bro is loaded. Modbus track address. ',name:'zeek.modbus.track_address',type:'integer'},'zeek.mysql.cmd':{category:'zeek',description:'The command that was issued. ',name:'zeek.mysql.cmd',type:'keyword'},'zeek.mysql.arg':{category:'zeek',description:'The argument issued to the command. ',name:'zeek.mysql.arg',type:'keyword'},'zeek.mysql.success':{category:'zeek',description:'Whether the command succeeded. ',name:'zeek.mysql.success',type:'boolean'},'zeek.mysql.rows':{category:'zeek',description:'The number of affected rows, if any. ',name:'zeek.mysql.rows',type:'integer'},'zeek.mysql.response':{category:'zeek',description:'Server message, if any. ',name:'zeek.mysql.response',type:'keyword'},'zeek.notice.connection_id':{category:'zeek',description:'Identifier of the related connection session. ',name:'zeek.notice.connection_id',type:'keyword'},'zeek.notice.icmp_id':{category:'zeek',description:'Identifier of the related ICMP session. ',name:'zeek.notice.icmp_id',type:'keyword'},'zeek.notice.file.id':{category:'zeek',description:'An identifier associated with a single file that is related to this notice. ',name:'zeek.notice.file.id',type:'keyword'},'zeek.notice.file.parent_id':{category:'zeek',description:'Identifier associated with a container file from which this one was extracted. ',name:'zeek.notice.file.parent_id',type:'keyword'},'zeek.notice.file.source':{category:'zeek',description:'An identification of the source of the file data. E.g. it may be a network protocol over which it was transferred, or a local file path which was read, or some other input source. ',name:'zeek.notice.file.source',type:'keyword'},'zeek.notice.file.mime_type':{category:'zeek',description:'A mime type if the notice is related to a file. ',name:'zeek.notice.file.mime_type',type:'keyword'},'zeek.notice.file.is_orig':{category:'zeek',description:'If the source of this file is a network connection, this field indicates if the file is being sent by the originator of the connection or the responder. ',name:'zeek.notice.file.is_orig',type:'boolean'},'zeek.notice.file.seen_bytes':{category:'zeek',description:'Number of bytes provided to the file analysis engine for the file. ',name:'zeek.notice.file.seen_bytes',type:'long'},'zeek.notice.ffile.total_bytes':{category:'zeek',description:'Total number of bytes that are supposed to comprise the full file. ',name:'zeek.notice.ffile.total_bytes',type:'long'},'zeek.notice.file.missing_bytes':{category:'zeek',description:'The number of bytes in the file stream that were completely missed during the process of analysis. ',name:'zeek.notice.file.missing_bytes',type:'long'},'zeek.notice.file.overflow_bytes':{category:'zeek',description:"The number of bytes in the file stream that were not delivered to stream file analyzers. This could be overlapping bytes or bytes that couldn't be reassembled. ",name:'zeek.notice.file.overflow_bytes',type:'long'},'zeek.notice.fuid':{category:'zeek',description:'A file unique ID if this notice is related to a file. ',name:'zeek.notice.fuid',type:'keyword'},'zeek.notice.note':{category:'zeek',description:'The type of the notice. ',name:'zeek.notice.note',type:'keyword'},'zeek.notice.msg':{category:'zeek',description:'The human readable message for the notice. ',name:'zeek.notice.msg',type:'keyword'},'zeek.notice.sub':{category:'zeek',description:'The human readable sub-message. ',name:'zeek.notice.sub',type:'keyword'},'zeek.notice.n':{category:'zeek',description:'Associated count, or a status code. ',name:'zeek.notice.n',type:'long'},'zeek.notice.peer_name':{category:'zeek',description:'Name of remote peer that raised this notice. ',name:'zeek.notice.peer_name',type:'keyword'},'zeek.notice.peer_descr':{category:'zeek',description:'Textual description for the peer that raised this notice. ',name:'zeek.notice.peer_descr',type:'text'},'zeek.notice.actions':{category:'zeek',description:'The actions which have been applied to this notice. ',name:'zeek.notice.actions',type:'keyword'},'zeek.notice.email_body_sections':{category:'zeek',description:'By adding chunks of text into this element, other scripts can expand on notices that are being emailed. ',name:'zeek.notice.email_body_sections',type:'text'},'zeek.notice.email_delay_tokens':{category:'zeek',description:'Adding a string token to this set will cause the built-in emailing functionality to delay sending the email either the token has been removed or the email has been delayed for the specified time duration. ',name:'zeek.notice.email_delay_tokens',type:'keyword'},'zeek.notice.identifier':{category:'zeek',description:'This field is provided when a notice is generated for the purpose of deduplicating notices. ',name:'zeek.notice.identifier',type:'keyword'},'zeek.notice.suppress_for':{category:'zeek',description:'This field indicates the length of time that this unique notice should be suppressed. ',name:'zeek.notice.suppress_for',type:'double'},'zeek.notice.dropped':{category:'zeek',description:'Indicate if the source IP address was dropped and denied network access. ',name:'zeek.notice.dropped',type:'boolean'},'zeek.ntlm.domain':{category:'zeek',description:'Domain name given by the client. ',name:'zeek.ntlm.domain',type:'keyword'},'zeek.ntlm.hostname':{category:'zeek',description:'Hostname given by the client. ',name:'zeek.ntlm.hostname',type:'keyword'},'zeek.ntlm.success':{category:'zeek',description:'Indicate whether or not the authentication was successful. ',name:'zeek.ntlm.success',type:'boolean'},'zeek.ntlm.username':{category:'zeek',description:'Username given by the client. ',name:'zeek.ntlm.username',type:'keyword'},'zeek.ntlm.server.name.dns':{category:'zeek',description:'DNS name given by the server in a CHALLENGE. ',name:'zeek.ntlm.server.name.dns',type:'keyword'},'zeek.ntlm.server.name.netbios':{category:'zeek',description:'NetBIOS name given by the server in a CHALLENGE. ',name:'zeek.ntlm.server.name.netbios',type:'keyword'},'zeek.ntlm.server.name.tree':{category:'zeek',description:'Tree name given by the server in a CHALLENGE. ',name:'zeek.ntlm.server.name.tree',type:'keyword'},'zeek.ocsp.file_id':{category:'zeek',description:'File id of the OCSP reply. ',name:'zeek.ocsp.file_id',type:'keyword'},'zeek.ocsp.hash.algorithm':{category:'zeek',description:'Hash algorithm used to generate issuerNameHash and issuerKeyHash. ',name:'zeek.ocsp.hash.algorithm',type:'keyword'},'zeek.ocsp.hash.issuer.name':{category:'zeek',description:"Hash of the issuer's distingueshed name. ",name:'zeek.ocsp.hash.issuer.name',type:'keyword'},'zeek.ocsp.hash.issuer.key':{category:'zeek',description:"Hash of the issuer's public key. ",name:'zeek.ocsp.hash.issuer.key',type:'keyword'},'zeek.ocsp.serial_number':{category:'zeek',description:'Serial number of the affected certificate. ',name:'zeek.ocsp.serial_number',type:'keyword'},'zeek.ocsp.status':{category:'zeek',description:'Status of the affected certificate. ',name:'zeek.ocsp.status',type:'keyword'},'zeek.ocsp.revoke.time':{category:'zeek',description:'Time at which the certificate was revoked. ',name:'zeek.ocsp.revoke.time',type:'date'},'zeek.ocsp.revoke.reason':{category:'zeek',description:'Reason for which the certificate was revoked. ',name:'zeek.ocsp.revoke.reason',type:'keyword'},'zeek.ocsp.update.this':{category:'zeek',description:'The time at which the status being shows is known to have been correct. ',name:'zeek.ocsp.update.this',type:'date'},'zeek.ocsp.update.next':{category:'zeek',description:'The latest time at which new information about the status of the certificate will be available. ',name:'zeek.ocsp.update.next',type:'date'},'zeek.pe.client':{category:'zeek',description:"The client's version string. ",name:'zeek.pe.client',type:'keyword'},'zeek.pe.id':{category:'zeek',description:'File id of this portable executable file. ',name:'zeek.pe.id',type:'keyword'},'zeek.pe.machine':{category:'zeek',description:'The target machine that the file was compiled for. ',name:'zeek.pe.machine',type:'keyword'},'zeek.pe.compile_time':{category:'zeek',description:'The time that the file was created at. ',name:'zeek.pe.compile_time',type:'date'},'zeek.pe.os':{category:'zeek',description:'The required operating system. ',name:'zeek.pe.os',type:'keyword'},'zeek.pe.subsystem':{category:'zeek',description:'The subsystem that is required to run this file. ',name:'zeek.pe.subsystem',type:'keyword'},'zeek.pe.is_exe':{category:'zeek',description:'Is the file an executable, or just an object file? ',name:'zeek.pe.is_exe',type:'boolean'},'zeek.pe.is_64bit':{category:'zeek',description:'Is the file a 64-bit executable? ',name:'zeek.pe.is_64bit',type:'boolean'},'zeek.pe.uses_aslr':{category:'zeek',description:'Does the file support Address Space Layout Randomization? ',name:'zeek.pe.uses_aslr',type:'boolean'},'zeek.pe.uses_dep':{category:'zeek',description:'Does the file support Data Execution Prevention? ',name:'zeek.pe.uses_dep',type:'boolean'},'zeek.pe.uses_code_integrity':{category:'zeek',description:'Does the file enforce code integrity checks? ',name:'zeek.pe.uses_code_integrity',type:'boolean'},'zeek.pe.uses_seh':{category:'zeek',description:'Does the file use structured exception handing? ',name:'zeek.pe.uses_seh',type:'boolean'},'zeek.pe.has_import_table':{category:'zeek',description:'Does the file have an import table? ',name:'zeek.pe.has_import_table',type:'boolean'},'zeek.pe.has_export_table':{category:'zeek',description:'Does the file have an export table? ',name:'zeek.pe.has_export_table',type:'boolean'},'zeek.pe.has_cert_table':{category:'zeek',description:'Does the file have an attribute certificate table? ',name:'zeek.pe.has_cert_table',type:'boolean'},'zeek.pe.has_debug_data':{category:'zeek',description:'Does the file have a debug table? ',name:'zeek.pe.has_debug_data',type:'boolean'},'zeek.pe.section_names':{category:'zeek',description:'The names of the sections, in order. ',name:'zeek.pe.section_names',type:'keyword'},'zeek.radius.username':{category:'zeek',description:'The username, if present. ',name:'zeek.radius.username',type:'keyword'},'zeek.radius.mac':{category:'zeek',description:'MAC address, if present. ',name:'zeek.radius.mac',type:'keyword'},'zeek.radius.framed_addr':{category:'zeek',description:'The address given to the network access server, if present. This is only a hint from the RADIUS server and the network access server is not required to honor the address. ',name:'zeek.radius.framed_addr',type:'ip'},'zeek.radius.remote_ip':{category:'zeek',description:'Remote IP address, if present. This is collected from the Tunnel-Client-Endpoint attribute. ',name:'zeek.radius.remote_ip',type:'ip'},'zeek.radius.connect_info':{category:'zeek',description:'Connect info, if present. ',name:'zeek.radius.connect_info',type:'keyword'},'zeek.radius.reply_msg':{category:'zeek',description:'Reply message from the server challenge. This is frequently shown to the user authenticating. ',name:'zeek.radius.reply_msg',type:'keyword'},'zeek.radius.result':{category:'zeek',description:'Successful or failed authentication. ',name:'zeek.radius.result',type:'keyword'},'zeek.radius.ttl':{category:'zeek',description:'The duration between the first request and either the "Access-Accept" message or an error. If the field is empty, it means that either the request or response was not seen. ',name:'zeek.radius.ttl',type:'integer'},'zeek.radius.logged':{category:'zeek',description:'Whether this has already been logged and can be ignored. ',name:'zeek.radius.logged',type:'boolean'},'zeek.rdp.cookie':{category:'zeek',description:'Cookie value used by the client machine. This is typically a username. ',name:'zeek.rdp.cookie',type:'keyword'},'zeek.rdp.result':{category:'zeek',description:"Status result for the connection. It's a mix between RDP negotation failure messages and GCC server create response messages. ",name:'zeek.rdp.result',type:'keyword'},'zeek.rdp.security_protocol':{category:'zeek',description:'Security protocol chosen by the server. ',name:'zeek.rdp.security_protocol',type:'keyword'},'zeek.rdp.keyboard_layout':{category:'zeek',description:'Keyboard layout (language) of the client machine. ',name:'zeek.rdp.keyboard_layout',type:'keyword'},'zeek.rdp.client.build':{category:'zeek',description:'RDP client version used by the client machine. ',name:'zeek.rdp.client.build',type:'keyword'},'zeek.rdp.client.client_name':{category:'zeek',description:'Name of the client machine. ',name:'zeek.rdp.client.client_name',type:'keyword'},'zeek.rdp.client.product_id':{category:'zeek',description:'Product ID of the client machine. ',name:'zeek.rdp.client.product_id',type:'keyword'},'zeek.rdp.desktop.width':{category:'zeek',description:'Desktop width of the client machine. ',name:'zeek.rdp.desktop.width',type:'integer'},'zeek.rdp.desktop.height':{category:'zeek',description:'Desktop height of the client machine. ',name:'zeek.rdp.desktop.height',type:'integer'},'zeek.rdp.desktop.color_depth':{category:'zeek',description:'The color depth requested by the client in the high_color_depth field. ',name:'zeek.rdp.desktop.color_depth',type:'keyword'},'zeek.rdp.cert.type':{category:'zeek',description:'If the connection is being encrypted with native RDP encryption, this is the type of cert being used. ',name:'zeek.rdp.cert.type',type:'keyword'},'zeek.rdp.cert.count':{category:'zeek',description:'The number of certs seen. X.509 can transfer an entire certificate chain. ',name:'zeek.rdp.cert.count',type:'integer'},'zeek.rdp.cert.permanent':{category:'zeek',description:'Indicates if the provided certificate or certificate chain is permanent or temporary. ',name:'zeek.rdp.cert.permanent',type:'boolean'},'zeek.rdp.encryption.level':{category:'zeek',description:'Encryption level of the connection. ',name:'zeek.rdp.encryption.level',type:'keyword'},'zeek.rdp.encryption.method':{category:'zeek',description:'Encryption method of the connection. ',name:'zeek.rdp.encryption.method',type:'keyword'},'zeek.rdp.done':{category:'zeek',description:'Track status of logging RDP connections. ',name:'zeek.rdp.done',type:'boolean'},'zeek.rdp.ssl':{category:'zeek',description:'(present if policy/protocols/rdp/indicate_ssl.bro is loaded) Flag the connection if it was seen over SSL. ',name:'zeek.rdp.ssl',type:'boolean'},'zeek.rfb.version.client.major':{category:'zeek',description:'Major version of the client. ',name:'zeek.rfb.version.client.major',type:'keyword'},'zeek.rfb.version.client.minor':{category:'zeek',description:'Minor version of the client. ',name:'zeek.rfb.version.client.minor',type:'keyword'},'zeek.rfb.version.server.major':{category:'zeek',description:'Major version of the server. ',name:'zeek.rfb.version.server.major',type:'keyword'},'zeek.rfb.version.server.minor':{category:'zeek',description:'Minor version of the server. ',name:'zeek.rfb.version.server.minor',type:'keyword'},'zeek.rfb.auth.success':{category:'zeek',description:'Whether or not authentication was successful. ',name:'zeek.rfb.auth.success',type:'boolean'},'zeek.rfb.auth.method':{category:'zeek',description:'Identifier of authentication method used. ',name:'zeek.rfb.auth.method',type:'keyword'},'zeek.rfb.share_flag':{category:'zeek',description:'Whether the client has an exclusive or a shared session. ',name:'zeek.rfb.share_flag',type:'boolean'},'zeek.rfb.desktop_name':{category:'zeek',description:'Name of the screen that is being shared. ',name:'zeek.rfb.desktop_name',type:'keyword'},'zeek.rfb.width':{category:'zeek',description:'Width of the screen that is being shared. ',name:'zeek.rfb.width',type:'integer'},'zeek.rfb.height':{category:'zeek',description:'Height of the screen that is being shared. ',name:'zeek.rfb.height',type:'integer'},'zeek.sip.transaction_depth':{category:'zeek',description:'Represents the pipelined depth into the connection of this request/response transaction. ',name:'zeek.sip.transaction_depth',type:'integer'},'zeek.sip.sequence.method':{category:'zeek',description:'Verb used in the SIP request (INVITE, REGISTER etc.). ',name:'zeek.sip.sequence.method',type:'keyword'},'zeek.sip.sequence.number':{category:'zeek',description:'Contents of the CSeq: header from the client. ',name:'zeek.sip.sequence.number',type:'keyword'},'zeek.sip.uri':{category:'zeek',description:'URI used in the request. ',name:'zeek.sip.uri',type:'keyword'},'zeek.sip.date':{category:'zeek',description:'Contents of the Date: header from the client. ',name:'zeek.sip.date',type:'keyword'},'zeek.sip.request.from':{category:'zeek',description:"Contents of the request From: header Note: The tag= value that's usually appended to the sender is stripped off and not logged. ",name:'zeek.sip.request.from',type:'keyword'},'zeek.sip.request.to':{category:'zeek',description:'Contents of the To: header. ',name:'zeek.sip.request.to',type:'keyword'},'zeek.sip.request.path':{category:'zeek',description:'The client message transmission path, as extracted from the headers. ',name:'zeek.sip.request.path',type:'keyword'},'zeek.sip.request.body_length':{category:'zeek',description:'Contents of the Content-Length: header from the client. ',name:'zeek.sip.request.body_length',type:'long'},'zeek.sip.response.from':{category:'zeek',description:"Contents of the response From: header Note: The tag= value that's usually appended to the sender is stripped off and not logged. ",name:'zeek.sip.response.from',type:'keyword'},'zeek.sip.response.to':{category:'zeek',description:'Contents of the response To: header. ',name:'zeek.sip.response.to',type:'keyword'},'zeek.sip.response.path':{category:'zeek',description:'The server message transmission path, as extracted from the headers. ',name:'zeek.sip.response.path',type:'keyword'},'zeek.sip.response.body_length':{category:'zeek',description:'Contents of the Content-Length: header from the server. ',name:'zeek.sip.response.body_length',type:'long'},'zeek.sip.reply_to':{category:'zeek',description:'Contents of the Reply-To: header. ',name:'zeek.sip.reply_to',type:'keyword'},'zeek.sip.call_id':{category:'zeek',description:'Contents of the Call-ID: header from the client. ',name:'zeek.sip.call_id',type:'keyword'},'zeek.sip.subject':{category:'zeek',description:'Contents of the Subject: header from the client. ',name:'zeek.sip.subject',type:'keyword'},'zeek.sip.user_agent':{category:'zeek',description:'Contents of the User-Agent: header from the client. ',name:'zeek.sip.user_agent',type:'keyword'},'zeek.sip.status.code':{category:'zeek',description:'Status code returned by the server. ',name:'zeek.sip.status.code',type:'integer'},'zeek.sip.status.msg':{category:'zeek',description:'Status message returned by the server. ',name:'zeek.sip.status.msg',type:'keyword'},'zeek.sip.warning':{category:'zeek',description:'Contents of the Warning: header. ',name:'zeek.sip.warning',type:'keyword'},'zeek.sip.content_type':{category:'zeek',description:'Contents of the Content-Type: header from the server. ',name:'zeek.sip.content_type',type:'keyword'},'zeek.smb_cmd.command':{category:'zeek',description:'The command sent by the client. ',name:'zeek.smb_cmd.command',type:'keyword'},'zeek.smb_cmd.sub_command':{category:'zeek',description:'The subcommand sent by the client, if present. ',name:'zeek.smb_cmd.sub_command',type:'keyword'},'zeek.smb_cmd.argument':{category:'zeek',description:'Command argument sent by the client, if any. ',name:'zeek.smb_cmd.argument',type:'keyword'},'zeek.smb_cmd.status':{category:'zeek',description:"Server reply to the client's command. ",name:'zeek.smb_cmd.status',type:'keyword'},'zeek.smb_cmd.rtt':{category:'zeek',description:'Round trip time from the request to the response. ',name:'zeek.smb_cmd.rtt',type:'double'},'zeek.smb_cmd.version':{category:'zeek',description:'Version of SMB for the command. ',name:'zeek.smb_cmd.version',type:'keyword'},'zeek.smb_cmd.username':{category:'zeek',description:'Authenticated username, if available. ',name:'zeek.smb_cmd.username',type:'keyword'},'zeek.smb_cmd.tree':{category:'zeek',description:'If this is related to a tree, this is the tree that was used for the current command. ',name:'zeek.smb_cmd.tree',type:'keyword'},'zeek.smb_cmd.tree_service':{category:'zeek',description:'The type of tree (disk share, printer share, named pipe, etc.). ',name:'zeek.smb_cmd.tree_service',type:'keyword'},'zeek.smb_cmd.file.name':{category:'zeek',description:'Filename if one was seen. ',name:'zeek.smb_cmd.file.name',type:'keyword'},'zeek.smb_cmd.file.action':{category:'zeek',description:'Action this log record represents. ',name:'zeek.smb_cmd.file.action',type:'keyword'},'zeek.smb_cmd.file.uid':{category:'zeek',description:'UID of the referenced file. ',name:'zeek.smb_cmd.file.uid',type:'keyword'},'zeek.smb_cmd.file.host.tx':{category:'zeek',description:'Address of the transmitting host. ',name:'zeek.smb_cmd.file.host.tx',type:'ip'},'zeek.smb_cmd.file.host.rx':{category:'zeek',description:'Address of the receiving host. ',name:'zeek.smb_cmd.file.host.rx',type:'ip'},'zeek.smb_cmd.smb1_offered_dialects':{category:'zeek',description:'Present if base/protocols/smb/smb1-main.bro is loaded. Dialects offered by the client. ',name:'zeek.smb_cmd.smb1_offered_dialects',type:'keyword'},'zeek.smb_cmd.smb2_offered_dialects':{category:'zeek',description:'Present if base/protocols/smb/smb2-main.bro is loaded. Dialects offered by the client. ',name:'zeek.smb_cmd.smb2_offered_dialects',type:'integer'},'zeek.smb_files.action':{category:'zeek',description:'Action this log record represents. ',name:'zeek.smb_files.action',type:'keyword'},'zeek.smb_files.fid':{category:'zeek',description:'ID referencing this file. ',name:'zeek.smb_files.fid',type:'integer'},'zeek.smb_files.name':{category:'zeek',description:'Filename if one was seen. ',name:'zeek.smb_files.name',type:'keyword'},'zeek.smb_files.path':{category:'zeek',description:'Path pulled from the tree this file was transferred to or from. ',name:'zeek.smb_files.path',type:'keyword'},'zeek.smb_files.previous_name':{category:'zeek',description:"If the rename action was seen, this will be the file's previous name. ",name:'zeek.smb_files.previous_name',type:'keyword'},'zeek.smb_files.size':{category:'zeek',description:'Byte size of the file. ',name:'zeek.smb_files.size',type:'long'},'zeek.smb_files.times.accessed':{category:'zeek',description:"The file's access time. ",name:'zeek.smb_files.times.accessed',type:'date'},'zeek.smb_files.times.changed':{category:'zeek',description:"The file's change time. ",name:'zeek.smb_files.times.changed',type:'date'},'zeek.smb_files.times.created':{category:'zeek',description:"The file's create time. ",name:'zeek.smb_files.times.created',type:'date'},'zeek.smb_files.times.modified':{category:'zeek',description:"The file's modify time. ",name:'zeek.smb_files.times.modified',type:'date'},'zeek.smb_files.uuid':{category:'zeek',description:'UUID referencing this file if DCE/RPC. ',name:'zeek.smb_files.uuid',type:'keyword'},'zeek.smb_mapping.path':{category:'zeek',description:'Name of the tree path. ',name:'zeek.smb_mapping.path',type:'keyword'},'zeek.smb_mapping.service':{category:'zeek',description:'The type of resource of the tree (disk share, printer share, named pipe, etc.). ',name:'zeek.smb_mapping.service',type:'keyword'},'zeek.smb_mapping.native_file_system':{category:'zeek',description:'File system of the tree. ',name:'zeek.smb_mapping.native_file_system',type:'keyword'},'zeek.smb_mapping.share_type':{category:'zeek',description:'If this is SMB2, a share type will be included. For SMB1, the type of share will be deduced and included as well. ',name:'zeek.smb_mapping.share_type',type:'keyword'},'zeek.smtp.transaction_depth':{category:'zeek',description:'A count to represent the depth of this message transaction in a single connection where multiple messages were transferred. ',name:'zeek.smtp.transaction_depth',type:'integer'},'zeek.smtp.helo':{category:'zeek',description:'Contents of the Helo header. ',name:'zeek.smtp.helo',type:'keyword'},'zeek.smtp.mail_from':{category:'zeek',description:'Email addresses found in the MAIL FROM header. ',name:'zeek.smtp.mail_from',type:'keyword'},'zeek.smtp.rcpt_to':{category:'zeek',description:'Email addresses found in the RCPT TO header. ',name:'zeek.smtp.rcpt_to',type:'keyword'},'zeek.smtp.date':{category:'zeek',description:'Contents of the Date header. ',name:'zeek.smtp.date',type:'date'},'zeek.smtp.from':{category:'zeek',description:'Contents of the From header. ',name:'zeek.smtp.from',type:'keyword'},'zeek.smtp.to':{category:'zeek',description:'Contents of the To header. ',name:'zeek.smtp.to',type:'keyword'},'zeek.smtp.cc':{category:'zeek',description:'Contents of the CC header. ',name:'zeek.smtp.cc',type:'keyword'},'zeek.smtp.reply_to':{category:'zeek',description:'Contents of the ReplyTo header. ',name:'zeek.smtp.reply_to',type:'keyword'},'zeek.smtp.msg_id':{category:'zeek',description:'Contents of the MsgID header. ',name:'zeek.smtp.msg_id',type:'keyword'},'zeek.smtp.in_reply_to':{category:'zeek',description:'Contents of the In-Reply-To header. ',name:'zeek.smtp.in_reply_to',type:'keyword'},'zeek.smtp.subject':{category:'zeek',description:'Contents of the Subject header. ',name:'zeek.smtp.subject',type:'keyword'},'zeek.smtp.x_originating_ip':{category:'zeek',description:'Contents of the X-Originating-IP header. ',name:'zeek.smtp.x_originating_ip',type:'keyword'},'zeek.smtp.first_received':{category:'zeek',description:'Contents of the first Received header. ',name:'zeek.smtp.first_received',type:'keyword'},'zeek.smtp.second_received':{category:'zeek',description:'Contents of the second Received header. ',name:'zeek.smtp.second_received',type:'keyword'},'zeek.smtp.last_reply':{category:'zeek',description:'The last message that the server sent to the client. ',name:'zeek.smtp.last_reply',type:'keyword'},'zeek.smtp.path':{category:'zeek',description:'The message transmission path, as extracted from the headers. ',name:'zeek.smtp.path',type:'ip'},'zeek.smtp.user_agent':{category:'zeek',description:'Value of the User-Agent header from the client. ',name:'zeek.smtp.user_agent',type:'keyword'},'zeek.smtp.tls':{category:'zeek',description:'Indicates that the connection has switched to using TLS. ',name:'zeek.smtp.tls',type:'boolean'},'zeek.smtp.process_received_from':{category:'zeek',description:'Indicates if the "Received: from" headers should still be processed. ',name:'zeek.smtp.process_received_from',type:'boolean'},'zeek.smtp.has_client_activity':{category:'zeek',description:'Indicates if client activity has been seen, but not yet logged. ',name:'zeek.smtp.has_client_activity',type:'boolean'},'zeek.smtp.fuids':{category:'zeek',description:'(present if base/protocols/smtp/files.bro is loaded) An ordered vector of file unique IDs seen attached to the message. ',name:'zeek.smtp.fuids',type:'keyword'},'zeek.smtp.is_webmail':{category:'zeek',description:'Indicates if the message was sent through a webmail interface. ',name:'zeek.smtp.is_webmail',type:'boolean'},'zeek.snmp.duration':{category:'zeek',description:'The amount of time between the first packet beloning to the SNMP session and the latest one seen. ',name:'zeek.snmp.duration',type:'double'},'zeek.snmp.version':{category:'zeek',description:'The version of SNMP being used. ',name:'zeek.snmp.version',type:'keyword'},'zeek.snmp.community':{category:'zeek',description:"The community string of the first SNMP packet associated with the session. This is used as part of SNMP's (v1 and v2c) administrative/security framework. See RFC 1157 or RFC 1901. ",name:'zeek.snmp.community',type:'keyword'},'zeek.snmp.get.requests':{category:'zeek',description:'The number of variable bindings in GetRequest/GetNextRequest PDUs seen for the session. ',name:'zeek.snmp.get.requests',type:'integer'},'zeek.snmp.get.bulk_requests':{category:'zeek',description:'The number of variable bindings in GetBulkRequest PDUs seen for the session. ',name:'zeek.snmp.get.bulk_requests',type:'integer'},'zeek.snmp.get.responses':{category:'zeek',description:'The number of variable bindings in GetResponse/Response PDUs seen for the session. ',name:'zeek.snmp.get.responses',type:'integer'},'zeek.snmp.set.requests':{category:'zeek',description:'The number of variable bindings in SetRequest PDUs seen for the session. ',name:'zeek.snmp.set.requests',type:'integer'},'zeek.snmp.display_string':{category:'zeek',description:'A system description of the SNMP responder endpoint. ',name:'zeek.snmp.display_string',type:'keyword'},'zeek.snmp.up_since':{category:'zeek',description:"The time at which the SNMP responder endpoint claims it's been up since. ",name:'zeek.snmp.up_since',type:'date'},'zeek.socks.version':{category:'zeek',description:'Protocol version of SOCKS. ',name:'zeek.socks.version',type:'integer'},'zeek.socks.user':{category:'zeek',description:'Username used to request a login to the proxy. ',name:'zeek.socks.user',type:'keyword'},'zeek.socks.password':{category:'zeek',description:'Password used to request a login to the proxy. ',name:'zeek.socks.password',type:'keyword'},'zeek.socks.status':{category:'zeek',description:'Server status for the attempt at using the proxy. ',name:'zeek.socks.status',type:'keyword'},'zeek.socks.request.host':{category:'zeek',description:'Client requested SOCKS address. Could be an address, a name or both. ',name:'zeek.socks.request.host',type:'keyword'},'zeek.socks.request.port':{category:'zeek',description:'Client requested port. ',name:'zeek.socks.request.port',type:'integer'},'zeek.socks.bound.host':{category:'zeek',description:'Server bound address. Could be an address, a name or both. ',name:'zeek.socks.bound.host',type:'keyword'},'zeek.socks.bound.port':{category:'zeek',description:'Server bound port. ',name:'zeek.socks.bound.port',type:'integer'},'zeek.socks.capture_password':{category:'zeek',description:'Determines if the password will be captured for this request. ',name:'zeek.socks.capture_password',type:'boolean'},'zeek.ssh.client':{category:'zeek',description:"The client's version string. ",name:'zeek.ssh.client',type:'keyword'},'zeek.ssh.direction':{category:'zeek',description:'Direction of the connection. If the client was a local host logging into an external host, this would be OUTBOUND. INBOUND would be set for the opposite situation. ',name:'zeek.ssh.direction',type:'keyword'},'zeek.ssh.host_key':{category:'zeek',description:"The server's key thumbprint. ",name:'zeek.ssh.host_key',type:'keyword'},'zeek.ssh.server':{category:'zeek',description:"The server's version string. ",name:'zeek.ssh.server',type:'keyword'},'zeek.ssh.version':{category:'zeek',description:'SSH major version (1 or 2). ',name:'zeek.ssh.version',type:'integer'},'zeek.ssh.algorithm.cipher':{category:'zeek',description:'The encryption algorithm in use. ',name:'zeek.ssh.algorithm.cipher',type:'keyword'},'zeek.ssh.algorithm.compression':{category:'zeek',description:'The compression algorithm in use. ',name:'zeek.ssh.algorithm.compression',type:'keyword'},'zeek.ssh.algorithm.host_key':{category:'zeek',description:"The server host key's algorithm. ",name:'zeek.ssh.algorithm.host_key',type:'keyword'},'zeek.ssh.algorithm.key_exchange':{category:'zeek',description:'The key exchange algorithm in use. ',name:'zeek.ssh.algorithm.key_exchange',type:'keyword'},'zeek.ssh.algorithm.mac':{category:'zeek',description:'The signing (MAC) algorithm in use. ',name:'zeek.ssh.algorithm.mac',type:'keyword'},'zeek.ssh.auth.attempts':{category:'zeek',description:"The number of authentication attemps we observed. There's always at least one, since some servers might support no authentication at all. It's important to note that not all of these are failures, since some servers require two-factor auth (e.g. password AND pubkey). ",name:'zeek.ssh.auth.attempts',type:'integer'},'zeek.ssh.auth.success':{category:'zeek',description:'Authentication result. ',name:'zeek.ssh.auth.success',type:'boolean'},'zeek.ssl.version':{category:'zeek',description:'SSL/TLS version that was logged. ',name:'zeek.ssl.version',type:'keyword'},'zeek.ssl.cipher':{category:'zeek',description:'SSL/TLS cipher suite that was logged. ',name:'zeek.ssl.cipher',type:'keyword'},'zeek.ssl.curve':{category:'zeek',description:'Elliptic curve that was logged when using ECDH/ECDHE. ',name:'zeek.ssl.curve',type:'keyword'},'zeek.ssl.resumed':{category:'zeek',description:'Flag to indicate if the session was resumed reusing the key material exchanged in an earlier connection. ',name:'zeek.ssl.resumed',type:'boolean'},'zeek.ssl.next_protocol':{category:'zeek',description:'Next protocol the server chose using the application layer next protocol extension. ',name:'zeek.ssl.next_protocol',type:'keyword'},'zeek.ssl.established':{category:'zeek',description:'Flag to indicate if this ssl session has been established successfully. ',name:'zeek.ssl.established',type:'boolean'},'zeek.ssl.validation.status':{category:'zeek',description:'Result of certificate validation for this connection. ',name:'zeek.ssl.validation.status',type:'keyword'},'zeek.ssl.validation.code':{category:'zeek',description:'Result of certificate validation for this connection, given as OpenSSL validation code. ',name:'zeek.ssl.validation.code',type:'keyword'},'zeek.ssl.last_alert':{category:'zeek',description:'Last alert that was seen during the connection. ',name:'zeek.ssl.last_alert',type:'keyword'},'zeek.ssl.server.name':{category:'zeek',description:'Value of the Server Name Indicator SSL/TLS extension. It indicates the server name that the client was requesting. ',name:'zeek.ssl.server.name',type:'keyword'},'zeek.ssl.server.cert_chain':{category:'zeek',description:'Chain of certificates offered by the server to validate its complete signing chain. ',name:'zeek.ssl.server.cert_chain',type:'keyword'},'zeek.ssl.server.cert_chain_fuids':{category:'zeek',description:'An ordered vector of certificate file identifiers for the certificates offered by the server. ',name:'zeek.ssl.server.cert_chain_fuids',type:'keyword'},'zeek.ssl.server.issuer.common_name':{category:'zeek',description:'Common name of the signer of the X.509 certificate offered by the server. ',name:'zeek.ssl.server.issuer.common_name',type:'keyword'},'zeek.ssl.server.issuer.country':{category:'zeek',description:'Country code of the signer of the X.509 certificate offered by the server. ',name:'zeek.ssl.server.issuer.country',type:'keyword'},'zeek.ssl.server.issuer.locality':{category:'zeek',description:'Locality of the signer of the X.509 certificate offered by the server. ',name:'zeek.ssl.server.issuer.locality',type:'keyword'},'zeek.ssl.server.issuer.organization':{category:'zeek',description:'Organization of the signer of the X.509 certificate offered by the server. ',name:'zeek.ssl.server.issuer.organization',type:'keyword'},'zeek.ssl.server.issuer.organizational_unit':{category:'zeek',description:'Organizational unit of the signer of the X.509 certificate offered by the server. ',name:'zeek.ssl.server.issuer.organizational_unit',type:'keyword'},'zeek.ssl.server.issuer.state':{category:'zeek',description:'State or province name of the signer of the X.509 certificate offered by the server. ',name:'zeek.ssl.server.issuer.state',type:'keyword'},'zeek.ssl.server.subject.common_name':{category:'zeek',description:'Common name of the X.509 certificate offered by the server. ',name:'zeek.ssl.server.subject.common_name',type:'keyword'},'zeek.ssl.server.subject.country':{category:'zeek',description:'Country code of the X.509 certificate offered by the server. ',name:'zeek.ssl.server.subject.country',type:'keyword'},'zeek.ssl.server.subject.locality':{category:'zeek',description:'Locality of the X.509 certificate offered by the server. ',name:'zeek.ssl.server.subject.locality',type:'keyword'},'zeek.ssl.server.subject.organization':{category:'zeek',description:'Organization of the X.509 certificate offered by the server. ',name:'zeek.ssl.server.subject.organization',type:'keyword'},'zeek.ssl.server.subject.organizational_unit':{category:'zeek',description:'Organizational unit of the X.509 certificate offered by the server. ',name:'zeek.ssl.server.subject.organizational_unit',type:'keyword'},'zeek.ssl.server.subject.state':{category:'zeek',description:'State or province name of the X.509 certificate offered by the server. ',name:'zeek.ssl.server.subject.state',type:'keyword'},'zeek.ssl.client.cert_chain':{category:'zeek',description:'Chain of certificates offered by the client to validate its complete signing chain. ',name:'zeek.ssl.client.cert_chain',type:'keyword'},'zeek.ssl.client.cert_chain_fuids':{category:'zeek',description:'An ordered vector of certificate file identifiers for the certificates offered by the client. ',name:'zeek.ssl.client.cert_chain_fuids',type:'keyword'},'zeek.ssl.client.issuer.common_name':{category:'zeek',description:'Common name of the signer of the X.509 certificate offered by the client. ',name:'zeek.ssl.client.issuer.common_name',type:'keyword'},'zeek.ssl.client.issuer.country':{category:'zeek',description:'Country code of the signer of the X.509 certificate offered by the client. ',name:'zeek.ssl.client.issuer.country',type:'keyword'},'zeek.ssl.client.issuer.locality':{category:'zeek',description:'Locality of the signer of the X.509 certificate offered by the client. ',name:'zeek.ssl.client.issuer.locality',type:'keyword'},'zeek.ssl.client.issuer.organization':{category:'zeek',description:'Organization of the signer of the X.509 certificate offered by the client. ',name:'zeek.ssl.client.issuer.organization',type:'keyword'},'zeek.ssl.client.issuer.organizational_unit':{category:'zeek',description:'Organizational unit of the signer of the X.509 certificate offered by the client. ',name:'zeek.ssl.client.issuer.organizational_unit',type:'keyword'},'zeek.ssl.client.issuer.state':{category:'zeek',description:'State or province name of the signer of the X.509 certificate offered by the client. ',name:'zeek.ssl.client.issuer.state',type:'keyword'},'zeek.ssl.client.subject.common_name':{category:'zeek',description:'Common name of the X.509 certificate offered by the client. ',name:'zeek.ssl.client.subject.common_name',type:'keyword'},'zeek.ssl.client.subject.country':{category:'zeek',description:'Country code of the X.509 certificate offered by the client. ',name:'zeek.ssl.client.subject.country',type:'keyword'},'zeek.ssl.client.subject.locality':{category:'zeek',description:'Locality of the X.509 certificate offered by the client. ',name:'zeek.ssl.client.subject.locality',type:'keyword'},'zeek.ssl.client.subject.organization':{category:'zeek',description:'Organization of the X.509 certificate offered by the client. ',name:'zeek.ssl.client.subject.organization',type:'keyword'},'zeek.ssl.client.subject.organizational_unit':{category:'zeek',description:'Organizational unit of the X.509 certificate offered by the client. ',name:'zeek.ssl.client.subject.organizational_unit',type:'keyword'},'zeek.ssl.client.subject.state':{category:'zeek',description:'State or province name of the X.509 certificate offered by the client. ',name:'zeek.ssl.client.subject.state',type:'keyword'},'zeek.stats.peer':{category:'zeek',description:'Peer that generated this log. Mostly for clusters. ',name:'zeek.stats.peer',type:'keyword'},'zeek.stats.memory':{category:'zeek',description:'Amount of memory currently in use in MB. ',name:'zeek.stats.memory',type:'integer'},'zeek.stats.packets.processed':{category:'zeek',description:'Number of packets processed since the last stats interval. ',name:'zeek.stats.packets.processed',type:'long'},'zeek.stats.packets.dropped':{category:'zeek',description:'Number of packets dropped since the last stats interval if reading live traffic. ',name:'zeek.stats.packets.dropped',type:'long'},'zeek.stats.packets.received':{category:'zeek',description:'Number of packets seen on the link since the last stats interval if reading live traffic. ',name:'zeek.stats.packets.received',type:'long'},'zeek.stats.bytes.received':{category:'zeek',description:'Number of bytes received since the last stats interval if reading live traffic. ',name:'zeek.stats.bytes.received',type:'long'},'zeek.stats.connections.tcp.active':{category:'zeek',description:'TCP connections currently in memory. ',name:'zeek.stats.connections.tcp.active',type:'integer'},'zeek.stats.connections.tcp.count':{category:'zeek',description:'TCP connections seen since last stats interval. ',name:'zeek.stats.connections.tcp.count',type:'integer'},'zeek.stats.connections.udp.active':{category:'zeek',description:'UDP connections currently in memory. ',name:'zeek.stats.connections.udp.active',type:'integer'},'zeek.stats.connections.udp.count':{category:'zeek',description:'UDP connections seen since last stats interval. ',name:'zeek.stats.connections.udp.count',type:'integer'},'zeek.stats.connections.icmp.active':{category:'zeek',description:'ICMP connections currently in memory. ',name:'zeek.stats.connections.icmp.active',type:'integer'},'zeek.stats.connections.icmp.count':{category:'zeek',description:'ICMP connections seen since last stats interval. ',name:'zeek.stats.connections.icmp.count',type:'integer'},'zeek.stats.events.processed':{category:'zeek',description:'Number of events processed since the last stats interval. ',name:'zeek.stats.events.processed',type:'integer'},'zeek.stats.events.queued':{category:'zeek',description:'Number of events that have been queued since the last stats interval. ',name:'zeek.stats.events.queued',type:'integer'},'zeek.stats.timers.count':{category:'zeek',description:'Number of timers scheduled since last stats interval. ',name:'zeek.stats.timers.count',type:'integer'},'zeek.stats.timers.active':{category:'zeek',description:'Current number of scheduled timers. ',name:'zeek.stats.timers.active',type:'integer'},'zeek.stats.files.count':{category:'zeek',description:'Number of files seen since last stats interval. ',name:'zeek.stats.files.count',type:'integer'},'zeek.stats.files.active':{category:'zeek',description:'Current number of files actively being seen. ',name:'zeek.stats.files.active',type:'integer'},'zeek.stats.dns_requests.count':{category:'zeek',description:'Number of DNS requests seen since last stats interval. ',name:'zeek.stats.dns_requests.count',type:'integer'},'zeek.stats.dns_requests.active':{category:'zeek',description:'Current number of DNS requests awaiting a reply. ',name:'zeek.stats.dns_requests.active',type:'integer'},'zeek.stats.reassembly_size.tcp':{category:'zeek',description:'Current size of TCP data in reassembly. ',name:'zeek.stats.reassembly_size.tcp',type:'integer'},'zeek.stats.reassembly_size.file':{category:'zeek',description:'Current size of File data in reassembly. ',name:'zeek.stats.reassembly_size.file',type:'integer'},'zeek.stats.reassembly_size.frag':{category:'zeek',description:'Current size of packet fragment data in reassembly. ',name:'zeek.stats.reassembly_size.frag',type:'integer'},'zeek.stats.reassembly_size.unknown':{category:'zeek',description:'Current size of unknown data in reassembly (this is only PIA buffer right now). ',name:'zeek.stats.reassembly_size.unknown',type:'integer'},'zeek.stats.timestamp_lag':{category:'zeek',description:'Lag between the wall clock and packet timestamps if reading live traffic. ',name:'zeek.stats.timestamp_lag',type:'integer'},'zeek.syslog.facility':{category:'zeek',description:'Syslog facility for the message. ',name:'zeek.syslog.facility',type:'keyword'},'zeek.syslog.severity':{category:'zeek',description:'Syslog severity for the message. ',name:'zeek.syslog.severity',type:'keyword'},'zeek.syslog.message':{category:'zeek',description:'The plain text message. ',name:'zeek.syslog.message',type:'keyword'},'zeek.tunnel.type':{category:'zeek',description:'The type of tunnel. ',name:'zeek.tunnel.type',type:'keyword'},'zeek.tunnel.action':{category:'zeek',description:'The type of activity that occurred. ',name:'zeek.tunnel.action',type:'keyword'},'zeek.weird.name':{category:'zeek',description:'The name of the weird that occurred. ',name:'zeek.weird.name',type:'keyword'},'zeek.weird.additional_info':{category:'zeek',description:'Additional information accompanying the weird if any. ',name:'zeek.weird.additional_info',type:'keyword'},'zeek.weird.notice':{category:'zeek',description:'Indicate if this weird was also turned into a notice. ',name:'zeek.weird.notice',type:'boolean'},'zeek.weird.peer':{category:'zeek',description:'The peer that originated this weird. This is helpful in cluster deployments if a particular cluster node is having trouble to help identify which node is having trouble. ',name:'zeek.weird.peer',type:'keyword'},'zeek.weird.identifier':{category:'zeek',description:'This field is to be provided when a weird is generated for the purpose of deduplicating weirds. The identifier string should be unique for a single instance of the weird. This field is used to define when a weird is conceptually a duplicate of a previous weird. ',name:'zeek.weird.identifier',type:'keyword'},'zeek.x509.id':{category:'zeek',description:'File id of this certificate. ',name:'zeek.x509.id',type:'keyword'},'zeek.x509.certificate.version':{category:'zeek',description:'Version number. ',name:'zeek.x509.certificate.version',type:'integer'},'zeek.x509.certificate.serial':{category:'zeek',description:'Serial number. ',name:'zeek.x509.certificate.serial',type:'keyword'},'zeek.x509.certificate.subject.country':{category:'zeek',description:'Country provided in the certificate subject. ',name:'zeek.x509.certificate.subject.country',type:'keyword'},'zeek.x509.certificate.subject.common_name':{category:'zeek',description:'Common name provided in the certificate subject. ',name:'zeek.x509.certificate.subject.common_name',type:'keyword'},'zeek.x509.certificate.subject.locality':{category:'zeek',description:'Locality provided in the certificate subject. ',name:'zeek.x509.certificate.subject.locality',type:'keyword'},'zeek.x509.certificate.subject.organization':{category:'zeek',description:'Organization provided in the certificate subject. ',name:'zeek.x509.certificate.subject.organization',type:'keyword'},'zeek.x509.certificate.subject.organizational_unit':{category:'zeek',description:'Organizational unit provided in the certificate subject. ',name:'zeek.x509.certificate.subject.organizational_unit',type:'keyword'},'zeek.x509.certificate.subject.state':{category:'zeek',description:'State or province provided in the certificate subject. ',name:'zeek.x509.certificate.subject.state',type:'keyword'},'zeek.x509.certificate.issuer.country':{category:'zeek',description:'Country provided in the certificate issuer field. ',name:'zeek.x509.certificate.issuer.country',type:'keyword'},'zeek.x509.certificate.issuer.common_name':{category:'zeek',description:'Common name provided in the certificate issuer field. ',name:'zeek.x509.certificate.issuer.common_name',type:'keyword'},'zeek.x509.certificate.issuer.locality':{category:'zeek',description:'Locality provided in the certificate issuer field. ',name:'zeek.x509.certificate.issuer.locality',type:'keyword'},'zeek.x509.certificate.issuer.organization':{category:'zeek',description:'Organization provided in the certificate issuer field. ',name:'zeek.x509.certificate.issuer.organization',type:'keyword'},'zeek.x509.certificate.issuer.organizational_unit':{category:'zeek',description:'Organizational unit provided in the certificate issuer field. ',name:'zeek.x509.certificate.issuer.organizational_unit',type:'keyword'},'zeek.x509.certificate.issuer.state':{category:'zeek',description:'State or province provided in the certificate issuer field. ',name:'zeek.x509.certificate.issuer.state',type:'keyword'},'zeek.x509.certificate.common_name':{category:'zeek',description:'Last (most specific) common name. ',name:'zeek.x509.certificate.common_name',type:'keyword'},'zeek.x509.certificate.valid.from':{category:'zeek',description:'Timestamp before when certificate is not valid. ',name:'zeek.x509.certificate.valid.from',type:'date'},'zeek.x509.certificate.valid.until':{category:'zeek',description:'Timestamp after when certificate is not valid. ',name:'zeek.x509.certificate.valid.until',type:'date'},'zeek.x509.certificate.key.algorithm':{category:'zeek',description:'Name of the key algorithm. ',name:'zeek.x509.certificate.key.algorithm',type:'keyword'},'zeek.x509.certificate.key.type':{category:'zeek',description:'Key type, if key parseable by openssl (either rsa, dsa or ec). ',name:'zeek.x509.certificate.key.type',type:'keyword'},'zeek.x509.certificate.key.length':{category:'zeek',description:'Key length in bits. ',name:'zeek.x509.certificate.key.length',type:'integer'},'zeek.x509.certificate.signature_algorithm':{category:'zeek',description:'Name of the signature algorithm. ',name:'zeek.x509.certificate.signature_algorithm',type:'keyword'},'zeek.x509.certificate.exponent':{category:'zeek',description:'Exponent, if RSA-certificate. ',name:'zeek.x509.certificate.exponent',type:'keyword'},'zeek.x509.certificate.curve':{category:'zeek',description:'Curve, if EC-certificate. ',name:'zeek.x509.certificate.curve',type:'keyword'},'zeek.x509.san.dns':{category:'zeek',description:'List of DNS entries in SAN. ',name:'zeek.x509.san.dns',type:'keyword'},'zeek.x509.san.uri':{category:'zeek',description:'List of URI entries in SAN. ',name:'zeek.x509.san.uri',type:'keyword'},'zeek.x509.san.email':{category:'zeek',description:'List of email entries in SAN. ',name:'zeek.x509.san.email',type:'keyword'},'zeek.x509.san.ip':{category:'zeek',description:'List of IP entries in SAN. ',name:'zeek.x509.san.ip',type:'ip'},'zeek.x509.san.other_fields':{category:'zeek',description:'True if the certificate contained other, not recognized or parsed name fields. ',name:'zeek.x509.san.other_fields',type:'boolean'},'zeek.x509.basic_constraints.certificate_authority':{category:'zeek',description:'CA flag set or not. ',name:'zeek.x509.basic_constraints.certificate_authority',type:'boolean'},'zeek.x509.basic_constraints.path_length':{category:'zeek',description:'Maximum path length. ',name:'zeek.x509.basic_constraints.path_length',type:'integer'},'zeek.x509.log_cert':{category:'zeek',description:'Present if policy/protocols/ssl/log-hostcerts-only.bro is loaded Logging of certificate is suppressed if set to F. ',name:'zeek.x509.log_cert',type:'boolean'},'awscloudwatch.log_group':{category:'awscloudwatch',description:'The name of the log group to which this event belongs.',name:'awscloudwatch.log_group',type:'keyword'},'awscloudwatch.log_stream':{category:'awscloudwatch',description:'The name of the log stream to which this event belongs.',name:'awscloudwatch.log_stream',type:'keyword'},'awscloudwatch.ingestion_time':{category:'awscloudwatch',description:'The time the event was ingested in AWS CloudWatch.',name:'awscloudwatch.ingestion_time',type:'keyword'},'netflow.type':{category:'netflow',description:'The type of NetFlow record described by this event. ',name:'netflow.type',type:'keyword'},'netflow.exporter.address':{category:'netflow',description:"Exporter's network address in IP:port format. ",name:'netflow.exporter.address',type:'keyword'},'netflow.exporter.source_id':{category:'netflow',description:'Observation domain ID to which this record belongs. ',name:'netflow.exporter.source_id',type:'long'},'netflow.exporter.timestamp':{category:'netflow',description:'Time and date of export. ',name:'netflow.exporter.timestamp',type:'date'},'netflow.exporter.uptime_millis':{category:'netflow',description:'How long the exporter process has been running, in milliseconds. ',name:'netflow.exporter.uptime_millis',type:'long'},'netflow.exporter.version':{category:'netflow',description:'NetFlow version used. ',name:'netflow.exporter.version',type:'integer'},'netflow.octet_delta_count':{category:'netflow',name:'netflow.octet_delta_count',type:'long'},'netflow.packet_delta_count':{category:'netflow',name:'netflow.packet_delta_count',type:'long'},'netflow.delta_flow_count':{category:'netflow',name:'netflow.delta_flow_count',type:'long'},'netflow.protocol_identifier':{category:'netflow',name:'netflow.protocol_identifier',type:'short'},'netflow.ip_class_of_service':{category:'netflow',name:'netflow.ip_class_of_service',type:'short'},'netflow.tcp_control_bits':{category:'netflow',name:'netflow.tcp_control_bits',type:'integer'},'netflow.source_transport_port':{category:'netflow',name:'netflow.source_transport_port',type:'integer'},'netflow.source_ipv4_address':{category:'netflow',name:'netflow.source_ipv4_address',type:'ip'},'netflow.source_ipv4_prefix_length':{category:'netflow',name:'netflow.source_ipv4_prefix_length',type:'short'},'netflow.ingress_interface':{category:'netflow',name:'netflow.ingress_interface',type:'long'},'netflow.destination_transport_port':{category:'netflow',name:'netflow.destination_transport_port',type:'integer'},'netflow.destination_ipv4_address':{category:'netflow',name:'netflow.destination_ipv4_address',type:'ip'},'netflow.destination_ipv4_prefix_length':{category:'netflow',name:'netflow.destination_ipv4_prefix_length',type:'short'},'netflow.egress_interface':{category:'netflow',name:'netflow.egress_interface',type:'long'},'netflow.ip_next_hop_ipv4_address':{category:'netflow',name:'netflow.ip_next_hop_ipv4_address',type:'ip'},'netflow.bgp_source_as_number':{category:'netflow',name:'netflow.bgp_source_as_number',type:'long'},'netflow.bgp_destination_as_number':{category:'netflow',name:'netflow.bgp_destination_as_number',type:'long'},'netflow.bgp_next_hop_ipv4_address':{category:'netflow',name:'netflow.bgp_next_hop_ipv4_address',type:'ip'},'netflow.post_mcast_packet_delta_count':{category:'netflow',name:'netflow.post_mcast_packet_delta_count',type:'long'},'netflow.post_mcast_octet_delta_count':{category:'netflow',name:'netflow.post_mcast_octet_delta_count',type:'long'},'netflow.flow_end_sys_up_time':{category:'netflow',name:'netflow.flow_end_sys_up_time',type:'long'},'netflow.flow_start_sys_up_time':{category:'netflow',name:'netflow.flow_start_sys_up_time',type:'long'},'netflow.post_octet_delta_count':{category:'netflow',name:'netflow.post_octet_delta_count',type:'long'},'netflow.post_packet_delta_count':{category:'netflow',name:'netflow.post_packet_delta_count',type:'long'},'netflow.minimum_ip_total_length':{category:'netflow',name:'netflow.minimum_ip_total_length',type:'long'},'netflow.maximum_ip_total_length':{category:'netflow',name:'netflow.maximum_ip_total_length',type:'long'},'netflow.source_ipv6_address':{category:'netflow',name:'netflow.source_ipv6_address',type:'ip'},'netflow.destination_ipv6_address':{category:'netflow',name:'netflow.destination_ipv6_address',type:'ip'},'netflow.source_ipv6_prefix_length':{category:'netflow',name:'netflow.source_ipv6_prefix_length',type:'short'},'netflow.destination_ipv6_prefix_length':{category:'netflow',name:'netflow.destination_ipv6_prefix_length',type:'short'},'netflow.flow_label_ipv6':{category:'netflow',name:'netflow.flow_label_ipv6',type:'long'},'netflow.icmp_type_code_ipv4':{category:'netflow',name:'netflow.icmp_type_code_ipv4',type:'integer'},'netflow.igmp_type':{category:'netflow',name:'netflow.igmp_type',type:'short'},'netflow.sampling_interval':{category:'netflow',name:'netflow.sampling_interval',type:'long'},'netflow.sampling_algorithm':{category:'netflow',name:'netflow.sampling_algorithm',type:'short'},'netflow.flow_active_timeout':{category:'netflow',name:'netflow.flow_active_timeout',type:'integer'},'netflow.flow_idle_timeout':{category:'netflow',name:'netflow.flow_idle_timeout',type:'integer'},'netflow.engine_type':{category:'netflow',name:'netflow.engine_type',type:'short'},'netflow.engine_id':{category:'netflow',name:'netflow.engine_id',type:'short'},'netflow.exported_octet_total_count':{category:'netflow',name:'netflow.exported_octet_total_count',type:'long'},'netflow.exported_message_total_count':{category:'netflow',name:'netflow.exported_message_total_count',type:'long'},'netflow.exported_flow_record_total_count':{category:'netflow',name:'netflow.exported_flow_record_total_count',type:'long'},'netflow.ipv4_router_sc':{category:'netflow',name:'netflow.ipv4_router_sc',type:'ip'},'netflow.source_ipv4_prefix':{category:'netflow',name:'netflow.source_ipv4_prefix',type:'ip'},'netflow.destination_ipv4_prefix':{category:'netflow',name:'netflow.destination_ipv4_prefix',type:'ip'},'netflow.mpls_top_label_type':{category:'netflow',name:'netflow.mpls_top_label_type',type:'short'},'netflow.mpls_top_label_ipv4_address':{category:'netflow',name:'netflow.mpls_top_label_ipv4_address',type:'ip'},'netflow.sampler_id':{category:'netflow',name:'netflow.sampler_id',type:'short'},'netflow.sampler_mode':{category:'netflow',name:'netflow.sampler_mode',type:'short'},'netflow.sampler_random_interval':{category:'netflow',name:'netflow.sampler_random_interval',type:'long'},'netflow.class_id':{category:'netflow',name:'netflow.class_id',type:'long'},'netflow.minimum_ttl':{category:'netflow',name:'netflow.minimum_ttl',type:'short'},'netflow.maximum_ttl':{category:'netflow',name:'netflow.maximum_ttl',type:'short'},'netflow.fragment_identification':{category:'netflow',name:'netflow.fragment_identification',type:'long'},'netflow.post_ip_class_of_service':{category:'netflow',name:'netflow.post_ip_class_of_service',type:'short'},'netflow.source_mac_address':{category:'netflow',name:'netflow.source_mac_address',type:'keyword'},'netflow.post_destination_mac_address':{category:'netflow',name:'netflow.post_destination_mac_address',type:'keyword'},'netflow.vlan_id':{category:'netflow',name:'netflow.vlan_id',type:'integer'},'netflow.post_vlan_id':{category:'netflow',name:'netflow.post_vlan_id',type:'integer'},'netflow.ip_version':{category:'netflow',name:'netflow.ip_version',type:'short'},'netflow.flow_direction':{category:'netflow',name:'netflow.flow_direction',type:'short'},'netflow.ip_next_hop_ipv6_address':{category:'netflow',name:'netflow.ip_next_hop_ipv6_address',type:'ip'},'netflow.bgp_next_hop_ipv6_address':{category:'netflow',name:'netflow.bgp_next_hop_ipv6_address',type:'ip'},'netflow.ipv6_extension_headers':{category:'netflow',name:'netflow.ipv6_extension_headers',type:'long'},'netflow.mpls_top_label_stack_section':{category:'netflow',name:'netflow.mpls_top_label_stack_section',type:'short'},'netflow.mpls_label_stack_section2':{category:'netflow',name:'netflow.mpls_label_stack_section2',type:'short'},'netflow.mpls_label_stack_section3':{category:'netflow',name:'netflow.mpls_label_stack_section3',type:'short'},'netflow.mpls_label_stack_section4':{category:'netflow',name:'netflow.mpls_label_stack_section4',type:'short'},'netflow.mpls_label_stack_section5':{category:'netflow',name:'netflow.mpls_label_stack_section5',type:'short'},'netflow.mpls_label_stack_section6':{category:'netflow',name:'netflow.mpls_label_stack_section6',type:'short'},'netflow.mpls_label_stack_section7':{category:'netflow',name:'netflow.mpls_label_stack_section7',type:'short'},'netflow.mpls_label_stack_section8':{category:'netflow',name:'netflow.mpls_label_stack_section8',type:'short'},'netflow.mpls_label_stack_section9':{category:'netflow',name:'netflow.mpls_label_stack_section9',type:'short'},'netflow.mpls_label_stack_section10':{category:'netflow',name:'netflow.mpls_label_stack_section10',type:'short'},'netflow.destination_mac_address':{category:'netflow',name:'netflow.destination_mac_address',type:'keyword'},'netflow.post_source_mac_address':{category:'netflow',name:'netflow.post_source_mac_address',type:'keyword'},'netflow.interface_name':{category:'netflow',name:'netflow.interface_name',type:'keyword'},'netflow.interface_description':{category:'netflow',name:'netflow.interface_description',type:'keyword'},'netflow.sampler_name':{category:'netflow',name:'netflow.sampler_name',type:'keyword'},'netflow.octet_total_count':{category:'netflow',name:'netflow.octet_total_count',type:'long'},'netflow.packet_total_count':{category:'netflow',name:'netflow.packet_total_count',type:'long'},'netflow.flags_and_sampler_id':{category:'netflow',name:'netflow.flags_and_sampler_id',type:'long'},'netflow.fragment_offset':{category:'netflow',name:'netflow.fragment_offset',type:'integer'},'netflow.forwarding_status':{category:'netflow',name:'netflow.forwarding_status',type:'short'},'netflow.mpls_vpn_route_distinguisher':{category:'netflow',name:'netflow.mpls_vpn_route_distinguisher',type:'short'},'netflow.mpls_top_label_prefix_length':{category:'netflow',name:'netflow.mpls_top_label_prefix_length',type:'short'},'netflow.src_traffic_index':{category:'netflow',name:'netflow.src_traffic_index',type:'long'},'netflow.dst_traffic_index':{category:'netflow',name:'netflow.dst_traffic_index',type:'long'},'netflow.application_description':{category:'netflow',name:'netflow.application_description',type:'keyword'},'netflow.application_id':{category:'netflow',name:'netflow.application_id',type:'short'},'netflow.application_name':{category:'netflow',name:'netflow.application_name',type:'keyword'},'netflow.post_ip_diff_serv_code_point':{category:'netflow',name:'netflow.post_ip_diff_serv_code_point',type:'short'},'netflow.multicast_replication_factor':{category:'netflow',name:'netflow.multicast_replication_factor',type:'long'},'netflow.class_name':{category:'netflow',name:'netflow.class_name',type:'keyword'},'netflow.classification_engine_id':{category:'netflow',name:'netflow.classification_engine_id',type:'short'},'netflow.layer2packet_section_offset':{category:'netflow',name:'netflow.layer2packet_section_offset',type:'integer'},'netflow.layer2packet_section_size':{category:'netflow',name:'netflow.layer2packet_section_size',type:'integer'},'netflow.layer2packet_section_data':{category:'netflow',name:'netflow.layer2packet_section_data',type:'short'},'netflow.bgp_next_adjacent_as_number':{category:'netflow',name:'netflow.bgp_next_adjacent_as_number',type:'long'},'netflow.bgp_prev_adjacent_as_number':{category:'netflow',name:'netflow.bgp_prev_adjacent_as_number',type:'long'},'netflow.exporter_ipv4_address':{category:'netflow',name:'netflow.exporter_ipv4_address',type:'ip'},'netflow.exporter_ipv6_address':{category:'netflow',name:'netflow.exporter_ipv6_address',type:'ip'},'netflow.dropped_octet_delta_count':{category:'netflow',name:'netflow.dropped_octet_delta_count',type:'long'},'netflow.dropped_packet_delta_count':{category:'netflow',name:'netflow.dropped_packet_delta_count',type:'long'},'netflow.dropped_octet_total_count':{category:'netflow',name:'netflow.dropped_octet_total_count',type:'long'},'netflow.dropped_packet_total_count':{category:'netflow',name:'netflow.dropped_packet_total_count',type:'long'},'netflow.flow_end_reason':{category:'netflow',name:'netflow.flow_end_reason',type:'short'},'netflow.common_properties_id':{category:'netflow',name:'netflow.common_properties_id',type:'long'},'netflow.observation_point_id':{category:'netflow',name:'netflow.observation_point_id',type:'long'},'netflow.icmp_type_code_ipv6':{category:'netflow',name:'netflow.icmp_type_code_ipv6',type:'integer'},'netflow.mpls_top_label_ipv6_address':{category:'netflow',name:'netflow.mpls_top_label_ipv6_address',type:'ip'},'netflow.line_card_id':{category:'netflow',name:'netflow.line_card_id',type:'long'},'netflow.port_id':{category:'netflow',name:'netflow.port_id',type:'long'},'netflow.metering_process_id':{category:'netflow',name:'netflow.metering_process_id',type:'long'},'netflow.exporting_process_id':{category:'netflow',name:'netflow.exporting_process_id',type:'long'},'netflow.template_id':{category:'netflow',name:'netflow.template_id',type:'integer'},'netflow.wlan_channel_id':{category:'netflow',name:'netflow.wlan_channel_id',type:'short'},'netflow.wlan_ssid':{category:'netflow',name:'netflow.wlan_ssid',type:'keyword'},'netflow.flow_id':{category:'netflow',name:'netflow.flow_id',type:'long'},'netflow.observation_domain_id':{category:'netflow',name:'netflow.observation_domain_id',type:'long'},'netflow.flow_start_seconds':{category:'netflow',name:'netflow.flow_start_seconds',type:'date'},'netflow.flow_end_seconds':{category:'netflow',name:'netflow.flow_end_seconds',type:'date'},'netflow.flow_start_milliseconds':{category:'netflow',name:'netflow.flow_start_milliseconds',type:'date'},'netflow.flow_end_milliseconds':{category:'netflow',name:'netflow.flow_end_milliseconds',type:'date'},'netflow.flow_start_microseconds':{category:'netflow',name:'netflow.flow_start_microseconds',type:'date'},'netflow.flow_end_microseconds':{category:'netflow',name:'netflow.flow_end_microseconds',type:'date'},'netflow.flow_start_nanoseconds':{category:'netflow',name:'netflow.flow_start_nanoseconds',type:'date'},'netflow.flow_end_nanoseconds':{category:'netflow',name:'netflow.flow_end_nanoseconds',type:'date'},'netflow.flow_start_delta_microseconds':{category:'netflow',name:'netflow.flow_start_delta_microseconds',type:'long'},'netflow.flow_end_delta_microseconds':{category:'netflow',name:'netflow.flow_end_delta_microseconds',type:'long'},'netflow.system_init_time_milliseconds':{category:'netflow',name:'netflow.system_init_time_milliseconds',type:'date'},'netflow.flow_duration_milliseconds':{category:'netflow',name:'netflow.flow_duration_milliseconds',type:'long'},'netflow.flow_duration_microseconds':{category:'netflow',name:'netflow.flow_duration_microseconds',type:'long'},'netflow.observed_flow_total_count':{category:'netflow',name:'netflow.observed_flow_total_count',type:'long'},'netflow.ignored_packet_total_count':{category:'netflow',name:'netflow.ignored_packet_total_count',type:'long'},'netflow.ignored_octet_total_count':{category:'netflow',name:'netflow.ignored_octet_total_count',type:'long'},'netflow.not_sent_flow_total_count':{category:'netflow',name:'netflow.not_sent_flow_total_count',type:'long'},'netflow.not_sent_packet_total_count':{category:'netflow',name:'netflow.not_sent_packet_total_count',type:'long'},'netflow.not_sent_octet_total_count':{category:'netflow',name:'netflow.not_sent_octet_total_count',type:'long'},'netflow.destination_ipv6_prefix':{category:'netflow',name:'netflow.destination_ipv6_prefix',type:'ip'},'netflow.source_ipv6_prefix':{category:'netflow',name:'netflow.source_ipv6_prefix',type:'ip'},'netflow.post_octet_total_count':{category:'netflow',name:'netflow.post_octet_total_count',type:'long'},'netflow.post_packet_total_count':{category:'netflow',name:'netflow.post_packet_total_count',type:'long'},'netflow.flow_key_indicator':{category:'netflow',name:'netflow.flow_key_indicator',type:'long'},'netflow.post_mcast_packet_total_count':{category:'netflow',name:'netflow.post_mcast_packet_total_count',type:'long'},'netflow.post_mcast_octet_total_count':{category:'netflow',name:'netflow.post_mcast_octet_total_count',type:'long'},'netflow.icmp_type_ipv4':{category:'netflow',name:'netflow.icmp_type_ipv4',type:'short'},'netflow.icmp_code_ipv4':{category:'netflow',name:'netflow.icmp_code_ipv4',type:'short'},'netflow.icmp_type_ipv6':{category:'netflow',name:'netflow.icmp_type_ipv6',type:'short'},'netflow.icmp_code_ipv6':{category:'netflow',name:'netflow.icmp_code_ipv6',type:'short'},'netflow.udp_source_port':{category:'netflow',name:'netflow.udp_source_port',type:'integer'},'netflow.udp_destination_port':{category:'netflow',name:'netflow.udp_destination_port',type:'integer'},'netflow.tcp_source_port':{category:'netflow',name:'netflow.tcp_source_port',type:'integer'},'netflow.tcp_destination_port':{category:'netflow',name:'netflow.tcp_destination_port',type:'integer'},'netflow.tcp_sequence_number':{category:'netflow',name:'netflow.tcp_sequence_number',type:'long'},'netflow.tcp_acknowledgement_number':{category:'netflow',name:'netflow.tcp_acknowledgement_number',type:'long'},'netflow.tcp_window_size':{category:'netflow',name:'netflow.tcp_window_size',type:'integer'},'netflow.tcp_urgent_pointer':{category:'netflow',name:'netflow.tcp_urgent_pointer',type:'integer'},'netflow.tcp_header_length':{category:'netflow',name:'netflow.tcp_header_length',type:'short'},'netflow.ip_header_length':{category:'netflow',name:'netflow.ip_header_length',type:'short'},'netflow.total_length_ipv4':{category:'netflow',name:'netflow.total_length_ipv4',type:'integer'},'netflow.payload_length_ipv6':{category:'netflow',name:'netflow.payload_length_ipv6',type:'integer'},'netflow.ip_ttl':{category:'netflow',name:'netflow.ip_ttl',type:'short'},'netflow.next_header_ipv6':{category:'netflow',name:'netflow.next_header_ipv6',type:'short'},'netflow.mpls_payload_length':{category:'netflow',name:'netflow.mpls_payload_length',type:'long'},'netflow.ip_diff_serv_code_point':{category:'netflow',name:'netflow.ip_diff_serv_code_point',type:'short'},'netflow.ip_precedence':{category:'netflow',name:'netflow.ip_precedence',type:'short'},'netflow.fragment_flags':{category:'netflow',name:'netflow.fragment_flags',type:'short'},'netflow.octet_delta_sum_of_squares':{category:'netflow',name:'netflow.octet_delta_sum_of_squares',type:'long'},'netflow.octet_total_sum_of_squares':{category:'netflow',name:'netflow.octet_total_sum_of_squares',type:'long'},'netflow.mpls_top_label_ttl':{category:'netflow',name:'netflow.mpls_top_label_ttl',type:'short'},'netflow.mpls_label_stack_length':{category:'netflow',name:'netflow.mpls_label_stack_length',type:'long'},'netflow.mpls_label_stack_depth':{category:'netflow',name:'netflow.mpls_label_stack_depth',type:'long'},'netflow.mpls_top_label_exp':{category:'netflow',name:'netflow.mpls_top_label_exp',type:'short'},'netflow.ip_payload_length':{category:'netflow',name:'netflow.ip_payload_length',type:'long'},'netflow.udp_message_length':{category:'netflow',name:'netflow.udp_message_length',type:'integer'},'netflow.is_multicast':{category:'netflow',name:'netflow.is_multicast',type:'short'},'netflow.ipv4_ihl':{category:'netflow',name:'netflow.ipv4_ihl',type:'short'},'netflow.ipv4_options':{category:'netflow',name:'netflow.ipv4_options',type:'long'},'netflow.tcp_options':{category:'netflow',name:'netflow.tcp_options',type:'long'},'netflow.padding_octets':{category:'netflow',name:'netflow.padding_octets',type:'short'},'netflow.collector_ipv4_address':{category:'netflow',name:'netflow.collector_ipv4_address',type:'ip'},'netflow.collector_ipv6_address':{category:'netflow',name:'netflow.collector_ipv6_address',type:'ip'},'netflow.export_interface':{category:'netflow',name:'netflow.export_interface',type:'long'},'netflow.export_protocol_version':{category:'netflow',name:'netflow.export_protocol_version',type:'short'},'netflow.export_transport_protocol':{category:'netflow',name:'netflow.export_transport_protocol',type:'short'},'netflow.collector_transport_port':{category:'netflow',name:'netflow.collector_transport_port',type:'integer'},'netflow.exporter_transport_port':{category:'netflow',name:'netflow.exporter_transport_port',type:'integer'},'netflow.tcp_syn_total_count':{category:'netflow',name:'netflow.tcp_syn_total_count',type:'long'},'netflow.tcp_fin_total_count':{category:'netflow',name:'netflow.tcp_fin_total_count',type:'long'},'netflow.tcp_rst_total_count':{category:'netflow',name:'netflow.tcp_rst_total_count',type:'long'},'netflow.tcp_psh_total_count':{category:'netflow',name:'netflow.tcp_psh_total_count',type:'long'},'netflow.tcp_ack_total_count':{category:'netflow',name:'netflow.tcp_ack_total_count',type:'long'},'netflow.tcp_urg_total_count':{category:'netflow',name:'netflow.tcp_urg_total_count',type:'long'},'netflow.ip_total_length':{category:'netflow',name:'netflow.ip_total_length',type:'long'},'netflow.post_nat_source_ipv4_address':{category:'netflow',name:'netflow.post_nat_source_ipv4_address',type:'ip'},'netflow.post_nat_destination_ipv4_address':{category:'netflow',name:'netflow.post_nat_destination_ipv4_address',type:'ip'},'netflow.post_napt_source_transport_port':{category:'netflow',name:'netflow.post_napt_source_transport_port',type:'integer'},'netflow.post_napt_destination_transport_port':{category:'netflow',name:'netflow.post_napt_destination_transport_port',type:'integer'},'netflow.nat_originating_address_realm':{category:'netflow',name:'netflow.nat_originating_address_realm',type:'short'},'netflow.nat_event':{category:'netflow',name:'netflow.nat_event',type:'short'},'netflow.initiator_octets':{category:'netflow',name:'netflow.initiator_octets',type:'long'},'netflow.responder_octets':{category:'netflow',name:'netflow.responder_octets',type:'long'},'netflow.firewall_event':{category:'netflow',name:'netflow.firewall_event',type:'short'},'netflow.ingress_vrfid':{category:'netflow',name:'netflow.ingress_vrfid',type:'long'},'netflow.egress_vrfid':{category:'netflow',name:'netflow.egress_vrfid',type:'long'},'netflow.vr_fname':{category:'netflow',name:'netflow.vr_fname',type:'keyword'},'netflow.post_mpls_top_label_exp':{category:'netflow',name:'netflow.post_mpls_top_label_exp',type:'short'},'netflow.tcp_window_scale':{category:'netflow',name:'netflow.tcp_window_scale',type:'integer'},'netflow.biflow_direction':{category:'netflow',name:'netflow.biflow_direction',type:'short'},'netflow.ethernet_header_length':{category:'netflow',name:'netflow.ethernet_header_length',type:'short'},'netflow.ethernet_payload_length':{category:'netflow',name:'netflow.ethernet_payload_length',type:'integer'},'netflow.ethernet_total_length':{category:'netflow',name:'netflow.ethernet_total_length',type:'integer'},'netflow.dot1q_vlan_id':{category:'netflow',name:'netflow.dot1q_vlan_id',type:'integer'},'netflow.dot1q_priority':{category:'netflow',name:'netflow.dot1q_priority',type:'short'},'netflow.dot1q_customer_vlan_id':{category:'netflow',name:'netflow.dot1q_customer_vlan_id',type:'integer'},'netflow.dot1q_customer_priority':{category:'netflow',name:'netflow.dot1q_customer_priority',type:'short'},'netflow.metro_evc_id':{category:'netflow',name:'netflow.metro_evc_id',type:'keyword'},'netflow.metro_evc_type':{category:'netflow',name:'netflow.metro_evc_type',type:'short'},'netflow.pseudo_wire_id':{category:'netflow',name:'netflow.pseudo_wire_id',type:'long'},'netflow.pseudo_wire_type':{category:'netflow',name:'netflow.pseudo_wire_type',type:'integer'},'netflow.pseudo_wire_control_word':{category:'netflow',name:'netflow.pseudo_wire_control_word',type:'long'},'netflow.ingress_physical_interface':{category:'netflow',name:'netflow.ingress_physical_interface',type:'long'},'netflow.egress_physical_interface':{category:'netflow',name:'netflow.egress_physical_interface',type:'long'},'netflow.post_dot1q_vlan_id':{category:'netflow',name:'netflow.post_dot1q_vlan_id',type:'integer'},'netflow.post_dot1q_customer_vlan_id':{category:'netflow',name:'netflow.post_dot1q_customer_vlan_id',type:'integer'},'netflow.ethernet_type':{category:'netflow',name:'netflow.ethernet_type',type:'integer'},'netflow.post_ip_precedence':{category:'netflow',name:'netflow.post_ip_precedence',type:'short'},'netflow.collection_time_milliseconds':{category:'netflow',name:'netflow.collection_time_milliseconds',type:'date'},'netflow.export_sctp_stream_id':{category:'netflow',name:'netflow.export_sctp_stream_id',type:'integer'},'netflow.max_export_seconds':{category:'netflow',name:'netflow.max_export_seconds',type:'date'},'netflow.max_flow_end_seconds':{category:'netflow',name:'netflow.max_flow_end_seconds',type:'date'},'netflow.message_md5_checksum':{category:'netflow',name:'netflow.message_md5_checksum',type:'short'},'netflow.message_scope':{category:'netflow',name:'netflow.message_scope',type:'short'},'netflow.min_export_seconds':{category:'netflow',name:'netflow.min_export_seconds',type:'date'},'netflow.min_flow_start_seconds':{category:'netflow',name:'netflow.min_flow_start_seconds',type:'date'},'netflow.opaque_octets':{category:'netflow',name:'netflow.opaque_octets',type:'short'},'netflow.session_scope':{category:'netflow',name:'netflow.session_scope',type:'short'},'netflow.max_flow_end_microseconds':{category:'netflow',name:'netflow.max_flow_end_microseconds',type:'date'},'netflow.max_flow_end_milliseconds':{category:'netflow',name:'netflow.max_flow_end_milliseconds',type:'date'},'netflow.max_flow_end_nanoseconds':{category:'netflow',name:'netflow.max_flow_end_nanoseconds',type:'date'},'netflow.min_flow_start_microseconds':{category:'netflow',name:'netflow.min_flow_start_microseconds',type:'date'},'netflow.min_flow_start_milliseconds':{category:'netflow',name:'netflow.min_flow_start_milliseconds',type:'date'},'netflow.min_flow_start_nanoseconds':{category:'netflow',name:'netflow.min_flow_start_nanoseconds',type:'date'},'netflow.collector_certificate':{category:'netflow',name:'netflow.collector_certificate',type:'short'},'netflow.exporter_certificate':{category:'netflow',name:'netflow.exporter_certificate',type:'short'},'netflow.data_records_reliability':{category:'netflow',name:'netflow.data_records_reliability',type:'boolean'},'netflow.observation_point_type':{category:'netflow',name:'netflow.observation_point_type',type:'short'},'netflow.new_connection_delta_count':{category:'netflow',name:'netflow.new_connection_delta_count',type:'long'},'netflow.connection_sum_duration_seconds':{category:'netflow',name:'netflow.connection_sum_duration_seconds',type:'long'},'netflow.connection_transaction_id':{category:'netflow',name:'netflow.connection_transaction_id',type:'long'},'netflow.post_nat_source_ipv6_address':{category:'netflow',name:'netflow.post_nat_source_ipv6_address',type:'ip'},'netflow.post_nat_destination_ipv6_address':{category:'netflow',name:'netflow.post_nat_destination_ipv6_address',type:'ip'},'netflow.nat_pool_id':{category:'netflow',name:'netflow.nat_pool_id',type:'long'},'netflow.nat_pool_name':{category:'netflow',name:'netflow.nat_pool_name',type:'keyword'},'netflow.anonymization_flags':{category:'netflow',name:'netflow.anonymization_flags',type:'integer'},'netflow.anonymization_technique':{category:'netflow',name:'netflow.anonymization_technique',type:'integer'},'netflow.information_element_index':{category:'netflow',name:'netflow.information_element_index',type:'integer'},'netflow.p2p_technology':{category:'netflow',name:'netflow.p2p_technology',type:'keyword'},'netflow.tunnel_technology':{category:'netflow',name:'netflow.tunnel_technology',type:'keyword'},'netflow.encrypted_technology':{category:'netflow',name:'netflow.encrypted_technology',type:'keyword'},'netflow.bgp_validity_state':{category:'netflow',name:'netflow.bgp_validity_state',type:'short'},'netflow.ip_sec_spi':{category:'netflow',name:'netflow.ip_sec_spi',type:'long'},'netflow.gre_key':{category:'netflow',name:'netflow.gre_key',type:'long'},'netflow.nat_type':{category:'netflow',name:'netflow.nat_type',type:'short'},'netflow.initiator_packets':{category:'netflow',name:'netflow.initiator_packets',type:'long'},'netflow.responder_packets':{category:'netflow',name:'netflow.responder_packets',type:'long'},'netflow.observation_domain_name':{category:'netflow',name:'netflow.observation_domain_name',type:'keyword'},'netflow.selection_sequence_id':{category:'netflow',name:'netflow.selection_sequence_id',type:'long'},'netflow.selector_id':{category:'netflow',name:'netflow.selector_id',type:'long'},'netflow.information_element_id':{category:'netflow',name:'netflow.information_element_id',type:'integer'},'netflow.selector_algorithm':{category:'netflow',name:'netflow.selector_algorithm',type:'integer'},'netflow.sampling_packet_interval':{category:'netflow',name:'netflow.sampling_packet_interval',type:'long'},'netflow.sampling_packet_space':{category:'netflow',name:'netflow.sampling_packet_space',type:'long'},'netflow.sampling_time_interval':{category:'netflow',name:'netflow.sampling_time_interval',type:'long'},'netflow.sampling_time_space':{category:'netflow',name:'netflow.sampling_time_space',type:'long'},'netflow.sampling_size':{category:'netflow',name:'netflow.sampling_size',type:'long'},'netflow.sampling_population':{category:'netflow',name:'netflow.sampling_population',type:'long'},'netflow.sampling_probability':{category:'netflow',name:'netflow.sampling_probability',type:'double'},'netflow.data_link_frame_size':{category:'netflow',name:'netflow.data_link_frame_size',type:'integer'},'netflow.ip_header_packet_section':{category:'netflow',name:'netflow.ip_header_packet_section',type:'short'},'netflow.ip_payload_packet_section':{category:'netflow',name:'netflow.ip_payload_packet_section',type:'short'},'netflow.data_link_frame_section':{category:'netflow',name:'netflow.data_link_frame_section',type:'short'},'netflow.mpls_label_stack_section':{category:'netflow',name:'netflow.mpls_label_stack_section',type:'short'},'netflow.mpls_payload_packet_section':{category:'netflow',name:'netflow.mpls_payload_packet_section',type:'short'},'netflow.selector_id_total_pkts_observed':{category:'netflow',name:'netflow.selector_id_total_pkts_observed',type:'long'},'netflow.selector_id_total_pkts_selected':{category:'netflow',name:'netflow.selector_id_total_pkts_selected',type:'long'},'netflow.absolute_error':{category:'netflow',name:'netflow.absolute_error',type:'double'},'netflow.relative_error':{category:'netflow',name:'netflow.relative_error',type:'double'},'netflow.observation_time_seconds':{category:'netflow',name:'netflow.observation_time_seconds',type:'date'},'netflow.observation_time_milliseconds':{category:'netflow',name:'netflow.observation_time_milliseconds',type:'date'},'netflow.observation_time_microseconds':{category:'netflow',name:'netflow.observation_time_microseconds',type:'date'},'netflow.observation_time_nanoseconds':{category:'netflow',name:'netflow.observation_time_nanoseconds',type:'date'},'netflow.digest_hash_value':{category:'netflow',name:'netflow.digest_hash_value',type:'long'},'netflow.hash_ip_payload_offset':{category:'netflow',name:'netflow.hash_ip_payload_offset',type:'long'},'netflow.hash_ip_payload_size':{category:'netflow',name:'netflow.hash_ip_payload_size',type:'long'},'netflow.hash_output_range_min':{category:'netflow',name:'netflow.hash_output_range_min',type:'long'},'netflow.hash_output_range_max':{category:'netflow',name:'netflow.hash_output_range_max',type:'long'},'netflow.hash_selected_range_min':{category:'netflow',name:'netflow.hash_selected_range_min',type:'long'},'netflow.hash_selected_range_max':{category:'netflow',name:'netflow.hash_selected_range_max',type:'long'},'netflow.hash_digest_output':{category:'netflow',name:'netflow.hash_digest_output',type:'boolean'},'netflow.hash_initialiser_value':{category:'netflow',name:'netflow.hash_initialiser_value',type:'long'},'netflow.selector_name':{category:'netflow',name:'netflow.selector_name',type:'keyword'},'netflow.upper_ci_limit':{category:'netflow',name:'netflow.upper_ci_limit',type:'double'},'netflow.lower_ci_limit':{category:'netflow',name:'netflow.lower_ci_limit',type:'double'},'netflow.confidence_level':{category:'netflow',name:'netflow.confidence_level',type:'double'},'netflow.information_element_data_type':{category:'netflow',name:'netflow.information_element_data_type',type:'short'},'netflow.information_element_description':{category:'netflow',name:'netflow.information_element_description',type:'keyword'},'netflow.information_element_name':{category:'netflow',name:'netflow.information_element_name',type:'keyword'},'netflow.information_element_range_begin':{category:'netflow',name:'netflow.information_element_range_begin',type:'long'},'netflow.information_element_range_end':{category:'netflow',name:'netflow.information_element_range_end',type:'long'},'netflow.information_element_semantics':{category:'netflow',name:'netflow.information_element_semantics',type:'short'},'netflow.information_element_units':{category:'netflow',name:'netflow.information_element_units',type:'integer'},'netflow.private_enterprise_number':{category:'netflow',name:'netflow.private_enterprise_number',type:'long'},'netflow.virtual_station_interface_id':{category:'netflow',name:'netflow.virtual_station_interface_id',type:'short'},'netflow.virtual_station_interface_name':{category:'netflow',name:'netflow.virtual_station_interface_name',type:'keyword'},'netflow.virtual_station_uuid':{category:'netflow',name:'netflow.virtual_station_uuid',type:'short'},'netflow.virtual_station_name':{category:'netflow',name:'netflow.virtual_station_name',type:'keyword'},'netflow.layer2_segment_id':{category:'netflow',name:'netflow.layer2_segment_id',type:'long'},'netflow.layer2_octet_delta_count':{category:'netflow',name:'netflow.layer2_octet_delta_count',type:'long'},'netflow.layer2_octet_total_count':{category:'netflow',name:'netflow.layer2_octet_total_count',type:'long'},'netflow.ingress_unicast_packet_total_count':{category:'netflow',name:'netflow.ingress_unicast_packet_total_count',type:'long'},'netflow.ingress_multicast_packet_total_count':{category:'netflow',name:'netflow.ingress_multicast_packet_total_count',type:'long'},'netflow.ingress_broadcast_packet_total_count':{category:'netflow',name:'netflow.ingress_broadcast_packet_total_count',type:'long'},'netflow.egress_unicast_packet_total_count':{category:'netflow',name:'netflow.egress_unicast_packet_total_count',type:'long'},'netflow.egress_broadcast_packet_total_count':{category:'netflow',name:'netflow.egress_broadcast_packet_total_count',type:'long'},'netflow.monitoring_interval_start_milli_seconds':{category:'netflow',name:'netflow.monitoring_interval_start_milli_seconds',type:'date'},'netflow.monitoring_interval_end_milli_seconds':{category:'netflow',name:'netflow.monitoring_interval_end_milli_seconds',type:'date'},'netflow.port_range_start':{category:'netflow',name:'netflow.port_range_start',type:'integer'},'netflow.port_range_end':{category:'netflow',name:'netflow.port_range_end',type:'integer'},'netflow.port_range_step_size':{category:'netflow',name:'netflow.port_range_step_size',type:'integer'},'netflow.port_range_num_ports':{category:'netflow',name:'netflow.port_range_num_ports',type:'integer'},'netflow.sta_mac_address':{category:'netflow',name:'netflow.sta_mac_address',type:'keyword'},'netflow.sta_ipv4_address':{category:'netflow',name:'netflow.sta_ipv4_address',type:'ip'},'netflow.wtp_mac_address':{category:'netflow',name:'netflow.wtp_mac_address',type:'keyword'},'netflow.ingress_interface_type':{category:'netflow',name:'netflow.ingress_interface_type',type:'long'},'netflow.egress_interface_type':{category:'netflow',name:'netflow.egress_interface_type',type:'long'},'netflow.rtp_sequence_number':{category:'netflow',name:'netflow.rtp_sequence_number',type:'integer'},'netflow.user_name':{category:'netflow',name:'netflow.user_name',type:'keyword'},'netflow.application_category_name':{category:'netflow',name:'netflow.application_category_name',type:'keyword'},'netflow.application_sub_category_name':{category:'netflow',name:'netflow.application_sub_category_name',type:'keyword'},'netflow.application_group_name':{category:'netflow',name:'netflow.application_group_name',type:'keyword'},'netflow.original_flows_present':{category:'netflow',name:'netflow.original_flows_present',type:'long'},'netflow.original_flows_initiated':{category:'netflow',name:'netflow.original_flows_initiated',type:'long'},'netflow.original_flows_completed':{category:'netflow',name:'netflow.original_flows_completed',type:'long'},'netflow.distinct_count_of_source_ip_address':{category:'netflow',name:'netflow.distinct_count_of_source_ip_address',type:'long'},'netflow.distinct_count_of_destination_ip_address':{category:'netflow',name:'netflow.distinct_count_of_destination_ip_address',type:'long'},'netflow.distinct_count_of_source_ipv4_address':{category:'netflow',name:'netflow.distinct_count_of_source_ipv4_address',type:'long'},'netflow.distinct_count_of_destination_ipv4_address':{category:'netflow',name:'netflow.distinct_count_of_destination_ipv4_address',type:'long'},'netflow.distinct_count_of_source_ipv6_address':{category:'netflow',name:'netflow.distinct_count_of_source_ipv6_address',type:'long'},'netflow.distinct_count_of_destination_ipv6_address':{category:'netflow',name:'netflow.distinct_count_of_destination_ipv6_address',type:'long'},'netflow.value_distribution_method':{category:'netflow',name:'netflow.value_distribution_method',type:'short'},'netflow.rfc3550_jitter_milliseconds':{category:'netflow',name:'netflow.rfc3550_jitter_milliseconds',type:'long'},'netflow.rfc3550_jitter_microseconds':{category:'netflow',name:'netflow.rfc3550_jitter_microseconds',type:'long'},'netflow.rfc3550_jitter_nanoseconds':{category:'netflow',name:'netflow.rfc3550_jitter_nanoseconds',type:'long'},'netflow.dot1q_dei':{category:'netflow',name:'netflow.dot1q_dei',type:'boolean'},'netflow.dot1q_customer_dei':{category:'netflow',name:'netflow.dot1q_customer_dei',type:'boolean'},'netflow.flow_selector_algorithm':{category:'netflow',name:'netflow.flow_selector_algorithm',type:'integer'},'netflow.flow_selected_octet_delta_count':{category:'netflow',name:'netflow.flow_selected_octet_delta_count',type:'long'},'netflow.flow_selected_packet_delta_count':{category:'netflow',name:'netflow.flow_selected_packet_delta_count',type:'long'},'netflow.flow_selected_flow_delta_count':{category:'netflow',name:'netflow.flow_selected_flow_delta_count',type:'long'},'netflow.selector_id_total_flows_observed':{category:'netflow',name:'netflow.selector_id_total_flows_observed',type:'long'},'netflow.selector_id_total_flows_selected':{category:'netflow',name:'netflow.selector_id_total_flows_selected',type:'long'},'netflow.sampling_flow_interval':{category:'netflow',name:'netflow.sampling_flow_interval',type:'long'},'netflow.sampling_flow_spacing':{category:'netflow',name:'netflow.sampling_flow_spacing',type:'long'},'netflow.flow_sampling_time_interval':{category:'netflow',name:'netflow.flow_sampling_time_interval',type:'long'},'netflow.flow_sampling_time_spacing':{category:'netflow',name:'netflow.flow_sampling_time_spacing',type:'long'},'netflow.hash_flow_domain':{category:'netflow',name:'netflow.hash_flow_domain',type:'integer'},'netflow.transport_octet_delta_count':{category:'netflow',name:'netflow.transport_octet_delta_count',type:'long'},'netflow.transport_packet_delta_count':{category:'netflow',name:'netflow.transport_packet_delta_count',type:'long'},'netflow.original_exporter_ipv4_address':{category:'netflow',name:'netflow.original_exporter_ipv4_address',type:'ip'},'netflow.original_exporter_ipv6_address':{category:'netflow',name:'netflow.original_exporter_ipv6_address',type:'ip'},'netflow.original_observation_domain_id':{category:'netflow',name:'netflow.original_observation_domain_id',type:'long'},'netflow.intermediate_process_id':{category:'netflow',name:'netflow.intermediate_process_id',type:'long'},'netflow.ignored_data_record_total_count':{category:'netflow',name:'netflow.ignored_data_record_total_count',type:'long'},'netflow.data_link_frame_type':{category:'netflow',name:'netflow.data_link_frame_type',type:'integer'},'netflow.section_offset':{category:'netflow',name:'netflow.section_offset',type:'integer'},'netflow.section_exported_octets':{category:'netflow',name:'netflow.section_exported_octets',type:'integer'},'netflow.dot1q_service_instance_tag':{category:'netflow',name:'netflow.dot1q_service_instance_tag',type:'short'},'netflow.dot1q_service_instance_id':{category:'netflow',name:'netflow.dot1q_service_instance_id',type:'long'},'netflow.dot1q_service_instance_priority':{category:'netflow',name:'netflow.dot1q_service_instance_priority',type:'short'},'netflow.dot1q_customer_source_mac_address':{category:'netflow',name:'netflow.dot1q_customer_source_mac_address',type:'keyword'},'netflow.dot1q_customer_destination_mac_address':{category:'netflow',name:'netflow.dot1q_customer_destination_mac_address',type:'keyword'},'netflow.post_layer2_octet_delta_count':{category:'netflow',name:'netflow.post_layer2_octet_delta_count',type:'long'},'netflow.post_mcast_layer2_octet_delta_count':{category:'netflow',name:'netflow.post_mcast_layer2_octet_delta_count',type:'long'},'netflow.post_layer2_octet_total_count':{category:'netflow',name:'netflow.post_layer2_octet_total_count',type:'long'},'netflow.post_mcast_layer2_octet_total_count':{category:'netflow',name:'netflow.post_mcast_layer2_octet_total_count',type:'long'},'netflow.minimum_layer2_total_length':{category:'netflow',name:'netflow.minimum_layer2_total_length',type:'long'},'netflow.maximum_layer2_total_length':{category:'netflow',name:'netflow.maximum_layer2_total_length',type:'long'},'netflow.dropped_layer2_octet_delta_count':{category:'netflow',name:'netflow.dropped_layer2_octet_delta_count',type:'long'},'netflow.dropped_layer2_octet_total_count':{category:'netflow',name:'netflow.dropped_layer2_octet_total_count',type:'long'},'netflow.ignored_layer2_octet_total_count':{category:'netflow',name:'netflow.ignored_layer2_octet_total_count',type:'long'},'netflow.not_sent_layer2_octet_total_count':{category:'netflow',name:'netflow.not_sent_layer2_octet_total_count',type:'long'},'netflow.layer2_octet_delta_sum_of_squares':{category:'netflow',name:'netflow.layer2_octet_delta_sum_of_squares',type:'long'},'netflow.layer2_octet_total_sum_of_squares':{category:'netflow',name:'netflow.layer2_octet_total_sum_of_squares',type:'long'},'netflow.layer2_frame_delta_count':{category:'netflow',name:'netflow.layer2_frame_delta_count',type:'long'},'netflow.layer2_frame_total_count':{category:'netflow',name:'netflow.layer2_frame_total_count',type:'long'},'netflow.pseudo_wire_destination_ipv4_address':{category:'netflow',name:'netflow.pseudo_wire_destination_ipv4_address',type:'ip'},'netflow.ignored_layer2_frame_total_count':{category:'netflow',name:'netflow.ignored_layer2_frame_total_count',type:'long'},'netflow.mib_object_value_integer':{category:'netflow',name:'netflow.mib_object_value_integer',type:'integer'},'netflow.mib_object_value_octet_string':{category:'netflow',name:'netflow.mib_object_value_octet_string',type:'short'},'netflow.mib_object_value_oid':{category:'netflow',name:'netflow.mib_object_value_oid',type:'short'},'netflow.mib_object_value_bits':{category:'netflow',name:'netflow.mib_object_value_bits',type:'short'},'netflow.mib_object_value_ip_address':{category:'netflow',name:'netflow.mib_object_value_ip_address',type:'ip'},'netflow.mib_object_value_counter':{category:'netflow',name:'netflow.mib_object_value_counter',type:'long'},'netflow.mib_object_value_gauge':{category:'netflow',name:'netflow.mib_object_value_gauge',type:'long'},'netflow.mib_object_value_time_ticks':{category:'netflow',name:'netflow.mib_object_value_time_ticks',type:'long'},'netflow.mib_object_value_unsigned':{category:'netflow',name:'netflow.mib_object_value_unsigned',type:'long'},'netflow.mib_object_identifier':{category:'netflow',name:'netflow.mib_object_identifier',type:'short'},'netflow.mib_sub_identifier':{category:'netflow',name:'netflow.mib_sub_identifier',type:'long'},'netflow.mib_index_indicator':{category:'netflow',name:'netflow.mib_index_indicator',type:'long'},'netflow.mib_capture_time_semantics':{category:'netflow',name:'netflow.mib_capture_time_semantics',type:'short'},'netflow.mib_context_engine_id':{category:'netflow',name:'netflow.mib_context_engine_id',type:'short'},'netflow.mib_context_name':{category:'netflow',name:'netflow.mib_context_name',type:'keyword'},'netflow.mib_object_name':{category:'netflow',name:'netflow.mib_object_name',type:'keyword'},'netflow.mib_object_description':{category:'netflow',name:'netflow.mib_object_description',type:'keyword'},'netflow.mib_object_syntax':{category:'netflow',name:'netflow.mib_object_syntax',type:'keyword'},'netflow.mib_module_name':{category:'netflow',name:'netflow.mib_module_name',type:'keyword'},'netflow.mobile_imsi':{category:'netflow',name:'netflow.mobile_imsi',type:'keyword'},'netflow.mobile_msisdn':{category:'netflow',name:'netflow.mobile_msisdn',type:'keyword'},'netflow.http_status_code':{category:'netflow',name:'netflow.http_status_code',type:'integer'},'netflow.source_transport_ports_limit':{category:'netflow',name:'netflow.source_transport_ports_limit',type:'integer'},'netflow.http_request_method':{category:'netflow',name:'netflow.http_request_method',type:'keyword'},'netflow.http_request_host':{category:'netflow',name:'netflow.http_request_host',type:'keyword'},'netflow.http_request_target':{category:'netflow',name:'netflow.http_request_target',type:'keyword'},'netflow.http_message_version':{category:'netflow',name:'netflow.http_message_version',type:'keyword'},'netflow.nat_instance_id':{category:'netflow',name:'netflow.nat_instance_id',type:'long'},'netflow.internal_address_realm':{category:'netflow',name:'netflow.internal_address_realm',type:'short'},'netflow.external_address_realm':{category:'netflow',name:'netflow.external_address_realm',type:'short'},'netflow.nat_quota_exceeded_event':{category:'netflow',name:'netflow.nat_quota_exceeded_event',type:'long'},'netflow.nat_threshold_event':{category:'netflow',name:'netflow.nat_threshold_event',type:'long'},'netflow.http_user_agent':{category:'netflow',name:'netflow.http_user_agent',type:'keyword'},'netflow.http_content_type':{category:'netflow',name:'netflow.http_content_type',type:'keyword'},'netflow.http_reason_phrase':{category:'netflow',name:'netflow.http_reason_phrase',type:'keyword'},'netflow.max_session_entries':{category:'netflow',name:'netflow.max_session_entries',type:'long'},'netflow.max_bib_entries':{category:'netflow',name:'netflow.max_bib_entries',type:'long'},'netflow.max_entries_per_user':{category:'netflow',name:'netflow.max_entries_per_user',type:'long'},'netflow.max_subscribers':{category:'netflow',name:'netflow.max_subscribers',type:'long'},'netflow.max_fragments_pending_reassembly':{category:'netflow',name:'netflow.max_fragments_pending_reassembly',type:'long'},'netflow.address_pool_high_threshold':{category:'netflow',name:'netflow.address_pool_high_threshold',type:'long'},'netflow.address_pool_low_threshold':{category:'netflow',name:'netflow.address_pool_low_threshold',type:'long'},'netflow.address_port_mapping_high_threshold':{category:'netflow',name:'netflow.address_port_mapping_high_threshold',type:'long'},'netflow.address_port_mapping_low_threshold':{category:'netflow',name:'netflow.address_port_mapping_low_threshold',type:'long'},'netflow.address_port_mapping_per_user_high_threshold':{category:'netflow',name:'netflow.address_port_mapping_per_user_high_threshold',type:'long'},'netflow.global_address_mapping_high_threshold':{category:'netflow',name:'netflow.global_address_mapping_high_threshold',type:'long'},'netflow.vpn_identifier':{category:'netflow',name:'netflow.vpn_identifier',type:'short'},bucket_name:{category:'base',description:'Name of the S3 bucket that this log retrieved from. ',name:'bucket_name',type:'keyword'},object_key:{category:'base',description:'Name of the S3 object that this log retrieved from. ',name:'object_key',type:'keyword'},'cef.version':{category:'cef',description:'Version of the CEF specification used by the message. ',name:'cef.version',type:'keyword'},'cef.device.vendor':{category:'cef',description:'Vendor of the device that produced the message. ',name:'cef.device.vendor',type:'keyword'},'cef.device.product':{category:'cef',description:'Product of the device that produced the message. ',name:'cef.device.product',type:'keyword'},'cef.device.version':{category:'cef',description:'Version of the product that produced the message. ',name:'cef.device.version',type:'keyword'},'cef.device.event_class_id':{category:'cef',description:'Unique identifier of the event type. ',name:'cef.device.event_class_id',type:'keyword'},'cef.severity':{category:'cef',description:'Importance of the event. The valid string values are Unknown, Low, Medium, High, and Very-High. The valid integer values are 0-3=Low, 4-6=Medium, 7- 8=High, and 9-10=Very-High. ',example:'Very-High',name:'cef.severity',type:'keyword'},'cef.name':{category:'cef',description:'Short description of the event. ',name:'cef.name',type:'keyword'},'cef.extensions.agentAddress':{category:'cef',description:'The IP address of the ArcSight connector that processed the event.',name:'cef.extensions.agentAddress',type:'ip'},'cef.extensions.agentDnsDomain':{category:'cef',description:'The DNS domain name of the ArcSight connector that processed the event.',name:'cef.extensions.agentDnsDomain',type:'keyword'},'cef.extensions.agentHostName':{category:'cef',description:'The hostname of the ArcSight connector that processed the event.',name:'cef.extensions.agentHostName',type:'keyword'},'cef.extensions.agentId':{category:'cef',description:'The agent ID of the ArcSight connector that processed the event.',name:'cef.extensions.agentId',type:'keyword'},'cef.extensions.agentMacAddress':{category:'cef',description:'The MAC address of the ArcSight connector that processed the event.',name:'cef.extensions.agentMacAddress',type:'keyword'},'cef.extensions.agentNtDomain':{category:'cef',description:'null',name:'cef.extensions.agentNtDomain',type:'keyword'},'cef.extensions.agentReceiptTime':{category:'cef',description:'The time at which information about the event was received by the ArcSight connector.',name:'cef.extensions.agentReceiptTime',type:'date'},'cef.extensions.agentTimeZone':{category:'cef',description:'The agent time zone of the ArcSight connector that processed the event.',name:'cef.extensions.agentTimeZone',type:'keyword'},'cef.extensions.agentTranslatedAddress':{category:'cef',description:'null',name:'cef.extensions.agentTranslatedAddress',type:'ip'},'cef.extensions.agentTranslatedZoneExternalID':{category:'cef',description:'null',name:'cef.extensions.agentTranslatedZoneExternalID',type:'keyword'},'cef.extensions.agentTranslatedZoneURI':{category:'cef',description:'null',name:'cef.extensions.agentTranslatedZoneURI',type:'keyword'},'cef.extensions.agentType':{category:'cef',description:'The agent type of the ArcSight connector that processed the event',name:'cef.extensions.agentType',type:'keyword'},'cef.extensions.agentVersion':{category:'cef',description:'The version of the ArcSight connector that processed the event.',name:'cef.extensions.agentVersion',type:'keyword'},'cef.extensions.agentZoneExternalID':{category:'cef',description:'null',name:'cef.extensions.agentZoneExternalID',type:'keyword'},'cef.extensions.agentZoneURI':{category:'cef',description:'null',name:'cef.extensions.agentZoneURI',type:'keyword'},'cef.extensions.applicationProtocol':{category:'cef',description:'Application level protocol, example values are HTTP, HTTPS, SSHv2, Telnet, POP, IMPA, IMAPS, and so on.',name:'cef.extensions.applicationProtocol',type:'keyword'},'cef.extensions.baseEventCount':{category:'cef',description:'A count associated with this event. How many times was this same event observed? Count can be omitted if it is 1.',name:'cef.extensions.baseEventCount',type:'long'},'cef.extensions.bytesIn':{category:'cef',description:'Number of bytes transferred inbound, relative to the source to destination relationship, meaning that data was flowing from source to destination.',name:'cef.extensions.bytesIn',type:'long'},'cef.extensions.bytesOut':{category:'cef',description:'Number of bytes transferred outbound relative to the source to destination relationship. For example, the byte number of data flowing from the destination to the source.',name:'cef.extensions.bytesOut',type:'long'},'cef.extensions.customerExternalID':{category:'cef',description:'null',name:'cef.extensions.customerExternalID',type:'keyword'},'cef.extensions.customerURI':{category:'cef',description:'null',name:'cef.extensions.customerURI',type:'keyword'},'cef.extensions.destinationAddress':{category:'cef',description:'Identifies the destination address that the event refers to in an IP network. The format is an IPv4 address.',name:'cef.extensions.destinationAddress',type:'ip'},'cef.extensions.destinationDnsDomain':{category:'cef',description:'The DNS domain part of the complete fully qualified domain name (FQDN).',name:'cef.extensions.destinationDnsDomain',type:'keyword'},'cef.extensions.destinationGeoLatitude':{category:'cef',description:"The latitudinal value from which the destination's IP address belongs.",name:'cef.extensions.destinationGeoLatitude',type:'double'},'cef.extensions.destinationGeoLongitude':{category:'cef',description:"The longitudinal value from which the destination's IP address belongs.",name:'cef.extensions.destinationGeoLongitude',type:'double'},'cef.extensions.destinationHostName':{category:'cef',description:'Identifies the destination that an event refers to in an IP network. The format should be a fully qualified domain name (FQDN) associated with the destination node, when a node is available.',name:'cef.extensions.destinationHostName',type:'keyword'},'cef.extensions.destinationMacAddress':{category:'cef',description:'Six colon-seperated hexadecimal numbers.',name:'cef.extensions.destinationMacAddress',type:'keyword'},'cef.extensions.destinationNtDomain':{category:'cef',description:'The Windows domain name of the destination address.',name:'cef.extensions.destinationNtDomain',type:'keyword'},'cef.extensions.destinationPort':{category:'cef',description:'The valid port numbers are between 0 and 65535.',name:'cef.extensions.destinationPort',type:'long'},'cef.extensions.destinationProcessId':{category:'cef',description:'Provides the ID of the destination process associated with the event. For example, if an event contains process ID 105, "105" is the process ID.',name:'cef.extensions.destinationProcessId',type:'long'},'cef.extensions.destinationProcessName':{category:'cef',description:"The name of the event's destination process.",name:'cef.extensions.destinationProcessName',type:'keyword'},'cef.extensions.destinationServiceName':{category:'cef',description:'The service targeted by this event.',name:'cef.extensions.destinationServiceName',type:'keyword'},'cef.extensions.destinationTranslatedAddress':{category:'cef',description:'Identifies the translated destination that the event refers to in an IP network.',name:'cef.extensions.destinationTranslatedAddress',type:'ip'},'cef.extensions.destinationTranslatedPort':{category:'cef',description:'Port after it was translated; for example, a firewall. Valid port numbers are 0 to 65535.',name:'cef.extensions.destinationTranslatedPort',type:'long'},'cef.extensions.destinationTranslatedZoneExternalID':{category:'cef',description:'null',name:'cef.extensions.destinationTranslatedZoneExternalID',type:'keyword'},'cef.extensions.destinationTranslatedZoneURI':{category:'cef',description:'The URI for the Translated Zone that the destination asset has been assigned to in ArcSight.',name:'cef.extensions.destinationTranslatedZoneURI',type:'keyword'},'cef.extensions.destinationUserId':{category:'cef',description:'Identifies the destination user by ID. For example, in UNIX, the root user is generally associated with user ID 0.',name:'cef.extensions.destinationUserId',type:'keyword'},'cef.extensions.destinationUserName':{category:'cef',description:"Identifies the destination user by name. This is the user associated with the event's destination. Email addresses are often mapped into the UserName fields. The recipient is a candidate to put into this field.",name:'cef.extensions.destinationUserName',type:'keyword'},'cef.extensions.destinationUserPrivileges':{category:'cef',description:'The typical values are "Administrator", "User", and "Guest". This identifies the destination user\'s privileges. In UNIX, for example, activity executed on the root user would be identified with destinationUser Privileges of "Administrator".',name:'cef.extensions.destinationUserPrivileges',type:'keyword'},'cef.extensions.destinationZoneExternalID':{category:'cef',description:'null',name:'cef.extensions.destinationZoneExternalID',type:'keyword'},'cef.extensions.destinationZoneURI':{category:'cef',description:'The URI for the Zone that the destination asset has been assigned to in ArcSight.',name:'cef.extensions.destinationZoneURI',type:'keyword'},'cef.extensions.deviceAction':{category:'cef',description:'Action taken by the device.',name:'cef.extensions.deviceAction',type:'keyword'},'cef.extensions.deviceAddress':{category:'cef',description:'Identifies the device address that an event refers to in an IP network.',name:'cef.extensions.deviceAddress',type:'ip'},'cef.extensions.deviceCustomFloatingPoint1Label':{category:'cef',description:'All custom fields have a corresponding label field. Each of these fields is a string and describes the purpose of the custom field.',name:'cef.extensions.deviceCustomFloatingPoint1Label',type:'keyword'},'cef.extensions.deviceCustomFloatingPoint3Label':{category:'cef',description:'All custom fields have a corresponding label field. Each of these fields is a string and describes the purpose of the custom field.',name:'cef.extensions.deviceCustomFloatingPoint3Label',type:'keyword'},'cef.extensions.deviceCustomFloatingPoint4Label':{category:'cef',description:'All custom fields have a corresponding label field. Each of these fields is a string and describes the purpose of the custom field.',name:'cef.extensions.deviceCustomFloatingPoint4Label',type:'keyword'},'cef.extensions.deviceCustomDate1':{category:'cef',description:'One of two timestamp fields available to map fields that do not apply to any other in this dictionary.',name:'cef.extensions.deviceCustomDate1',type:'date'},'cef.extensions.deviceCustomDate1Label':{category:'cef',description:'All custom fields have a corresponding label field. Each of these fields is a string and describes the purpose of the custom field.',name:'cef.extensions.deviceCustomDate1Label',type:'keyword'},'cef.extensions.deviceCustomDate2':{category:'cef',description:'One of two timestamp fields available to map fields that do not apply to any other in this dictionary.',name:'cef.extensions.deviceCustomDate2',type:'date'},'cef.extensions.deviceCustomDate2Label':{category:'cef',description:'All custom fields have a corresponding label field. Each of these fields is a string and describes the purpose of the custom field.',name:'cef.extensions.deviceCustomDate2Label',type:'keyword'},'cef.extensions.deviceCustomFloatingPoint1':{category:'cef',description:'One of four floating point fields available to map fields that do not apply to any other in this dictionary.',name:'cef.extensions.deviceCustomFloatingPoint1',type:'double'},'cef.extensions.deviceCustomFloatingPoint2':{category:'cef',description:'One of four floating point fields available to map fields that do not apply to any other in this dictionary.',name:'cef.extensions.deviceCustomFloatingPoint2',type:'double'},'cef.extensions.deviceCustomFloatingPoint2Label':{category:'cef',description:'All custom fields have a corresponding label field. Each of these fields is a string and describes the purpose of the custom field.',name:'cef.extensions.deviceCustomFloatingPoint2Label',type:'keyword'},'cef.extensions.deviceCustomFloatingPoint3':{category:'cef',description:'One of four floating point fields available to map fields that do not apply to any other in this dictionary.',name:'cef.extensions.deviceCustomFloatingPoint3',type:'double'},'cef.extensions.deviceCustomFloatingPoint4':{category:'cef',description:'One of four floating point fields available to map fields that do not apply to any other in this dictionary.',name:'cef.extensions.deviceCustomFloatingPoint4',type:'double'},'cef.extensions.deviceCustomIPv6Address1':{category:'cef',description:'One of four IPv6 address fields available to map fields that do not apply to any other in this dictionary.',name:'cef.extensions.deviceCustomIPv6Address1',type:'ip'},'cef.extensions.deviceCustomIPv6Address1Label':{category:'cef',description:'All custom fields have a corresponding label field. Each of these fields is a string and describes the purpose of the custom field.',name:'cef.extensions.deviceCustomIPv6Address1Label',type:'keyword'},'cef.extensions.deviceCustomIPv6Address2':{category:'cef',description:'One of four IPv6 address fields available to map fields that do not apply to any other in this dictionary.',name:'cef.extensions.deviceCustomIPv6Address2',type:'ip'},'cef.extensions.deviceCustomIPv6Address2Label':{category:'cef',description:'All custom fields have a corresponding label field. Each of these fields is a string and describes the purpose of the custom field.',name:'cef.extensions.deviceCustomIPv6Address2Label',type:'keyword'},'cef.extensions.deviceCustomIPv6Address3':{category:'cef',description:'One of four IPv6 address fields available to map fields that do not apply to any other in this dictionary.',name:'cef.extensions.deviceCustomIPv6Address3',type:'ip'},'cef.extensions.deviceCustomIPv6Address3Label':{category:'cef',description:'All custom fields have a corresponding label field. Each of these fields is a string and describes the purpose of the custom field.',name:'cef.extensions.deviceCustomIPv6Address3Label',type:'keyword'},'cef.extensions.deviceCustomIPv6Address4':{category:'cef',description:'One of four IPv6 address fields available to map fields that do not apply to any other in this dictionary.',name:'cef.extensions.deviceCustomIPv6Address4',type:'ip'},'cef.extensions.deviceCustomIPv6Address4Label':{category:'cef',description:'All custom fields have a corresponding label field. Each of these fields is a string and describes the purpose of the custom field.',name:'cef.extensions.deviceCustomIPv6Address4Label',type:'keyword'},'cef.extensions.deviceCustomNumber1':{category:'cef',description:'One of three number fields available to map fields that do not apply to any other in this dictionary. Use sparingly and seek a more specific, dictionary supplied field when possible.',name:'cef.extensions.deviceCustomNumber1',type:'long'},'cef.extensions.deviceCustomNumber1Label':{category:'cef',description:'All custom fields have a corresponding label field. Each of these fields is a string and describes the purpose of the custom field.',name:'cef.extensions.deviceCustomNumber1Label',type:'keyword'},'cef.extensions.deviceCustomNumber2':{category:'cef',description:'One of three number fields available to map fields that do not apply to any other in this dictionary. Use sparingly and seek a more specific, dictionary supplied field when possible.',name:'cef.extensions.deviceCustomNumber2',type:'long'},'cef.extensions.deviceCustomNumber2Label':{category:'cef',description:'All custom fields have a corresponding label field. Each of these fields is a string and describes the purpose of the custom field.',name:'cef.extensions.deviceCustomNumber2Label',type:'keyword'},'cef.extensions.deviceCustomNumber3':{category:'cef',description:'One of three number fields available to map fields that do not apply to any other in this dictionary. Use sparingly and seek a more specific, dictionary supplied field when possible.',name:'cef.extensions.deviceCustomNumber3',type:'long'},'cef.extensions.deviceCustomNumber3Label':{category:'cef',description:'All custom fields have a corresponding label field. Each of these fields is a string and describes the purpose of the custom field.',name:'cef.extensions.deviceCustomNumber3Label',type:'keyword'},'cef.extensions.deviceCustomString1':{category:'cef',description:'One of six strings available to map fields that do not apply to any other in this dictionary. Use sparingly and seek a more specific, dictionary supplied field when possible.',name:'cef.extensions.deviceCustomString1',type:'keyword'},'cef.extensions.deviceCustomString1Label':{category:'cef',description:'All custom fields have a corresponding label field. Each of these fields is a string and describes the purpose of the custom field.',name:'cef.extensions.deviceCustomString1Label',type:'keyword'},'cef.extensions.deviceCustomString2':{category:'cef',description:'One of six strings available to map fields that do not apply to any other in this dictionary. Use sparingly and seek a more specific, dictionary supplied field when possible.',name:'cef.extensions.deviceCustomString2',type:'keyword'},'cef.extensions.deviceCustomString2Label':{category:'cef',description:'All custom fields have a corresponding label field. Each of these fields is a string and describes the purpose of the custom field.',name:'cef.extensions.deviceCustomString2Label',type:'keyword'},'cef.extensions.deviceCustomString3':{category:'cef',description:'One of six strings available to map fields that do not apply to any other in this dictionary. Use sparingly and seek a more specific, dictionary supplied field when possible.',name:'cef.extensions.deviceCustomString3',type:'keyword'},'cef.extensions.deviceCustomString3Label':{category:'cef',description:'All custom fields have a corresponding label field. Each of these fields is a string and describes the purpose of the custom field.',name:'cef.extensions.deviceCustomString3Label',type:'keyword'},'cef.extensions.deviceCustomString4':{category:'cef',description:'One of six strings available to map fields that do not apply to any other in this dictionary. Use sparingly and seek a more specific, dictionary supplied field when possible.',name:'cef.extensions.deviceCustomString4',type:'keyword'},'cef.extensions.deviceCustomString4Label':{category:'cef',description:'All custom fields have a corresponding label field. Each of these fields is a string and describes the purpose of the custom field.',name:'cef.extensions.deviceCustomString4Label',type:'keyword'},'cef.extensions.deviceCustomString5':{category:'cef',description:'One of six strings available to map fields that do not apply to any other in this dictionary. Use sparingly and seek a more specific, dictionary supplied field when possible.',name:'cef.extensions.deviceCustomString5',type:'keyword'},'cef.extensions.deviceCustomString5Label':{category:'cef',description:'All custom fields have a corresponding label field. Each of these fields is a string and describes the purpose of the custom field.',name:'cef.extensions.deviceCustomString5Label',type:'keyword'},'cef.extensions.deviceCustomString6':{category:'cef',description:'One of six strings available to map fields that do not apply to any other in this dictionary. Use sparingly and seek a more specific, dictionary supplied field when possible.',name:'cef.extensions.deviceCustomString6',type:'keyword'},'cef.extensions.deviceCustomString6Label':{category:'cef',description:'All custom fields have a corresponding label field. Each of these fields is a string and describes the purpose of the custom field.',name:'cef.extensions.deviceCustomString6Label',type:'keyword'},'cef.extensions.deviceDirection':{category:'cef',description:'Any information about what direction the observed communication has taken. The following values are supported - "0" for inbound or "1" for outbound.',name:'cef.extensions.deviceDirection',type:'long'},'cef.extensions.deviceDnsDomain':{category:'cef',description:'The DNS domain part of the complete fully qualified domain name (FQDN).',name:'cef.extensions.deviceDnsDomain',type:'keyword'},'cef.extensions.deviceEventCategory':{category:'cef',description:'Represents the category assigned by the originating device. Devices often use their own categorization schema to classify event. Example "/Monitor/Disk/Read".',name:'cef.extensions.deviceEventCategory',type:'keyword'},'cef.extensions.deviceExternalId':{category:'cef',description:'A name that uniquely identifies the device generating this event.',name:'cef.extensions.deviceExternalId',type:'keyword'},'cef.extensions.deviceFacility':{category:'cef',description:'The facility generating this event. For example, Syslog has an explicit facility associated with every event.',name:'cef.extensions.deviceFacility',type:'keyword'},'cef.extensions.deviceFlexNumber1':{category:'cef',description:'One of two alternative number fields available to map fields that do not apply to any other in this dictionary. Use sparingly and seek a more specific, dictionary supplied field when possible.',name:'cef.extensions.deviceFlexNumber1',type:'long'},'cef.extensions.deviceFlexNumber1Label':{category:'cef',description:'All custom fields have a corresponding label field. Each of these fields is a string and describes the purpose of the custom field.',name:'cef.extensions.deviceFlexNumber1Label',type:'keyword'},'cef.extensions.deviceFlexNumber2':{category:'cef',description:'One of two alternative number fields available to map fields that do not apply to any other in this dictionary. Use sparingly and seek a more specific, dictionary supplied field when possible.',name:'cef.extensions.deviceFlexNumber2',type:'long'},'cef.extensions.deviceFlexNumber2Label':{category:'cef',description:'All custom fields have a corresponding label field. Each of these fields is a string and describes the purpose of the custom field.',name:'cef.extensions.deviceFlexNumber2Label',type:'keyword'},'cef.extensions.deviceHostName':{category:'cef',description:'The format should be a fully qualified domain name (FQDN) associated with the device node, when a node is available.',name:'cef.extensions.deviceHostName',type:'keyword'},'cef.extensions.deviceInboundInterface':{category:'cef',description:'Interface on which the packet or data entered the device.',name:'cef.extensions.deviceInboundInterface',type:'keyword'},'cef.extensions.deviceMacAddress':{category:'cef',description:'Six colon-separated hexadecimal numbers.',name:'cef.extensions.deviceMacAddress',type:'keyword'},'cef.extensions.deviceNtDomain':{category:'cef',description:'The Windows domain name of the device address.',name:'cef.extensions.deviceNtDomain',type:'keyword'},'cef.extensions.deviceOutboundInterface':{category:'cef',description:'Interface on which the packet or data left the device.',name:'cef.extensions.deviceOutboundInterface',type:'keyword'},'cef.extensions.devicePayloadId':{category:'cef',description:'Unique identifier for the payload associated with the event.',name:'cef.extensions.devicePayloadId',type:'keyword'},'cef.extensions.deviceProcessId':{category:'cef',description:'Provides the ID of the process on the device generating the event.',name:'cef.extensions.deviceProcessId',type:'long'},'cef.extensions.deviceProcessName':{category:'cef',description:'Process name associated with the event. An example might be the process generating the syslog entry in UNIX.',name:'cef.extensions.deviceProcessName',type:'keyword'},'cef.extensions.deviceReceiptTime':{category:'cef',description:'The time at which the event related to the activity was received. The format is MMM dd yyyy HH:mm:ss or milliseconds since epoch (Jan 1st 1970)',name:'cef.extensions.deviceReceiptTime',type:'date'},'cef.extensions.deviceTimeZone':{category:'cef',description:'The time zone for the device generating the event.',name:'cef.extensions.deviceTimeZone',type:'keyword'},'cef.extensions.deviceTranslatedAddress':{category:'cef',description:'Identifies the translated device address that the event refers to in an IP network.',name:'cef.extensions.deviceTranslatedAddress',type:'ip'},'cef.extensions.deviceTranslatedZoneExternalID':{category:'cef',description:'null',name:'cef.extensions.deviceTranslatedZoneExternalID',type:'keyword'},'cef.extensions.deviceTranslatedZoneURI':{category:'cef',description:'The URI for the Translated Zone that the device asset has been assigned to in ArcSight.',name:'cef.extensions.deviceTranslatedZoneURI',type:'keyword'},'cef.extensions.deviceZoneExternalID':{category:'cef',description:'null',name:'cef.extensions.deviceZoneExternalID',type:'keyword'},'cef.extensions.deviceZoneURI':{category:'cef',description:'Thee URI for the Zone that the device asset has been assigned to in ArcSight.',name:'cef.extensions.deviceZoneURI',type:'keyword'},'cef.extensions.endTime':{category:'cef',description:'The time at which the activity related to the event ended. The format is MMM dd yyyy HH:mm:ss or milliseconds since epoch (Jan 1st1970). An example would be reporting the end of a session.',name:'cef.extensions.endTime',type:'date'},'cef.extensions.eventId':{category:'cef',description:'This is a unique ID that ArcSight assigns to each event.',name:'cef.extensions.eventId',type:'long'},'cef.extensions.eventOutcome':{category:'cef',description:"Displays the outcome, usually as 'success' or 'failure'.",name:'cef.extensions.eventOutcome',type:'keyword'},'cef.extensions.externalId':{category:'cef',description:'The ID used by an originating device. They are usually increasing numbers, associated with events.',name:'cef.extensions.externalId',type:'keyword'},'cef.extensions.fileCreateTime':{category:'cef',description:'Time when the file was created.',name:'cef.extensions.fileCreateTime',type:'date'},'cef.extensions.fileHash':{category:'cef',description:'Hash of a file.',name:'cef.extensions.fileHash',type:'keyword'},'cef.extensions.fileId':{category:'cef',description:'An ID associated with a file could be the inode.',name:'cef.extensions.fileId',type:'keyword'},'cef.extensions.fileModificationTime':{category:'cef',description:'Time when the file was last modified.',name:'cef.extensions.fileModificationTime',type:'date'},'cef.extensions.filename':{category:'cef',description:'Name of the file only (without its path).',name:'cef.extensions.filename',type:'keyword'},'cef.extensions.filePath':{category:'cef',description:'Full path to the file, including file name itself.',name:'cef.extensions.filePath',type:'keyword'},'cef.extensions.filePermission':{category:'cef',description:'Permissions of the file.',name:'cef.extensions.filePermission',type:'keyword'},'cef.extensions.fileSize':{category:'cef',description:'Size of the file.',name:'cef.extensions.fileSize',type:'long'},'cef.extensions.fileType':{category:'cef',description:'Type of file (pipe, socket, etc.)',name:'cef.extensions.fileType',type:'keyword'},'cef.extensions.flexDate1':{category:'cef',description:'A timestamp field available to map a timestamp that does not apply to any other defined timestamp field in this dictionary. Use all flex fields sparingly and seek a more specific, dictionary supplied field when possible. These fields are typically reserved for customer use and should not be set by vendors unless necessary.',name:'cef.extensions.flexDate1',type:'date'},'cef.extensions.flexDate1Label':{category:'cef',description:'The label field is a string and describes the purpose of the flex field.',name:'cef.extensions.flexDate1Label',type:'keyword'},'cef.extensions.flexString1':{category:'cef',description:'One of four floating point fields available to map fields that do not apply to any other in this dictionary. Use sparingly and seek a more specific, dictionary supplied field when possible. These fields are typically reserved for customer use and should not be set by vendors unless necessary.',name:'cef.extensions.flexString1',type:'keyword'},'cef.extensions.flexString2':{category:'cef',description:'One of four floating point fields available to map fields that do not apply to any other in this dictionary. Use sparingly and seek a more specific, dictionary supplied field when possible. These fields are typically reserved for customer use and should not be set by vendors unless necessary.',name:'cef.extensions.flexString2',type:'keyword'},'cef.extensions.flexString1Label':{category:'cef',description:'The label field is a string and describes the purpose of the flex field.',name:'cef.extensions.flexString1Label',type:'keyword'},'cef.extensions.flexString2Label':{category:'cef',description:'The label field is a string and describes the purpose of the flex field.',name:'cef.extensions.flexString2Label',type:'keyword'},'cef.extensions.message':{category:'cef',description:'An arbitrary message giving more details about the event. Multi-line entries can be produced by using \\n as the new line separator.',name:'cef.extensions.message',type:'keyword'},'cef.extensions.oldFileCreateTime':{category:'cef',description:'Time when old file was created.',name:'cef.extensions.oldFileCreateTime',type:'date'},'cef.extensions.oldFileHash':{category:'cef',description:'Hash of the old file.',name:'cef.extensions.oldFileHash',type:'keyword'},'cef.extensions.oldFileId':{category:'cef',description:'An ID associated with the old file could be the inode.',name:'cef.extensions.oldFileId',type:'keyword'},'cef.extensions.oldFileModificationTime':{category:'cef',description:'Time when old file was last modified.',name:'cef.extensions.oldFileModificationTime',type:'date'},'cef.extensions.oldFileName':{category:'cef',description:'Name of the old file.',name:'cef.extensions.oldFileName',type:'keyword'},'cef.extensions.oldFilePath':{category:'cef',description:'Full path to the old file, including the file name itself.',name:'cef.extensions.oldFilePath',type:'keyword'},'cef.extensions.oldFilePermission':{category:'cef',description:'Permissions of the old file.',name:'cef.extensions.oldFilePermission',type:'keyword'},'cef.extensions.oldFileSize':{category:'cef',description:'Size of the old file.',name:'cef.extensions.oldFileSize',type:'long'},'cef.extensions.oldFileType':{category:'cef',description:'Type of the old file (pipe, socket, etc.)',name:'cef.extensions.oldFileType',type:'keyword'},'cef.extensions.rawEvent':{category:'cef',description:'null',name:'cef.extensions.rawEvent',type:'keyword'},'cef.extensions.Reason':{category:'cef',description:'The reason an audit event was generated. For example "bad password" or "unknown user". This could also be an error or return code. Example "0x1234".',name:'cef.extensions.Reason',type:'keyword'},'cef.extensions.requestClientApplication':{category:'cef',description:'The User-Agent associated with the request.',name:'cef.extensions.requestClientApplication',type:'keyword'},'cef.extensions.requestContext':{category:'cef',description:'Description of the content from which the request originated (for example, HTTP Referrer)',name:'cef.extensions.requestContext',type:'keyword'},'cef.extensions.requestCookies':{category:'cef',description:'Cookies associated with the request.',name:'cef.extensions.requestCookies',type:'keyword'},'cef.extensions.requestMethod':{category:'cef',description:'The HTTP method used to access a URL.',name:'cef.extensions.requestMethod',type:'keyword'},'cef.extensions.requestUrl':{category:'cef',description:'In the case of an HTTP request, this field contains the URL accessed. The URL should contain the protocol as well.',name:'cef.extensions.requestUrl',type:'keyword'},'cef.extensions.sourceAddress':{category:'cef',description:'Identifies the source that an event refers to in an IP network.',name:'cef.extensions.sourceAddress',type:'ip'},'cef.extensions.sourceDnsDomain':{category:'cef',description:'The DNS domain part of the complete fully qualified domain name (FQDN).',name:'cef.extensions.sourceDnsDomain',type:'keyword'},'cef.extensions.sourceGeoLatitude':{category:'cef',description:'null',name:'cef.extensions.sourceGeoLatitude',type:'double'},'cef.extensions.sourceGeoLongitude':{category:'cef',description:'null',name:'cef.extensions.sourceGeoLongitude',type:'double'},'cef.extensions.sourceHostName':{category:'cef',description:"Identifies the source that an event refers to in an IP network. The format should be a fully qualified domain name (FQDN) associated with the source node, when a mode is available. Examples: 'host' or 'host.domain.com'. ",name:'cef.extensions.sourceHostName',type:'keyword'},'cef.extensions.sourceMacAddress':{category:'cef',description:'Six colon-separated hexadecimal numbers.',example:'00:0d:60:af:1b:61',name:'cef.extensions.sourceMacAddress',type:'keyword'},'cef.extensions.sourceNtDomain':{category:'cef',description:'The Windows domain name for the source address.',name:'cef.extensions.sourceNtDomain',type:'keyword'},'cef.extensions.sourcePort':{category:'cef',description:'The valid port numbers are 0 to 65535.',name:'cef.extensions.sourcePort',type:'long'},'cef.extensions.sourceProcessId':{category:'cef',description:'The ID of the source process associated with the event.',name:'cef.extensions.sourceProcessId',type:'long'},'cef.extensions.sourceProcessName':{category:'cef',description:"The name of the event's source process.",name:'cef.extensions.sourceProcessName',type:'keyword'},'cef.extensions.sourceServiceName':{category:'cef',description:'The service that is responsible for generating this event.',name:'cef.extensions.sourceServiceName',type:'keyword'},'cef.extensions.sourceTranslatedAddress':{category:'cef',description:'Identifies the translated source that the event refers to in an IP network.',name:'cef.extensions.sourceTranslatedAddress',type:'ip'},'cef.extensions.sourceTranslatedPort':{category:'cef',description:'A port number after being translated by, for example, a firewall. Valid port numbers are 0 to 65535.',name:'cef.extensions.sourceTranslatedPort',type:'long'},'cef.extensions.sourceTranslatedZoneExternalID':{category:'cef',description:'null',name:'cef.extensions.sourceTranslatedZoneExternalID',type:'keyword'},'cef.extensions.sourceTranslatedZoneURI':{category:'cef',description:'The URI for the Translated Zone that the destination asset has been assigned to in ArcSight.',name:'cef.extensions.sourceTranslatedZoneURI',type:'keyword'},'cef.extensions.sourceUserId':{category:'cef',description:'Identifies the source user by ID. This is the user associated with the source of the event. For example, in UNIX, the root user is generally associated with user ID 0.',name:'cef.extensions.sourceUserId',type:'keyword'},'cef.extensions.sourceUserName':{category:'cef',description:'Identifies the source user by name. Email addresses are also mapped into the UserName fields. The sender is a candidate to put into this field.',name:'cef.extensions.sourceUserName',type:'keyword'},'cef.extensions.sourceUserPrivileges':{category:'cef',description:'The typical values are "Administrator", "User", and "Guest". It identifies the source user\'s privileges. In UNIX, for example, activity executed by the root user would be identified with "Administrator".',name:'cef.extensions.sourceUserPrivileges',type:'keyword'},'cef.extensions.sourceZoneExternalID':{category:'cef',description:'null',name:'cef.extensions.sourceZoneExternalID',type:'keyword'},'cef.extensions.sourceZoneURI':{category:'cef',description:'The URI for the Zone that the source asset has been assigned to in ArcSight.',name:'cef.extensions.sourceZoneURI',type:'keyword'},'cef.extensions.startTime':{category:'cef',description:'The time when the activity the event referred to started. The format is MMM dd yyyy HH:mm:ss or milliseconds since epoch (Jan 1st 1970)',name:'cef.extensions.startTime',type:'date'},'cef.extensions.transportProtocol':{category:'cef',description:'Identifies the Layer-4 protocol used. The possible values are protocols such as TCP or UDP.',name:'cef.extensions.transportProtocol',type:'keyword'},'cef.extensions.type':{category:'cef',description:'0 means base event, 1 means aggregated, 2 means correlation, and 3 means action. This field can be omitted for base events (type 0).',name:'cef.extensions.type',type:'long'},'cef.extensions.categoryDeviceType':{category:'cef',description:'Device type. Examples - Proxy, IDS, Web Server',name:'cef.extensions.categoryDeviceType',type:'keyword'},'cef.extensions.categoryObject':{category:'cef',description:'Object that the event is about. For example it can be an operating sytem, database, file, etc.',name:'cef.extensions.categoryObject',type:'keyword'},'cef.extensions.categoryBehavior':{category:'cef',description:"Action or a behavior associated with an event. It's what is being done to the object.",name:'cef.extensions.categoryBehavior',type:'keyword'},'cef.extensions.categoryTechnique':{category:'cef',description:'Technique being used (e.g. /DoS).',name:'cef.extensions.categoryTechnique',type:'keyword'},'cef.extensions.categoryDeviceGroup':{category:'cef',description:'General device group like Firewall.',name:'cef.extensions.categoryDeviceGroup',type:'keyword'},'cef.extensions.categorySignificance':{category:'cef',description:'Characterization of the importance of the event.',name:'cef.extensions.categorySignificance',type:'keyword'},'cef.extensions.categoryOutcome':{category:'cef',description:'Outcome of the event (e.g. sucess, failure, or attempt).',name:'cef.extensions.categoryOutcome',type:'keyword'},'cef.extensions.managerReceiptTime':{category:'cef',description:'When the Arcsight ESM received the event.',name:'cef.extensions.managerReceiptTime',type:'date'},'source.service.name':{category:'source',description:'Service that is the source of the event.',name:'source.service.name',type:'keyword'},'destination.service.name':{category:'destination',description:'Service that is the target of the event.',name:'destination.service.name',type:'keyword'},type:{category:'base',description:'The type of the transaction (for example, HTTP, MySQL, Redis, or RUM) or "flow" in case of flows. ',name:'type'},'server.process.name':{category:'server',description:'The name of the process that served the transaction. ',name:'server.process.name'},'server.process.args':{category:'server',description:'The command-line of the process that served the transaction. ',name:'server.process.args'},'server.process.executable':{category:'server',description:'Absolute path to the server process executable. ',name:'server.process.executable'},'server.process.working_directory':{category:'server',description:'The working directory of the server process. ',name:'server.process.working_directory'},'server.process.start':{category:'server',description:'The time the server process started. ',name:'server.process.start'},'client.process.name':{category:'client',description:'The name of the process that initiated the transaction. ',name:'client.process.name'},'client.process.args':{category:'client',description:'The command-line of the process that initiated the transaction. ',name:'client.process.args'},'client.process.executable':{category:'client',description:'Absolute path to the client process executable. ',name:'client.process.executable'},'client.process.working_directory':{category:'client',description:'The working directory of the client process. ',name:'client.process.working_directory'},'client.process.start':{category:'client',description:'The time the client process started. ',name:'client.process.start'},real_ip:{category:'base',description:'If the server initiating the transaction is a proxy, this field contains the original client IP address. For HTTP, for example, the IP address extracted from a configurable HTTP header, by default `X-Forwarded-For`. Unless this field is disabled, it always has a value, and it matches the `client_ip` for non proxy clients. ',name:'real_ip',type:'alias'},transport:{category:'base',description:'The transport protocol used for the transaction. If not specified, then tcp is assumed. ',name:'transport',type:'alias'},'flow.final':{category:'flow',description:'Indicates if event is last event in flow. If final is false, the event reports an intermediate flow state only. ',name:'flow.final',type:'boolean'},'flow.id':{category:'flow',description:'Internal flow ID based on connection meta data and address. ',name:'flow.id'},'flow.vlan':{category:'flow',description:"VLAN identifier from the 802.1q frame. In case of a multi-tagged frame this field will be an array with the outer tag's VLAN identifier listed first. ",name:'flow.vlan',type:'long'},flow_id:{category:'base',name:'flow_id',type:'alias'},final:{category:'base',name:'final',type:'alias'},vlan:{category:'base',name:'vlan',type:'alias'},'source.stats.net_bytes_total':{category:'source',name:'source.stats.net_bytes_total',type:'alias'},'source.stats.net_packets_total':{category:'source',name:'source.stats.net_packets_total',type:'alias'},'dest.stats.net_bytes_total':{category:'dest',name:'dest.stats.net_bytes_total',type:'alias'},'dest.stats.net_packets_total':{category:'dest',name:'dest.stats.net_packets_total',type:'alias'},status:{category:'base',description:'The high level status of the transaction. The way to compute this value depends on the protocol, but the result has a meaning independent of the protocol. ',name:'status'},method:{category:'base',description:'The command/verb/method of the transaction. For HTTP, this is the method name (GET, POST, PUT, and so on), for SQL this is the verb (SELECT, UPDATE, DELETE, and so on). ',name:'method'},resource:{category:'base',description:'The logical resource that this transaction refers to. For HTTP, this is the URL path up to the last slash (/). For example, if the URL is `/users/1`, the resource is `/users`. For databases, the resource is typically the table name. The field is not filled for all transaction types. ',name:'resource'},path:{category:'base',description:'The path the transaction refers to. For HTTP, this is the URL. For SQL databases, this is the table name. For key-value stores, this is the key. ',name:'path'},query:{category:'base',description:'The query in a human readable format. For HTTP, it will typically be something like `GET /users/_search?name=test`. For MySQL, it is something like `SELECT id from users where name=test`. ',name:'query',type:'keyword'},params:{category:'base',description:'The request parameters. For HTTP, these are the POST or GET parameters. For Thrift-RPC, these are the parameters from the request. ',name:'params',type:'text'},notes:{category:'base',description:'Messages from Packetbeat itself. This field usually contains error messages for interpreting the raw data. This information can be helpful for troubleshooting. ',name:'notes',type:'alias'},request:{category:'base',description:'For text protocols, this is the request as seen on the wire (application layer only). For binary protocols this is our representation of the request. ',name:'request',type:'text'},response:{category:'base',description:'For text protocols, this is the response as seen on the wire (application layer only). For binary protocols this is our representation of the request. ',name:'response',type:'text'},bytes_in:{category:'base',description:'The number of bytes of the request. Note that this size is the application layer message length, without the length of the IP or TCP headers. ',name:'bytes_in',type:'alias'},bytes_out:{category:'base',description:'The number of bytes of the response. Note that this size is the application layer message length, without the length of the IP or TCP headers. ',name:'bytes_out',type:'alias'},'amqp.reply-code':{category:'amqp',description:'AMQP reply code to an error, similar to http reply-code ',example:404,name:'amqp.reply-code',type:'long'},'amqp.reply-text':{category:'amqp',description:'Text explaining the error. ',name:'amqp.reply-text',type:'keyword'},'amqp.class-id':{category:'amqp',description:'Failing method class. ',name:'amqp.class-id',type:'long'},'amqp.method-id':{category:'amqp',description:'Failing method ID. ',name:'amqp.method-id',type:'long'},'amqp.exchange':{category:'amqp',description:'Name of the exchange. ',name:'amqp.exchange',type:'keyword'},'amqp.exchange-type':{category:'amqp',description:'Exchange type. ',example:'fanout',name:'amqp.exchange-type',type:'keyword'},'amqp.passive':{category:'amqp',description:'If set, do not create exchange/queue. ',name:'amqp.passive',type:'boolean'},'amqp.durable':{category:'amqp',description:'If set, request a durable exchange/queue. ',name:'amqp.durable',type:'boolean'},'amqp.exclusive':{category:'amqp',description:'If set, request an exclusive queue. ',name:'amqp.exclusive',type:'boolean'},'amqp.auto-delete':{category:'amqp',description:'If set, auto-delete queue when unused. ',name:'amqp.auto-delete',type:'boolean'},'amqp.no-wait':{category:'amqp',description:'If set, the server will not respond to the method. ',name:'amqp.no-wait',type:'boolean'},'amqp.consumer-tag':{category:'amqp',description:'Identifier for the consumer, valid within the current channel. ',name:'amqp.consumer-tag'},'amqp.delivery-tag':{category:'amqp',description:'The server-assigned and channel-specific delivery tag. ',name:'amqp.delivery-tag',type:'long'},'amqp.message-count':{category:'amqp',description:'The number of messages in the queue, which will be zero for newly-declared queues. ',name:'amqp.message-count',type:'long'},'amqp.consumer-count':{category:'amqp',description:'The number of consumers of a queue. ',name:'amqp.consumer-count',type:'long'},'amqp.routing-key':{category:'amqp',description:'Message routing key. ',name:'amqp.routing-key',type:'keyword'},'amqp.no-ack':{category:'amqp',description:'If set, the server does not expect acknowledgements for messages. ',name:'amqp.no-ack',type:'boolean'},'amqp.no-local':{category:'amqp',description:'If set, the server will not send messages to the connection that published them. ',name:'amqp.no-local',type:'boolean'},'amqp.if-unused':{category:'amqp',description:'Delete only if unused. ',name:'amqp.if-unused',type:'boolean'},'amqp.if-empty':{category:'amqp',description:'Delete only if empty. ',name:'amqp.if-empty',type:'boolean'},'amqp.queue':{category:'amqp',description:'The queue name identifies the queue within the vhost. ',name:'amqp.queue',type:'keyword'},'amqp.redelivered':{category:'amqp',description:'Indicates that the message has been previously delivered to this or another client. ',name:'amqp.redelivered',type:'boolean'},'amqp.multiple':{category:'amqp',description:'Acknowledge multiple messages. ',name:'amqp.multiple',type:'boolean'},'amqp.arguments':{category:'amqp',description:'Optional additional arguments passed to some methods. Can be of various types. ',name:'amqp.arguments',type:'object'},'amqp.mandatory':{category:'amqp',description:'Indicates mandatory routing. ',name:'amqp.mandatory',type:'boolean'},'amqp.immediate':{category:'amqp',description:'Request immediate delivery. ',name:'amqp.immediate',type:'boolean'},'amqp.content-type':{category:'amqp',description:'MIME content type. ',example:'text/plain',name:'amqp.content-type',type:'keyword'},'amqp.content-encoding':{category:'amqp',description:'MIME content encoding. ',name:'amqp.content-encoding',type:'keyword'},'amqp.headers':{category:'amqp',description:'Message header field table. ',name:'amqp.headers',type:'object'},'amqp.delivery-mode':{category:'amqp',description:'Non-persistent (1) or persistent (2). ',name:'amqp.delivery-mode',type:'keyword'},'amqp.priority':{category:'amqp',description:'Message priority, 0 to 9. ',name:'amqp.priority',type:'long'},'amqp.correlation-id':{category:'amqp',description:'Application correlation identifier. ',name:'amqp.correlation-id',type:'keyword'},'amqp.reply-to':{category:'amqp',description:'Address to reply to. ',name:'amqp.reply-to',type:'keyword'},'amqp.expiration':{category:'amqp',description:'Message expiration specification. ',name:'amqp.expiration',type:'keyword'},'amqp.message-id':{category:'amqp',description:'Application message identifier. ',name:'amqp.message-id',type:'keyword'},'amqp.timestamp':{category:'amqp',description:'Message timestamp. ',name:'amqp.timestamp',type:'keyword'},'amqp.type':{category:'amqp',description:'Message type name. ',name:'amqp.type',type:'keyword'},'amqp.user-id':{category:'amqp',description:'Creating user id. ',name:'amqp.user-id',type:'keyword'},'amqp.app-id':{category:'amqp',description:'Creating application id. ',name:'amqp.app-id',type:'keyword'},no_request:{category:'base',name:'no_request',type:'alias'},'cassandra.no_request':{category:'cassandra',description:'Indicates that there is no request because this is a PUSH message. ',name:'cassandra.no_request',type:'boolean'},'cassandra.request.headers.version':{category:'cassandra',description:'The version of the protocol.',name:'cassandra.request.headers.version',type:'long'},'cassandra.request.headers.flags':{category:'cassandra',description:'Flags applying to this frame.',name:'cassandra.request.headers.flags',type:'keyword'},'cassandra.request.headers.stream':{category:'cassandra',description:'A frame has a stream id.  If a client sends a request message with the stream id X, it is guaranteed that the stream id of the response to that message will be X.',name:'cassandra.request.headers.stream',type:'keyword'},'cassandra.request.headers.op':{category:'cassandra',description:'An operation type that distinguishes the actual message.',name:'cassandra.request.headers.op',type:'keyword'},'cassandra.request.headers.length':{category:'cassandra',description:'A integer representing the length of the body of the frame (a frame is limited to 256MB in length).',name:'cassandra.request.headers.length',type:'long'},'cassandra.request.query':{category:'cassandra',description:'The CQL query which client send to cassandra.',name:'cassandra.request.query',type:'keyword'},'cassandra.response.headers.version':{category:'cassandra',description:'The version of the protocol.',name:'cassandra.response.headers.version',type:'long'},'cassandra.response.headers.flags':{category:'cassandra',description:'Flags applying to this frame.',name:'cassandra.response.headers.flags',type:'keyword'},'cassandra.response.headers.stream':{category:'cassandra',description:'A frame has a stream id.  If a client sends a request message with the stream id X, it is guaranteed that the stream id of the response to that message will be X.',name:'cassandra.response.headers.stream',type:'keyword'},'cassandra.response.headers.op':{category:'cassandra',description:'An operation type that distinguishes the actual message.',name:'cassandra.response.headers.op',type:'keyword'},'cassandra.response.headers.length':{category:'cassandra',description:'A integer representing the length of the body of the frame (a frame is limited to 256MB in length).',name:'cassandra.response.headers.length',type:'long'},'cassandra.response.result.type':{category:'cassandra',description:'Cassandra result type.',name:'cassandra.response.result.type',type:'keyword'},'cassandra.response.result.rows.num_rows':{category:'cassandra',description:'Representing the number of rows present in this result.',name:'cassandra.response.result.rows.num_rows',type:'long'},'cassandra.response.result.rows.meta.keyspace':{category:'cassandra',description:'Only present after set Global_tables_spec, the keyspace name.',name:'cassandra.response.result.rows.meta.keyspace',type:'keyword'},'cassandra.response.result.rows.meta.table':{category:'cassandra',description:'Only present after set Global_tables_spec, the table name.',name:'cassandra.response.result.rows.meta.table',type:'keyword'},'cassandra.response.result.rows.meta.flags':{category:'cassandra',description:'Provides information on the formatting of the remaining information.',name:'cassandra.response.result.rows.meta.flags',type:'keyword'},'cassandra.response.result.rows.meta.col_count':{category:'cassandra',description:'Representing the number of columns selected by the query that produced this result.',name:'cassandra.response.result.rows.meta.col_count',type:'long'},'cassandra.response.result.rows.meta.pkey_columns':{category:'cassandra',description:'Representing the PK columns index and counts.',name:'cassandra.response.result.rows.meta.pkey_columns',type:'long'},'cassandra.response.result.rows.meta.paging_state':{category:'cassandra',description:'The paging_state is a bytes value that should be used in QUERY/EXECUTE to continue paging and retrieve the remainder of the result for this query.',name:'cassandra.response.result.rows.meta.paging_state',type:'keyword'},'cassandra.response.result.keyspace':{category:'cassandra',description:'Indicating the name of the keyspace that has been set.',name:'cassandra.response.result.keyspace',type:'keyword'},'cassandra.response.result.schema_change.change':{category:'cassandra',description:'Representing the type of changed involved.',name:'cassandra.response.result.schema_change.change',type:'keyword'},'cassandra.response.result.schema_change.keyspace':{category:'cassandra',description:'This describes which keyspace has changed.',name:'cassandra.response.result.schema_change.keyspace',type:'keyword'},'cassandra.response.result.schema_change.table':{category:'cassandra',description:'This describes which table has changed.',name:'cassandra.response.result.schema_change.table',type:'keyword'},'cassandra.response.result.schema_change.object':{category:'cassandra',description:'This describes the name of said affected object (either the table, user type, function, or aggregate name).',name:'cassandra.response.result.schema_change.object',type:'keyword'},'cassandra.response.result.schema_change.target':{category:'cassandra',description:'Target could be "FUNCTION" or "AGGREGATE", multiple arguments.',name:'cassandra.response.result.schema_change.target',type:'keyword'},'cassandra.response.result.schema_change.name':{category:'cassandra',description:'The function/aggregate name.',name:'cassandra.response.result.schema_change.name',type:'keyword'},'cassandra.response.result.schema_change.args':{category:'cassandra',description:'One string for each argument type (as CQL type).',name:'cassandra.response.result.schema_change.args',type:'keyword'},'cassandra.response.result.prepared.prepared_id':{category:'cassandra',description:'Representing the prepared query ID.',name:'cassandra.response.result.prepared.prepared_id',type:'keyword'},'cassandra.response.result.prepared.req_meta.keyspace':{category:'cassandra',description:'Only present after set Global_tables_spec, the keyspace name.',name:'cassandra.response.result.prepared.req_meta.keyspace',type:'keyword'},'cassandra.response.result.prepared.req_meta.table':{category:'cassandra',description:'Only present after set Global_tables_spec, the table name.',name:'cassandra.response.result.prepared.req_meta.table',type:'keyword'},'cassandra.response.result.prepared.req_meta.flags':{category:'cassandra',description:'Provides information on the formatting of the remaining information.',name:'cassandra.response.result.prepared.req_meta.flags',type:'keyword'},'cassandra.response.result.prepared.req_meta.col_count':{category:'cassandra',description:'Representing the number of columns selected by the query that produced this result.',name:'cassandra.response.result.prepared.req_meta.col_count',type:'long'},'cassandra.response.result.prepared.req_meta.pkey_columns':{category:'cassandra',description:'Representing the PK columns index and counts.',name:'cassandra.response.result.prepared.req_meta.pkey_columns',type:'long'},'cassandra.response.result.prepared.req_meta.paging_state':{category:'cassandra',description:'The paging_state is a bytes value that should be used in QUERY/EXECUTE to continue paging and retrieve the remainder of the result for this query.',name:'cassandra.response.result.prepared.req_meta.paging_state',type:'keyword'},'cassandra.response.result.prepared.resp_meta.keyspace':{category:'cassandra',description:'Only present after set Global_tables_spec, the keyspace name.',name:'cassandra.response.result.prepared.resp_meta.keyspace',type:'keyword'},'cassandra.response.result.prepared.resp_meta.table':{category:'cassandra',description:'Only present after set Global_tables_spec, the table name.',name:'cassandra.response.result.prepared.resp_meta.table',type:'keyword'},'cassandra.response.result.prepared.resp_meta.flags':{category:'cassandra',description:'Provides information on the formatting of the remaining information.',name:'cassandra.response.result.prepared.resp_meta.flags',type:'keyword'},'cassandra.response.result.prepared.resp_meta.col_count':{category:'cassandra',description:'Representing the number of columns selected by the query that produced this result.',name:'cassandra.response.result.prepared.resp_meta.col_count',type:'long'},'cassandra.response.result.prepared.resp_meta.pkey_columns':{category:'cassandra',description:'Representing the PK columns index and counts.',name:'cassandra.response.result.prepared.resp_meta.pkey_columns',type:'long'},'cassandra.response.result.prepared.resp_meta.paging_state':{category:'cassandra',description:'The paging_state is a bytes value that should be used in QUERY/EXECUTE to continue paging and retrieve the remainder of the result for this query.',name:'cassandra.response.result.prepared.resp_meta.paging_state',type:'keyword'},'cassandra.response.supported':{category:'cassandra',description:'Indicates which startup options are supported by the server. This message comes as a response to an OPTIONS message.',name:'cassandra.response.supported',type:'object'},'cassandra.response.authentication.class':{category:'cassandra',description:'Indicates the full class name of the IAuthenticator in use',name:'cassandra.response.authentication.class',type:'keyword'},'cassandra.response.warnings':{category:'cassandra',description:'The text of the warnings, only occur when Warning flag was set.',name:'cassandra.response.warnings',type:'keyword'},'cassandra.response.event.type':{category:'cassandra',description:'Representing the event type.',name:'cassandra.response.event.type',type:'keyword'},'cassandra.response.event.change':{category:'cassandra',description:'The message corresponding respectively to the type of change followed by the address of the new/removed node.',name:'cassandra.response.event.change',type:'keyword'},'cassandra.response.event.host':{category:'cassandra',description:'Representing the node ip.',name:'cassandra.response.event.host',type:'keyword'},'cassandra.response.event.port':{category:'cassandra',description:'Representing the node port.',name:'cassandra.response.event.port',type:'long'},'cassandra.response.event.schema_change.change':{category:'cassandra',description:'Representing the type of changed involved.',name:'cassandra.response.event.schema_change.change',type:'keyword'},'cassandra.response.event.schema_change.keyspace':{category:'cassandra',description:'This describes which keyspace has changed.',name:'cassandra.response.event.schema_change.keyspace',type:'keyword'},'cassandra.response.event.schema_change.table':{category:'cassandra',description:'This describes which table has changed.',name:'cassandra.response.event.schema_change.table',type:'keyword'},'cassandra.response.event.schema_change.object':{category:'cassandra',description:'This describes the name of said affected object (either the table, user type, function, or aggregate name).',name:'cassandra.response.event.schema_change.object',type:'keyword'},'cassandra.response.event.schema_change.target':{category:'cassandra',description:'Target could be "FUNCTION" or "AGGREGATE", multiple arguments.',name:'cassandra.response.event.schema_change.target',type:'keyword'},'cassandra.response.event.schema_change.name':{category:'cassandra',description:'The function/aggregate name.',name:'cassandra.response.event.schema_change.name',type:'keyword'},'cassandra.response.event.schema_change.args':{category:'cassandra',description:'One string for each argument type (as CQL type).',name:'cassandra.response.event.schema_change.args',type:'keyword'},'cassandra.response.error.code':{category:'cassandra',description:'The error code of the Cassandra response.',name:'cassandra.response.error.code',type:'long'},'cassandra.response.error.msg':{category:'cassandra',description:'The error message of the Cassandra response.',name:'cassandra.response.error.msg',type:'keyword'},'cassandra.response.error.type':{category:'cassandra',description:'The error type of the Cassandra response.',name:'cassandra.response.error.type',type:'keyword'},'cassandra.response.error.details.read_consistency':{category:'cassandra',description:'Representing the consistency level of the query that triggered the exception.',name:'cassandra.response.error.details.read_consistency',type:'keyword'},'cassandra.response.error.details.required':{category:'cassandra',description:'Representing the number of nodes that should be alive to respect consistency level.',name:'cassandra.response.error.details.required',type:'long'},'cassandra.response.error.details.alive':{category:'cassandra',description:'Representing the number of replicas that were known to be alive when the request had been processed (since an unavailable exception has been triggered).',name:'cassandra.response.error.details.alive',type:'long'},'cassandra.response.error.details.received':{category:'cassandra',description:'Representing the number of nodes having acknowledged the request.',name:'cassandra.response.error.details.received',type:'long'},'cassandra.response.error.details.blockfor':{category:'cassandra',description:'Representing the number of replicas whose acknowledgement is required to achieve consistency level.',name:'cassandra.response.error.details.blockfor',type:'long'},'cassandra.response.error.details.write_type':{category:'cassandra',description:'Describe the type of the write that timed out.',name:'cassandra.response.error.details.write_type',type:'keyword'},'cassandra.response.error.details.data_present':{category:'cassandra',description:'It means the replica that was asked for data had responded.',name:'cassandra.response.error.details.data_present',type:'boolean'},'cassandra.response.error.details.keyspace':{category:'cassandra',description:'The keyspace of the failed function.',name:'cassandra.response.error.details.keyspace',type:'keyword'},'cassandra.response.error.details.table':{category:'cassandra',description:'The keyspace of the failed function.',name:'cassandra.response.error.details.table',type:'keyword'},'cassandra.response.error.details.stmt_id':{category:'cassandra',description:'Representing the unknown ID.',name:'cassandra.response.error.details.stmt_id',type:'keyword'},'cassandra.response.error.details.num_failures':{category:'cassandra',description:'Representing the number of nodes that experience a failure while executing the request.',name:'cassandra.response.error.details.num_failures',type:'keyword'},'cassandra.response.error.details.function':{category:'cassandra',description:'The name of the failed function.',name:'cassandra.response.error.details.function',type:'keyword'},'cassandra.response.error.details.arg_types':{category:'cassandra',description:'One string for each argument type (as CQL type) of the failed function.',name:'cassandra.response.error.details.arg_types',type:'keyword'},'dhcpv4.transaction_id':{category:'dhcpv4',description:'Transaction ID, a random number chosen by the client, used by the client and server to associate messages and responses between a client and a server. ',name:'dhcpv4.transaction_id',type:'keyword'},'dhcpv4.seconds':{category:'dhcpv4',description:'Number of seconds elapsed since client began address acquisition or renewal process. ',name:'dhcpv4.seconds',type:'long'},'dhcpv4.flags':{category:'dhcpv4',description:'Flags are set by the client to indicate how the DHCP server should its reply -- either unicast or broadcast. ',name:'dhcpv4.flags',type:'keyword'},'dhcpv4.client_ip':{category:'dhcpv4',description:'The current IP address of the client.',name:'dhcpv4.client_ip',type:'ip'},'dhcpv4.assigned_ip':{category:'dhcpv4',description:'The IP address that the DHCP server is assigning to the client. This field is also known as "your" IP address. ',name:'dhcpv4.assigned_ip',type:'ip'},'dhcpv4.server_ip':{category:'dhcpv4',description:'The IP address of the DHCP server that the client should use for the next step in the bootstrap process. ',name:'dhcpv4.server_ip',type:'ip'},'dhcpv4.relay_ip':{category:'dhcpv4',description:'The relay IP address used by the client to contact the server (i.e. a DHCP relay server). ',name:'dhcpv4.relay_ip',type:'ip'},'dhcpv4.client_mac':{category:'dhcpv4',description:"The client's MAC address (layer two).",name:'dhcpv4.client_mac',type:'keyword'},'dhcpv4.server_name':{category:'dhcpv4',description:'The name of the server sending the message. Optional. Used in DHCPOFFER or DHCPACK messages. ',name:'dhcpv4.server_name',type:'keyword'},'dhcpv4.op_code':{category:'dhcpv4',description:'The message op code (bootrequest or bootreply). ',example:'bootreply',name:'dhcpv4.op_code',type:'keyword'},'dhcpv4.hops':{category:'dhcpv4',description:'The number of hops the DHCP message went through.',name:'dhcpv4.hops',type:'long'},'dhcpv4.hardware_type':{category:'dhcpv4',description:'The type of hardware used for the local network (Ethernet, LocalTalk, etc). ',name:'dhcpv4.hardware_type',type:'keyword'},'dhcpv4.option.message_type':{category:'dhcpv4',description:'The specific type of DHCP message being sent (e.g. discover, offer, request, decline, ack, nak, release, inform). ',example:'ack',name:'dhcpv4.option.message_type',type:'keyword'},'dhcpv4.option.parameter_request_list':{category:'dhcpv4',description:'This option is used by a DHCP client to request values for specified configuration parameters. ',name:'dhcpv4.option.parameter_request_list',type:'keyword'},'dhcpv4.option.requested_ip_address':{category:'dhcpv4',description:'This option is used in a client request (DHCPDISCOVER) to allow the client to request that a particular IP address be assigned. ',name:'dhcpv4.option.requested_ip_address',type:'ip'},'dhcpv4.option.server_identifier':{category:'dhcpv4',description:'IP address of the individual DHCP server which handled this message. ',name:'dhcpv4.option.server_identifier',type:'ip'},'dhcpv4.option.broadcast_address':{category:'dhcpv4',description:"This option specifies the broadcast address in use on the client's subnet. ",name:'dhcpv4.option.broadcast_address',type:'ip'},'dhcpv4.option.max_dhcp_message_size':{category:'dhcpv4',description:'This option specifies the maximum length DHCP message that the client is willing to accept. ',name:'dhcpv4.option.max_dhcp_message_size',type:'long'},'dhcpv4.option.class_identifier':{category:'dhcpv4',description:"This option is used by DHCP clients to optionally identify the vendor type and configuration of a DHCP client. Vendors may choose to define specific vendor class identifiers to convey particular configuration or other identification information about a client.  For example, the identifier may encode the client's hardware configuration. ",name:'dhcpv4.option.class_identifier',type:'keyword'},'dhcpv4.option.domain_name':{category:'dhcpv4',description:'This option specifies the domain name that client should use when resolving hostnames via the Domain Name System. ',name:'dhcpv4.option.domain_name',type:'keyword'},'dhcpv4.option.dns_servers':{category:'dhcpv4',description:'The domain name server option specifies a list of Domain Name System servers available to the client. ',name:'dhcpv4.option.dns_servers',type:'ip'},'dhcpv4.option.vendor_identifying_options':{category:'dhcpv4',description:'A DHCP client may use this option to unambiguously identify the vendor that manufactured the hardware on which the client is running, the software in use, or an industry consortium to which the vendor belongs. This field is described in RFC 3925. ',name:'dhcpv4.option.vendor_identifying_options',type:'object'},'dhcpv4.option.subnet_mask':{category:'dhcpv4',description:'The subnet mask that the client should use on the currnet network. ',name:'dhcpv4.option.subnet_mask',type:'ip'},'dhcpv4.option.utc_time_offset_sec':{category:'dhcpv4',description:"The time offset field specifies the offset of the client's subnet in seconds from Coordinated Universal Time (UTC). ",name:'dhcpv4.option.utc_time_offset_sec',type:'long'},'dhcpv4.option.router':{category:'dhcpv4',description:"The router option specifies a list of IP addresses for routers on the client's subnet. ",name:'dhcpv4.option.router',type:'ip'},'dhcpv4.option.time_servers':{category:'dhcpv4',description:'The time server option specifies a list of RFC 868 time servers available to the client. ',name:'dhcpv4.option.time_servers',type:'ip'},'dhcpv4.option.ntp_servers':{category:'dhcpv4',description:'This option specifies a list of IP addresses indicating NTP servers available to the client. ',name:'dhcpv4.option.ntp_servers',type:'ip'},'dhcpv4.option.hostname':{category:'dhcpv4',description:'This option specifies the name of the client. ',name:'dhcpv4.option.hostname',type:'keyword'},'dhcpv4.option.ip_address_lease_time_sec':{category:'dhcpv4',description:'This option is used in a client request (DHCPDISCOVER or DHCPREQUEST) to allow the client to request a lease time for the IP address.  In a server reply (DHCPOFFER), a DHCP server uses this option to specify the lease time it is willing to offer. ',name:'dhcpv4.option.ip_address_lease_time_sec',type:'long'},'dhcpv4.option.message':{category:'dhcpv4',description:'This option is used by a DHCP server to provide an error message to a DHCP client in a DHCPNAK message in the event of a failure. A client may use this option in a DHCPDECLINE message to indicate the why the client declined the offered parameters. ',name:'dhcpv4.option.message',type:'text'},'dhcpv4.option.renewal_time_sec':{category:'dhcpv4',description:'This option specifies the time interval from address assignment until the client transitions to the RENEWING state. ',name:'dhcpv4.option.renewal_time_sec',type:'long'},'dhcpv4.option.rebinding_time_sec':{category:'dhcpv4',description:'This option specifies the time interval from address assignment until the client transitions to the REBINDING state. ',name:'dhcpv4.option.rebinding_time_sec',type:'long'},'dhcpv4.option.boot_file_name':{category:'dhcpv4',description:"This option is used to identify a bootfile when the 'file' field in the DHCP header has been used for DHCP options. ",name:'dhcpv4.option.boot_file_name',type:'keyword'},'dns.flags.authoritative':{category:'dns',description:'A DNS flag specifying that the responding server is an authority for the domain name used in the question. ',name:'dns.flags.authoritative',type:'boolean'},'dns.flags.recursion_available':{category:'dns',description:'A DNS flag specifying whether recursive query support is available in the name server. ',name:'dns.flags.recursion_available',type:'boolean'},'dns.flags.recursion_desired':{category:'dns',description:'A DNS flag specifying that the client directs the server to pursue a query recursively. Recursive query support is optional. ',name:'dns.flags.recursion_desired',type:'boolean'},'dns.flags.authentic_data':{category:'dns',description:'A DNS flag specifying that the recursive server considers the response authentic. ',name:'dns.flags.authentic_data',type:'boolean'},'dns.flags.checking_disabled':{category:'dns',description:'A DNS flag specifying that the client disables the server signature validation of the query. ',name:'dns.flags.checking_disabled',type:'boolean'},'dns.flags.truncated_response':{category:'dns',description:'A DNS flag specifying that only the first 512 bytes of the reply were returned. ',name:'dns.flags.truncated_response',type:'boolean'},'dns.question.etld_plus_one':{category:'dns',description:'The effective top-level domain (eTLD) plus one more label. For example, the eTLD+1 for "foo.bar.golang.org." is "golang.org.". The data for determining the eTLD comes from an embedded copy of the data from http://publicsuffix.org.',example:'amazon.co.uk.',name:'dns.question.etld_plus_one'},'dns.answers_count':{category:'dns',description:'The number of resource records contained in the `dns.answers` field. ',name:'dns.answers_count',type:'long'},'dns.authorities':{category:'dns',description:'An array containing a dictionary for each authority section from the answer. ',name:'dns.authorities',type:'object'},'dns.authorities_count':{category:'dns',description:'The number of resource records contained in the `dns.authorities` field. The `dns.authorities` field may or may not be included depending on the configuration of Packetbeat. ',name:'dns.authorities_count',type:'long'},'dns.authorities.name':{category:'dns',description:'The domain name to which this resource record pertains.',example:'example.com.',name:'dns.authorities.name'},'dns.authorities.type':{category:'dns',description:'The type of data contained in this resource record.',example:'NS',name:'dns.authorities.type'},'dns.authorities.class':{category:'dns',description:'The class of DNS data contained in this resource record.',example:'IN',name:'dns.authorities.class'},'dns.additionals':{category:'dns',description:'An array containing a dictionary for each additional section from the answer. ',name:'dns.additionals',type:'object'},'dns.additionals_count':{category:'dns',description:'The number of resource records contained in the `dns.additionals` field. The `dns.additionals` field may or may not be included depending on the configuration of Packetbeat. ',name:'dns.additionals_count',type:'long'},'dns.additionals.name':{category:'dns',description:'The domain name to which this resource record pertains.',example:'example.com.',name:'dns.additionals.name'},'dns.additionals.type':{category:'dns',description:'The type of data contained in this resource record.',example:'NS',name:'dns.additionals.type'},'dns.additionals.class':{category:'dns',description:'The class of DNS data contained in this resource record.',example:'IN',name:'dns.additionals.class'},'dns.additionals.ttl':{category:'dns',description:'The time interval in seconds that this resource record may be cached before it should be discarded. Zero values mean that the data should not be cached. ',name:'dns.additionals.ttl',type:'long'},'dns.additionals.data':{category:'dns',description:'The data describing the resource. The meaning of this data depends on the type and class of the resource record. ',name:'dns.additionals.data'},'dns.opt.version':{category:'dns',description:'The EDNS version.',example:'0',name:'dns.opt.version'},'dns.opt.do':{category:'dns',description:'If set, the transaction uses DNSSEC.',name:'dns.opt.do',type:'boolean'},'dns.opt.ext_rcode':{category:'dns',description:'Extended response code field.',example:'BADVERS',name:'dns.opt.ext_rcode'},'dns.opt.udp_size':{category:'dns',description:"Requestor's UDP payload size (in bytes).",name:'dns.opt.udp_size',type:'long'},'http.request.headers':{category:'http',description:'A map containing the captured header fields from the request. Which headers to capture is configurable. If headers with the same header name are present in the message, they will be separated by commas. ',name:'http.request.headers',type:'object'},'http.request.params':{category:'http',name:'http.request.params',type:'alias'},'http.response.status_phrase':{category:'http',description:'The HTTP status phrase.',example:'Not Found',name:'http.response.status_phrase'},'http.response.headers':{category:'http',description:'A map containing the captured header fields from the response. Which headers to capture is configurable. If headers with the same header name are present in the message, they will be separated by commas. ',name:'http.response.headers',type:'object'},'http.response.code':{category:'http',name:'http.response.code',type:'alias'},'http.response.phrase':{category:'http',name:'http.response.phrase',type:'alias'},'icmp.version':{category:'icmp',description:'The version of the ICMP protocol.',name:'icmp.version'},'icmp.request.message':{category:'icmp',description:'A human readable form of the request.',name:'icmp.request.message',type:'keyword'},'icmp.request.type':{category:'icmp',description:'The request type.',name:'icmp.request.type',type:'long'},'icmp.request.code':{category:'icmp',description:'The request code.',name:'icmp.request.code',type:'long'},'icmp.response.message':{category:'icmp',description:'A human readable form of the response.',name:'icmp.response.message',type:'keyword'},'icmp.response.type':{category:'icmp',description:'The response type.',name:'icmp.response.type',type:'long'},'icmp.response.code':{category:'icmp',description:'The response code.',name:'icmp.response.code',type:'long'},'memcache.protocol_type':{category:'memcache',description:'The memcache protocol implementation. The value can be "binary" for binary-based, "text" for text-based, or "unknown" for an unknown memcache protocol type. ',name:'memcache.protocol_type',type:'keyword'},'memcache.request.line':{category:'memcache',description:'The raw command line for unknown commands ONLY. ',name:'memcache.request.line',type:'keyword'},'memcache.request.command':{category:'memcache',description:'The memcache command being requested in the memcache text protocol. For example "set" or "get". The binary protocol opcodes are translated into memcache text protocol commands. ',name:'memcache.request.command',type:'keyword'},'memcache.response.command':{category:'memcache',description:'Either the text based protocol response message type or the name of the originating request if binary protocol is used. ',name:'memcache.response.command',type:'keyword'},'memcache.request.type':{category:'memcache',description:'The memcache command classification. This value can be "UNKNOWN", "Load", "Store", "Delete", "Counter", "Info", "SlabCtrl", "LRUCrawler", "Stats", "Success", "Fail", or "Auth". ',name:'memcache.request.type',type:'keyword'},'memcache.response.type':{category:'memcache',description:'The memcache command classification. This value can be "UNKNOWN", "Load", "Store", "Delete", "Counter", "Info", "SlabCtrl", "LRUCrawler", "Stats", "Success", "Fail", or "Auth". The text based protocol will employ any of these, whereas the binary based protocol will mirror the request commands only (see `memcache.response.status` for binary protocol). ',name:'memcache.response.type',type:'keyword'},'memcache.response.error_msg':{category:'memcache',description:'The optional error message in the memcache response (text based protocol only). ',name:'memcache.response.error_msg',type:'keyword'},'memcache.request.opcode':{category:'memcache',description:'The binary protocol message opcode name. ',name:'memcache.request.opcode',type:'keyword'},'memcache.response.opcode':{category:'memcache',description:'The binary protocol message opcode name. ',name:'memcache.response.opcode',type:'keyword'},'memcache.request.opcode_value':{category:'memcache',description:'The binary protocol message opcode value. ',name:'memcache.request.opcode_value',type:'long'},'memcache.response.opcode_value':{category:'memcache',description:'The binary protocol message opcode value. ',name:'memcache.response.opcode_value',type:'long'},'memcache.request.opaque':{category:'memcache',description:'The binary protocol opaque header value used for correlating request with response messages. ',name:'memcache.request.opaque',type:'long'},'memcache.response.opaque':{category:'memcache',description:'The binary protocol opaque header value used for correlating request with response messages. ',name:'memcache.response.opaque',type:'long'},'memcache.request.vbucket':{category:'memcache',description:'The vbucket index sent in the binary message. ',name:'memcache.request.vbucket',type:'long'},'memcache.response.status':{category:'memcache',description:'The textual representation of the response error code (binary protocol only). ',name:'memcache.response.status',type:'keyword'},'memcache.response.status_code':{category:'memcache',description:'The status code value returned in the response (binary protocol only). ',name:'memcache.response.status_code',type:'long'},'memcache.request.keys':{category:'memcache',description:'The list of keys sent in the store or load commands. ',name:'memcache.request.keys',type:'array'},'memcache.response.keys':{category:'memcache',description:'The list of keys returned for the load command (if present). ',name:'memcache.response.keys',type:'array'},'memcache.request.count_values':{category:'memcache',description:'The number of values found in the memcache request message. If the command does not send any data, this field is missing. ',name:'memcache.request.count_values',type:'long'},'memcache.response.count_values':{category:'memcache',description:'The number of values found in the memcache response message. If the command does not send any data, this field is missing. ',name:'memcache.response.count_values',type:'long'},'memcache.request.values':{category:'memcache',description:'The list of base64 encoded values sent with the request (if present). ',name:'memcache.request.values',type:'array'},'memcache.response.values':{category:'memcache',description:'The list of base64 encoded values sent with the response (if present). ',name:'memcache.response.values',type:'array'},'memcache.request.bytes':{category:'memcache',description:'The byte count of the values being transferred. ',name:'memcache.request.bytes',type:'long',format:'bytes'},'memcache.response.bytes':{category:'memcache',description:'The byte count of the values being transferred. ',name:'memcache.response.bytes',type:'long',format:'bytes'},'memcache.request.delta':{category:'memcache',description:'The counter increment/decrement delta value. ',name:'memcache.request.delta',type:'long'},'memcache.request.initial':{category:'memcache',description:'The counter increment/decrement initial value parameter (binary protocol only). ',name:'memcache.request.initial',type:'long'},'memcache.request.verbosity':{category:'memcache',description:'The value of the memcache "verbosity" command. ',name:'memcache.request.verbosity',type:'long'},'memcache.request.raw_args':{category:'memcache',description:'The text protocol raw arguments for the "stats ..." and "lru crawl ..." commands. ',name:'memcache.request.raw_args',type:'keyword'},'memcache.request.source_class':{category:'memcache',description:"The source class id in 'slab reassign' command. ",name:'memcache.request.source_class',type:'long'},'memcache.request.dest_class':{category:'memcache',description:"The destination class id in 'slab reassign' command. ",name:'memcache.request.dest_class',type:'long'},'memcache.request.automove':{category:'memcache',description:'The automove mode in the \'slab automove\' command expressed as a string. This value can be "standby"(=0), "slow"(=1), "aggressive"(=2), or the raw value if the value is unknown. ',name:'memcache.request.automove',type:'keyword'},'memcache.request.flags':{category:'memcache',description:'The memcache command flags sent in the request (if present). ',name:'memcache.request.flags',type:'long'},'memcache.response.flags':{category:'memcache',description:'The memcache message flags sent in the response (if present). ',name:'memcache.response.flags',type:'long'},'memcache.request.exptime':{category:'memcache',description:'The data expiry time in seconds sent with the memcache command (if present). If the value is <30 days, the expiry time is relative to "now", or else it is an absolute Unix time in seconds (32-bit). ',name:'memcache.request.exptime',type:'long'},'memcache.request.sleep_us':{category:'memcache',description:"The sleep setting in microseconds for the 'lru_crawler sleep' command. ",name:'memcache.request.sleep_us',type:'long'},'memcache.response.value':{category:'memcache',description:'The counter value returned by a counter operation. ',name:'memcache.response.value',type:'long'},'memcache.request.noreply':{category:'memcache',description:'Set to true if noreply was set in the request. The `memcache.response` field will be missing. ',name:'memcache.request.noreply',type:'boolean'},'memcache.request.quiet':{category:'memcache',description:'Set to true if the binary protocol message is to be treated as a quiet message. ',name:'memcache.request.quiet',type:'boolean'},'memcache.request.cas_unique':{category:'memcache',description:'The CAS (compare-and-swap) identifier if present. ',name:'memcache.request.cas_unique',type:'long'},'memcache.response.cas_unique':{category:'memcache',description:'The CAS (compare-and-swap) identifier to be used with CAS-based updates (if present). ',name:'memcache.response.cas_unique',type:'long'},'memcache.response.stats':{category:'memcache',description:'The list of statistic values returned. Each entry is a dictionary with the fields "name" and "value". ',name:'memcache.response.stats',type:'array'},'memcache.response.version':{category:'memcache',description:'The returned memcache version string. ',name:'memcache.response.version',type:'keyword'},'mongodb.error':{category:'mongodb',description:'If the MongoDB request has resulted in an error, this field contains the error message returned by the server. ',name:'mongodb.error'},'mongodb.fullCollectionName':{category:'mongodb',description:'The full collection name. The full collection name is the concatenation of the database name with the collection name, using a dot (.) for the concatenation. For example, for the database foo and the collection bar, the full collection name is foo.bar. ',name:'mongodb.fullCollectionName'},'mongodb.numberToSkip':{category:'mongodb',description:'Sets the number of documents to omit - starting from the first document in the resulting dataset - when returning the result of the query. ',name:'mongodb.numberToSkip',type:'long'},'mongodb.numberToReturn':{category:'mongodb',description:'The requested maximum number of documents to be returned. ',name:'mongodb.numberToReturn',type:'long'},'mongodb.numberReturned':{category:'mongodb',description:'The number of documents in the reply. ',name:'mongodb.numberReturned',type:'long'},'mongodb.startingFrom':{category:'mongodb',description:'Where in the cursor this reply is starting. ',name:'mongodb.startingFrom'},'mongodb.query':{category:'mongodb',description:'A JSON document that represents the query. The query will contain one or more elements, all of which must match for a document to be included in the result set. Possible elements include $query, $orderby, $hint, $explain, and $snapshot. ',name:'mongodb.query'},'mongodb.returnFieldsSelector':{category:'mongodb',description:'A JSON document that limits the fields in the returned documents. The returnFieldsSelector contains one or more elements, each of which is the name of a field that should be returned, and the integer value 1. ',name:'mongodb.returnFieldsSelector'},'mongodb.selector':{category:'mongodb',description:'A BSON document that specifies the query for selecting the document to update or delete. ',name:'mongodb.selector'},'mongodb.update':{category:'mongodb',description:'A BSON document that specifies the update to be performed. For information on specifying updates, see the Update Operations documentation from the MongoDB Manual. ',name:'mongodb.update'},'mongodb.cursorId':{category:'mongodb',description:'The cursor identifier returned in the OP_REPLY. This must be the value that was returned from the database. ',name:'mongodb.cursorId'},'mysql.affected_rows':{category:'mysql',description:'If the MySQL command is successful, this field contains the affected number of rows of the last statement. ',name:'mysql.affected_rows',type:'long'},'mysql.insert_id':{category:'mysql',description:'If the INSERT query is successful, this field contains the id of the newly inserted row. ',name:'mysql.insert_id'},'mysql.num_fields':{category:'mysql',description:'If the SELECT query is successful, this field is set to the number of fields returned. ',name:'mysql.num_fields'},'mysql.num_rows':{category:'mysql',description:'If the SELECT query is successful, this field is set to the number of rows returned. ',name:'mysql.num_rows'},'mysql.query':{category:'mysql',description:"The row mysql query as read from the transaction's request. ",name:'mysql.query'},'mysql.error_code':{category:'mysql',description:'The error code returned by MySQL. ',name:'mysql.error_code',type:'long'},'mysql.error_message':{category:'mysql',description:'The error info message returned by MySQL. ',name:'mysql.error_message'},'nfs.version':{category:'nfs',description:'NFS protocol version number.',name:'nfs.version',type:'long'},'nfs.minor_version':{category:'nfs',description:'NFS protocol minor version number.',name:'nfs.minor_version',type:'long'},'nfs.tag':{category:'nfs',description:'NFS v4 COMPOUND operation tag.',name:'nfs.tag'},'nfs.opcode':{category:'nfs',description:'NFS operation name, or main operation name, in case of COMPOUND calls. ',name:'nfs.opcode'},'nfs.status':{category:'nfs',description:'NFS operation reply status.',name:'nfs.status'},'rpc.xid':{category:'rpc',description:'RPC message transaction identifier.',name:'rpc.xid'},'rpc.status':{category:'rpc',description:'RPC message reply status.',name:'rpc.status'},'rpc.auth_flavor':{category:'rpc',description:'RPC authentication flavor.',name:'rpc.auth_flavor'},'rpc.cred.uid':{category:'rpc',description:"RPC caller's user id, in case of auth-unix.",name:'rpc.cred.uid',type:'long'},'rpc.cred.gid':{category:'rpc',description:"RPC caller's group id, in case of auth-unix.",name:'rpc.cred.gid',type:'long'},'rpc.cred.gids':{category:'rpc',description:"RPC caller's secondary group ids, in case of auth-unix.",name:'rpc.cred.gids'},'rpc.cred.stamp':{category:'rpc',description:'Arbitrary ID which the caller machine may generate.',name:'rpc.cred.stamp',type:'long'},'rpc.cred.machinename':{category:'rpc',description:"The name of the caller's machine.",name:'rpc.cred.machinename'},'rpc.call_size':{category:'rpc',description:'RPC call size with argument.',name:'rpc.call_size',type:'alias'},'rpc.reply_size':{category:'rpc',description:'RPC reply size with argument.',name:'rpc.reply_size',type:'alias'},'pgsql.error_code':{category:'pgsql',description:'The PostgreSQL error code.',name:'pgsql.error_code',type:'long'},'pgsql.error_message':{category:'pgsql',description:'The PostgreSQL error message.',name:'pgsql.error_message'},'pgsql.error_severity':{category:'pgsql',description:'The PostgreSQL error severity.',name:'pgsql.error_severity'},'pgsql.num_fields':{category:'pgsql',description:'If the SELECT query if successful, this field is set to the number of fields returned. ',name:'pgsql.num_fields'},'pgsql.num_rows':{category:'pgsql',description:'If the SELECT query if successful, this field is set to the number of rows returned. ',name:'pgsql.num_rows'},'redis.return_value':{category:'redis',description:'The return value of the Redis command in a human readable format. ',name:'redis.return_value'},'redis.error':{category:'redis',description:'If the Redis command has resulted in an error, this field contains the error message returned by the Redis server. ',name:'redis.error'},'thrift.params':{category:'thrift',description:'The RPC method call parameters in a human readable format. If the IDL files are available, the parameters use names whenever possible. Otherwise, the IDs from the message are used. ',name:'thrift.params'},'thrift.service':{category:'thrift',description:'The name of the Thrift-RPC service as defined in the IDL files. ',name:'thrift.service'},'thrift.return_value':{category:'thrift',description:'The value returned by the Thrift-RPC call. This is encoded in a human readable format. ',name:'thrift.return_value'},'thrift.exceptions':{category:'thrift',description:'If the call resulted in exceptions, this field contains the exceptions in a human readable format. ',name:'thrift.exceptions'},'tls.client.x509.version':{category:'tls',description:'Version of x509 format.',example:3,name:'tls.client.x509.version',type:'keyword'},'tls.client.x509.version_number':{category:'tls',description:'Version of x509 format.',example:3,name:'tls.client.x509.version_number',type:'keyword'},'tls.client.x509.serial_number':{category:'tls',description:'Unique serial number issued by the certificate authority. For consistency, if this value is alphanumeric, it should be formatted without colons and uppercase characters. ',example:'55FBB9C7DEBF09809D12CCAA',name:'tls.client.x509.serial_number',type:'keyword'},'tls.client.x509.issuer.distinguished_name':{category:'tls',description:'Distinguished name (DN) of issuing certificate authority.',example:'C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert SHA2 High Assurance Server CA',name:'tls.client.x509.issuer.distinguished_name',type:'keyword'},'tls.client.x509.issuer.common_name':{category:'tls',description:'List of common name (CN) of issuing certificate authority.',example:'DigiCert SHA2 High Assurance Server CA',name:'tls.client.x509.issuer.common_name',type:'keyword'},'tls.client.x509.issuer.organizational_unit':{category:'tls',description:'List of organizational units (OU) of issuing certificate authority.',example:'www.digicert.com',name:'tls.client.x509.issuer.organizational_unit',type:'keyword'},'tls.client.x509.issuer.organization':{category:'tls',description:'List of organizations (O) of issuing certificate authority.',example:'DigiCert Inc',name:'tls.client.x509.issuer.organization',type:'keyword'},'tls.client.x509.issuer.locality':{category:'tls',description:'List of locality names (L)',example:'Mountain View',name:'tls.client.x509.issuer.locality',type:'keyword'},'tls.client.x509.issuer.province':{category:'tls',description:'Province or region within country.',name:'tls.client.x509.issuer.province',type:'keyword'},'tls.client.x509.issuer.state_or_province':{category:'tls',description:'List of state or province names (ST, S, or P)',example:'California',name:'tls.client.x509.issuer.state_or_province',type:'keyword'},'tls.client.x509.issuer.country':{category:'tls',description:'List of country (C) codes',example:'US',name:'tls.client.x509.issuer.country',type:'keyword'},'tls.client.x509.signature_algorithm':{category:'tls',description:'Identifier for certificate signature algorithm. Recommend using names found in Go Lang Crypto library (See https://github.com/golang/go/blob/go1.14/src/crypto/x509/x509.go#L337-L353).',example:'SHA256-RSA',name:'tls.client.x509.signature_algorithm',type:'keyword'},'tls.client.x509.not_before':{category:'tls',description:'Time at which the certificate is first considered valid.',example:'"2019-08-16T01:40:25.000Z"',name:'tls.client.x509.not_before',type:'date'},'tls.client.x509.not_after':{category:'tls',description:'Time at which the certificate is no longer considered valid.',example:'"2020-07-16T03:15:39.000Z"',name:'tls.client.x509.not_after',type:'date'},'tls.client.x509.subject.distinguished_name':{category:'tls',description:'Distinguished name (DN) of the certificate subject entity.',example:'C=US, ST=California, L=San Francisco, O=Fastly, Inc., CN=r2.shared.global.fastly.net',name:'tls.client.x509.subject.distinguished_name',type:'keyword'},'tls.client.x509.subject.common_name':{category:'tls',description:'List of common names (CN) of subject.',example:'r2.shared.global.fastly.net',name:'tls.client.x509.subject.common_name',type:'keyword'},'tls.client.x509.subject.organizational_unit':{category:'tls',description:'List of organizational units (OU) of subject.',name:'tls.client.x509.subject.organizational_unit',type:'keyword'},'tls.client.x509.subject.organization':{category:'tls',description:'List of organizations (O) of subject.',example:'Fastly, Inc.',name:'tls.client.x509.subject.organization',type:'keyword'},'tls.client.x509.subject.locality':{category:'tls',description:'List of locality names (L)',example:'San Francisco',name:'tls.client.x509.subject.locality',type:'keyword'},'tls.client.x509.subject.province':{category:'tls',description:'Province or region within country.',name:'tls.client.x509.subject.province',type:'keyword'},'tls.client.x509.subject.state_or_province':{category:'tls',description:'List of state or province names (ST, S, or P)',example:'California',name:'tls.client.x509.subject.state_or_province',type:'keyword'},'tls.client.x509.subject.country':{category:'tls',description:'List of country (C) code',example:'US',name:'tls.client.x509.subject.country',type:'keyword'},'tls.client.x509.public_key_algorithm':{category:'tls',description:'Algorithm used to generate the public key.',example:'RSA',name:'tls.client.x509.public_key_algorithm',type:'keyword'},'tls.client.x509.public_key_size':{category:'tls',description:'The size of the public key space in bits.',example:2048,name:'tls.client.x509.public_key_size',type:'long'},'tls.client.x509.alternative_names':{category:'tls',description:'List of subject alternative names (SAN). Name types vary by certificate authority and certificate type but commonly contain IP addresses, DNS names (and wildcards), and email addresses.',example:'*.elastic.co',name:'tls.client.x509.alternative_names',type:'keyword'},'tls.server.x509.version':{category:'tls',description:'Version of x509 format.',example:3,name:'tls.server.x509.version',type:'keyword'},'tls.server.x509.version_number':{category:'tls',description:'Version of x509 format.',example:3,name:'tls.server.x509.version_number',type:'keyword'},'tls.server.x509.serial_number':{category:'tls',description:'Unique serial number issued by the certificate authority. For consistency, if this value is alphanumeric, it should be formatted without colons and uppercase characters. ',example:'55FBB9C7DEBF09809D12CCAA',name:'tls.server.x509.serial_number',type:'keyword'},'tls.server.x509.issuer.distinguished_name':{category:'tls',description:'Distinguished name (DN) of issuing certificate authority.',example:'C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert SHA2 High Assurance Server CA',name:'tls.server.x509.issuer.distinguished_name',type:'keyword'},'tls.server.x509.issuer.common_name':{category:'tls',description:'List of common name (CN) of issuing certificate authority.',example:'DigiCert SHA2 High Assurance Server CA',name:'tls.server.x509.issuer.common_name',type:'keyword'},'tls.server.x509.issuer.organizational_unit':{category:'tls',description:'List of organizational units (OU) of issuing certificate authority.',example:'www.digicert.com',name:'tls.server.x509.issuer.organizational_unit',type:'keyword'},'tls.server.x509.issuer.organization':{category:'tls',description:'List of organizations (O) of issuing certificate authority.',example:'DigiCert Inc',name:'tls.server.x509.issuer.organization',type:'keyword'},'tls.server.x509.issuer.locality':{category:'tls',description:'List of locality names (L)',example:'Mountain View',name:'tls.server.x509.issuer.locality',type:'keyword'},'tls.server.x509.issuer.province':{category:'tls',description:'Province or region within country.',name:'tls.server.x509.issuer.province',type:'keyword'},'tls.server.x509.issuer.state_or_province':{category:'tls',description:'List of state or province names (ST, S, or P)',example:'California',name:'tls.server.x509.issuer.state_or_province',type:'keyword'},'tls.server.x509.issuer.country':{category:'tls',description:'List of country (C) codes',example:'US',name:'tls.server.x509.issuer.country',type:'keyword'},'tls.server.x509.signature_algorithm':{category:'tls',description:'Identifier for certificate signature algorithm. Recommend using names found in Go Lang Crypto library (See https://github.com/golang/go/blob/go1.14/src/crypto/x509/x509.go#L337-L353).',example:'SHA256-RSA',name:'tls.server.x509.signature_algorithm',type:'keyword'},'tls.server.x509.not_before':{category:'tls',description:'Time at which the certificate is first considered valid.',example:'"2019-08-16T01:40:25.000Z"',name:'tls.server.x509.not_before',type:'date'},'tls.server.x509.not_after':{category:'tls',description:'Time at which the certificate is no longer considered valid.',example:'"2020-07-16T03:15:39.000Z"',name:'tls.server.x509.not_after',type:'date'},'tls.server.x509.subject.distinguished_name':{category:'tls',description:'Distinguished name (DN) of the certificate subject entity.',example:'C=US, ST=California, L=San Francisco, O=Fastly, Inc., CN=r2.shared.global.fastly.net',name:'tls.server.x509.subject.distinguished_name',type:'keyword'},'tls.server.x509.subject.common_name':{category:'tls',description:'List of common names (CN) of subject.',example:'r2.shared.global.fastly.net',name:'tls.server.x509.subject.common_name',type:'keyword'},'tls.server.x509.subject.organizational_unit':{category:'tls',description:'List of organizational units (OU) of subject.',name:'tls.server.x509.subject.organizational_unit',type:'keyword'},'tls.server.x509.subject.organization':{category:'tls',description:'List of organizations (O) of subject.',example:'Fastly, Inc.',name:'tls.server.x509.subject.organization',type:'keyword'},'tls.server.x509.subject.locality':{category:'tls',description:'List of locality names (L)',example:'San Francisco',name:'tls.server.x509.subject.locality',type:'keyword'},'tls.server.x509.subject.province':{category:'tls',description:'Province or region within country.',name:'tls.server.x509.subject.province',type:'keyword'},'tls.server.x509.subject.state_or_province':{category:'tls',description:'List of state or province names (ST, S, or P)',example:'California',name:'tls.server.x509.subject.state_or_province',type:'keyword'},'tls.server.x509.subject.country':{category:'tls',description:'List of country (C) code',example:'US',name:'tls.server.x509.subject.country',type:'keyword'},'tls.server.x509.public_key_algorithm':{category:'tls',description:'Algorithm used to generate the public key.',example:'RSA',name:'tls.server.x509.public_key_algorithm',type:'keyword'},'tls.server.x509.public_key_size':{category:'tls',description:'The size of the public key space in bits.',example:2048,name:'tls.server.x509.public_key_size',type:'long'},'tls.server.x509.alternative_names':{category:'tls',description:'List of subject alternative names (SAN). Name types vary by certificate authority and certificate type but commonly contain IP addresses, DNS names (and wildcards), and email addresses.',example:'*.elastic.co',name:'tls.server.x509.alternative_names',type:'keyword'},'tls.detailed.version':{category:'tls',description:'The version of the TLS protocol used. ',example:'TLS 1.3',name:'tls.detailed.version',type:'keyword'},'tls.detailed.resumption_method':{category:'tls',description:'If the session has been resumed, the underlying method used. One of "id" for TLS session ID or "ticket" for TLS ticket extension. ',name:'tls.detailed.resumption_method',type:'keyword'},'tls.detailed.client_certificate_requested':{category:'tls',description:'Whether the server has requested the client to authenticate itself using a client certificate. ',name:'tls.detailed.client_certificate_requested',type:'boolean'},'tls.detailed.client_hello.version':{category:'tls',description:'The version of the TLS protocol by which the client wishes to communicate during this session. ',name:'tls.detailed.client_hello.version',type:'keyword'},'tls.detailed.client_hello.session_id':{category:'tls',description:'Unique number to identify the session for the corresponding connection with the client. ',name:'tls.detailed.client_hello.session_id',type:'keyword'},'tls.detailed.client_hello.supported_compression_methods':{category:'tls',description:'The list of compression methods the client supports. See https://www.iana.org/assignments/comp-meth-ids/comp-meth-ids.xhtml ',name:'tls.detailed.client_hello.supported_compression_methods',type:'keyword'},'tls.detailed.client_hello.extensions.server_name_indication':{category:'tls',description:'List of hostnames',name:'tls.detailed.client_hello.extensions.server_name_indication',type:'keyword'},'tls.detailed.client_hello.extensions.application_layer_protocol_negotiation':{category:'tls',description:'List of application-layer protocols the client is willing to use. ',name:'tls.detailed.client_hello.extensions.application_layer_protocol_negotiation',type:'keyword'},'tls.detailed.client_hello.extensions.session_ticket':{category:'tls',description:'Length of the session ticket, if provided, or an empty string to advertise support for tickets. ',name:'tls.detailed.client_hello.extensions.session_ticket',type:'keyword'},'tls.detailed.client_hello.extensions.supported_versions':{category:'tls',description:'List of TLS versions that the client is willing to use. ',name:'tls.detailed.client_hello.extensions.supported_versions',type:'keyword'},'tls.detailed.client_hello.extensions.supported_groups':{category:'tls',description:'List of Elliptic Curve Cryptography (ECC) curve groups supported by the client. ',name:'tls.detailed.client_hello.extensions.supported_groups',type:'keyword'},'tls.detailed.client_hello.extensions.signature_algorithms':{category:'tls',description:'List of signature algorithms that may be use in digital signatures. ',name:'tls.detailed.client_hello.extensions.signature_algorithms',type:'keyword'},'tls.detailed.client_hello.extensions.ec_points_formats':{category:'tls',description:'List of Elliptic Curve (EC) point formats. Indicates the set of point formats that the client can parse. ',name:'tls.detailed.client_hello.extensions.ec_points_formats',type:'keyword'},'tls.detailed.client_hello.extensions._unparsed_':{category:'tls',description:'List of extensions that were left unparsed by Packetbeat. ',name:'tls.detailed.client_hello.extensions._unparsed_',type:'keyword'},'tls.detailed.server_hello.version':{category:'tls',description:'The version of the TLS protocol that is used for this session. It is the highest version supported by the server not exceeding the version requested in the client hello. ',name:'tls.detailed.server_hello.version',type:'keyword'},'tls.detailed.server_hello.selected_compression_method':{category:'tls',description:'The compression method selected by the server from the list provided in the client hello. ',name:'tls.detailed.server_hello.selected_compression_method',type:'keyword'},'tls.detailed.server_hello.session_id':{category:'tls',description:'Unique number to identify the session for the corresponding connection with the client. ',name:'tls.detailed.server_hello.session_id',type:'keyword'},'tls.detailed.server_hello.extensions.application_layer_protocol_negotiation':{category:'tls',description:'Negotiated application layer protocol',name:'tls.detailed.server_hello.extensions.application_layer_protocol_negotiation',type:'keyword'},'tls.detailed.server_hello.extensions.session_ticket':{category:'tls',description:'Used to announce that a session ticket will be provided by the server. Always an empty string. ',name:'tls.detailed.server_hello.extensions.session_ticket',type:'keyword'},'tls.detailed.server_hello.extensions.supported_versions':{category:'tls',description:'Negotiated TLS version to be used. ',name:'tls.detailed.server_hello.extensions.supported_versions',type:'keyword'},'tls.detailed.server_hello.extensions.ec_points_formats':{category:'tls',description:'List of Elliptic Curve (EC) point formats. Indicates the set of point formats that the server can parse. ',name:'tls.detailed.server_hello.extensions.ec_points_formats',type:'keyword'},'tls.detailed.server_hello.extensions._unparsed_':{category:'tls',description:'List of extensions that were left unparsed by Packetbeat. ',name:'tls.detailed.server_hello.extensions._unparsed_',type:'keyword'},'tls.detailed.client_certificate.version':{category:'tls',description:'X509 format version.',name:'tls.detailed.client_certificate.version',type:'long'},'tls.detailed.client_certificate.version_number':{category:'tls',description:'Version of x509 format.',example:3,name:'tls.detailed.client_certificate.version_number',type:'keyword'},'tls.detailed.client_certificate.serial_number':{category:'tls',description:"The certificate's serial number.",name:'tls.detailed.client_certificate.serial_number',type:'keyword'},'tls.detailed.client_certificate.not_before':{category:'tls',description:'Date before which the certificate is not valid.',name:'tls.detailed.client_certificate.not_before',type:'date'},'tls.detailed.client_certificate.not_after':{category:'tls',description:'Date after which the certificate expires.',name:'tls.detailed.client_certificate.not_after',type:'date'},'tls.detailed.client_certificate.public_key_algorithm':{category:'tls',description:"The algorithm used for this certificate's public key. One of RSA, DSA or ECDSA. ",name:'tls.detailed.client_certificate.public_key_algorithm',type:'keyword'},'tls.detailed.client_certificate.public_key_size':{category:'tls',description:'Size of the public key.',name:'tls.detailed.client_certificate.public_key_size',type:'long'},'tls.detailed.client_certificate.signature_algorithm':{category:'tls',description:"The algorithm used for the certificate's signature. ",name:'tls.detailed.client_certificate.signature_algorithm',type:'keyword'},'tls.detailed.client_certificate.alternative_names':{category:'tls',description:'Subject Alternative Names for this certificate.',name:'tls.detailed.client_certificate.alternative_names',type:'keyword'},'tls.detailed.client_certificate.subject.country':{category:'tls',description:'Country code.',name:'tls.detailed.client_certificate.subject.country',type:'keyword'},'tls.detailed.client_certificate.subject.organization':{category:'tls',description:'Organization name.',name:'tls.detailed.client_certificate.subject.organization',type:'keyword'},'tls.detailed.client_certificate.subject.organizational_unit':{category:'tls',description:'Unit within organization.',name:'tls.detailed.client_certificate.subject.organizational_unit',type:'keyword'},'tls.detailed.client_certificate.subject.province':{category:'tls',description:'Province or region within country.',name:'tls.detailed.client_certificate.subject.province',type:'keyword'},'tls.detailed.client_certificate.subject.common_name':{category:'tls',description:'Name or host name identified by the certificate.',name:'tls.detailed.client_certificate.subject.common_name',type:'keyword'},'tls.detailed.client_certificate.subject.locality':{category:'tls',description:'Locality.',name:'tls.detailed.client_certificate.subject.locality',type:'keyword'},'tls.detailed.client_certificate.subject.distinguished_name':{category:'tls',description:'Distinguished name (DN) of the certificate subject entity.',example:'C=US, ST=California, L=San Francisco, O=Fastly, Inc., CN=r2.shared.global.fastly.net',name:'tls.detailed.client_certificate.subject.distinguished_name',type:'keyword'},'tls.detailed.client_certificate.issuer.country':{category:'tls',description:'Country code.',name:'tls.detailed.client_certificate.issuer.country',type:'keyword'},'tls.detailed.client_certificate.issuer.organization':{category:'tls',description:'Organization name.',name:'tls.detailed.client_certificate.issuer.organization',type:'keyword'},'tls.detailed.client_certificate.issuer.organizational_unit':{category:'tls',description:'Unit within organization.',name:'tls.detailed.client_certificate.issuer.organizational_unit',type:'keyword'},'tls.detailed.client_certificate.issuer.province':{category:'tls',description:'Province or region within country.',name:'tls.detailed.client_certificate.issuer.province',type:'keyword'},'tls.detailed.client_certificate.issuer.common_name':{category:'tls',description:'Name or host name identified by the certificate.',name:'tls.detailed.client_certificate.issuer.common_name',type:'keyword'},'tls.detailed.client_certificate.issuer.locality':{category:'tls',description:'Locality.',name:'tls.detailed.client_certificate.issuer.locality',type:'keyword'},'tls.detailed.client_certificate.issuer.distinguished_name':{category:'tls',description:'Distinguished name (DN) of the certificate issuer entity.',example:'C=US, ST=California, L=San Francisco, O=Fastly, Inc., CN=r2.shared.global.fastly.net',name:'tls.detailed.client_certificate.issuer.distinguished_name',type:'keyword'},'tls.detailed.server_certificate.version':{category:'tls',description:'X509 format version.',name:'tls.detailed.server_certificate.version',type:'long'},'tls.detailed.server_certificate.version_number':{category:'tls',description:'Version of x509 format.',example:3,name:'tls.detailed.server_certificate.version_number',type:'keyword'},'tls.detailed.server_certificate.serial_number':{category:'tls',description:"The certificate's serial number.",name:'tls.detailed.server_certificate.serial_number',type:'keyword'},'tls.detailed.server_certificate.not_before':{category:'tls',description:'Date before which the certificate is not valid.',name:'tls.detailed.server_certificate.not_before',type:'date'},'tls.detailed.server_certificate.not_after':{category:'tls',description:'Date after which the certificate expires.',name:'tls.detailed.server_certificate.not_after',type:'date'},'tls.detailed.server_certificate.public_key_algorithm':{category:'tls',description:"The algorithm used for this certificate's public key. One of RSA, DSA or ECDSA. ",name:'tls.detailed.server_certificate.public_key_algorithm',type:'keyword'},'tls.detailed.server_certificate.public_key_size':{category:'tls',description:'Size of the public key.',name:'tls.detailed.server_certificate.public_key_size',type:'long'},'tls.detailed.server_certificate.signature_algorithm':{category:'tls',description:"The algorithm used for the certificate's signature. ",name:'tls.detailed.server_certificate.signature_algorithm',type:'keyword'},'tls.detailed.server_certificate.alternative_names':{category:'tls',description:'Subject Alternative Names for this certificate.',name:'tls.detailed.server_certificate.alternative_names',type:'keyword'},'tls.detailed.server_certificate.subject.country':{category:'tls',description:'Country code.',name:'tls.detailed.server_certificate.subject.country',type:'keyword'},'tls.detailed.server_certificate.subject.organization':{category:'tls',description:'Organization name.',name:'tls.detailed.server_certificate.subject.organization',type:'keyword'},'tls.detailed.server_certificate.subject.organizational_unit':{category:'tls',description:'Unit within organization.',name:'tls.detailed.server_certificate.subject.organizational_unit',type:'keyword'},'tls.detailed.server_certificate.subject.province':{category:'tls',description:'Province or region within country.',name:'tls.detailed.server_certificate.subject.province',type:'keyword'},'tls.detailed.server_certificate.subject.state_or_province':{category:'tls',description:'Province or region within country.',name:'tls.detailed.server_certificate.subject.state_or_province',type:'keyword'},'tls.detailed.server_certificate.subject.common_name':{category:'tls',description:'Name or host name identified by the certificate.',name:'tls.detailed.server_certificate.subject.common_name',type:'keyword'},'tls.detailed.server_certificate.subject.locality':{category:'tls',description:'Locality.',name:'tls.detailed.server_certificate.subject.locality',type:'keyword'},'tls.detailed.server_certificate.subject.distinguished_name':{category:'tls',description:'Distinguished name (DN) of the certificate subject entity.',example:'C=US, ST=California, L=San Francisco, O=Fastly, Inc., CN=r2.shared.global.fastly.net',name:'tls.detailed.server_certificate.subject.distinguished_name',type:'keyword'},'tls.detailed.server_certificate.issuer.country':{category:'tls',description:'Country code.',name:'tls.detailed.server_certificate.issuer.country',type:'keyword'},'tls.detailed.server_certificate.issuer.organization':{category:'tls',description:'Organization name.',name:'tls.detailed.server_certificate.issuer.organization',type:'keyword'},'tls.detailed.server_certificate.issuer.organizational_unit':{category:'tls',description:'Unit within organization.',name:'tls.detailed.server_certificate.issuer.organizational_unit',type:'keyword'},'tls.detailed.server_certificate.issuer.province':{category:'tls',description:'Province or region within country.',name:'tls.detailed.server_certificate.issuer.province',type:'keyword'},'tls.detailed.server_certificate.issuer.state_or_province':{category:'tls',description:'Province or region within country.',name:'tls.detailed.server_certificate.issuer.state_or_province',type:'keyword'},'tls.detailed.server_certificate.issuer.common_name':{category:'tls',description:'Name or host name identified by the certificate.',name:'tls.detailed.server_certificate.issuer.common_name',type:'keyword'},'tls.detailed.server_certificate.issuer.locality':{category:'tls',description:'Locality.',name:'tls.detailed.server_certificate.issuer.locality',type:'keyword'},'tls.detailed.server_certificate.issuer.distinguished_name':{category:'tls',description:'Distinguished name (DN) of the certificate issuer entity.',example:'C=US, ST=California, L=San Francisco, O=Fastly, Inc., CN=r2.shared.global.fastly.net',name:'tls.detailed.server_certificate.issuer.distinguished_name',type:'keyword'},'tls.detailed.server_certificate_chain':{category:'tls',description:'Chain of trust for the server certificate.',name:'tls.detailed.server_certificate_chain',type:'array'},'tls.detailed.client_certificate_chain':{category:'tls',description:'Chain of trust for the client certificate.',name:'tls.detailed.client_certificate_chain',type:'array'},'tls.detailed.alert_types':{category:'tls',description:'An array containing the TLS alert type for every alert received. ',name:'tls.detailed.alert_types',type:'keyword'},'tls.handshake_completed':{category:'tls',name:'tls.handshake_completed',type:'alias'},'tls.client_hello.supported_ciphers':{category:'tls',name:'tls.client_hello.supported_ciphers',type:'alias'},'tls.server_hello.selected_cipher':{category:'tls',name:'tls.server_hello.selected_cipher',type:'alias'},'tls.fingerprints.ja3':{category:'tls',name:'tls.fingerprints.ja3',type:'alias'},'tls.resumption_method':{category:'tls',name:'tls.resumption_method',type:'alias'},'tls.client_certificate_requested':{category:'tls',name:'tls.client_certificate_requested',type:'alias'},'tls.client_hello.version':{category:'tls',name:'tls.client_hello.version',type:'alias'},'tls.client_hello.session_id':{category:'tls',name:'tls.client_hello.session_id',type:'alias'},'tls.client_hello.supported_compression_methods':{category:'tls',name:'tls.client_hello.supported_compression_methods',type:'alias'},'tls.client_hello.extensions.server_name_indication':{category:'tls',name:'tls.client_hello.extensions.server_name_indication',type:'alias'},'tls.client_hello.extensions.application_layer_protocol_negotiation':{category:'tls',name:'tls.client_hello.extensions.application_layer_protocol_negotiation',type:'alias'},'tls.client_hello.extensions.session_ticket':{category:'tls',name:'tls.client_hello.extensions.session_ticket',type:'alias'},'tls.client_hello.extensions.supported_versions':{category:'tls',name:'tls.client_hello.extensions.supported_versions',type:'alias'},'tls.client_hello.extensions.supported_groups':{category:'tls',name:'tls.client_hello.extensions.supported_groups',type:'alias'},'tls.client_hello.extensions.signature_algorithms':{category:'tls',name:'tls.client_hello.extensions.signature_algorithms',type:'alias'},'tls.client_hello.extensions.ec_points_formats':{category:'tls',name:'tls.client_hello.extensions.ec_points_formats',type:'alias'},'tls.client_hello.extensions._unparsed_':{category:'tls',name:'tls.client_hello.extensions._unparsed_',type:'alias'},'tls.server_hello.version':{category:'tls',name:'tls.server_hello.version',type:'alias'},'tls.server_hello.selected_compression_method':{category:'tls',name:'tls.server_hello.selected_compression_method',type:'alias'},'tls.server_hello.session_id':{category:'tls',name:'tls.server_hello.session_id',type:'alias'},'tls.server_hello.extensions.application_layer_protocol_negotiation':{category:'tls',name:'tls.server_hello.extensions.application_layer_protocol_negotiation',type:'alias'},'tls.server_hello.extensions.session_ticket':{category:'tls',name:'tls.server_hello.extensions.session_ticket',type:'alias'},'tls.server_hello.extensions.supported_versions':{category:'tls',name:'tls.server_hello.extensions.supported_versions',type:'alias'},'tls.server_hello.extensions.ec_points_formats':{category:'tls',name:'tls.server_hello.extensions.ec_points_formats',type:'alias'},'tls.server_hello.extensions._unparsed_':{category:'tls',name:'tls.server_hello.extensions._unparsed_',type:'alias'},'tls.client_certificate.version':{category:'tls',name:'tls.client_certificate.version',type:'alias'},'tls.client_certificate.serial_number':{category:'tls',name:'tls.client_certificate.serial_number',type:'alias'},'tls.client_certificate.not_before':{category:'tls',name:'tls.client_certificate.not_before',type:'alias'},'tls.client_certificate.not_after':{category:'tls',name:'tls.client_certificate.not_after',type:'alias'},'tls.client_certificate.public_key_algorithm':{category:'tls',name:'tls.client_certificate.public_key_algorithm',type:'alias'},'tls.client_certificate.public_key_size':{category:'tls',name:'tls.client_certificate.public_key_size',type:'alias'},'tls.client_certificate.signature_algorithm':{category:'tls',name:'tls.client_certificate.signature_algorithm',type:'alias'},'tls.client_certificate.alternative_names':{category:'tls',name:'tls.client_certificate.alternative_names',type:'alias'},'tls.client_certificate.subject.country':{category:'tls',name:'tls.client_certificate.subject.country',type:'alias'},'tls.client_certificate.subject.organization':{category:'tls',name:'tls.client_certificate.subject.organization',type:'alias'},'tls.client_certificate.subject.organizational_unit':{category:'tls',name:'tls.client_certificate.subject.organizational_unit',type:'alias'},'tls.client_certificate.subject.province':{category:'tls',name:'tls.client_certificate.subject.province',type:'alias'},'tls.client_certificate.subject.common_name':{category:'tls',name:'tls.client_certificate.subject.common_name',type:'alias'},'tls.client_certificate.subject.locality':{category:'tls',name:'tls.client_certificate.subject.locality',type:'alias'},'tls.client_certificate.issuer.country':{category:'tls',name:'tls.client_certificate.issuer.country',type:'alias'},'tls.client_certificate.issuer.organization':{category:'tls',name:'tls.client_certificate.issuer.organization',type:'alias'},'tls.client_certificate.issuer.organizational_unit':{category:'tls',name:'tls.client_certificate.issuer.organizational_unit',type:'alias'},'tls.client_certificate.issuer.province':{category:'tls',name:'tls.client_certificate.issuer.province',type:'alias'},'tls.client_certificate.issuer.common_name':{category:'tls',name:'tls.client_certificate.issuer.common_name',type:'alias'},'tls.client_certificate.issuer.locality':{category:'tls',name:'tls.client_certificate.issuer.locality',type:'alias'},'tls.server_certificate.version':{category:'tls',name:'tls.server_certificate.version',type:'alias'},'tls.server_certificate.serial_number':{category:'tls',name:'tls.server_certificate.serial_number',type:'alias'},'tls.server_certificate.not_before':{category:'tls',name:'tls.server_certificate.not_before',type:'alias'},'tls.server_certificate.not_after':{category:'tls',name:'tls.server_certificate.not_after',type:'alias'},'tls.server_certificate.public_key_algorithm':{category:'tls',name:'tls.server_certificate.public_key_algorithm',type:'alias'},'tls.server_certificate.public_key_size':{category:'tls',name:'tls.server_certificate.public_key_size',type:'alias'},'tls.server_certificate.signature_algorithm':{category:'tls',name:'tls.server_certificate.signature_algorithm',type:'alias'},'tls.server_certificate.alternative_names':{category:'tls',name:'tls.server_certificate.alternative_names',type:'alias'},'tls.server_certificate.subject.country':{category:'tls',name:'tls.server_certificate.subject.country',type:'alias'},'tls.server_certificate.subject.organization':{category:'tls',name:'tls.server_certificate.subject.organization',type:'alias'},'tls.server_certificate.subject.organizational_unit':{category:'tls',name:'tls.server_certificate.subject.organizational_unit',type:'alias'},'tls.server_certificate.subject.province':{category:'tls',name:'tls.server_certificate.subject.province',type:'alias'},'tls.server_certificate.subject.common_name':{category:'tls',name:'tls.server_certificate.subject.common_name',type:'alias'},'tls.server_certificate.subject.locality':{category:'tls',name:'tls.server_certificate.subject.locality',type:'alias'},'tls.server_certificate.issuer.country':{category:'tls',name:'tls.server_certificate.issuer.country',type:'alias'},'tls.server_certificate.issuer.organization':{category:'tls',name:'tls.server_certificate.issuer.organization',type:'alias'},'tls.server_certificate.issuer.organizational_unit':{category:'tls',name:'tls.server_certificate.issuer.organizational_unit',type:'alias'},'tls.server_certificate.issuer.province':{category:'tls',name:'tls.server_certificate.issuer.province',type:'alias'},'tls.server_certificate.issuer.common_name':{category:'tls',name:'tls.server_certificate.issuer.common_name',type:'alias'},'tls.server_certificate.issuer.locality':{category:'tls',name:'tls.server_certificate.issuer.locality',type:'alias'},'tls.alert_types':{category:'tls',name:'tls.alert_types',type:'alias'},'winlog.api':{category:'winlog',description:'The event log API type used to read the record. The possible values are "wineventlog" for the Windows Event Log API or "eventlogging" for the Event Logging API. The Event Logging API was designed for Windows Server 2003 or Windows 2000 operating systems. In Windows Vista, the event logging infrastructure was redesigned. On Windows Vista or later operating systems, the Windows Event Log API is used. Winlogbeat automatically detects which API to use for reading event logs. ',name:'winlog.api'},'winlog.activity_id':{category:'winlog',description:'A globally unique identifier that identifies the current activity. The events that are published with this identifier are part of the same activity. ',name:'winlog.activity_id',type:'keyword'},'winlog.computer_name':{category:'winlog',description:'The name of the computer that generated the record. When using Windows event forwarding, this name can differ from `agent.hostname`. ',name:'winlog.computer_name',type:'keyword'},'winlog.event_data':{category:'winlog',description:'The event-specific data. This field is mutually exclusive with `user_data`. If you are capturing event data on versions prior to Windows Vista, the parameters in `event_data` are named `param1`, `param2`, and so on, because event log parameters are unnamed in earlier versions of Windows. ',name:'winlog.event_data',type:'object'},'winlog.event_data.AuthenticationPackageName':{category:'winlog',name:'winlog.event_data.AuthenticationPackageName',type:'keyword'},'winlog.event_data.Binary':{category:'winlog',name:'winlog.event_data.Binary',type:'keyword'},'winlog.event_data.BitlockerUserInputTime':{category:'winlog',name:'winlog.event_data.BitlockerUserInputTime',type:'keyword'},'winlog.event_data.BootMode':{category:'winlog',name:'winlog.event_data.BootMode',type:'keyword'},'winlog.event_data.BootType':{category:'winlog',name:'winlog.event_data.BootType',type:'keyword'},'winlog.event_data.BuildVersion':{category:'winlog',name:'winlog.event_data.BuildVersion',type:'keyword'},'winlog.event_data.Company':{category:'winlog',name:'winlog.event_data.Company',type:'keyword'},'winlog.event_data.CorruptionActionState':{category:'winlog',name:'winlog.event_data.CorruptionActionState',type:'keyword'},'winlog.event_data.CreationUtcTime':{category:'winlog',name:'winlog.event_data.CreationUtcTime',type:'keyword'},'winlog.event_data.Description':{category:'winlog',name:'winlog.event_data.Description',type:'keyword'},'winlog.event_data.Detail':{category:'winlog',name:'winlog.event_data.Detail',type:'keyword'},'winlog.event_data.DeviceName':{category:'winlog',name:'winlog.event_data.DeviceName',type:'keyword'},'winlog.event_data.DeviceNameLength':{category:'winlog',name:'winlog.event_data.DeviceNameLength',type:'keyword'},'winlog.event_data.DeviceTime':{category:'winlog',name:'winlog.event_data.DeviceTime',type:'keyword'},'winlog.event_data.DeviceVersionMajor':{category:'winlog',name:'winlog.event_data.DeviceVersionMajor',type:'keyword'},'winlog.event_data.DeviceVersionMinor':{category:'winlog',name:'winlog.event_data.DeviceVersionMinor',type:'keyword'},'winlog.event_data.DriveName':{category:'winlog',name:'winlog.event_data.DriveName',type:'keyword'},'winlog.event_data.DriverName':{category:'winlog',name:'winlog.event_data.DriverName',type:'keyword'},'winlog.event_data.DriverNameLength':{category:'winlog',name:'winlog.event_data.DriverNameLength',type:'keyword'},'winlog.event_data.DwordVal':{category:'winlog',name:'winlog.event_data.DwordVal',type:'keyword'},'winlog.event_data.EntryCount':{category:'winlog',name:'winlog.event_data.EntryCount',type:'keyword'},'winlog.event_data.ExtraInfo':{category:'winlog',name:'winlog.event_data.ExtraInfo',type:'keyword'},'winlog.event_data.FailureName':{category:'winlog',name:'winlog.event_data.FailureName',type:'keyword'},'winlog.event_data.FailureNameLength':{category:'winlog',name:'winlog.event_data.FailureNameLength',type:'keyword'},'winlog.event_data.FileVersion':{category:'winlog',name:'winlog.event_data.FileVersion',type:'keyword'},'winlog.event_data.FinalStatus':{category:'winlog',name:'winlog.event_data.FinalStatus',type:'keyword'},'winlog.event_data.Group':{category:'winlog',name:'winlog.event_data.Group',type:'keyword'},'winlog.event_data.IdleImplementation':{category:'winlog',name:'winlog.event_data.IdleImplementation',type:'keyword'},'winlog.event_data.IdleStateCount':{category:'winlog',name:'winlog.event_data.IdleStateCount',type:'keyword'},'winlog.event_data.ImpersonationLevel':{category:'winlog',name:'winlog.event_data.ImpersonationLevel',type:'keyword'},'winlog.event_data.IntegrityLevel':{category:'winlog',name:'winlog.event_data.IntegrityLevel',type:'keyword'},'winlog.event_data.IpAddress':{category:'winlog',name:'winlog.event_data.IpAddress',type:'keyword'},'winlog.event_data.IpPort':{category:'winlog',name:'winlog.event_data.IpPort',type:'keyword'},'winlog.event_data.KeyLength':{category:'winlog',name:'winlog.event_data.KeyLength',type:'keyword'},'winlog.event_data.LastBootGood':{category:'winlog',name:'winlog.event_data.LastBootGood',type:'keyword'},'winlog.event_data.LastShutdownGood':{category:'winlog',name:'winlog.event_data.LastShutdownGood',type:'keyword'},'winlog.event_data.LmPackageName':{category:'winlog',name:'winlog.event_data.LmPackageName',type:'keyword'},'winlog.event_data.LogonGuid':{category:'winlog',name:'winlog.event_data.LogonGuid',type:'keyword'},'winlog.event_data.LogonId':{category:'winlog',name:'winlog.event_data.LogonId',type:'keyword'},'winlog.event_data.LogonProcessName':{category:'winlog',name:'winlog.event_data.LogonProcessName',type:'keyword'},'winlog.event_data.LogonType':{category:'winlog',name:'winlog.event_data.LogonType',type:'keyword'},'winlog.event_data.MajorVersion':{category:'winlog',name:'winlog.event_data.MajorVersion',type:'keyword'},'winlog.event_data.MaximumPerformancePercent':{category:'winlog',name:'winlog.event_data.MaximumPerformancePercent',type:'keyword'},'winlog.event_data.MemberName':{category:'winlog',name:'winlog.event_data.MemberName',type:'keyword'},'winlog.event_data.MemberSid':{category:'winlog',name:'winlog.event_data.MemberSid',type:'keyword'},'winlog.event_data.MinimumPerformancePercent':{category:'winlog',name:'winlog.event_data.MinimumPerformancePercent',type:'keyword'},'winlog.event_data.MinimumThrottlePercent':{category:'winlog',name:'winlog.event_data.MinimumThrottlePercent',type:'keyword'},'winlog.event_data.MinorVersion':{category:'winlog',name:'winlog.event_data.MinorVersion',type:'keyword'},'winlog.event_data.NewProcessId':{category:'winlog',name:'winlog.event_data.NewProcessId',type:'keyword'},'winlog.event_data.NewProcessName':{category:'winlog',name:'winlog.event_data.NewProcessName',type:'keyword'},'winlog.event_data.NewSchemeGuid':{category:'winlog',name:'winlog.event_data.NewSchemeGuid',type:'keyword'},'winlog.event_data.NewTime':{category:'winlog',name:'winlog.event_data.NewTime',type:'keyword'},'winlog.event_data.NominalFrequency':{category:'winlog',name:'winlog.event_data.NominalFrequency',type:'keyword'},'winlog.event_data.Number':{category:'winlog',name:'winlog.event_data.Number',type:'keyword'},'winlog.event_data.OldSchemeGuid':{category:'winlog',name:'winlog.event_data.OldSchemeGuid',type:'keyword'},'winlog.event_data.OldTime':{category:'winlog',name:'winlog.event_data.OldTime',type:'keyword'},'winlog.event_data.OriginalFileName':{category:'winlog',name:'winlog.event_data.OriginalFileName',type:'keyword'},'winlog.event_data.Path':{category:'winlog',name:'winlog.event_data.Path',type:'keyword'},'winlog.event_data.PerformanceImplementation':{category:'winlog',name:'winlog.event_data.PerformanceImplementation',type:'keyword'},'winlog.event_data.PreviousCreationUtcTime':{category:'winlog',name:'winlog.event_data.PreviousCreationUtcTime',type:'keyword'},'winlog.event_data.PreviousTime':{category:'winlog',name:'winlog.event_data.PreviousTime',type:'keyword'},'winlog.event_data.PrivilegeList':{category:'winlog',name:'winlog.event_data.PrivilegeList',type:'keyword'},'winlog.event_data.ProcessId':{category:'winlog',name:'winlog.event_data.ProcessId',type:'keyword'},'winlog.event_data.ProcessName':{category:'winlog',name:'winlog.event_data.ProcessName',type:'keyword'},'winlog.event_data.ProcessPath':{category:'winlog',name:'winlog.event_data.ProcessPath',type:'keyword'},'winlog.event_data.ProcessPid':{category:'winlog',name:'winlog.event_data.ProcessPid',type:'keyword'},'winlog.event_data.Product':{category:'winlog',name:'winlog.event_data.Product',type:'keyword'},'winlog.event_data.PuaCount':{category:'winlog',name:'winlog.event_data.PuaCount',type:'keyword'},'winlog.event_data.PuaPolicyId':{category:'winlog',name:'winlog.event_data.PuaPolicyId',type:'keyword'},'winlog.event_data.QfeVersion':{category:'winlog',name:'winlog.event_data.QfeVersion',type:'keyword'},'winlog.event_data.Reason':{category:'winlog',name:'winlog.event_data.Reason',type:'keyword'},'winlog.event_data.SchemaVersion':{category:'winlog',name:'winlog.event_data.SchemaVersion',type:'keyword'},'winlog.event_data.ScriptBlockText':{category:'winlog',name:'winlog.event_data.ScriptBlockText',type:'keyword'},'winlog.event_data.ServiceName':{category:'winlog',name:'winlog.event_data.ServiceName',type:'keyword'},'winlog.event_data.ServiceVersion':{category:'winlog',name:'winlog.event_data.ServiceVersion',type:'keyword'},'winlog.event_data.ShutdownActionType':{category:'winlog',name:'winlog.event_data.ShutdownActionType',type:'keyword'},'winlog.event_data.ShutdownEventCode':{category:'winlog',name:'winlog.event_data.ShutdownEventCode',type:'keyword'},'winlog.event_data.ShutdownReason':{category:'winlog',name:'winlog.event_data.ShutdownReason',type:'keyword'},'winlog.event_data.Signature':{category:'winlog',name:'winlog.event_data.Signature',type:'keyword'},'winlog.event_data.SignatureStatus':{category:'winlog',name:'winlog.event_data.SignatureStatus',type:'keyword'},'winlog.event_data.Signed':{category:'winlog',name:'winlog.event_data.Signed',type:'keyword'},'winlog.event_data.StartTime':{category:'winlog',name:'winlog.event_data.StartTime',type:'keyword'},'winlog.event_data.State':{category:'winlog',name:'winlog.event_data.State',type:'keyword'},'winlog.event_data.Status':{category:'winlog',name:'winlog.event_data.Status',type:'keyword'},'winlog.event_data.StopTime':{category:'winlog',name:'winlog.event_data.StopTime',type:'keyword'},'winlog.event_data.SubjectDomainName':{category:'winlog',name:'winlog.event_data.SubjectDomainName',type:'keyword'},'winlog.event_data.SubjectLogonId':{category:'winlog',name:'winlog.event_data.SubjectLogonId',type:'keyword'},'winlog.event_data.SubjectUserName':{category:'winlog',name:'winlog.event_data.SubjectUserName',type:'keyword'},'winlog.event_data.SubjectUserSid':{category:'winlog',name:'winlog.event_data.SubjectUserSid',type:'keyword'},'winlog.event_data.TSId':{category:'winlog',name:'winlog.event_data.TSId',type:'keyword'},'winlog.event_data.TargetDomainName':{category:'winlog',name:'winlog.event_data.TargetDomainName',type:'keyword'},'winlog.event_data.TargetInfo':{category:'winlog',name:'winlog.event_data.TargetInfo',type:'keyword'},'winlog.event_data.TargetLogonGuid':{category:'winlog',name:'winlog.event_data.TargetLogonGuid',type:'keyword'},'winlog.event_data.TargetLogonId':{category:'winlog',name:'winlog.event_data.TargetLogonId',type:'keyword'},'winlog.event_data.TargetServerName':{category:'winlog',name:'winlog.event_data.TargetServerName',type:'keyword'},'winlog.event_data.TargetUserName':{category:'winlog',name:'winlog.event_data.TargetUserName',type:'keyword'},'winlog.event_data.TargetUserSid':{category:'winlog',name:'winlog.event_data.TargetUserSid',type:'keyword'},'winlog.event_data.TerminalSessionId':{category:'winlog',name:'winlog.event_data.TerminalSessionId',type:'keyword'},'winlog.event_data.TokenElevationType':{category:'winlog',name:'winlog.event_data.TokenElevationType',type:'keyword'},'winlog.event_data.TransmittedServices':{category:'winlog',name:'winlog.event_data.TransmittedServices',type:'keyword'},'winlog.event_data.UserSid':{category:'winlog',name:'winlog.event_data.UserSid',type:'keyword'},'winlog.event_data.Version':{category:'winlog',name:'winlog.event_data.Version',type:'keyword'},'winlog.event_data.Workstation':{category:'winlog',name:'winlog.event_data.Workstation',type:'keyword'},'winlog.event_data.param1':{category:'winlog',name:'winlog.event_data.param1',type:'keyword'},'winlog.event_data.param2':{category:'winlog',name:'winlog.event_data.param2',type:'keyword'},'winlog.event_data.param3':{category:'winlog',name:'winlog.event_data.param3',type:'keyword'},'winlog.event_data.param4':{category:'winlog',name:'winlog.event_data.param4',type:'keyword'},'winlog.event_data.param5':{category:'winlog',name:'winlog.event_data.param5',type:'keyword'},'winlog.event_data.param6':{category:'winlog',name:'winlog.event_data.param6',type:'keyword'},'winlog.event_data.param7':{category:'winlog',name:'winlog.event_data.param7',type:'keyword'},'winlog.event_data.param8':{category:'winlog',name:'winlog.event_data.param8',type:'keyword'},'winlog.event_id':{category:'winlog',description:'The event identifier. The value is specific to the source of the event. ',name:'winlog.event_id',type:'keyword'},'winlog.keywords':{category:'winlog',description:'The keywords are used to classify an event. ',name:'winlog.keywords',type:'keyword'},'winlog.channel':{category:'winlog',description:'The name of the channel from which this record was read. This value is one of the names from the `event_logs` collection in the configuration. ',name:'winlog.channel',type:'keyword'},'winlog.record_id':{category:'winlog',description:'The record ID of the event log record. The first record written to an event log is record number 1, and other records are numbered sequentially. If the record number reaches the maximum value (2^32^ for the Event Logging API and 2^64^ for the Windows Event Log API), the next record number will be 0. ',name:'winlog.record_id',type:'keyword'},'winlog.related_activity_id':{category:'winlog',description:'A globally unique identifier that identifies the activity to which control was transferred to. The related events would then have this identifier as their `activity_id` identifier. ',name:'winlog.related_activity_id',type:'keyword'},'winlog.opcode':{category:'winlog',description:'The opcode defined in the event. Task and opcode are typically used to identify the location in the application from where the event was logged. ',name:'winlog.opcode',type:'keyword'},'winlog.provider_guid':{category:'winlog',description:'A globally unique identifier that identifies the provider that logged the event. ',name:'winlog.provider_guid',type:'keyword'},'winlog.process.pid':{category:'winlog',description:'The process_id of the Client Server Runtime Process. ',name:'winlog.process.pid',type:'long'},'winlog.provider_name':{category:'winlog',description:'The source of the event log record (the application or service that logged the record). ',name:'winlog.provider_name',type:'keyword'},'winlog.task':{category:'winlog',description:'The task defined in the event. Task and opcode are typically used to identify the location in the application from where the event was logged. The category used by the Event Logging API (on pre Windows Vista operating systems) is written to this field. ',name:'winlog.task',type:'keyword'},'winlog.process.thread.id':{category:'winlog',name:'winlog.process.thread.id',type:'long'},'winlog.user_data':{category:'winlog',description:'The event specific data. This field is mutually exclusive with `event_data`. ',name:'winlog.user_data',type:'object'},'winlog.user.identifier':{category:'winlog',description:'The Windows security identifier (SID) of the account associated with this event. If Winlogbeat cannot resolve the SID to a name, then the `user.name`, `user.domain`, and `user.type` fields will be omitted from the event. If you discover Winlogbeat not resolving SIDs, review the log for clues as to what the problem may be. ',example:'S-1-5-21-3541430928-2051711210-1391384369-1001',name:'winlog.user.identifier',type:'keyword'},'winlog.user.name':{category:'winlog',description:'Name of the user associated with this event. ',name:'winlog.user.name',type:'keyword'},'winlog.user.domain':{category:'winlog',description:'The domain that the account associated with this event is a member of. ',name:'winlog.user.domain',type:'keyword'},'winlog.user.type':{category:'winlog',description:'The type of account associated with this event. ',name:'winlog.user.type',type:'keyword'},'winlog.version':{category:'winlog',description:"The version number of the event's definition.",name:'winlog.version',type:'long'},activity_id:{category:'base',name:'activity_id',type:'alias'},computer_name:{category:'base',name:'computer_name',type:'alias'},event_id:{category:'base',name:'event_id',type:'alias'},keywords:{category:'base',name:'keywords',type:'alias'},log_name:{category:'base',name:'log_name',type:'alias'},message_error:{category:'base',name:'message_error',type:'alias'},record_number:{category:'base',name:'record_number',type:'alias'},related_activity_id:{category:'base',name:'related_activity_id',type:'alias'},opcode:{category:'base',name:'opcode',type:'alias'},provider_guid:{category:'base',name:'provider_guid',type:'alias'},process_id:{category:'base',name:'process_id',type:'alias'},source_name:{category:'base',name:'source_name',type:'alias'},task:{category:'base',name:'task',type:'alias'},thread_id:{category:'base',name:'thread_id',type:'alias'},'user.identifier':{category:'user',name:'user.identifier',type:'alias'},'user.type':{category:'user',name:'user.type',type:'alias'},version:{category:'base',name:'version',type:'alias'},xml:{category:'base',name:'xml',type:'alias'},'powershell.id':{category:'powershell',description:'Shell Id.',example:'Microsoft Powershell',name:'powershell.id',type:'keyword'},'powershell.pipeline_id':{category:'powershell',description:'Pipeline id.',example:'1',name:'powershell.pipeline_id',type:'keyword'},'powershell.runspace_id':{category:'powershell',description:'Runspace id.',example:'4fa9074d-45ab-4e53-9195-e91981ac2bbb',name:'powershell.runspace_id',type:'keyword'},'powershell.sequence':{category:'powershell',description:'Sequence number of the powershell execution.',example:1,name:'powershell.sequence',type:'long'},'powershell.total':{category:'powershell',description:'Total number of messages in the sequence.',example:10,name:'powershell.total',type:'long'},'powershell.command.path':{category:'powershell',description:'Path of the executed command.',example:'C:\\Windows\\system32\\cmd.exe',name:'powershell.command.path',type:'keyword'},'powershell.command.name':{category:'powershell',description:'Name of the executed command.',example:'cmd.exe',name:'powershell.command.name',type:'keyword'},'powershell.command.type':{category:'powershell',description:'Type of the executed command.',example:'Application',name:'powershell.command.type',type:'keyword'},'powershell.command.value':{category:'powershell',description:'The invoked command.',example:'Import-LocalizedData  LocalizedData -filename ArchiveResources',name:'powershell.command.value',type:'text'},'powershell.command.invocation_details':{category:'powershell',description:'An array of objects containing detailed information of the executed command. ',name:'powershell.command.invocation_details',type:'array'},'powershell.command.invocation_details.type':{category:'powershell',description:'The type of detail.',example:'CommandInvocation',name:'powershell.command.invocation_details.type',type:'keyword'},'powershell.command.invocation_details.related_command':{category:'powershell',description:'The command to which the detail is related to.',example:'Add-Type',name:'powershell.command.invocation_details.related_command',type:'keyword'},'powershell.command.invocation_details.name':{category:'powershell',description:'Only used for ParameterBinding detail type. Indicates the parameter name. ',example:'AssemblyName',name:'powershell.command.invocation_details.name',type:'keyword'},'powershell.command.invocation_details.value':{category:'powershell',description:'The value of the detail. The meaning of it will depend on the detail type. ',example:'System.IO.Compression.FileSystem',name:'powershell.command.invocation_details.value',type:'text'},'powershell.connected_user.domain':{category:'powershell',description:'User domain.',example:'VAGRANT',name:'powershell.connected_user.domain',type:'keyword'},'powershell.connected_user.name':{category:'powershell',description:'User name.',example:'vagrant',name:'powershell.connected_user.name',type:'keyword'},'powershell.engine.version':{category:'powershell',description:'Version of the PowerShell engine version used to execute the command.',example:'5.1.17763.1007',name:'powershell.engine.version',type:'keyword'},'powershell.engine.previous_state':{category:'powershell',description:'Previous state of the PowerShell engine. ',example:'Available',name:'powershell.engine.previous_state',type:'keyword'},'powershell.engine.new_state':{category:'powershell',description:'New state of the PowerShell engine. ',example:'Stopped',name:'powershell.engine.new_state',type:'keyword'},'powershell.file.script_block_id':{category:'powershell',description:'Id of the executed script block.',example:'50d2dbda-7361-4926-a94d-d9eadfdb43fa',name:'powershell.file.script_block_id',type:'keyword'},'powershell.file.script_block_text':{category:'powershell',description:'Text of the executed script block. ',example:'.\\a_script.ps1',name:'powershell.file.script_block_text',type:'text'},'powershell.process.executable_version':{category:'powershell',description:'Version of the engine hosting process executable.',example:'5.1.17763.1007',name:'powershell.process.executable_version',type:'keyword'},'powershell.provider.new_state':{category:'powershell',description:'New state of the PowerShell provider. ',example:'Active',name:'powershell.provider.new_state',type:'keyword'},'powershell.provider.name':{category:'powershell',description:'Provider name. ',example:'Variable',name:'powershell.provider.name',type:'keyword'},'winlog.logon.type':{category:'winlog',description:'Logon type name. This is the descriptive version of the `winlog.event_data.LogonType` ordinal. This is an enrichment added by the Security module. ',example:'RemoteInteractive',name:'winlog.logon.type',type:'keyword'},'winlog.logon.id':{category:'winlog',description:'Logon ID that can be used to associate this logon with other events related to the same logon session. ',name:'winlog.logon.id',type:'keyword'},'winlog.logon.failure.reason':{category:'winlog',description:'The reason the logon failed. ',name:'winlog.logon.failure.reason',type:'keyword'},'winlog.logon.failure.status':{category:'winlog',description:'The reason the logon failed. This is textual description based on the value of the hexadecimal `Status` field. ',name:'winlog.logon.failure.status',type:'keyword'},'winlog.logon.failure.sub_status':{category:'winlog',description:'Additional information about the logon failure. This is a textual description based on the value of the hexidecimal `SubStatus` field. ',name:'winlog.logon.failure.sub_status',type:'keyword'},'sysmon.dns.status':{category:'sysmon',description:'Windows status code returned for the DNS query.',name:'sysmon.dns.status',type:'keyword'},'sysmon.file.archived':{category:'sysmon',description:'Indicates if the deleted file was archived.',name:'sysmon.file.archived',type:'boolean'},'sysmon.file.is_executable':{category:'sysmon',description:'Indicates if the deleted file was an executable.',name:'sysmon.file.is_executable',type:'boolean'}};exports.fieldsBeat=fieldsBeat;