"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createThunk = createThunk;
function createThunk(type, fn) {
  var actionCreator = function actionCreator() {
    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return function (dispatch, getState) {
      return fn.apply(undefined, [{ dispatch: dispatch, getState: getState, type: type }].concat(args));
    };
  };

  // mimic redux-actions' .toString() functionality
  actionCreator.toString = function () {
    return type.toString();
  };

  return actionCreator;
}