(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
  typeof define === 'function' && define.amd ? define(['exports'], factory) :
  (global = global || self, factory(global.ReactQueryCreateWebStoragePersistorExperimental = {}));
}(this, (function (exports) { 'use strict';

  function noop() {
    return undefined;
  }

  function createWebStoragePersistor(_ref) {
    var storage = _ref.storage,
        _ref$key = _ref.key,
        key = _ref$key === void 0 ? "REACT_QUERY_OFFLINE_CACHE" : _ref$key,
        _ref$throttleTime = _ref.throttleTime,
        throttleTime = _ref$throttleTime === void 0 ? 1000 : _ref$throttleTime;

    if (typeof storage !== 'undefined') {
      return {
        persistClient: throttle(function (persistedClient) {
          storage.setItem(key, JSON.stringify(persistedClient));
        }, throttleTime),
        restoreClient: function restoreClient() {
          var cacheString = storage.getItem(key);

          if (!cacheString) {
            return;
          }

          return JSON.parse(cacheString);
        },
        removeClient: function removeClient() {
          storage.removeItem(key);
        }
      };
    }

    return {
      persistClient: noop,
      restoreClient: noop,
      removeClient: noop
    };
  }

  function throttle(func, wait) {
    if (wait === void 0) {
      wait = 100;
    }

    var timer = null;
    var params;
    return function () {
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      params = args;

      if (timer === null) {
        timer = setTimeout(function () {
          func.apply(void 0, params);
          timer = null;
        }, wait);
      }
    };
  }

  exports.createWebStoragePersistor = createWebStoragePersistor;

  Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=createWebStoragePersistor-experimental.development.js.map
