"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataPath = exports.getConfigPath = exports.getConfigDirectory = exports.config = void 0;

var _path = require("path");

var _fs = require("fs");

var _configSchema = require("@kbn/config-schema");

var _repo_root = require("../repo_root");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const isString = v => typeof v === 'string';

const CONFIG_PATHS = [process.env.KBN_PATH_CONF && (0, _path.join)(process.env.KBN_PATH_CONF, 'kibana.yml'), process.env.KIBANA_PATH_CONF && (0, _path.join)(process.env.KIBANA_PATH_CONF, 'kibana.yml'), // deprecated
process.env.CONFIG_PATH, // deprecated
(0, _path.join)(_repo_root.REPO_ROOT, 'config/kibana.yml'), '/etc/kibana/kibana.yml'].filter(isString);
const CONFIG_DIRECTORIES = [process.env.KBN_PATH_CONF, process.env.KIBANA_PATH_CONF, // deprecated
(0, _path.join)(_repo_root.REPO_ROOT, 'config'), '/etc/kibana'].filter(isString);
const DATA_PATHS = [process.env.DATA_PATH, // deprecated
(0, _path.join)(_repo_root.REPO_ROOT, 'data'), '/var/lib/kibana'].filter(isString);

function findFile(paths) {
  const availablePath = paths.find(configPath => {
    try {
      (0, _fs.accessSync)(configPath, _fs.constants.R_OK);
      return true;
    } catch (e) {// Check the next path
    }
  });
  return availablePath || paths[0];
}
/**
 * Get the path of kibana.yml
 * @internal
 */


const getConfigPath = () => findFile(CONFIG_PATHS);
/**
 * Get the directory containing configuration files
 * @internal
 */


exports.getConfigPath = getConfigPath;

const getConfigDirectory = () => findFile(CONFIG_DIRECTORIES);
/**
 * Get the directory containing runtime data
 * @internal
 */


exports.getConfigDirectory = getConfigDirectory;

const getDataPath = () => findFile(DATA_PATHS);

exports.getDataPath = getDataPath;
const config = {
  path: 'path',
  schema: _configSchema.schema.object({
    data: _configSchema.schema.string({
      defaultValue: () => getDataPath()
    })
  })
};
exports.config = config;