/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React, { createContext, useContext } from 'react';
import { jsx as ___EmotionJSX } from "@emotion/react";
var RouterContext = /*#__PURE__*/createContext(undefined);
export var RouterContextProvider = function RouterContextProvider(_ref) {
  var router = _ref.router,
      children = _ref.children;
  return ___EmotionJSX(RouterContext.Provider, {
    value: router
  }, children);
};
export function useRouter() {
  var router = useContext(RouterContext);

  if (!router) {
    throw new Error('Router not found in context');
  }

  return router;
}