"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useParams = useParams;

var _reactRouterDom = require("react-router-dom");

var _use_router = require("./use_router");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function useParams(...args) {
  const router = (0, _use_router.useRouter)();
  const location = (0, _reactRouterDom.useLocation)();
  let optional = false;
  const last = args[args.length - 1];

  if (typeof last === 'boolean') {
    optional = last;
    args.pop();
  }

  const paths = args;
  const getParamsArgs = [...paths, location, optional];
  return router.getParams(...getParamsArgs);
}