"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RouteRenderer = RouteRenderer;

var _react = _interopRequireDefault(require("react"));

var _use_current_route = require("./use_current_route");

var _use_match_routes = require("./use_match_routes");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function RouteRenderer() {
  const matches = (0, _use_match_routes.useMatchRoutes)();
  return matches.concat().reverse().reduce((prev, match) => {
    const {
      element
    } = match.route;
    return /*#__PURE__*/_react.default.createElement(_use_current_route.CurrentRouteContextProvider, {
      match: match,
      element: prev
    }, element);
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null));
}