import _objectSpread from "@babel/runtime/helpers/objectSpread2";
import _asyncToGenerator from "@babel/runtime/helpers/asyncToGenerator";
import _regeneratorRuntime from "@babel/runtime/regenerator";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { chain, fromEither, map, tryCatch } from 'fp-ts/lib/TaskEither';
import { flow } from 'fp-ts/lib/function';
import { pipe } from 'fp-ts/lib/pipeable';
import { validateEither } from '@kbn/securitysolution-io-ts-utils';
import { acknowledgeSchema, deleteListSchema, exportListItemQuerySchema, findListSchema, foundListSchema, importListItemQuerySchema, importListItemSchema, listItemIndexExistSchema, listSchema } from '@kbn/securitysolution-io-ts-list-types';
import { LIST_INDEX, LIST_ITEM_URL, LIST_PRIVILEGES_URL, LIST_URL } from '@kbn/securitysolution-list-constants';
import { toError, toPromise } from '../fp_utils';

var findLists = /*#__PURE__*/function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(_ref) {
    var http, cursor, page, per_page, signal;
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            http = _ref.http, cursor = _ref.cursor, page = _ref.page, per_page = _ref.per_page, signal = _ref.signal;
            return _context.abrupt("return", http.fetch("".concat(LIST_URL, "/_find"), {
              method: 'GET',
              query: {
                cursor: cursor,
                page: page,
                per_page: per_page
              },
              signal: signal
            }));

          case 2:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));

  return function findLists(_x) {
    return _ref2.apply(this, arguments);
  };
}();

var findListsWithValidation = /*#__PURE__*/function () {
  var _ref4 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(_ref3) {
    var cursor, http, pageIndex, pageSize, signal;
    return _regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            cursor = _ref3.cursor, http = _ref3.http, pageIndex = _ref3.pageIndex, pageSize = _ref3.pageSize, signal = _ref3.signal;
            return _context2.abrupt("return", pipe({
              cursor: cursor != null ? cursor.toString() : undefined,
              page: pageIndex != null ? pageIndex.toString() : undefined,
              per_page: pageSize != null ? pageSize.toString() : undefined
            }, function (payload) {
              return fromEither(validateEither(findListSchema, payload));
            }, chain(function (payload) {
              return tryCatch(function () {
                return findLists(_objectSpread({
                  http: http,
                  signal: signal
                }, payload));
              }, toError);
            }), chain(function (response) {
              return fromEither(validateEither(foundListSchema, response));
            }), flow(toPromise)));

          case 2:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2);
  }));

  return function findListsWithValidation(_x2) {
    return _ref4.apply(this, arguments);
  };
}();

export { findListsWithValidation as findLists };

var importList = /*#__PURE__*/function () {
  var _ref6 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3(_ref5) {
    var file, http, list_id, type, signal, formData;
    return _regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            file = _ref5.file, http = _ref5.http, list_id = _ref5.list_id, type = _ref5.type, signal = _ref5.signal;
            formData = new FormData();
            formData.append('file', file);
            return _context3.abrupt("return", http.fetch("".concat(LIST_ITEM_URL, "/_import"), {
              body: formData,
              headers: {
                'Content-Type': undefined
              },
              method: 'POST',
              query: {
                list_id: list_id,
                type: type
              },
              signal: signal
            }));

          case 4:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3);
  }));

  return function importList(_x3) {
    return _ref6.apply(this, arguments);
  };
}();

var importListWithValidation = /*#__PURE__*/function () {
  var _ref8 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee4(_ref7) {
    var file, http, listId, type, signal;
    return _regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            file = _ref7.file, http = _ref7.http, listId = _ref7.listId, type = _ref7.type, signal = _ref7.signal;
            return _context4.abrupt("return", pipe({
              list_id: listId,
              type: type
            }, function (query) {
              return fromEither(validateEither(importListItemQuerySchema, query));
            }, chain(function (query) {
              return pipe(fromEither(validateEither(importListItemSchema, {
                file: file
              })), map(function (body) {
                return _objectSpread(_objectSpread({}, body), query);
              }));
            }), chain(function (payload) {
              return tryCatch(function () {
                return importList(_objectSpread({
                  http: http,
                  signal: signal
                }, payload));
              }, toError);
            }), chain(function (response) {
              return fromEither(validateEither(listSchema, response));
            }), toPromise));

          case 2:
          case "end":
            return _context4.stop();
        }
      }
    }, _callee4);
  }));

  return function importListWithValidation(_x4) {
    return _ref8.apply(this, arguments);
  };
}();

export { importListWithValidation as importList };

var deleteList = /*#__PURE__*/function () {
  var _ref10 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee5(_ref9) {
    var _ref9$deleteReference, deleteReferences, http, id, _ref9$ignoreReference, ignoreReferences, signal;

    return _regeneratorRuntime.wrap(function _callee5$(_context5) {
      while (1) {
        switch (_context5.prev = _context5.next) {
          case 0:
            _ref9$deleteReference = _ref9.deleteReferences, deleteReferences = _ref9$deleteReference === void 0 ? false : _ref9$deleteReference, http = _ref9.http, id = _ref9.id, _ref9$ignoreReference = _ref9.ignoreReferences, ignoreReferences = _ref9$ignoreReference === void 0 ? false : _ref9$ignoreReference, signal = _ref9.signal;
            return _context5.abrupt("return", http.fetch(LIST_URL, {
              method: 'DELETE',
              query: {
                deleteReferences: deleteReferences,
                id: id,
                ignoreReferences: ignoreReferences
              },
              signal: signal
            }));

          case 2:
          case "end":
            return _context5.stop();
        }
      }
    }, _callee5);
  }));

  return function deleteList(_x5) {
    return _ref10.apply(this, arguments);
  };
}();

var deleteListWithValidation = /*#__PURE__*/function () {
  var _ref12 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee6(_ref11) {
    var deleteReferences, http, id, ignoreReferences, signal;
    return _regeneratorRuntime.wrap(function _callee6$(_context6) {
      while (1) {
        switch (_context6.prev = _context6.next) {
          case 0:
            deleteReferences = _ref11.deleteReferences, http = _ref11.http, id = _ref11.id, ignoreReferences = _ref11.ignoreReferences, signal = _ref11.signal;
            return _context6.abrupt("return", pipe({
              deleteReferences: deleteReferences,
              id: id,
              ignoreReferences: ignoreReferences
            }, function (payload) {
              return fromEither(validateEither(deleteListSchema, payload));
            }, chain(function (payload) {
              return tryCatch(function () {
                return deleteList(_objectSpread({
                  http: http,
                  signal: signal
                }, payload));
              }, toError);
            }), chain(function (response) {
              return fromEither(validateEither(listSchema, response));
            }), flow(toPromise)));

          case 2:
          case "end":
            return _context6.stop();
        }
      }
    }, _callee6);
  }));

  return function deleteListWithValidation(_x6) {
    return _ref12.apply(this, arguments);
  };
}();

export { deleteListWithValidation as deleteList };

var exportList = /*#__PURE__*/function () {
  var _ref14 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee7(_ref13) {
    var http, list_id, signal;
    return _regeneratorRuntime.wrap(function _callee7$(_context7) {
      while (1) {
        switch (_context7.prev = _context7.next) {
          case 0:
            http = _ref13.http, list_id = _ref13.list_id, signal = _ref13.signal;
            return _context7.abrupt("return", http.fetch("".concat(LIST_ITEM_URL, "/_export"), {
              method: 'POST',
              query: {
                list_id: list_id
              },
              signal: signal
            }));

          case 2:
          case "end":
            return _context7.stop();
        }
      }
    }, _callee7);
  }));

  return function exportList(_x7) {
    return _ref14.apply(this, arguments);
  };
}();

var exportListWithValidation = /*#__PURE__*/function () {
  var _ref16 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee8(_ref15) {
    var http, listId, signal;
    return _regeneratorRuntime.wrap(function _callee8$(_context8) {
      while (1) {
        switch (_context8.prev = _context8.next) {
          case 0:
            http = _ref15.http, listId = _ref15.listId, signal = _ref15.signal;
            return _context8.abrupt("return", pipe({
              list_id: listId
            }, function (payload) {
              return fromEither(validateEither(exportListItemQuerySchema, payload));
            }, chain(function (payload) {
              return tryCatch(function () {
                return exportList(_objectSpread({
                  http: http,
                  signal: signal
                }, payload));
              }, toError);
            }), flow(toPromise)));

          case 2:
          case "end":
            return _context8.stop();
        }
      }
    }, _callee8);
  }));

  return function exportListWithValidation(_x8) {
    return _ref16.apply(this, arguments);
  };
}();

export { exportListWithValidation as exportList };

var readListIndex = /*#__PURE__*/function () {
  var _ref18 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee9(_ref17) {
    var http, signal;
    return _regeneratorRuntime.wrap(function _callee9$(_context9) {
      while (1) {
        switch (_context9.prev = _context9.next) {
          case 0:
            http = _ref17.http, signal = _ref17.signal;
            return _context9.abrupt("return", http.fetch(LIST_INDEX, {
              method: 'GET',
              signal: signal
            }));

          case 2:
          case "end":
            return _context9.stop();
        }
      }
    }, _callee9);
  }));

  return function readListIndex(_x9) {
    return _ref18.apply(this, arguments);
  };
}();

var readListIndexWithValidation = /*#__PURE__*/function () {
  var _ref20 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee10(_ref19) {
    var http, signal;
    return _regeneratorRuntime.wrap(function _callee10$(_context10) {
      while (1) {
        switch (_context10.prev = _context10.next) {
          case 0:
            http = _ref19.http, signal = _ref19.signal;
            return _context10.abrupt("return", flow(function () {
              return tryCatch(function () {
                return readListIndex({
                  http: http,
                  signal: signal
                });
              }, toError);
            }, chain(function (response) {
              return fromEither(validateEither(listItemIndexExistSchema, response));
            }), flow(toPromise))());

          case 2:
          case "end":
            return _context10.stop();
        }
      }
    }, _callee10);
  }));

  return function readListIndexWithValidation(_x10) {
    return _ref20.apply(this, arguments);
  };
}();

export { readListIndexWithValidation as readListIndex }; // TODO add types and validation

export var readListPrivileges = /*#__PURE__*/function () {
  var _ref22 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee11(_ref21) {
    var http, signal;
    return _regeneratorRuntime.wrap(function _callee11$(_context11) {
      while (1) {
        switch (_context11.prev = _context11.next) {
          case 0:
            http = _ref21.http, signal = _ref21.signal;
            return _context11.abrupt("return", http.fetch(LIST_PRIVILEGES_URL, {
              method: 'GET',
              signal: signal
            }));

          case 2:
          case "end":
            return _context11.stop();
        }
      }
    }, _callee11);
  }));

  return function readListPrivileges(_x11) {
    return _ref22.apply(this, arguments);
  };
}();

var createListIndex = /*#__PURE__*/function () {
  var _ref24 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee12(_ref23) {
    var http, signal;
    return _regeneratorRuntime.wrap(function _callee12$(_context12) {
      while (1) {
        switch (_context12.prev = _context12.next) {
          case 0:
            http = _ref23.http, signal = _ref23.signal;
            return _context12.abrupt("return", http.fetch(LIST_INDEX, {
              method: 'POST',
              signal: signal
            }));

          case 2:
          case "end":
            return _context12.stop();
        }
      }
    }, _callee12);
  }));

  return function createListIndex(_x12) {
    return _ref24.apply(this, arguments);
  };
}();

var createListIndexWithValidation = /*#__PURE__*/function () {
  var _ref26 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee13(_ref25) {
    var http, signal;
    return _regeneratorRuntime.wrap(function _callee13$(_context13) {
      while (1) {
        switch (_context13.prev = _context13.next) {
          case 0:
            http = _ref25.http, signal = _ref25.signal;
            return _context13.abrupt("return", flow(function () {
              return tryCatch(function () {
                return createListIndex({
                  http: http,
                  signal: signal
                });
              }, toError);
            }, chain(function (response) {
              return fromEither(validateEither(acknowledgeSchema, response));
            }), flow(toPromise))());

          case 2:
          case "end":
            return _context13.stop();
        }
      }
    }, _callee13);
  }));

  return function createListIndexWithValidation(_x13) {
    return _ref26.apply(this, arguments);
  };
}();

export { createListIndexWithValidation as createListIndex };