/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import * as t from 'io-ts';
import { version } from '@kbn/securitysolution-io-ts-types';
import { _versionOrUndefined } from '../../common/underscore_version';
import { namespace_type } from '../../common/namespace_type';
import { metaOrUndefined } from '../../common/meta';
import { name } from '../../common/name';
import { created_at } from '../../common/created_at';
import { created_by } from '../../common/created_by';
import { id } from '../../common/id';
import { tie_breaker_id } from '../../common/tie_breaker_id';
import { immutable } from '../../common/immutable';
import { updated_at } from '../../common/updated_at';
import { updated_by } from '../../common/updated_by';
import { list_id } from '../../common/list_id';
import { description } from '../../common/description';
import { osTypeArray } from '../../common/os_type';
import { exceptionListType } from '../../common/exception_list';
import { tags } from '../../common/tags';
export var exceptionListSchema = t.exact(t.type({
  _version: _versionOrUndefined,
  created_at: created_at,
  created_by: created_by,
  description: description,
  id: id,
  immutable: immutable,
  list_id: list_id,
  meta: metaOrUndefined,
  name: name,
  namespace_type: namespace_type,
  os_types: osTypeArray,
  tags: tags,
  tie_breaker_id: tie_breaker_id,
  type: exceptionListType,
  updated_at: updated_at,
  updated_by: updated_by,
  version: version
}));