import _objectSpread from "@babel/runtime/helpers/objectSpread2";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { FILTERS } from './types';
/** @public */

/**
 *
 * @param indexPatternString
 * @param queryDsl
 * @param disabled
 * @param negate
 * @param alias
 * @param store
 * @returns
 *
 * @public
 */
export function buildCustomFilter(indexPatternString, queryDsl, disabled, negate, alias, store) {
  var meta = {
    index: indexPatternString,
    type: FILTERS.CUSTOM,
    disabled: disabled,
    negate: negate,
    alias: alias
  };

  var filter = _objectSpread(_objectSpread({}, queryDsl), {}, {
    meta: meta
  });

  filter.$state = {
    store: store
  };
  return filter;
}