"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildNodeParams = buildNodeParams;
exports.toElasticsearchQuery = toElasticsearchQuery;

var literal = _interopRequireWildcard(require("../node_types/literal"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function buildNodeParams(fieldName) {
  return {
    arguments: [literal.buildNode(fieldName)]
  };
}

function toElasticsearchQuery(node, indexPattern, config = {}, context = {}) {
  var _indexPattern$fields;

  const {
    arguments: [fieldNameArg]
  } = node;
  const fullFieldNameArg = { ...fieldNameArg,
    value: context !== null && context !== void 0 && context.nested ? `${context.nested.path}.${fieldNameArg.value}` : fieldNameArg.value
  };
  const fieldName = literal.toElasticsearchQuery(fullFieldNameArg);
  const field = indexPattern === null || indexPattern === void 0 ? void 0 : (_indexPattern$fields = indexPattern.fields) === null || _indexPattern$fields === void 0 ? void 0 : _indexPattern$fields.find(fld => fld.name === fieldName);

  if (field !== null && field !== void 0 && field.scripted) {
    throw new Error(`Exists query does not support scripted fields`);
  }

  return {
    exists: {
      field: fieldName
    }
  };
}