"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = reset;

/**
 * Reset search experience to initial state
 *
 */
function reset() {
  var _console;

  // eslint-disable-next-line no-console
  if (this.debug) (_console = console).log.apply(_console, ["Search UI: Action", "reset"].concat(Array.prototype.slice.call(arguments)));

  this._setState(this.startingState);

  if (this.trackUrlState) {
    this.URLManager.pushStateToURL(this.state);
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9hY3Rpb25zL3Jlc2V0LmpzIl0sIm5hbWVzIjpbInJlc2V0IiwiZGVidWciLCJjb25zb2xlIiwibG9nIiwiYXJndW1lbnRzIiwiX3NldFN0YXRlIiwic3RhcnRpbmdTdGF0ZSIsInRyYWNrVXJsU3RhdGUiLCJVUkxNYW5hZ2VyIiwicHVzaFN0YXRlVG9VUkwiLCJzdGF0ZSJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ2UsU0FBU0EsS0FBVCxHQUFpQjtBQUFBOztBQUM5QjtBQUNBLE1BQUksS0FBS0MsS0FBVCxFQUFnQixZQUFBQyxPQUFPLEVBQUNDLEdBQVIsa0JBQVksbUJBQVosRUFBaUMsT0FBakMsb0NBQTZDQyxTQUE3Qzs7QUFFaEIsT0FBS0MsU0FBTCxDQUFlLEtBQUtDLGFBQXBCOztBQUNBLE1BQUksS0FBS0MsYUFBVCxFQUF3QjtBQUN0QixTQUFLQyxVQUFMLENBQWdCQyxjQUFoQixDQUErQixLQUFLQyxLQUFwQztBQUNEO0FBQ0YiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIFJlc2V0IHNlYXJjaCBleHBlcmllbmNlIHRvIGluaXRpYWwgc3RhdGVcbiAqXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIHJlc2V0KCkge1xuICAvLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgbm8tY29uc29sZVxuICBpZiAodGhpcy5kZWJ1ZykgY29uc29sZS5sb2coXCJTZWFyY2ggVUk6IEFjdGlvblwiLCBcInJlc2V0XCIsIC4uLmFyZ3VtZW50cyk7XG5cbiAgdGhpcy5fc2V0U3RhdGUodGhpcy5zdGFydGluZ1N0YXRlKTtcbiAgaWYgKHRoaXMudHJhY2tVcmxTdGF0ZSkge1xuICAgIHRoaXMuVVJMTWFuYWdlci5wdXNoU3RhdGVUb1VSTCh0aGlzLnN0YXRlKTtcbiAgfVxufVxuIl19