"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = clearFilters;

/**
 * Remove all filters
 *
 * Will trigger new search
 *
 * @param except Array[String] field name of any filters that should remain
 */
function clearFilters() {
  var _console;

  var except = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  if (this.debug) // eslint-disable-next-line no-console
    (_console = console).log.apply(_console, ["Search UI: Action", "clearFilters"].concat(Array.prototype.slice.call(arguments)));
  var filters = this.state.filters;
  var updatedFilters = filters.filter(function (filter) {
    var filterField = filter.field;
    return except.includes(filterField);
  });

  this._updateSearchResults({
    current: 1,
    filters: updatedFilters
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9hY3Rpb25zL2NsZWFyRmlsdGVycy5qcyJdLCJuYW1lcyI6WyJjbGVhckZpbHRlcnMiLCJleGNlcHQiLCJkZWJ1ZyIsImNvbnNvbGUiLCJsb2ciLCJhcmd1bWVudHMiLCJmaWx0ZXJzIiwic3RhdGUiLCJ1cGRhdGVkRmlsdGVycyIsImZpbHRlciIsImZpbHRlckZpZWxkIiwiZmllbGQiLCJpbmNsdWRlcyIsIl91cGRhdGVTZWFyY2hSZXN1bHRzIiwiY3VycmVudCJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ2UsU0FBU0EsWUFBVCxHQUFtQztBQUFBOztBQUFBLE1BQWJDLE1BQWEsdUVBQUosRUFBSTtBQUNoRCxNQUFJLEtBQUtDLEtBQVQsRUFDRTtBQUNBLGdCQUFBQyxPQUFPLEVBQUNDLEdBQVIsa0JBQVksbUJBQVosRUFBaUMsY0FBakMsb0NBQW9EQyxTQUFwRDtBQUg4QyxNQUt4Q0MsT0FMd0MsR0FLNUIsS0FBS0MsS0FMdUIsQ0FLeENELE9BTHdDO0FBT2hELE1BQU1FLGNBQWMsR0FBR0YsT0FBTyxDQUFDRyxNQUFSLENBQWUsVUFBQUEsTUFBTSxFQUFJO0FBQzlDLFFBQU1DLFdBQVcsR0FBR0QsTUFBTSxDQUFDRSxLQUEzQjtBQUNBLFdBQU9WLE1BQU0sQ0FBQ1csUUFBUCxDQUFnQkYsV0FBaEIsQ0FBUDtBQUNELEdBSHNCLENBQXZCOztBQUtBLE9BQUtHLG9CQUFMLENBQTBCO0FBQ3hCQyxJQUFBQSxPQUFPLEVBQUUsQ0FEZTtBQUV4QlIsSUFBQUEsT0FBTyxFQUFFRTtBQUZlLEdBQTFCO0FBSUQiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIFJlbW92ZSBhbGwgZmlsdGVyc1xuICpcbiAqIFdpbGwgdHJpZ2dlciBuZXcgc2VhcmNoXG4gKlxuICogQHBhcmFtIGV4Y2VwdCBBcnJheVtTdHJpbmddIGZpZWxkIG5hbWUgb2YgYW55IGZpbHRlcnMgdGhhdCBzaG91bGQgcmVtYWluXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIGNsZWFyRmlsdGVycyhleGNlcHQgPSBbXSkge1xuICBpZiAodGhpcy5kZWJ1ZylcbiAgICAvLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgbm8tY29uc29sZVxuICAgIGNvbnNvbGUubG9nKFwiU2VhcmNoIFVJOiBBY3Rpb25cIiwgXCJjbGVhckZpbHRlcnNcIiwgLi4uYXJndW1lbnRzKTtcblxuICBjb25zdCB7IGZpbHRlcnMgfSA9IHRoaXMuc3RhdGU7XG5cbiAgY29uc3QgdXBkYXRlZEZpbHRlcnMgPSBmaWx0ZXJzLmZpbHRlcihmaWx0ZXIgPT4ge1xuICAgIGNvbnN0IGZpbHRlckZpZWxkID0gZmlsdGVyLmZpZWxkO1xuICAgIHJldHVybiBleGNlcHQuaW5jbHVkZXMoZmlsdGVyRmllbGQpO1xuICB9KTtcblxuICB0aGlzLl91cGRhdGVTZWFyY2hSZXN1bHRzKHtcbiAgICBjdXJyZW50OiAxLFxuICAgIGZpbHRlcnM6IHVwZGF0ZWRGaWx0ZXJzXG4gIH0pO1xufVxuIl19