import queryString from "qs";
import preserveTypesEncoder from "./preserveTypesEncoder";
export default {
  parse: function parse(string) {
    return queryString.parse(string, {
      ignoreQueryPrefix: true,
      decoder: preserveTypesEncoder.decode,
      arrayLimit: 1000
    });
  },
  stringify: function stringify(object) {
    return queryString.stringify(object, {
      encoder: preserveTypesEncoder.encode
    });
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy9xdWVyeVN0cmluZy5qcyJdLCJuYW1lcyI6WyJxdWVyeVN0cmluZyIsInByZXNlcnZlVHlwZXNFbmNvZGVyIiwicGFyc2UiLCJzdHJpbmciLCJpZ25vcmVRdWVyeVByZWZpeCIsImRlY29kZXIiLCJkZWNvZGUiLCJhcnJheUxpbWl0Iiwic3RyaW5naWZ5Iiwib2JqZWN0IiwiZW5jb2RlciIsImVuY29kZSJdLCJtYXBwaW5ncyI6IkFBQUEsT0FBT0EsV0FBUCxNQUF3QixJQUF4QjtBQUNBLE9BQU9DLG9CQUFQLE1BQWlDLHdCQUFqQztBQUVBLGVBQWU7QUFDYkMsRUFBQUEsS0FEYSxpQkFDUEMsTUFETyxFQUNDO0FBQ1osV0FBT0gsV0FBVyxDQUFDRSxLQUFaLENBQWtCQyxNQUFsQixFQUEwQjtBQUMvQkMsTUFBQUEsaUJBQWlCLEVBQUUsSUFEWTtBQUUvQkMsTUFBQUEsT0FBTyxFQUFFSixvQkFBb0IsQ0FBQ0ssTUFGQztBQUcvQkMsTUFBQUEsVUFBVSxFQUFFO0FBSG1CLEtBQTFCLENBQVA7QUFLRCxHQVBZO0FBUWJDLEVBQUFBLFNBUmEscUJBUUhDLE1BUkcsRUFRSztBQUNoQixXQUFPVCxXQUFXLENBQUNRLFNBQVosQ0FBc0JDLE1BQXRCLEVBQThCO0FBQ25DQyxNQUFBQSxPQUFPLEVBQUVULG9CQUFvQixDQUFDVTtBQURLLEtBQTlCLENBQVA7QUFHRDtBQVpZLENBQWYiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgcXVlcnlTdHJpbmcgZnJvbSBcInFzXCI7XG5pbXBvcnQgcHJlc2VydmVUeXBlc0VuY29kZXIgZnJvbSBcIi4vcHJlc2VydmVUeXBlc0VuY29kZXJcIjtcblxuZXhwb3J0IGRlZmF1bHQge1xuICBwYXJzZShzdHJpbmcpIHtcbiAgICByZXR1cm4gcXVlcnlTdHJpbmcucGFyc2Uoc3RyaW5nLCB7XG4gICAgICBpZ25vcmVRdWVyeVByZWZpeDogdHJ1ZSxcbiAgICAgIGRlY29kZXI6IHByZXNlcnZlVHlwZXNFbmNvZGVyLmRlY29kZSxcbiAgICAgIGFycmF5TGltaXQ6IDEwMDBcbiAgICB9KTtcbiAgfSxcbiAgc3RyaW5naWZ5KG9iamVjdCkge1xuICAgIHJldHVybiBxdWVyeVN0cmluZy5zdHJpbmdpZnkob2JqZWN0LCB7XG4gICAgICBlbmNvZGVyOiBwcmVzZXJ2ZVR5cGVzRW5jb2Rlci5lbmNvZGVcbiAgICB9KTtcbiAgfVxufTtcbiJdfQ==