import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import PropTypes from "prop-types";
import React from "react";
import Downshift from "downshift";
import { Result } from "./types";
import { Suggestion } from "./types";
import { appendClassName } from "./view-helpers";
import Autocomplete from "./Autocomplete";
import SearchInput from "./SearchInput";

function SearchBox(props) {
  var className = props.className,
      allAutocompletedItemsCount = props.allAutocompletedItemsCount,
      autocompleteView = props.autocompleteView,
      isFocused = props.isFocused,
      _props$inputProps = props.inputProps,
      inputProps = _props$inputProps === void 0 ? {} : _props$inputProps,
      inputView = props.inputView,
      onChange = props.onChange,
      onSelectAutocomplete = props.onSelectAutocomplete,
      _onSubmit = props.onSubmit,
      useAutocomplete = props.useAutocomplete,
      value = props.value,
      autocompletedResults = props.autocompletedResults,
      autocompletedSuggestions = props.autocompletedSuggestions,
      autocompletedSuggestionsCount = props.autocompletedSuggestionsCount,
      completeSuggestion = props.completeSuggestion,
      notifyAutocompleteSelected = props.notifyAutocompleteSelected,
      rest = _objectWithoutProperties(props, ["className", "allAutocompletedItemsCount", "autocompleteView", "isFocused", "inputProps", "inputView", "onChange", "onSelectAutocomplete", "onSubmit", "useAutocomplete", "value", "autocompletedResults", "autocompletedSuggestions", "autocompletedSuggestionsCount", "completeSuggestion", "notifyAutocompleteSelected"]);

  var focusedClass = isFocused ? "focus" : "";
  var AutocompleteView = autocompleteView || Autocomplete;
  var InputView = inputView || SearchInput;
  return /*#__PURE__*/React.createElement(Downshift, _extends({
    inputValue: value,
    onChange: onSelectAutocomplete,
    onInputValueChange: function onInputValueChange(newValue) {
      // To avoid over dispatching
      if (value === newValue) return;
      onChange(newValue);
    } // Because when a selection is made, we don't really want to change
    // the inputValue. This is supposed to be a "controlled" value, and when
    // this happens we lose control of it.
    ,
    itemToString: function itemToString() {
      return value;
    }
  }, rest), function (downshiftProps) {
    var closeMenu = downshiftProps.closeMenu,
        _getInputProps = downshiftProps.getInputProps,
        isOpen = downshiftProps.isOpen;
    var autocompleteClass = isOpen === true ? " autocomplete" : "";
    return /*#__PURE__*/React.createElement("form", {
      onSubmit: function onSubmit(e) {
        closeMenu();

        _onSubmit(e);
      }
    }, /*#__PURE__*/React.createElement("div", {
      className: appendClassName("sui-search-box", className) + autocompleteClass
    }, /*#__PURE__*/React.createElement(InputView, _extends({}, downshiftProps, {
      getInputProps: function getInputProps(additionalProps) {
        var _ref = additionalProps || {},
            className = _ref.className,
            rest = _objectWithoutProperties(_ref, ["className"]);

        return _getInputProps(_objectSpread(_objectSpread({
          placeholder: "Search"
        }, inputProps), {}, {
          className: appendClassName("sui-search-box__text-input", [inputProps.className, className, focusedClass])
        }, rest));
      },
      getButtonProps: function getButtonProps(additionalProps) {
        var _ref2 = additionalProps || {},
            className = _ref2.className,
            rest = _objectWithoutProperties(_ref2, ["className"]);

        return _objectSpread({
          type: "submit",
          value: "Search",
          className: appendClassName("button sui-search-box__submit", className)
        }, rest);
      },
      getAutocomplete: function getAutocomplete() {
        if (useAutocomplete && isOpen && allAutocompletedItemsCount > 0) {
          return /*#__PURE__*/React.createElement(AutocompleteView, _extends({}, props, downshiftProps));
        } else {
          return null;
        }
      }
    }))));
  });
}

SearchBox.propTypes = {
  // Provided by container
  allAutocompletedItemsCount: PropTypes.number.isRequired,
  autocompletedResults: PropTypes.arrayOf(Result).isRequired,
  autocompletedSuggestions: PropTypes.objectOf(PropTypes.arrayOf(Suggestion)).isRequired,
  autocompletedSuggestionsCount: PropTypes.number.isRequired,
  completeSuggestion: PropTypes.func.isRequired,
  notifyAutocompleteSelected: PropTypes.func.isRequired,
  onChange: PropTypes.func.isRequired,
  onSubmit: PropTypes.func.isRequired,
  value: PropTypes.string.isRequired,
  autocompleteResults: PropTypes.oneOfType([PropTypes.bool, PropTypes.shape({
    titleField: PropTypes.string.isRequired,
    urlField: PropTypes.string.isRequired,
    linkTarget: PropTypes.string,
    sectionTitle: PropTypes.string
  })]),
  autocompleteView: PropTypes.func,
  autocompleteSuggestions: PropTypes.oneOfType([PropTypes.bool, PropTypes.exact({
    sectionTitle: PropTypes.string
  }), PropTypes.objectOf(PropTypes.exact({
    sectionTitle: PropTypes.string
  }))]),
  className: PropTypes.string,
  inputProps: PropTypes.object,
  inputView: PropTypes.func,
  isFocused: PropTypes.bool,
  useAutocomplete: PropTypes.bool,
  // Specific configuration for this view only
  onSelectAutocomplete: PropTypes.func
};
export default SearchBox;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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